	!
	! $Id: gx_test.s 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $
	!
	
	.include "gx.h"
	
	! Registers
	!	%r1	Temporary
	!	%r2	Points to the gx register base

	
	.global	start
	.text
start:
	! open the gx device
        set     GX_BUFFER, %r2          ! %r2points to gx registers

        st      %r0, [%r2+GX_CMD]       ! open display

        ld      [%r2+GX_STATUS], %r1    ! load status word
wait_for_map:
        cmp     %r1, 0
        be      wait_for_map            ! wait until window is mapped
        ld      [%r2+GX_STATUS], %r1    ! load status word

	! draw a black rectangle
	clr	%r3
	st	%r3, [%r2+GX_ARG]
	set	GX_COLOR, %r1
	st	%r1, [%r2+GX_CMD]

	! next, fill a rectangle
	set	100, %r3
	st	%r3, [%r2+GX_FILL_X]
	st	%r3, [%r2+GX_FILL_Y]
	st	%r3, [%r2+GX_FILL_W]
	st	%r3, [%r2+GX_FILL_H]
	set	GX_FILL, %r1
	st	%r1, [%r2+GX_CMD]

	! draw a white rectangle
	set	1, %r3
	st	%r3, [%r2+GX_ARG]
	set	GX_COLOR, %r1
	st	%r1, [%r2+GX_CMD]
	
	set	125, %r3
	st	%r3, [%r2+GX_FILL_X]
	st	%r3, [%r2+GX_FILL_Y]
	set	50, %r3
	st	%r3, [%r2+GX_FILL_W]
	st	%r3, [%r2+GX_FILL_H]
	set	GX_FILL, %r1
	st	%r1, [%r2+GX_CMD]

	! draw some lines
	set	100, %r3
	st	%r3, [%r2+GX_LINE_X1]
	st	%r3, [%r2+GX_LINE_Y1]
	set	200, %r3
	st	%r3, [%r2+GX_LINE_X2]
	st	%r3, [%r2+GX_LINE_Y2]
	set	GX_LINE, %r1
	st	%r1, [%r2+GX_CMD]

	clr	%r3
	st	%r3, [%r2+GX_ARG]
	set	GX_COLOR, %r1
	st	%r1, [%r2+GX_CMD]
	
	set	100, %r3
	st	%r3, [%r2+GX_LINE_X1]
	st	%r3, [%r2+GX_LINE_Y2]
	set	200, %r3
	st	%r3, [%r2+GX_LINE_Y1]
	st	%r3, [%r2+GX_LINE_X2]
	set	GX_LINE, %r1
	st	%r1, [%r2+GX_CMD]

	! now, try to blit the region
	set	100, %r3
	st	%r3, [%r2+GX_BLIT_X1]
	st	%r3, [%r2+GX_BLIT_Y1]
	st	%r3, [%r2+GX_BLIT_W]
	st	%r3, [%r2+GX_BLIT_H]
	set	300, %r3
	st	%r3, [%r2+GX_BLIT_X2]
	st	%r3, [%r2+GX_BLIT_Y2]
	set	GX_BLIT, %r1
	st	%r1, [%r2+GX_CMD]
	
	
	ta	0

