/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED
 = "$Id: isemDev.cpp 1.2 Mon, 11 Nov 1996 14:11:38 -0700 maccabe $";

// -- isemDev.c --------------------------------------------------------------
//
// This module adds a TK style device to the set of devices known to isem.
//
// Ver 1.0 - 30 OCT 94 - A.Maccabe
// 

#include <stdio.h>
#include <stdlib.h>             /* for strtoul */ 
#include <string.h>
#include <tk.h>

#include "config.h"

#include "sizedefs.h"
#include "sys_bus.h"
#include "MMU.h"
#include "TK_dev.h"
#include "IU.h"

#include "globals.h"

int Isem_Dev( ClientData, Tcl_Interp *interp, int argc, char *argv[] ) {
    //
    // isem_device name start_address [ user ]
    //
    // map an isem device into the supervisor (and optionally the user)
    // data page table
    //
    if( !(argc == 3 || (argc == 4 && strcmp(argv[3],"user")==0)) ) {
	sprintf( interp->result, "isem_dev:  invalid number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    int start_addr;
    start_addr = strtoul( argv[2], 0, 0 );
    
    TK_dev *device = new TK_dev( *sbus, argv[1], start_addr );
    sbus->install( device );

    if( argc==4 && strcmp( "user", argv[3] ) == 0 ) {
	mmu->write( 2, (start_addr/4096)*4, 0xf, start_addr/4096 );
    }
    mmu->write( 3, (start_addr/4096)*4, 0xf, start_addr/4096 );

    return TCL_OK;
}
