/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: sav_rest.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

//-----------------------------------------------------
// save and restore Instructions -
//    see p173 of SPARC Architecture Manual, Version 8
//-----------------------------------------------------

#include "sizedefs.h"
#include "Instruct.h"
#include "RegBlock.h"
#include "IU.h"


void IntegerUnit::save_restore(const Instruction& inst) {
    UInt32 operand2 = (inst.i() == 0) ? reg[inst.rs2()] : inst.simm13();

    // Init result to shut up gcc
    UInt32 result = 0;
    int new_cwp;

    switch (inst.op3()) {
    case Instruction::SAVE:   
	new_cwp = (reg.CWP() == 0) ? (NWINDOWS - 1) : (reg.CWP() - 1);
	// next

	if ((IU_WIM >> new_cwp) & 1) {
	    trap = 1;
	    trapFlag[window_overflow] = 1;

	} else {
	    result = reg[inst.rs1()] + operand2;
	    reg.CWP(new_cwp);
	}
	break;

    case Instruction::RESTORE:    
	new_cwp = (reg.CWP() + 1) % NWINDOWS;  
	// next
	                
	if ((IU_WIM >> new_cwp) & 1) {
	    trap = 1;
	    trapFlag[window_underflow] = 1;
	} else {
	    result = reg[inst.rs1()] + operand2;
	    reg.CWP(new_cwp);
	}
	break;

    default:
	Assert(0, "Unknown Op3: PLEASE EMAIL isem@cs.unm.edu with this error!");
    }

    if (trap == 0)
	reg[inst.rd()] = result;
}
