/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Tue Feb  6 09:23:08 2001
****************************************************************************/
/*
* Error package for editor.
*/
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "tkgate.h"

extern struct displaylist *simerrors;

GError *errlist = NULL,*curerr = NULL;

static GError **errors = 0;
int ErrorCount;

#define ERRORHEADLINES 2


int ErrorXPos;
int ErrorYPos;
int ErrorMarkTimeout = 0;

/*
    Set the position of an error
*/
void SetErrorPosition(int x,int y)
{
  ErrorMarkTimeout = 2;
  ErrorXPos = x;
  ErrorYPos = y;
}

void DrawErrorPositionMark()
{
  line(ErrorXPos-20,ErrorYPos-20,ErrorXPos+20,ErrorYPos+20);
  line(ErrorXPos-20,ErrorYPos+20,ErrorXPos+20,ErrorYPos-20);
}

void ClearErrorMark()
{
  if (ErrorMarkTimeout == 1) {
    DrawErrorPositionMark();
    ErrorMarkTimeout = 0;
  }
}

GError *new_GError(char *path,char *msg)
{
  GError *E = (GError*) malloc(sizeof(GError));
  char b[STRMAX];

  if (path) {
    GModuleDef *M = sim_findContainingMod(path);
    sprintf(b,"In %s: %s",M->Name,msg);
  } else
    strcpy(b, msg);

  E->Num = 0;
  E->path = strdup(path);
  E->message = strdup(b);
  E->g = 0;
  E->n = 0;
  E->next = E->last = 0;

  return E;
}

void Error_add(GError *E)
{
  if (!curerr) {
    DoTcl("tkg_makeErrBox");
    ErrorCount = 0;
    errlist = curerr = E;
    errlist->last = NULL;
    errlist->next = NULL;
  } else {
    curerr->next = E;
    curerr->next->last = curerr;
    curerr = curerr->next;
    curerr->next = NULL;
  }
  DoTcl("tkg_errBoxAdd \"%s\"",E->message);
}

void Error_gateReport(char *path,GCElement *g,char *msg)
{
  GError *E = new_GError(path,msg);

  E->Num = ErrorCount++;
  E->g = g;
  Error_add(E);
}

void Error_nodeReport(char *path,GWireNode *n,char *msg)
{
  GError *E = new_GError(path,msg);

  E->Num = ErrorCount++;
  E->n = n;
  Error_add(E);
}

void Error_genericReport(char *path,char *msg)
{
  GError *E = new_GError(path,msg);

  E->Num = ErrorCount++;
  Error_add(E);
}

void Error_close()
{
  GError *E;
  int i = 0;

  errors = (GError**) malloc(sizeof(GError*)*ErrorCount);
  for (E = errlist;E;E = E->next, i++) {
    errors[i] = E;
  }
}

void Error_purge()
{
  GError *E;

  free(errors);
  errors = 0;
  ClearErrorMark();
  while (errlist) {
    E = errlist;
    errlist = errlist->next;
    free(E->message);
    free(E);
  }
  curerr = errlist = NULL;

  ErrorMarkTimeout = 0;
  FlagRedraw();
}

void Error_navigateToModule(EditState **es,char *path)
{
  char buf[STRMAX],*T,*N;
  GModuleDef *M;

  while (*es) editstate_pop(es);

  M = XGate.root_mod;
  strcpy(buf,path);
  editstate_push(es,M,0);
  for (T = strtok(buf,".");T;T = N) {
    N = strtok(0,".");
    if (N) {
      GCElement *g = (GCElement*) SHash_find(&M->gates,T);
      if (g && g->typeinfo->Code == BLOCK) {
	M = env_findModule(g->u.block.BlockFunction);
	editstate_push(es,M,g);
      }
    }
  }
  cpath_reshow();
}

EditState *Error_open(GError *E,EditState *es)
{
  int x,y;

  if (!E) return es;

  if (!E->n && !E->g) return es;

  if (!E->path) {
    message(0,msgLookup("err.noerr"));		/* "Can not locate error." */
    return es;
  }

  es->save_x = XGate.org_x; 
  es->save_y = XGate.org_y;

  Error_navigateToModule(&es,E->path);

  XGate.select = XGate.last = 0;
  if (E->g) {
    XGate.select = E->g;
    E->g->selected = 1;
  }
  XGate.wsel = NULL;
  XGate.wnsel = NULL;
  
  if (E->n) {
    GWireNode *wn1,*wn2;

    wn1 = E->n;
    wn2 = wn1->out ? wn1->out : wn1->in;
    x = (wn1->x + wn2->x)/2;
    y = (wn1->y + wn2->y)/2;
  } else if (E->g) {
    x = E->g->xpos;
    y = E->g->ypos;
    if (E->g->typeinfo->Code == BLOCK) {
      x += E->g->u.block.gwidth/2;
      y += E->g->u.block.gheight/2 + 10;
    }
  } else {
    x = XGate.width/2;
    y = XGate.height/2;
  }

  XGate_setOrigin(XGate.width/2 - x,XGate.height/2 - y);
  es->save_x = XGate.org_x;
  es->save_y = XGate.org_y; 

  editstate_setCurrent(es);
  SetErrorPosition(x,y);
  
  FlagRedraw();
  
  return es;
}


EditState *seterror(int n,EditState *es)
{
  GError *E;

  if (!errors) {
    message(0,msgLookup("err.misserr"));
    return es;
  }

  E = errors[n];
  return Error_open(E,es);
}

