# $id$

#
# if you're running tkabber under the tkcon package 
#
#     http://tkcon.sourceforge.net
#
# e.g.,
#
#     % tkcon.tcl -exec "" -root .tkconn -main "source tkabber.tcl"
#

if {[llength [info commands ::tkcon::*]] <= 0} {
    return
}

namespace eval tkcon {
    variable showP 0
}

proc tkcon::add_tkcon_to_tkabber_menu {args} {
    set menu [lindex [lsort -dictionary [winfo children .menubar]] end]
    $menu add separator
    $menu add checkbutton -label [::msgcat::mc "Show console"] \
	  -command  [namespace current]::show_console \
	  -variable [namespace current]::showP

    show_console
}

proc tkcon::show_console {} {
    variable showP

    if {$showP} {
	wm state $::tkcon::PRIV(root) normal
    } else {
	wm state $::tkcon::PRIV(root) withdrawn
    }
}

hook::add finload_hook [namespace current]::tkcon::add_tkcon_to_tkabber_menu
