/***************************************************************************
                          optionen.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Feb 19 21:09:31 MET 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <iostream>

#include "wx/sizer.h"
#include "wx/config.h"

#include "optionen.h"

enum
{
  B1 = 43,
  B2
};

BEGIN_EVENT_TABLE(ODialog, wxDialog)
  EVT_BUTTON(B1, ODialog::OnOK)
  EVT_BUTTON(B2, ODialog::OnCancel)
	     
END_EVENT_TABLE()

ODialog::ODialog(wxWindow* parent) : wxDialog(parent, -1, _("Einstellungen"), wxDefaultPosition, wxSize(350,200),  wxDEFAULT_DIALOG_STYLE
					      , "Einstellungen")
{

  //**********************************************
  //* Dialog erstellen
  //**********************************************
  
  SetAutoLayout(TRUE);
 
  st = new wxStaticText(this, -1, _("Sprache:"));

  wxLayoutConstraints *c1 = new wxLayoutConstraints;
  c1->centreX.SameAs(this, wxLeft);
  c1->width.PercentOf(this, wxWidth, 30);
  c1->height.PercentOf(this, wxHeight, 10);
  c1->left.SameAs(this, wxLeft, 10);
  c1->top.SameAs(this, wxTop, 30);
  st->SetConstraints(c1);

  wxString langs[] =
  {
    _("Deutsch"),
    _("Englisch")
  };

  sprache = new wxComboBox(this, -1, "", wxDefaultPosition, wxDefaultSize, 2, langs, wxCB_READONLY);
  wxLayoutConstraints *c2 = new wxLayoutConstraints;
  c2->centreX.SameAs(this, wxRight);
  c2->right.SameAs(this, wxRight, 10);
  c2->width.PercentOf(this, wxWidth, 40);
  c2->height.PercentOf(this,wxHeight,10);
  c2->top.SameAs(this, wxTop, 30);
  sprache->SetConstraints(c2);
    
  tt = new wxStaticText(this, -1, _("Tastaturbelegung:"));
  wxLayoutConstraints *c3 = new wxLayoutConstraints;
  c3->centreX.SameAs(this, wxLeft);
  c3->left.SameAs(this, wxLeft, 10);
  c3->height.PercentOf(this, wxHeight, 12);
  c3->width.PercentOf(this, wxWidth, 40);
  c3->top.SameAs(st, wxBottom, 30);
  tt->SetConstraints(c3);

  wxString maps[] =
  {
    _("Deutsch"),
    _("Englisch")
  };
  
  tastatur = new wxComboBox(this, -1, "", wxDefaultPosition, wxDefaultSize, 2, maps, wxCB_READONLY);
  wxLayoutConstraints *c4 = new wxLayoutConstraints;
  c4->centreX.SameAs(this, wxRight);
  c4->right.SameAs(this, wxRight, 10);
  c4->height.PercentOf(this, wxHeight, 12);
  c4->width.PercentOf(this, wxWidth, 40);
  c4->top.SameAs(sprache, wxBottom, 30);
  tastatur->SetConstraints(c4);

  ok = new wxButton(this, B1,_("OK"));
  wxLayoutConstraints *b2 = new wxLayoutConstraints;
  b2->centreX.SameAs(this, wxLeft);
  b2->top.PercentOf(this, wxHeight, 82);
  b2->left.SameAs(this, wxLeft, 20);
  b2->width.PercentOf(this, wxWidth, 40);
  b2->height.PercentOf(this, wxHeight, 13);
  ok->SetConstraints(b2);

  ab = new wxButton(this, B2, _("Abbrechen"));

  wxLayoutConstraints *b3 = new wxLayoutConstraints;
  b3->centreX.SameAs(this, wxRight);
  b3->top.PercentOf(this, wxHeight, 82);
  b3->right.SameAs(this, wxRight, 20);
  b3->width.PercentOf(this, wxWidth, 40);
  b3->height.PercentOf(this, wxHeight, 13);
  
  ab->SetConstraints(b3);
  SetAutoLayout(TRUE);
  Center();

  //****************************************************
  //* Werte einlesen
  //***************************************************

   wxConfigBase *pConfig = wxConfigBase::Get();
   wxString l = pConfig->Read("/Sprache/Sprache", "deutsch");
   if (l=="deutsch")
     sprache->SetSelection(0);
   else
     if (l=="english") sprache->SetSelection(1);

   wxString k = pConfig->Read("/Tastatur/Layout", "german");
   if (k=="german")
     tastatur->SetSelection(0);
   else
     if (k=="english") tastatur->SetSelection(1);
}

void ODialog::OnOK(wxCommandEvent *event)
{
  wxConfigBase *pConfig = wxConfigBase::Get();
  switch (sprache->GetSelection())
    {
    case 0:
      pConfig->Write("/Sprache/Sprache", (wxString) "deutsch");
      pConfig->Write("/Sprache/SprachID", (wxString) "de");
      break;
    case 1:
      pConfig->Write("/Sprache/Sprache", (wxString) "english");
      pConfig->Write("/Sprache/SprachID", (wxString) "en");
      break;
    };
  switch (tastatur->GetSelection())
    {
    case 0:
      pConfig->Write("/Tastatur/Layout", (wxString) "german");
      break;
    case 1:
      pConfig->Write("/Tastatur/Layout", (wxString) "english");
      break;
    }
  EndModal(GEAENDERT);
}

void ODialog::OnCancel(wxCommandEvent *event)
{
  EndModal(GetReturnCode());
}
					     
