/*
 * Copyright (C) 2004-2006 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef TIMER_APPLET_H
#define TIMER_APPLET_H
#include <gtk/gtk.h>
#include <panel-applet.h>

#ifdef HAVE_LIBNOTIFY
#include <libnotify/notify.h>
#endif

#include "gloo/gloo-presets.h"
#include "gloo/gloo-timer.h"

G_BEGIN_DECLS

#define SHOW_REMAINING_TIME_KEY			"show_remaining_time"
#define PLAY_NOTIFICATION_SOUND_KEY		"play_notification_sound"
#define USE_CUST_NOTIFICATION_SOUND_KEY		"use_custom_notification_sound"
#define CUST_NOTIFICATION_SOUND_PATH_KEY	"custom_notification_sound_path"

typedef struct _TimerApplet
{
	PanelApplet *applet;
	
	GlooTimer *gloo_timer;
	GlooPresets *gloo_presets;

#ifdef HAVE_LIBNOTIFY
	NotifyNotification *notify;
#endif
	
	/* Main applet interface */
	/* This allows us to destroy and re-construct the button with or without the label */
	GtkWidget *main_button;
	/* Keep a pointer to the image around just in case we
	 * need to dim it when the timer is inactive.
	 */
	GtkWidget *main_button_layout_box;
	GtkWidget *main_image;
	GtkWidget *main_remaining_time_label;
	/* Keep a pointer to the tooltips so we can update
	 * its display of the remaining time.
	 */
	GtkTooltips *main_tooltips;
	
	
	/* Start timer dialog */
	GtkWidget *start_timer_dialog;
	GtkWidget *start_timer_presets_manager_widget;
	
	
	/* Preferences dialog */
	GtkWidget *prefs_dialog;
	

	guint gconf_notification_id;
	gulong presets_changed_handler_id;
} TimerApplet;

void
timer_applet_init (TimerApplet *timer_applet, PanelApplet *panel_applet);
void
timer_applet_start_timer (TimerApplet *timer_applet, const gchar *preset_name, guint timer_duration);

G_END_DECLS

#endif /* TIMER_APPLET_H */
