/*
 * Copyright (C) 2004-2006 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef PRESETS_MANAGER_H
#define PRESETS_MANAGER_H

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define MAX_PRESET_NAME_LENGTH		255



/**
 * NOTE: If this is going to be made into a real GtkWidget, might want to make it emit
 * the "empty" and "not empty" signals so we know when to enable certain buttons.
 */

typedef void (*ViewEmptyCallback) (GtkWidget *presets_manager);
typedef void (*ViewNotEmptyCallback) (GtkWidget *presets_manager);
typedef void (*SelectionEmptyCallback) (GtkWidget *presets_manager);
typedef void (*SelectionNotEmptyCallback) (GtkWidget *presets_manager);
typedef void (*RowSelectedCallback) (GtkWidget *presets_manager, gpointer data);

typedef void (*PresetsManagerAddedCallback) (GtkWidget *add_presets_dialog, gchar *preset_name, guint preset_duration, gpointer user_data);
typedef void (*PresetsManagerEditedCallback) (GtkWidget *add_presets_dialog, GtkTreeRowReference *row_ref, gchar *preset_name, guint preset_duration, gpointer user_data);
typedef void (*PresetsManagerDeletedCallback) (GtkWidget *add_presets_dialog, GtkTreeRowReference *row_ref, gpointer user_data);

GtkWidget *
presets_manager_new (GtkTreeModel *tree_model);
GtkTreeRowReference *
presets_manager_get_selected_preset (GtkWidget *presets_manager);
GtkTreeRowReference *
presets_manager_delete_selection (GtkWidget *presets_manager, GtkWidget *parent_window);
void
presets_manager_select_row (GtkWidget *presets_manager, GtkTreeRowReference *row_ref);
void
presets_manager_select_first_row (GtkWidget *presets_manager);
void
presets_manager_connect_row_selected (GtkWidget *presets_manager, RowSelectedCallback row_activated_cb, gpointer user_data);
void
presets_manager_set_view_change_handlers (GtkWidget *presets_manager, ViewEmptyCallback empty_cb, ViewNotEmptyCallback not_empty_cb);
void
presets_manager_set_selection_change_handlers (GtkWidget *presets_manager, SelectionEmptyCallback empty_cb, SelectionNotEmptyCallback not_empty_cb);
void
presets_manager_set_preset_handlers (GtkWidget *presets_manager, PresetsManagerAddedCallback added_cb, gpointer user_data1,
				PresetsManagerEditedCallback edited_cb, gpointer user_data2, PresetsManagerDeletedCallback deleted_cb, gpointer user_data3);
GtkWidget *
presets_manager_get_tree_view (GtkWidget *presets_manager);

G_END_DECLS

#endif /* PRESETS_MANAGER_H */
