/*
 * Copyright (C) 2004-2006 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef LAYOUT_UTILS_H
#define LAYOUT_UTILS_H

#include <gtk/gtk.h>

G_BEGIN_DECLS

GtkWidget *
create_group_box (GtkWidget *header_widget);
GtkWidget *
create_group_box_with_label (const gchar *label);
void
group_box_add_row_full (GtkWidget *group_box, GtkWidget *row_widget, gboolean expand, gboolean fill);
void
group_box_add_row (GtkWidget *group_box, GtkWidget *row_widget);

GtkWidget *
create_duration_chooser (void);
GtkWidget *
duration_chooser_get_hours_spin (GtkWidget *duration_chooser);
GtkWidget *
duration_chooser_get_minutes_spin (GtkWidget *duration_chooser);
GtkWidget *
duration_chooser_get_seconds_spin (GtkWidget *duration_chooser);
GtkSizeGroup *
duration_chooser_get_labels_size_group (GtkWidget *duration_chooser);



#define MAX_NUM_HOURS 48

gchar *
construct_time_str (guint remaining_seconds, gboolean show_all, gboolean shorten_zero);
gchar *
construct_display_name (const gchar *name, guint duration);

G_END_DECLS

#endif /* LAYOUT_UTILS_H */
