/* -*- mode: c; c-file-style: "gnu" -*-
 * session.h -- HTTP session handling routines, prototypes
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file session.h
 * HTTP session handling routines, prototypes.
 */

#ifndef _THY_SESSION_H
#define _THY_SESSION_H 1 /**< session.h multi-inclusion guard. */

#include "types.h"

session_t *session_init (int infd, int outfd, int sport, int ssl,
			 const char *origin, void *tls_data);
void session_update (session_t *session);
int session_handle (session_t *session);
void session_kill (session_t *session, int clse);

void session_header (session_t *session, http_status_t code);
void session_header_add (session_t *session, const char *hdr,
			 const char *value);
void session_headers_flush (session_t *session);
void session_error (session_t *session);
int session_handle_keepalive (session_t *session);
void session_log (session_t *session);
char *session_handler_check (const char *fn, const char *absuri);
void session_finalise (session_t *session);
char *session_isindex (const session_t *session, const char *fn);
void session_state_change (session_t *session, session_state_t nstate);

#endif /* !_THY_SESSION_H */
