/* -*- mode: c; c-file-style: "gnu" -*-
 * config.h -- configuration handling function prototypes
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file config.h
 * Configuration handling function prototypes.
 */

#ifndef _THY_CONFIG_H
#define _THY_CONFIG_H 1 /**< config.h multi-inclusion guard. */

#include "types.h"

void config_parse (int argc, char **argv);
config_t *config_get (void);
thy_mappable_config_t *config_get_mapped (const char *absuri,
					  const char *file);
/** Parse a configuration file.
 * This function reads in a configuration file, and stores the result
 * in #conffile_list, which will be converted to an argv[] array and
 * passed to argp_parse().
 *
 * @param fn is the name of the file to parse.
 *
 * @returns Zero on success, 1 on parse error, and 2 if the file does
 * not exist.
 */
int thy_config_file_parse (const char *fn);

#endif /* ! _THY_CONFIG_H */
