
/******************************************************************************
* MODULE     : tm_widget.gen.h
* DESCRIPTION: Main current graphical interface for user applications
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <server.gen.h>
#include <window.gen.h>
#include <Event/attribute_event.gen.h>

#module tm_widget
#import server
#import window
#import attribute_event

class tm_widget_rep;
class tm_widget;

class tm_widget_rep: public basic_widget_rep {
public:
  server_rep* sv;

protected:
  widget   icon_bar  [3]; // icon bars
  bool     icon_flag [3]; // icon bar active ?
  bool     cmd_mode;      // type a command on the bottom line ?
  string*  text_ptr;      // where the interactive string should be returned
  command  call_back;     // called when typing finished
  widget   left;          // backup of footers
  widget   middle;        // when switching between
  widget   right;         // text and command mode

public:
  tm_widget_rep (server_rep* sv, display dis);
  ~tm_widget_rep ();
  widget_rep* get_this ();

  operator tree ();
  void set_window_name (string s);
  void set_popup_menu (widget w, SI x, SI y);
  void set_main_menu (widget w);
  void set_icon_menu (int which, widget w);
  void set_icon_flag (int which, bool on);
  bool get_icon_flag (int which);

  void set_left_footer (string s);
  void set_right_footer (string s);
  void swap_mode ();
  void interactive (string name, string& s, command cmd);
  void interactive_return ();

  void handle_get_size (get_size_event ev);
  void handle_get_widget (get_widget_event ev);
  void handle_set_widget (set_widget_event ev);
  void handle_set_string (set_string_event ev);
  void handle_keypress (keypress_event ev);
  void handle_mouse (mouse_event ev);
  void handle_keyboard_focus (keyboard_focus_event ev);
  void handle_resize (resize_event ev);
  void handle_destroy (destroy_event ev);
  void handle_alarm (alarm_event ev);

  bool handle (event ev);

  friend class server_rep;
  friend class tm_editor_rep;
  friend class tm_widget;
};

class tm_widget {
#import extend_null (widget, tm_widget, tm_widget_rep)
};
#import code_extend_null (widget, tm_widget, tm_widget_rep)

#endmodule // tm_widget
