
/******************************************************************************
* MODULE     : server.gen.h
* DESCRIPTION: Main current graphical interface for user applications
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <editor.gen.h>
#include <tm_widget.gen.h>

#module server
#import editor
#import array (editor)
#import tm_widget

class tm_buffer_rep;
class tm_view_rep;
class tm_window_rep;
typedef tm_buffer_rep* tm_buffer;
typedef tm_view_rep*   tm_view;
typedef tm_window_rep* tm_window;

class server_rep: public abstract_struct {
public:
  server_rep ();
  virtual ~server_rep ();
  virtual void advance_banner () = 0;

  /* Control global server parameters */
  virtual void   set_input_language (string s) = 0;
  virtual void   set_output_language (string s) = 0;
  virtual string get_input_language () = 0;
  virtual string get_output_language () = 0;
  virtual void   set_font_rules (scheme_tree rules) = 0;
  virtual void   set_latex_commands (scheme_tree cmds) = 0;
  virtual void   set_latex_symbols (scheme_tree syms) = 0;
  virtual bool   get_latex_command (string s, string& help, scheme_tree& p)=0;
  virtual void   set_keymap (scheme_tree m, scheme_tree cmds) = 0;
  virtual void   remove_keymap (scheme_tree m, scheme_tree cmds) = 0;
  virtual void   get_keycomb (string s, int& status,
			      scheme_tree& cmd, string& sh, string& help) = 0;

  /* Guile scheme motor */
  virtual bool exec (string s) = 0;
  virtual bool exec (scheme_tree p) = 0;
  virtual bool exec_file (string dir, string name) = 0;
  virtual void exec_delayed (scheme_tree p) = 0;
  virtual bool eval_any (scheme_tree p, string& ret) = 0;
  virtual bool eval_bool (scheme_tree p, bool& ret) = 0;
  virtual bool eval_scheme_tree (scheme_tree p, scheme_tree& ret) = 0;

  /* TeXmacs layout */
  virtual void menu_widget (scheme_tree p, widget& w) = 0;
  virtual void menu_main (scheme_tree p) = 0;
  virtual void menu_icons (int which, scheme_tree p) = 0;
  virtual void menu_icons_on (int which, bool flag) = 0;
  virtual bool menu_icons_status (int which) = 0;

  /* Buffer management */
  virtual bool no_name () = 0;
  virtual string get_name_buffer () = 0;
  virtual void set_name_buffer (string name) = 0;
  virtual void new_buffer () = 0;
  virtual void switch_to_buffer (string name) = 0;
  virtual void revert_buffer () = 0;
  virtual void kill_buffer () = 0;
  virtual void open_window () = 0;
  virtual void clone_window () = 0;
  virtual void kill_window () = 0;
  virtual void set_max_undo_depth (int i) = 0;
  virtual int  get_max_undo_depth () = 0;
  virtual bool no_bufs () = 0;

  /* Projects */
  virtual void project_attach (string prj_name= "") = 0;
  virtual bool project_attached () = 0;

  /* Loading and saving files */
  virtual void load_buffer (string d,string n,string f,int w=0,bool a=FALSE)=0;
  virtual void save_buffer (string name, string fm) = 0;
  virtual bool exists_unsaved_buffer () = 0;
  virtual void pretend_save_buffer () = 0;
  virtual void auto_save () = 0;

  /* Get and set objects associated to server */
  virtual server_rep* get_server () = 0;
  virtual display     get_display () = 0;
  virtual tm_view     get_view (bool must_be_valid= TRUE) = 0;
  virtual void        set_view (tm_view vw) = 0;
  virtual tm_buffer   get_buffer () = 0;
  virtual editor      get_editor () = 0;
  virtual tm_window   get_window () = 0;
  virtual tm_widget   get_meta () = 0;

  /* Routines concerning the current editor widget */
  virtual void get_visible (SI& x1, SI& y1, SI& x2, SI& y2) = 0;
  virtual void scroll_where (SI& x, SI& y) = 0;
  virtual void scroll_to (SI x, SI y) = 0;
  virtual void set_extents (SI x1, SI y1, SI x2, SI y2) = 0;
  virtual void set_left_footer (string s) = 0;
  virtual void set_right_footer (string s) = 0;
  virtual void set_message (string left, string right) = 0;
  virtual void interactive (string name, string& s, command call_back) = 0;
  virtual void dialogue_start (string name, widget wid, scheme_tree prg) = 0;
  virtual void dialogue_inquire (scheme_tree& arg) = 0;
  virtual void dialogue_end () = 0;
  virtual void choose_file (string title, string type, scheme_tree prg) = 0;

  /* Misscelaneous routines */
  virtual void   interpose_handler () = 0;
  virtual void   wait_handler (string message, string arg) = 0;
  virtual void   set_script_status (int i) = 0;
  virtual void   focus_on_editor (editor ed) = 0;
  virtual void   set_printing_command (string s) = 0;
  virtual void   set_printer_page_type (string s) = 0;
  virtual void   set_printer_dpi (string dpi) = 0;
  virtual void   postscript_gc (string which= "*") = 0;
  virtual void   inclusions_gc (string which= "*") = 0;
  virtual bool   is_yes (string s) = 0;
  virtual void   quit () = 0;
  virtual void   declare (string name, string lib, string symb, string init)=0;
  virtual tree   evaluate (string name, string session, tree expr) = 0;
  virtual string execute  (string name, string session, string expr) = 0;
  virtual void   shell    (string s) = 0;
};

class server {
#import abstract (server, server_rep)
  server (display dis);
};
#import code_abstract (server, server_rep)

scheme_tree menu_merge (scheme_tree m1, scheme_tree m2);
server get_server ();

#endmodule // server
