
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : build-glue-basic.scm
;; DESCRIPTION : Building basic glue for the server
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public licence and comes WITHOUT
;; ANY WARRENTY WHATSOEVER. See the file $TEXMACS_PATH/LICENCE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(output-copyright "build-glue-server.scm")

(output "\n#module code_glue_server\n")

(build
  "get_server()->"
  "initialize_glue_server"

  (set-input-language set_input_language (void string))
  (set-output-language set_output_language (void string))
  (system-set-keymap set_keymap (void scheme_tree scheme_tree))
  (system-remove-keymap remove_keymap (void scheme_tree scheme_tree))
  (set-latex-commands set_latex_commands (void scheme_tree))
  (set-latex-symbols set_latex_symbols (void scheme_tree))
  (set-shorthands set_keymap (void scheme_tree scheme_tree))
  (set-font-rules set_font_rules (void scheme_tree))

  (menu-icons-on menu_icons_on (void int bool))
  (menu-icons-status menu_icons_status (bool int))

  (exec-file exec_file (void string string))
  (shell shell (void string))
  (dialogue-end dialogue_end (void))
  (choose-file choose_file (void string string scheme_tree))

  (no-name? no_name (bool))
  (exists-unsaved-buffer? exists_unsaved_buffer (bool))
  (pretend-save-buffer pretend_save_buffer (void))
  (get-name-buffer get_name_buffer (string))
  (set-name-buffer set_name_buffer (void string))
  (new-buffer new_buffer (void))
  (switch-to-buffer switch_to_buffer (void string))
  (revert-buffer revert_buffer (void))
  (kill-buffer kill_buffer (void))
  (open-window open_window (void))
  (clone-window clone_window (void))
  (kill-window kill_window (void))
  (set-maximal-undo-depth set_max_undo_depth (void int))
  (get-maximal-undo-depth get_max_undo_depth (int))

  (project-attach project_attach (void string))
  (project-detach project_attach (void))
  (project-attached? project_attached (bool))

  (texmacs-load-buffer load_buffer (void string string string int bool))
  (texmacs-save-buffer save_buffer (void string string))

  (set-script-status set_script_status (void int))
  (set-printing-command set_printing_command (void string))
  (set-printer-page-type set_printer_page_type (void string))
  (set-printer-dpi set_printer_dpi (void string))
  (postscript-gc postscript_gc (void))
  (inclusions-gc inclusions_gc (void))
  (yes? is_yes (bool string))
  (quit-TeXmacs quit (void))
  (package-evaluate evaluate (texmacs_tree string string texmacs_tree))
  (package-execute execute (string string string string)))

(output "\n#endmodule //code_glue_server\n")
