
/******************************************************************************
* MODULE     : gg_file.gen.cc
* DESCRIPTION: reading input
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#ifndef _GG_FILE
#define _GG_FILE
#include "gg_array_string.h"
#include "gg_system.h"
#include <stdio.h>

class ifstream {
  FILE*    fp;
  string   name;
  bool     already_included;

public:
  ifstream (string prefix, string s);
  ifstream (string prefix, string s, array_string& includes);
  ~ifstream ();

  bool try_to_open (string s);
  bool try_to_open (string s, array_string& includes);
  bool get (char& c);
  operator bool ();
  friend class file_reader;
};

struct ofstream {
  FILE* fp;
  ofstream (string s);
  ~ofstream ();
  ofstream& operator << (char c);
  ofstream& operator << (int i);
  ofstream& operator << (string s);
  operator bool ();
};

class file_reader {
public:
  string       Input_file;
  int          Input_line;
  string       in;
  array_string includes;
  
  void output_line ();
  void read (string prefix, string file_name);
};

string radical (string f);
string load (string file_name);
void   save (string file_name, string s);

#endif
