
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : math-fonts.scm
;; DESCRIPTION : setup cm fonts for math mode
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(set-font-rules
  '(((math $ecrm $cmr $cmmi $cmsy $msam $msbm $stmary $wasy $line $cmex $s $d)
     (math
      (math (tex $cmr $s $d)
	    (tex $cmmi $s $d)
	    (tex $cmsy $s $d)
	    (tex $msam $s $d)
	    (tex $msbm $s $d)
	    (tex $stmary $s $d)
	    (tex $wasy $s $d)
	    (tex $line $s $d)
	    (virtual long $s $d)
	    (virtual negate $s $d)
	    (virtual misc $s $d))
      (rubber (tex-rubber rubber-cmex $cmex $s $d)
	      (tex-rubber rubber-stmary $stmary $s $d)
	      (tex-rubber rubber-wasy $wasy $s $d)
	      (tex-dummy-rubber (tex-rubber rubber-cmex $cmex $s $d)))
      (ec $ecrm $s $d)
      (ec ecrm $s $d)))

    ((math-std $ecrm $cmr $cmmi $s $d)
     (math $ecrm $cmr $cmmi cmsy msam msbm stmary wasy line cmex $s $d))
    ((bold-math-std $ecrm $cmr $cmmi $s $d)
     (math $ecrm $cmr $cmmi cmbsy msam msbm stmaryb wasyb linew cmex $s $d))
    ((math-conc $ecrm $cmr $cmmi $s $d)
     (math $ecrm $cmr $cmmi xccsy xccam xccbm stmary wasy line xccex $s $d))
    ((math-bright $ecrm $cmr $cmmi $s $d)
     (math $ecrm $cmr $cmmi cmbrsy cmbram cmbrbm stmary wasy line cmex $s $d))

    ((var-math $ecrm $cmr $cmmi $cmsy $msam $msbm
	       $stmary $wasy $line $cmex $s $d)
     (math
      (var-math (tex $cmmi $s $d)
		(tex $cmr $s $d)
		(tex $cmsy $s $d)
		(tex $msam $s $d)
		(tex $msbm $s $d)
		(tex $stmary $s $d)
		(tex $wasy $s $d)
		(tex $line $s $d)
		(virtual long $s $d)
		(virtual negate $s $d)
		(virtual misc $s $d))
      (rubber (tex-rubber rubber-cmex $cmex $s $d)
	      (tex-rubber rubber-stmary $stmary $s $d)
	      (tex-rubber rubber-wasy $wasy $s $d)
	      (tex-dummy-rubber (tex-rubber rubber-cmex $cmex $s $d)))
      (ec $ecrm $s $d)
      (ec ecrm $s $d)))

    ((math-var $ecrm $cmr $cmmi $s $d)
     (var-math $ecrm $cmr $cmmi cmsy msam msbm stmary wasy line cmex $s $d))
    ((bold-math-var $ecrm $cmr $cmmi $s $d)
     (var-math $ecrm $cmr $cmmi
	       cmbsy msam msbm stmaryb wasyb linew cmex $s $d))
    ((math-conc-var $ecrm $cmr $cmmi $s $d)
     (var-math $ecrm $cmr $cmmi
	       xccsy xccam xccbm stmary wasy line xccex $s $d))
    ((math-bright-var $ecrm $cmr $cmmi $s $d)
     (var-math $ecrm $cmr $cmmi
	       cmbrsy cmbram cmbrbm stmary wasy line cmex $s $d))

    ((math-capital $name $s $d)
      (join (capital (tex $name $s $d)) (error (tex cmr $s $d))))
    ((math-alpha $name $s $d)
      (join (alpha (tex $name $s $d)) (error (tex cmr $s $d))))
    ((math-alpha-numeric $name $s $d)
      (join (alpha-numeric (tex $name $s $d)) (error (tex cmr $s $d))))

    ((roman mr medium $a $s $d) (math-std ecrm cmr cmmi $s $d))
    ((roman mr bold $a $s $d) (bold-math-std ecbx cmbx cmmib $s $d))
    ((roman ms light $a $s $d) (math-bright cmbr cmbr cmbrmi $s $d))
    ((roman ms medium $a $s $d) (math-std ecss cmss cmssi $s $d))
    ((roman ms bold $a $s $d) (math-std ecsx cmssbx cmmib $s $d))
    ((roman mt medium $a $s $d) (math-std ectt cmtt cmitt $s $d))
    ((roman rm $a $b $s $d) (math-var ecrm cmr cmmi $s $d))
    ((roman ss $a $b $s $d) (math-var ecss cmss cmmi $s $d))
    ((roman tt $a $b $s $d) (math-var ectt cmtt cmmi $s $d))
    ((roman bf $a $b $s $d) (bold-math-var ecbx cmbx cmmib $s $d))
    ((roman up $a $b $s $d) (math-var ecui cmu cmmi $s $d))
    ((roman it $a $b $s $d) (math-var ecti cmti cmmi $s $d))
    ((roman sl $a $b $s $d) (math-var ecsl cmsl cmmi $s $d))

    ((concrete mr medium $a $s $d) (math-conc eorm ccr xccmi $s $d))
    ((concrete mr bold $a $s $d) (bold-math-std ecbx cmbx cmmib $s $d))
    ((concrete ms light $a $s $d) (math-bright cmbr cmbr cmbrmi $s $d))
    ((concrete ms medium $a $s $d) (math-std ecss cmss cmssi $s $d))
    ((concrete ms bold $a $s $d) (math-std ecsx cmssbx cmmib $s $d))
    ((concrete mt medium $a $s $d) (math-std ectt cmtt cmitt $s $d))
    ((concrete rm $a $b $s $d) (math-conc-var eorm ccr xcmmi $s $d))
    ((concrete ss $a $b $s $d) (math-var ecss cmss cmmi $s $d))
    ((concrete tt $a $b $s $d) (math-var ectt cmtt cmmi $s $d))
    ((concrete bf $a $b $s $d) (bold-math-var ecbx cmbx cmmib $s $d))
    ((concrete up $a $b $s $d) (math-var ecui cmu cmmi $s $d))
    ((concrete it $a $b $s $d) (math-var ecti cmti cmmi $s $d))
    ((concrete sl $a $b $s $d) (math-var ecsl cmsl cmmi $s $d))

    ((ENR mr medium normal $s $d) (math-alpha-numeric eurm $s $d))
    ((ENR mr bold normal $s $d) (math-alpha-numeric eurb $s $d))
    ((Duerer mr medium normal $s $d) (math-alpha-numeric cdr $s $d))
    ((Duerer mr medium slanted $s $d) (math-alpha-numeric cdsl $s $d))
    ((Duerer mr medium italic $s $d) (math-alpha-numeric cdi $s $d))
    ((Duerer mr bold normal $s $d) (math-alpha-numeric cdb $s $d))
    ((Duerer ms medium normal $s $d) (math-alpha-numeric cdss $s $d))
    ((Duerer mt medium normal $s $d) (math-alpha-numeric cdtt $s $d))
    ((Euler mr medium normal $s $d) (math-alpha-numeric eufm $s $d))
    ((Euler mr bold normal $s $d) (math-alpha-numeric eufb $s $d))
    ((cal mr medium normal $s $d) (math-capital cmsy $s $d))
    ((cal mr bold normal $s $d) (math-capital cmbsy $s $d))
    ((cal* mr medium normal $s $d) (math-capital rsfs $s $d))
    ((cal** mr medium normal $s $d) (math-capital euxm $s $d))
    ((Bbb mr medium normal $s $d) (math-capital msbm $s $d))
    ((Bbb* mr medium normal $s $d) (math-alpha-numeric bbm $s $d))
    ((Bbb* mr medium slanted $s $d) (math-alpha-numeric bbmsl $s $d))
    ((Bbb* mr bold normal $s $d) (math-alpha-numeric bbmbx $s $d))
    ((Bbb* mr bold slanted $s $d) (math-alpha-numeric bbmbxsl $s $d))
    ((Bbb* ms medium normal $s $d) (math-alpha-numeric bbmss $s $d))
    ((Bbb* ms medium italic $s $d) (math-alpha-numeric bbmssi $s $d))
    ((Bbb* ms bold normal $s $d) (math-alpha-numeric bbmssbx $s $d))
    ((Bbb* mt medium normal $s $d) (math-alpha-numeric bbmsltt $s $d))
    ((Bbb** mr medium normal $s $d) (math-alpha-numeric bbold $s $d))
    ((Bbb*** mr medium normal $s $d) (math-alpha-numeric ocmr $s $d))
    ((Bbb**** mr medium normal $s $d) (math-alpha-numeric dsrom $s $d))
    ((Bbb**** ms medium normal $s $d) (math-alpha-numeric dsss $s $d))))
