
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : qcl.scm
;; DESCRIPTION : Special support for qcl
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Specific conversion routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (qcl-input-var-row r)
  (if (not (null? r))
      (begin
	(display ", ")
	(cas-input (car r))
	(qcl-input-var-row (cdr r)))))

(define (qcl-input-row r)
  (display "[")
  (cas-input (car r))
  (qcl-input-var-row (cdr r))
  (display "]"))

(define (qcl-input-var-rows t)
  (if (not (null? t))
      (begin
	(display ", ")
	(qcl-input-row (car t))
	(qcl-input-var-rows (cdr t)))))

(define (qcl-input-rows t)
  (display "matrix(")
  (qcl-input-row (car t))
  (qcl-input-var-rows (cdr t))
  (display ")"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(connection-declare "qcl" "tm_qcl")
(connection-format "qcl" "verbatim" "generic")
(set! session-menu (menu-merge session-menu
  '(("qcl" (make-session "qcl" "default")))))
(define (in-qcl?) (equal? (get-env "prog language") "qcl"))

(set! cas-input-current-cas "qcl")
(cas-input-set! 'rows qcl-input-rows)
(display "")
