
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : mupad.scm
;; DESCRIPTION : Special support for mupad
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Help menus
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define mupad-help-menu
  '(("tutorial" (system "tm_mupad_help tutorium &"))
    ("quick reference" (system "tm_mupad_help quickref &"))
    ("standard library" (system "tm_mupad_help stdlib &"))
    ("what's new" (system "tm_mupad_help changes &"))
    ---
    ("solving equations" (system "tm_mupad_help solvelib &"))
    ("numerical calculations" (system "tm_mupad_help numeric &"))
    ("plots" (system "tm_mupad_help plot &"))
    ---
    (-> "algebra" (link mupad-help-algebra))
    (-> "polynomials" (link mupad-help-polynomials))
    (-> "calculus" (link mupad-help-calculus))
    (-> "programming" (link mupad-help-programming))
    (-> "domains" (link mupad-help-domains))
    (-> "input-output" (link mupad-help-io))))

(define mupad-help-algebra
  '(("linear algebra" (system "tm_mupad_help linalg &"))
    ("linear optimization" (system "tm_mupad_help linopt &"))
    ("number theory" (system "tm_mupad_help numlib &"))
    ("combinatorics" (system "tm_mupad_help combinat &"))
    ("graph theory" (system "tm_mupad_help Network &"))
    ("statistics" (system "tm_mupad_help stats &"))
    ("miscellania" (system "tm_mupad_help misc &"))))

(define mupad-help-polynomials
  '(("polynomials" (system "tm_mupad_help polylib &"))
    ("orthogonal polynomials" (system "tm_mupad_help orthpoly &"))
    ("groebner bases" (system "tm_mupad_help groebner &"))))

(define mupad-help-calculus
  '(("integration" (system "tm_mupad_help intlib &"))
    ("educational tools" (system "tm_mupad_help student &"))
    ("integral transforms" (system "tm_mupad_help transform &"))
    ("differential equations" (system "tm_mupad_help detools &"))))

(define mupad-help-programming
  '(("data types" (system "tm_mupad_help datatypes &"))
    ("strings" (system "tm_mupad_help stringlib &"))
    ("lists" (system "tm_mupad_help listlib &"))
    ("programmer's toolbox" (system "tm_mupad_help prog &"))
    ("abstract data types" (system "tm_mupad_help adt &"))
    ("functional programming" (system "tm_mupad_help fp &"))
    ("type checking" (system "tm_mupad_help Type &"))
    ("properties" (system "tm_mupad_help property &"))
    ("pattern matching" (system "tm_mupad_help matchlib &"))
    ("user preferences" (system "tm_mupad_help Pref &"))
    ("dynamic modules" (system "tm_mupad_help module &"))))

(define mupad-help-domains
  '(("axioms, categories and domains" (system "tm_mupad_help domainref &"))
    ("domains" (system "tm_mupad_help Dom &"))
    ("categories" (system "tm_mupad_help Cat &"))
    ("axioms" (system "tm_mupad_help Ax &"))))

(define mupad-help-io
  '(("formatted output" (system "tm_mupad_help output &"))
    ("importing data" (system "tm_mupad_help import &"))
    ("generating input for other programs"
     (system "tm_mupad_help generate &"))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Specific conversion routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (mupad-input-var-row r)
  (if (not (null? r))
      (begin
	(display ", ")
	(cas-input (car r))
	(mupad-input-var-row (cdr r)))))

(define (mupad-input-row r)
  (display "[")
  (cas-input (car r))
  (mupad-input-var-row (cdr r))
  (display "]"))

(define (mupad-input-var-rows t)
  (if (not (null? t))
      (begin
	(display ", ")
	(mupad-input-row (car t))
	(mupad-input-var-rows (cdr t)))))

(define (mupad-input-rows t)
  (display "matrix([")
  (mupad-input-row (car t))
  (mupad-input-var-rows (cdr t))
  (display "])"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(connection-declare "mupad" "tm_mupad")
(connection-format "mupad" "verbatim" "generic")
(set! session-menu (menu-merge session-menu
  '(("mupad" (make-session "mupad" "default")))))
(set! texmacs-session-help-icons (menu-merge texmacs-session-help-icons
  '(if (equal? (get-env "prog language") "mupad")
       |
       (=> (balloon (icon "tm_help.xpm") "MuPAD documentation")
	   (link mupad-help-menu)))))

(define (in-mupad?) (equal? (get-env "prog language") "mupad"))

(set! cas-input-current-cas "mupad")
(cas-input-set! 'rows mupad-input-rows)
(display "")
