
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : table.scm
;; DESCRIPTION : routines for manipulating tables
;; COPYRIGHT   : (C) 2001  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Commands for tables
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (table-set-width-ia)
  (interactive '("Table width:")
	       '(lambda (s) (table-set-format "table width" s))))

(define (table-use-paragraph-width)
  (table-set-format "table width" "1par"))

(define (table-set-height-ia)
  (interactive '("Table height:")
	       '(lambda (s) (table-set-format "table height" s))))

(define (table-set-padding-ia)
  (interactive '("Padding:")
	       '(lambda (s)
		  (table-set-format "table lsep" s)
		  (table-set-format "table rsep" s)
		  (table-set-format "table bsep" s)
		  (table-set-format "table tsep" s))))

(define (table-set-lpadding-ia)
  (interactive '("Left padding:")
	       '(lambda (s) (table-set-format "table lsep" s))))

(define (table-set-rpadding-ia)
  (interactive '("Right padding:")
	       '(lambda (s) (table-set-format "table rsep" s))))

(define (table-set-bpadding-ia)
  (interactive '("Bottom padding:")
	       '(lambda (s) (table-set-format "table bsep" s))))

(define (table-set-tpadding-ia)
  (interactive '("Top padding:")
	       '(lambda (s) (table-set-format "table tsep" s))))

(define (table-set-border-ia)
  (interactive '("Border width:")
	       '(lambda (s)
		  (table-set-format "table lborder" s)
		  (table-set-format "table rborder" s)
		  (table-set-format "table bborder" s)
		  (table-set-format "table tborder" s))))

(define (table-set-lborder-ia)
  (interactive '("Left border width:")
	       '(lambda (s) (table-set-format "table lborder" s))))

(define (table-set-rborder-ia)
  (interactive '("Right border width:")
	       '(lambda (s) (table-set-format "table rborder" s))))

(define (table-set-bborder-ia)
  (interactive '("Bottom border width:")
	       '(lambda (s) (table-set-format "table bborder" s))))

(define (table-set-tborder-ia)
  (interactive '("Top border width:")
	       '(lambda (s) (table-set-format "table tborder" s))))

(define (table-set-row-origin-ia)
  (interactive '("Origin row:")
	       '(lambda (s) (table-set-format "table row origin" s))))

(define (table-set-column-origin-ia)
  (interactive '("Origin column:")
	       '(lambda (s) (table-set-format "table column origin" s))))

(define (table-set-min-rows-ia)
  (interactive '("Minimal number of rows:")
	       '(lambda (s) (table-set-format "table min rows" s))))

(define (table-set-max-rows-ia)
  (interactive '("Maximal number of rows:")
	       '(lambda (s) (table-set-format "table max rows" s))))

(define (table-set-min-columns-ia)
  (interactive '("Minimal number of columns:")
	       '(lambda (s) (table-set-format "table min cols" s))))

(define (table-set-max-columns-ia)
  (interactive '("Maximal number of columns:")
	       '(lambda (s) (table-set-format "table max cols" s))))

(define (table-set-halign s) (table-set-format "table halign" s))
(define (table-set-valign s) (table-set-format "table valign" s))
(define (table-set-hyphen s) (table-set-format "table hyphen" s))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Commands for cells in tables
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (cell-set-halign s) (cell-set-format "cell halign" s))
(define (cell-set-valign s) (cell-set-format "cell valign" s))
(define (cell-set-hmode s) (cell-set-format "cell hmode" s))
(define (cell-set-vmode s) (cell-set-format "cell vmode" s))
(define (cell-set-background s) (cell-set-format "cell background" s))
(define (cell-set-hyphen s) (cell-set-format "cell hyphen" s))
(define (cell-set-vcorrect s) (cell-set-format "cell vcorrect" s))

(define (cell-set-width-ia)
  (interactive '("Cell width:")
	       '(lambda (s) (cell-set-format "cell width" s))))

(define (cell-set-height-ia)
  (interactive '("Cell height:")
	       '(lambda (s) (cell-set-format "cell height" s))))

(define (cell-set-hpart-ia)
  (interactive '("Part in unused horizontal space:")
	       '(lambda (s) (cell-set-format "cell hpart" s))))

(define (cell-set-vpart-ia)
  (interactive '("Part in unused vertical space:")
	       '(lambda (s) (cell-set-format "cell vpart" s))))

(define (cell-set-padding-ia)
  (interactive '("Padding:")
	       '(lambda (s)
		  (cell-set-format "cell lsep" s)
		  (cell-set-format "cell rsep" s)
		  (cell-set-format "cell bsep" s)
		  (cell-set-format "cell tsep" s))))

(define (cell-set-lpadding-ia)
  (interactive '("Left padding:")
	       '(lambda (s) (cell-set-format "cell lsep" s))))

(define (cell-set-rpadding-ia)
  (interactive '("Right padding:")
	       '(lambda (s) (cell-set-format "cell rsep" s))))

(define (cell-set-bpadding-ia)
  (interactive '("Bottom padding:")
	       '(lambda (s) (cell-set-format "cell bsep" s))))

(define (cell-set-tpadding-ia)
  (interactive '("Top padding:")
	       '(lambda (s) (cell-set-format "cell tsep" s))))

(define (cell-set-border-ia)
  (interactive '("Border width:")
	       '(lambda (s)
		  (cell-set-format "cell lborder" s)
		  (cell-set-format "cell rborder" s)
		  (cell-set-format "cell bborder" s)
		  (cell-set-format "cell tborder" s)
		  (if (equal? (get-cell-mode) "table")
		      (begin
			(table-set-format "table lborder" s)
			(table-set-format "table rborder" s)
			(table-set-format "table bborder" s)
			(table-set-format "table tborder" s))))))

(define (cell-set-lborder-ia)
  (interactive '("Left border width:")
	       '(lambda (s) (cell-set-format "cell lborder" s))))

(define (cell-set-rborder-ia)
  (interactive '("Right border width:")
	       '(lambda (s) (cell-set-format "cell rborder" s))))

(define (cell-set-bborder-ia)
  (interactive '("Bottom border width:")
	       '(lambda (s) (cell-set-format "cell bborder" s))))

(define (cell-set-tborder-ia)
  (interactive '("Top border width:")
	       '(lambda (s) (cell-set-format "cell tborder" s))))

(define (cell-set-span-ia)
  (interactive '("Row span:" "Column span: ")
	       '(lambda (rs cs)
		  (cell-set-format "cell row span" rs)
		  (cell-set-format "cell col span" cs))))

(define (cell-halign-left)
  (let* ((var "cell halign")
	 (old (cell-get-format var)))
    (cond
     ((equal? old "r") (cell-set-format var "c"))
     (else (cell-set-format var "l")))))

(define (cell-halign-right)
  (let* ((var "cell halign")
	 (old (cell-get-format var)))
    (cond
     ((equal? old "l") (cell-set-format var "c"))
     (else (cell-set-format var "r")))))

(define (cell-valign-down)
  (let* ((var "cell valign")
	 (old (cell-get-format var)))
    (cond
     ((equal? old "c") (cell-set-format var "B"))
     ((equal? old "t") (cell-set-format var "c"))
     (else (cell-set-format var "b")))))

(define (cell-valign-up)
  (let* ((var "cell valign")
	 (old (cell-get-format var)))
    (cond
     ((equal? old "b") (cell-set-format var "B"))
     ((equal? old "B") (cell-set-format var "c"))
     (else (cell-set-format var "t")))))
