/* $Date: 2001/06/18 15:09:29 $ $Author: stefanw $ $Revision: 1.44 $ */

// solvelib::BasicSet - the domain of basic sets



alias(Z = new(solvelib::BasicSet, Dom::Integer)):
alias(Q = new(solvelib::BasicSet, Dom::Rational)):
alias(R = new(solvelib::BasicSet, Dom::Real)):
alias(C = new(solvelib::BasicSet, Dom::Complex)):


alias(path = pathname("SOLVELIB", "BASICSET")):


domain solvelib::BasicSet

local plusexpr, multexpr;

inherits Dom::BaseDomain;
  
category Cat::Set;

axiom Ax::canonicalRep;
      /* no two basic sets represent the same mathematical object !? */


      /* entries */



  convert:=
  proc(x:DOM_DOMAIN)

  begin
    if contains({Dom::Integer, Dom::Real, Dom::Rational, Dom::Complex}, x) then
      new(dom, x)
    else
      FAIL
    end_if
  end_proc;


/* union, intersection, minus */  
  
  homog_intersect:=
  proc()
    local arglist;
    
  begin
    arglist:=[args()];
    if testargs() then
      if {op(arglist)} minus {Z, Q, R, C} <> {} then
        error("Illegal argument")
      end_if
    end_if;
    if contains(arglist, Z)>0 then
      Z
    elif contains(arglist, Q)>0 then
      Q
    elif contains(arglist, R)>0 then
      R
    else
      C
    end_if
  end_proc;


  homog_union:=
  proc()
    local arglist;
    
  begin
    arglist:=[args()];
    if testargs() then
      if {op(arglist)} minus {Z, Q, R, C} <> {} then
        error("Illegal argument")
      end_if
    end_if;
    if contains(arglist, C)>0 then
      C
    elif contains(arglist, R)>0 then
      R
    elif contains(arglist, Q)>0 then
      Q
    else
      Z
    end_if
  end_proc;

  inhomog_intersect:=
  table(

        DOM_EXPR=
        proc(bset, e:DOM_EXPR)
          local A, B;
        begin
          if bset=C then
            e
          else
            case type(e)
              of "_minus" do
                A:=bset intersect op(e,1);
                B:=bset intersect op(e,2);
                if type(A)<>"_intersect" and type(B)<>"_intersect" then
                  return(A minus B)
                end_if;
                break
              of "_union" do
                A:=map([op(e)], _intersect, bset);
                if contains(map(A, type), "_intersect")=0 then
                  return(_union(op(A)))
                end_if;
                break
            end_case;
            FAIL
          end_if
        end_proc,
        
        DOM_SET=
        proc(bset, S:DOM_SET)
          local splitset;
        begin
          if bset=C then
            return(S)
          end_if;
          splitset:=split(S, is,(case bset
                                   of Z_ do
                                     Type::Integer;
                                     break;
                                   of Q_ do
                                     Type::Rational;
                                     break
                                   of R_ do
                                     Type::Real;
                                     break
                                 end_case));
          if op(splitset,3)={} then
            splitset[1]
          else
            // expand each element of splitset[3] to a piecewise
            map(splitset[3], el-> piecewise([el in bset, {el}],
                                            [not el in bset, {}]));
            splitset[1] union _union(op(%))
          end_if
        end_proc,
              
        Dom::Multiset =
        proc(bset, S:Dom::Multiset)
          local splitset;
        begin
         if bset=C then
            return(S)
          end_if;
          splitset:=split(S, is,(case bset
                                   of Z_ do
                                     Type::Integer;
                                     break;
                                   of Q_ do
                                     Type::Rational;
                                     break
                                   of R_ do
                                     Type::Real;
                                     break
                                 end_case));
          if nops(splitset[3])=0 then
            splitset[1]
          else
            splitset[1] union hold(_intersect)(splitset[3], bset)
          end_if
        end_proc, 

        
        Dom::Interval =
        proc(bset,iv)
          local lb, rb;
        begin
          if bset=R or bset=C then
            iv
          elif iv=Dom::Interval(-infinity, infinity) then
            bset
          elif bset=Q then
            FAIL
          else /* bset = Z */
            if testtype((lb:=iv::dom::left(iv)), Type::Constant)=TRUE and
             testtype((rb:=iv::dom::right(iv)), Type::Constant)=TRUE then
              if not iv::dom::isleftopen(iv) then
                lb:=ceil(lb)
              else
                lb:=floor(lb+1)
              end_if;
              if not iv::dom::isrightopen(iv) then
                rb:=floor(rb)
              else
                rb:=ceil(rb-1)
              end_if;
              {$lb..rb}
             else
              hold(_intersect)(args())
             end_if
           end_if
        end_proc,

        Dom::ImageSet=
        proc(bset, iset)

        begin
          if bset=C then
            return(iset)
          end_if;
          if bset<>R then
            // not implemented
            return(FAIL)
          end_if;
          // bset=R
          if nops(iset::dom::variables(iset))<>1 then
            // cannot solve for more than one var 
            return(FAIL)
          end_if;
          solve(Im(expr(iset)), op(iset::dom::variables(iset),1));
          if hastype(%, "solve") then
            return(FAIL)
          else  
            % intersect iset::dom::sets(iset)[1]
          end_if;
          solvelib::substituteBySet(expr(iset),
                                    op(iset::dom::variables(iset),1), %)
        end_proc,

        piecewise= piecewise::_intersect
        
          );

  inhomog_union:=
  table(

        DOM_EXPR=
        proc(bset, e)
        begin
          if bset=C then
            return(e)
          end_if;    
          FAIL
        end_proc,
        
        DOM_SET=
        proc(bset, S)
          local splitset;
        begin
          if bset=C then
            return(bset)
          end_if;
          splitset:=split(S, is,(case bset
                                   of Z do
                                     Type::Integer;
                                     break;
                                   of Q do
                                     Type::Rational;
                                     break
                                   of R do
                                     Type::Real;
                                     break
                                 end_case));
        if op(splitset,2)={} and op(splitset,3)={} then
          bset
        else
          hold(_union)(splitset[2] union splitset[3], bset)
        end_if
        end_proc,
        
        Dom::Interval =
        proc(bset, iv)
        begin
          if bset=R or bset=C then
            bset
          elif iv=Dom::Interval(-infinity, infinity) then
            R
          else
            FAIL
          end_if
        end_proc,

        Dom::Multiset=
        proc()
	name BasicSet_union;
	begin
	  error("This would be an infinite multiset")
        end_proc,

        piecewise=piecewise::_union
            );



  inhomogleft_minus:=
  table(
        DOM_SET=
        proc(bset, S: DOM_SET)
          local newS: DOM_SET;
        begin
          newS:=select(S, x-> contains(bset, x)<>FALSE );
          if newS={} then
            bset
          else
            hold(_minus)(bset, newS)
          end_if
        end_proc,

        Dom::Interval=
        proc(bset, iv:Dom::Interval)
        begin
          if bset=R then
            Dom::Interval(-infinity, infinity) minus iv
          else
            FAIL
          end_if
        end_proc,

        piecewise=piecewise::_minus
          );
  
  inhomogright_minus:=
  table(
        DOM_EXPR=
        proc(xpr, bset)

        begin
          if bset=C then
            return({})
          end_if;
          case type(xpr)
            of "_union" do
            of "_intersect" do
              return(map(xpr, _minus, bset))
            of "_minus" do
              return(op(xpr,1) minus (op(xpr,2) union bset))
            otherwise
              FAIL
          end_case;
        end_proc,

        DOM_SET=
        proc(S, bset)
          local splitset;
        begin
          splitset:=split(S, u-> contains(bset,u));
          if op(splitset,3)={} then
            op(splitset,2)
          else
            op(splitset,2) union hold(_minus)(op(splitset,3), bset)
          end_if
        end_proc

        );
 

// _plus, _mult, _minus, special functions

homog_plus:= () -> dom::homog_union(args());

homog_mult:= () -> dom::homog_union(args());

inhomog_plus:=
table(
      DOM_INT= ((bset,n) -> bset),

      DOM_RAT=
      proc(bset, r)
        local i;
      begin
        if bset=Z then
          i:=genident();
          Dom::ImageSet(i+r, i, Z)
        else
          bset
        end_if
      end_proc,
      

      DOM_IDENT= plusexpr,

      DOM_EXPR= plusexpr,

      DOM_FLOAT = plusexpr,

      DOM_COMPLEX= plusexpr,
      
      DOM_SET=
      proc(bset, S)
      begin
        _union(bset + op(S,i) $i=1..nops(S))
      end_proc,
      
      Dom::Interval=
      proc(bset, iv)
      begin
        if bset=R or bset=Q then
          R
        elif bset=C then
          C
        else
          FAIL
        end_if
      end_proc,

      Dom::ImageSet=
      proc(bset, iset)
      begin
        if bset=C then
          C
        else
          genident();
          Dom::ImageSet(expr(iset)+%, append(iset::dom::variables(iset), %),
                        append(iset::dom::sets(iset), bset))
        end_if
      end_proc,

      piecewise=
      proc(bset, pw)
      begin
        piecewise::map(pw, _plus, bset)
      end_proc
        );


inhomog_mult:=
table(
      DOM_INT=
      proc(bset, n)
        local u;
      begin
        if n=0 then
          return({0})
        end_if;
        if bset<>Z then
          return(bset)
        end_if;
        if n=1 or n=-1 then
          Z
        else
          u:=genident();
          Dom::ImageSet(n*u, u, Z)
        end_if
      end_proc,

      DOM_EXPR=multexpr,

      DOM_IDENT=multexpr,

      DOM_COMPLEX=multexpr,

      DOM_FLOAT=multexpr,

      DOM_SET=
      proc(bset, S)
      begin
        _union(bset * op(S,i) $i=1..nops(S))
      end_proc,
      
      Dom::ImageSet=
      proc(bset, iset)
      begin
        if bset=C then
          C
        else
          genident();
          Dom::ImageSet(expr(iset)*%, append(iset::dom::variables(iset), %),
                        append(iset::dom::sets(iset), bset))
        end_if
      end_proc,

      piecewise=
      proc(bset, pw)
      begin
        piecewise::map(pw, _mult, bset)
      end_proc
        );

_negate:=id;


bin_power:=
proc(bset1, bset2)
  local u;
begin
  if bset2 <> Z then
    return(C)
  end_if;
  if bset1 <> Z then
    return(bset1)
  end_if;
  u:=genident();
  Dom::ImageSet(1/u, u, Z)
end_proc;

inhomogleft_power:=
table(
      DOM_INT=
      proc(bset, n)
        local u;
      begin
        if n=0 then
          return({1})
        end_if;
      if n=1 then
        return(bset)
      end_if;
      if bset=C then
        if n>0 then
          return(bset)
        else
          return(bset minus {0})
        end_if
      end_if;
      if bset=Z or bset=Q then
        u:=genident();
        return(Dom::ImageSet(u^n, u, bset))
      end_if;
      /* bset = R */
      if n mod 2= 1 then
        bset
      else
        Dom::Interval([0], infinity)
      end_if
      end_proc,

      DOM_RAT=
      proc(bset, q)
        local u;
      begin
        if bset=C then
          return(bset)
        end_if;
      if bset=Z or bset=Q then
        u:=genident();
        return(Dom::ImageSet(u^q, u, bset))
      end_if;
      /* bset = R */
      return(hold(_union)(Dom::Interval([0], infinity),
                          Dom::ImageSet((-1)^q * u, u,
                                        Dom::Interval([0], infinity)) ))
      end_proc
      
        
        );


inhomogright_power:=
table(
      DOM_INT=
      proc(n, bset)
        local u;
      begin
        if n=0 then
          return({0,1})
        end_if;
      if n=1 then
        return({1})
      end_if;
      case bset
        of C do
          return(C minus {0})
        of R do
          if n>0 then
            return(R)
          elif n=-1 then
            return(exp(I*R))
          else
            return(C minus {0})
          end_if
        of Q do
          u:=genident();
          return(Dom::ImageSet(n^u, u, Q))
        of Z do
          u:=genident();
          return(Dom::ImageSet(n^u, u, Z))
      end_case
      end_proc
            
      
      
      );

spfun:=
proc(u)
  option escape;
begin
  /* return value : */
  proc(S)
    local newvar:DOM_IDENT;
  begin
    newvar:=genident();
    Dom::ImageSet(u(newvar), newvar, S)
  end_proc;

end_proc;


_invert:= loadproc(solvelib::BasicSet::_invert, path, "_invert");

sin:=loadproc(solvelib::BasicSet::sin, path,
                                         "sin");
cos:= loadproc(solvelib::BasicSet::cos, path,
                                         "cos");

tan := loadproc(solvelib::BasicSet::tan, path, "tan");

arcsin:= loadproc(solvelib::BasicSet::arcsin, path,
                                         "arcsin");

arccos:=dom::spfun(arccos);
arctan:=dom::spfun(arctan);
sign:=dom::spfun(sign);
dirac:=dom::spfun(dirac);
heaviside:=dom::spfun(heaviside);

expr:= x -> extop(x,1);

print:= x -> error("body should never be reached");

TeX:= x -> "\\mathbb ".(expr2text(dom::print(x))[0]); 


indets:= {};

contains:=
proc(bset:dom,x)
  
begin
  case bset
    of C do
      // return(is(x, Type::Complex))
      return(TRUE)
    of R do
      is(x, Type::Real); break
    of Q do
      is(x, Type::Rational); break
    of Z do
      is(x, Type::Integer); break
  end_case;
  if %<>UNKNOWN then
    %
  else
    hold(contains)(args())
  end_if
end_proc;

isEmpty:=FALSE;

isFinite:=FALSE;

set2prop:=
proc(S:dom)
begin
  case S
    of C do return(Type::Complex)
    of R do return(Type::Real)
    of Q do return(Type::Rational)
    of Z do return(Type::Integer)
  end_case;
  error("Illegal argument")
end_proc;

// overload solvelib::substituteBySet
// substituteBySet(a, x, S) - returns { a(y): y \in S } for given a(x)


substituteBySet:=
proc(a, x, S: solvelib::BasicSet)

begin
  // simple implementation
  genident();
  Dom::ImageSet(subs(a, x=%), %, S)
end_proc;

// overload solvelib::getElement : zero is in every basic set

getElement:= 0;

// overload solvelib::Union: no basic set depends on any parameter 

Union:=(bset, x, xset) -> bset;


  /*  e n d    o f     m e t h o d s  */


begin

  /* l o c a l  f u n c t i o n s  */


  // plusexpr: add basic set and DOM_IDENT/DOM_EXPR/..
  
  plusexpr:=
  proc(bset, xpr)
    local u,v;
  begin
    case bset
      of C do
        return(C)
      of R do
        if is(xpr, Type::Real)=TRUE then
          return(R)
        else
          u:=genident();
          if length((v:=Im(xpr)))>length(xpr) then
            v:=xpr
          else
            v:=I*v
          end_if;
          return(Dom::ImageSet(v+u, u, R))
        end_if
      of Q do
        if is(xpr, Type::Rational)=TRUE then
          return(Q)
        else
          u:=genident();
          /* simplify xpr by removing some subexpressions ? */
          return(Dom::ImageSet(xpr+u, u, Q))
        end_if
      of Z do
        if is(xpr,Type::Integer) then
          return(Z)
        else
          u:=genident();
          return(Dom::ImageSet(xpr+u),u, Z)
        end_if
    end_case;
  end_proc;


  // multexpr - mult basic set and DOM_IDENT/DOM_EXPR 

multexpr:=
proc(bset, xpr)
  local u,v;
begin
  case bset
    of C do
      return(piecewise([xpr<>0, C], [xpr=0, {0}]))
    of R do
      if is(xpr, Type::Real)=TRUE then
        return(piecewise([xpr<>0, R], [xpr=0, {0}]))
      else
        u:=genident();
        // try to get vector of norm 1 (hopefully simpler ..)
        if length((v:=sign(xpr)))>length(xpr) then
          v:=xpr
        end_if;
        return(Dom::ImageSet(v*u, u, R))
      end_if
    of Q do
      if is(xpr, Type::Rational)=TRUE then
        return(piecewise([xpr<>0, Q], [xpr=0, {0}]))
      else
        u:=genident();
        return(Dom::ImageSet(v*u, u, Q))
      end_if;
    of Z do
      u:=genident();
      return(Dom::ImageSet(u*xpr, u, Z))
  end_case;
end_proc;

end_domain:


// values for special functions



solvelib::BasicSet::sign(Z):={-1,0,1}:
solvelib::BasicSet::sign(Q):={-1,0,1}:
solvelib::BasicSet::sign(R):={-1,0,1}:
solvelib::BasicSet::dirac(Z):= {0, dirac(0)}:
solvelib::BasicSet::dirac(Q):= {0, dirac(0)}:
solvelib::BasicSet::dirac(R):= {0, dirac(0)}:
solvelib::BasicSet::heaviside(Z):= {0, 1, heaviside(0)}:
solvelib::BasicSet::heaviside(Q):= {0, 1, heaviside(0)}:
solvelib::BasicSet::heaviside(R):= {0, 1, heaviside(0)}:

solvelib::BasicSet::print(R):=hold(R_):
solvelib::BasicSet::print(Z):=hold(Z_):
solvelib::BasicSet::print(Q):=hold(Q_):
solvelib::BasicSet::print(C):=hold(C_):

