<?xml version='1.0' encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" 
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
     xmlns:xt="http://www.jclark.com/xt"
     extension-element-prefixes="xt">

<xsl:template match="/">
 <xsl:call-template name="newfile">
  <xsl:with-param name="abc" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
 </xsl:call-template>
</xsl:template>

<xsl:template name="newfile">
 <xsl:param name="abc" />
 <xsl:variable name="letter" select="substring($abc,1,1)" />
 <xsl:variable name="file" select="concat($letter,'-currency.txt')"/>
 <xt:document method="text" href="{$file}" encoding="ISO-8859-1">
  <xsl:for-each select="//country[starts-with(isocurrency, $letter)]">
   <xsl:sort select="shortname"/>
   <xsl:sort select="currency"/>
   <xsl:variable name="Currency" select="normalize-space(string(currency))"/>
   <xsl:if test="($Currency != '-') and ($Currency != '')">
    <xsl:text>The </xsl:text>
    <xsl:value-of select="currency"/>
    <xsl:text> is used by </xsl:text>
    <xsl:variable name="L1" select="substring(citizen,1,1)"/>
    <xsl:choose>
     <xsl:when test="$L1 = 'A' or $L1 = 'E' or $L1 = 'I' or 
                     $L1 = 'O' or $L1 = 'U'">
      <xsl:text>an </xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>a </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="citizen"/>
    <xsl:text> living in </xsl:text>
    <xsl:value-of select="shortname"/>
    <xsl:text>.&#xA;</xsl:text><!-- new line -->
   </xsl:if>
  </xsl:for-each>
  <xsl:call-template name="footer"/>
 </xt:document>
  
 <xsl:if test="string-length($abc) != 1">
  <xsl:call-template name="newfile">
   <xsl:with-param name="abc" select="substring($abc, 2)" />
  </xsl:call-template>
 </xsl:if>
</xsl:template>

<xsl:template name="footer">
 <xsl:text>Last modification : Michel Goossens, </xsl:text>
 <xsl:choose>
  <xsl:when test="function-available('date:to-string') and 
                  function-available('date:new')">
   <!-- date format : Fri Dec 31 23:59:59 PDT 1999 -->
   <!--               1234567890123456789012345678 -->
   <xsl:variable name="datetemp" select="date:to-string(date:new())"/>
   <xsl:variable name="month" select="substring($datetemp,5,3)"/>
   <xsl:variable name="day" select="substring($datetemp,9,2)"/>
   <xsl:variable name="year" select="substring($datetemp,string-length($datetemp)-3,4)"/>
   <xsl:variable name="Date" select="concat($day,' ',$month,'. ',$year)"/>
   <xsl:value-of select="$Date"/>
  </xsl:when>
  <xsl:otherwise>
   <xsl:text>11 Nov. 1999</xsl:text>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

</xsl:stylesheet>
