.\" Copyright (c) 1990-1999  Paul Vojta
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a copy
.\" of this software and associated documentation files (the "Software"), to
.\" deal in the Software without restriction, including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
.\" sell copies of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" PAUL VOJTA BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
.\" IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
'	# small and boldface (not all -man's provide it)
.de SB
\&\fB\s-1\&\\$1 \\$2\s0\fR
..
.TH XDVI 1 "15 February 1999" "X Version 11"
.SH NAME
xdvi \- DVI Previewer for the X Window System
.SH SYNOPSIS
.B xdvi
.nh
[\fB+\fP[\fIpage\fP]] [\fB\-s\fP \fIshrink\fP] [\fB\-S\fP \fIdensity\fP]
#ifgrey
[\fB\-nogrey\fP] [\fB\-gamma\fP \fIg\fP] [\fB\-install\fP] [\fB\-noinstall\fP]
#endif
[\fB\-p\fP \fIpixels\fP]
[\fB\-margins\fP \fIdimen\fP]
[\fB\-sidemargin\fP \fIdimen\fP] [\fB\-topmargin\fP \fIdimen\fP]
[\fB\-offsets\fP \fIdimen\fP]
[\fB\-xoffset\fP \fIdimen\fP] [\fB\-yoffset\fP \fIdimen\fP]
[\fB\-paper\fP \fIpapertype\fP] [\fB\-altfont\fP \fIfont\fP]
#ifmakepk
[\fB\-nomakepk\fP]
#endif
#ifkpathsea
.BI \-mfmode " mode-def\fR[\fP\fB:\fPdpi\fR]\fP"
#endif
#ifnokpathsea
[\fB\-mfmode\fP \fImode-def\fP]
#endif
[\fB\-l\fP]
[\fB\-rv\fP]
#ifbuttons
[\fB\-expert\fP]
[\fB\-shrinkbutton\fP\fIn\fP \fIshrink\fP]
#endif
[\fB\-mgs\fP[\fIn\fP] \fIsize\fP] [\fB\-warnspecials\fP]
[\fB\-hush\fP]
[\fB\-hushchars\fP] [\fB\-hushchecksums\fP]
#ifkpathsea
[\fB\-hushspecials\fP]
#endif
[\fB\-safer\fP]
[\fB\-fg\fP \fIcolor\fP] [\fB\-bg\fP \fIcolor\fP] [\fB\-hl\fP \fIcolor\fP]
[\fB\-bd\fP \fIcolor\fP] [\fB\-cr\fP \fIcolor\fP]
[\fB\-bw\fP \fIwidth\fP]
#ifgrid
[\fB\-grid1\fP \fIcolor\fP] 
[\fB\-grid2\fP \fIcolor\fP] 
[\fB\-grid3\fP \fIcolor\fP]
#endif
[\fB\-bw\fP \fIwidth\fP]
[\fB\-display\fP \fIhost:display\fP] [\fB\-geometry\fP \fIgeometry\fP]
[\fB\-icongeometry\fP \fIgeometry\fP] [\fB\-iconic\fP]
#ifbuttons
[\fB\-font\fP \fIfont\fP]
#endif
[\fB\-keep\fP] [\fB\-copy\fP] [\fB\-thorough\fP]
#ifps
[\fB\-nopostscript\fP]
[\fB\-noscan\fP]
[\fB\-allowshell\fP]
#endif
#ifdps
[\fB\-nodps\fP]
#endif
#ifnews
[\fB\-nonews\fP]
#endif
#ifghost
[\fB\-noghostscript\fP]
[\fB\-nogssafer\fP]
[\fB\-gsalpha\fP]
[\fB\-interpreter\fP \fIpath\fP]
[\fB\-gspalette\fP \fIpalette\fP]
#endif
#ifhyper
[\fB\-underlink\fP]
[\fB\-browser\fP \fIWWWbrowser\fP]
[\fB\-base\fP \fIbase URL\fP]
#endif
[\fB\-debug\fP \fIbitmask\fP] [\fB\-version\fP]
#ifselfile
[\fIdvi_file\fP]
#endif
#ifnoselfile
.I dvi_file
#endif
.hy
.SH DESCRIPTION
.B xdvi
is a program which runs under the X window system. It is used to preview
.I dvi
files, such as are produced by
.BR tex (1).
.PP
This program has the capability of showing the file shrunken by various
(integer) factors, and also has a ``magnifying glass'' which allows one
to see a small part of the unshrunk image momentarily.
.PP
Before displaying any page or part thereof, it checks to see if the
.I dvi
file has changed since the last time it was displayed.  If this is the case,
then
.B xdvi
will reinitialize itself for the new
.I dvi
file.  For this reason, exposing parts of the
.B xdvi
window while \*(Te\& is running should be avoided.  This feature allows you
to preview many versions of the same file while running
.B xdvi
only once.
#ifbuttons
.PP
In addition to using keystrokes to move within the file,
.B xdvi
provides buttons on the right side of the window, which are synonymous
with various sequences of keystrokes.
#endif
#ifps
.PP
.B xdvi
can show PostScript<tm> specials by any of three methods.
It will try first to use Display PostScript<tm>, then NeWS, then it
will try to use Ghostscript to render the images.  All of these options
depend on additional software to work properly; moreover, some of them
may not be compiled into this copy of
.BR xdvi .
.PP
For performance reasons,
.B xdvi
does not render PostScript specials in the magnifying glass.
#endif
#ifselfile
.PP
If
.I dvi_file
is not specified, a file-selection widget is popped up for you to choose the
.I dvi
file.
#endif
.SH OPTIONS
In addition to specifying the
.I dvi
file (with or without the
.B .dvi
extension),
.B xdvi
supports the following command line options.  If the option begins with a
.RB ` + '
instead of a
.RB ` \- ',
the option is restored to its default value.  By default, these options can
be set via the resource names given in parentheses in the description of
each option.
.TP
.BI + page
Specifies the first page to show.  If
.B +
is given without a number, the last page is assumed; the first page is
the default.
#ifps
.TP
.B \-allowshell
.RB ( .allowShell )
This option enables the shell escape in PostScript specials.
(For security reasons, shell escapes are disabled by default.)
This option should be rarely used; in particular it should not be used just
to uncompress files: that function is done automatically if the file name
ends in
.BR .Z ,
.BR .gz ,
or
.BR .bz2
Shell escapes are always turned off if the
.B \-safer
option is used.
#endif
.TP
.BI \-altfont " font"
.RB ( .altFont )
Declares a default font to use when the font in the
.I dvi
file cannot be found.  This is useful, for example, with PostScript <tm> fonts.
.TP
.BI \-background " color"
.RB ( .background )
Determines the color of the background.  Same as
.BR -bg .
#ifhyper
.TP
.BI \-base " base URL"
.RB ( .urlBase )
Sets the base URL value that external links given in the
.I dvi
file are assumed relative to - normally this should be the URL
of the document itself (?).
#endif
.TP
.BI \-bd " color"
.RB ( .borderColor )
Determines the color of the window border.
.TP
.BI \-bg " color"
.RB ( .background )
Determines the color of the background.
.TP
.BI \-bordercolor " color"
Same as
.BR -bd .
.TP
.BI \-borderwidth " width"
.RB ( .borderWidth )
Specifies the width of the border of the window.  Same as
.BR -bw .
#ifhyper
.TP
.BI \-browser " WWWbrowser"
.RB ( .wwwBrowser )
Defines the World Wide Web browser to be used to handle external URL's,
for example mosaic.  If neither the command-line option nor the X
resource are set, uses the environment variable WWWBROWSER.
#endif
.TP
.BI \-bw " width"
.RB ( .borderWidth )
Specifies the width of the border of the window.
.TP
.B \-copy
.RB ( .copy )
Always use the
.I copy
operation when writing characters to the display.
This option may be necessary for correct operation on a color display, but
overstrike characters will be incorrect.
#ifgrey
If greyscale anti-aliasing is in use, the
.B \-copy
operation will disable the use of colorplanes and make overstrikes come
out incorrectly.
#endif
See also
.BR \-thorough .
.TP
.BI \-cr " color"
.RB ( .cursorColor )
Determines the color of the cursor.  The default is the color of the page
border.
.TP
.BI \-debug " bitmask"
.RB ( .debugLevel )
#ifnokpathsea
If nonzero, prints additional debugging information on standard output.
The bitmask should be given as a decimal number.  The values of the bits
are defined in the source file
.BR xdvi.h .
#endif
#ifkpathsea
If nonzero, prints additional information on standard output.  The
number is taken as a set of independent bits.  The meaning of each bit
follows. 1=bitmaps; 2=dvi translation; 4=pk reading; 8=batch
operation; 16=events; 32=file opening; 64=PostScript communication;
128=Kpathsea stat(2) calls; 256=Kpathsea hash table lookups; 512=Kpathsea
path definitions; 1024=Kpathsea path expansion; 2048=Kpathsea searches.
To trace everything having to do with file searching and opening, use 4000.
Some of these debugging options are actually provided by Kpathsea.
See the Debugging section in the Kpathsea manual.
#endif
.TP
.BI \-density " density"
.RB ( .densityPercent )
Determines the density used when shrinking bitmaps for fonts.
A higher value produces a lighter font.  The default value is 40.
#ifgrey
If greyscaling is in use this argument does not apply; use
.B \-gamma
instead.
#endif
See also the
.RB ` S '.
keystroke.
Same as
.BR \-S
.TP
.BI \-display " host" : display
Specifies the host and screen to be used for displaying the
.I dvi
file.  By default this is obtained from the environment variable
.SB DISPLAY.
#ifbuttons
.TP
.B \-expert
.RB ( .expert )
Prevent the buttons from appearing.  See also the
.RB ` x '
keystroke.
#endif
.TP
.BI \-fg " color"
.RB ( .foreground )
Determines the color of the text (foreground).
.TP
.BI \-foreground " color"
Same as
.BR -fg .
#ifbuttons
.TP
.BI \-font " font"
.RB ( *font )
Sets the font for use in the buttons.
#endif
#ifgrey
.TP
.BI \-gamma " gamma"
.RB ( .gamma )
Controls the interpolation of colors in the greyscale anti-aliasing color
palette.  Default value is 1.0.  For 0 <
.I gamma
< 1, the fonts will be lighter (more like the background), and for
.I gamma
> 1, the fonts will be darker (more like the foreground).  Negative
values behave the same way, but use a slightly different algorithm.
For color and greyscale displays; for monochrome, see
.BR \-density .
See also the
.RB ` S '
keystroke
#endif
#ifgrid
.TP
.BI \-grid1 " color"
.RB ( .grid1Color )
Determines the color of level 1 grid (default as foreground)
.TP
.BI \-grid2 " color"
.RB ( .grid2Color )
Determines the color of level 2 grid (default as foreground)
.TP
.BI \-grid3 " color"
.RB ( .grid3Color )
Determines the color of level 3 grid (default as foreground)
#endif
.TP
.BI \-geometry " geometry"
.RB ( *geometry )
Specifies the initial geometry of the window.
#ifghost
.TP
.BI \-gspalette " palette"
.RB ( .palette )
Specifies the palette to be used when using Ghostscript for rendering
PostScript specials.  Possible values are
.BR Color ,
.BR Greyscale ,
and
.BR Monochrome .
The default is
.BR Color .
.TP
.B \-gsalpha
.RB ( .gsAlpha )
Causes
.B Ghostscript
to be called with the
.B x11alpha
driver instead of the
.B x11
driver.  The
.B x11alpha
driver enables anti-aliasing in PostScript figures, for a nicer appearance.
It is available on newer versions of
.BR Ghostscript .
This option can also be toggled with the
.RB ` V '
keystroke.
#endif
.TP
.BI \-hl " color"
.RB ( .highlight )
Determines the color of the page border.  The default is the foreground color.
.TP
.B \-hush
.RB ( .Hush )
Causes
.B xdvi
to suppress all suppressible warnings.
.TP
.B \-hushchars
.RB ( .hushLostChars )
Causes
.B xdvi
to suppress warnings about references to characters which are not defined
in the font.
.TP
.B \-hushchecksums
.RB ( .hushChecksums )
Causes
.B xdvi
to suppress warnings about checksum mismatches between the
.I dvi
file and the font file.
.TP
#ifkpathsea
.B \-hushspecials
.RB ( .hushSpecials )
Causes
.B xdvi
to suppress warnings about
.B \especial
strings that it cannot process.
#endif
.TP
.BI \-icongeometry " geometry"
.RB ( .iconGeometry )
Specifies the initial position for the icon.
.TP
.B \-iconic
.RB ( .iconic )
Causes the
.B xdvi
window to start in the iconic state.  The default is to start with the
window open.
#ifgrey
.TP
.B \-install
.RB ( .install )
If
.B xdvi
is running under a
.B PseudoColor
visual, then (by default) it will check for
.B TrueColor
visuals with more bits per pixel, and switch to such a visual if one exists.
If no such visual exists, it will use the current visual and colormap.  If
.B \-install
is selected, however, it will still use a
.B TrueColor
visual with a greater depth, if one is available; otherwise, it will
install its own colormap on the current visual.  If the current visual is not
.BR PseudoColor ,
then
.B xdvi
will not switch the visual or colormap, regardless of its options.
The default value of the
.B install
resource is the special value,
.BR maybe .
There is no
.B +install
option.  See also
.BR \-noinstall ,
and the GREYSCALING AND COLORMAPS section.
#endif
#ifghost
.TP
.BI \-interpreter " filename"
.RB ( .interpreter )
Use
.I filename
as the Ghostscript interpreter.  By default it uses
.BR @GS_PATH@ .
#endif
.TP
.B \-keep
.RB ( .keepPosition )
Sets a flag to indicate that
.B xdvi
should not move to the home position when moving to a new page.  See also the
.RB ` k '
keystroke.
.TP
.B \-l
.RB ( .listFonts )
Causes the names of the fonts used to be listed.
.TP
.BI \-margins " dimen"
.RB ( .Margin )
Specifies the size of both the top margin and side margin.
This determines the ``home'' position of the page within the window as
follows.  If the entire page fits in the window, then the margin settings
are ignored.  If, even after removing the margins from the left, right,
top, and bottom, the page still cannot fit in the window, then the page
is put in the window such that the top and left margins are hidden, and
presumably the upper left-hand corner of the text on the page will be
in the upper left-hand corner of the window.
Otherwise, the text is centered in the window.
The dimension should be a decimal number optionally followed by
any of the two-letter abbreviations for units accepted by \*(Te\&
.RB ( pt ,
.BR pc ,
.BR in ,
.BR bp ,
.BR cm ,
.BR mm ,
.BR dd ,
.BR cc ,
or
.BR sp ).
By default, the unit will be
.BR @DEFAULT_UNIT@.
See also
.BR \-sidemargin ", " \-topmargin ,
and the keystroke
.RB ` M .'
.TP
#ifkpathsea
.BI \-mfmode " mode-def"
#endif
#ifnokpathsea
.BI \-mfmode " mode-def\fR[\fP\fB:\fPdpi\fR]\fP"
#endif
.RB ( .mfMode )
Specifies a
.I mode-def
string, which can be used in searching for fonts (see ENVIRONMENT, below).
Generally, when changing the
.IR mode-def ,
it is also necessary to change the font size to the appropriate value
for that mode.  This is done by adding a colon and the value in dots per inch;
for example,
.BR "\-mfmode ljfour:600" .
This method overrides any value given by the
.B pixelsPerInch
resource or the
.B \-p
command-line argument.
#ifmakepk
The metafont mode is also passed to
.B metafont
during automatic creation of fonts.
#endif
By default, it is
.BR "@MFMODE@" .
.TP
.BI \-mgs " size"
Same as
.BR \-mgs1 .
.TP
.BI "\-mgs\fR[\fIn\fR]" " size"
.RB ( .magnifierSize\fR[\fIn\fR] )
Specifies the size of the window to be used for the ``magnifying glass''
for Button
.IR n .
The size may be given as an integer (indicating that the magnifying glass
is to be square), or it may be given in the form
.IR width x height .
See the MOUSE ACTIONS section.  Defaults are 200x150, 400x250, 700x500,
1000x800, and 1200x1200.
#ifdps
.TP
.B \-nodps
.RB ( .dps )
Inhibits the use of Display PostScript<tm> for displaying PostScript<tm>
specials.  Other forms of PostScript emulation, if installed, will be used
instead.
(For this option, the logic of the corresponding resource is reversed:
.B \-nodps
corresponds to
.BR dps:off ;
.B +nodps
to
.BR dps:on .)
#endif
#ifghost
.TP
.B \-noghostscript
.RB ( .ghostscript )
Inhibits the use of Ghostscript for displaying PostScript<tm> specials.
(For this option, the logic of the corresponding resource is reversed:
.B \-noghostscript
corresponds to
.BR ghostscript:off ;
.B +noghostscript
to
.BR ghostscript:on .)
#endif
#ifgrey
.TP
.B \-nogrey
.RB ( .grey )
Turns off the use of greyscale anti-aliasing when printing shrunken bitmaps.
(For this option, the logic of the corresponding resource is reversed:
.B \-nogrey
corresponds to
.BR grey:off ;
.B +nogrey
to
.BR grey:on .)
See also the
.RB ` G '
keystroke.
#endif
#ifghost
.TP
.B \-nogssafer
.RB ( .gsSafer )
Normally, if Ghostscript is used to render PostScript specials, the Ghostscript
interpreter is run with the option
.BR \-dSAFER .
The
.B \-nogssafer
option runs Ghostscript without
.BR \-dSAFER .
The
.B \-dSAFER
option in Ghostscript disables PostScript operators such as
.BR deletefile ,
to prevent possibly malicious PostScript programs from having any effect.
If the
.B \-safer
option is specified, then this option has no effect; in that case Ghostscript
is always run with
.BR \-dSAFER .
(For the
.B \-nogssafer
option, the logic of the corresponding resource is reversed:
.B \-nogssafer
corresponds to
.BR gsSafer:off ;
.B +nogssafer
to
.BR gsSafer:on .)
#endif
#ifgrey
.TP
.B \-noinstall
.RB ( .install )
Inhibit the default behavior of switching to a
.B TrueColor
visual if one is available with more bits per pixel than the current visual.
This option corresponds to a resource of
.BR install:off .
There is no
.B +noinstall
option.  See also
.BR \-install ,
and the GREYSCALING AND COLORMAPS section.
#endif
#ifmakepk
.TP
.B \-nomakepk
.RB ( .makePk )
Turns off automatic generation of font files that cannot be found by other
means.
(For this option, the logic of the corresponding resource is reversed:
.B \-nomakepk
corresponds to
.BR makePk:off ;
.B +nomakepk
to
.BR makePK:on .)
#endif
#ifnews
.TP
.B \-nonews
.RB ( .news )
Inhibits the use of NeWS<tm> for displaying PostScript<tm> specials.
Ghostscript, if enabled by the installation, will be used instead.
(For this option, the logic of the corresponding resource is reversed:
.B \-nonews
corresponds to
.BR news:off ;
.B +news
to
.BR news:on .)
#endif
#ifps
.TP
.B \-nopostscript
.RB ( .postscript )
Turns off rendering of PostScript<tm> specials.  Bounding boxes, if known,
will be displayed instead.  This option can also be toggled with the
.RB ` v '
keystroke.
(For this option, the logic of the corresponding resource is reversed:
.B \-nopostscript
corresponds to
.BR postscript:off ;
.B +postscript
to
.BR postscript:on .)
#endif
#ifps
.TP
.B \-noscan
.RB ( .prescan )
Normally, when PostScript<tm> is turned on,
.B xdvi
will do a preliminary scan of the
.I dvi
file, in order to send any necessary header files before sending the
PostScript code that requires them.  This option turns off such prescanning.
(It will be automatically be turned back on if
.B xdvi
detects any specials that require headers.)  (For the
.B \-noscan
option, the logic of the corresponding resource is reversed:
.B \-noscan
corresponds to
.BR prescan:off ;
.B +noscan
to
.BR prescan:on .)
#endif
.TP
.BI \-offsets " dimen"
.RB ( .Offset )
Specifies the size of both the horizontal and vertical offsets of the
output on the page.  By decree of the Stanford \*(Te\& Project,
the default \*(Te\& page origin is always 1 inch over and down from
the top-left page corner, even when non-American paper sizes are used.
Therefore, the default offsets are 1.0 inch.
The argument
.I dimen
should be a decimal number optionally followed by any of the two-letter
abbreviations for units accepted by \*(Te\&
.RB ( pt ,
.BR pc ,
.BR in ,
.BR bp ,
.BR cm ,
.BR mm ,
.BR dd ,
.BR cc ,
or
.BR sp ).
By default, the unit will be
.BR @DEFAULT_UNIT@.
See also
.B \-xoffset
and
.BR \-yoffset .
.TP
.BI \-p " pixels"
.RB ( .pixelsPerInch )
Defines the size of the fonts to use, in pixels per inch.  The
default value is @BDPI@.  This option is provided only for backwards
compatibility; the preferred way of setting the font size is by setting the
Metafont mode at the same time; see the
.B \-mfmode
option.
.TP
.BI \-paper " papertype"
.RB ( .paper )
Specifies the size of the printed page.  This may be of the form
\fIwidth\fBx\fIheight\fR optionally followed by a unit, where
.I width
and
.I height
are decimal numbers giving the width and height of the paper, respectively,
and the unit is any of the two-letter abbreviations for units accepted
by \*(Te\&
.RB ( pt ,
.BR pc ,
.BR in ,
.BR bp ,
.BR cm ,
.BR mm ,
.BR dd ,
.BR cc ,
or
.BR sp ).
By default, the unit will be
.BR @DEFAULT_UNIT@.
There are also synonyms which may be used:
.B us
(8.5x11in),
.B usr
(11x8.5in),
.B legal
(8.5x14in),
.B foolscap
(13.5x17in),
as well as the ISO sizes
.BR a1 - a7 ,
.BR b1 - b7 ,
.BR c1 - c7 ,
.BR a1r - a7r
.RB ( a1 - a7
rotated), etc.  The default size is @DEFAULT_PAGE_SIZE@.
.TP
.B \-rv
.RB ( .reverseVideo )
Causes the page to be displayed with white characters on a black background,
instead of vice versa.
.TP
.BI \-s " shrink"
.RB ( .shrinkFactor )
Defines the initial shrink factor.  The default value is @SHRINK@.  If
.I shrink
is given as 0, then the initial shrink factor is computed so that the
page fits within the window (as if the `s' keystroke were given without
a number).
.TP
.BI \-S " density"
.RB ( .densityPercent )
Same as
.BR \-density ,
.I q.v.
.TP
.B \-safer
.RB ( .safer )
This option turns on all available security options; it is designed for use when
.B xdvi
is called by a browser that obtains a
.I dvi
or \*(Te\& file from another site.
#ifps
In the present case, this option selects
#endif
#ifghost
.B +nogssafer
and
#endif
#ifps
.BR +allowshell .
#endif
#ifnops
In the present case, this option is accepted but has no effect, since
.B xdvi
has been compiled without support for PostScript specials.
#endif
#ifbuttons
.TP
.BI \-shrinkbutton "n shrink"
.RB ( .shrinkButton\fIn\fP )
Specifies that the
.IR n th
button changing shrink factors shall change to shrink factor
.IR factor .
This is not very usefull in the normal run of things.  xdvik scales the
scaling factors according to resolution (currently 300dpi and 600dpi).
Here
.I n
may be a number from 1 to 4.  Typical
.I factors
are powers of 2.
#endif
.TP
.BI \-sidemargin " dimen"
.RB ( .sideMargin )
Specifies the side margin (see
.BR \-margins ).
.TP
.B \-thorough
.RB ( .thorough )
.B xdvi
will usually try to ensure that overstrike characters
.RI ( e.g. ,
.BR \enotin )
are printed correctly.  On monochrome displays, this is always possible
with one logical operation, either
.I and
or
.IR or .
On color displays, however, this may take two operations, one to set the
appropriate bits and one to clear other bits.  If this is the case, then
by default
.B xdvi
will instead use the
.I copy
operation, which does not handle overstriking correctly.  The
.B \-thorough
option chooses the slower but more correct choice.  See also
.BR \-copy .
.TP
.BI \-topmargin " dimen"
.RB ( .topMargin )
Specifies the top and bottom margins (see
.BR \-margins ).
.TP
#ifhyper
.BI \-underlink
.RB ( .underLink )
Underline links.  Default is true.
#endif
.TP
.BI \-version
Print information on the version of
.BR xdvi .
.TP
.B \-warnspecials
.RB ( .warnSpecials )
Causes
.B xdvi
to issue warnings about
.B \especial
strings that it cannot process.
.TP
.BI \-xoffset " dimen"
.RB ( .xOffset )
Specifies the size of the horizontal offset of the output on the page.  See
.BR \-offsets .
.TP
.BI \-yoffset " dimen"
.RB ( .yOffset )
Specifies the size of the vertical offset of the output on the page.  See
.BR -offsets .
.SH KEYSTROKES
.B xdvi
recognizes the following keystrokes when typed in its window.
Each may optionally be preceded by a (positive or negative) number, whose
interpretation will depend on the particular keystroke.
Also, the ``Help'', ``Home'', ``Prior'', ``Next'', and arrow cursor keys
are synonyms for
.RB ` ? ',
.RB ` ^ ',
.RB ` b ',
.RB ` f ',
.RB ` l ',
.RB ` r ',
.RB ` u ',
and
.RB ` d '
keys, respectively.
.TP
.B q
Quits the program.  Control-C and control-D will do this, too.
.TP
.B Q
Quits the program with exit status 2.
.TP
.B n
Moves to the next page (or to the
.IR n th
next page if a number is given).  Synonyms are
.RB ` f ',
Space, Return, and Line Feed.
.TP
.B p
Moves to the previous page (or back
.I n
pages).  Synonyms are
.RB ` b ',
control-H, and Delete.
.TP
.B g
Moves to the page with the given number.  Initially, the first page is assumed
to be page number 1, but this can be changed with the
.RB ` P '
keystroke, below.  If no page number is given, then it goes to the last page.
.TP
.B P
``This is page number
.IR n .''
This can be used to make the
.RB ` g '
keystroke refer to actual page numbers instead of absolute page numbers.
.TP
Control-L
Redisplays the current page.
.TP
.B ^
Move to the ``home'' position of the page.  This is normally the upper
left-hand corner of the page, depending on the margins as described in the
.B \-margins
option, above.
.TP
.B u
Moves up two thirds of a window-full.
.TP
.B d
Moves down two thirds of a window-full.
.TP
.B l
Moves left two thirds of a window-full.
.TP
.B r
Moves right two thirds of a window-full.
.TP
.B c
Moves the page so that the point currently beneath the cursor is moved to
the middle of the window.  It also (gasp!) warps the cursor to the same place.
.TP
.B M
Sets the margins so that the point currently under the cursor is the upper
left-hand corner of the text in the page.  Note that this command itself does
not move the image at all.  For details on how the margins are used, see
the
.B \-margins
option.
.TP
.B s
Changes the shrink factor to the given number.  If no number is given, the
smallest factor that makes the entire page fit in the window will be used.
(Margins are ignored in this computation.)
.TP
.B S
Sets the density factor to be used when shrinking bitmaps.  This should
be a number between 0 and 100; higher numbers produce lighter characters.
#ifgrey
If greyscaling mode is in effect, this changes the value of gamma instead.
The new value of gamma is the given number divided by 100; negative values
are allowed.
#endif
.TP
.B t
Toggles to the next unit in a sorted list of \*(Te\& dimension
units for the popup magnifier ruler.
.TP
.B R
Forces the
.I dvi
file to be reread.  This allows you to preview many versions of the same
file while running
.B xdvi
only once.
.TP
.B k
Normally when
.B xdvi
switches pages, it moves to the home position as well.  The
.RB ` k '
keystroke toggles a `keep-position' flag which, when set, will keep
the same position when moving between pages.  Also
.RB ` 0k '
and
.RB ` 1k '
clear and set this flag, respectively.  See also the
.B \-keep
option.
#ifbuttons
.TP
.B x
Toggles expert mode (in which the buttons do not appear).  Also
.RB ` 0x '
and
.RB ` 1x '
clear and reset this mode, respectively.  See also the
.B \-expert
option.
#endif
#ifgrey
.TP
.B G
This key toggles the use of greyscale anti-aliasing for displaying shrunken
bitmaps.  In addition, the key sequences
.RB ` 0G '
and
.RB ` 1G '
clear and set this flag, respectively.  See also the
.B \-nogrey
option.
.PP
If given a numeric argument that is not 0 or 1, greyscale anti-aliasing is
turned on, and the gamma resource is set to the value divided by
100. E.g.,
.RB ` 150G '
turns on greyscale and sets gamma to 1.5.
#endif
#ifgrid
.TP
.B D
This key toggles the use of grid over the document.
If no number is given, the grid mode toggles. 
By prepending number, 3 grid levels can be set.
The grid in each level is drawn in the colour specified.
See also the
.B \-grid1, \-grid2, 
and
.B \-grid3
options.
#endif
#ifps
.TP
.B v
This key toggles the rendering of PostScript<tm> specials.  If rendering
is turned off, then bounding boxes are displayed when available.
In addition the key sequences
.RB ` 0v '
and
.RB ` 1v '
clear and set this flag, respectively.  See also the
.B \-nopostscript
option.
#endif
#ifghost
.TP
.B V
This key toggles tha anti-aliasing of PostScript<tm> specials when
.B Ghostscript
is used as renderer.  In addition the key sequences
.RB ` 0V '
and
.RB ` 1V '
clear and set this flag, See also the
+.B \-gsalpha
option.
#endif
#ifselfile
.TP
.B F
Read a new 
.I dvi
file. A file-selection widget is popped up for you to choose the dvi
file from.
#endif
.SH MOUSE ACTIONS
If the shrink factor is set to any number other than one, then clicking
#ifkpathsea
mouse button 3 
#endif
#ifnokpathsea
any mouse button
#endif
will pop up a ``magnifying glass'' which shows the unshrunk
image in the vicinity of the mouse click.  This subwindow disappears when
the mouse button is released.  Different mouse buttons produce different sized
windows, as indicated by the
.B \-mgs
option.  Moving the cursor while holding the button down will move the
magnifying glass.
#ifhyper
.PP
If the cursor is on a hypertext link (underlined by default), then
that link overrides the magnifying glass for Buttons 1 and 2.
If Button 1 is clicked over a link, then
.B xdvi
jumps to the target in the current window.  If Button 2 is clicked over a link,
then
.B xdvi
opens a new window on the target.
.PP
More precisely, for internal links, Button 1 jumps in the same window to
the link, while Button 2 starts up a new
.B xdvi
on the link.  For external links to
.I dvi
files, Button 1 changes the current
.B xdvi
to be reading that file, while Button 2 starts a new
.B xdvi
on that file.  For other file types,
.B mime.types
and
.B mailcap
are parsed to determine the viewer; finally, if no suitable
.B mailcap
entry was found, if the
.SB WWWBROWSER
environment variable is set, or
.B \-browser
was specified on the command line, it is started up on the file.
#endif
.PP
The scrollbars (if present) behave in the standard way:  pushing Button 2
in a scrollbar moves the top or left edge of the scrollbar to that point
and optionally drags it;
pushing Button 1 moves the image up or right by an amount equal to the distance
from the button press to the upper left-hand corner of the window; pushing
Button 3 moves the image down or left by the same amount.
.SH SIGNALS
When
.B xdvi
receives a
.SB SIGUSR1
signal, it rereads the
.I dvi
file.
#ifgrey
.SH GREYSCALING AND COLORMAPS
The greyscale anti-aliasing feature in
.B xdvi
will not work at its best if the display does not have enough colors available.
This can happen if other applications are using most of the colormap
(even if they are iconified).  If this occurs, then
.B xdvi
will print an error message and turn on the
.B -copy
option.  This will result in overstrike characters appearing wrong;
it may also result in poor display quality if the number of available
colors is very small.
.PP
Typically this problem occurs on displays that allocate eight bits
of video memory per pixel.  To see how many bits per pixel your display
uses, type
.B xwininfo
in an
.B xterm
window, and then click the mouse on the root window when asked.  The
``Depth:'' entry will tell you how many bits are allocated per pixel.
.PP
Displays using at least 15 bits per pixel are typically
.B TrueColor
visuals, which do not have this problem, since their colormap is
permanently allocated and available to all applications.  (The visual
class is also displayed by
.BR xwininfo .)
For more information on visual classes see the documentation for the
X Window System.
.PP
To alleviate this problem, therefore, one may (a) run with more bits
per pixel (this may require adding more video memory or replacing the video
card), (b) shut down other applications that may be using much of the colormap
and then restart
.BR xdvi ,
or (c) run
.B xdvi
with the
.B \-install
option.
.PP
One application which is often the cause of this problem is
.BR Netscape .
In this case there are two more alternatives to remedying the situation.
One can run
.RB `` "netscape -install" ''
to cause
.B Netscape
to install a private colormap.  This can cause colors to change in
bizarre ways when the mouse is moved to a different window.
Or, one can run
.RB `` "netscape -ncols 220" ''
to limit
.B Netscape
to a smaller number of colors.  A smaller number will ensure that
other applications have more colors available, but will degrade the
color quality in the
.B Netscape
window.
#endif
#ifkpathsea
.SH ENVIRONMENT
Please see the
.B kpathsea
documentation.
#endif

#ifps
.SH HANDLING OF POSTSCRIPT FIGURES
.B xdvi
can display PostScript files included in the
.I dvi
file.  Such files are first searched for in the directory where the
.I dvi
file is, and then using normal
.B Kpathsea
rules.  There is an exception to this, however:  if the file name begins
with a backtick
.RB ( ` ),
then the remaining characters in the file name give a shell command (often
.BR zcat )
which is executed; its standard output is then sent to be interpreted as
PostScript.  Note that there is some potential for security problems here;
see the
.B \-allowshell
command-line option.  It is better to use compressed files directly (see below).
.PP
If a file name is given (as opposed to a shell command),
if that file name ends in
.RB `` .Z '',
.RB `` .gz '',
or
.RB `` .bz2 ''
and if the first two bytes of the file indicate that it was compressed with
.BR compress (1),
.BR gzip (1),
or
.BR bzip2 (1)
respectively, then the file is first uncompressed with
.BR "uncompress \-c" ,
.BR "gunzip \-c" ,
or
.BR "bunzip2 \-c" ,
respectively.  This is preferred over using a backtick to call the command
directly, since you do not have to specify
.B \-allowshell
and since it allows for path searching.
#endif
.SH ENVIRONMENT
.B xdvik
uses the same environment variables and algorithms for finding
font files as \*(Te\& and friends.  See the documentation for the
.B Kpathsea
library for details (repeating it here is too cumbersome).  In addition,
.B xdvik
accepts the following variables:
.TP
.SB DISPLAY
Specifies which graphics display terminal to use.
#ifnokpathsea
.TP
.SB XDVISIZES
A list of font resolutions separated by colons.  If a font cannot be found
or made at its stated size, then these sizes are tried as a fallback.
See the `Fallback font' section in the
.B Kpathsea
manual for more details.
.B xdvi
tries the actual size of the font before trying any of the given sizes.
Each font resolution should be a positive integer, specifying the number
of dots per inch, or a string of the form
.BR magstep\fIn\fP ,
where
.I n
is a number -9.5, -9, -8.5, ..., 8, 8.5, 9, or 9.5.  The string
.B magstep
may be shortened to any non-empty initial substring (so that
.B magstep0.5
may be shortened to
.B mag0.5
or
.B m0.5
(but not
.BR mag.5 )).
The entries
.BI magstep n
signify the current pixels-per-inch value, multiplied by 1.2 raised to the
.IR n th
power, and rounded to the nearest integer.
If the list begins with a colon, the system default sizes are used, as well.
Sizes are expressed in dots per inch and must be integers.
The current default set of sizes is @DEFAULT_FONT_SIZES@.
#endif
.TP
.SB KPATHSEA_DEBUG
Trace
.B Kpathsea
lookups; set it to
.B -1
for complete tracing.
.TP
.SB MIMELIBDIR
Directory containing the
.B mime.types
file, if
.B ~/.mime-types
does not exist.
.TP
.SB MAILCAPDIR
Directory containing the
.B .mailcap
file, if
.B ~/.mailcap
does not exist.
#ifhyper
.TP
.SB WWWBROWSER
The browser used to open URL's, if neither the
.B \-browser
option nor the
.B .wwwBrowser
resource are set.  For more information on hyper-\*(Te\& support,
see the `Hypertext' node in the
.B dvipsk
manual.
#endif
#ifps
.TP
.SB TMPDIR
The directory to use for storing temporary files created when uncompressing
PostScript files.
#ifps
.SH LIMITATIONS
.B xdvi
accepts many but not all types of PostScript specials accepted by
.BR dvips .
For example, it accepts most specials generated by
.B epsf
and
.BR psfig ,
It does not, however, support
.B bop\-hook
or
.BR eop\-hook ,
nor does it allow PostScript commands to affect the rendering of things that
are not PostScript (for example, the ``NEAT'' and rotated ``A'' examples in the
.B dvips
manual).  These restrictions are due to the design of
.BR xdvi ;
in all likelihood they will always remain.
.PP
La\*(Te\&2e color and rotation specials are not currently supported.
#endif
.SH FILES
Please see the kpathsea documentation.
.SH COPYRIGHTS
.B xdvi
itself is Copyrighted by Paul Vojta and distributed under the X-Consortium
license.
.B xdvi
uses the 
.B libwww
library of the World Wide Web Consortium, which includes computer software
creaded and made available by CERN.  It also uses the
.B kpathsea
library which is distributed under the GNU LIBRARY General Public License.
.PP
THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL PAUL VOJTA OR ANY OTHERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.SH SEE ALSO
.BR X (1),
.BR dvips (1),
.BR Kpathsea documentation
.SH AUTHORS
Eric Cooper, CMU, did a version for direct output to a QVSS. Modified
for X by Bob Scheifler, MIT Laboratory for Computer Science. Modified
for X11 by Mark Eichin, MIT SIPB. +Additional enhancements by many
others.  The current maintainer of the original
.B xdvi
is Paul Vojta, U.C. Berkeley; the maintainer of the
.B xdvik
variant is Nicolai Langfeldt, Dept. of Math, UiO, Norway, with the help
of many others.
