/*
 * dui-paper.c - a module for paper selection UI
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/param.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>

#include "libdvi29.h"
#include "defs.h"
#include "dev.h"
#include "cf-xmdvi.h"
#include "resource.h"
#include "paper.h"
#include "window.h"
#include "ui.h"

Private Widget  dialog_paper_selection; 

Private void  cb_orientation(Widget,int,caddr_t);
Private void  cb_paper_select(Widget,int,caddr_t);
Private Widget   make_selection_paper(Widget);
Private Widget   make_selection_orient(Widget);


Public Widget
x_make_panel_paper(Widget parent)
{
  Widget  xfm, xtitle, xb_close, xsep1, xrc;
  Widget  xlb_paper, xlb_orient, xsel_paper, xsel_orient;
  Arg     args[10];
  int     i;

  i = 0;
  XtSetArg(args[i], XmNdialogStyle, XmDIALOG_MODELESS); i++;
  dialog_paper_selection
    = XmCreateBulletinBoardDialog(parent, "Paper Selection", args, i);

  xfm = XmCreateForm(dialog_paper_selection, "paperSelect", NULL, 0);
  XtManageChild(xfm);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Paper Selection", XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  xtitle = XmCreateLabel(xfm, "title", args, i);
  XtManageChild(xtitle);
  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Close", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_NONE);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  xb_close  = XmCreatePushButton(xfm, "close", args, i);
  XtAddCallback(xb_close, XmNactivateCallback, 
		(XtCallbackProc)cb_paper_close, NULL);
  XtManageChild(xb_close);

  xsep1 = x_p_make_hsep(xfm);
  x_p_put_below(xsep1, xtitle);
  x_p_put_below(xsep1, xb_close);

  i = 0;
  XtSetArg(args[i], XmNorientation, XmVERTICAL);  i++;
  XtSetArg(args[i], XmNpacking, XmPACK_COLUMN);  i++;
  XtSetArg(args[i], XmNnumColumns, 2);  i++;
  XtSetArg(args[i], XmNentryAlignment, XmALIGNMENT_CENTER);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
  xrc = XmCreateRowColumn(xfm, "choise", args, i);

  XtSetArg(args[0], XmNlabelString, 
	   XmStringCreate("Paper Size: ", XmSTRING_DEFAULT_CHARSET));
  xlb_paper = XmCreateLabel(xrc, "paperLabel", args, 1);
  XtManageChild(xlb_paper);
  XtSetArg(args[0], XmNlabelString, 
	   XmStringCreate("Orientation: ", XmSTRING_DEFAULT_CHARSET));
  xlb_orient = XmCreateLabel(xrc, "orientLabel", args, 1);
  XtManageChild(xlb_orient);
  xsel_paper  = make_selection_paper(xrc);
  XtManageChild(xsel_paper);
  xsel_orient = make_selection_orient(xrc);
  XtManageChild(xsel_orient);

  XtManageChild(xrc);
  x_p_put_below(xrc, xsep1);

  return dialog_paper_selection;
}

struct  paper_size {
  char  *label; 
  char  *resource;
  int   paper_id;
  XmString  xlabel;
};
Private struct paper_size paper_table[] = {
  {"A1", "a1", A1_PAPER},    {"A2", "a2", A2_PAPER}, 
  {"A3", "a3", A3_PAPER},    {"A4", "a4", A4_PAPER}, 
  {"A5", "a5", A5_PAPER},    {"A6", "a6", A6_PAPER}, 
  {"A7", "a7", A7_PAPER},
  {"B1", "b1", B1_PAPER},    {"B2", "b2", B2_PAPER}, 
  {"B3", "b3", B3_PAPER},    {"B4", "b4", B4_PAPER}, 
  {"B5", "b5", B5_PAPER},    {"B6", "b6", B6_PAPER}, 
  {"B7", "b7", B7_PAPER},
  {"Letter", "leter", LETTER_PAPER}, 
  {"US",     "us",    US_PAPER},
  {"Legal",  "legal", LEGAL_PAPER},
  {NULL, NULL, -1}
};

Private Widget
make_selection_paper(Widget parent)
{
  Widget   xoptm, xrc, x_menu, xb_p[20];
  Arg      args[10];
  int      i, b;

  xrc = XmCreateRowColumn(parent, "paper", NULL, 0);
  XtManageChild(xrc);

  x_menu = XmCreatePulldownMenu(xrc, "selection", NULL, 0);
  for (b = 0; paper_table[b].label != NULL; b++){
    XtSetArg(args[0], XmNlabelString, 
	     XmStringCreate(paper_table[b].label, XmSTRING_DEFAULT_CHARSET)); 
    XtSetArg(args[1], XmNhighlightThickness, 0);
    xb_p[b] = XmCreatePushButton(x_menu, paper_table[b].resource, args, 2);
    XtAddCallback(xb_p[b], XmNactivateCallback, 
		  (XtCallbackProc)cb_paper_select, 
		  (XtPointer)(paper_table[b].paper_id)); 
  }
  XtManageChildren(xb_p, b);

  for (b = 0; paper_table[b].paper_id >= 0; b++){
    if (paper_table[b].paper_id == PAPER_BASIC_ID(RES(DviDev,paper)))
      break;
  }
  if (paper_table[b].paper_id < 0)
    b = 0;
  i = 0;
  XtSetArg(args[i], XmNsubMenuId, x_menu); i++;
  XtSetArg(args[i], XmNmenuHistory, xb_p[b]); i++;
  xoptm = XmCreateOptionMenu(xrc, "menu", args, i);
  XtManageChild(xoptm);

  return xoptm; 
}

struct  s_ori {
  char  *label; 
  char  *resource;
  int   ori;
};
Private struct s_ori ori_table[] = {
  {"Portrait",  "port", PAPER_ORIENTAION_PORT},
  {"Landscape", "land", PAPER_ORIENTAION_LAND},
  {NULL, NULL, -1}
};

Private Widget 
make_selection_orient(Widget parent)
{
  Widget    xoptm, xrc, x_menu, xb_p[20];
  Arg       args[10];
  int       i, b;

  xrc = XmCreateRowColumn(parent, "orientation", NULL, 0);
  XtManageChild(xrc);

  x_menu = XmCreatePulldownMenu(xrc, "selection", NULL, 0);
  for (b = 0; ori_table[b].label != NULL; b++){
    XtSetArg(args[0], XmNlabelString, 
	     XmStringCreate(ori_table[b].label, XmSTRING_DEFAULT_CHARSET)); 
    XtSetArg(args[1], XmNhighlightThickness, 0);
    xb_p[b] = XmCreatePushButton(x_menu, ori_table[b].resource, args, 2);
    XtAddCallback(xb_p[b], XmNactivateCallback, 
		  (XtCallbackProc)cb_orientation, 
		  (XtPointer)(ori_table[b].ori)); 
  }
  XtManageChildren(xb_p, b);

  for (b = 0; ori_table[b].ori >= 0; b++){
    if (ori_table[b].ori == RES(DviDev,orient))
      break;
  }
  if (ori_table[b].ori < 0)
    b = 0;
  i = 0;
  XtSetArg(args[i], XmNsubMenuId, x_menu); i++;
  XtSetArg(args[i], XmNmenuHistory, xb_p[b]); i++;
  xoptm = XmCreateOptionMenu(xrc, "menu", args, i);
  XtManageChild(xoptm);

  return xoptm; 
}

Public void
cb_paper(Widget w, caddr_t d1, caddr_t d2)
{
  if (XtIsManaged(dialog_paper_selection)){
    XtUnmanageChild(dialog_paper_selection);
  } else {
    ui_close_panel_all();
    XtManageChild(dialog_paper_selection);
  }
}

Public void
cb_paper_close(Widget w, caddr_t d1, caddr_t d2)
{
  if (XtIsManaged(dialog_paper_selection))
    XtUnmanageChild(dialog_paper_selection);
}


Private void  
cb_orientation(Widget w, int ori, caddr_t d2)
{
  if (RES(DviDev,orient) == ori)
    return;

  RES(DviDev,orient) = (int)ori;
  ui_preview_paper_change(NULL, NULL);
  x_ui_command = UI_CMD_PAGE;
}

Private void  
cb_paper_select(Widget w, int paper, caddr_t d2)
{
  if (PAPER_BASIC_ID(RES(DviDev,paper)) == paper)
    return;
  
  RES(DviDev,paper) = (int)paper;
  ui_preview_paper_change(NULL, NULL);
  x_ui_command = UI_CMD_PAGE;
}

