/*
 * resource.h - a header file for resource.c
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */


Import struct s_resource  Resource;

#define VISUAL_MONO       1 
#define VISUAL_MONO_STR     "Monochrome"
#define VISUAL_GRAY       2
#define VISUAL_GRAY_STR     "Grayscale"
#define VISUAL_RGB        3
#define VISUAL_RGB_STR      "RGB"


struct s_resource {
  /* DVI file */
  char *dvi_file;
  char *vflibcap;      /* vflibcap path */

  char *s_dpi;         /* dpi */
  int  dpi;

  char *kpathsea_mode; /* kpathsea mode name */

  char *s_offset_x;    /* offset */
  float  offset_x; 
  char *s_offset_y;
  float  offset_y; 

  char *s_shrink;      /* shrink factor */
  double  shrink; 

  char *s_paper;       /* paper size */
  int  paper;
  char *s_orient;      /* orientation */
  int  orient; 

  char *color_char;    /* character color */
  char *color_paper;   /* paper color */
  char *color_back;    /* background color */
  char *color_frame;   /* frame color */

  char *s_page_cache;  /* page cache size */
  int  page_cache; 
  char *s_poll;        /* polling interval for user input */
  int  poll;

  char *s_eps_style;   /* LaTeX style files for EPS figs */
  int  eps_style;
  char *s_draw_eps;    /* draw or skip EPS filg */
  Bool  draw_eps;

  char *s_visual_text;  
  int   visual_text;
  char *s_visual_eps;  
  int   visual_eps;

  char *gs_path;       /* Ghostscript path name */
  char *s_gs_timeout;  /* Ghostscript process timeout */
  int  gs_timeout;

  char *temp_dir;      /* temporary directory */
};


Import void  get_default_application_resources(void);
Import void  get_application_resources(void);
Import int   resource_check(void);
Import void  resource_conv(void);

/*EOF*/

