/*  XGDVI
 *  Copyright (C) 1999-2001  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Edition History
 *  12 Dec 2001   First implementation.
 *
 */

#ifndef __IMGCACHE_H__

#define __IMGCACHE_H__

typedef  struct s_imgcache_cftbl   *IMGCACHE_CFTBL;
struct s_imgcache_cftbl {
  long    key;
  long    mag;
  char   *cfname;
  long    width, height;
  long    pos_x, pos_y;
};

typedef  struct s_imgcache    *IMGCACHE;
struct s_imgcache {
  int             cftbl_size;
  IMGCACHE_CFTBL  cftbl;
  long            mag;
};


extern IMGCACHE  imgcache_new(void);
extern void      imgcache_dispose(IMGCACHE ic);

extern void      imgcache_purge(IMGCACHE ic);
extern int       imgcache_search(IMGCACHE ic, long key, long mag);
extern guchar   *imgcache_is_cached(IMGCACHE ic, long key, double m, 
				    int *type_p, long *width_p, long *height_p,
				    long *pos_x_p, long *pos_y_p);
extern void      imgcache_free_img(guchar *img, int type);
extern void      imgcache_do_cache(IMGCACHE ic, long key, double m,
				   int type, guchar *img, 
				   long width, long height,
				   long pos_x, long pos_y);

#endif


/*EOF*/
