/*
 * xgdvi -  TeX DVI previewer with GTK 
 *
 *  Copyright (C) 1999  Hirotsugu Kakugawa. All rights reserved. 
 *  See "COPYING" for distribution of this software. 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"
#include "../with.h"

#include <stdio.h>
#include <stdlib.h>
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif
#if HAVE_STDARG_H
#  include <stdarg.h>
#else
#  include <vararg.h>
#endif
#if HAVE_SYS_TYPES_H
#  include <sys/types.h>
#endif
#if HAVE_SYS_STAT_H
#  include <sys/stat.h>
#endif
#include <ctype.h>
#if WITH_GETTEXT
#  include <libintl.h>
#endif

#include <glib.h>
#include <gtk/gtk.h>

#include "libdvi29.h"
#include "defs.h"
#include "xgdvi.h"
#include "files.h"
#include "gui.h"

extern guint  ctl_chan;

static void   run_stdin_cmmand(int argc, char **argv);
static int    readline_buffering(int fd, char *s, int n, int rf);
static int    tokenize_string(char **argv, int nargv, char *cmdline);


void
event_command_input(gpointer data, gint fd, GdkInputCondition cond)
{
  char  buff[BUFSIZ], *argv[32], *p;
  int  argc, j;

  j = readline_buffering(fd, buff, BUFSIZ, 1);
  while (j > 0){
    if ((argc = tokenize_string(argv, 32, buff)) == 0)
      break;
    for (p = argv[0]; *p != '\0'; p++)
      *p = (char)tolower((int)*p);
    run_stdin_cmmand(argc, argv);
    j = readline_buffering(fd, buff, BUFSIZ, 0);
  }
  return;
}

static void 
run_stdin_cmmand(int argc, char **argv)
{
  static int   start_page = 1;
  char  resp[256], *response, *errmsg; 
  int      need_resp; 
  double   s;

  errmsg = NULL;
  response = NULL;
  need_resp = 0;

#if 0
  printf("<<%s>>\n", argv[0]);
#endif

  if ((strcmp(argv[0], "quit") == 0)
      || (strcmp(argv[0], "q") == 0)){
    gtk_main_quit();
    exit(0);

  } else if (strcmp(argv[0], "file") == 0){
    if (argc > 1){
      find_file(argv[1]);
    } else {
      errmsg = "No file name";
    }
    start_page = 1;

  } else if (strcmp(argv[0], "reload") == 0){
    reload_file();

  } else if ((strcmp(argv[0], "page-next") == 0)
	     || (strcmp(argv[0], "next") == 0)
	     || (strcmp(argv[0], "n") == 0)){
    if ((dvi != NULL) && (page < dvi->pages))
      goto_page(page + 1); 
    else
      errmsg = "Can't go to the page";

  } else if ((strcmp(argv[0], "page-prev") == 0)
	     || (strcmp(argv[0], "prev") == 0)
	     || (strcmp(argv[0], "p") == 0)){
    if ((dvi != NULL) && (1 < page))
      goto_page(page - 1);
    else
      errmsg = "Can't go to the page";

  } else if ((strcmp(argv[0], "page-begin") == 0)
	     || (strcmp(argv[0], "<") == 0)){
    if (dvi != NULL)
      goto_page(1); 
    else
      errmsg = "Can't go to the page";

  } else if ((strcmp(argv[0], "page-end") == 0)
	     || (strcmp(argv[0], ">") == 0)){
    if (dvi != NULL)
      goto_page(dvi->pages); 
    else
      errmsg = "Can't go to the page";

  } else if ((strcmp(argv[0], "goto-page") == 0)
	     || (strcmp(argv[0], "g") == 0)){
    if ((argc > 1) && (dvi != NULL) && (atoi(argv[1]) > 0))
      goto_page(atoi(argv[1])); 
    else
      errmsg = "Can't go to the page";
    
  } else if (strcmp(argv[0], "start-page") == 0){
    if ((argc > 1) && (atoi(argv[1]) > 0))
	start_page = atoi(argv[1]);
    else
      start_page = 1;

  } else if ((strcmp(argv[0], "total-pages") == 0)
	     || (strcmp(argv[0], "#") == 0)){
    need_resp = 1;
    if (dvi != NULL)
      sprintf(resp, "%d", dvi->pages);
    else 
      sprintf(resp, "%d", 0);
    response = resp;

  } else if ((strcmp(argv[0], "current-page") == 0)
	     || (strcmp(argv[0], "?") == 0)){
    need_resp = 1;
    if (dvi != NULL)
      sprintf(resp, "%d", page);
    else 
      sprintf(resp, "%d", 0);
    response = resp;

  } else if ((strcmp(argv[0], "zoom-in") == 0)
	     || (strcmp(argv[0], "]") == 0)){
    s = shrink * 8/10;
    if ((1 <= s) && (s <= 128)){
      ui_cmd = CMD_DRAW_PAGE;
      shrink = s;
      resize_window();
    }

  } else if ((strcmp(argv[0], "zoom-out") == 0)
	     || (strcmp(argv[0], "[") == 0)){
    s = shrink * 10/8;
    if ((1 <= s) && (s <= 128)){
      ui_cmd = CMD_DRAW_PAGE;
      shrink = s;
      resize_window();
    }

  } else if ((strcmp(argv[0], "home") == 0)
	     || (strcmp(argv[0], "h") == 0)){
    preview_window_set_pos(0.0, 0.0);

  } else if ((strcmp(argv[0], "center") == 0)
	     || (strcmp(argv[0], "c") == 0)){
    preview_window_set_pos_center(0.5, 0.5);

  } else if ((strcmp(argv[0], "posision") == 0)
	     || (strcmp(argv[0], "pos") == 0)
	     || (strcmp(argv[0], "xy") == 0)){
    if ((argc > 2) 
	&& (0 <= atoi(argv[1])) && (atoi(argv[1]) <= 100)
	&& (0 <= atoi(argv[2])) && (atoi(argv[2]) <= 100))
      preview_window_set_pos_center(0.01*atoi(argv[1]), 0.01*atoi(argv[2]));
    else
      errmsg = "Positions must be 0 .. 100";

  } else if ((strcmp(argv[0], "posision-x") == 0)
	     || (strcmp(argv[0], "pos-x") == 0)
	     || (strcmp(argv[0], "x") == 0)){
    if ((argc > 1) 
	&& (0 <= atoi(argv[1])) && (atoi(argv[1]) <= 100))
      preview_window_set_pos_center(0.01 * atoi(argv[1]), -1.0);
    else
      errmsg = "Position must be 0 .. 100";

  } else if ((strcmp(argv[0], "posision-y") == 0)
	     || (strcmp(argv[0], "pos-y") == 0)
	     || (strcmp(argv[0], "y") == 0)){
    if ((argc > 1) 
	&& (0 <= atoi(argv[1])) && (atoi(argv[1]) <= 100))
      preview_window_set_pos_center(-1.0, 0.01 * atoi(argv[1]));
    else
      errmsg = "Position must be 0 .. 100";

  } else if (strcmp(argv[0], "paper-size") == 0){
    if ((argc > 1) && (DVI_parse_paper_size(argv[1], NULL, NULL) >= 0)){
      paper = paper_id(argv[1]);
      resize_window();
    } else {
      errmsg = "Unknown paper size";
    }

  } else if ((strcmp(argv[0], "orientation") == 0)
	     || (strncmp(argv[0], "or", 2) == 0)){
    if (argc > 1){
      orient = (argv[1][0] == 'p') ? ORI_PORT : ORI_LAND;
      resize_window();
    }
  } else if ((strcmp(argv[0], "portrait") == 0)
	     || (strncmp(argv[0], "port", 4) == 0)){
    orient = ORI_PORT;
    resize_window();
  } else if ((strcmp(argv[0], "landscape") == 0)
	     || (strncmp(argv[0], "land", 4) == 0)){
    orient = ORI_LAND;
    resize_window();
    
  } else if ((strcmp(argv[0], "show-file-panel") == 0)
	     || (strncmp(argv[0], "show-file", 9) == 0)){
    show_FileSelection();
  } else if ((strcmp(argv[0], "hide-file-panel") == 0)
	     || (strncmp(argv[0], "hide-file", 9) == 0)){
    hide_FileSelection();
  } else if ((strcmp(argv[0], "show-paper-panel") == 0)
	     || (strncmp(argv[0], "show-paper", 10) == 0)){
    show_PaperSelection();
  } else if ((strcmp(argv[0], "hide-paper-panel") == 0)
	     || (strncmp(argv[0], "hide-paper", 10) == 0)){
    hide_PaperSelection();
  } else if ((strcmp(argv[0], "show-buffer-panel") == 0)
	     || (strncmp(argv[0], "show-buffer", 11) == 0)){
    show_BufferSelection();
  } else if ((strcmp(argv[0], "hide-buffer-panel") == 0)
	     || (strncmp(argv[0], "hide-buffer", 11) == 0)){
    hide_BufferSelection();
  } else if ((strcmp(argv[0], "show-printer-panel") == 0)
	     || (strncmp(argv[0], "show-printer", 12) == 0)){
    show_Printer();
  } else if ((strcmp(argv[0], "hide-printer-panel") == 0)
	     || (strncmp(argv[0], "hide-printer", 12) == 0)){
    hide_Printer();
  } else if ((strcmp(argv[0], "show-license-panel") == 0)
	     || (strncmp(argv[0], "show-license", 12) == 0)){
    show_License();
  } else if ((strcmp(argv[0], "hide-license-panel") == 0)
	     || (strncmp(argv[0], "hide-license", 12) == 0)){
    hide_License();

  } else if (strcmp(argv[0], "help") == 0){
    response = "Usage:\n"
      "    quit\n"
      "    start-page PAGE\n"
      "    file FILENAME \n"
      "    total-pages\n"
      "    paper-size PAPERNAME\n"
      "    orientation ORIENT  (portrait or landscape)\n"
      "    portrait\n"
      "    landscape\n"
      "    reload\n"
      "    show-file-panel\n"
      "    hide-file-panel\n"
      "    show-buffer-panel\n"
      "    hide-buffer-panel\n"
      "    show-paper-panel\n"
      "    hide-paper-panel\n"
      "    show-printer-panel\n"
      "    hide-printer-panel\n"
      "    show-license-panel\n"
      "    hide-license-panel\n"
      "    page-next\n"
      "    page-prev\n"
      "    page-begin\n"
      "    page-end\n"
      "    goto-page PAGE\n"
      "    current-page\n"
      "    zoom-in\n"
      "    zoom-out\n"
      "    home\n"
      "    center\n"
      "    position X Y    (0...100, 0...100)\n"
      "    position-x X    (0...100)\n"
      "    position-y Y    (0...100)\n"
      "    help\n";
    need_resp = 1;
  } else {
    errmsg = "Unknow command";
  }

  if (ui_cmd == CMD_DRAW_PAGE){
    draw_page();
  }

  if (errmsg != NULL)
    printf("ERROR\n%s\n.\n", errmsg);
  if (need_resp == 1){
    if (response == NULL)
      printf("OK\n.\n");
    else
      printf("OK\n%s\n.\n", response);
  }
}


static int
readline_buffering(int fd, char *s, int n, int rf)
{
  static int   in = 0;
  static int   out = 0;
  static int   room = BUFSIZ-1;
  static char  buff[BUFSIZ];
  char subbuff[BUFSIZ+1];
  int  line, rn, i;

  if (n == 0)
    return 0;

  if ((rf == 1) && (room > 0)){
    if ((rn = read(fd, subbuff, room)) <= 0){
      if (ctl_chan >= 0){
	gtk_input_remove(ctl_chan);
	ctl_chan = -1;
      }
    } else {
      for (i = 0; i < rn; i++){
	buff[in] = subbuff[i];
	in = (in + 1) % BUFSIZ;
	room--;
      }
    }
  }

#if 0
  printf("[");
  for (i = out; i != in; i = (i+1) % BUFSIZ){
    if (isprint(buff[i]))
      printf("%c", buff[i]);
    else
      printf("\\0x%02x", buff[i]);
  }
  printf("]\n");
#endif

  line = 0;
  for (i = out; i != in; i = (i+1) % BUFSIZ){
    if (buff[i] == '\n'){
      line = 1;
      break;
    }
  }

  if (line == 0){
    i = 0;
  } else {
    for (i = 0; out != in; i++){
      if (i == n-1)
	break;
      s[i] = buff[out];
      out = (out+1) % BUFSIZ ;
      room++;
      if (s[i] == '\n')
	break;
    }
  }
  s[i] = '\0';

  return i;
}

static int
tokenize_string(char **argv, int nargv, char *cmdline)
{
  int  argc, idx;

  idx = 0;
  for (argc = 0; argc < nargv-1; ){
    while (isspace(cmdline[idx]))
      idx++;
    if (cmdline[idx] == '\0')
      break;
    argv[argc] = &cmdline[idx];
    argc++;
    while (!isspace(cmdline[idx]) && (cmdline[idx] != '\0'))
      idx++;
    if (cmdline[idx] == '\0')
      break;
    cmdline[idx++] = '\0';
  }
  argv[argc] = NULL;

  return argc;
}
