/*
 * ui.h - a header file for UI
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#define PREVIEW_MAG_DEN     12
#define PREVIEW_MAG_NUM     10
#define PREVIEW_MINIMUM_H   50
#define PREVIEW_MINIMUM_V   50

extern void   cmd_goto_page(int);
extern void   cmd_page_prev(int);
extern void   cmd_page_next(int);
extern void   cmd_find_file(void);
extern void   cmd_reload(void);
extern void   cmd_quit(void);
extern void   cmd_quit_anyway(void);
extern void   cmd_redraw(void);
extern void   cmd_preview_move_h(int);
extern void   cmd_preview_move_v(int);
extern void   cmd_magnify_enlarge(void);
extern void   cmd_magnify_shrink(void);
extern void   cmd_preview_enlarge(void);
extern void   cmd_preview_shrink(void);
extern void  ui_set_page_jump_range(void);

extern void  cb_reload(Widget,caddr_t,caddr_t);
extern void  cb_print(Widget,caddr_t,caddr_t);
extern void  cb_option(Widget,caddr_t,caddr_t);
extern void  cb_mag(Widget,caddr_t,caddr_t);
extern void  cb_file(Widget,caddr_t,caddr_t);
extern void  cb_paper(Widget,caddr_t,caddr_t);
extern void  cb_quit(Widget,caddr_t,caddr_t);

extern void  ui_close_panel_all(void);
extern void  cb_print_close(Widget,caddr_t,caddr_t);
extern void  cb_option_close(Widget,caddr_t,caddr_t);
extern void  cb_mag_close(Widget,caddr_t,caddr_t);
extern void  cb_file_close(Widget,caddr_t,caddr_t);
extern void  cb_paper_close(Widget,caddr_t,caddr_t);
extern void  cb_quit_close(Widget,caddr_t,caddr_t);

extern int   x_make_panel(Widget);
extern Widget  x_make_panel_file(Widget);
extern Widget  x_make_panel_paper(Widget);
extern Widget  x_make_panel_mag(Widget);
extern Widget  x_make_panel_print(Widget);
extern Widget  x_make_panel_option(Widget);
extern Widget  x_make_panel_quit(Widget);
extern void  x_p_put_top(Widget);
extern void  x_p_put_below(Widget,Widget);
extern void  x_p_put_right(Widget,Widget);
extern void  x_p_put_left(Widget,Widget);
extern void  x_p_put_rightmost(Widget);
extern void  x_p_put_leftmost(Widget);
extern void  x_p_put_center(Widget);
extern Widget  x_p_make_hsep(Widget);
extern Widget  x_p_make_vsep(Widget);

/* Preview Window */
extern int   x_make_preview(Widget);
extern void  x_widget_short_cut(Widget,EventMask);
extern void    ui_preview_paper_change(int*,int*);
extern void    ui_preview_mag_changed(int*,int*);

