#include <locale.h>
#include <stdio.h>
#include <stdarg.h>
#include "clocale.h"

/* Note that these functions aren't thread safe... */

int fscanf_C (FILE *in,
              char *format,
              ...)
{
  gchar   *old_locale = g_strdup (setlocale (LC_NUMERIC, NULL));
  va_list  args;
  int      result;

  setlocale (LC_NUMERIC, "C");  

  va_start (args, format);
#ifndef HAVE_LIB_TRIO
  result = vfscanf (in, format, args);
#else
  result = trio_vfscanf (in, format, args);
#endif
  va_end (args);

  setlocale (LC_NUMERIC, old_locale);
  g_free (old_locale);

  return result;
}

int sscanf_C (char *in,
              char *format,
              ...)
{
  gchar   *old_locale = g_strdup (setlocale (LC_NUMERIC, NULL));
  va_list  args;
  int      result;

  setlocale (LC_NUMERIC, "C");  

  va_start (args, format);
#ifndef HAVE_LIB_TRIO
  result = vsscanf (in, format, args);
#else
  result = trio_vsscanf (in, format, args);
#endif
  va_end (args);

  setlocale (LC_NUMERIC, old_locale);
  g_free (old_locale);

  return result;
}

void fprintf_C (FILE *out,
                char *format,
                ...)
{
  gchar   *old_locale = g_strdup (setlocale (LC_NUMERIC, NULL));
  va_list  args;

  setlocale (LC_NUMERIC, "C");  

  va_start (args, format);
  vfprintf (out, format, args);
  va_end (args);

  setlocale (LC_NUMERIC, old_locale);
  g_free (old_locale);
}

void sprintf_C (char *out,
                char *format,
                ...)
{
  gchar   *old_locale = g_strdup (setlocale (LC_NUMERIC, NULL));
  va_list  args;

  setlocale (LC_NUMERIC, "C");  

  va_start (args, format);
  vsprintf (out, format, args);
  va_end (args);

  setlocale (LC_NUMERIC, old_locale);
  g_free (old_locale);
}
