/************************************************************************/
/*									*/
/*  Header file for internal use by the FileChooser implementation.	*/
/*									*/
/************************************************************************/

/************************************************************************/
/*									*/
/*  For opening/saving documents.					*/
/*									*/
/************************************************************************/

#   define	ACIrespNONE	0
#   define	ACIrespSAVE	1
#   define	ACIrespCANCEL	2
#   define	ACIrespOPEN	3
#   define	ACIrespFAILURE	4

typedef struct AppChooserInformation
    {
    AppDialog			aciDialog;

    char *			aciFilename;
    void *			aciThrough;
    APP_OPEN_DOCUMENT		aciOpenDocument;
    const AppFileExtension *	aciExtensions;
    int				aciExtensionCount;
    AppOptionmenu		aciFilterOptionmenu;
    EditApplication *		aciApplication;
    APP_WIDGET			aciOption;
    int				aciFormat;
    char *			aciExtension;

    char *			aciNoFilenameMessage;
    char *			aciIsDirecoryMessage;
    char *			aciNotWritableMessage;
    char *			aciNotReadableMessage;
    char *			aciOverwriteMessage;
    char *			aciNoSuchDirMessage;
    } AppChooserInformation;

/************************************************************************/
/*									*/
/*  Procedure declarations.						*/
/*									*/
/************************************************************************/

extern void appFileChooserGetTexts(	EditApplication *		ea,
					AppChooserInformation *		aci );

extern int appFileChooserTestNameForOpen(
				const AppChooserInformation *	aci,
				const char *			filename );

extern int appFileChooserTestNameForSave(
				const AppChooserInformation *	aci,
				const char *			filename );

extern int appChooserSaveFilename(	AppChooserInformation *	aci,
					const char *		filename );
