/************************************************************************/
/*									*/
/*  Read the various document tables of an RTF text file into a		*/
/*  BufferDocument.							*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	<psFont.h>
#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Consume a font table.						*/
/*									*/
/************************************************************************/

static int docRtfFontPanoseText(	RtfReadingContext *	rrc,
					const unsigned char *	panose,
					int			len )
    {
    if  ( len != FONTlenPANOSE )
	{ LLDEB(len,FONTlenPANOSE); return 0;	}

    memcpy( rrc->rrcCurrentFont.dfPanose, panose, len );

    rrc->rrcCurrentFont.dfPanose[FONTlenPANOSE]= '\0';

    return 0;
    }

static int docRtfFontPanoseGroup( SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfEmptyTable, docRtfEmptyTable,
				    docRtfFontPanoseText ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

static int docRtfFontName(	RtfReadingContext *	rrc,
				const unsigned char *	name,
				int			len )
    {
    DocumentFont *		df;
    DocumentProperties *	dp= &(rrc->rrcBd->bdProperties);

    static char *		scratch;
    char *			fresh;

    fresh= (char *)realloc( scratch, len+ 1 );
    if  ( ! fresh )
	{ XDEB(fresh); return -1;	}
    scratch= fresh;
    strncpy( scratch, (const char *)name, len )[len]= '\0';

    if  ( len > 0 && scratch[len-1] == ';' )
	{ scratch[len-1]= '\0';	}

    if  ( ! scratch[0] )
	{ return 0;	}

    df= docInsertFont( &(dp->dpFontList),
		    rrc->rrcCurrentFont.dfDocFamilyNumber,
		    rrc->rrcCurrentFont.dfFamilyStyle, scratch );

    if  ( ! df )
	{ SSDEB(rrc->rrcCurrentFont.dfFamilyStyle,scratch); return -1; }

    df->dfCharset= rrc->rrcCurrentFont.dfCharset;
    df->dfPitch= rrc->rrcCurrentFont.dfPitch;

    strcpy( df->dfPanose, rrc->rrcCurrentFont.dfPanose );

    rrc->rrcCurrentFont.dfPanose[0]= '\0';

    return 0;
    }

static int docRtfFontNumber(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    docCleanFont( &(rrc->rrcCurrentFont) );
    docInitFont( &(rrc->rrcCurrentFont) );

    rrc->rrcCurrentFont.dfDocFamilyNumber= arg;

    return 0;
    }

static int docRtfFontFamily(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    rrc->rrcCurrentFont.dfFamilyStyle= strdup( rcw->rcwWord );

    if  ( ! rrc->rrcCurrentFont.dfFamilyStyle )
	{ XDEB(rrc->rrcCurrentFont.dfFamilyStyle); return -1;	}

    return 0;
    }

static int docRtfFontProperty(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    switch( rcw->rcwId )
	{
	case RTFidFCHARSET:
	    rrc->rrcCurrentFont.dfCharset= arg;
	    break;

	case RTFidFPRQ:
	    rrc->rrcCurrentFont.dfPitch= arg;
	    break;

	default:
	    SLDEB(rcw->rcwWord,arg);
	}

    return 0;
    }

static RtfControlWord	docRtfFontGroupGroups[]=
    {
	{ "panose",	RTFidPANOSE,	DOClevANY, docRtfFontPanoseGroup, },

	{ 0, 0, 0 }
    };

static RtfControlWord	docRtfFontGroupWords[]=
    {
	{ "fnil",	RTFidFNIL,	DOClevANY, docRtfFontFamily, },
	{ "froman",	RTFidFROMAN,	DOClevANY, docRtfFontFamily, },
	{ "fswiss",	RTFidFSWISS,	DOClevANY, docRtfFontFamily, },
	{ "fmodern",	RTFidFMODERN,	DOClevANY, docRtfFontFamily, },
	{ "fscript",	RTFidFSCRIPT,	DOClevANY, docRtfFontFamily, },
	{ "fdecor",	RTFidFDECOR,	DOClevANY, docRtfFontFamily, },
	{ "ftech",	RTFidFTECH,	DOClevANY, docRtfFontFamily, },

	{ "fcharset",	RTFidFCHARSET,	DOClevDOC, docRtfFontProperty, },
	{ "fprq",	RTFidFPRQ,	DOClevDOC, docRtfFontProperty, },

	{ 0, 0, 0 }
    };

static int docRtfFontGroup(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc	)
    {
    docCleanFont( &(rrc->rrcCurrentFont) );
    docInitFont( &(rrc->rrcCurrentFont) );

    rrc->rrcCurrentFont.dfDocFamilyNumber= arg;

    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				    (RtfControlWord *)0, 0, 0, rrc,
				    docRtfFontGroupWords, docRtfFontGroupGroups,
				    docRtfFontName ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    docCleanFont( &(rrc->rrcCurrentFont) );
    docInitFont( &(rrc->rrcCurrentFont) );

    return 0;
    }

static RtfControlWord	docRtfFontTableWords[]=
    {
	{ "f",		RTFidF,		DOClevDOC, docRtfFontNumber, },

	{ "fnil",	RTFidFNIL,	DOClevANY, docRtfFontFamily, },
	{ "froman",	RTFidFROMAN,	DOClevANY, docRtfFontFamily, },
	{ "fswiss",	RTFidFSWISS,	DOClevANY, docRtfFontFamily, },
	{ "fmodern",	RTFidFMODERN,	DOClevANY, docRtfFontFamily, },
	{ "fscript",	RTFidFSCRIPT,	DOClevANY, docRtfFontFamily, },
	{ "fdecor",	RTFidFDECOR,	DOClevANY, docRtfFontFamily, },
	{ "ftech",	RTFidFTECH,	DOClevANY, docRtfFontFamily, },

	{ "fcharset",	RTFidFCHARSET,	DOClevDOC, docRtfFontProperty, },
	{ "fprq",	RTFidFPRQ,	DOClevDOC, docRtfFontProperty, },

	{ 0, 0, 0 }
    };

static RtfControlWord	docRtfFontTableGroups[]=
    {
	{ "f",		RTFidF,		DOClevDOC,  docRtfFontGroup, },

	{ 0, 0, 0 }
    };

int docRtfFontTable(	SimpleInputStream *	sis,
			const RtfControlWord *	rcw,
			int			arg,
			RtfReadingContext *	rrc	)
    {
    if  ( docRtfReadGroup( sis, rcw->rcwLevel,
				(RtfControlWord *)0, 0, 0, rrc,
				docRtfFontTableWords, docRtfFontTableGroups,
				docRtfFontName ) )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

