#
# zh/00default.rb: Traditional-Chinese resources of 00default.rb.
#
# Copyright (C) 2001-2005, TADA Tadashi <sho@spc.gr.jp>
# You can redistribute it and/or modify it under GPL2.
#

#
# header
#
def title_tag
	r = "<title>#{h @html_title}"
	case @mode
	when 'day', 'comment'
		r << "(#{@date.strftime( '%Y-%m-%d' )})" if @date
	when 'month'
		r << "(#{@date.strftime( '%Y-%m' )})" if @date
	when 'form'
		r << '(Append)'
	when 'edit'
		r << '(Edit)'
	when 'preview'
		r << '(Preview)'
	when 'showcomment'
		r << '(TSUKKOMI Status Change Completed)'
	when 'conf'
		r << '(Preferences)'
	when 'saveconf'
		r << '(Preferences Changed)'
	when 'nyear'
		years = @diaries.keys.map {|ymd| ymd.sub(/^\d{4}/, "")}
		r << "(#{years[0].sub( /^(\d\d)/, '\1-')}[#{nyear_diary_label @date, years}])" if @date
	end
	r << '</title>'
end

#
# link to HOWTO write diary
#
def style_howto
	%Q|/<a href="http://docs.tdiary.org/en/?#{h @conf.style}Style">g</a>|
end

#
# convert to UTF-8
#
require 'iconv'
def to_utf8( str, charset = 'Big5' )
	Iconv::conv( 'UTF-8', charset, str )
end

#
# labels
#
def no_diary; "#{@date.strftime( @conf.date_format )} oѨSox"; end
def comment_today; "jT"; end
def comment_total( total ); "(`@: #{total} h)"; end
def comment_new; 'ojT'; end
def comment_description_default; 'woz糧媺jTAzg email }uxDHiHݨC'; end
def comment_limit_label; 'You cannot make more TSUKKOMI because it has over limit.'; end
def comment_description_short; 'ojT!!'; end
def comment_name_label; 'mW'; end
def comment_name_label_short; 'mW'; end
def comment_mail_label; 'qll'; end
def comment_mail_label_short; 'l'; end
def comment_body_label; 'jT'; end
def comment_body_label_short; 'jT'; end
def comment_submit_label; 'o'; end
def comment_submit_label_short; 'o'; end
def comment_date( time ); time.strftime( "(#{@date_format} %H:%M)" ); end
def trackback_today; "ޥ"; end
def trackback_total( total ); "(`@: #{total} h)"; end

def navi_index; ''; end
def navi_latest; '̷sx'; end
def navi_oldest; '¤x'; end
def navi_update; "sW"; end
def navi_edit; "s"; end
def navi_preference; "ﶵ]w"; end
def navi_prev_diary(date); "e@hx (#{date.strftime(@date_format)})"; end
def navi_next_diary(date); "U@hx (#{date.strftime(@date_format)})"; end
def navi_prev_month; "Prev month"; end
def navi_next_month; "Next month"; end
def navi_prev_nyear(date); "h~x (#{date.strftime('%m-%d')})"; end
def navi_next_nyear(date); "~x (#{date.strftime('%m-%d')})"; end
def navi_prev_ndays; "#{@conf.latest_limit} days before"; end
def navi_next_ndays; "#{@conf.latest_limit} days after"; end

def submit_label
	if @mode == 'form' or @cgi.valid?( 'appendpreview' ) then
		'sW' #'Append'
	else
		'' #'Replace'
	end
end
def preview_label; 'w'; end #'Preview'

def nyear_diary_label(date, years); "鱡h"; end
def nyear_diary_title(date, years); "Lhɦ"; end


#
# labels (for mobile)
#
def mobile_navi_latest; '̷sx'; end
def mobile_navi_update; "sW"; end
def mobile_navi_edit; "s"; end
def mobile_navi_preference; "ﶵ]w"; end
def mobile_navi_prev_diary; "e@hx})"; end
def mobile_navi_next_diary; "U@hx})"; end
def mobile_label_hidden_diary; 'This day is HIDDEN.'; end

#
# category
#
def category_anchor(c); "[#{c}]"; end

#
# preferences
#

# genre labels
@conf_genre_label['basic'] = ''
@conf_genre_label['theme'] = 'Themes'
@conf_genre_label['tsukkomi'] = 'TSUKKOMI'
@conf_genre_label['referer'] = 'Referrer'
@conf_genre_label['security'] = 'Security'
@conf_genre_label['etc'] = 'etc'

# basic (default)
add_conf_proc( 'default', '򥻳]w', 'basic' ) do
	saveconf_default
	@conf.description ||= ''
	@conf.icon ||= ''
	@conf.banner ||= ''
	<<-HTML
	<h3 class="subtitle">jD</h3>
	#{"<p>oOzxjDAzJȷ|Φb HTML  &lt;title&gt; طCSO`NAФŨϥ HTML (tags)C </p>" unless @conf.mobile_agent?}
	<p><input name="html_title" value="#{h @conf.html_title}" size="50"></p>

	<h3 class="subtitle">@</h3>
	#{"<p>WzjWaI쪺ȱN|Φb HTML Y(header)̡C</p>" unless @conf.mobile_agent?}
	<p><input name="author_name" value="#{h @conf.author_name}" size="40"></p>

	<h3 class="subtitle">qll</h3>
	#{"<p>Jzqll}A쪺ȱNΦb HTML Y(header)̡C</p>" unless @conf.mobile_agent?}
	<p><input name="author_mail" value="#{h @conf.author_mail}" size="40"></p>

	<h3 class="subtitle">z޺() URL</h3>
	#{"<p>Yzۤv}AiHbUC</p>" unless @conf.mobile_agent?}
	<p><input name="index_page" value="#{h @conf.index_page}" size="50"></p>

	<h3 class="subtitle">URL of Your Diary</h3>
	#{"<p>Specify your diary's URL. This URL is used by some plugins for indicate your diary</p>" unless @conf.mobile_agent?}
	#{"<p><strong>NOTICE!! The URL specified below is different from current URL of accessed now.</strong></p>" unless @conf.base_url == @conf.base_url_auto}
	<p><input name="base_url" value="#{h @conf.base_url}" size="70"></p>

	<h3 class="subtitle">Description</h3>
	#{"<p>A brief description of your diary. Can be left blank.</p>" unless @conf.mobile_agent?}
	<p><input name="description" value="#{h @conf.description}" size="70"></p>

	<h3 class="subtitle">Site icon (favicon)</h3>
	#{"<p>URL for the small icon (aka 'favicon') of your site. Can be left blank.</p>" unless @conf.mobile_agent?}
	<p><input name="icon" value="#{h @conf.icon}" size="70"></p>

	<h3 class="subtitle">Site banner</h3>
	#{"<p>URL for the banner image of your site. makerss plugin will use this value to make RSS. Can be left blank.</p>" unless @conf.mobile_agent?}
	<p><input name="banner" value="#{h @conf.banner}" size="70"></p>
	HTML
end

# header/footer (header)
add_conf_proc( 'header', 'ܻP}', 'basic' ) do
	saveconf_header

	<<-HTML
	<h3 class="subtitle"></h3>
	#{"<p>oqrN|\mbCӭݡAziHϥ HTML ykCOФŲ \"&lt;%=navi%&gt;\"ҡA]N]t\"s\"(Update)\\sbuCvA \"&lt;%=calendar%&gt;\" ҥNCBz]iHۥѷft䥦 pluginC </p>" unless @conf.mobile_agent?}
	<p><textarea name="header" cols="70" rows="10">#{h @conf.header}</textarea></p>
	<h3 class="subtitle">}</h3>
	#{"<p>oqrFmOm󩳺ݥH~AlpPܡC </p>" unless @conf.mobile_agent?}
	<p><textarea name="footer" cols="70" rows="10">#{h @conf.footer}</textarea></p>
	HTML
end

# diaplay
add_conf_proc( 'display', '', 'basic' ) do
	saveconf_display

	<<-HTML
	<h3 class="subtitle">qI(anchor)NO</h3>
	#{"<p>\"I\" Nqb䥦iHPzx۳sCqI|QmCӬq}YBAziHw \"&lt;span class=\"sanchor\"&gt;_&lt;/span&gt;\"AӹϧΤILA|ѧGDD]pӨMwC </p>" unless @conf.mobile_agent?}
	<p><input name="section_anchor" value="#{h @conf.section_anchor}" size="40"></p>
	<h3 class="subtitle">jTI(anchor)NO</h3>
	#{"<p>jTI|mChjT}YBAziHw \"&lt;span class=\"canchor\"&gt;_&lt;/span&gt;\"C</p>" unless @conf.mobile_agent?}
	<p><input name="comment_anchor" value="#{h @conf.comment_anchor}" size="40"></p>
	<h3 class="subtitle">榡</h3>
	#{"<p>榡A@zwUCo % ŸftrAզXNiN榡Ap \"%Y\"(~), \"%m\"()\"%b\"(²uܪk), \"%B\"(ܪk), \"%d\"(), \"%a\"(P²uܪk), \"%A\"(Pܪk)C</p>" unless @conf.mobile_agent?}
	<p><input name="date_format" value="#{h @conf.date_format}" size="30"></p>
	<h3 class="subtitle">u̷sxv̦hnqXXѥH</h3>
	#{"<p>bu̷sxvAznܦh֤ѥxH </p>" unless @conf.mobile_agent?}
	<p><input name="latest_limit" value="#{h @conf.latest_limit}" size="2"> ѥ</p>
	<h3 class="subtitle">鱡h</h3>
	#{"<p>O_nqX \"鱡h\" (PP骺Lhx)H</p>" unless @conf.mobile_agent?}
	<p><select name="show_nyear">
		<option value="true"#{" selected" if @conf.show_nyear}>qI</option>
		<option value="false"#{" selected" unless @conf.show_nyear}></option>
	</select></p>
	HTML
end

# timezone
add_conf_proc( 'timezone', 'ɶtվ', 'update' ) do
	saveconf_timezone
	<<-HTML
	<h3 class="subtitle">ɶtվ</h3>
	#{"<p>YOzsFxAziHzL(쬰p)Ӱ۰ʽվɶtCҦpAzYQnwbMIҵoxQOQѪxAzNiHbo̶J -2CtDiary |ѦҦƭȨӧPwogxoC </p>" unless @conf.mobile_agent?}
	<p><input name="hour_offset" value="#{h @conf.hour_offset}" size="5"></p>
	HTML
end

# themes
@theme_location_comment = "<p>ziHb <a href=\"http://www.tdiary.org/20021001.html\">Theme Gallery</a>(饻y) ohGDDI</p>"
@theme_thumbnail_label = "Thumbnail"

add_conf_proc( 'theme', 'GDD', 'theme' ) do
	saveconf_theme

	 r = <<-HTML
	<h3 class="subtitle">GDD</h3>
	#{"<p>ܱzxQnGDDμ˦(CSS)ApGzܤF \"CSS specify\"AЦbk(U)̿J CSS Ҧb}C </p>" unless @conf.mobile_agent?}
	<p>
	<select name="theme" onChange="changeTheme( theme_thumbnail, this )">
		<option value="">CSS Specify-&gt;</option>
	HTML
	r << conf_theme_list
end

# comments
add_conf_proc( 'comment', 'jT', 'tsukkomi' ) do
	saveconf_comment

	<<-HTML
	<h3 class="subtitle">O_nqXjTH</h3>
	#{"<p>nnqXṶ̵̄zjTH </p>" unless @conf.mobile_agent?}
	<p><select name="show_comment">
		<option value="true"#{" selected" if @conf.show_comment}>n</option>
		<option value="false"#{" selected" unless @conf.show_comment}>n</option>
	</select></p>
	<h3 class="subtitle">nqXXgjTH</h3>
	#{"<p>bu̷sxvΡuYxvҥܤUAzQnqXhֽgijTH ۹ӻAbugvҥܤUAҦjT|qXӡC </p>" unless @conf.mobile_agent?}
	<p>qX <input name="comment_limit" value="#{h @conf.comment_limit}" size="3"> gjT</p>
	<h3 class="subtitle">Limit of TSUKKOMI per a day</h3>
	#{"<p>When numbers of TSUKKOMI over this value in a day, nobody can make new TSUKKOMI. If you use TrackBack plugin, this value means sum of TSUKKOMIs and TrackBacks.</p>" unless @conf.mobile_agent?}
	<p><input name="comment_limit_per_day" value="#{h @conf.comment_limit_per_day}" size="3"> TSUKKOMIs</p>
	HTML
end


# comment mail
def comment_mail_mime( str )
	[str.dup]
end

def comment_mail_conf_label; 'HHqzjT'; end

def comment_mail_basic_html
	@conf['comment_mail.header'] = '' unless @conf['comment_mail.header']
	@conf['comment_mail.receivers'] = '' unless @conf['comment_mail.receivers']
	@conf['comment_mail.sendhidden'] = false unless @conf['comment_mail.sendhidden']

	<<-HTML
	<h3 class="subtitle">O_QΫHqjTH</h3>
	#{"<p>пܦbsjTɭnnHqllqzCаOoo\\ݭnzb tdiary.conf ]w SMTP AC</p>" unless @conf.mobile_agent?}
	<p><select name="comment_mail.enable">
		<option value="true"#{" selected" if @conf['comment_mail.enable']}>Хζlq</option>
        <option value="false"#{" selected" unless @conf['comment_mail.enable']}>ΤF</option>
	</select></p>
	<h3 class="subtitle">}</h3>
	#{"<p>ЫwnjTqqll}A@g@Ӧ}CpGǫSt~wAhqHN|Hzqll}C</p>" unless @conf.mobile_agent?}
	<p><textarea name="comment_mail.receivers" cols="40" rows="3">#{h @conf['comment_mail.receivers'].gsub( /[, ]+/, "\n")}</textarea></p>
	<h3 class="subtitle">HD</h3>
	#{"<p>w@ӷ|\bqHuHDv}YBrCHD|O \"zwr:DATE-SERIAL NAME\" ˦C \"date\" OzxoAOpGztwF˦ADh|ܬ \"zwr-SERIAL NAME\" (ex: \"hoge:%Y-%m-%d\")</p>" unless @conf.mobile_agent?}
	<p><input name="comment_mail.header" value="#{h @conf['comment_mail.header']}"></p>
	<h3 class="subtitle">About hidden TSUKKOMI</h3>
	#{"<p>Some TSUKKOMI are hidden by filters. You can decide which sending E-mail by hidden TSUKKOMI.</p>" unless @conf.mobile_agent?}
	<p><label for="comment_mail.sendhidden"><input type="checkbox" id="comment_mail.sendhidden" name="comment_mail.sendhidden" value="#{" checked" if @conf['comment_mail.sendhidden']}">Send mail by hidden TSUKKOMI</label></p>
	HTML
end

add_conf_proc( 'csrf_protection', 'CSRF Protection', 'security' ) do
	err = saveconf_csrf_protection
	errstr = ''
	case err
	when :param
		errstr = '<p class="message">Invalid options specified. Configuration not saved.</p>'
	when :key
		errstr = '<p class="message">No key specified. Configuration not saved.</p>'
	end
	csrf_protection_method = @conf.options['csrf_protection_method'] || 1
	csrf_protection_key = @conf.options['csrf_protection_key'] || ''
	<<-HTML
	#{errstr}
	<p>This page configures a protection scheme to prevent "cross-site request forgery" (CSRF) attacks.</p>
	<p>To make CSRF attack, a malicious person prepares a trap link in some web page and lets you visit that page.
	When the trap link is invoked (either by Javascript or your mouse click), <i>your</i> web browser sends a forged request to tDiary.
	Thus, neither encryption nor usual password protection can serve as a protection mechanism.
	TDiary provies two methods -- "checking referer" and "checking CSRF key" -- to prevent such attacks.</p>
	<div class="section">
	<h3 class="subtitle">Checking Referer</h3>
	<h4 class="subtitle">Checks for Referer values</h4>
	<p>#{if [0,1,2,3].include?(csrf_protection_method) then
            '<input type="checkbox" name="check_enabled2" value="true" checked disabled>
            <input type="hidden" name="check_enabled" value="true">'
          else
            '<input type="checkbox" name="check_enabled" value="true">'
        end}Enabled (default)</input>
	</p>
	#{"<p>Configures Referer-based CSRF protection.
	TDiary checks the Referer value sent from your web browser. If the post request comes from some outer page,
	the request will be rejected. This setting can't be disabled through web-based configuration, for safety reasons.</p>
	" unless @conf.mobile_agent?}
	<h3 class="subtitle">Handling of Referer-disabled browsers</h3>
	<p><input type="radio" name="check_referer" value="true" #{if [1,3].include?(csrf_protection_method) then " checked" end}>Reject (default)</input>
	<input type="radio" name="check_referer" value="false" #{if [0,2].include?(csrf_protection_method) then " checked" end}>Accept</input>
	</p>
	#{"<p>Configures handling for requests without any Referer: value.
	By default tDiary rejects such request for safety reasons.
	If your browser is configured not to send Referer values, alter that setting to allow sending Referer, at least for
	originating sites. If it is impossible, configure the key-based CSRF protection below, and 
	change this setting to \"Accept\".</p>
	" unless @conf.mobile_agent?}
	</div>
	<div class="section">
	<h3 class="subtitle">Checking CSRF key</h3>
	<h4>Checks for CSRF protection key</h4>
	<p><input type="radio" name="check_key" value="true" #{if [2,3].include?(csrf_protection_method) then " checked" end}>Enabled</input>
	<input type="radio" name="check_key" value="false" #{if [0,1].include?(csrf_protection_method) then " checked" end}>Disabled (default)</input>
	</p>
	#{"<p>TDiary can add a secret key for every post form to prevent CSRF. As long as attackers do not know the secret key,
	forged requests will not be granted. To enable this feature, you must specify the secret key below.
	To allow Referer-disabled browsers, you must enable this setting.</p>" unless @conf.mobile_agent?}
	<h4>CSRF protection key</h4>
	<p><input type="text" name="key" value="#{h csrf_protection_key}" size="20"></p>
	#{"<p>A secret key used for key-based CSRF protection. Specify a secret string which is not easy to guess.
	If this key is leaked, CSRF attacks can be exploited.
	Do not use any passwords used in other places. You need not to remember this phrase to type in.</p>" unless @conf.mobile_agent?}
	#{"<p class=\"message\">Caution: 
	Your browser seems not to be sending any Referers, although Referer-based protection is enabled.
	<a href=\"#{h @update}?conf=csrf_protection\">Please open this page again via this link</a>.
	If you see this message again, you must either change your browser setting (temporarily to change these settings, at least),
	or edit \"tdiary.conf\" directly.</p>" if [1,3].include?(csrf_protection_method) && ! @cgi.referer && !@cgi.valid?('referer_exists')}
	</div>
	HTML
end
