'\"
'\" Generated from file 'tcllib_dns\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002, Pat Thoyts
'\"
.TH "dns" n 1\&.3\&.3 tcllib "Domain Name Service"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
dns \- Tcl Domain Name Service Client
.SH SYNOPSIS
package require \fBTcl  8\&.2\fR
.sp
package require \fBdns  ?1\&.3\&.3?\fR
.sp
\fB::dns::resolve\fR \fIquery\fR ?\fIoptions\fR?
.sp
\fB::dns::configure\fR ?\fIoptions\fR?
.sp
\fB::dns::name\fR \fItoken\fR
.sp
\fB::dns::address\fR \fItoken\fR
.sp
\fB::dns::cname\fR \fItoken\fR
.sp
\fB::dns::result\fR \fItoken\fR
.sp
\fB::dns::status\fR \fItoken\fR
.sp
\fB::dns::error\fR \fItoken\fR
.sp
\fB::dns::reset\fR \fItoken\fR
.sp
\fB::dns::wait\fR \fItoken\fR
.sp
\fB::dns::cleanup\fR \fItoken\fR
.sp
\fB::dns::nameservers\fR
.sp
.BE
.SH DESCRIPTION
.PP
The dns package provides a Tcl only Domain Name Service client\&. You
should refer to (1) and (2) for information about the DNS protocol or
read resolver(3) to find out how the C library resolves domain names\&.
The intention of this package is to insulate Tcl scripts
from problems with using the system library resolver for slow name servers\&.
It may or may not be of practical use\&. Internet name resolution is a
complex business and DNS is only one part of the resolver\&. You may
find you are supposed to be using hosts files, NIS or WINS to name a
few other systems\&. This package is not a substitute for the C library
resolver - it does however implement name resolution over DNS\&.
The package also extends the package \fBuri\fR to support DNS URIs
(4) of the form \fIdns:what\&.host\&.com\fR or
\fIdns://my\&.nameserver/what\&.host\&.com\fR\&. The \fBdns::resolve\fR
command can handle DNS URIs or simple domain names as a query\&.
.PP
\fINote:\fR The package defaults to using DNS over TCP
connections\&. If you wish to use UDP you will need to have the
\fBtcludp\fR package installed and have a version that
correctly handles binary data (> 1\&.0\&.4)\&.
This is available at \fIhttp://tcludp\&.sourceforge\&.net/\fR\&.
If the \fBudp\fR package is present then UDP will be used by default\&.
.SH COMMANDS
.TP
\fB::dns::resolve\fR \fIquery\fR ?\fIoptions\fR?
Resolve a domain name using the \fIDNS\fR protocol\&. \fIquery\fR is
the domain name to be lookup up\&. This should be either a fully
qualified domain name or a DNS URI\&.
.RS
.TP
\fB-nameserver\fR \fIhostname\fR or \fB-server\fR \fIhostname\fR
Specify an alternative name server for this request\&.
.TP
\fB-protocol\fR \fItcp|udp\fR
Specify the network protocol to use for this request\&. Can be one of
\fItcp\fR or \fIudp\fR\&.
.TP
\fB-port\fR \fIportnum\fR
Specify an alternative port\&.
.TP
\fB-search\fR \fIdomainlist\fR
.TP
\fB-timeout\fR \fImilliseconds\fR
Override the default timeout\&.
.TP
\fB-type\fR \fITYPE\fR
Specify the type of DNS record you are interested in\&. Valid values
are A, NS, MD, MF, CNAME, SOA, MB, MG, MR, NULL, WKS, PTR, HINFO,
MINFO, MX, TXT, SPF, SRV, AAAA, AXFR, MAILB, MAILA and *\&.
See RFC1035 for details about the return values\&.
See \fIhttp://spf\&.pobox\&.com/\fR about SPF\&.
See (3) about AAAA records and RFC2782 for details of SRV records\&.
.TP
\fB-class\fR \fICLASS\fR
Specify the class of domain name\&. This is usually IN but may be one
of IN for internet domain names, CS, CH, HS or * for any class\&.
.TP
\fB-recurse\fR \fIboolean\fR
Set to \fIfalse\fR if you do not want the name server to recursively
act upon your request\&. Normally set to \fItrue\fR\&.
.TP
\fB-command\fR \fIprocname\fR
Set a procedure to be called upon request completion\&. The procedure
will be passed the token as its only argument\&.
.RE
.sp
.TP
\fB::dns::configure\fR ?\fIoptions\fR?
The \fB::dns::configure\fR command is used to setup the dns
package\&. The server to query, the protocol and domain search path are
all set via this command\&. If no arguments are provided then a list of
all the current settings is returned\&.  If only one argument then it
must the the name of an option and the value for that option is
returned\&.
.RS
.TP
\fB-nameserver\fR \fIhostname\fR
Set the default name server to be used by all queries\&. The default is
\fIlocalhost\fR\&.
.TP
\fB-protocol\fR \fItcp|udp\fR
Set the default network protocol to be used\&. Default is \fItcp\fR\&.
.TP
\fB-port\fR \fIportnum\fR
Set the default port to use on the name server\&. The default is 53\&.
.TP
\fB-search\fR \fIdomainlist\fR
Set the domain search list\&. This is currently not used\&.
.TP
\fB-timeout\fR \fImilliseconds\fR
Set the default timeout value for DNS lookups\&. Default is 30 seconds\&.
.TP
\fB-loglevel\fR \fIlevel\fR
Set the log level used for emitting diagnostic messages from this
package\&. The default is \fIwarn\fR\&. See the \fBlog\fR package
for details of the available levels\&.
.RE
.sp
.TP
\fB::dns::name\fR \fItoken\fR
Returns a list of all domain names returned as an answer to your query\&.
.sp
.TP
\fB::dns::address\fR \fItoken\fR
Returns a list of the address records that match your query\&.
.sp
.TP
\fB::dns::cname\fR \fItoken\fR
Returns a list of canonical names (usually just one) matching your query\&.
.sp
.TP
\fB::dns::result\fR \fItoken\fR
Returns a list of all the decoded answer records provided for your
query\&. This permits you to extract the result for more unusual query types\&.
.sp
.TP
\fB::dns::status\fR \fItoken\fR
Returns the status flag\&. For a successfully completed query this will be
\fIok\fR\&. May be \fIerror\fR or \fItimeout\fR or \fIeof\fR\&.
See also \fB::dns::error\fR
.sp
.TP
\fB::dns::error\fR \fItoken\fR
Returns the error message provided for requests whose status is \fIerror\fR\&.
If there is no error message then an empty string is returned\&.
.sp
.TP
\fB::dns::reset\fR \fItoken\fR
Reset or cancel a DNS query\&.
.sp
.TP
\fB::dns::wait\fR \fItoken\fR
Wait for a DNS query to complete and return the status upon completion\&.
.sp
.TP
\fB::dns::cleanup\fR \fItoken\fR
Remove all state variables associated with the request\&.
.sp
.TP
\fB::dns::nameservers\fR
Attempts to return a list of the nameservers currently configured
for the users system\&. On a unix machine this parses the
/etc/resolv\&.conf file for nameservers (if it exists) and on Windows
systems we examine certain parts of the registry\&. If no nameserver can
be found then the loopback address (127\&.0\&.0\&.1) is used as a default\&.
.PP
.SH EXAMPLES
.PP
.CS


% set tok [dns::resolve www\&.tcl\&.tk]
::dns::1
% dns::status $tok
ok
% dns::address $tok
199\&.175\&.6\&.239
% dns::name $tok
www\&.tcl\&.tk
% dns::cleanup $tok

.CE
.PP
Using DNS URIs as queries:
.CS


% set tok [dns::resolve "dns:tcl\&.tk;type=MX"]
% set tok [dns::resolve "dns://l\&.root-servers\&.net/www\&.tcl\&.tk"]

.CE
.PP
Reverse address lookup:
.CS


% set tok [dns::resolve 127\&.0\&.0\&.1]
::dns::1
% dns::name $tok
localhost
% dns::cleanup $tok

.CE
.SH REFERENCES
.IP [1]
Mockapetris, P\&., "Domain Names - Concepts and Facilities",
RFC 1034, November 1987\&.
(\fIhttp://www\&.ietf\&.org/rfc/rfc1034\&.txt\fR)
.IP [2]
Mockapetris, P\&., "Domain Names - Implementation and Specification",
RFC 1035, November 1087\&.
(\fIhttp://www\&.ietf\&.org/rfc/rfc1035\&.txt\fR)
.IP [3]
Thompson, S\&. and Huitema, C\&., "DNS Extensions to support IP version 6",
RFC 1886, December 1995\&.
(\fIhttp://www\&.ietf\&.org/rfc/rfc1886\&.txt\fR)
.IP [4]
Josefsson, S\&., "Domain Name System Uniform Resource Identifiers",
Internet-Draft, October 2003,
(\fIhttp://www\&.ietf\&.org/internet-drafts/draft-josefsson-dns-url-09\&.txt\fR)
.IP [5]
Gulbrandsen, A\&., Vixie, P\&. and Esibov, L\&.,
"A DNS RR for specifying the location of services (DNS SRV)",
RFC 2782, February 2000,
(\fIhttp://www\&.ietf\&.org/rfc/rfc2782\&.txt\fR)
.IP [6]
Ohta, M\&. "Incremental Zone Transfer in DNS",
RFC 1995, August 1996,
(\fIhttp://www\&.ietf\&.org/rfc/rfc1995\&.txt\fR)
.PP
.SH AUTHORS
Pat Thoyts
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIdns\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH "SEE ALSO"
resolver(5)
.SH KEYWORDS
DNS, domain name service, resolver, rfc 1034, rfc 1035, rfc 1886
.SH CATEGORY
Networking
.SH COPYRIGHT
.nf
Copyright (c) 2002, Pat Thoyts

.fi