/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.x11;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextFactory;
import net.java.games.jogl.impl.JAWT;
import net.java.games.jogl.impl.JAWTFactory;
import net.java.games.jogl.impl.NativeLibLoader;
import net.java.games.jogl.impl.x11.GLX;
import net.java.games.jogl.impl.x11.X11OffscreenGLContext;
import net.java.games.jogl.impl.x11.X11OnscreenGLContext;
import net.java.games.jogl.impl.x11.X11SunJDKReflection;
import net.java.games.jogl.impl.x11.XVisualInfo;

public class X11GLContextFactory
extends GLContextFactory {
    private static final int MAX_ATTRIBS = 128;
    private static JAWT jawt;
    private static long staticDisplay;
    private static boolean checkedMultisample;
    private static boolean multisampleAvailable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        int n;
        GraphicsConfiguration[] graphicsConfigurationArray;
        int n2 = X11SunJDKReflection.graphicsDeviceGetScreen(graphicsDevice);
        int[] nArray = X11GLContextFactory.glCapabilities2AttribList(gLCapabilities, X11GLContextFactory.isMultisampleAvailable());
        XVisualInfo[] xVisualInfoArray = null;
        GLCapabilities[] gLCapabilitiesArray = null;
        int n3 = -1;
        X11GLContextFactory.lockAWT();
        try {
            long l = X11GLContextFactory.getDisplayConnection();
            XVisualInfo xVisualInfo = GLX.glXChooseVisual(l, n2, nArray);
            int[] nArray2 = new int[1];
            graphicsConfigurationArray = new XVisualInfo();
            graphicsConfigurationArray.screen(n2);
            xVisualInfoArray = GLX.XGetVisualInfo(l, 2, (XVisualInfo)graphicsConfigurationArray, nArray2);
            if (xVisualInfoArray == null) {
                throw new GLException("Error while enumerating available XVisualInfos");
            }
            gLCapabilitiesArray = new GLCapabilities[xVisualInfoArray.length];
            for (n = 0; n < xVisualInfoArray.length; ++n) {
                gLCapabilitiesArray[n] = X11GLContextFactory.xvi2GLCapabilities(l, xVisualInfoArray[n]);
                if (xVisualInfo == null || xVisualInfo.visualid() != xVisualInfoArray[n].visualid()) continue;
                n3 = n;
            }
        }
        finally {
            X11GLContextFactory.unlockAWT();
        }
        int n4 = gLCapabilitiesChooser.chooseCapabilities(gLCapabilities, gLCapabilitiesArray, n3);
        if (n4 < 0 || n4 >= gLCapabilitiesArray.length) {
            throw new GLException("GLCapabilitiesChooser specified invalid index (expected 0.." + (gLCapabilitiesArray.length - 1) + ")");
        }
        XVisualInfo xVisualInfo = xVisualInfoArray[n4];
        if (xVisualInfo == null) {
            throw new GLException("GLCapabilitiesChooser chose an invalid visual");
        }
        long l = xVisualInfo.visualid();
        graphicsConfigurationArray = graphicsDevice.getConfigurations();
        for (n = 0; n < graphicsConfigurationArray.length; ++n) {
            GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[n];
            if (graphicsConfiguration == null || (long)X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration) != l) continue;
            return graphicsConfiguration;
        }
        return null;
    }

    public GLContext createGLContext(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        if (component != null) {
            return new X11OnscreenGLContext(component, gLCapabilities, gLCapabilitiesChooser, gLContext);
        }
        return new X11OffscreenGLContext(gLCapabilities, gLCapabilitiesChooser, gLContext);
    }

    public static GLCapabilities xvi2GLCapabilities(long l, XVisualInfo xVisualInfo) {
        int[] nArray = new int[1];
        int n = X11GLContextFactory.glXGetConfig(l, xVisualInfo, 1, nArray);
        if (n == 0) {
            return null;
        }
        n = X11GLContextFactory.glXGetConfig(l, xVisualInfo, 4, nArray);
        if (n == 0) {
            return null;
        }
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 5, nArray) != 0);
        gLCapabilities.setStereo(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 6, nArray) != 0);
        gLCapabilities.setHardwareAccelerated(true);
        gLCapabilities.setDepthBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 12, nArray));
        gLCapabilities.setStencilBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 13, nArray));
        gLCapabilities.setRedBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 8, nArray));
        gLCapabilities.setGreenBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 9, nArray));
        gLCapabilities.setBlueBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 10, nArray));
        gLCapabilities.setAlphaBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 11, nArray));
        gLCapabilities.setAccumRedBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 14, nArray));
        gLCapabilities.setAccumGreenBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 15, nArray));
        gLCapabilities.setAccumBlueBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 16, nArray));
        gLCapabilities.setAccumAlphaBits(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 17, nArray));
        if (X11GLContextFactory.isMultisampleAvailable()) {
            gLCapabilities.setSampleBuffers(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 100000, nArray) != 0);
            gLCapabilities.setNumSamples(X11GLContextFactory.glXGetConfig(l, xVisualInfo, 100001, nArray));
        }
        return gLCapabilities;
    }

    public static int[] glCapabilities2AttribList(GLCapabilities gLCapabilities, boolean bl) {
        int n = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
        if (n < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        int[] nArray = new int[128];
        int n2 = 0;
        nArray[n2++] = 4;
        if (gLCapabilities.getDoubleBuffered()) {
            nArray[n2++] = 5;
        }
        if (gLCapabilities.getStereo()) {
            nArray[n2++] = 6;
        }
        nArray[n2++] = 8;
        nArray[n2++] = gLCapabilities.getRedBits();
        nArray[n2++] = 9;
        nArray[n2++] = gLCapabilities.getGreenBits();
        nArray[n2++] = 10;
        nArray[n2++] = gLCapabilities.getBlueBits();
        nArray[n2++] = 11;
        nArray[n2++] = gLCapabilities.getAlphaBits();
        nArray[n2++] = 12;
        nArray[n2++] = gLCapabilities.getDepthBits();
        nArray[n2++] = 13;
        nArray[n2++] = gLCapabilities.getStencilBits();
        nArray[n2++] = 14;
        nArray[n2++] = gLCapabilities.getAccumRedBits();
        nArray[n2++] = 15;
        nArray[n2++] = gLCapabilities.getAccumGreenBits();
        nArray[n2++] = 16;
        nArray[n2++] = gLCapabilities.getAccumBlueBits();
        if (bl && gLCapabilities.getSampleBuffers()) {
            nArray[n2++] = 100000;
            nArray[n2++] = 1;
            nArray[n2++] = 100001;
            nArray[n2++] = gLCapabilities.getNumSamples();
        }
        nArray[n2++] = 0;
        return nArray;
    }

    public static JAWT getJAWT() {
        if (jawt == null) {
            JAWT jAWT = new JAWT();
            jAWT.version(65540);
            if (!JAWTFactory.JAWT_GetAWT(jAWT)) {
                throw new RuntimeException("Unable to initialize JAWT");
            }
            jawt = jAWT;
        }
        return jawt;
    }

    public static void lockAWT() {
        X11GLContextFactory.getJAWT().Lock();
    }

    public static void unlockAWT() {
        X11GLContextFactory.getJAWT().Unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDisplayConnection() {
        if (staticDisplay == 0L) {
            X11GLContextFactory.lockAWT();
            try {
                staticDisplay = GLX.XOpenDisplay(null);
            }
            finally {
                X11GLContextFactory.unlockAWT();
            }
            if (staticDisplay == 0L) {
                throw new GLException("Unable to open default display, needed for visual selection and offscreen surface handling");
            }
        }
        return staticDisplay;
    }

    public static boolean isMultisampleAvailable() {
        if (!checkedMultisample) {
            long l = X11GLContextFactory.getDisplayConnection();
            String string = GLX.glXGetClientString(l, 3);
            if (string != null) {
                multisampleAvailable = string.indexOf("GLX_ARB_multisample") >= 0;
            }
            checkedMultisample = true;
        }
        return multisampleAvailable;
    }

    private static String glXGetConfigErrorCode(int n) {
        switch (n) {
            case 3: {
                return "GLX_NO_EXTENSION";
            }
            case 1: {
                return "GLX_BAD_SCREEN";
            }
            case 2: {
                return "GLX_BAD_ATTRIBUTE";
            }
            case 4: {
                return "GLX_BAD_VISUAL";
            }
        }
        return "Unknown error code " + n;
    }

    public static int glXGetConfig(long l, XVisualInfo xVisualInfo, int n, int[] nArray) {
        if (l == 0L) {
            throw new GLException("No display connection");
        }
        int n2 = GLX.glXGetConfig(l, xVisualInfo, n, nArray);
        if (n2 != 0) {
            throw new GLException("glXGetConfig failed: error code " + X11GLContextFactory.glXGetConfigErrorCode(n2));
        }
        return nArray[0];
    }

    static {
        NativeLibLoader.load();
    }
}

