/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.java.games.jogl.GL;

public class TraceGL
implements GL {
    private PrintStream stream;
    private int indent = 0;
    private GL downstreamGL;

    public TraceGL(GL gL, PrintStream printStream) {
        if (gL == null) {
            throw new IllegalArgumentException("null downstreamGL");
        }
        this.downstreamGL = gL;
        this.stream = printStream;
    }

    public void glAccum(int n, float f) {
        this.printIndent();
        this.print("glAccum(" + n + "," + f + ")");
        this.downstreamGL.glAccum(n, f);
        this.println("");
    }

    public void glActiveStencilFaceEXT(int n) {
        this.printIndent();
        this.print("glActiveStencilFaceEXT(" + n + ")");
        this.downstreamGL.glActiveStencilFaceEXT(n);
        this.println("");
    }

    public void glActiveTexture(int n) {
        this.printIndent();
        this.print("glActiveTexture(" + n + ")");
        this.downstreamGL.glActiveTexture(n);
        this.println("");
    }

    public void glActiveTextureARB(int n) {
        this.printIndent();
        this.print("glActiveTextureARB(" + n + ")");
        this.downstreamGL.glActiveTextureARB(n);
        this.println("");
    }

    public void glAlphaFragmentOp1ATI(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glAlphaFragmentOp1ATI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glAlphaFragmentOp1ATI(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public void glAlphaFragmentOp2ATI(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.printIndent();
        this.print("glAlphaFragmentOp2ATI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + ")");
        this.downstreamGL.glAlphaFragmentOp2ATI(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.println("");
    }

    public void glAlphaFragmentOp3ATI(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        this.printIndent();
        this.print("glAlphaFragmentOp3ATI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + ")");
        this.downstreamGL.glAlphaFragmentOp3ATI(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12);
        this.println("");
    }

    public void glAlphaFunc(int n, float f) {
        this.printIndent();
        this.print("glAlphaFunc(" + n + "," + f + ")");
        this.downstreamGL.glAlphaFunc(n, f);
        this.println("");
    }

    public void glApplyTextureEXT(int n) {
        this.printIndent();
        this.print("glApplyTextureEXT(" + n + ")");
        this.downstreamGL.glApplyTextureEXT(n);
        this.println("");
    }

    public boolean glAreProgramsResidentNV(int n, int[] nArray, byte[] byArray) {
        this.printIndent();
        this.print("glAreProgramsResidentNV(" + n + "," + this.dumpArray(nArray) + "," + this.dumpArray(byArray) + ")");
        boolean bl = this.downstreamGL.glAreProgramsResidentNV(n, nArray, byArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glAreProgramsResidentNV(int n, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glAreProgramsResidentNV(" + n + "," + intBuffer + "," + byteBuffer + ")");
        boolean bl = this.downstreamGL.glAreProgramsResidentNV(n, intBuffer, byteBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glAreTexturesResident(int n, int[] nArray, byte[] byArray) {
        this.printIndent();
        this.print("glAreTexturesResident(" + n + "," + this.dumpArray(nArray) + "," + this.dumpArray(byArray) + ")");
        boolean bl = this.downstreamGL.glAreTexturesResident(n, nArray, byArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glAreTexturesResident(int n, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glAreTexturesResident(" + n + "," + intBuffer + "," + byteBuffer + ")");
        boolean bl = this.downstreamGL.glAreTexturesResident(n, intBuffer, byteBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glAreTexturesResidentEXT(int n, int[] nArray, byte[] byArray) {
        this.printIndent();
        this.print("glAreTexturesResidentEXT(" + n + "," + this.dumpArray(nArray) + "," + this.dumpArray(byArray) + ")");
        boolean bl = this.downstreamGL.glAreTexturesResidentEXT(n, nArray, byArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glAreTexturesResidentEXT(int n, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glAreTexturesResidentEXT(" + n + "," + intBuffer + "," + byteBuffer + ")");
        boolean bl = this.downstreamGL.glAreTexturesResidentEXT(n, intBuffer, byteBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public void glArrayElement(int n) {
        this.printIndent();
        this.print("glArrayElement(" + n + ")");
        this.downstreamGL.glArrayElement(n);
        this.println("");
    }

    public void glArrayElementEXT(int n) {
        this.printIndent();
        this.print("glArrayElementEXT(" + n + ")");
        this.downstreamGL.glArrayElementEXT(n);
        this.println("");
    }

    public void glArrayObjectATI(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glArrayObjectATI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glArrayObjectATI(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public void glAsyncMarkerSGIX(int n) {
        this.printIndent();
        this.print("glAsyncMarkerSGIX(" + n + ")");
        this.downstreamGL.glAsyncMarkerSGIX(n);
        this.println("");
    }

    public void glAttachObjectARB(int n, int n2) {
        this.printIndent();
        this.print("glAttachObjectARB(" + n + "," + n2 + ")");
        this.downstreamGL.glAttachObjectARB(n, n2);
        this.println("");
    }

    public void glAttachShader(int n, int n2) {
        this.printIndent();
        this.print("glAttachShader(" + n + "," + n2 + ")");
        this.downstreamGL.glAttachShader(n, n2);
        this.println("");
    }

    public void glBegin(int n) {
        this.printIndent();
        this.print("glBegin(" + n + ")");
        this.downstreamGL.glBegin(n);
        this.println("");
    }

    public void glBeginFragmentShaderATI() {
        this.printIndent();
        this.print("glBeginFragmentShaderATI()");
        this.downstreamGL.glBeginFragmentShaderATI();
        this.println("");
    }

    public void glBeginOcclusionQueryNV(int n) {
        this.printIndent();
        this.print("glBeginOcclusionQueryNV(" + n + ")");
        this.downstreamGL.glBeginOcclusionQueryNV(n);
        this.println("");
    }

    public void glBeginQuery(int n, int n2) {
        this.printIndent();
        this.print("glBeginQuery(" + n + "," + n2 + ")");
        this.downstreamGL.glBeginQuery(n, n2);
        this.println("");
    }

    public void glBeginQueryARB(int n, int n2) {
        this.printIndent();
        this.print("glBeginQueryARB(" + n + "," + n2 + ")");
        this.downstreamGL.glBeginQueryARB(n, n2);
        this.println("");
    }

    public void glBeginVertexShaderEXT() {
        this.printIndent();
        this.print("glBeginVertexShaderEXT()");
        this.downstreamGL.glBeginVertexShaderEXT();
        this.println("");
    }

    public void glBindAttribLocation(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glBindAttribLocation(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glBindAttribLocation(n, n2, byArray);
        this.println("");
    }

    public void glBindAttribLocation(int n, int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glBindAttribLocation(" + n + "," + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glBindAttribLocation(n, n2, byteBuffer);
        this.println("");
    }

    public void glBindAttribLocationARB(int n, int n2, String string) {
        this.printIndent();
        this.print("glBindAttribLocationARB(" + n + "," + n2 + "," + string + ")");
        this.downstreamGL.glBindAttribLocationARB(n, n2, string);
        this.println("");
    }

    public void glBindBuffer(int n, int n2) {
        this.printIndent();
        this.print("glBindBuffer(" + n + "," + n2 + ")");
        this.downstreamGL.glBindBuffer(n, n2);
        this.println("");
    }

    public void glBindBufferARB(int n, int n2) {
        this.printIndent();
        this.print("glBindBufferARB(" + n + "," + n2 + ")");
        this.downstreamGL.glBindBufferARB(n, n2);
        this.println("");
    }

    public void glBindFragmentShaderATI(int n) {
        this.printIndent();
        this.print("glBindFragmentShaderATI(" + n + ")");
        this.downstreamGL.glBindFragmentShaderATI(n);
        this.println("");
    }

    public void glBindFramebufferEXT(int n, int n2) {
        this.printIndent();
        this.print("glBindFramebufferEXT(" + n + "," + n2 + ")");
        this.downstreamGL.glBindFramebufferEXT(n, n2);
        this.println("");
    }

    public int glBindLightParameterEXT(int n, int n2) {
        this.printIndent();
        this.print("glBindLightParameterEXT(" + n + "," + n2 + ")");
        int n3 = this.downstreamGL.glBindLightParameterEXT(n, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glBindMaterialParameterEXT(int n, int n2) {
        this.printIndent();
        this.print("glBindMaterialParameterEXT(" + n + "," + n2 + ")");
        int n3 = this.downstreamGL.glBindMaterialParameterEXT(n, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glBindParameterEXT(int n) {
        this.printIndent();
        this.print("glBindParameterEXT(" + n + ")");
        int n2 = this.downstreamGL.glBindParameterEXT(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glBindProgramARB(int n, int n2) {
        this.printIndent();
        this.print("glBindProgramARB(" + n + "," + n2 + ")");
        this.downstreamGL.glBindProgramARB(n, n2);
        this.println("");
    }

    public void glBindProgramNV(int n, int n2) {
        this.printIndent();
        this.print("glBindProgramNV(" + n + "," + n2 + ")");
        this.downstreamGL.glBindProgramNV(n, n2);
        this.println("");
    }

    public void glBindRenderbufferEXT(int n, int n2) {
        this.printIndent();
        this.print("glBindRenderbufferEXT(" + n + "," + n2 + ")");
        this.downstreamGL.glBindRenderbufferEXT(n, n2);
        this.println("");
    }

    public int glBindTexGenParameterEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glBindTexGenParameterEXT(" + n + "," + n2 + "," + n3 + ")");
        int n4 = this.downstreamGL.glBindTexGenParameterEXT(n, n2, n3);
        this.println(" = " + n4);
        return n4;
    }

    public void glBindTexture(int n, int n2) {
        this.printIndent();
        this.print("glBindTexture(" + n + "," + n2 + ")");
        this.downstreamGL.glBindTexture(n, n2);
        this.println("");
    }

    public void glBindTextureEXT(int n, int n2) {
        this.printIndent();
        this.print("glBindTextureEXT(" + n + "," + n2 + ")");
        this.downstreamGL.glBindTextureEXT(n, n2);
        this.println("");
    }

    public int glBindTextureUnitParameterEXT(int n, int n2) {
        this.printIndent();
        this.print("glBindTextureUnitParameterEXT(" + n + "," + n2 + ")");
        int n3 = this.downstreamGL.glBindTextureUnitParameterEXT(n, n2);
        this.println(" = " + n3);
        return n3;
    }

    public void glBindVertexArrayAPPLE(int n) {
        this.printIndent();
        this.print("glBindVertexArrayAPPLE(" + n + ")");
        this.downstreamGL.glBindVertexArrayAPPLE(n);
        this.println("");
    }

    public void glBindVertexShaderEXT(int n) {
        this.printIndent();
        this.print("glBindVertexShaderEXT(" + n + ")");
        this.downstreamGL.glBindVertexShaderEXT(n);
        this.println("");
    }

    public void glBinormal3bEXT(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glBinormal3bEXT(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glBinormal3bEXT(by, by2, by3);
        this.println("");
    }

    public void glBinormal3bvEXT(byte[] byArray) {
        this.printIndent();
        this.print("glBinormal3bvEXT(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glBinormal3bvEXT(byArray);
        this.println("");
    }

    public void glBinormal3bvEXT(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glBinormal3bvEXT(" + byteBuffer + ")");
        this.downstreamGL.glBinormal3bvEXT(byteBuffer);
        this.println("");
    }

    public void glBinormal3dEXT(double d, double d2, double d3) {
        this.printIndent();
        this.print("glBinormal3dEXT(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glBinormal3dEXT(d, d2, d3);
        this.println("");
    }

    public void glBinormal3dvEXT(double[] dArray) {
        this.printIndent();
        this.print("glBinormal3dvEXT(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glBinormal3dvEXT(dArray);
        this.println("");
    }

    public void glBinormal3dvEXT(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glBinormal3dvEXT(" + doubleBuffer + ")");
        this.downstreamGL.glBinormal3dvEXT(doubleBuffer);
        this.println("");
    }

    public void glBinormal3fEXT(float f, float f2, float f3) {
        this.printIndent();
        this.print("glBinormal3fEXT(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glBinormal3fEXT(f, f2, f3);
        this.println("");
    }

    public void glBinormal3fvEXT(float[] fArray) {
        this.printIndent();
        this.print("glBinormal3fvEXT(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glBinormal3fvEXT(fArray);
        this.println("");
    }

    public void glBinormal3fvEXT(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glBinormal3fvEXT(" + floatBuffer + ")");
        this.downstreamGL.glBinormal3fvEXT(floatBuffer);
        this.println("");
    }

    public void glBinormal3iEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glBinormal3iEXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glBinormal3iEXT(n, n2, n3);
        this.println("");
    }

    public void glBinormal3ivEXT(int[] nArray) {
        this.printIndent();
        this.print("glBinormal3ivEXT(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glBinormal3ivEXT(nArray);
        this.println("");
    }

    public void glBinormal3ivEXT(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glBinormal3ivEXT(" + intBuffer + ")");
        this.downstreamGL.glBinormal3ivEXT(intBuffer);
        this.println("");
    }

    public void glBinormal3sEXT(short s, short s2, short s3) {
        this.printIndent();
        this.print("glBinormal3sEXT(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glBinormal3sEXT(s, s2, s3);
        this.println("");
    }

    public void glBinormal3svEXT(short[] sArray) {
        this.printIndent();
        this.print("glBinormal3svEXT(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glBinormal3svEXT(sArray);
        this.println("");
    }

    public void glBinormal3svEXT(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glBinormal3svEXT(" + shortBuffer + ")");
        this.downstreamGL.glBinormal3svEXT(shortBuffer);
        this.println("");
    }

    public void glBinormalPointerEXT(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glBinormalPointerEXT(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glBinormalPointerEXT(n, n2, buffer);
        this.println("");
    }

    public void glBitmap(int n, int n2, float f, float f2, float f3, float f4, byte[] byArray) {
        this.printIndent();
        this.print("glBitmap(" + n + "," + n2 + "," + f + "," + f2 + "," + f3 + "," + f4 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glBitmap(n, n2, f, f2, f3, f4, byArray);
        this.println("");
    }

    public void glBitmap(int n, int n2, float f, float f2, float f3, float f4, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glBitmap(" + n + "," + n2 + "," + f + "," + f2 + "," + f3 + "," + f4 + "," + byteBuffer + ")");
        this.downstreamGL.glBitmap(n, n2, f, f2, f3, f4, byteBuffer);
        this.println("");
    }

    public void glBlendColor(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glBlendColor(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glBlendColor(f, f2, f3, f4);
        this.println("");
    }

    public void glBlendColorEXT(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glBlendColorEXT(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glBlendColorEXT(f, f2, f3, f4);
        this.println("");
    }

    public void glBlendEquation(int n) {
        this.printIndent();
        this.print("glBlendEquation(" + n + ")");
        this.downstreamGL.glBlendEquation(n);
        this.println("");
    }

    public void glBlendEquationEXT(int n) {
        this.printIndent();
        this.print("glBlendEquationEXT(" + n + ")");
        this.downstreamGL.glBlendEquationEXT(n);
        this.println("");
    }

    public void glBlendEquationSeparate(int n, int n2) {
        this.printIndent();
        this.print("glBlendEquationSeparate(" + n + "," + n2 + ")");
        this.downstreamGL.glBlendEquationSeparate(n, n2);
        this.println("");
    }

    public void glBlendEquationSeparateEXT(int n, int n2) {
        this.printIndent();
        this.print("glBlendEquationSeparateEXT(" + n + "," + n2 + ")");
        this.downstreamGL.glBlendEquationSeparateEXT(n, n2);
        this.println("");
    }

    public void glBlendFunc(int n, int n2) {
        this.printIndent();
        this.print("glBlendFunc(" + n + "," + n2 + ")");
        this.downstreamGL.glBlendFunc(n, n2);
        this.println("");
    }

    public void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glBlendFuncSeparate(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glBlendFuncSeparate(n, n2, n3, n4);
        this.println("");
    }

    public void glBlendFuncSeparateEXT(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glBlendFuncSeparateEXT(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glBlendFuncSeparateEXT(n, n2, n3, n4);
        this.println("");
    }

    public void glBlendFuncSeparateINGR(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glBlendFuncSeparateINGR(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glBlendFuncSeparateINGR(n, n2, n3, n4);
        this.println("");
    }

    public void glBufferData(int n, int n2, boolean[] blArray, int n3) {
        this.printIndent();
        this.print("glBufferData(" + n + "," + n2 + "," + this.dumpArray(blArray) + "," + n3 + ")");
        this.downstreamGL.glBufferData(n, n2, blArray, n3);
        this.println("");
    }

    public void glBufferData(int n, int n2, char[] cArray, int n3) {
        this.printIndent();
        this.print("glBufferData(" + n + "," + n2 + "," + this.dumpArray(cArray) + "," + n3 + ")");
        this.downstreamGL.glBufferData(n, n2, cArray, n3);
        this.println("");
    }

    public void glBufferData(int n, int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glBufferData(" + n + "," + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glBufferData(n, n2, byArray, n3);
        this.println("");
    }

    public void glBufferData(int n, int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glBufferData(" + n + "," + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glBufferData(n, n2, sArray, n3);
        this.println("");
    }

    public void glBufferData(int n, int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glBufferData(" + n + "," + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glBufferData(n, n2, nArray, n3);
        this.println("");
    }

    public void glBufferData(int n, int n2, long[] lArray, int n3) {
        this.printIndent();
        this.print("glBufferData(" + n + "," + n2 + "," + this.dumpArray(lArray) + "," + n3 + ")");
        this.downstreamGL.glBufferData(n, n2, lArray, n3);
        this.println("");
    }

    public void glBufferData(int n, int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glBufferData(" + n + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glBufferData(n, n2, fArray, n3);
        this.println("");
    }

    public void glBufferData(int n, int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glBufferData(" + n + "," + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glBufferData(n, n2, dArray, n3);
        this.println("");
    }

    public void glBufferData(int n, int n2, Buffer buffer, int n3) {
        this.printIndent();
        this.print("glBufferData(" + n + "," + n2 + "," + buffer + "," + n3 + ")");
        this.downstreamGL.glBufferData(n, n2, buffer, n3);
        this.println("");
    }

    public void glBufferDataARB(int n, int n2, boolean[] blArray, int n3) {
        this.printIndent();
        this.print("glBufferDataARB(" + n + "," + n2 + "," + this.dumpArray(blArray) + "," + n3 + ")");
        this.downstreamGL.glBufferDataARB(n, n2, blArray, n3);
        this.println("");
    }

    public void glBufferDataARB(int n, int n2, char[] cArray, int n3) {
        this.printIndent();
        this.print("glBufferDataARB(" + n + "," + n2 + "," + this.dumpArray(cArray) + "," + n3 + ")");
        this.downstreamGL.glBufferDataARB(n, n2, cArray, n3);
        this.println("");
    }

    public void glBufferDataARB(int n, int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glBufferDataARB(" + n + "," + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glBufferDataARB(n, n2, byArray, n3);
        this.println("");
    }

    public void glBufferDataARB(int n, int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glBufferDataARB(" + n + "," + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glBufferDataARB(n, n2, sArray, n3);
        this.println("");
    }

    public void glBufferDataARB(int n, int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glBufferDataARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glBufferDataARB(n, n2, nArray, n3);
        this.println("");
    }

    public void glBufferDataARB(int n, int n2, long[] lArray, int n3) {
        this.printIndent();
        this.print("glBufferDataARB(" + n + "," + n2 + "," + this.dumpArray(lArray) + "," + n3 + ")");
        this.downstreamGL.glBufferDataARB(n, n2, lArray, n3);
        this.println("");
    }

    public void glBufferDataARB(int n, int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glBufferDataARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glBufferDataARB(n, n2, fArray, n3);
        this.println("");
    }

    public void glBufferDataARB(int n, int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glBufferDataARB(" + n + "," + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glBufferDataARB(n, n2, dArray, n3);
        this.println("");
    }

    public void glBufferDataARB(int n, int n2, Buffer buffer, int n3) {
        this.printIndent();
        this.print("glBufferDataARB(" + n + "," + n2 + "," + buffer + "," + n3 + ")");
        this.downstreamGL.glBufferDataARB(n, n2, buffer, n3);
        this.println("");
    }

    public int glBufferRegionEnabled() {
        this.printIndent();
        this.print("glBufferRegionEnabled()");
        int n = this.downstreamGL.glBufferRegionEnabled();
        this.println(" = " + n);
        return n;
    }

    public void glBufferSubData(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glBufferSubData(n, n2, n3, blArray);
        this.println("");
    }

    public void glBufferSubData(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glBufferSubData(n, n2, n3, cArray);
        this.println("");
    }

    public void glBufferSubData(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glBufferSubData(n, n2, n3, byArray);
        this.println("");
    }

    public void glBufferSubData(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glBufferSubData(n, n2, n3, sArray);
        this.println("");
    }

    public void glBufferSubData(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glBufferSubData(n, n2, n3, nArray);
        this.println("");
    }

    public void glBufferSubData(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glBufferSubData(n, n2, n3, lArray);
        this.println("");
    }

    public void glBufferSubData(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glBufferSubData(n, n2, n3, fArray);
        this.println("");
    }

    public void glBufferSubData(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glBufferSubData(n, n2, n3, dArray);
        this.println("");
    }

    public void glBufferSubData(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glBufferSubData(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glBufferSubData(n, n2, n3, buffer);
        this.println("");
    }

    public void glBufferSubDataARB(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glBufferSubDataARB(n, n2, n3, blArray);
        this.println("");
    }

    public void glBufferSubDataARB(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glBufferSubDataARB(n, n2, n3, cArray);
        this.println("");
    }

    public void glBufferSubDataARB(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glBufferSubDataARB(n, n2, n3, byArray);
        this.println("");
    }

    public void glBufferSubDataARB(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glBufferSubDataARB(n, n2, n3, sArray);
        this.println("");
    }

    public void glBufferSubDataARB(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glBufferSubDataARB(n, n2, n3, nArray);
        this.println("");
    }

    public void glBufferSubDataARB(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glBufferSubDataARB(n, n2, n3, lArray);
        this.println("");
    }

    public void glBufferSubDataARB(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glBufferSubDataARB(n, n2, n3, fArray);
        this.println("");
    }

    public void glBufferSubDataARB(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glBufferSubDataARB(n, n2, n3, dArray);
        this.println("");
    }

    public void glBufferSubDataARB(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glBufferSubDataARB(n, n2, n3, buffer);
        this.println("");
    }

    public void glCallList(int n) {
        this.printIndent();
        this.print("glCallList(" + n + ")");
        this.downstreamGL.glCallList(n);
        this.println("");
    }

    public void glCallLists(int n, int n2, boolean[] blArray) {
        this.printIndent();
        this.print("glCallLists(" + n + "," + n2 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCallLists(n, n2, blArray);
        this.println("");
    }

    public void glCallLists(int n, int n2, char[] cArray) {
        this.printIndent();
        this.print("glCallLists(" + n + "," + n2 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCallLists(n, n2, cArray);
        this.println("");
    }

    public void glCallLists(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glCallLists(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCallLists(n, n2, byArray);
        this.println("");
    }

    public void glCallLists(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glCallLists(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCallLists(n, n2, sArray);
        this.println("");
    }

    public void glCallLists(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glCallLists(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCallLists(n, n2, nArray);
        this.println("");
    }

    public void glCallLists(int n, int n2, long[] lArray) {
        this.printIndent();
        this.print("glCallLists(" + n + "," + n2 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCallLists(n, n2, lArray);
        this.println("");
    }

    public void glCallLists(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glCallLists(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCallLists(n, n2, fArray);
        this.println("");
    }

    public void glCallLists(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glCallLists(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCallLists(n, n2, dArray);
        this.println("");
    }

    public void glCallLists(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glCallLists(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glCallLists(n, n2, buffer);
        this.println("");
    }

    public int glCheckFramebufferStatusEXT(int n) {
        this.printIndent();
        this.print("glCheckFramebufferStatusEXT(" + n + ")");
        int n2 = this.downstreamGL.glCheckFramebufferStatusEXT(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glClampColorARB(int n, int n2) {
        this.printIndent();
        this.print("glClampColorARB(" + n + "," + n2 + ")");
        this.downstreamGL.glClampColorARB(n, n2);
        this.println("");
    }

    public void glClear(int n) {
        this.printIndent();
        this.print("glClear(" + n + ")");
        this.downstreamGL.glClear(n);
        this.println("");
    }

    public void glClearAccum(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glClearAccum(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glClearAccum(f, f2, f3, f4);
        this.println("");
    }

    public void glClearColor(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glClearColor(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glClearColor(f, f2, f3, f4);
        this.println("");
    }

    public void glClearDepth(double d) {
        this.printIndent();
        this.print("glClearDepth(" + d + ")");
        this.downstreamGL.glClearDepth(d);
        this.println("");
    }

    public void glClearIndex(float f) {
        this.printIndent();
        this.print("glClearIndex(" + f + ")");
        this.downstreamGL.glClearIndex(f);
        this.println("");
    }

    public void glClearStencil(int n) {
        this.printIndent();
        this.print("glClearStencil(" + n + ")");
        this.downstreamGL.glClearStencil(n);
        this.println("");
    }

    public void glClientActiveTexture(int n) {
        this.printIndent();
        this.print("glClientActiveTexture(" + n + ")");
        this.downstreamGL.glClientActiveTexture(n);
        this.println("");
    }

    public void glClientActiveTextureARB(int n) {
        this.printIndent();
        this.print("glClientActiveTextureARB(" + n + ")");
        this.downstreamGL.glClientActiveTextureARB(n);
        this.println("");
    }

    public void glClientActiveVertexStreamATI(int n) {
        this.printIndent();
        this.print("glClientActiveVertexStreamATI(" + n + ")");
        this.downstreamGL.glClientActiveVertexStreamATI(n);
        this.println("");
    }

    public void glClipPlane(int n, double[] dArray) {
        this.printIndent();
        this.print("glClipPlane(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glClipPlane(n, dArray);
        this.println("");
    }

    public void glClipPlane(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glClipPlane(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glClipPlane(n, doubleBuffer);
        this.println("");
    }

    public void glColor3b(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glColor3b(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glColor3b(by, by2, by3);
        this.println("");
    }

    public void glColor3bv(byte[] byArray) {
        this.printIndent();
        this.print("glColor3bv(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glColor3bv(byArray);
        this.println("");
    }

    public void glColor3bv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glColor3bv(" + byteBuffer + ")");
        this.downstreamGL.glColor3bv(byteBuffer);
        this.println("");
    }

    public void glColor3d(double d, double d2, double d3) {
        this.printIndent();
        this.print("glColor3d(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glColor3d(d, d2, d3);
        this.println("");
    }

    public void glColor3dv(double[] dArray) {
        this.printIndent();
        this.print("glColor3dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glColor3dv(dArray);
        this.println("");
    }

    public void glColor3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glColor3dv(" + doubleBuffer + ")");
        this.downstreamGL.glColor3dv(doubleBuffer);
        this.println("");
    }

    public void glColor3f(float f, float f2, float f3) {
        this.printIndent();
        this.print("glColor3f(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glColor3f(f, f2, f3);
        this.println("");
    }

    public void glColor3fVertex3fSUN(float f, float f2, float f3, float f4, float f5, float f6) {
        this.printIndent();
        this.print("glColor3fVertex3fSUN(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + ")");
        this.downstreamGL.glColor3fVertex3fSUN(f, f2, f3, f4, f5, f6);
        this.println("");
    }

    public void glColor3fVertex3fvSUN(float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glColor3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glColor3fVertex3fvSUN(fArray, fArray2);
        this.println("");
    }

    public void glColor3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glColor3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glColor3fVertex3fvSUN(floatBuffer, floatBuffer2);
        this.println("");
    }

    public void glColor3fv(float[] fArray) {
        this.printIndent();
        this.print("glColor3fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColor3fv(fArray);
        this.println("");
    }

    public void glColor3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColor3fv(" + floatBuffer + ")");
        this.downstreamGL.glColor3fv(floatBuffer);
        this.println("");
    }

    public void glColor3hNV(short s, short s2, short s3) {
        this.printIndent();
        this.print("glColor3hNV(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glColor3hNV(s, s2, s3);
        this.println("");
    }

    public void glColor3hvNV(short[] sArray) {
        this.printIndent();
        this.print("glColor3hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColor3hvNV(sArray);
        this.println("");
    }

    public void glColor3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glColor3hvNV(shortBuffer);
        this.println("");
    }

    public void glColor3i(int n, int n2, int n3) {
        this.printIndent();
        this.print("glColor3i(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glColor3i(n, n2, n3);
        this.println("");
    }

    public void glColor3iv(int[] nArray) {
        this.printIndent();
        this.print("glColor3iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColor3iv(nArray);
        this.println("");
    }

    public void glColor3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColor3iv(" + intBuffer + ")");
        this.downstreamGL.glColor3iv(intBuffer);
        this.println("");
    }

    public void glColor3s(short s, short s2, short s3) {
        this.printIndent();
        this.print("glColor3s(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glColor3s(s, s2, s3);
        this.println("");
    }

    public void glColor3sv(short[] sArray) {
        this.printIndent();
        this.print("glColor3sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColor3sv(sArray);
        this.println("");
    }

    public void glColor3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor3sv(" + shortBuffer + ")");
        this.downstreamGL.glColor3sv(shortBuffer);
        this.println("");
    }

    public void glColor3ub(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glColor3ub(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glColor3ub(by, by2, by3);
        this.println("");
    }

    public void glColor3ubv(byte[] byArray) {
        this.printIndent();
        this.print("glColor3ubv(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glColor3ubv(byArray);
        this.println("");
    }

    public void glColor3ubv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glColor3ubv(" + byteBuffer + ")");
        this.downstreamGL.glColor3ubv(byteBuffer);
        this.println("");
    }

    public void glColor3ui(int n, int n2, int n3) {
        this.printIndent();
        this.print("glColor3ui(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glColor3ui(n, n2, n3);
        this.println("");
    }

    public void glColor3uiv(int[] nArray) {
        this.printIndent();
        this.print("glColor3uiv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColor3uiv(nArray);
        this.println("");
    }

    public void glColor3uiv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColor3uiv(" + intBuffer + ")");
        this.downstreamGL.glColor3uiv(intBuffer);
        this.println("");
    }

    public void glColor3us(short s, short s2, short s3) {
        this.printIndent();
        this.print("glColor3us(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glColor3us(s, s2, s3);
        this.println("");
    }

    public void glColor3usv(short[] sArray) {
        this.printIndent();
        this.print("glColor3usv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColor3usv(sArray);
        this.println("");
    }

    public void glColor3usv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor3usv(" + shortBuffer + ")");
        this.downstreamGL.glColor3usv(shortBuffer);
        this.println("");
    }

    public void glColor4b(byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glColor4b(" + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glColor4b(by, by2, by3, by4);
        this.println("");
    }

    public void glColor4bv(byte[] byArray) {
        this.printIndent();
        this.print("glColor4bv(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glColor4bv(byArray);
        this.println("");
    }

    public void glColor4bv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glColor4bv(" + byteBuffer + ")");
        this.downstreamGL.glColor4bv(byteBuffer);
        this.println("");
    }

    public void glColor4d(double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glColor4d(" + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glColor4d(d, d2, d3, d4);
        this.println("");
    }

    public void glColor4dv(double[] dArray) {
        this.printIndent();
        this.print("glColor4dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glColor4dv(dArray);
        this.println("");
    }

    public void glColor4dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glColor4dv(" + doubleBuffer + ")");
        this.downstreamGL.glColor4dv(doubleBuffer);
        this.println("");
    }

    public void glColor4f(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glColor4f(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glColor4f(f, f2, f3, f4);
        this.println("");
    }

    public void glColor4fNormal3fVertex3fSUN(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.printIndent();
        this.print("glColor4fNormal3fVertex3fSUN(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + ")");
        this.downstreamGL.glColor4fNormal3fVertex3fSUN(f, f2, f3, f4, f5, f6, f7, f8, f9, f10);
        this.println("");
    }

    public void glColor4fNormal3fVertex3fvSUN(float[] fArray, float[] fArray2, float[] fArray3) {
        this.printIndent();
        this.print("glColor4fNormal3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + ")");
        this.downstreamGL.glColor4fNormal3fVertex3fvSUN(fArray, fArray2, fArray3);
        this.println("");
    }

    public void glColor4fNormal3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glColor4fNormal3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glColor4fNormal3fVertex3fvSUN(floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    public void glColor4fv(float[] fArray) {
        this.printIndent();
        this.print("glColor4fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColor4fv(fArray);
        this.println("");
    }

    public void glColor4fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColor4fv(" + floatBuffer + ")");
        this.downstreamGL.glColor4fv(floatBuffer);
        this.println("");
    }

    public void glColor4hNV(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glColor4hNV(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glColor4hNV(s, s2, s3, s4);
        this.println("");
    }

    public void glColor4hvNV(short[] sArray) {
        this.printIndent();
        this.print("glColor4hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColor4hvNV(sArray);
        this.println("");
    }

    public void glColor4hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor4hvNV(" + shortBuffer + ")");
        this.downstreamGL.glColor4hvNV(shortBuffer);
        this.println("");
    }

    public void glColor4i(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glColor4i(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glColor4i(n, n2, n3, n4);
        this.println("");
    }

    public void glColor4iv(int[] nArray) {
        this.printIndent();
        this.print("glColor4iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColor4iv(nArray);
        this.println("");
    }

    public void glColor4iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColor4iv(" + intBuffer + ")");
        this.downstreamGL.glColor4iv(intBuffer);
        this.println("");
    }

    public void glColor4s(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glColor4s(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glColor4s(s, s2, s3, s4);
        this.println("");
    }

    public void glColor4sv(short[] sArray) {
        this.printIndent();
        this.print("glColor4sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColor4sv(sArray);
        this.println("");
    }

    public void glColor4sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor4sv(" + shortBuffer + ")");
        this.downstreamGL.glColor4sv(shortBuffer);
        this.println("");
    }

    public void glColor4ub(byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glColor4ub(" + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glColor4ub(by, by2, by3, by4);
        this.println("");
    }

    public void glColor4ubVertex2fSUN(byte by, byte by2, byte by3, byte by4, float f, float f2) {
        this.printIndent();
        this.print("glColor4ubVertex2fSUN(" + by + "," + by2 + "," + by3 + "," + by4 + "," + f + "," + f2 + ")");
        this.downstreamGL.glColor4ubVertex2fSUN(by, by2, by3, by4, f, f2);
        this.println("");
    }

    public void glColor4ubVertex2fvSUN(byte[] byArray, float[] fArray) {
        this.printIndent();
        this.print("glColor4ubVertex2fvSUN(" + this.dumpArray(byArray) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColor4ubVertex2fvSUN(byArray, fArray);
        this.println("");
    }

    public void glColor4ubVertex2fvSUN(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColor4ubVertex2fvSUN(" + byteBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glColor4ubVertex2fvSUN(byteBuffer, floatBuffer);
        this.println("");
    }

    public void glColor4ubVertex3fSUN(byte by, byte by2, byte by3, byte by4, float f, float f2, float f3) {
        this.printIndent();
        this.print("glColor4ubVertex3fSUN(" + by + "," + by2 + "," + by3 + "," + by4 + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glColor4ubVertex3fSUN(by, by2, by3, by4, f, f2, f3);
        this.println("");
    }

    public void glColor4ubVertex3fvSUN(byte[] byArray, float[] fArray) {
        this.printIndent();
        this.print("glColor4ubVertex3fvSUN(" + this.dumpArray(byArray) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColor4ubVertex3fvSUN(byArray, fArray);
        this.println("");
    }

    public void glColor4ubVertex3fvSUN(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColor4ubVertex3fvSUN(" + byteBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glColor4ubVertex3fvSUN(byteBuffer, floatBuffer);
        this.println("");
    }

    public void glColor4ubv(byte[] byArray) {
        this.printIndent();
        this.print("glColor4ubv(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glColor4ubv(byArray);
        this.println("");
    }

    public void glColor4ubv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glColor4ubv(" + byteBuffer + ")");
        this.downstreamGL.glColor4ubv(byteBuffer);
        this.println("");
    }

    public void glColor4ui(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glColor4ui(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glColor4ui(n, n2, n3, n4);
        this.println("");
    }

    public void glColor4uiv(int[] nArray) {
        this.printIndent();
        this.print("glColor4uiv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColor4uiv(nArray);
        this.println("");
    }

    public void glColor4uiv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColor4uiv(" + intBuffer + ")");
        this.downstreamGL.glColor4uiv(intBuffer);
        this.println("");
    }

    public void glColor4us(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glColor4us(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glColor4us(s, s2, s3, s4);
        this.println("");
    }

    public void glColor4usv(short[] sArray) {
        this.printIndent();
        this.print("glColor4usv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColor4usv(sArray);
        this.println("");
    }

    public void glColor4usv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor4usv(" + shortBuffer + ")");
        this.downstreamGL.glColor4usv(shortBuffer);
        this.println("");
    }

    public void glColorFragmentOp1ATI(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glColorFragmentOp1ATI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glColorFragmentOp1ATI(n, n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    public void glColorFragmentOp2ATI(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.printIndent();
        this.print("glColorFragmentOp2ATI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + ")");
        this.downstreamGL.glColorFragmentOp2ATI(n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
        this.println("");
    }

    public void glColorFragmentOp3ATI(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        this.printIndent();
        this.print("glColorFragmentOp3ATI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + n13 + ")");
        this.downstreamGL.glColorFragmentOp3ATI(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
        this.println("");
    }

    public void glColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.printIndent();
        this.print("glColorMask(" + bl + "," + bl2 + "," + bl3 + "," + bl4 + ")");
        this.downstreamGL.glColorMask(bl, bl2, bl3, bl4);
        this.println("");
    }

    public void glColorMaterial(int n, int n2) {
        this.printIndent();
        this.print("glColorMaterial(" + n + "," + n2 + ")");
        this.downstreamGL.glColorMaterial(n, n2);
        this.println("");
    }

    public void glColorPointer(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glColorPointer(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glColorPointer(n, n2, n3, buffer);
        this.println("");
    }

    public void glColorPointerEXT(int n, int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glColorPointerEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glColorPointerEXT(n, n2, n3, n4, buffer);
        this.println("");
    }

    public void glColorPointerListIBM(int n, int n2, int n3, Buffer[] bufferArray, int n4) {
        this.printIndent();
        this.print("glColorPointerListIBM(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(bufferArray) + "," + n4 + ")");
        this.downstreamGL.glColorPointerListIBM(n, n2, n3, bufferArray, n4);
        this.println("");
    }

    public void glColorPointervINTEL(int n, int n2, Buffer[] bufferArray) {
        this.printIndent();
        this.print("glColorPointervINTEL(" + n + "," + n2 + "," + this.dumpArray(bufferArray) + ")");
        this.downstreamGL.glColorPointervINTEL(n, n2, bufferArray);
        this.println("");
    }

    public void glColorSubTable(int n, int n2, int n3, int n4, int n5, boolean[] blArray) {
        this.printIndent();
        this.print("glColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glColorSubTable(n, n2, n3, n4, n5, blArray);
        this.println("");
    }

    public void glColorSubTable(int n, int n2, int n3, int n4, int n5, char[] cArray) {
        this.printIndent();
        this.print("glColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glColorSubTable(n, n2, n3, n4, n5, cArray);
        this.println("");
    }

    public void glColorSubTable(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.printIndent();
        this.print("glColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glColorSubTable(n, n2, n3, n4, n5, byArray);
        this.println("");
    }

    public void glColorSubTable(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        this.printIndent();
        this.print("glColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColorSubTable(n, n2, n3, n4, n5, sArray);
        this.println("");
    }

    public void glColorSubTable(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.printIndent();
        this.print("glColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColorSubTable(n, n2, n3, n4, n5, nArray);
        this.println("");
    }

    public void glColorSubTable(int n, int n2, int n3, int n4, int n5, long[] lArray) {
        this.printIndent();
        this.print("glColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glColorSubTable(n, n2, n3, n4, n5, lArray);
        this.println("");
    }

    public void glColorSubTable(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColorSubTable(n, n2, n3, n4, n5, fArray);
        this.println("");
    }

    public void glColorSubTable(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glColorSubTable(n, n2, n3, n4, n5, dArray);
        this.println("");
    }

    public void glColorSubTable(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glColorSubTable(n, n2, n3, n4, n5, buffer);
        this.println("");
    }

    public void glColorSubTableEXT(int n, int n2, int n3, int n4, int n5, boolean[] blArray) {
        this.printIndent();
        this.print("glColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glColorSubTableEXT(n, n2, n3, n4, n5, blArray);
        this.println("");
    }

    public void glColorSubTableEXT(int n, int n2, int n3, int n4, int n5, char[] cArray) {
        this.printIndent();
        this.print("glColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glColorSubTableEXT(n, n2, n3, n4, n5, cArray);
        this.println("");
    }

    public void glColorSubTableEXT(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.printIndent();
        this.print("glColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glColorSubTableEXT(n, n2, n3, n4, n5, byArray);
        this.println("");
    }

    public void glColorSubTableEXT(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        this.printIndent();
        this.print("glColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColorSubTableEXT(n, n2, n3, n4, n5, sArray);
        this.println("");
    }

    public void glColorSubTableEXT(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.printIndent();
        this.print("glColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColorSubTableEXT(n, n2, n3, n4, n5, nArray);
        this.println("");
    }

    public void glColorSubTableEXT(int n, int n2, int n3, int n4, int n5, long[] lArray) {
        this.printIndent();
        this.print("glColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glColorSubTableEXT(n, n2, n3, n4, n5, lArray);
        this.println("");
    }

    public void glColorSubTableEXT(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColorSubTableEXT(n, n2, n3, n4, n5, fArray);
        this.println("");
    }

    public void glColorSubTableEXT(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glColorSubTableEXT(n, n2, n3, n4, n5, dArray);
        this.println("");
    }

    public void glColorSubTableEXT(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glColorSubTableEXT(n, n2, n3, n4, n5, buffer);
        this.println("");
    }

    public void glColorTable(int n, int n2, int n3, int n4, int n5, boolean[] blArray) {
        this.printIndent();
        this.print("glColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glColorTable(n, n2, n3, n4, n5, blArray);
        this.println("");
    }

    public void glColorTable(int n, int n2, int n3, int n4, int n5, char[] cArray) {
        this.printIndent();
        this.print("glColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glColorTable(n, n2, n3, n4, n5, cArray);
        this.println("");
    }

    public void glColorTable(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.printIndent();
        this.print("glColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glColorTable(n, n2, n3, n4, n5, byArray);
        this.println("");
    }

    public void glColorTable(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        this.printIndent();
        this.print("glColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColorTable(n, n2, n3, n4, n5, sArray);
        this.println("");
    }

    public void glColorTable(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.printIndent();
        this.print("glColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColorTable(n, n2, n3, n4, n5, nArray);
        this.println("");
    }

    public void glColorTable(int n, int n2, int n3, int n4, int n5, long[] lArray) {
        this.printIndent();
        this.print("glColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glColorTable(n, n2, n3, n4, n5, lArray);
        this.println("");
    }

    public void glColorTable(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColorTable(n, n2, n3, n4, n5, fArray);
        this.println("");
    }

    public void glColorTable(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glColorTable(n, n2, n3, n4, n5, dArray);
        this.println("");
    }

    public void glColorTable(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glColorTable(n, n2, n3, n4, n5, buffer);
        this.println("");
    }

    public void glColorTableEXT(int n, int n2, int n3, int n4, int n5, boolean[] blArray) {
        this.printIndent();
        this.print("glColorTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glColorTableEXT(n, n2, n3, n4, n5, blArray);
        this.println("");
    }

    public void glColorTableEXT(int n, int n2, int n3, int n4, int n5, char[] cArray) {
        this.printIndent();
        this.print("glColorTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glColorTableEXT(n, n2, n3, n4, n5, cArray);
        this.println("");
    }

    public void glColorTableEXT(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.printIndent();
        this.print("glColorTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glColorTableEXT(n, n2, n3, n4, n5, byArray);
        this.println("");
    }

    public void glColorTableEXT(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        this.printIndent();
        this.print("glColorTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColorTableEXT(n, n2, n3, n4, n5, sArray);
        this.println("");
    }

    public void glColorTableEXT(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.printIndent();
        this.print("glColorTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColorTableEXT(n, n2, n3, n4, n5, nArray);
        this.println("");
    }

    public void glColorTableEXT(int n, int n2, int n3, int n4, int n5, long[] lArray) {
        this.printIndent();
        this.print("glColorTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glColorTableEXT(n, n2, n3, n4, n5, lArray);
        this.println("");
    }

    public void glColorTableEXT(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glColorTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColorTableEXT(n, n2, n3, n4, n5, fArray);
        this.println("");
    }

    public void glColorTableEXT(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glColorTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glColorTableEXT(n, n2, n3, n4, n5, dArray);
        this.println("");
    }

    public void glColorTableEXT(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glColorTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glColorTableEXT(n, n2, n3, n4, n5, buffer);
        this.println("");
    }

    public void glColorTableParameterfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glColorTableParameterfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColorTableParameterfv(n, n2, fArray);
        this.println("");
    }

    public void glColorTableParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColorTableParameterfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glColorTableParameterfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glColorTableParameterfvSGI(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glColorTableParameterfvSGI(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColorTableParameterfvSGI(n, n2, fArray);
        this.println("");
    }

    public void glColorTableParameterfvSGI(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColorTableParameterfvSGI(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glColorTableParameterfvSGI(n, n2, floatBuffer);
        this.println("");
    }

    public void glColorTableParameteriv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glColorTableParameteriv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColorTableParameteriv(n, n2, nArray);
        this.println("");
    }

    public void glColorTableParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColorTableParameteriv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glColorTableParameteriv(n, n2, intBuffer);
        this.println("");
    }

    public void glColorTableParameterivSGI(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glColorTableParameterivSGI(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColorTableParameterivSGI(n, n2, nArray);
        this.println("");
    }

    public void glColorTableParameterivSGI(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColorTableParameterivSGI(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glColorTableParameterivSGI(n, n2, intBuffer);
        this.println("");
    }

    public void glColorTableSGI(int n, int n2, int n3, int n4, int n5, boolean[] blArray) {
        this.printIndent();
        this.print("glColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glColorTableSGI(n, n2, n3, n4, n5, blArray);
        this.println("");
    }

    public void glColorTableSGI(int n, int n2, int n3, int n4, int n5, char[] cArray) {
        this.printIndent();
        this.print("glColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glColorTableSGI(n, n2, n3, n4, n5, cArray);
        this.println("");
    }

    public void glColorTableSGI(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.printIndent();
        this.print("glColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glColorTableSGI(n, n2, n3, n4, n5, byArray);
        this.println("");
    }

    public void glColorTableSGI(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        this.printIndent();
        this.print("glColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glColorTableSGI(n, n2, n3, n4, n5, sArray);
        this.println("");
    }

    public void glColorTableSGI(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.printIndent();
        this.print("glColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glColorTableSGI(n, n2, n3, n4, n5, nArray);
        this.println("");
    }

    public void glColorTableSGI(int n, int n2, int n3, int n4, int n5, long[] lArray) {
        this.printIndent();
        this.print("glColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glColorTableSGI(n, n2, n3, n4, n5, lArray);
        this.println("");
    }

    public void glColorTableSGI(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glColorTableSGI(n, n2, n3, n4, n5, fArray);
        this.println("");
    }

    public void glColorTableSGI(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glColorTableSGI(n, n2, n3, n4, n5, dArray);
        this.println("");
    }

    public void glColorTableSGI(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glColorTableSGI(n, n2, n3, n4, n5, buffer);
        this.println("");
    }

    public void glCombinerInputNV(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glCombinerInputNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glCombinerInputNV(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public void glCombinerOutputNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, boolean bl3) {
        this.printIndent();
        this.print("glCombinerOutputNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + bl2 + "," + bl3 + ")");
        this.downstreamGL.glCombinerOutputNV(n, n2, n3, n4, n5, n6, n7, bl, bl2, bl3);
        this.println("");
    }

    public void glCombinerParameterfNV(int n, float f) {
        this.printIndent();
        this.print("glCombinerParameterfNV(" + n + "," + f + ")");
        this.downstreamGL.glCombinerParameterfNV(n, f);
        this.println("");
    }

    public void glCombinerParameterfvNV(int n, float[] fArray) {
        this.printIndent();
        this.print("glCombinerParameterfvNV(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCombinerParameterfvNV(n, fArray);
        this.println("");
    }

    public void glCombinerParameterfvNV(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glCombinerParameterfvNV(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glCombinerParameterfvNV(n, floatBuffer);
        this.println("");
    }

    public void glCombinerParameteriNV(int n, int n2) {
        this.printIndent();
        this.print("glCombinerParameteriNV(" + n + "," + n2 + ")");
        this.downstreamGL.glCombinerParameteriNV(n, n2);
        this.println("");
    }

    public void glCombinerParameterivNV(int n, int[] nArray) {
        this.printIndent();
        this.print("glCombinerParameterivNV(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCombinerParameterivNV(n, nArray);
        this.println("");
    }

    public void glCombinerParameterivNV(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glCombinerParameterivNV(" + n + "," + intBuffer + ")");
        this.downstreamGL.glCombinerParameterivNV(n, intBuffer);
        this.println("");
    }

    public void glCombinerStageParameterfvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glCombinerStageParameterfvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCombinerStageParameterfvNV(n, n2, fArray);
        this.println("");
    }

    public void glCombinerStageParameterfvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glCombinerStageParameterfvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glCombinerStageParameterfvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glCompileShader(int n) {
        this.printIndent();
        this.print("glCompileShader(" + n + ")");
        this.downstreamGL.glCompileShader(n);
        this.println("");
    }

    public void glCompileShaderARB(int n) {
        this.printIndent();
        this.print("glCompileShaderARB(" + n + ")");
        this.downstreamGL.glCompileShaderARB(n);
        this.println("");
    }

    public void glCompressedTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexImage1D(n, n2, n3, n4, n5, n6, blArray);
        this.println("");
    }

    public void glCompressedTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexImage1D(n, n2, n3, n4, n5, n6, cArray);
        this.println("");
    }

    public void glCompressedTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexImage1D(n, n2, n3, n4, n5, n6, byArray);
        this.println("");
    }

    public void glCompressedTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexImage1D(n, n2, n3, n4, n5, n6, sArray);
        this.println("");
    }

    public void glCompressedTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexImage1D(n, n2, n3, n4, n5, n6, nArray);
        this.println("");
    }

    public void glCompressedTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexImage1D(n, n2, n3, n4, n5, n6, lArray);
        this.println("");
    }

    public void glCompressedTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexImage1D(n, n2, n3, n4, n5, n6, fArray);
        this.println("");
    }

    public void glCompressedTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexImage1D(n, n2, n3, n4, n5, n6, dArray);
        this.println("");
    }

    public void glCompressedTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexImage1D(n, n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    public void glCompressedTexImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexImage1DARB(n, n2, n3, n4, n5, n6, blArray);
        this.println("");
    }

    public void glCompressedTexImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexImage1DARB(n, n2, n3, n4, n5, n6, cArray);
        this.println("");
    }

    public void glCompressedTexImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexImage1DARB(n, n2, n3, n4, n5, n6, byArray);
        this.println("");
    }

    public void glCompressedTexImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexImage1DARB(n, n2, n3, n4, n5, n6, sArray);
        this.println("");
    }

    public void glCompressedTexImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexImage1DARB(n, n2, n3, n4, n5, n6, nArray);
        this.println("");
    }

    public void glCompressedTexImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexImage1DARB(n, n2, n3, n4, n5, n6, lArray);
        this.println("");
    }

    public void glCompressedTexImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexImage1DARB(n, n2, n3, n4, n5, n6, fArray);
        this.println("");
    }

    public void glCompressedTexImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexImage1DARB(n, n2, n3, n4, n5, n6, dArray);
        this.println("");
    }

    public void glCompressedTexImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexImage1DARB(n, n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, blArray);
        this.println("");
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, cArray);
        this.println("");
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, byArray);
        this.println("");
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, sArray);
        this.println("");
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, nArray);
        this.println("");
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, lArray);
        this.println("");
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, fArray);
        this.println("");
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, dArray);
        this.println("");
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, buffer);
        this.println("");
    }

    public void glCompressedTexImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexImage2DARB(n, n2, n3, n4, n5, n6, n7, blArray);
        this.println("");
    }

    public void glCompressedTexImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexImage2DARB(n, n2, n3, n4, n5, n6, n7, cArray);
        this.println("");
    }

    public void glCompressedTexImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexImage2DARB(n, n2, n3, n4, n5, n6, n7, byArray);
        this.println("");
    }

    public void glCompressedTexImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexImage2DARB(n, n2, n3, n4, n5, n6, n7, sArray);
        this.println("");
    }

    public void glCompressedTexImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexImage2DARB(n, n2, n3, n4, n5, n6, n7, nArray);
        this.println("");
    }

    public void glCompressedTexImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexImage2DARB(n, n2, n3, n4, n5, n6, n7, lArray);
        this.println("");
    }

    public void glCompressedTexImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexImage2DARB(n, n2, n3, n4, n5, n6, n7, fArray);
        this.println("");
    }

    public void glCompressedTexImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexImage2DARB(n, n2, n3, n4, n5, n6, n7, dArray);
        this.println("");
    }

    public void glCompressedTexImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexImage2DARB(n, n2, n3, n4, n5, n6, n7, buffer);
        this.println("");
    }

    public void glCompressedTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, blArray);
        this.println("");
    }

    public void glCompressedTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, cArray);
        this.println("");
    }

    public void glCompressedTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, byArray);
        this.println("");
    }

    public void glCompressedTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, sArray);
        this.println("");
    }

    public void glCompressedTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, nArray);
        this.println("");
    }

    public void glCompressedTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, lArray);
        this.println("");
    }

    public void glCompressedTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, fArray);
        this.println("");
    }

    public void glCompressedTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, dArray);
        this.println("");
    }

    public void glCompressedTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.println("");
    }

    public void glCompressedTexImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, blArray);
        this.println("");
    }

    public void glCompressedTexImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, cArray);
        this.println("");
    }

    public void glCompressedTexImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, byArray);
        this.println("");
    }

    public void glCompressedTexImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, sArray);
        this.println("");
    }

    public void glCompressedTexImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, nArray);
        this.println("");
    }

    public void glCompressedTexImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, lArray);
        this.println("");
    }

    public void glCompressedTexImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, fArray);
        this.println("");
    }

    public void glCompressedTexImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, dArray);
        this.println("");
    }

    public void glCompressedTexImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.println("");
    }

    public void glCompressedTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n, n2, n3, n4, n5, n6, blArray);
        this.println("");
    }

    public void glCompressedTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n, n2, n3, n4, n5, n6, cArray);
        this.println("");
    }

    public void glCompressedTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n, n2, n3, n4, n5, n6, byArray);
        this.println("");
    }

    public void glCompressedTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n, n2, n3, n4, n5, n6, sArray);
        this.println("");
    }

    public void glCompressedTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n, n2, n3, n4, n5, n6, nArray);
        this.println("");
    }

    public void glCompressedTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n, n2, n3, n4, n5, n6, lArray);
        this.println("");
    }

    public void glCompressedTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n, n2, n3, n4, n5, n6, fArray);
        this.println("");
    }

    public void glCompressedTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n, n2, n3, n4, n5, n6, dArray);
        this.println("");
    }

    public void glCompressedTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n, n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    public void glCompressedTexSubImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1DARB(n, n2, n3, n4, n5, n6, blArray);
        this.println("");
    }

    public void glCompressedTexSubImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1DARB(n, n2, n3, n4, n5, n6, cArray);
        this.println("");
    }

    public void glCompressedTexSubImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1DARB(n, n2, n3, n4, n5, n6, byArray);
        this.println("");
    }

    public void glCompressedTexSubImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1DARB(n, n2, n3, n4, n5, n6, sArray);
        this.println("");
    }

    public void glCompressedTexSubImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1DARB(n, n2, n3, n4, n5, n6, nArray);
        this.println("");
    }

    public void glCompressedTexSubImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1DARB(n, n2, n3, n4, n5, n6, lArray);
        this.println("");
    }

    public void glCompressedTexSubImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1DARB(n, n2, n3, n4, n5, n6, fArray);
        this.println("");
    }

    public void glCompressedTexSubImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexSubImage1DARB(n, n2, n3, n4, n5, n6, dArray);
        this.println("");
    }

    public void glCompressedTexSubImage1DARB(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexSubImage1DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexSubImage1DARB(n, n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, blArray);
        this.println("");
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, cArray);
        this.println("");
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, byArray);
        this.println("");
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, sArray);
        this.println("");
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, nArray);
        this.println("");
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, lArray);
        this.println("");
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, fArray);
        this.println("");
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, dArray);
        this.println("");
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.println("");
    }

    public void glCompressedTexSubImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2DARB(n, n2, n3, n4, n5, n6, n7, n8, blArray);
        this.println("");
    }

    public void glCompressedTexSubImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2DARB(n, n2, n3, n4, n5, n6, n7, n8, cArray);
        this.println("");
    }

    public void glCompressedTexSubImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2DARB(n, n2, n3, n4, n5, n6, n7, n8, byArray);
        this.println("");
    }

    public void glCompressedTexSubImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2DARB(n, n2, n3, n4, n5, n6, n7, n8, sArray);
        this.println("");
    }

    public void glCompressedTexSubImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2DARB(n, n2, n3, n4, n5, n6, n7, n8, nArray);
        this.println("");
    }

    public void glCompressedTexSubImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2DARB(n, n2, n3, n4, n5, n6, n7, n8, lArray);
        this.println("");
    }

    public void glCompressedTexSubImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2DARB(n, n2, n3, n4, n5, n6, n7, n8, fArray);
        this.println("");
    }

    public void glCompressedTexSubImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexSubImage2DARB(n, n2, n3, n4, n5, n6, n7, n8, dArray);
        this.println("");
    }

    public void glCompressedTexSubImage2DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexSubImage2DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexSubImage2DARB(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.println("");
    }

    public void glCompressedTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, blArray);
        this.println("");
    }

    public void glCompressedTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, cArray);
        this.println("");
    }

    public void glCompressedTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, byArray);
        this.println("");
    }

    public void glCompressedTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, sArray);
        this.println("");
    }

    public void glCompressedTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, nArray);
        this.println("");
    }

    public void glCompressedTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, lArray);
        this.println("");
    }

    public void glCompressedTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, fArray);
        this.println("");
    }

    public void glCompressedTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, dArray);
        this.println("");
    }

    public void glCompressedTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, buffer);
        this.println("");
    }

    public void glCompressedTexSubImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean[] blArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, blArray);
        this.println("");
    }

    public void glCompressedTexSubImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, char[] cArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, cArray);
        this.println("");
    }

    public void glCompressedTexSubImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, byte[] byArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, byArray);
        this.println("");
    }

    public void glCompressedTexSubImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, short[] sArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, sArray);
        this.println("");
    }

    public void glCompressedTexSubImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, nArray);
        this.println("");
    }

    public void glCompressedTexSubImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long[] lArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, lArray);
        this.println("");
    }

    public void glCompressedTexSubImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, float[] fArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, fArray);
        this.println("");
    }

    public void glCompressedTexSubImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, double[] dArray) {
        this.printIndent();
        this.print("glCompressedTexSubImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCompressedTexSubImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, dArray);
        this.println("");
    }

    public void glCompressedTexSubImage3DARB(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexSubImage3DARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexSubImage3DARB(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, buffer);
        this.println("");
    }

    public void glConvolutionFilter1D(int n, int n2, int n3, int n4, int n5, boolean[] blArray) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glConvolutionFilter1D(n, n2, n3, n4, n5, blArray);
        this.println("");
    }

    public void glConvolutionFilter1D(int n, int n2, int n3, int n4, int n5, char[] cArray) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glConvolutionFilter1D(n, n2, n3, n4, n5, cArray);
        this.println("");
    }

    public void glConvolutionFilter1D(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glConvolutionFilter1D(n, n2, n3, n4, n5, byArray);
        this.println("");
    }

    public void glConvolutionFilter1D(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glConvolutionFilter1D(n, n2, n3, n4, n5, sArray);
        this.println("");
    }

    public void glConvolutionFilter1D(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glConvolutionFilter1D(n, n2, n3, n4, n5, nArray);
        this.println("");
    }

    public void glConvolutionFilter1D(int n, int n2, int n3, int n4, int n5, long[] lArray) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glConvolutionFilter1D(n, n2, n3, n4, n5, lArray);
        this.println("");
    }

    public void glConvolutionFilter1D(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glConvolutionFilter1D(n, n2, n3, n4, n5, fArray);
        this.println("");
    }

    public void glConvolutionFilter1D(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glConvolutionFilter1D(n, n2, n3, n4, n5, dArray);
        this.println("");
    }

    public void glConvolutionFilter1D(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glConvolutionFilter1D(n, n2, n3, n4, n5, buffer);
        this.println("");
    }

    public void glConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5, boolean[] blArray) {
        this.printIndent();
        this.print("glConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glConvolutionFilter1DEXT(n, n2, n3, n4, n5, blArray);
        this.println("");
    }

    public void glConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5, char[] cArray) {
        this.printIndent();
        this.print("glConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glConvolutionFilter1DEXT(n, n2, n3, n4, n5, cArray);
        this.println("");
    }

    public void glConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.printIndent();
        this.print("glConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glConvolutionFilter1DEXT(n, n2, n3, n4, n5, byArray);
        this.println("");
    }

    public void glConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        this.printIndent();
        this.print("glConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glConvolutionFilter1DEXT(n, n2, n3, n4, n5, sArray);
        this.println("");
    }

    public void glConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.printIndent();
        this.print("glConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glConvolutionFilter1DEXT(n, n2, n3, n4, n5, nArray);
        this.println("");
    }

    public void glConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5, long[] lArray) {
        this.printIndent();
        this.print("glConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glConvolutionFilter1DEXT(n, n2, n3, n4, n5, lArray);
        this.println("");
    }

    public void glConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glConvolutionFilter1DEXT(n, n2, n3, n4, n5, fArray);
        this.println("");
    }

    public void glConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glConvolutionFilter1DEXT(n, n2, n3, n4, n5, dArray);
        this.println("");
    }

    public void glConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glConvolutionFilter1DEXT(n, n2, n3, n4, n5, buffer);
        this.println("");
    }

    public void glConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glConvolutionFilter2D(n, n2, n3, n4, n5, n6, blArray);
        this.println("");
    }

    public void glConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glConvolutionFilter2D(n, n2, n3, n4, n5, n6, cArray);
        this.println("");
    }

    public void glConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glConvolutionFilter2D(n, n2, n3, n4, n5, n6, byArray);
        this.println("");
    }

    public void glConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glConvolutionFilter2D(n, n2, n3, n4, n5, n6, sArray);
        this.println("");
    }

    public void glConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glConvolutionFilter2D(n, n2, n3, n4, n5, n6, nArray);
        this.println("");
    }

    public void glConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glConvolutionFilter2D(n, n2, n3, n4, n5, n6, lArray);
        this.println("");
    }

    public void glConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glConvolutionFilter2D(n, n2, n3, n4, n5, n6, fArray);
        this.println("");
    }

    public void glConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glConvolutionFilter2D(n, n2, n3, n4, n5, n6, dArray);
        this.println("");
    }

    public void glConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glConvolutionFilter2D(n, n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    public void glConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray) {
        this.printIndent();
        this.print("glConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6, blArray);
        this.println("");
    }

    public void glConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray) {
        this.printIndent();
        this.print("glConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6, cArray);
        this.println("");
    }

    public void glConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.printIndent();
        this.print("glConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6, byArray);
        this.println("");
    }

    public void glConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        this.printIndent();
        this.print("glConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6, sArray);
        this.println("");
    }

    public void glConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.printIndent();
        this.print("glConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6, nArray);
        this.println("");
    }

    public void glConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray) {
        this.printIndent();
        this.print("glConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6, lArray);
        this.println("");
    }

    public void glConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6, fArray);
        this.println("");
    }

    public void glConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6, dArray);
        this.println("");
    }

    public void glConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    public void glConvolutionParameterf(int n, int n2, float f) {
        this.printIndent();
        this.print("glConvolutionParameterf(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glConvolutionParameterf(n, n2, f);
        this.println("");
    }

    public void glConvolutionParameterfEXT(int n, int n2, float f) {
        this.printIndent();
        this.print("glConvolutionParameterfEXT(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glConvolutionParameterfEXT(n, n2, f);
        this.println("");
    }

    public void glConvolutionParameterfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glConvolutionParameterfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glConvolutionParameterfv(n, n2, fArray);
        this.println("");
    }

    public void glConvolutionParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glConvolutionParameterfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glConvolutionParameterfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glConvolutionParameterfvEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glConvolutionParameterfvEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glConvolutionParameterfvEXT(n, n2, fArray);
        this.println("");
    }

    public void glConvolutionParameterfvEXT(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glConvolutionParameterfvEXT(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glConvolutionParameterfvEXT(n, n2, floatBuffer);
        this.println("");
    }

    public void glConvolutionParameteri(int n, int n2, int n3) {
        this.printIndent();
        this.print("glConvolutionParameteri(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glConvolutionParameteri(n, n2, n3);
        this.println("");
    }

    public void glConvolutionParameteriEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glConvolutionParameteriEXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glConvolutionParameteriEXT(n, n2, n3);
        this.println("");
    }

    public void glConvolutionParameteriv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glConvolutionParameteriv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glConvolutionParameteriv(n, n2, nArray);
        this.println("");
    }

    public void glConvolutionParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glConvolutionParameteriv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glConvolutionParameteriv(n, n2, intBuffer);
        this.println("");
    }

    public void glConvolutionParameterivEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glConvolutionParameterivEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glConvolutionParameterivEXT(n, n2, nArray);
        this.println("");
    }

    public void glConvolutionParameterivEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glConvolutionParameterivEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glConvolutionParameterivEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glCopyColorSubTable(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glCopyColorSubTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glCopyColorSubTable(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glCopyColorSubTableEXT(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glCopyColorSubTableEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glCopyColorSubTableEXT(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glCopyColorTable(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glCopyColorTable(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glCopyColorTable(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glCopyColorTableSGI(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glCopyColorTableSGI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glCopyColorTableSGI(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glCopyConvolutionFilter1D(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glCopyConvolutionFilter1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glCopyConvolutionFilter1D(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glCopyConvolutionFilter1DEXT(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glCopyConvolutionFilter1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glCopyConvolutionFilter1DEXT(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glCopyConvolutionFilter2D(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glCopyConvolutionFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glCopyConvolutionFilter2D(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public void glCopyConvolutionFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glCopyConvolutionFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glCopyConvolutionFilter2DEXT(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public void glCopyPixels(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glCopyPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glCopyPixels(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glCopyTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glCopyTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glCopyTexImage1D(n, n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    public void glCopyTexImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glCopyTexImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glCopyTexImage1DEXT(n, n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    public void glCopyTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.printIndent();
        this.print("glCopyTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + ")");
        this.downstreamGL.glCopyTexImage2D(n, n2, n3, n4, n5, n6, n7, n8);
        this.println("");
    }

    public void glCopyTexImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.printIndent();
        this.print("glCopyTexImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + ")");
        this.downstreamGL.glCopyTexImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8);
        this.println("");
    }

    public void glCopyTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glCopyTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glCopyTexSubImage1D(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public void glCopyTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glCopyTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glCopyTexSubImage1DEXT(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public void glCopyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.printIndent();
        this.print("glCopyTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + ")");
        this.downstreamGL.glCopyTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8);
        this.println("");
    }

    public void glCopyTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.printIndent();
        this.print("glCopyTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + ")");
        this.downstreamGL.glCopyTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8);
        this.println("");
    }

    public void glCopyTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.printIndent();
        this.print("glCopyTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + ")");
        this.downstreamGL.glCopyTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.println("");
    }

    public void glCopyTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.printIndent();
        this.print("glCopyTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + ")");
        this.downstreamGL.glCopyTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.println("");
    }

    public int glCreateProgram() {
        this.printIndent();
        this.print("glCreateProgram()");
        int n = this.downstreamGL.glCreateProgram();
        this.println(" = " + n);
        return n;
    }

    public int glCreateProgramObjectARB() {
        this.printIndent();
        this.print("glCreateProgramObjectARB()");
        int n = this.downstreamGL.glCreateProgramObjectARB();
        this.println(" = " + n);
        return n;
    }

    public int glCreateShader(int n) {
        this.printIndent();
        this.print("glCreateShader(" + n + ")");
        int n2 = this.downstreamGL.glCreateShader(n);
        this.println(" = " + n2);
        return n2;
    }

    public int glCreateShaderObjectARB(int n) {
        this.printIndent();
        this.print("glCreateShaderObjectARB(" + n + ")");
        int n2 = this.downstreamGL.glCreateShaderObjectARB(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glCullFace(int n) {
        this.printIndent();
        this.print("glCullFace(" + n + ")");
        this.downstreamGL.glCullFace(n);
        this.println("");
    }

    public void glCullParameterdvEXT(int n, double[] dArray) {
        this.printIndent();
        this.print("glCullParameterdvEXT(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glCullParameterdvEXT(n, dArray);
        this.println("");
    }

    public void glCullParameterdvEXT(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glCullParameterdvEXT(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glCullParameterdvEXT(n, doubleBuffer);
        this.println("");
    }

    public void glCullParameterfvEXT(int n, float[] fArray) {
        this.printIndent();
        this.print("glCullParameterfvEXT(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glCullParameterfvEXT(n, fArray);
        this.println("");
    }

    public void glCullParameterfvEXT(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glCullParameterfvEXT(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glCullParameterfvEXT(n, floatBuffer);
        this.println("");
    }

    public void glCurrentPaletteMatrixARB(int n) {
        this.printIndent();
        this.print("glCurrentPaletteMatrixARB(" + n + ")");
        this.downstreamGL.glCurrentPaletteMatrixARB(n);
        this.println("");
    }

    public void glDeformSGIX(int n) {
        this.printIndent();
        this.print("glDeformSGIX(" + n + ")");
        this.downstreamGL.glDeformSGIX(n);
        this.println("");
    }

    public void glDeformationMap3dSGIX(int n, double d, double d2, int n2, int n3, double d3, double d4, int n4, int n5, double d5, double d6, int n6, int n7, double[] dArray) {
        this.printIndent();
        this.print("glDeformationMap3dSGIX(" + n + "," + d + "," + d2 + "," + n2 + "," + n3 + "," + d3 + "," + d4 + "," + n4 + "," + n5 + "," + d5 + "," + d6 + "," + n6 + "," + n7 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glDeformationMap3dSGIX(n, d, d2, n2, n3, d3, d4, n4, n5, d5, d6, n6, n7, dArray);
        this.println("");
    }

    public void glDeformationMap3dSGIX(int n, double d, double d2, int n2, int n3, double d3, double d4, int n4, int n5, double d5, double d6, int n6, int n7, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glDeformationMap3dSGIX(" + n + "," + d + "," + d2 + "," + n2 + "," + n3 + "," + d3 + "," + d4 + "," + n4 + "," + n5 + "," + d5 + "," + d6 + "," + n6 + "," + n7 + "," + doubleBuffer + ")");
        this.downstreamGL.glDeformationMap3dSGIX(n, d, d2, n2, n3, d3, d4, n4, n5, d5, d6, n6, n7, doubleBuffer);
        this.println("");
    }

    public void glDeformationMap3fSGIX(int n, float f, float f2, int n2, int n3, float f3, float f4, int n4, int n5, float f5, float f6, int n6, int n7, float[] fArray) {
        this.printIndent();
        this.print("glDeformationMap3fSGIX(" + n + "," + f + "," + f2 + "," + n2 + "," + n3 + "," + f3 + "," + f4 + "," + n4 + "," + n5 + "," + f5 + "," + f6 + "," + n6 + "," + n7 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glDeformationMap3fSGIX(n, f, f2, n2, n3, f3, f4, n4, n5, f5, f6, n6, n7, fArray);
        this.println("");
    }

    public void glDeformationMap3fSGIX(int n, float f, float f2, int n2, int n3, float f3, float f4, int n4, int n5, float f5, float f6, int n6, int n7, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glDeformationMap3fSGIX(" + n + "," + f + "," + f2 + "," + n2 + "," + n3 + "," + f3 + "," + f4 + "," + n4 + "," + n5 + "," + f5 + "," + f6 + "," + n6 + "," + n7 + "," + floatBuffer + ")");
        this.downstreamGL.glDeformationMap3fSGIX(n, f, f2, n2, n3, f3, f4, n4, n5, f5, f6, n6, n7, floatBuffer);
        this.println("");
    }

    public void glDeleteAsyncMarkersSGIX(int n, int n2) {
        this.printIndent();
        this.print("glDeleteAsyncMarkersSGIX(" + n + "," + n2 + ")");
        this.downstreamGL.glDeleteAsyncMarkersSGIX(n, n2);
        this.println("");
    }

    public void glDeleteBufferRegion(int n) {
        this.printIndent();
        this.print("glDeleteBufferRegion(" + n + ")");
        this.downstreamGL.glDeleteBufferRegion(n);
        this.println("");
    }

    public void glDeleteBuffers(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteBuffers(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteBuffers(n, nArray);
        this.println("");
    }

    public void glDeleteBuffers(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteBuffers(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteBuffers(n, intBuffer);
        this.println("");
    }

    public void glDeleteBuffersARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteBuffersARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteBuffersARB(n, nArray);
        this.println("");
    }

    public void glDeleteBuffersARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteBuffersARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteBuffersARB(n, intBuffer);
        this.println("");
    }

    public void glDeleteFencesAPPLE(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteFencesAPPLE(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteFencesAPPLE(n, nArray);
        this.println("");
    }

    public void glDeleteFencesAPPLE(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteFencesAPPLE(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteFencesAPPLE(n, intBuffer);
        this.println("");
    }

    public void glDeleteFencesNV(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteFencesNV(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteFencesNV(n, nArray);
        this.println("");
    }

    public void glDeleteFencesNV(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteFencesNV(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteFencesNV(n, intBuffer);
        this.println("");
    }

    public void glDeleteFragmentShaderATI(int n) {
        this.printIndent();
        this.print("glDeleteFragmentShaderATI(" + n + ")");
        this.downstreamGL.glDeleteFragmentShaderATI(n);
        this.println("");
    }

    public void glDeleteFramebuffersEXT(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteFramebuffersEXT(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteFramebuffersEXT(n, nArray);
        this.println("");
    }

    public void glDeleteFramebuffersEXT(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteFramebuffersEXT(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteFramebuffersEXT(n, intBuffer);
        this.println("");
    }

    public void glDeleteLists(int n, int n2) {
        this.printIndent();
        this.print("glDeleteLists(" + n + "," + n2 + ")");
        this.downstreamGL.glDeleteLists(n, n2);
        this.println("");
    }

    public void glDeleteObjectARB(int n) {
        this.printIndent();
        this.print("glDeleteObjectARB(" + n + ")");
        this.downstreamGL.glDeleteObjectARB(n);
        this.println("");
    }

    public void glDeleteOcclusionQueriesNV(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteOcclusionQueriesNV(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteOcclusionQueriesNV(n, nArray);
        this.println("");
    }

    public void glDeleteOcclusionQueriesNV(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteOcclusionQueriesNV(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteOcclusionQueriesNV(n, intBuffer);
        this.println("");
    }

    public void glDeleteProgram(int n) {
        this.printIndent();
        this.print("glDeleteProgram(" + n + ")");
        this.downstreamGL.glDeleteProgram(n);
        this.println("");
    }

    public void glDeleteProgramsARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteProgramsARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteProgramsARB(n, nArray);
        this.println("");
    }

    public void glDeleteProgramsARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteProgramsARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteProgramsARB(n, intBuffer);
        this.println("");
    }

    public void glDeleteProgramsNV(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteProgramsNV(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteProgramsNV(n, nArray);
        this.println("");
    }

    public void glDeleteProgramsNV(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteProgramsNV(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteProgramsNV(n, intBuffer);
        this.println("");
    }

    public void glDeleteQueries(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteQueries(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteQueries(n, nArray);
        this.println("");
    }

    public void glDeleteQueries(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteQueries(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteQueries(n, intBuffer);
        this.println("");
    }

    public void glDeleteQueriesARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteQueriesARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteQueriesARB(n, nArray);
        this.println("");
    }

    public void glDeleteQueriesARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteQueriesARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteQueriesARB(n, intBuffer);
        this.println("");
    }

    public void glDeleteRenderbuffersEXT(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteRenderbuffersEXT(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteRenderbuffersEXT(n, nArray);
        this.println("");
    }

    public void glDeleteRenderbuffersEXT(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteRenderbuffersEXT(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteRenderbuffersEXT(n, intBuffer);
        this.println("");
    }

    public void glDeleteShader(int n) {
        this.printIndent();
        this.print("glDeleteShader(" + n + ")");
        this.downstreamGL.glDeleteShader(n);
        this.println("");
    }

    public void glDeleteTextures(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteTextures(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteTextures(n, nArray);
        this.println("");
    }

    public void glDeleteTextures(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteTextures(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteTextures(n, intBuffer);
        this.println("");
    }

    public void glDeleteTexturesEXT(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteTexturesEXT(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteTexturesEXT(n, nArray);
        this.println("");
    }

    public void glDeleteTexturesEXT(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteTexturesEXT(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteTexturesEXT(n, intBuffer);
        this.println("");
    }

    public void glDeleteVertexArraysAPPLE(int n, int[] nArray) {
        this.printIndent();
        this.print("glDeleteVertexArraysAPPLE(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDeleteVertexArraysAPPLE(n, nArray);
        this.println("");
    }

    public void glDeleteVertexArraysAPPLE(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteVertexArraysAPPLE(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDeleteVertexArraysAPPLE(n, intBuffer);
        this.println("");
    }

    public void glDeleteVertexShaderEXT(int n) {
        this.printIndent();
        this.print("glDeleteVertexShaderEXT(" + n + ")");
        this.downstreamGL.glDeleteVertexShaderEXT(n);
        this.println("");
    }

    public void glDepthBoundsEXT(double d, double d2) {
        this.printIndent();
        this.print("glDepthBoundsEXT(" + d + "," + d2 + ")");
        this.downstreamGL.glDepthBoundsEXT(d, d2);
        this.println("");
    }

    public void glDepthFunc(int n) {
        this.printIndent();
        this.print("glDepthFunc(" + n + ")");
        this.downstreamGL.glDepthFunc(n);
        this.println("");
    }

    public void glDepthMask(boolean bl) {
        this.printIndent();
        this.print("glDepthMask(" + bl + ")");
        this.downstreamGL.glDepthMask(bl);
        this.println("");
    }

    public void glDepthRange(double d, double d2) {
        this.printIndent();
        this.print("glDepthRange(" + d + "," + d2 + ")");
        this.downstreamGL.glDepthRange(d, d2);
        this.println("");
    }

    public void glDetachObjectARB(int n, int n2) {
        this.printIndent();
        this.print("glDetachObjectARB(" + n + "," + n2 + ")");
        this.downstreamGL.glDetachObjectARB(n, n2);
        this.println("");
    }

    public void glDetachShader(int n, int n2) {
        this.printIndent();
        this.print("glDetachShader(" + n + "," + n2 + ")");
        this.downstreamGL.glDetachShader(n, n2);
        this.println("");
    }

    public void glDetailTexFuncSGIS(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glDetailTexFuncSGIS(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glDetailTexFuncSGIS(n, n2, fArray);
        this.println("");
    }

    public void glDetailTexFuncSGIS(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glDetailTexFuncSGIS(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glDetailTexFuncSGIS(n, n2, floatBuffer);
        this.println("");
    }

    public void glDisable(int n) {
        this.printIndent();
        this.print("glDisable(" + n + ")");
        this.downstreamGL.glDisable(n);
        this.println("");
    }

    public void glDisableClientState(int n) {
        this.printIndent();
        this.print("glDisableClientState(" + n + ")");
        this.downstreamGL.glDisableClientState(n);
        this.println("");
    }

    public void glDisableVariantClientStateEXT(int n) {
        this.printIndent();
        this.print("glDisableVariantClientStateEXT(" + n + ")");
        this.downstreamGL.glDisableVariantClientStateEXT(n);
        this.println("");
    }

    public void glDisableVertexAttribAPPLE(int n, int n2) {
        this.printIndent();
        this.print("glDisableVertexAttribAPPLE(" + n + "," + n2 + ")");
        this.downstreamGL.glDisableVertexAttribAPPLE(n, n2);
        this.println("");
    }

    public void glDisableVertexAttribArray(int n) {
        this.printIndent();
        this.print("glDisableVertexAttribArray(" + n + ")");
        this.downstreamGL.glDisableVertexAttribArray(n);
        this.println("");
    }

    public void glDisableVertexAttribArrayARB(int n) {
        this.printIndent();
        this.print("glDisableVertexAttribArrayARB(" + n + ")");
        this.downstreamGL.glDisableVertexAttribArrayARB(n);
        this.println("");
    }

    public void glDrawArrays(int n, int n2, int n3) {
        this.printIndent();
        this.print("glDrawArrays(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glDrawArrays(n, n2, n3);
        this.println("");
    }

    public void glDrawArraysEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glDrawArraysEXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glDrawArraysEXT(n, n2, n3);
        this.println("");
    }

    public void glDrawBuffer(int n) {
        this.printIndent();
        this.print("glDrawBuffer(" + n + ")");
        this.downstreamGL.glDrawBuffer(n);
        this.println("");
    }

    public void glDrawBufferRegion(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glDrawBufferRegion(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glDrawBufferRegion(n, n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    public void glDrawBuffers(int n, int[] nArray) {
        this.printIndent();
        this.print("glDrawBuffers(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDrawBuffers(n, nArray);
        this.println("");
    }

    public void glDrawBuffers(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDrawBuffers(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDrawBuffers(n, intBuffer);
        this.println("");
    }

    public void glDrawBuffersARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glDrawBuffersARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDrawBuffersARB(n, nArray);
        this.println("");
    }

    public void glDrawBuffersARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDrawBuffersARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDrawBuffersARB(n, intBuffer);
        this.println("");
    }

    public void glDrawBuffersATI(int n, int[] nArray) {
        this.printIndent();
        this.print("glDrawBuffersATI(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDrawBuffersATI(n, nArray);
        this.println("");
    }

    public void glDrawBuffersATI(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDrawBuffersATI(" + n + "," + intBuffer + ")");
        this.downstreamGL.glDrawBuffersATI(n, intBuffer);
        this.println("");
    }

    public void glDrawElementArrayAPPLE(int n, int n2, int n3) {
        this.printIndent();
        this.print("glDrawElementArrayAPPLE(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glDrawElementArrayAPPLE(n, n2, n3);
        this.println("");
    }

    public void glDrawElementArrayATI(int n, int n2) {
        this.printIndent();
        this.print("glDrawElementArrayATI(" + n + "," + n2 + ")");
        this.downstreamGL.glDrawElementArrayATI(n, n2);
        this.println("");
    }

    public void glDrawElementArrayNV(int n, int n2, int n3) {
        this.printIndent();
        this.print("glDrawElementArrayNV(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glDrawElementArrayNV(n, n2, n3);
        this.println("");
    }

    public void glDrawElements(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glDrawElements(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glDrawElements(n, n2, n3, blArray);
        this.println("");
    }

    public void glDrawElements(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glDrawElements(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glDrawElements(n, n2, n3, cArray);
        this.println("");
    }

    public void glDrawElements(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glDrawElements(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glDrawElements(n, n2, n3, byArray);
        this.println("");
    }

    public void glDrawElements(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glDrawElements(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glDrawElements(n, n2, n3, sArray);
        this.println("");
    }

    public void glDrawElements(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glDrawElements(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDrawElements(n, n2, n3, nArray);
        this.println("");
    }

    public void glDrawElements(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glDrawElements(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glDrawElements(n, n2, n3, lArray);
        this.println("");
    }

    public void glDrawElements(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glDrawElements(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glDrawElements(n, n2, n3, fArray);
        this.println("");
    }

    public void glDrawElements(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glDrawElements(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glDrawElements(n, n2, n3, dArray);
        this.println("");
    }

    public void glDrawElements(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glDrawElements(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glDrawElements(n, n2, n3, buffer);
        this.println("");
    }

    public void glDrawMeshArraysSUN(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glDrawMeshArraysSUN(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glDrawMeshArraysSUN(n, n2, n3, n4);
        this.println("");
    }

    public void glDrawPixels(int n, int n2, int n3, int n4, boolean[] blArray) {
        this.printIndent();
        this.print("glDrawPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glDrawPixels(n, n2, n3, n4, blArray);
        this.println("");
    }

    public void glDrawPixels(int n, int n2, int n3, int n4, char[] cArray) {
        this.printIndent();
        this.print("glDrawPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glDrawPixels(n, n2, n3, n4, cArray);
        this.println("");
    }

    public void glDrawPixels(int n, int n2, int n3, int n4, byte[] byArray) {
        this.printIndent();
        this.print("glDrawPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glDrawPixels(n, n2, n3, n4, byArray);
        this.println("");
    }

    public void glDrawPixels(int n, int n2, int n3, int n4, short[] sArray) {
        this.printIndent();
        this.print("glDrawPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glDrawPixels(n, n2, n3, n4, sArray);
        this.println("");
    }

    public void glDrawPixels(int n, int n2, int n3, int n4, int[] nArray) {
        this.printIndent();
        this.print("glDrawPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDrawPixels(n, n2, n3, n4, nArray);
        this.println("");
    }

    public void glDrawPixels(int n, int n2, int n3, int n4, long[] lArray) {
        this.printIndent();
        this.print("glDrawPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glDrawPixels(n, n2, n3, n4, lArray);
        this.println("");
    }

    public void glDrawPixels(int n, int n2, int n3, int n4, float[] fArray) {
        this.printIndent();
        this.print("glDrawPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glDrawPixels(n, n2, n3, n4, fArray);
        this.println("");
    }

    public void glDrawPixels(int n, int n2, int n3, int n4, double[] dArray) {
        this.printIndent();
        this.print("glDrawPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glDrawPixels(n, n2, n3, n4, dArray);
        this.println("");
    }

    public void glDrawPixels(int n, int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glDrawPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glDrawPixels(n, n2, n3, n4, buffer);
        this.println("");
    }

    public void glDrawRangeElementArrayAPPLE(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glDrawRangeElementArrayAPPLE(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glDrawRangeElementArrayAPPLE(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glDrawRangeElementArrayATI(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glDrawRangeElementArrayATI(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glDrawRangeElementArrayATI(n, n2, n3, n4);
        this.println("");
    }

    public void glDrawRangeElementArrayNV(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glDrawRangeElementArrayNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glDrawRangeElementArrayNV(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, boolean[] blArray) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glDrawRangeElements(n, n2, n3, n4, n5, blArray);
        this.println("");
    }

    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, char[] cArray) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glDrawRangeElements(n, n2, n3, n4, n5, cArray);
        this.println("");
    }

    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glDrawRangeElements(n, n2, n3, n4, n5, byArray);
        this.println("");
    }

    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glDrawRangeElements(n, n2, n3, n4, n5, sArray);
        this.println("");
    }

    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDrawRangeElements(n, n2, n3, n4, n5, nArray);
        this.println("");
    }

    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, long[] lArray) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glDrawRangeElements(n, n2, n3, n4, n5, lArray);
        this.println("");
    }

    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glDrawRangeElements(n, n2, n3, n4, n5, fArray);
        this.println("");
    }

    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glDrawRangeElements(n, n2, n3, n4, n5, dArray);
        this.println("");
    }

    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glDrawRangeElements(n, n2, n3, n4, n5, buffer);
        this.println("");
    }

    public void glDrawRangeElementsEXT(int n, int n2, int n3, int n4, int n5, boolean[] blArray) {
        this.printIndent();
        this.print("glDrawRangeElementsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glDrawRangeElementsEXT(n, n2, n3, n4, n5, blArray);
        this.println("");
    }

    public void glDrawRangeElementsEXT(int n, int n2, int n3, int n4, int n5, char[] cArray) {
        this.printIndent();
        this.print("glDrawRangeElementsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glDrawRangeElementsEXT(n, n2, n3, n4, n5, cArray);
        this.println("");
    }

    public void glDrawRangeElementsEXT(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.printIndent();
        this.print("glDrawRangeElementsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glDrawRangeElementsEXT(n, n2, n3, n4, n5, byArray);
        this.println("");
    }

    public void glDrawRangeElementsEXT(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        this.printIndent();
        this.print("glDrawRangeElementsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glDrawRangeElementsEXT(n, n2, n3, n4, n5, sArray);
        this.println("");
    }

    public void glDrawRangeElementsEXT(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.printIndent();
        this.print("glDrawRangeElementsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glDrawRangeElementsEXT(n, n2, n3, n4, n5, nArray);
        this.println("");
    }

    public void glDrawRangeElementsEXT(int n, int n2, int n3, int n4, int n5, long[] lArray) {
        this.printIndent();
        this.print("glDrawRangeElementsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glDrawRangeElementsEXT(n, n2, n3, n4, n5, lArray);
        this.println("");
    }

    public void glDrawRangeElementsEXT(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glDrawRangeElementsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glDrawRangeElementsEXT(n, n2, n3, n4, n5, fArray);
        this.println("");
    }

    public void glDrawRangeElementsEXT(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glDrawRangeElementsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glDrawRangeElementsEXT(n, n2, n3, n4, n5, dArray);
        this.println("");
    }

    public void glDrawRangeElementsEXT(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glDrawRangeElementsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glDrawRangeElementsEXT(n, n2, n3, n4, n5, buffer);
        this.println("");
    }

    public void glEdgeFlag(boolean bl) {
        this.printIndent();
        this.print("glEdgeFlag(" + bl + ")");
        this.downstreamGL.glEdgeFlag(bl);
        this.println("");
    }

    public void glEdgeFlagPointer(int n, Buffer buffer) {
        this.printIndent();
        this.print("glEdgeFlagPointer(" + n + "," + buffer + ")");
        this.downstreamGL.glEdgeFlagPointer(n, buffer);
        this.println("");
    }

    public void glEdgeFlagPointerEXT(int n, int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glEdgeFlagPointerEXT(" + n + "," + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glEdgeFlagPointerEXT(n, n2, byteBuffer);
        this.println("");
    }

    public void glEdgeFlagPointerListIBM(int n, ByteBuffer[] byteBufferArray, int n2) {
        this.printIndent();
        this.print("glEdgeFlagPointerListIBM(" + n + "," + this.dumpArray(byteBufferArray) + "," + n2 + ")");
        this.downstreamGL.glEdgeFlagPointerListIBM(n, byteBufferArray, n2);
        this.println("");
    }

    public void glEdgeFlagv(byte[] byArray) {
        this.printIndent();
        this.print("glEdgeFlagv(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glEdgeFlagv(byArray);
        this.println("");
    }

    public void glEdgeFlagv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glEdgeFlagv(" + byteBuffer + ")");
        this.downstreamGL.glEdgeFlagv(byteBuffer);
        this.println("");
    }

    public void glElementPointerAPPLE(int n, boolean[] blArray) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glElementPointerAPPLE(n, blArray);
        this.println("");
    }

    public void glElementPointerAPPLE(int n, char[] cArray) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glElementPointerAPPLE(n, cArray);
        this.println("");
    }

    public void glElementPointerAPPLE(int n, byte[] byArray) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glElementPointerAPPLE(n, byArray);
        this.println("");
    }

    public void glElementPointerAPPLE(int n, short[] sArray) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glElementPointerAPPLE(n, sArray);
        this.println("");
    }

    public void glElementPointerAPPLE(int n, int[] nArray) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glElementPointerAPPLE(n, nArray);
        this.println("");
    }

    public void glElementPointerAPPLE(int n, long[] lArray) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glElementPointerAPPLE(n, lArray);
        this.println("");
    }

    public void glElementPointerAPPLE(int n, float[] fArray) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glElementPointerAPPLE(n, fArray);
        this.println("");
    }

    public void glElementPointerAPPLE(int n, double[] dArray) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glElementPointerAPPLE(n, dArray);
        this.println("");
    }

    public void glElementPointerAPPLE(int n, Buffer buffer) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n + "," + buffer + ")");
        this.downstreamGL.glElementPointerAPPLE(n, buffer);
        this.println("");
    }

    public void glElementPointerATI(int n, Buffer buffer) {
        this.printIndent();
        this.print("glElementPointerATI(" + n + "," + buffer + ")");
        this.downstreamGL.glElementPointerATI(n, buffer);
        this.println("");
    }

    public void glElementPointerNV(int n, Buffer buffer) {
        this.printIndent();
        this.print("glElementPointerNV(" + n + "," + buffer + ")");
        this.downstreamGL.glElementPointerNV(n, buffer);
        this.println("");
    }

    public void glEnable(int n) {
        this.printIndent();
        this.print("glEnable(" + n + ")");
        this.downstreamGL.glEnable(n);
        this.println("");
    }

    public void glEnableClientState(int n) {
        this.printIndent();
        this.print("glEnableClientState(" + n + ")");
        this.downstreamGL.glEnableClientState(n);
        this.println("");
    }

    public void glEnableVariantClientStateEXT(int n) {
        this.printIndent();
        this.print("glEnableVariantClientStateEXT(" + n + ")");
        this.downstreamGL.glEnableVariantClientStateEXT(n);
        this.println("");
    }

    public void glEnableVertexAttribAPPLE(int n, int n2) {
        this.printIndent();
        this.print("glEnableVertexAttribAPPLE(" + n + "," + n2 + ")");
        this.downstreamGL.glEnableVertexAttribAPPLE(n, n2);
        this.println("");
    }

    public void glEnableVertexAttribArray(int n) {
        this.printIndent();
        this.print("glEnableVertexAttribArray(" + n + ")");
        this.downstreamGL.glEnableVertexAttribArray(n);
        this.println("");
    }

    public void glEnableVertexAttribArrayARB(int n) {
        this.printIndent();
        this.print("glEnableVertexAttribArrayARB(" + n + ")");
        this.downstreamGL.glEnableVertexAttribArrayARB(n);
        this.println("");
    }

    public void glEnd() {
        this.indent -= 2;
        this.printIndent();
        this.print("glEnd()");
        this.downstreamGL.glEnd();
        this.println("");
    }

    public void glEndFragmentShaderATI() {
        this.printIndent();
        this.print("glEndFragmentShaderATI()");
        this.downstreamGL.glEndFragmentShaderATI();
        this.println("");
    }

    public void glEndList() {
        this.indent -= 2;
        this.printIndent();
        this.print("glEndList()");
        this.downstreamGL.glEndList();
        this.println("");
    }

    public void glEndOcclusionQueryNV() {
        this.printIndent();
        this.print("glEndOcclusionQueryNV()");
        this.downstreamGL.glEndOcclusionQueryNV();
        this.println("");
    }

    public void glEndQuery(int n) {
        this.printIndent();
        this.print("glEndQuery(" + n + ")");
        this.downstreamGL.glEndQuery(n);
        this.println("");
    }

    public void glEndQueryARB(int n) {
        this.printIndent();
        this.print("glEndQueryARB(" + n + ")");
        this.downstreamGL.glEndQueryARB(n);
        this.println("");
    }

    public void glEndVertexShaderEXT() {
        this.printIndent();
        this.print("glEndVertexShaderEXT()");
        this.downstreamGL.glEndVertexShaderEXT();
        this.println("");
    }

    public void glEvalCoord1d(double d) {
        this.printIndent();
        this.print("glEvalCoord1d(" + d + ")");
        this.downstreamGL.glEvalCoord1d(d);
        this.println("");
    }

    public void glEvalCoord1dv(double[] dArray) {
        this.printIndent();
        this.print("glEvalCoord1dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glEvalCoord1dv(dArray);
        this.println("");
    }

    public void glEvalCoord1dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glEvalCoord1dv(" + doubleBuffer + ")");
        this.downstreamGL.glEvalCoord1dv(doubleBuffer);
        this.println("");
    }

    public void glEvalCoord1f(float f) {
        this.printIndent();
        this.print("glEvalCoord1f(" + f + ")");
        this.downstreamGL.glEvalCoord1f(f);
        this.println("");
    }

    public void glEvalCoord1fv(float[] fArray) {
        this.printIndent();
        this.print("glEvalCoord1fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glEvalCoord1fv(fArray);
        this.println("");
    }

    public void glEvalCoord1fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glEvalCoord1fv(" + floatBuffer + ")");
        this.downstreamGL.glEvalCoord1fv(floatBuffer);
        this.println("");
    }

    public void glEvalCoord2d(double d, double d2) {
        this.printIndent();
        this.print("glEvalCoord2d(" + d + "," + d2 + ")");
        this.downstreamGL.glEvalCoord2d(d, d2);
        this.println("");
    }

    public void glEvalCoord2dv(double[] dArray) {
        this.printIndent();
        this.print("glEvalCoord2dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glEvalCoord2dv(dArray);
        this.println("");
    }

    public void glEvalCoord2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glEvalCoord2dv(" + doubleBuffer + ")");
        this.downstreamGL.glEvalCoord2dv(doubleBuffer);
        this.println("");
    }

    public void glEvalCoord2f(float f, float f2) {
        this.printIndent();
        this.print("glEvalCoord2f(" + f + "," + f2 + ")");
        this.downstreamGL.glEvalCoord2f(f, f2);
        this.println("");
    }

    public void glEvalCoord2fv(float[] fArray) {
        this.printIndent();
        this.print("glEvalCoord2fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glEvalCoord2fv(fArray);
        this.println("");
    }

    public void glEvalCoord2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glEvalCoord2fv(" + floatBuffer + ")");
        this.downstreamGL.glEvalCoord2fv(floatBuffer);
        this.println("");
    }

    public void glEvalMapsNV(int n, int n2) {
        this.printIndent();
        this.print("glEvalMapsNV(" + n + "," + n2 + ")");
        this.downstreamGL.glEvalMapsNV(n, n2);
        this.println("");
    }

    public void glEvalMesh1(int n, int n2, int n3) {
        this.printIndent();
        this.print("glEvalMesh1(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glEvalMesh1(n, n2, n3);
        this.println("");
    }

    public void glEvalMesh2(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glEvalMesh2(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glEvalMesh2(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glEvalPoint1(int n) {
        this.printIndent();
        this.print("glEvalPoint1(" + n + ")");
        this.downstreamGL.glEvalPoint1(n);
        this.println("");
    }

    public void glEvalPoint2(int n, int n2) {
        this.printIndent();
        this.print("glEvalPoint2(" + n + "," + n2 + ")");
        this.downstreamGL.glEvalPoint2(n, n2);
        this.println("");
    }

    public void glExecuteProgramNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glExecuteProgramNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glExecuteProgramNV(n, n2, fArray);
        this.println("");
    }

    public void glExecuteProgramNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glExecuteProgramNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glExecuteProgramNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glExtractComponentEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glExtractComponentEXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glExtractComponentEXT(n, n2, n3);
        this.println("");
    }

    public void glFeedbackBuffer(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFeedbackBuffer(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glFeedbackBuffer(n, n2, floatBuffer);
        this.println("");
    }

    public void glFinalCombinerInputNV(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glFinalCombinerInputNV(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glFinalCombinerInputNV(n, n2, n3, n4);
        this.println("");
    }

    public void glFinish() {
        this.printIndent();
        this.print("glFinish()");
        this.downstreamGL.glFinish();
        this.println("");
    }

    public int glFinishAsyncSGIX(int[] nArray) {
        this.printIndent();
        this.print("glFinishAsyncSGIX(" + this.dumpArray(nArray) + ")");
        int n = this.downstreamGL.glFinishAsyncSGIX(nArray);
        this.println(" = " + n);
        return n;
    }

    public int glFinishAsyncSGIX(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFinishAsyncSGIX(" + intBuffer + ")");
        int n = this.downstreamGL.glFinishAsyncSGIX(intBuffer);
        this.println(" = " + n);
        return n;
    }

    public void glFinishFenceAPPLE(int n) {
        this.printIndent();
        this.print("glFinishFenceAPPLE(" + n + ")");
        this.downstreamGL.glFinishFenceAPPLE(n);
        this.println("");
    }

    public void glFinishFenceNV(int n) {
        this.printIndent();
        this.print("glFinishFenceNV(" + n + ")");
        this.downstreamGL.glFinishFenceNV(n);
        this.println("");
    }

    public void glFinishObjectAPPLE(int n, int n2) {
        this.printIndent();
        this.print("glFinishObjectAPPLE(" + n + "," + n2 + ")");
        this.downstreamGL.glFinishObjectAPPLE(n, n2);
        this.println("");
    }

    public void glFinishRenderAPPLE() {
        this.printIndent();
        this.print("glFinishRenderAPPLE()");
        this.downstreamGL.glFinishRenderAPPLE();
        this.println("");
    }

    public void glFinishTextureSUNX() {
        this.printIndent();
        this.print("glFinishTextureSUNX()");
        this.downstreamGL.glFinishTextureSUNX();
        this.println("");
    }

    public void glFlush() {
        this.printIndent();
        this.print("glFlush()");
        this.downstreamGL.glFlush();
        this.println("");
    }

    public void glFlushPixelDataRangeNV(int n) {
        this.printIndent();
        this.print("glFlushPixelDataRangeNV(" + n + ")");
        this.downstreamGL.glFlushPixelDataRangeNV(n);
        this.println("");
    }

    public void glFlushRasterSGIX() {
        this.printIndent();
        this.print("glFlushRasterSGIX()");
        this.downstreamGL.glFlushRasterSGIX();
        this.println("");
    }

    public void glFlushRenderAPPLE() {
        this.printIndent();
        this.print("glFlushRenderAPPLE()");
        this.downstreamGL.glFlushRenderAPPLE();
        this.println("");
    }

    public void glFlushVertexArrayRangeAPPLE(int n, boolean[] blArray) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n, blArray);
        this.println("");
    }

    public void glFlushVertexArrayRangeAPPLE(int n, char[] cArray) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n, cArray);
        this.println("");
    }

    public void glFlushVertexArrayRangeAPPLE(int n, byte[] byArray) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n, byArray);
        this.println("");
    }

    public void glFlushVertexArrayRangeAPPLE(int n, short[] sArray) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n, sArray);
        this.println("");
    }

    public void glFlushVertexArrayRangeAPPLE(int n, int[] nArray) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n, nArray);
        this.println("");
    }

    public void glFlushVertexArrayRangeAPPLE(int n, long[] lArray) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n, lArray);
        this.println("");
    }

    public void glFlushVertexArrayRangeAPPLE(int n, float[] fArray) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n, fArray);
        this.println("");
    }

    public void glFlushVertexArrayRangeAPPLE(int n, double[] dArray) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n, dArray);
        this.println("");
    }

    public void glFlushVertexArrayRangeAPPLE(int n, Buffer buffer) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n + "," + buffer + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n, buffer);
        this.println("");
    }

    public void glFlushVertexArrayRangeNV() {
        this.printIndent();
        this.print("glFlushVertexArrayRangeNV()");
        this.downstreamGL.glFlushVertexArrayRangeNV();
        this.println("");
    }

    public void glFogCoordPointer(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glFogCoordPointer(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glFogCoordPointer(n, n2, buffer);
        this.println("");
    }

    public void glFogCoordPointerEXT(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glFogCoordPointerEXT(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glFogCoordPointerEXT(n, n2, buffer);
        this.println("");
    }

    public void glFogCoordPointerListIBM(int n, int n2, Buffer[] bufferArray, int n3) {
        this.printIndent();
        this.print("glFogCoordPointerListIBM(" + n + "," + n2 + "," + this.dumpArray(bufferArray) + "," + n3 + ")");
        this.downstreamGL.glFogCoordPointerListIBM(n, n2, bufferArray, n3);
        this.println("");
    }

    public void glFogCoordd(double d) {
        this.printIndent();
        this.print("glFogCoordd(" + d + ")");
        this.downstreamGL.glFogCoordd(d);
        this.println("");
    }

    public void glFogCoorddEXT(double d) {
        this.printIndent();
        this.print("glFogCoorddEXT(" + d + ")");
        this.downstreamGL.glFogCoorddEXT(d);
        this.println("");
    }

    public void glFogCoorddv(double[] dArray) {
        this.printIndent();
        this.print("glFogCoorddv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glFogCoorddv(dArray);
        this.println("");
    }

    public void glFogCoorddv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glFogCoorddv(" + doubleBuffer + ")");
        this.downstreamGL.glFogCoorddv(doubleBuffer);
        this.println("");
    }

    public void glFogCoorddvEXT(double[] dArray) {
        this.printIndent();
        this.print("glFogCoorddvEXT(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glFogCoorddvEXT(dArray);
        this.println("");
    }

    public void glFogCoorddvEXT(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glFogCoorddvEXT(" + doubleBuffer + ")");
        this.downstreamGL.glFogCoorddvEXT(doubleBuffer);
        this.println("");
    }

    public void glFogCoordf(float f) {
        this.printIndent();
        this.print("glFogCoordf(" + f + ")");
        this.downstreamGL.glFogCoordf(f);
        this.println("");
    }

    public void glFogCoordfEXT(float f) {
        this.printIndent();
        this.print("glFogCoordfEXT(" + f + ")");
        this.downstreamGL.glFogCoordfEXT(f);
        this.println("");
    }

    public void glFogCoordfv(float[] fArray) {
        this.printIndent();
        this.print("glFogCoordfv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glFogCoordfv(fArray);
        this.println("");
    }

    public void glFogCoordfv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFogCoordfv(" + floatBuffer + ")");
        this.downstreamGL.glFogCoordfv(floatBuffer);
        this.println("");
    }

    public void glFogCoordfvEXT(float[] fArray) {
        this.printIndent();
        this.print("glFogCoordfvEXT(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glFogCoordfvEXT(fArray);
        this.println("");
    }

    public void glFogCoordfvEXT(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFogCoordfvEXT(" + floatBuffer + ")");
        this.downstreamGL.glFogCoordfvEXT(floatBuffer);
        this.println("");
    }

    public void glFogCoordhNV(short s) {
        this.printIndent();
        this.print("glFogCoordhNV(" + s + ")");
        this.downstreamGL.glFogCoordhNV(s);
        this.println("");
    }

    public void glFogCoordhvNV(short[] sArray) {
        this.printIndent();
        this.print("glFogCoordhvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glFogCoordhvNV(sArray);
        this.println("");
    }

    public void glFogCoordhvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glFogCoordhvNV(" + shortBuffer + ")");
        this.downstreamGL.glFogCoordhvNV(shortBuffer);
        this.println("");
    }

    public void glFogFuncSGIS(int n, float[] fArray) {
        this.printIndent();
        this.print("glFogFuncSGIS(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glFogFuncSGIS(n, fArray);
        this.println("");
    }

    public void glFogFuncSGIS(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFogFuncSGIS(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glFogFuncSGIS(n, floatBuffer);
        this.println("");
    }

    public void glFogf(int n, float f) {
        this.printIndent();
        this.print("glFogf(" + n + "," + f + ")");
        this.downstreamGL.glFogf(n, f);
        this.println("");
    }

    public void glFogfv(int n, float[] fArray) {
        this.printIndent();
        this.print("glFogfv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glFogfv(n, fArray);
        this.println("");
    }

    public void glFogfv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFogfv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glFogfv(n, floatBuffer);
        this.println("");
    }

    public void glFogi(int n, int n2) {
        this.printIndent();
        this.print("glFogi(" + n + "," + n2 + ")");
        this.downstreamGL.glFogi(n, n2);
        this.println("");
    }

    public void glFogiv(int n, int[] nArray) {
        this.printIndent();
        this.print("glFogiv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glFogiv(n, nArray);
        this.println("");
    }

    public void glFogiv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFogiv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glFogiv(n, intBuffer);
        this.println("");
    }

    public void glFragmentColorMaterialSGIX(int n, int n2) {
        this.printIndent();
        this.print("glFragmentColorMaterialSGIX(" + n + "," + n2 + ")");
        this.downstreamGL.glFragmentColorMaterialSGIX(n, n2);
        this.println("");
    }

    public void glFragmentLightModelfSGIX(int n, float f) {
        this.printIndent();
        this.print("glFragmentLightModelfSGIX(" + n + "," + f + ")");
        this.downstreamGL.glFragmentLightModelfSGIX(n, f);
        this.println("");
    }

    public void glFragmentLightModelfvSGIX(int n, float[] fArray) {
        this.printIndent();
        this.print("glFragmentLightModelfvSGIX(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glFragmentLightModelfvSGIX(n, fArray);
        this.println("");
    }

    public void glFragmentLightModelfvSGIX(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFragmentLightModelfvSGIX(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glFragmentLightModelfvSGIX(n, floatBuffer);
        this.println("");
    }

    public void glFragmentLightModeliSGIX(int n, int n2) {
        this.printIndent();
        this.print("glFragmentLightModeliSGIX(" + n + "," + n2 + ")");
        this.downstreamGL.glFragmentLightModeliSGIX(n, n2);
        this.println("");
    }

    public void glFragmentLightModelivSGIX(int n, int[] nArray) {
        this.printIndent();
        this.print("glFragmentLightModelivSGIX(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glFragmentLightModelivSGIX(n, nArray);
        this.println("");
    }

    public void glFragmentLightModelivSGIX(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFragmentLightModelivSGIX(" + n + "," + intBuffer + ")");
        this.downstreamGL.glFragmentLightModelivSGIX(n, intBuffer);
        this.println("");
    }

    public void glFragmentLightfSGIX(int n, int n2, float f) {
        this.printIndent();
        this.print("glFragmentLightfSGIX(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glFragmentLightfSGIX(n, n2, f);
        this.println("");
    }

    public void glFragmentLightfvSGIX(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glFragmentLightfvSGIX(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glFragmentLightfvSGIX(n, n2, fArray);
        this.println("");
    }

    public void glFragmentLightfvSGIX(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFragmentLightfvSGIX(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glFragmentLightfvSGIX(n, n2, floatBuffer);
        this.println("");
    }

    public void glFragmentLightiSGIX(int n, int n2, int n3) {
        this.printIndent();
        this.print("glFragmentLightiSGIX(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glFragmentLightiSGIX(n, n2, n3);
        this.println("");
    }

    public void glFragmentLightivSGIX(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glFragmentLightivSGIX(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glFragmentLightivSGIX(n, n2, nArray);
        this.println("");
    }

    public void glFragmentLightivSGIX(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFragmentLightivSGIX(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glFragmentLightivSGIX(n, n2, intBuffer);
        this.println("");
    }

    public void glFragmentMaterialfSGIX(int n, int n2, float f) {
        this.printIndent();
        this.print("glFragmentMaterialfSGIX(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glFragmentMaterialfSGIX(n, n2, f);
        this.println("");
    }

    public void glFragmentMaterialfvSGIX(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glFragmentMaterialfvSGIX(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glFragmentMaterialfvSGIX(n, n2, fArray);
        this.println("");
    }

    public void glFragmentMaterialfvSGIX(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFragmentMaterialfvSGIX(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glFragmentMaterialfvSGIX(n, n2, floatBuffer);
        this.println("");
    }

    public void glFragmentMaterialiSGIX(int n, int n2, int n3) {
        this.printIndent();
        this.print("glFragmentMaterialiSGIX(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glFragmentMaterialiSGIX(n, n2, n3);
        this.println("");
    }

    public void glFragmentMaterialivSGIX(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glFragmentMaterialivSGIX(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glFragmentMaterialivSGIX(n, n2, nArray);
        this.println("");
    }

    public void glFragmentMaterialivSGIX(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFragmentMaterialivSGIX(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glFragmentMaterialivSGIX(n, n2, intBuffer);
        this.println("");
    }

    public void glFrameZoomSGIX(int n) {
        this.printIndent();
        this.print("glFrameZoomSGIX(" + n + ")");
        this.downstreamGL.glFrameZoomSGIX(n);
        this.println("");
    }

    public void glFramebufferRenderbufferEXT(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glFramebufferRenderbufferEXT(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glFramebufferRenderbufferEXT(n, n2, n3, n4);
        this.println("");
    }

    public void glFramebufferTexture1DEXT(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glFramebufferTexture1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glFramebufferTexture1DEXT(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glFramebufferTexture2DEXT(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glFramebufferTexture2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glFramebufferTexture2DEXT(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glFramebufferTexture3DEXT(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glFramebufferTexture3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glFramebufferTexture3DEXT(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public void glFreeObjectBufferATI(int n) {
        this.printIndent();
        this.print("glFreeObjectBufferATI(" + n + ")");
        this.downstreamGL.glFreeObjectBufferATI(n);
        this.println("");
    }

    public void glFrontFace(int n) {
        this.printIndent();
        this.print("glFrontFace(" + n + ")");
        this.downstreamGL.glFrontFace(n);
        this.println("");
    }

    public void glFrustum(double d, double d2, double d3, double d4, double d5, double d6) {
        this.printIndent();
        this.print("glFrustum(" + d + "," + d2 + "," + d3 + "," + d4 + "," + d5 + "," + d6 + ")");
        this.downstreamGL.glFrustum(d, d2, d3, d4, d5, d6);
        this.println("");
    }

    public int glGenAsyncMarkersSGIX(int n) {
        this.printIndent();
        this.print("glGenAsyncMarkersSGIX(" + n + ")");
        int n2 = this.downstreamGL.glGenAsyncMarkersSGIX(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glGenBuffers(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenBuffers(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenBuffers(n, nArray);
        this.println("");
    }

    public void glGenBuffers(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenBuffers(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenBuffers(n, intBuffer);
        this.println("");
    }

    public void glGenBuffersARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenBuffersARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenBuffersARB(n, nArray);
        this.println("");
    }

    public void glGenBuffersARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenBuffersARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenBuffersARB(n, intBuffer);
        this.println("");
    }

    public void glGenFencesAPPLE(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenFencesAPPLE(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenFencesAPPLE(n, nArray);
        this.println("");
    }

    public void glGenFencesAPPLE(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenFencesAPPLE(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenFencesAPPLE(n, intBuffer);
        this.println("");
    }

    public void glGenFencesNV(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenFencesNV(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenFencesNV(n, nArray);
        this.println("");
    }

    public void glGenFencesNV(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenFencesNV(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenFencesNV(n, intBuffer);
        this.println("");
    }

    public int glGenFragmentShadersATI(int n) {
        this.printIndent();
        this.print("glGenFragmentShadersATI(" + n + ")");
        int n2 = this.downstreamGL.glGenFragmentShadersATI(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glGenFramebuffersEXT(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenFramebuffersEXT(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenFramebuffersEXT(n, nArray);
        this.println("");
    }

    public void glGenFramebuffersEXT(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenFramebuffersEXT(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenFramebuffersEXT(n, intBuffer);
        this.println("");
    }

    public int glGenLists(int n) {
        this.printIndent();
        this.print("glGenLists(" + n + ")");
        int n2 = this.downstreamGL.glGenLists(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glGenOcclusionQueriesNV(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenOcclusionQueriesNV(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenOcclusionQueriesNV(n, nArray);
        this.println("");
    }

    public void glGenOcclusionQueriesNV(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenOcclusionQueriesNV(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenOcclusionQueriesNV(n, intBuffer);
        this.println("");
    }

    public void glGenProgramsARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenProgramsARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenProgramsARB(n, nArray);
        this.println("");
    }

    public void glGenProgramsARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenProgramsARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenProgramsARB(n, intBuffer);
        this.println("");
    }

    public void glGenProgramsNV(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenProgramsNV(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenProgramsNV(n, nArray);
        this.println("");
    }

    public void glGenProgramsNV(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenProgramsNV(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenProgramsNV(n, intBuffer);
        this.println("");
    }

    public void glGenQueries(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenQueries(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenQueries(n, nArray);
        this.println("");
    }

    public void glGenQueries(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenQueries(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenQueries(n, intBuffer);
        this.println("");
    }

    public void glGenQueriesARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenQueriesARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenQueriesARB(n, nArray);
        this.println("");
    }

    public void glGenQueriesARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenQueriesARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenQueriesARB(n, intBuffer);
        this.println("");
    }

    public void glGenRenderbuffersEXT(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenRenderbuffersEXT(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenRenderbuffersEXT(n, nArray);
        this.println("");
    }

    public void glGenRenderbuffersEXT(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenRenderbuffersEXT(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenRenderbuffersEXT(n, intBuffer);
        this.println("");
    }

    public int glGenSymbolsEXT(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glGenSymbolsEXT(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        int n5 = this.downstreamGL.glGenSymbolsEXT(n, n2, n3, n4);
        this.println(" = " + n5);
        return n5;
    }

    public void glGenTextures(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenTextures(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenTextures(n, nArray);
        this.println("");
    }

    public void glGenTextures(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenTextures(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenTextures(n, intBuffer);
        this.println("");
    }

    public void glGenTexturesEXT(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenTexturesEXT(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenTexturesEXT(n, nArray);
        this.println("");
    }

    public void glGenTexturesEXT(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenTexturesEXT(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenTexturesEXT(n, intBuffer);
        this.println("");
    }

    public void glGenVertexArraysAPPLE(int n, int[] nArray) {
        this.printIndent();
        this.print("glGenVertexArraysAPPLE(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGenVertexArraysAPPLE(n, nArray);
        this.println("");
    }

    public void glGenVertexArraysAPPLE(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenVertexArraysAPPLE(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGenVertexArraysAPPLE(n, intBuffer);
        this.println("");
    }

    public int glGenVertexShadersEXT(int n) {
        this.printIndent();
        this.print("glGenVertexShadersEXT(" + n + ")");
        int n2 = this.downstreamGL.glGenVertexShadersEXT(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glGenerateMipmapEXT(int n) {
        this.printIndent();
        this.print("glGenerateMipmapEXT(" + n + ")");
        this.downstreamGL.glGenerateMipmapEXT(n);
        this.println("");
    }

    public void glGetActiveAttrib(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, byte[] byArray) {
        this.printIndent();
        this.print("glGetActiveAttrib(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetActiveAttrib(n, n2, n3, nArray, nArray2, nArray3, byArray);
        this.println("");
    }

    public void glGetActiveAttrib(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetActiveAttrib(" + n + "," + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetActiveAttrib(n, n2, n3, intBuffer, intBuffer2, intBuffer3, byteBuffer);
        this.println("");
    }

    public void glGetActiveAttribARB(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, byte[] byArray) {
        this.printIndent();
        this.print("glGetActiveAttribARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetActiveAttribARB(n, n2, n3, nArray, nArray2, nArray3, byArray);
        this.println("");
    }

    public void glGetActiveAttribARB(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetActiveAttribARB(" + n + "," + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetActiveAttribARB(n, n2, n3, intBuffer, intBuffer2, intBuffer3, byteBuffer);
        this.println("");
    }

    public void glGetActiveUniform(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, byte[] byArray) {
        this.printIndent();
        this.print("glGetActiveUniform(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetActiveUniform(n, n2, n3, nArray, nArray2, nArray3, byArray);
        this.println("");
    }

    public void glGetActiveUniform(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetActiveUniform(" + n + "," + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetActiveUniform(n, n2, n3, intBuffer, intBuffer2, intBuffer3, byteBuffer);
        this.println("");
    }

    public void glGetActiveUniformARB(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, byte[] byArray) {
        this.printIndent();
        this.print("glGetActiveUniformARB(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetActiveUniformARB(n, n2, n3, nArray, nArray2, nArray3, byArray);
        this.println("");
    }

    public void glGetActiveUniformARB(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetActiveUniformARB(" + n + "," + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetActiveUniformARB(n, n2, n3, intBuffer, intBuffer2, intBuffer3, byteBuffer);
        this.println("");
    }

    public void glGetArrayObjectfvATI(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetArrayObjectfvATI(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetArrayObjectfvATI(n, n2, fArray);
        this.println("");
    }

    public void glGetArrayObjectfvATI(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetArrayObjectfvATI(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetArrayObjectfvATI(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetArrayObjectivATI(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetArrayObjectivATI(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetArrayObjectivATI(n, n2, nArray);
        this.println("");
    }

    public void glGetArrayObjectivATI(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetArrayObjectivATI(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetArrayObjectivATI(n, n2, intBuffer);
        this.println("");
    }

    public void glGetAttachedObjectsARB(int n, int n2, int[] nArray, int[] nArray2) {
        this.printIndent();
        this.print("glGetAttachedObjectsARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + ")");
        this.downstreamGL.glGetAttachedObjectsARB(n, n2, nArray, nArray2);
        this.println("");
    }

    public void glGetAttachedObjectsARB(int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        this.printIndent();
        this.print("glGetAttachedObjectsARB(" + n + "," + n2 + "," + intBuffer + "," + intBuffer2 + ")");
        this.downstreamGL.glGetAttachedObjectsARB(n, n2, intBuffer, intBuffer2);
        this.println("");
    }

    public void glGetAttachedShaders(int n, int n2, int[] nArray, int[] nArray2) {
        this.printIndent();
        this.print("glGetAttachedShaders(" + n + "," + n2 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + ")");
        this.downstreamGL.glGetAttachedShaders(n, n2, nArray, nArray2);
        this.println("");
    }

    public void glGetAttachedShaders(int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        this.printIndent();
        this.print("glGetAttachedShaders(" + n + "," + n2 + "," + intBuffer + "," + intBuffer2 + ")");
        this.downstreamGL.glGetAttachedShaders(n, n2, intBuffer, intBuffer2);
        this.println("");
    }

    public int glGetAttribLocation(int n, byte[] byArray) {
        this.printIndent();
        this.print("glGetAttribLocation(" + n + "," + this.dumpArray(byArray) + ")");
        int n2 = this.downstreamGL.glGetAttribLocation(n, byArray);
        this.println(" = " + n2);
        return n2;
    }

    public int glGetAttribLocation(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetAttribLocation(" + n + "," + byteBuffer + ")");
        int n2 = this.downstreamGL.glGetAttribLocation(n, byteBuffer);
        this.println(" = " + n2);
        return n2;
    }

    public int glGetAttribLocationARB(int n, String string) {
        this.printIndent();
        this.print("glGetAttribLocationARB(" + n + "," + string + ")");
        int n2 = this.downstreamGL.glGetAttribLocationARB(n, string);
        this.println(" = " + n2);
        return n2;
    }

    public void glGetBooleanv(int n, byte[] byArray) {
        this.printIndent();
        this.print("glGetBooleanv(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetBooleanv(n, byArray);
        this.println("");
    }

    public void glGetBooleanv(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetBooleanv(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glGetBooleanv(n, byteBuffer);
        this.println("");
    }

    public void glGetBufferParameteriv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetBufferParameteriv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetBufferParameteriv(n, n2, nArray);
        this.println("");
    }

    public void glGetBufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetBufferParameteriv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetBufferParameteriv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetBufferParameterivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetBufferParameterivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetBufferParameterivARB(n, n2, nArray);
        this.println("");
    }

    public void glGetBufferParameterivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetBufferParameterivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetBufferParameterivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glGetBufferSubData(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetBufferSubData(n, n2, n3, blArray);
        this.println("");
    }

    public void glGetBufferSubData(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetBufferSubData(n, n2, n3, cArray);
        this.println("");
    }

    public void glGetBufferSubData(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetBufferSubData(n, n2, n3, byArray);
        this.println("");
    }

    public void glGetBufferSubData(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetBufferSubData(n, n2, n3, sArray);
        this.println("");
    }

    public void glGetBufferSubData(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetBufferSubData(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetBufferSubData(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetBufferSubData(n, n2, n3, lArray);
        this.println("");
    }

    public void glGetBufferSubData(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetBufferSubData(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetBufferSubData(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetBufferSubData(n, n2, n3, dArray);
        this.println("");
    }

    public void glGetBufferSubData(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetBufferSubData(n, n2, n3, buffer);
        this.println("");
    }

    public void glGetBufferSubDataARB(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetBufferSubDataARB(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetBufferSubDataARB(n, n2, n3, buffer);
        this.println("");
    }

    public void glGetClipPlane(int n, double[] dArray) {
        this.printIndent();
        this.print("glGetClipPlane(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetClipPlane(n, dArray);
        this.println("");
    }

    public void glGetClipPlane(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetClipPlane(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glGetClipPlane(n, doubleBuffer);
        this.println("");
    }

    public void glGetColorTable(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetColorTable(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetColorTable(n, n2, n3, blArray);
        this.println("");
    }

    public void glGetColorTable(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetColorTable(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetColorTable(n, n2, n3, cArray);
        this.println("");
    }

    public void glGetColorTable(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetColorTable(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetColorTable(n, n2, n3, byArray);
        this.println("");
    }

    public void glGetColorTable(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetColorTable(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetColorTable(n, n2, n3, sArray);
        this.println("");
    }

    public void glGetColorTable(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetColorTable(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetColorTable(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetColorTable(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetColorTable(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetColorTable(n, n2, n3, lArray);
        this.println("");
    }

    public void glGetColorTable(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetColorTable(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetColorTable(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetColorTable(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetColorTable(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetColorTable(n, n2, n3, dArray);
        this.println("");
    }

    public void glGetColorTable(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetColorTable(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetColorTable(n, n2, n3, buffer);
        this.println("");
    }

    public void glGetColorTableEXT(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetColorTableEXT(n, n2, n3, blArray);
        this.println("");
    }

    public void glGetColorTableEXT(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetColorTableEXT(n, n2, n3, cArray);
        this.println("");
    }

    public void glGetColorTableEXT(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetColorTableEXT(n, n2, n3, byArray);
        this.println("");
    }

    public void glGetColorTableEXT(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetColorTableEXT(n, n2, n3, sArray);
        this.println("");
    }

    public void glGetColorTableEXT(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetColorTableEXT(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetColorTableEXT(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetColorTableEXT(n, n2, n3, lArray);
        this.println("");
    }

    public void glGetColorTableEXT(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetColorTableEXT(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetColorTableEXT(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetColorTableEXT(n, n2, n3, dArray);
        this.println("");
    }

    public void glGetColorTableEXT(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetColorTableEXT(n, n2, n3, buffer);
        this.println("");
    }

    public void glGetColorTableParameterfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetColorTableParameterfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetColorTableParameterfv(n, n2, fArray);
        this.println("");
    }

    public void glGetColorTableParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameterfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetColorTableParameterfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetColorTableParameterfvEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetColorTableParameterfvEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetColorTableParameterfvEXT(n, n2, fArray);
        this.println("");
    }

    public void glGetColorTableParameterfvEXT(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameterfvEXT(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetColorTableParameterfvEXT(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetColorTableParameterfvSGI(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetColorTableParameterfvSGI(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetColorTableParameterfvSGI(n, n2, fArray);
        this.println("");
    }

    public void glGetColorTableParameterfvSGI(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameterfvSGI(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetColorTableParameterfvSGI(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetColorTableParameteriv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetColorTableParameteriv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetColorTableParameteriv(n, n2, nArray);
        this.println("");
    }

    public void glGetColorTableParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameteriv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetColorTableParameteriv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetColorTableParameterivEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetColorTableParameterivEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetColorTableParameterivEXT(n, n2, nArray);
        this.println("");
    }

    public void glGetColorTableParameterivEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameterivEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetColorTableParameterivEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glGetColorTableParameterivSGI(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetColorTableParameterivSGI(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetColorTableParameterivSGI(n, n2, nArray);
        this.println("");
    }

    public void glGetColorTableParameterivSGI(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameterivSGI(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetColorTableParameterivSGI(n, n2, intBuffer);
        this.println("");
    }

    public void glGetColorTableSGI(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetColorTableSGI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetColorTableSGI(n, n2, n3, blArray);
        this.println("");
    }

    public void glGetColorTableSGI(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetColorTableSGI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetColorTableSGI(n, n2, n3, cArray);
        this.println("");
    }

    public void glGetColorTableSGI(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetColorTableSGI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetColorTableSGI(n, n2, n3, byArray);
        this.println("");
    }

    public void glGetColorTableSGI(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetColorTableSGI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetColorTableSGI(n, n2, n3, sArray);
        this.println("");
    }

    public void glGetColorTableSGI(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetColorTableSGI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetColorTableSGI(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetColorTableSGI(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetColorTableSGI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetColorTableSGI(n, n2, n3, lArray);
        this.println("");
    }

    public void glGetColorTableSGI(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetColorTableSGI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetColorTableSGI(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetColorTableSGI(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetColorTableSGI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetColorTableSGI(n, n2, n3, dArray);
        this.println("");
    }

    public void glGetColorTableSGI(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetColorTableSGI(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetColorTableSGI(n, n2, n3, buffer);
        this.println("");
    }

    public void glGetCombinerInputParameterfvNV(int n, int n2, int n3, int n4, float[] fArray) {
        this.printIndent();
        this.print("glGetCombinerInputParameterfvNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetCombinerInputParameterfvNV(n, n2, n3, n4, fArray);
        this.println("");
    }

    public void glGetCombinerInputParameterfvNV(int n, int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetCombinerInputParameterfvNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glGetCombinerInputParameterfvNV(n, n2, n3, n4, floatBuffer);
        this.println("");
    }

    public void glGetCombinerInputParameterivNV(int n, int n2, int n3, int n4, int[] nArray) {
        this.printIndent();
        this.print("glGetCombinerInputParameterivNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetCombinerInputParameterivNV(n, n2, n3, n4, nArray);
        this.println("");
    }

    public void glGetCombinerInputParameterivNV(int n, int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetCombinerInputParameterivNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glGetCombinerInputParameterivNV(n, n2, n3, n4, intBuffer);
        this.println("");
    }

    public void glGetCombinerOutputParameterfvNV(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetCombinerOutputParameterfvNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetCombinerOutputParameterfvNV(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetCombinerOutputParameterfvNV(int n, int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetCombinerOutputParameterfvNV(" + n + "," + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetCombinerOutputParameterfvNV(n, n2, n3, floatBuffer);
        this.println("");
    }

    public void glGetCombinerOutputParameterivNV(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetCombinerOutputParameterivNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetCombinerOutputParameterivNV(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetCombinerOutputParameterivNV(int n, int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetCombinerOutputParameterivNV(" + n + "," + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetCombinerOutputParameterivNV(n, n2, n3, intBuffer);
        this.println("");
    }

    public void glGetCombinerStageParameterfvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetCombinerStageParameterfvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetCombinerStageParameterfvNV(n, n2, fArray);
        this.println("");
    }

    public void glGetCombinerStageParameterfvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetCombinerStageParameterfvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetCombinerStageParameterfvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetCompressedTexImage(int n, int n2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n + "," + n2 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetCompressedTexImage(n, n2, blArray);
        this.println("");
    }

    public void glGetCompressedTexImage(int n, int n2, char[] cArray) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n + "," + n2 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetCompressedTexImage(n, n2, cArray);
        this.println("");
    }

    public void glGetCompressedTexImage(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetCompressedTexImage(n, n2, byArray);
        this.println("");
    }

    public void glGetCompressedTexImage(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetCompressedTexImage(n, n2, sArray);
        this.println("");
    }

    public void glGetCompressedTexImage(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetCompressedTexImage(n, n2, nArray);
        this.println("");
    }

    public void glGetCompressedTexImage(int n, int n2, long[] lArray) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n + "," + n2 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetCompressedTexImage(n, n2, lArray);
        this.println("");
    }

    public void glGetCompressedTexImage(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetCompressedTexImage(n, n2, fArray);
        this.println("");
    }

    public void glGetCompressedTexImage(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetCompressedTexImage(n, n2, dArray);
        this.println("");
    }

    public void glGetCompressedTexImage(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glGetCompressedTexImage(n, n2, buffer);
        this.println("");
    }

    public void glGetCompressedTexImageARB(int n, int n2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetCompressedTexImageARB(" + n + "," + n2 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetCompressedTexImageARB(n, n2, blArray);
        this.println("");
    }

    public void glGetCompressedTexImageARB(int n, int n2, char[] cArray) {
        this.printIndent();
        this.print("glGetCompressedTexImageARB(" + n + "," + n2 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetCompressedTexImageARB(n, n2, cArray);
        this.println("");
    }

    public void glGetCompressedTexImageARB(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glGetCompressedTexImageARB(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetCompressedTexImageARB(n, n2, byArray);
        this.println("");
    }

    public void glGetCompressedTexImageARB(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glGetCompressedTexImageARB(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetCompressedTexImageARB(n, n2, sArray);
        this.println("");
    }

    public void glGetCompressedTexImageARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetCompressedTexImageARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetCompressedTexImageARB(n, n2, nArray);
        this.println("");
    }

    public void glGetCompressedTexImageARB(int n, int n2, long[] lArray) {
        this.printIndent();
        this.print("glGetCompressedTexImageARB(" + n + "," + n2 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetCompressedTexImageARB(n, n2, lArray);
        this.println("");
    }

    public void glGetCompressedTexImageARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetCompressedTexImageARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetCompressedTexImageARB(n, n2, fArray);
        this.println("");
    }

    public void glGetCompressedTexImageARB(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glGetCompressedTexImageARB(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetCompressedTexImageARB(n, n2, dArray);
        this.println("");
    }

    public void glGetCompressedTexImageARB(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glGetCompressedTexImageARB(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glGetCompressedTexImageARB(n, n2, buffer);
        this.println("");
    }

    public void glGetConvolutionFilter(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetConvolutionFilter(n, n2, n3, blArray);
        this.println("");
    }

    public void glGetConvolutionFilter(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetConvolutionFilter(n, n2, n3, cArray);
        this.println("");
    }

    public void glGetConvolutionFilter(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetConvolutionFilter(n, n2, n3, byArray);
        this.println("");
    }

    public void glGetConvolutionFilter(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetConvolutionFilter(n, n2, n3, sArray);
        this.println("");
    }

    public void glGetConvolutionFilter(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetConvolutionFilter(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetConvolutionFilter(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetConvolutionFilter(n, n2, n3, lArray);
        this.println("");
    }

    public void glGetConvolutionFilter(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetConvolutionFilter(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetConvolutionFilter(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetConvolutionFilter(n, n2, n3, dArray);
        this.println("");
    }

    public void glGetConvolutionFilter(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetConvolutionFilter(n, n2, n3, buffer);
        this.println("");
    }

    public void glGetConvolutionFilterEXT(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetConvolutionFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetConvolutionFilterEXT(n, n2, n3, blArray);
        this.println("");
    }

    public void glGetConvolutionFilterEXT(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetConvolutionFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetConvolutionFilterEXT(n, n2, n3, cArray);
        this.println("");
    }

    public void glGetConvolutionFilterEXT(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetConvolutionFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetConvolutionFilterEXT(n, n2, n3, byArray);
        this.println("");
    }

    public void glGetConvolutionFilterEXT(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetConvolutionFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetConvolutionFilterEXT(n, n2, n3, sArray);
        this.println("");
    }

    public void glGetConvolutionFilterEXT(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetConvolutionFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetConvolutionFilterEXT(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetConvolutionFilterEXT(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetConvolutionFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetConvolutionFilterEXT(n, n2, n3, lArray);
        this.println("");
    }

    public void glGetConvolutionFilterEXT(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetConvolutionFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetConvolutionFilterEXT(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetConvolutionFilterEXT(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetConvolutionFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetConvolutionFilterEXT(n, n2, n3, dArray);
        this.println("");
    }

    public void glGetConvolutionFilterEXT(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetConvolutionFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetConvolutionFilterEXT(n, n2, n3, buffer);
        this.println("");
    }

    public void glGetConvolutionParameterfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetConvolutionParameterfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetConvolutionParameterfv(n, n2, fArray);
        this.println("");
    }

    public void glGetConvolutionParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetConvolutionParameterfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetConvolutionParameterfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetConvolutionParameterfvEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetConvolutionParameterfvEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetConvolutionParameterfvEXT(n, n2, fArray);
        this.println("");
    }

    public void glGetConvolutionParameterfvEXT(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetConvolutionParameterfvEXT(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetConvolutionParameterfvEXT(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetConvolutionParameteriv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetConvolutionParameteriv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetConvolutionParameteriv(n, n2, nArray);
        this.println("");
    }

    public void glGetConvolutionParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetConvolutionParameteriv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetConvolutionParameteriv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetConvolutionParameterivEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetConvolutionParameterivEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetConvolutionParameterivEXT(n, n2, nArray);
        this.println("");
    }

    public void glGetConvolutionParameterivEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetConvolutionParameterivEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetConvolutionParameterivEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glGetDetailTexFuncSGIS(int n, float[] fArray) {
        this.printIndent();
        this.print("glGetDetailTexFuncSGIS(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetDetailTexFuncSGIS(n, fArray);
        this.println("");
    }

    public void glGetDetailTexFuncSGIS(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetDetailTexFuncSGIS(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glGetDetailTexFuncSGIS(n, floatBuffer);
        this.println("");
    }

    public void glGetDoublev(int n, double[] dArray) {
        this.printIndent();
        this.print("glGetDoublev(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetDoublev(n, dArray);
        this.println("");
    }

    public void glGetDoublev(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetDoublev(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glGetDoublev(n, doubleBuffer);
        this.println("");
    }

    public int glGetError() {
        this.printIndent();
        this.print("glGetError()");
        int n = this.downstreamGL.glGetError();
        this.println(" = " + n);
        return n;
    }

    public void glGetFenceivNV(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetFenceivNV(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetFenceivNV(n, n2, nArray);
        this.println("");
    }

    public void glGetFenceivNV(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFenceivNV(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetFenceivNV(n, n2, intBuffer);
        this.println("");
    }

    public void glGetFinalCombinerInputParameterfvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetFinalCombinerInputParameterfvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetFinalCombinerInputParameterfvNV(n, n2, fArray);
        this.println("");
    }

    public void glGetFinalCombinerInputParameterfvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFinalCombinerInputParameterfvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetFinalCombinerInputParameterfvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetFinalCombinerInputParameterivNV(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetFinalCombinerInputParameterivNV(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetFinalCombinerInputParameterivNV(n, n2, nArray);
        this.println("");
    }

    public void glGetFinalCombinerInputParameterivNV(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFinalCombinerInputParameterivNV(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetFinalCombinerInputParameterivNV(n, n2, intBuffer);
        this.println("");
    }

    public void glGetFloatv(int n, float[] fArray) {
        this.printIndent();
        this.print("glGetFloatv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetFloatv(n, fArray);
        this.println("");
    }

    public void glGetFloatv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFloatv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glGetFloatv(n, floatBuffer);
        this.println("");
    }

    public void glGetFogFuncSGIS(float[] fArray) {
        this.printIndent();
        this.print("glGetFogFuncSGIS(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetFogFuncSGIS(fArray);
        this.println("");
    }

    public void glGetFogFuncSGIS(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFogFuncSGIS(" + floatBuffer + ")");
        this.downstreamGL.glGetFogFuncSGIS(floatBuffer);
        this.println("");
    }

    public void glGetFragmentLightfvSGIX(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetFragmentLightfvSGIX(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetFragmentLightfvSGIX(n, n2, fArray);
        this.println("");
    }

    public void glGetFragmentLightfvSGIX(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFragmentLightfvSGIX(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetFragmentLightfvSGIX(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetFragmentLightivSGIX(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetFragmentLightivSGIX(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetFragmentLightivSGIX(n, n2, nArray);
        this.println("");
    }

    public void glGetFragmentLightivSGIX(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFragmentLightivSGIX(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetFragmentLightivSGIX(n, n2, intBuffer);
        this.println("");
    }

    public void glGetFragmentMaterialfvSGIX(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetFragmentMaterialfvSGIX(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetFragmentMaterialfvSGIX(n, n2, fArray);
        this.println("");
    }

    public void glGetFragmentMaterialfvSGIX(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFragmentMaterialfvSGIX(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetFragmentMaterialfvSGIX(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetFragmentMaterialivSGIX(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetFragmentMaterialivSGIX(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetFragmentMaterialivSGIX(n, n2, nArray);
        this.println("");
    }

    public void glGetFragmentMaterialivSGIX(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFragmentMaterialivSGIX(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetFragmentMaterialivSGIX(n, n2, intBuffer);
        this.println("");
    }

    public void glGetFramebufferAttachmentParameterivEXT(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetFramebufferAttachmentParameterivEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetFramebufferAttachmentParameterivEXT(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetFramebufferAttachmentParameterivEXT(int n, int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFramebufferAttachmentParameterivEXT(" + n + "," + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetFramebufferAttachmentParameterivEXT(n, n2, n3, intBuffer);
        this.println("");
    }

    public int glGetHandleARB(int n) {
        this.printIndent();
        this.print("glGetHandleARB(" + n + ")");
        int n2 = this.downstreamGL.glGetHandleARB(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glGetHistogram(int n, boolean bl, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetHistogram(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetHistogram(n, bl, n2, n3, blArray);
        this.println("");
    }

    public void glGetHistogram(int n, boolean bl, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetHistogram(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetHistogram(n, bl, n2, n3, cArray);
        this.println("");
    }

    public void glGetHistogram(int n, boolean bl, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetHistogram(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetHistogram(n, bl, n2, n3, byArray);
        this.println("");
    }

    public void glGetHistogram(int n, boolean bl, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetHistogram(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetHistogram(n, bl, n2, n3, sArray);
        this.println("");
    }

    public void glGetHistogram(int n, boolean bl, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetHistogram(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetHistogram(n, bl, n2, n3, nArray);
        this.println("");
    }

    public void glGetHistogram(int n, boolean bl, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetHistogram(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetHistogram(n, bl, n2, n3, lArray);
        this.println("");
    }

    public void glGetHistogram(int n, boolean bl, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetHistogram(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetHistogram(n, bl, n2, n3, fArray);
        this.println("");
    }

    public void glGetHistogram(int n, boolean bl, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetHistogram(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetHistogram(n, bl, n2, n3, dArray);
        this.println("");
    }

    public void glGetHistogram(int n, boolean bl, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetHistogram(" + n + "," + bl + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetHistogram(n, bl, n2, n3, buffer);
        this.println("");
    }

    public void glGetHistogramEXT(int n, boolean bl, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetHistogramEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetHistogramEXT(n, bl, n2, n3, blArray);
        this.println("");
    }

    public void glGetHistogramEXT(int n, boolean bl, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetHistogramEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetHistogramEXT(n, bl, n2, n3, cArray);
        this.println("");
    }

    public void glGetHistogramEXT(int n, boolean bl, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetHistogramEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetHistogramEXT(n, bl, n2, n3, byArray);
        this.println("");
    }

    public void glGetHistogramEXT(int n, boolean bl, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetHistogramEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetHistogramEXT(n, bl, n2, n3, sArray);
        this.println("");
    }

    public void glGetHistogramEXT(int n, boolean bl, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetHistogramEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetHistogramEXT(n, bl, n2, n3, nArray);
        this.println("");
    }

    public void glGetHistogramEXT(int n, boolean bl, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetHistogramEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetHistogramEXT(n, bl, n2, n3, lArray);
        this.println("");
    }

    public void glGetHistogramEXT(int n, boolean bl, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetHistogramEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetHistogramEXT(n, bl, n2, n3, fArray);
        this.println("");
    }

    public void glGetHistogramEXT(int n, boolean bl, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetHistogramEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetHistogramEXT(n, bl, n2, n3, dArray);
        this.println("");
    }

    public void glGetHistogramEXT(int n, boolean bl, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetHistogramEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetHistogramEXT(n, bl, n2, n3, buffer);
        this.println("");
    }

    public void glGetHistogramParameterfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetHistogramParameterfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetHistogramParameterfv(n, n2, fArray);
        this.println("");
    }

    public void glGetHistogramParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetHistogramParameterfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetHistogramParameterfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetHistogramParameterfvEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetHistogramParameterfvEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetHistogramParameterfvEXT(n, n2, fArray);
        this.println("");
    }

    public void glGetHistogramParameterfvEXT(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetHistogramParameterfvEXT(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetHistogramParameterfvEXT(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetHistogramParameteriv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetHistogramParameteriv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetHistogramParameteriv(n, n2, nArray);
        this.println("");
    }

    public void glGetHistogramParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetHistogramParameteriv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetHistogramParameteriv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetHistogramParameterivEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetHistogramParameterivEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetHistogramParameterivEXT(n, n2, nArray);
        this.println("");
    }

    public void glGetHistogramParameterivEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetHistogramParameterivEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetHistogramParameterivEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glGetImageTransformParameterfvHP(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetImageTransformParameterfvHP(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetImageTransformParameterfvHP(n, n2, fArray);
        this.println("");
    }

    public void glGetImageTransformParameterfvHP(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetImageTransformParameterfvHP(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetImageTransformParameterfvHP(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetImageTransformParameterivHP(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetImageTransformParameterivHP(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetImageTransformParameterivHP(n, n2, nArray);
        this.println("");
    }

    public void glGetImageTransformParameterivHP(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetImageTransformParameterivHP(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetImageTransformParameterivHP(n, n2, intBuffer);
        this.println("");
    }

    public void glGetInfoLogARB(int n, int n2, int[] nArray, byte[] byArray) {
        this.printIndent();
        this.print("glGetInfoLogARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetInfoLogARB(n, n2, nArray, byArray);
        this.println("");
    }

    public void glGetInfoLogARB(int n, int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetInfoLogARB(" + n + "," + n2 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetInfoLogARB(n, n2, intBuffer, byteBuffer);
        this.println("");
    }

    public int glGetInstrumentsSGIX() {
        this.printIndent();
        this.print("glGetInstrumentsSGIX()");
        int n = this.downstreamGL.glGetInstrumentsSGIX();
        this.println(" = " + n);
        return n;
    }

    public void glGetIntegerv(int n, int[] nArray) {
        this.printIndent();
        this.print("glGetIntegerv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetIntegerv(n, nArray);
        this.println("");
    }

    public void glGetIntegerv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetIntegerv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGetIntegerv(n, intBuffer);
        this.println("");
    }

    public void glGetInvariantBooleanvEXT(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glGetInvariantBooleanvEXT(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetInvariantBooleanvEXT(n, n2, byArray);
        this.println("");
    }

    public void glGetInvariantBooleanvEXT(int n, int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetInvariantBooleanvEXT(" + n + "," + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glGetInvariantBooleanvEXT(n, n2, byteBuffer);
        this.println("");
    }

    public void glGetInvariantFloatvEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetInvariantFloatvEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetInvariantFloatvEXT(n, n2, fArray);
        this.println("");
    }

    public void glGetInvariantFloatvEXT(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetInvariantFloatvEXT(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetInvariantFloatvEXT(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetInvariantIntegervEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetInvariantIntegervEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetInvariantIntegervEXT(n, n2, nArray);
        this.println("");
    }

    public void glGetInvariantIntegervEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetInvariantIntegervEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetInvariantIntegervEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glGetLightfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetLightfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetLightfv(n, n2, fArray);
        this.println("");
    }

    public void glGetLightfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetLightfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetLightfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetLightiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetLightiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetLightiv(n, n2, nArray);
        this.println("");
    }

    public void glGetLightiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetLightiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetLightiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetListParameterfvSGIX(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetListParameterfvSGIX(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetListParameterfvSGIX(n, n2, fArray);
        this.println("");
    }

    public void glGetListParameterfvSGIX(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetListParameterfvSGIX(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetListParameterfvSGIX(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetListParameterivSGIX(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetListParameterivSGIX(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetListParameterivSGIX(n, n2, nArray);
        this.println("");
    }

    public void glGetListParameterivSGIX(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetListParameterivSGIX(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetListParameterivSGIX(n, n2, intBuffer);
        this.println("");
    }

    public void glGetLocalConstantBooleanvEXT(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glGetLocalConstantBooleanvEXT(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetLocalConstantBooleanvEXT(n, n2, byArray);
        this.println("");
    }

    public void glGetLocalConstantBooleanvEXT(int n, int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetLocalConstantBooleanvEXT(" + n + "," + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glGetLocalConstantBooleanvEXT(n, n2, byteBuffer);
        this.println("");
    }

    public void glGetLocalConstantFloatvEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetLocalConstantFloatvEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetLocalConstantFloatvEXT(n, n2, fArray);
        this.println("");
    }

    public void glGetLocalConstantFloatvEXT(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetLocalConstantFloatvEXT(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetLocalConstantFloatvEXT(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetLocalConstantIntegervEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetLocalConstantIntegervEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetLocalConstantIntegervEXT(n, n2, nArray);
        this.println("");
    }

    public void glGetLocalConstantIntegervEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetLocalConstantIntegervEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetLocalConstantIntegervEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glGetMapAttribParameterfvNV(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetMapAttribParameterfvNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetMapAttribParameterfvNV(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetMapAttribParameterfvNV(int n, int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMapAttribParameterfvNV(" + n + "," + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMapAttribParameterfvNV(n, n2, n3, floatBuffer);
        this.println("");
    }

    public void glGetMapAttribParameterivNV(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetMapAttribParameterivNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetMapAttribParameterivNV(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetMapAttribParameterivNV(int n, int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMapAttribParameterivNV(" + n + "," + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetMapAttribParameterivNV(n, n2, n3, intBuffer);
        this.println("");
    }

    public void glGetMapControlPointsNV(int n, int n2, int n3, int n4, int n5, boolean bl, boolean[] blArray) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + bl + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetMapControlPointsNV(n, n2, n3, n4, n5, bl, blArray);
        this.println("");
    }

    public void glGetMapControlPointsNV(int n, int n2, int n3, int n4, int n5, boolean bl, char[] cArray) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + bl + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetMapControlPointsNV(n, n2, n3, n4, n5, bl, cArray);
        this.println("");
    }

    public void glGetMapControlPointsNV(int n, int n2, int n3, int n4, int n5, boolean bl, byte[] byArray) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + bl + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetMapControlPointsNV(n, n2, n3, n4, n5, bl, byArray);
        this.println("");
    }

    public void glGetMapControlPointsNV(int n, int n2, int n3, int n4, int n5, boolean bl, short[] sArray) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + bl + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetMapControlPointsNV(n, n2, n3, n4, n5, bl, sArray);
        this.println("");
    }

    public void glGetMapControlPointsNV(int n, int n2, int n3, int n4, int n5, boolean bl, int[] nArray) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + bl + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetMapControlPointsNV(n, n2, n3, n4, n5, bl, nArray);
        this.println("");
    }

    public void glGetMapControlPointsNV(int n, int n2, int n3, int n4, int n5, boolean bl, long[] lArray) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + bl + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetMapControlPointsNV(n, n2, n3, n4, n5, bl, lArray);
        this.println("");
    }

    public void glGetMapControlPointsNV(int n, int n2, int n3, int n4, int n5, boolean bl, float[] fArray) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + bl + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetMapControlPointsNV(n, n2, n3, n4, n5, bl, fArray);
        this.println("");
    }

    public void glGetMapControlPointsNV(int n, int n2, int n3, int n4, int n5, boolean bl, double[] dArray) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + bl + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetMapControlPointsNV(n, n2, n3, n4, n5, bl, dArray);
        this.println("");
    }

    public void glGetMapControlPointsNV(int n, int n2, int n3, int n4, int n5, boolean bl, Buffer buffer) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + bl + "," + buffer + ")");
        this.downstreamGL.glGetMapControlPointsNV(n, n2, n3, n4, n5, bl, buffer);
        this.println("");
    }

    public void glGetMapParameterfvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetMapParameterfvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetMapParameterfvNV(n, n2, fArray);
        this.println("");
    }

    public void glGetMapParameterfvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMapParameterfvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMapParameterfvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetMapParameterivNV(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetMapParameterivNV(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetMapParameterivNV(n, n2, nArray);
        this.println("");
    }

    public void glGetMapParameterivNV(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMapParameterivNV(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetMapParameterivNV(n, n2, intBuffer);
        this.println("");
    }

    public void glGetMapdv(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glGetMapdv(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetMapdv(n, n2, dArray);
        this.println("");
    }

    public void glGetMapdv(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetMapdv(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetMapdv(n, n2, doubleBuffer);
        this.println("");
    }

    public void glGetMapfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetMapfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetMapfv(n, n2, fArray);
        this.println("");
    }

    public void glGetMapfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMapfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMapfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetMapiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetMapiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetMapiv(n, n2, nArray);
        this.println("");
    }

    public void glGetMapiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMapiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetMapiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetMaterialfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetMaterialfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetMaterialfv(n, n2, fArray);
        this.println("");
    }

    public void glGetMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMaterialfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMaterialfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetMaterialiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetMaterialiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetMaterialiv(n, n2, nArray);
        this.println("");
    }

    public void glGetMaterialiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMaterialiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetMaterialiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetMinmax(int n, boolean bl, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetMinmax(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetMinmax(n, bl, n2, n3, blArray);
        this.println("");
    }

    public void glGetMinmax(int n, boolean bl, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetMinmax(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetMinmax(n, bl, n2, n3, cArray);
        this.println("");
    }

    public void glGetMinmax(int n, boolean bl, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetMinmax(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetMinmax(n, bl, n2, n3, byArray);
        this.println("");
    }

    public void glGetMinmax(int n, boolean bl, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetMinmax(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetMinmax(n, bl, n2, n3, sArray);
        this.println("");
    }

    public void glGetMinmax(int n, boolean bl, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetMinmax(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetMinmax(n, bl, n2, n3, nArray);
        this.println("");
    }

    public void glGetMinmax(int n, boolean bl, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetMinmax(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetMinmax(n, bl, n2, n3, lArray);
        this.println("");
    }

    public void glGetMinmax(int n, boolean bl, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetMinmax(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetMinmax(n, bl, n2, n3, fArray);
        this.println("");
    }

    public void glGetMinmax(int n, boolean bl, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetMinmax(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetMinmax(n, bl, n2, n3, dArray);
        this.println("");
    }

    public void glGetMinmax(int n, boolean bl, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetMinmax(" + n + "," + bl + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetMinmax(n, bl, n2, n3, buffer);
        this.println("");
    }

    public void glGetMinmaxEXT(int n, boolean bl, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glGetMinmaxEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetMinmaxEXT(n, bl, n2, n3, blArray);
        this.println("");
    }

    public void glGetMinmaxEXT(int n, boolean bl, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glGetMinmaxEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetMinmaxEXT(n, bl, n2, n3, cArray);
        this.println("");
    }

    public void glGetMinmaxEXT(int n, boolean bl, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glGetMinmaxEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetMinmaxEXT(n, bl, n2, n3, byArray);
        this.println("");
    }

    public void glGetMinmaxEXT(int n, boolean bl, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glGetMinmaxEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetMinmaxEXT(n, bl, n2, n3, sArray);
        this.println("");
    }

    public void glGetMinmaxEXT(int n, boolean bl, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetMinmaxEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetMinmaxEXT(n, bl, n2, n3, nArray);
        this.println("");
    }

    public void glGetMinmaxEXT(int n, boolean bl, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glGetMinmaxEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetMinmaxEXT(n, bl, n2, n3, lArray);
        this.println("");
    }

    public void glGetMinmaxEXT(int n, boolean bl, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetMinmaxEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetMinmaxEXT(n, bl, n2, n3, fArray);
        this.println("");
    }

    public void glGetMinmaxEXT(int n, boolean bl, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetMinmaxEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetMinmaxEXT(n, bl, n2, n3, dArray);
        this.println("");
    }

    public void glGetMinmaxEXT(int n, boolean bl, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetMinmaxEXT(" + n + "," + bl + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetMinmaxEXT(n, bl, n2, n3, buffer);
        this.println("");
    }

    public void glGetMinmaxParameterfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetMinmaxParameterfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetMinmaxParameterfv(n, n2, fArray);
        this.println("");
    }

    public void glGetMinmaxParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMinmaxParameterfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMinmaxParameterfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetMinmaxParameterfvEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetMinmaxParameterfvEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetMinmaxParameterfvEXT(n, n2, fArray);
        this.println("");
    }

    public void glGetMinmaxParameterfvEXT(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMinmaxParameterfvEXT(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMinmaxParameterfvEXT(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetMinmaxParameteriv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetMinmaxParameteriv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetMinmaxParameteriv(n, n2, nArray);
        this.println("");
    }

    public void glGetMinmaxParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMinmaxParameteriv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetMinmaxParameteriv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetMinmaxParameterivEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetMinmaxParameterivEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetMinmaxParameterivEXT(n, n2, nArray);
        this.println("");
    }

    public void glGetMinmaxParameterivEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMinmaxParameterivEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetMinmaxParameterivEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glGetObjectBufferfvATI(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetObjectBufferfvATI(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetObjectBufferfvATI(n, n2, fArray);
        this.println("");
    }

    public void glGetObjectBufferfvATI(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetObjectBufferfvATI(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetObjectBufferfvATI(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetObjectBufferivATI(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetObjectBufferivATI(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetObjectBufferivATI(n, n2, nArray);
        this.println("");
    }

    public void glGetObjectBufferivATI(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetObjectBufferivATI(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetObjectBufferivATI(n, n2, intBuffer);
        this.println("");
    }

    public void glGetObjectParameterfvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetObjectParameterfvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetObjectParameterfvARB(n, n2, fArray);
        this.println("");
    }

    public void glGetObjectParameterfvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetObjectParameterfvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetObjectParameterfvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetObjectParameterivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetObjectParameterivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetObjectParameterivARB(n, n2, nArray);
        this.println("");
    }

    public void glGetObjectParameterivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetObjectParameterivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetObjectParameterivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glGetOcclusionQueryivNV(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetOcclusionQueryivNV(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetOcclusionQueryivNV(n, n2, nArray);
        this.println("");
    }

    public void glGetOcclusionQueryivNV(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetOcclusionQueryivNV(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetOcclusionQueryivNV(n, n2, intBuffer);
        this.println("");
    }

    public void glGetOcclusionQueryuivNV(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetOcclusionQueryuivNV(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetOcclusionQueryuivNV(n, n2, nArray);
        this.println("");
    }

    public void glGetOcclusionQueryuivNV(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetOcclusionQueryuivNV(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetOcclusionQueryuivNV(n, n2, intBuffer);
        this.println("");
    }

    public void glGetPixelMapfv(int n, float[] fArray) {
        this.printIndent();
        this.print("glGetPixelMapfv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetPixelMapfv(n, fArray);
        this.println("");
    }

    public void glGetPixelMapfv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetPixelMapfv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glGetPixelMapfv(n, floatBuffer);
        this.println("");
    }

    public void glGetPixelMapuiv(int n, int[] nArray) {
        this.printIndent();
        this.print("glGetPixelMapuiv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetPixelMapuiv(n, nArray);
        this.println("");
    }

    public void glGetPixelMapuiv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetPixelMapuiv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGetPixelMapuiv(n, intBuffer);
        this.println("");
    }

    public void glGetPixelMapusv(int n, short[] sArray) {
        this.printIndent();
        this.print("glGetPixelMapusv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetPixelMapusv(n, sArray);
        this.println("");
    }

    public void glGetPixelMapusv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glGetPixelMapusv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glGetPixelMapusv(n, shortBuffer);
        this.println("");
    }

    public void glGetPixelTexGenParameterfvSGIS(int n, float[] fArray) {
        this.printIndent();
        this.print("glGetPixelTexGenParameterfvSGIS(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetPixelTexGenParameterfvSGIS(n, fArray);
        this.println("");
    }

    public void glGetPixelTexGenParameterfvSGIS(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetPixelTexGenParameterfvSGIS(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glGetPixelTexGenParameterfvSGIS(n, floatBuffer);
        this.println("");
    }

    public void glGetPixelTexGenParameterivSGIS(int n, int[] nArray) {
        this.printIndent();
        this.print("glGetPixelTexGenParameterivSGIS(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetPixelTexGenParameterivSGIS(n, nArray);
        this.println("");
    }

    public void glGetPixelTexGenParameterivSGIS(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetPixelTexGenParameterivSGIS(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGetPixelTexGenParameterivSGIS(n, intBuffer);
        this.println("");
    }

    public void glGetPolygonStipple(byte[] byArray) {
        this.printIndent();
        this.print("glGetPolygonStipple(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetPolygonStipple(byArray);
        this.println("");
    }

    public void glGetPolygonStipple(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetPolygonStipple(" + byteBuffer + ")");
        this.downstreamGL.glGetPolygonStipple(byteBuffer);
        this.println("");
    }

    public void glGetProgramEnvParameterdvARB(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glGetProgramEnvParameterdvARB(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetProgramEnvParameterdvARB(n, n2, dArray);
        this.println("");
    }

    public void glGetProgramEnvParameterdvARB(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetProgramEnvParameterdvARB(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetProgramEnvParameterdvARB(n, n2, doubleBuffer);
        this.println("");
    }

    public void glGetProgramEnvParameterfvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetProgramEnvParameterfvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetProgramEnvParameterfvARB(n, n2, fArray);
        this.println("");
    }

    public void glGetProgramEnvParameterfvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetProgramEnvParameterfvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetProgramEnvParameterfvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetProgramInfoLog(int n, int n2, int[] nArray, byte[] byArray) {
        this.printIndent();
        this.print("glGetProgramInfoLog(" + n + "," + n2 + "," + this.dumpArray(nArray) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetProgramInfoLog(n, n2, nArray, byArray);
        this.println("");
    }

    public void glGetProgramInfoLog(int n, int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetProgramInfoLog(" + n + "," + n2 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetProgramInfoLog(n, n2, intBuffer, byteBuffer);
        this.println("");
    }

    public void glGetProgramLocalParameterdvARB(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glGetProgramLocalParameterdvARB(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetProgramLocalParameterdvARB(n, n2, dArray);
        this.println("");
    }

    public void glGetProgramLocalParameterdvARB(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetProgramLocalParameterdvARB(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetProgramLocalParameterdvARB(n, n2, doubleBuffer);
        this.println("");
    }

    public void glGetProgramLocalParameterfvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetProgramLocalParameterfvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetProgramLocalParameterfvARB(n, n2, fArray);
        this.println("");
    }

    public void glGetProgramLocalParameterfvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetProgramLocalParameterfvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetProgramLocalParameterfvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetProgramNamedParameterdvNV(int n, int n2, String string, double[] dArray) {
        this.printIndent();
        this.print("glGetProgramNamedParameterdvNV(" + n + "," + n2 + "," + string + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetProgramNamedParameterdvNV(n, n2, string, dArray);
        this.println("");
    }

    public void glGetProgramNamedParameterdvNV(int n, int n2, String string, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetProgramNamedParameterdvNV(" + n + "," + n2 + "," + string + "," + doubleBuffer + ")");
        this.downstreamGL.glGetProgramNamedParameterdvNV(n, n2, string, doubleBuffer);
        this.println("");
    }

    public void glGetProgramNamedParameterfvNV(int n, int n2, String string, float[] fArray) {
        this.printIndent();
        this.print("glGetProgramNamedParameterfvNV(" + n + "," + n2 + "," + string + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetProgramNamedParameterfvNV(n, n2, string, fArray);
        this.println("");
    }

    public void glGetProgramNamedParameterfvNV(int n, int n2, String string, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetProgramNamedParameterfvNV(" + n + "," + n2 + "," + string + "," + floatBuffer + ")");
        this.downstreamGL.glGetProgramNamedParameterfvNV(n, n2, string, floatBuffer);
        this.println("");
    }

    public void glGetProgramParameterdvNV(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glGetProgramParameterdvNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetProgramParameterdvNV(n, n2, n3, dArray);
        this.println("");
    }

    public void glGetProgramParameterdvNV(int n, int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetProgramParameterdvNV(" + n + "," + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetProgramParameterdvNV(n, n2, n3, doubleBuffer);
        this.println("");
    }

    public void glGetProgramParameterfvNV(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetProgramParameterfvNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetProgramParameterfvNV(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetProgramParameterfvNV(int n, int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetProgramParameterfvNV(" + n + "," + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetProgramParameterfvNV(n, n2, n3, floatBuffer);
        this.println("");
    }

    public void glGetProgramStringARB(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glGetProgramStringARB(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glGetProgramStringARB(n, n2, buffer);
        this.println("");
    }

    public void glGetProgramStringNV(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glGetProgramStringNV(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetProgramStringNV(n, n2, byArray);
        this.println("");
    }

    public void glGetProgramStringNV(int n, int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetProgramStringNV(" + n + "," + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glGetProgramStringNV(n, n2, byteBuffer);
        this.println("");
    }

    public void glGetProgramiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetProgramiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetProgramiv(n, n2, nArray);
        this.println("");
    }

    public void glGetProgramiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetProgramivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetProgramivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetProgramivARB(n, n2, nArray);
        this.println("");
    }

    public void glGetProgramivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glGetProgramivNV(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetProgramivNV(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetProgramivNV(n, n2, nArray);
        this.println("");
    }

    public void glGetProgramivNV(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramivNV(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramivNV(n, n2, intBuffer);
        this.println("");
    }

    public void glGetQueryObjectiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetQueryObjectiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetQueryObjectiv(n, n2, nArray);
        this.println("");
    }

    public void glGetQueryObjectiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryObjectiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryObjectiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetQueryObjectivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetQueryObjectivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetQueryObjectivARB(n, n2, nArray);
        this.println("");
    }

    public void glGetQueryObjectivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryObjectivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryObjectivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glGetQueryObjectuiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetQueryObjectuiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetQueryObjectuiv(n, n2, nArray);
        this.println("");
    }

    public void glGetQueryObjectuiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryObjectuiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryObjectuiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetQueryObjectuivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetQueryObjectuivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetQueryObjectuivARB(n, n2, nArray);
        this.println("");
    }

    public void glGetQueryObjectuivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryObjectuivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryObjectuivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glGetQueryiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetQueryiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetQueryiv(n, n2, nArray);
        this.println("");
    }

    public void glGetQueryiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetQueryivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetQueryivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetQueryivARB(n, n2, nArray);
        this.println("");
    }

    public void glGetQueryivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glGetRenderbufferParameterivEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetRenderbufferParameterivEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetRenderbufferParameterivEXT(n, n2, nArray);
        this.println("");
    }

    public void glGetRenderbufferParameterivEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetRenderbufferParameterivEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetRenderbufferParameterivEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, boolean[] blArray3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(blArray3) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, blArray, blArray2, blArray3);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, blArray, blArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, blArray, blArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, blArray, blArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, blArray, blArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, blArray, blArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, blArray, blArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, blArray, blArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, blArray, blArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, char[] cArray, char[] cArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, cArray, cArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, char[] cArray, char[] cArray2, char[] cArray3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(cArray3) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, cArray, cArray2, cArray3);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, char[] cArray, char[] cArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, cArray, cArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, char[] cArray, char[] cArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, cArray, cArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, char[] cArray, char[] cArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, cArray, cArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, char[] cArray, char[] cArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, cArray, cArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, char[] cArray, char[] cArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, cArray, cArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, char[] cArray, char[] cArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, cArray, cArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, char[] cArray, char[] cArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, cArray, cArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, byte[] byArray, byte[] byArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, byArray, byArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, byte[] byArray, byte[] byArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, byArray, byArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(byArray3) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, byArray, byArray2, byArray3);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, byte[] byArray, byte[] byArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, byArray, byArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, byte[] byArray, byte[] byArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, byArray, byArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, byte[] byArray, byte[] byArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, byArray, byArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, byte[] byArray, byte[] byArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, byArray, byArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, byte[] byArray, byte[] byArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, byArray, byArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, byte[] byArray, byte[] byArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, byArray, byArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, short[] sArray, short[] sArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, sArray, sArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, short[] sArray, short[] sArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, sArray, sArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, short[] sArray, short[] sArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, sArray, sArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, short[] sArray, short[] sArray2, short[] sArray3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(sArray3) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, sArray, sArray2, sArray3);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, short[] sArray, short[] sArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, sArray, sArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, short[] sArray, short[] sArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, sArray, sArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, short[] sArray, short[] sArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, sArray, sArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, short[] sArray, short[] sArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, sArray, sArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, short[] sArray, short[] sArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, sArray, sArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, int[] nArray, int[] nArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, nArray, nArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, int[] nArray, int[] nArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, nArray, nArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, int[] nArray, int[] nArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, nArray, nArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, int[] nArray, int[] nArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, nArray, nArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, nArray, nArray2, nArray3);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, int[] nArray, int[] nArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, nArray, nArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, int[] nArray, int[] nArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, nArray, nArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, int[] nArray, int[] nArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, nArray, nArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, int[] nArray, int[] nArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, nArray, nArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, long[] lArray, long[] lArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, lArray, lArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, long[] lArray, long[] lArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, lArray, lArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, long[] lArray, long[] lArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, lArray, lArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, long[] lArray, long[] lArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, lArray, lArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, long[] lArray, long[] lArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, lArray, lArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, long[] lArray, long[] lArray2, long[] lArray3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(lArray3) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, lArray, lArray2, lArray3);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, long[] lArray, long[] lArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, lArray, lArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, long[] lArray, long[] lArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, lArray, lArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, long[] lArray, long[] lArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, lArray, lArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, float[] fArray, float[] fArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, fArray, fArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, float[] fArray, float[] fArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, fArray, fArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, float[] fArray, float[] fArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, fArray, fArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, float[] fArray, float[] fArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, fArray, fArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, float[] fArray, float[] fArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, fArray, fArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, float[] fArray, float[] fArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, fArray, fArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, float[] fArray, float[] fArray2, float[] fArray3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, fArray, fArray2, fArray3);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, float[] fArray, float[] fArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, fArray, fArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, float[] fArray, float[] fArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, fArray, fArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, double[] dArray, double[] dArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, dArray, dArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, double[] dArray, double[] dArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, dArray, dArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, double[] dArray, double[] dArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, dArray, dArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, double[] dArray, double[] dArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, dArray, dArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, double[] dArray, double[] dArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, dArray, dArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, double[] dArray, double[] dArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, dArray, dArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, double[] dArray, double[] dArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, dArray, dArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(dArray3) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, dArray, dArray2, dArray3);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, double[] dArray, double[] dArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, dArray, dArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, Buffer buffer, Buffer buffer2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, buffer, buffer2, blArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, Buffer buffer, Buffer buffer2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, buffer, buffer2, cArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, Buffer buffer, Buffer buffer2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, buffer, buffer2, byArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, Buffer buffer, Buffer buffer2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, buffer, buffer2, sArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, Buffer buffer, Buffer buffer2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, buffer, buffer2, nArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, Buffer buffer, Buffer buffer2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, buffer, buffer2, lArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, Buffer buffer, Buffer buffer2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, buffer, buffer2, fArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, Buffer buffer, Buffer buffer2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, buffer, buffer2, dArray);
        this.println("");
    }

    public void glGetSeparableFilter(int n, int n2, int n3, Buffer buffer, Buffer buffer2, Buffer buffer3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + buffer3 + ")");
        this.downstreamGL.glGetSeparableFilter(n, n2, n3, buffer, buffer2, buffer3);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, boolean[] blArray3) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(blArray3) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, blArray, blArray2, blArray3);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, blArray, blArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, blArray, blArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, blArray, blArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, blArray, blArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, blArray, blArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, blArray, blArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, blArray, blArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, blArray, blArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, char[] cArray, char[] cArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, cArray, cArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, char[] cArray, char[] cArray2, char[] cArray3) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(cArray3) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, cArray, cArray2, cArray3);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, char[] cArray, char[] cArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, cArray, cArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, char[] cArray, char[] cArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, cArray, cArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, char[] cArray, char[] cArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, cArray, cArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, char[] cArray, char[] cArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, cArray, cArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, char[] cArray, char[] cArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, cArray, cArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, char[] cArray, char[] cArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, cArray, cArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, char[] cArray, char[] cArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, cArray, cArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, byte[] byArray, byte[] byArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, byArray, byArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, byte[] byArray, byte[] byArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, byArray, byArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(byArray3) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, byArray, byArray2, byArray3);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, byte[] byArray, byte[] byArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, byArray, byArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, byte[] byArray, byte[] byArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, byArray, byArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, byte[] byArray, byte[] byArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, byArray, byArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, byte[] byArray, byte[] byArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, byArray, byArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, byte[] byArray, byte[] byArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, byArray, byArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, byte[] byArray, byte[] byArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, byArray, byArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, short[] sArray, short[] sArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, sArray, sArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, short[] sArray, short[] sArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, sArray, sArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, short[] sArray, short[] sArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, sArray, sArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, short[] sArray, short[] sArray2, short[] sArray3) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(sArray3) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, sArray, sArray2, sArray3);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, short[] sArray, short[] sArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, sArray, sArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, short[] sArray, short[] sArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, sArray, sArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, short[] sArray, short[] sArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, sArray, sArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, short[] sArray, short[] sArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, sArray, sArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, short[] sArray, short[] sArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, sArray, sArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, int[] nArray, int[] nArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, nArray, nArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, int[] nArray, int[] nArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, nArray, nArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, int[] nArray, int[] nArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, nArray, nArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, int[] nArray, int[] nArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, nArray, nArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, nArray, nArray2, nArray3);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, int[] nArray, int[] nArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, nArray, nArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, int[] nArray, int[] nArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, nArray, nArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, int[] nArray, int[] nArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, nArray, nArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, int[] nArray, int[] nArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, nArray, nArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, long[] lArray, long[] lArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, lArray, lArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, long[] lArray, long[] lArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, lArray, lArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, long[] lArray, long[] lArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, lArray, lArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, long[] lArray, long[] lArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, lArray, lArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, long[] lArray, long[] lArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, lArray, lArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, long[] lArray, long[] lArray2, long[] lArray3) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(lArray3) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, lArray, lArray2, lArray3);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, long[] lArray, long[] lArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, lArray, lArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, long[] lArray, long[] lArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, lArray, lArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, long[] lArray, long[] lArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, lArray, lArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, float[] fArray, float[] fArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, fArray, fArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, float[] fArray, float[] fArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, fArray, fArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, float[] fArray, float[] fArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, fArray, fArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, float[] fArray, float[] fArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, fArray, fArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, float[] fArray, float[] fArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, fArray, fArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, float[] fArray, float[] fArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, fArray, fArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, float[] fArray, float[] fArray2, float[] fArray3) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, fArray, fArray2, fArray3);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, float[] fArray, float[] fArray2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, fArray, fArray2, dArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, float[] fArray, float[] fArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, fArray, fArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, double[] dArray, double[] dArray2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, dArray, dArray2, blArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, double[] dArray, double[] dArray2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, dArray, dArray2, cArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, double[] dArray, double[] dArray2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, dArray, dArray2, byArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, double[] dArray, double[] dArray2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, dArray, dArray2, sArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, double[] dArray, double[] dArray2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, dArray, dArray2, nArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, double[] dArray, double[] dArray2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, dArray, dArray2, lArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, double[] dArray, double[] dArray2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, dArray, dArray2, fArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + this.dumpArray(dArray3) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, dArray, dArray2, dArray3);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, double[] dArray, double[] dArray2, Buffer buffer) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + "," + buffer + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, dArray, dArray2, buffer);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, Buffer buffer, Buffer buffer2, boolean[] blArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, buffer, buffer2, blArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, Buffer buffer, Buffer buffer2, char[] cArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, buffer, buffer2, cArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, Buffer buffer, Buffer buffer2, byte[] byArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, buffer, buffer2, byArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, Buffer buffer, Buffer buffer2, short[] sArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, buffer, buffer2, sArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, Buffer buffer, Buffer buffer2, int[] nArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, buffer, buffer2, nArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, Buffer buffer, Buffer buffer2, long[] lArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, buffer, buffer2, lArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, Buffer buffer, Buffer buffer2, float[] fArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, buffer, buffer2, fArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, Buffer buffer, Buffer buffer2, double[] dArray) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, buffer, buffer2, dArray);
        this.println("");
    }

    public void glGetSeparableFilterEXT(int n, int n2, int n3, Buffer buffer, Buffer buffer2, Buffer buffer3) {
        this.printIndent();
        this.print("glGetSeparableFilterEXT(" + n + "," + n2 + "," + n3 + "," + buffer + "," + buffer2 + "," + buffer3 + ")");
        this.downstreamGL.glGetSeparableFilterEXT(n, n2, n3, buffer, buffer2, buffer3);
        this.println("");
    }

    public void glGetShaderInfoLog(int n, int n2, int[] nArray, byte[] byArray) {
        this.printIndent();
        this.print("glGetShaderInfoLog(" + n + "," + n2 + "," + this.dumpArray(nArray) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetShaderInfoLog(n, n2, nArray, byArray);
        this.println("");
    }

    public void glGetShaderInfoLog(int n, int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetShaderInfoLog(" + n + "," + n2 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetShaderInfoLog(n, n2, intBuffer, byteBuffer);
        this.println("");
    }

    public void glGetShaderSource(int n, int n2, int[] nArray, byte[] byArray) {
        this.printIndent();
        this.print("glGetShaderSource(" + n + "," + n2 + "," + this.dumpArray(nArray) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetShaderSource(n, n2, nArray, byArray);
        this.println("");
    }

    public void glGetShaderSource(int n, int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetShaderSource(" + n + "," + n2 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetShaderSource(n, n2, intBuffer, byteBuffer);
        this.println("");
    }

    public void glGetShaderSourceARB(int n, int n2, int[] nArray, byte[] byArray) {
        this.printIndent();
        this.print("glGetShaderSourceARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetShaderSourceARB(n, n2, nArray, byArray);
        this.println("");
    }

    public void glGetShaderSourceARB(int n, int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetShaderSourceARB(" + n + "," + n2 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetShaderSourceARB(n, n2, intBuffer, byteBuffer);
        this.println("");
    }

    public void glGetShaderiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetShaderiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetShaderiv(n, n2, nArray);
        this.println("");
    }

    public void glGetShaderiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetShaderiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetShaderiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetSharpenTexFuncSGIS(int n, float[] fArray) {
        this.printIndent();
        this.print("glGetSharpenTexFuncSGIS(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetSharpenTexFuncSGIS(n, fArray);
        this.println("");
    }

    public void glGetSharpenTexFuncSGIS(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetSharpenTexFuncSGIS(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glGetSharpenTexFuncSGIS(n, floatBuffer);
        this.println("");
    }

    public String glGetString(int n) {
        this.printIndent();
        this.print("glGetString(" + n + ")");
        String string = this.downstreamGL.glGetString(n);
        this.println(" = " + string);
        return string;
    }

    public void glGetTexBumpParameterfvATI(int n, float[] fArray) {
        this.printIndent();
        this.print("glGetTexBumpParameterfvATI(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetTexBumpParameterfvATI(n, fArray);
        this.println("");
    }

    public void glGetTexBumpParameterfvATI(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexBumpParameterfvATI(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexBumpParameterfvATI(n, floatBuffer);
        this.println("");
    }

    public void glGetTexBumpParameterivATI(int n, int[] nArray) {
        this.printIndent();
        this.print("glGetTexBumpParameterivATI(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetTexBumpParameterivATI(n, nArray);
        this.println("");
    }

    public void glGetTexBumpParameterivATI(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexBumpParameterivATI(" + n + "," + intBuffer + ")");
        this.downstreamGL.glGetTexBumpParameterivATI(n, intBuffer);
        this.println("");
    }

    public void glGetTexEnvfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetTexEnvfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetTexEnvfv(n, n2, fArray);
        this.println("");
    }

    public void glGetTexEnvfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexEnvfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexEnvfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetTexEnviv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetTexEnviv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetTexEnviv(n, n2, nArray);
        this.println("");
    }

    public void glGetTexEnviv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexEnviv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexEnviv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetTexFilterFuncSGIS(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetTexFilterFuncSGIS(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetTexFilterFuncSGIS(n, n2, fArray);
        this.println("");
    }

    public void glGetTexFilterFuncSGIS(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexFilterFuncSGIS(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexFilterFuncSGIS(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetTexGendv(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glGetTexGendv(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetTexGendv(n, n2, dArray);
        this.println("");
    }

    public void glGetTexGendv(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetTexGendv(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetTexGendv(n, n2, doubleBuffer);
        this.println("");
    }

    public void glGetTexGenfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetTexGenfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetTexGenfv(n, n2, fArray);
        this.println("");
    }

    public void glGetTexGenfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexGenfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexGenfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetTexGeniv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetTexGeniv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetTexGeniv(n, n2, nArray);
        this.println("");
    }

    public void glGetTexGeniv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexGeniv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexGeniv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetTexImage(int n, int n2, int n3, int n4, boolean[] blArray) {
        this.printIndent();
        this.print("glGetTexImage(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glGetTexImage(n, n2, n3, n4, blArray);
        this.println("");
    }

    public void glGetTexImage(int n, int n2, int n3, int n4, char[] cArray) {
        this.printIndent();
        this.print("glGetTexImage(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glGetTexImage(n, n2, n3, n4, cArray);
        this.println("");
    }

    public void glGetTexImage(int n, int n2, int n3, int n4, byte[] byArray) {
        this.printIndent();
        this.print("glGetTexImage(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetTexImage(n, n2, n3, n4, byArray);
        this.println("");
    }

    public void glGetTexImage(int n, int n2, int n3, int n4, short[] sArray) {
        this.printIndent();
        this.print("glGetTexImage(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glGetTexImage(n, n2, n3, n4, sArray);
        this.println("");
    }

    public void glGetTexImage(int n, int n2, int n3, int n4, int[] nArray) {
        this.printIndent();
        this.print("glGetTexImage(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetTexImage(n, n2, n3, n4, nArray);
        this.println("");
    }

    public void glGetTexImage(int n, int n2, int n3, int n4, long[] lArray) {
        this.printIndent();
        this.print("glGetTexImage(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glGetTexImage(n, n2, n3, n4, lArray);
        this.println("");
    }

    public void glGetTexImage(int n, int n2, int n3, int n4, float[] fArray) {
        this.printIndent();
        this.print("glGetTexImage(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetTexImage(n, n2, n3, n4, fArray);
        this.println("");
    }

    public void glGetTexImage(int n, int n2, int n3, int n4, double[] dArray) {
        this.printIndent();
        this.print("glGetTexImage(" + n + "," + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetTexImage(n, n2, n3, n4, dArray);
        this.println("");
    }

    public void glGetTexImage(int n, int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glGetTexImage(" + n + "," + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glGetTexImage(n, n2, n3, n4, buffer);
        this.println("");
    }

    public void glGetTexLevelParameterfv(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glGetTexLevelParameterfv(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetTexLevelParameterfv(n, n2, n3, fArray);
        this.println("");
    }

    public void glGetTexLevelParameterfv(int n, int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexLevelParameterfv(" + n + "," + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexLevelParameterfv(n, n2, n3, floatBuffer);
        this.println("");
    }

    public void glGetTexLevelParameteriv(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetTexLevelParameteriv(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetTexLevelParameteriv(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetTexLevelParameteriv(int n, int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexLevelParameteriv(" + n + "," + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexLevelParameteriv(n, n2, n3, intBuffer);
        this.println("");
    }

    public void glGetTexParameterfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetTexParameterfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetTexParameterfv(n, n2, fArray);
        this.println("");
    }

    public void glGetTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexParameterfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexParameterfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetTexParameteriv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetTexParameteriv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetTexParameteriv(n, n2, nArray);
        this.println("");
    }

    public void glGetTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexParameteriv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexParameteriv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetTrackMatrixivNV(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glGetTrackMatrixivNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetTrackMatrixivNV(n, n2, n3, nArray);
        this.println("");
    }

    public void glGetTrackMatrixivNV(int n, int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTrackMatrixivNV(" + n + "," + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetTrackMatrixivNV(n, n2, n3, intBuffer);
        this.println("");
    }

    public int glGetUniformLocation(int n, byte[] byArray) {
        this.printIndent();
        this.print("glGetUniformLocation(" + n + "," + this.dumpArray(byArray) + ")");
        int n2 = this.downstreamGL.glGetUniformLocation(n, byArray);
        this.println(" = " + n2);
        return n2;
    }

    public int glGetUniformLocation(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetUniformLocation(" + n + "," + byteBuffer + ")");
        int n2 = this.downstreamGL.glGetUniformLocation(n, byteBuffer);
        this.println(" = " + n2);
        return n2;
    }

    public int glGetUniformLocationARB(int n, String string) {
        this.printIndent();
        this.print("glGetUniformLocationARB(" + n + "," + string + ")");
        int n2 = this.downstreamGL.glGetUniformLocationARB(n, string);
        this.println(" = " + n2);
        return n2;
    }

    public void glGetUniformfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetUniformfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetUniformfv(n, n2, fArray);
        this.println("");
    }

    public void glGetUniformfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetUniformfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetUniformfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetUniformfvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetUniformfvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetUniformfvARB(n, n2, fArray);
        this.println("");
    }

    public void glGetUniformfvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetUniformfvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetUniformfvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetUniformiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetUniformiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetUniformiv(n, n2, nArray);
        this.println("");
    }

    public void glGetUniformiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetUniformiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetUniformiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetUniformivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetUniformivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetUniformivARB(n, n2, nArray);
        this.println("");
    }

    public void glGetUniformivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetUniformivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetUniformivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glGetVariantArrayObjectfvATI(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetVariantArrayObjectfvATI(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetVariantArrayObjectfvATI(n, n2, fArray);
        this.println("");
    }

    public void glGetVariantArrayObjectfvATI(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVariantArrayObjectfvATI(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVariantArrayObjectfvATI(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetVariantArrayObjectivATI(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetVariantArrayObjectivATI(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetVariantArrayObjectivATI(n, n2, nArray);
        this.println("");
    }

    public void glGetVariantArrayObjectivATI(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVariantArrayObjectivATI(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetVariantArrayObjectivATI(n, n2, intBuffer);
        this.println("");
    }

    public void glGetVariantBooleanvEXT(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glGetVariantBooleanvEXT(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glGetVariantBooleanvEXT(n, n2, byArray);
        this.println("");
    }

    public void glGetVariantBooleanvEXT(int n, int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetVariantBooleanvEXT(" + n + "," + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glGetVariantBooleanvEXT(n, n2, byteBuffer);
        this.println("");
    }

    public void glGetVariantFloatvEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetVariantFloatvEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetVariantFloatvEXT(n, n2, fArray);
        this.println("");
    }

    public void glGetVariantFloatvEXT(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVariantFloatvEXT(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVariantFloatvEXT(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetVariantIntegervEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetVariantIntegervEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetVariantIntegervEXT(n, n2, nArray);
        this.println("");
    }

    public void glGetVariantIntegervEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVariantIntegervEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetVariantIntegervEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glGetVertexAttribArrayObjectfvATI(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetVertexAttribArrayObjectfvATI(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetVertexAttribArrayObjectfvATI(n, n2, fArray);
        this.println("");
    }

    public void glGetVertexAttribArrayObjectfvATI(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribArrayObjectfvATI(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVertexAttribArrayObjectfvATI(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetVertexAttribArrayObjectivATI(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetVertexAttribArrayObjectivATI(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetVertexAttribArrayObjectivATI(n, n2, nArray);
        this.println("");
    }

    public void glGetVertexAttribArrayObjectivATI(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribArrayObjectivATI(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribArrayObjectivATI(n, n2, intBuffer);
        this.println("");
    }

    public void glGetVertexAttribdv(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glGetVertexAttribdv(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetVertexAttribdv(n, n2, dArray);
        this.println("");
    }

    public void glGetVertexAttribdv(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribdv(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetVertexAttribdv(n, n2, doubleBuffer);
        this.println("");
    }

    public void glGetVertexAttribdvARB(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glGetVertexAttribdvARB(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetVertexAttribdvARB(n, n2, dArray);
        this.println("");
    }

    public void glGetVertexAttribdvARB(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribdvARB(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetVertexAttribdvARB(n, n2, doubleBuffer);
        this.println("");
    }

    public void glGetVertexAttribdvNV(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glGetVertexAttribdvNV(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glGetVertexAttribdvNV(n, n2, dArray);
        this.println("");
    }

    public void glGetVertexAttribdvNV(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribdvNV(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetVertexAttribdvNV(n, n2, doubleBuffer);
        this.println("");
    }

    public void glGetVertexAttribfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetVertexAttribfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetVertexAttribfv(n, n2, fArray);
        this.println("");
    }

    public void glGetVertexAttribfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVertexAttribfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetVertexAttribfvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetVertexAttribfvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetVertexAttribfvARB(n, n2, fArray);
        this.println("");
    }

    public void glGetVertexAttribfvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribfvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVertexAttribfvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetVertexAttribfvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glGetVertexAttribfvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glGetVertexAttribfvNV(n, n2, fArray);
        this.println("");
    }

    public void glGetVertexAttribfvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribfvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVertexAttribfvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glGetVertexAttribiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetVertexAttribiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetVertexAttribiv(n, n2, nArray);
        this.println("");
    }

    public void glGetVertexAttribiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribiv(n, n2, intBuffer);
        this.println("");
    }

    public void glGetVertexAttribivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetVertexAttribivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetVertexAttribivARB(n, n2, nArray);
        this.println("");
    }

    public void glGetVertexAttribivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glGetVertexAttribivNV(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glGetVertexAttribivNV(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glGetVertexAttribivNV(n, n2, nArray);
        this.println("");
    }

    public void glGetVertexAttribivNV(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribivNV(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribivNV(n, n2, intBuffer);
        this.println("");
    }

    public void glGlobalAlphaFactorbSUN(byte by) {
        this.printIndent();
        this.print("glGlobalAlphaFactorbSUN(" + by + ")");
        this.downstreamGL.glGlobalAlphaFactorbSUN(by);
        this.println("");
    }

    public void glGlobalAlphaFactordSUN(double d) {
        this.printIndent();
        this.print("glGlobalAlphaFactordSUN(" + d + ")");
        this.downstreamGL.glGlobalAlphaFactordSUN(d);
        this.println("");
    }

    public void glGlobalAlphaFactorfSUN(float f) {
        this.printIndent();
        this.print("glGlobalAlphaFactorfSUN(" + f + ")");
        this.downstreamGL.glGlobalAlphaFactorfSUN(f);
        this.println("");
    }

    public void glGlobalAlphaFactoriSUN(int n) {
        this.printIndent();
        this.print("glGlobalAlphaFactoriSUN(" + n + ")");
        this.downstreamGL.glGlobalAlphaFactoriSUN(n);
        this.println("");
    }

    public void glGlobalAlphaFactorsSUN(short s) {
        this.printIndent();
        this.print("glGlobalAlphaFactorsSUN(" + s + ")");
        this.downstreamGL.glGlobalAlphaFactorsSUN(s);
        this.println("");
    }

    public void glGlobalAlphaFactorubSUN(byte by) {
        this.printIndent();
        this.print("glGlobalAlphaFactorubSUN(" + by + ")");
        this.downstreamGL.glGlobalAlphaFactorubSUN(by);
        this.println("");
    }

    public void glGlobalAlphaFactoruiSUN(int n) {
        this.printIndent();
        this.print("glGlobalAlphaFactoruiSUN(" + n + ")");
        this.downstreamGL.glGlobalAlphaFactoruiSUN(n);
        this.println("");
    }

    public void glGlobalAlphaFactorusSUN(short s) {
        this.printIndent();
        this.print("glGlobalAlphaFactorusSUN(" + s + ")");
        this.downstreamGL.glGlobalAlphaFactorusSUN(s);
        this.println("");
    }

    public void glHint(int n, int n2) {
        this.printIndent();
        this.print("glHint(" + n + "," + n2 + ")");
        this.downstreamGL.glHint(n, n2);
        this.println("");
    }

    public void glHintPGI(int n, int n2) {
        this.printIndent();
        this.print("glHintPGI(" + n + "," + n2 + ")");
        this.downstreamGL.glHintPGI(n, n2);
        this.println("");
    }

    public void glHistogram(int n, int n2, int n3, boolean bl) {
        this.printIndent();
        this.print("glHistogram(" + n + "," + n2 + "," + n3 + "," + bl + ")");
        this.downstreamGL.glHistogram(n, n2, n3, bl);
        this.println("");
    }

    public void glHistogramEXT(int n, int n2, int n3, boolean bl) {
        this.printIndent();
        this.print("glHistogramEXT(" + n + "," + n2 + "," + n3 + "," + bl + ")");
        this.downstreamGL.glHistogramEXT(n, n2, n3, bl);
        this.println("");
    }

    public void glIglooInterfaceSGIX(int n, boolean[] blArray) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n, blArray);
        this.println("");
    }

    public void glIglooInterfaceSGIX(int n, char[] cArray) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n, cArray);
        this.println("");
    }

    public void glIglooInterfaceSGIX(int n, byte[] byArray) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n, byArray);
        this.println("");
    }

    public void glIglooInterfaceSGIX(int n, short[] sArray) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n, sArray);
        this.println("");
    }

    public void glIglooInterfaceSGIX(int n, int[] nArray) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n, nArray);
        this.println("");
    }

    public void glIglooInterfaceSGIX(int n, long[] lArray) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n, lArray);
        this.println("");
    }

    public void glIglooInterfaceSGIX(int n, float[] fArray) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n, fArray);
        this.println("");
    }

    public void glIglooInterfaceSGIX(int n, double[] dArray) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n, dArray);
        this.println("");
    }

    public void glIglooInterfaceSGIX(int n, Buffer buffer) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n + "," + buffer + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n, buffer);
        this.println("");
    }

    public void glImageTransformParameterfHP(int n, int n2, float f) {
        this.printIndent();
        this.print("glImageTransformParameterfHP(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glImageTransformParameterfHP(n, n2, f);
        this.println("");
    }

    public void glImageTransformParameterfvHP(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glImageTransformParameterfvHP(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glImageTransformParameterfvHP(n, n2, fArray);
        this.println("");
    }

    public void glImageTransformParameterfvHP(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glImageTransformParameterfvHP(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glImageTransformParameterfvHP(n, n2, floatBuffer);
        this.println("");
    }

    public void glImageTransformParameteriHP(int n, int n2, int n3) {
        this.printIndent();
        this.print("glImageTransformParameteriHP(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glImageTransformParameteriHP(n, n2, n3);
        this.println("");
    }

    public void glImageTransformParameterivHP(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glImageTransformParameterivHP(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glImageTransformParameterivHP(n, n2, nArray);
        this.println("");
    }

    public void glImageTransformParameterivHP(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glImageTransformParameterivHP(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glImageTransformParameterivHP(n, n2, intBuffer);
        this.println("");
    }

    public void glIndexFuncEXT(int n, float f) {
        this.printIndent();
        this.print("glIndexFuncEXT(" + n + "," + f + ")");
        this.downstreamGL.glIndexFuncEXT(n, f);
        this.println("");
    }

    public void glIndexMask(int n) {
        this.printIndent();
        this.print("glIndexMask(" + n + ")");
        this.downstreamGL.glIndexMask(n);
        this.println("");
    }

    public void glIndexMaterialEXT(int n, int n2) {
        this.printIndent();
        this.print("glIndexMaterialEXT(" + n + "," + n2 + ")");
        this.downstreamGL.glIndexMaterialEXT(n, n2);
        this.println("");
    }

    public void glIndexPointer(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glIndexPointer(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glIndexPointer(n, n2, buffer);
        this.println("");
    }

    public void glIndexPointerEXT(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glIndexPointerEXT(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glIndexPointerEXT(n, n2, n3, buffer);
        this.println("");
    }

    public void glIndexPointerListIBM(int n, int n2, Buffer[] bufferArray, int n3) {
        this.printIndent();
        this.print("glIndexPointerListIBM(" + n + "," + n2 + "," + this.dumpArray(bufferArray) + "," + n3 + ")");
        this.downstreamGL.glIndexPointerListIBM(n, n2, bufferArray, n3);
        this.println("");
    }

    public void glIndexd(double d) {
        this.printIndent();
        this.print("glIndexd(" + d + ")");
        this.downstreamGL.glIndexd(d);
        this.println("");
    }

    public void glIndexdv(double[] dArray) {
        this.printIndent();
        this.print("glIndexdv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glIndexdv(dArray);
        this.println("");
    }

    public void glIndexdv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glIndexdv(" + doubleBuffer + ")");
        this.downstreamGL.glIndexdv(doubleBuffer);
        this.println("");
    }

    public void glIndexf(float f) {
        this.printIndent();
        this.print("glIndexf(" + f + ")");
        this.downstreamGL.glIndexf(f);
        this.println("");
    }

    public void glIndexfv(float[] fArray) {
        this.printIndent();
        this.print("glIndexfv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glIndexfv(fArray);
        this.println("");
    }

    public void glIndexfv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glIndexfv(" + floatBuffer + ")");
        this.downstreamGL.glIndexfv(floatBuffer);
        this.println("");
    }

    public void glIndexi(int n) {
        this.printIndent();
        this.print("glIndexi(" + n + ")");
        this.downstreamGL.glIndexi(n);
        this.println("");
    }

    public void glIndexiv(int[] nArray) {
        this.printIndent();
        this.print("glIndexiv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glIndexiv(nArray);
        this.println("");
    }

    public void glIndexiv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glIndexiv(" + intBuffer + ")");
        this.downstreamGL.glIndexiv(intBuffer);
        this.println("");
    }

    public void glIndexs(short s) {
        this.printIndent();
        this.print("glIndexs(" + s + ")");
        this.downstreamGL.glIndexs(s);
        this.println("");
    }

    public void glIndexsv(short[] sArray) {
        this.printIndent();
        this.print("glIndexsv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glIndexsv(sArray);
        this.println("");
    }

    public void glIndexsv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glIndexsv(" + shortBuffer + ")");
        this.downstreamGL.glIndexsv(shortBuffer);
        this.println("");
    }

    public void glIndexub(byte by) {
        this.printIndent();
        this.print("glIndexub(" + by + ")");
        this.downstreamGL.glIndexub(by);
        this.println("");
    }

    public void glIndexubv(byte[] byArray) {
        this.printIndent();
        this.print("glIndexubv(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glIndexubv(byArray);
        this.println("");
    }

    public void glIndexubv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glIndexubv(" + byteBuffer + ")");
        this.downstreamGL.glIndexubv(byteBuffer);
        this.println("");
    }

    public void glInitNames() {
        this.printIndent();
        this.print("glInitNames()");
        this.downstreamGL.glInitNames();
        this.println("");
    }

    public void glInsertComponentEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glInsertComponentEXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glInsertComponentEXT(n, n2, n3);
        this.println("");
    }

    public void glInstrumentsBufferSGIX(int n, int[] nArray) {
        this.printIndent();
        this.print("glInstrumentsBufferSGIX(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glInstrumentsBufferSGIX(n, nArray);
        this.println("");
    }

    public void glInstrumentsBufferSGIX(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glInstrumentsBufferSGIX(" + n + "," + intBuffer + ")");
        this.downstreamGL.glInstrumentsBufferSGIX(n, intBuffer);
        this.println("");
    }

    public void glInterleavedArrays(int n, int n2, boolean[] blArray) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n + "," + n2 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glInterleavedArrays(n, n2, blArray);
        this.println("");
    }

    public void glInterleavedArrays(int n, int n2, char[] cArray) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n + "," + n2 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glInterleavedArrays(n, n2, cArray);
        this.println("");
    }

    public void glInterleavedArrays(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glInterleavedArrays(n, n2, byArray);
        this.println("");
    }

    public void glInterleavedArrays(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glInterleavedArrays(n, n2, sArray);
        this.println("");
    }

    public void glInterleavedArrays(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glInterleavedArrays(n, n2, nArray);
        this.println("");
    }

    public void glInterleavedArrays(int n, int n2, long[] lArray) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n + "," + n2 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glInterleavedArrays(n, n2, lArray);
        this.println("");
    }

    public void glInterleavedArrays(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glInterleavedArrays(n, n2, fArray);
        this.println("");
    }

    public void glInterleavedArrays(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glInterleavedArrays(n, n2, dArray);
        this.println("");
    }

    public void glInterleavedArrays(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glInterleavedArrays(n, n2, buffer);
        this.println("");
    }

    public boolean glIsAsyncMarkerSGIX(int n) {
        this.printIndent();
        this.print("glIsAsyncMarkerSGIX(" + n + ")");
        boolean bl = this.downstreamGL.glIsAsyncMarkerSGIX(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsBuffer(int n) {
        this.printIndent();
        this.print("glIsBuffer(" + n + ")");
        boolean bl = this.downstreamGL.glIsBuffer(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsBufferARB(int n) {
        this.printIndent();
        this.print("glIsBufferARB(" + n + ")");
        boolean bl = this.downstreamGL.glIsBufferARB(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsEnabled(int n) {
        this.printIndent();
        this.print("glIsEnabled(" + n + ")");
        boolean bl = this.downstreamGL.glIsEnabled(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsFenceAPPLE(int n) {
        this.printIndent();
        this.print("glIsFenceAPPLE(" + n + ")");
        boolean bl = this.downstreamGL.glIsFenceAPPLE(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsFenceNV(int n) {
        this.printIndent();
        this.print("glIsFenceNV(" + n + ")");
        boolean bl = this.downstreamGL.glIsFenceNV(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsFramebufferEXT(int n) {
        this.printIndent();
        this.print("glIsFramebufferEXT(" + n + ")");
        boolean bl = this.downstreamGL.glIsFramebufferEXT(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsList(int n) {
        this.printIndent();
        this.print("glIsList(" + n + ")");
        boolean bl = this.downstreamGL.glIsList(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsObjectBufferATI(int n) {
        this.printIndent();
        this.print("glIsObjectBufferATI(" + n + ")");
        boolean bl = this.downstreamGL.glIsObjectBufferATI(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsOcclusionQueryNV(int n) {
        this.printIndent();
        this.print("glIsOcclusionQueryNV(" + n + ")");
        boolean bl = this.downstreamGL.glIsOcclusionQueryNV(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsProgram(int n) {
        this.printIndent();
        this.print("glIsProgram(" + n + ")");
        boolean bl = this.downstreamGL.glIsProgram(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsProgramARB(int n) {
        this.printIndent();
        this.print("glIsProgramARB(" + n + ")");
        boolean bl = this.downstreamGL.glIsProgramARB(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsProgramNV(int n) {
        this.printIndent();
        this.print("glIsProgramNV(" + n + ")");
        boolean bl = this.downstreamGL.glIsProgramNV(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsQuery(int n) {
        this.printIndent();
        this.print("glIsQuery(" + n + ")");
        boolean bl = this.downstreamGL.glIsQuery(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsQueryARB(int n) {
        this.printIndent();
        this.print("glIsQueryARB(" + n + ")");
        boolean bl = this.downstreamGL.glIsQueryARB(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsRenderbufferEXT(int n) {
        this.printIndent();
        this.print("glIsRenderbufferEXT(" + n + ")");
        boolean bl = this.downstreamGL.glIsRenderbufferEXT(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsShader(int n) {
        this.printIndent();
        this.print("glIsShader(" + n + ")");
        boolean bl = this.downstreamGL.glIsShader(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsTexture(int n) {
        this.printIndent();
        this.print("glIsTexture(" + n + ")");
        boolean bl = this.downstreamGL.glIsTexture(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsTextureEXT(int n) {
        this.printIndent();
        this.print("glIsTextureEXT(" + n + ")");
        boolean bl = this.downstreamGL.glIsTextureEXT(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsVariantEnabledEXT(int n, int n2) {
        this.printIndent();
        this.print("glIsVariantEnabledEXT(" + n + "," + n2 + ")");
        boolean bl = this.downstreamGL.glIsVariantEnabledEXT(n, n2);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsVertexArrayAPPLE(int n) {
        this.printIndent();
        this.print("glIsVertexArrayAPPLE(" + n + ")");
        boolean bl = this.downstreamGL.glIsVertexArrayAPPLE(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glIsVertexAttribEnabledAPPLE(int n, int n2) {
        this.printIndent();
        this.print("glIsVertexAttribEnabledAPPLE(" + n + "," + n2 + ")");
        boolean bl = this.downstreamGL.glIsVertexAttribEnabledAPPLE(n, n2);
        this.println(" = " + bl);
        return bl;
    }

    public void glLightEnviSGIX(int n, int n2) {
        this.printIndent();
        this.print("glLightEnviSGIX(" + n + "," + n2 + ")");
        this.downstreamGL.glLightEnviSGIX(n, n2);
        this.println("");
    }

    public void glLightModelf(int n, float f) {
        this.printIndent();
        this.print("glLightModelf(" + n + "," + f + ")");
        this.downstreamGL.glLightModelf(n, f);
        this.println("");
    }

    public void glLightModelfv(int n, float[] fArray) {
        this.printIndent();
        this.print("glLightModelfv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glLightModelfv(n, fArray);
        this.println("");
    }

    public void glLightModelfv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glLightModelfv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glLightModelfv(n, floatBuffer);
        this.println("");
    }

    public void glLightModeli(int n, int n2) {
        this.printIndent();
        this.print("glLightModeli(" + n + "," + n2 + ")");
        this.downstreamGL.glLightModeli(n, n2);
        this.println("");
    }

    public void glLightModeliv(int n, int[] nArray) {
        this.printIndent();
        this.print("glLightModeliv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glLightModeliv(n, nArray);
        this.println("");
    }

    public void glLightModeliv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glLightModeliv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glLightModeliv(n, intBuffer);
        this.println("");
    }

    public void glLightf(int n, int n2, float f) {
        this.printIndent();
        this.print("glLightf(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glLightf(n, n2, f);
        this.println("");
    }

    public void glLightfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glLightfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glLightfv(n, n2, fArray);
        this.println("");
    }

    public void glLightfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glLightfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glLightfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glLighti(int n, int n2, int n3) {
        this.printIndent();
        this.print("glLighti(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glLighti(n, n2, n3);
        this.println("");
    }

    public void glLightiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glLightiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glLightiv(n, n2, nArray);
        this.println("");
    }

    public void glLightiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glLightiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glLightiv(n, n2, intBuffer);
        this.println("");
    }

    public void glLineStipple(int n, short s) {
        this.printIndent();
        this.print("glLineStipple(" + n + "," + s + ")");
        this.downstreamGL.glLineStipple(n, s);
        this.println("");
    }

    public void glLineWidth(float f) {
        this.printIndent();
        this.print("glLineWidth(" + f + ")");
        this.downstreamGL.glLineWidth(f);
        this.println("");
    }

    public void glLinkProgram(int n) {
        this.printIndent();
        this.print("glLinkProgram(" + n + ")");
        this.downstreamGL.glLinkProgram(n);
        this.println("");
    }

    public void glLinkProgramARB(int n) {
        this.printIndent();
        this.print("glLinkProgramARB(" + n + ")");
        this.downstreamGL.glLinkProgramARB(n);
        this.println("");
    }

    public void glListBase(int n) {
        this.printIndent();
        this.print("glListBase(" + n + ")");
        this.downstreamGL.glListBase(n);
        this.println("");
    }

    public void glListParameterfSGIX(int n, int n2, float f) {
        this.printIndent();
        this.print("glListParameterfSGIX(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glListParameterfSGIX(n, n2, f);
        this.println("");
    }

    public void glListParameterfvSGIX(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glListParameterfvSGIX(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glListParameterfvSGIX(n, n2, fArray);
        this.println("");
    }

    public void glListParameterfvSGIX(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glListParameterfvSGIX(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glListParameterfvSGIX(n, n2, floatBuffer);
        this.println("");
    }

    public void glListParameteriSGIX(int n, int n2, int n3) {
        this.printIndent();
        this.print("glListParameteriSGIX(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glListParameteriSGIX(n, n2, n3);
        this.println("");
    }

    public void glListParameterivSGIX(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glListParameterivSGIX(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glListParameterivSGIX(n, n2, nArray);
        this.println("");
    }

    public void glListParameterivSGIX(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glListParameterivSGIX(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glListParameterivSGIX(n, n2, intBuffer);
        this.println("");
    }

    public void glLoadIdentity() {
        this.printIndent();
        this.print("glLoadIdentity()");
        this.downstreamGL.glLoadIdentity();
        this.println("");
    }

    public void glLoadIdentityDeformationMapSGIX(int n) {
        this.printIndent();
        this.print("glLoadIdentityDeformationMapSGIX(" + n + ")");
        this.downstreamGL.glLoadIdentityDeformationMapSGIX(n);
        this.println("");
    }

    public void glLoadMatrixd(double[] dArray) {
        this.printIndent();
        this.print("glLoadMatrixd(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glLoadMatrixd(dArray);
        this.println("");
    }

    public void glLoadMatrixd(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glLoadMatrixd(" + doubleBuffer + ")");
        this.downstreamGL.glLoadMatrixd(doubleBuffer);
        this.println("");
    }

    public void glLoadMatrixf(float[] fArray) {
        this.printIndent();
        this.print("glLoadMatrixf(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glLoadMatrixf(fArray);
        this.println("");
    }

    public void glLoadMatrixf(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glLoadMatrixf(" + floatBuffer + ")");
        this.downstreamGL.glLoadMatrixf(floatBuffer);
        this.println("");
    }

    public void glLoadName(int n) {
        this.printIndent();
        this.print("glLoadName(" + n + ")");
        this.downstreamGL.glLoadName(n);
        this.println("");
    }

    public void glLoadProgramNV(int n, int n2, int n3, String string) {
        this.printIndent();
        this.print("glLoadProgramNV(" + n + "," + n2 + "," + n3 + "," + string + ")");
        this.downstreamGL.glLoadProgramNV(n, n2, n3, string);
        this.println("");
    }

    public void glLoadTransposeMatrixd(double[] dArray) {
        this.printIndent();
        this.print("glLoadTransposeMatrixd(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glLoadTransposeMatrixd(dArray);
        this.println("");
    }

    public void glLoadTransposeMatrixd(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glLoadTransposeMatrixd(" + doubleBuffer + ")");
        this.downstreamGL.glLoadTransposeMatrixd(doubleBuffer);
        this.println("");
    }

    public void glLoadTransposeMatrixdARB(double[] dArray) {
        this.printIndent();
        this.print("glLoadTransposeMatrixdARB(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glLoadTransposeMatrixdARB(dArray);
        this.println("");
    }

    public void glLoadTransposeMatrixdARB(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glLoadTransposeMatrixdARB(" + doubleBuffer + ")");
        this.downstreamGL.glLoadTransposeMatrixdARB(doubleBuffer);
        this.println("");
    }

    public void glLoadTransposeMatrixf(float[] fArray) {
        this.printIndent();
        this.print("glLoadTransposeMatrixf(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glLoadTransposeMatrixf(fArray);
        this.println("");
    }

    public void glLoadTransposeMatrixf(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glLoadTransposeMatrixf(" + floatBuffer + ")");
        this.downstreamGL.glLoadTransposeMatrixf(floatBuffer);
        this.println("");
    }

    public void glLoadTransposeMatrixfARB(float[] fArray) {
        this.printIndent();
        this.print("glLoadTransposeMatrixfARB(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glLoadTransposeMatrixfARB(fArray);
        this.println("");
    }

    public void glLoadTransposeMatrixfARB(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glLoadTransposeMatrixfARB(" + floatBuffer + ")");
        this.downstreamGL.glLoadTransposeMatrixfARB(floatBuffer);
        this.println("");
    }

    public void glLockArraysEXT(int n, int n2) {
        this.printIndent();
        this.print("glLockArraysEXT(" + n + "," + n2 + ")");
        this.downstreamGL.glLockArraysEXT(n, n2);
        this.println("");
    }

    public void glLogicOp(int n) {
        this.printIndent();
        this.print("glLogicOp(" + n + ")");
        this.downstreamGL.glLogicOp(n);
        this.println("");
    }

    public void glMap1d(int n, double d, double d2, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glMap1d(" + n + "," + d + "," + d2 + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMap1d(n, d, d2, n2, n3, dArray);
        this.println("");
    }

    public void glMap1d(int n, double d, double d2, int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMap1d(" + n + "," + d + "," + d2 + "," + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glMap1d(n, d, d2, n2, n3, doubleBuffer);
        this.println("");
    }

    public void glMap1f(int n, float f, float f2, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glMap1f(" + n + "," + f + "," + f2 + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMap1f(n, f, f2, n2, n3, fArray);
        this.println("");
    }

    public void glMap1f(int n, float f, float f2, int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMap1f(" + n + "," + f + "," + f2 + "," + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glMap1f(n, f, f2, n2, n3, floatBuffer);
        this.println("");
    }

    public void glMap2d(int n, double d, double d2, int n2, int n3, double d3, double d4, int n4, int n5, double[] dArray) {
        this.printIndent();
        this.print("glMap2d(" + n + "," + d + "," + d2 + "," + n2 + "," + n3 + "," + d3 + "," + d4 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMap2d(n, d, d2, n2, n3, d3, d4, n4, n5, dArray);
        this.println("");
    }

    public void glMap2d(int n, double d, double d2, int n2, int n3, double d3, double d4, int n4, int n5, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMap2d(" + n + "," + d + "," + d2 + "," + n2 + "," + n3 + "," + d3 + "," + d4 + "," + n4 + "," + n5 + "," + doubleBuffer + ")");
        this.downstreamGL.glMap2d(n, d, d2, n2, n3, d3, d4, n4, n5, doubleBuffer);
        this.println("");
    }

    public void glMap2f(int n, float f, float f2, int n2, int n3, float f3, float f4, int n4, int n5, float[] fArray) {
        this.printIndent();
        this.print("glMap2f(" + n + "," + f + "," + f2 + "," + n2 + "," + n3 + "," + f3 + "," + f4 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMap2f(n, f, f2, n2, n3, f3, f4, n4, n5, fArray);
        this.println("");
    }

    public void glMap2f(int n, float f, float f2, int n2, int n3, float f3, float f4, int n4, int n5, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMap2f(" + n + "," + f + "," + f2 + "," + n2 + "," + n3 + "," + f3 + "," + f4 + "," + n4 + "," + n5 + "," + floatBuffer + ")");
        this.downstreamGL.glMap2f(n, f, f2, n2, n3, f3, f4, n4, n5, floatBuffer);
        this.println("");
    }

    public ByteBuffer glMapBuffer(int n, int n2) {
        this.printIndent();
        this.print("glMapBuffer(" + n + "," + n2 + ")");
        ByteBuffer byteBuffer = this.downstreamGL.glMapBuffer(n, n2);
        this.println(" = " + byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer glMapBufferARB(int n, int n2) {
        this.printIndent();
        this.print("glMapBufferARB(" + n + "," + n2 + ")");
        ByteBuffer byteBuffer = this.downstreamGL.glMapBufferARB(n, n2);
        this.println(" = " + byteBuffer);
        return byteBuffer;
    }

    public void glMapControlPointsNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean[] blArray) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glMapControlPointsNV(n, n2, n3, n4, n5, n6, n7, bl, blArray);
        this.println("");
    }

    public void glMapControlPointsNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, char[] cArray) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glMapControlPointsNV(n, n2, n3, n4, n5, n6, n7, bl, cArray);
        this.println("");
    }

    public void glMapControlPointsNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, byte[] byArray) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glMapControlPointsNV(n, n2, n3, n4, n5, n6, n7, bl, byArray);
        this.println("");
    }

    public void glMapControlPointsNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, short[] sArray) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMapControlPointsNV(n, n2, n3, n4, n5, n6, n7, bl, sArray);
        this.println("");
    }

    public void glMapControlPointsNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, int[] nArray) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMapControlPointsNV(n, n2, n3, n4, n5, n6, n7, bl, nArray);
        this.println("");
    }

    public void glMapControlPointsNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, long[] lArray) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glMapControlPointsNV(n, n2, n3, n4, n5, n6, n7, bl, lArray);
        this.println("");
    }

    public void glMapControlPointsNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float[] fArray) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMapControlPointsNV(n, n2, n3, n4, n5, n6, n7, bl, fArray);
        this.println("");
    }

    public void glMapControlPointsNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, double[] dArray) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMapControlPointsNV(n, n2, n3, n4, n5, n6, n7, bl, dArray);
        this.println("");
    }

    public void glMapControlPointsNV(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, Buffer buffer) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + bl + "," + buffer + ")");
        this.downstreamGL.glMapControlPointsNV(n, n2, n3, n4, n5, n6, n7, bl, buffer);
        this.println("");
    }

    public void glMapGrid1d(int n, double d, double d2) {
        this.printIndent();
        this.print("glMapGrid1d(" + n + "," + d + "," + d2 + ")");
        this.downstreamGL.glMapGrid1d(n, d, d2);
        this.println("");
    }

    public void glMapGrid1f(int n, float f, float f2) {
        this.printIndent();
        this.print("glMapGrid1f(" + n + "," + f + "," + f2 + ")");
        this.downstreamGL.glMapGrid1f(n, f, f2);
        this.println("");
    }

    public void glMapGrid2d(int n, double d, double d2, int n2, double d3, double d4) {
        this.printIndent();
        this.print("glMapGrid2d(" + n + "," + d + "," + d2 + "," + n2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glMapGrid2d(n, d, d2, n2, d3, d4);
        this.println("");
    }

    public void glMapGrid2f(int n, float f, float f2, int n2, float f3, float f4) {
        this.printIndent();
        this.print("glMapGrid2f(" + n + "," + f + "," + f2 + "," + n2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glMapGrid2f(n, f, f2, n2, f3, f4);
        this.println("");
    }

    public void glMapParameterfvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glMapParameterfvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMapParameterfvNV(n, n2, fArray);
        this.println("");
    }

    public void glMapParameterfvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMapParameterfvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glMapParameterfvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glMapParameterivNV(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glMapParameterivNV(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMapParameterivNV(n, n2, nArray);
        this.println("");
    }

    public void glMapParameterivNV(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMapParameterivNV(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glMapParameterivNV(n, n2, intBuffer);
        this.println("");
    }

    public void glMapVertexAttrib1dAPPLE(int n, int n2, double d, double d2, int n3, int n4, double[] dArray) {
        this.printIndent();
        this.print("glMapVertexAttrib1dAPPLE(" + n + "," + n2 + "," + d + "," + d2 + "," + n3 + "," + n4 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMapVertexAttrib1dAPPLE(n, n2, d, d2, n3, n4, dArray);
        this.println("");
    }

    public void glMapVertexAttrib1dAPPLE(int n, int n2, double d, double d2, int n3, int n4, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMapVertexAttrib1dAPPLE(" + n + "," + n2 + "," + d + "," + d2 + "," + n3 + "," + n4 + "," + doubleBuffer + ")");
        this.downstreamGL.glMapVertexAttrib1dAPPLE(n, n2, d, d2, n3, n4, doubleBuffer);
        this.println("");
    }

    public void glMapVertexAttrib1fAPPLE(int n, int n2, float f, float f2, int n3, int n4, float[] fArray) {
        this.printIndent();
        this.print("glMapVertexAttrib1fAPPLE(" + n + "," + n2 + "," + f + "," + f2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMapVertexAttrib1fAPPLE(n, n2, f, f2, n3, n4, fArray);
        this.println("");
    }

    public void glMapVertexAttrib1fAPPLE(int n, int n2, float f, float f2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMapVertexAttrib1fAPPLE(" + n + "," + n2 + "," + f + "," + f2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glMapVertexAttrib1fAPPLE(n, n2, f, f2, n3, n4, floatBuffer);
        this.println("");
    }

    public void glMapVertexAttrib2dAPPLE(int n, int n2, double d, double d2, int n3, int n4, double d3, double d4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glMapVertexAttrib2dAPPLE(" + n + "," + n2 + "," + d + "," + d2 + "," + n3 + "," + n4 + "," + d3 + "," + d4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMapVertexAttrib2dAPPLE(n, n2, d, d2, n3, n4, d3, d4, n5, n6, dArray);
        this.println("");
    }

    public void glMapVertexAttrib2dAPPLE(int n, int n2, double d, double d2, int n3, int n4, double d3, double d4, int n5, int n6, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMapVertexAttrib2dAPPLE(" + n + "," + n2 + "," + d + "," + d2 + "," + n3 + "," + n4 + "," + d3 + "," + d4 + "," + n5 + "," + n6 + "," + doubleBuffer + ")");
        this.downstreamGL.glMapVertexAttrib2dAPPLE(n, n2, d, d2, n3, n4, d3, d4, n5, n6, doubleBuffer);
        this.println("");
    }

    public void glMapVertexAttrib2fAPPLE(int n, int n2, float f, float f2, int n3, int n4, float f3, float f4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glMapVertexAttrib2fAPPLE(" + n + "," + n2 + "," + f + "," + f2 + "," + n3 + "," + n4 + "," + f3 + "," + f4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMapVertexAttrib2fAPPLE(n, n2, f, f2, n3, n4, f3, f4, n5, n6, fArray);
        this.println("");
    }

    public void glMapVertexAttrib2fAPPLE(int n, int n2, float f, float f2, int n3, int n4, float f3, float f4, int n5, int n6, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMapVertexAttrib2fAPPLE(" + n + "," + n2 + "," + f + "," + f2 + "," + n3 + "," + n4 + "," + f3 + "," + f4 + "," + n5 + "," + n6 + "," + floatBuffer + ")");
        this.downstreamGL.glMapVertexAttrib2fAPPLE(n, n2, f, f2, n3, n4, f3, f4, n5, n6, floatBuffer);
        this.println("");
    }

    public void glMaterialf(int n, int n2, float f) {
        this.printIndent();
        this.print("glMaterialf(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glMaterialf(n, n2, f);
        this.println("");
    }

    public void glMaterialfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glMaterialfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMaterialfv(n, n2, fArray);
        this.println("");
    }

    public void glMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMaterialfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glMaterialfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glMateriali(int n, int n2, int n3) {
        this.printIndent();
        this.print("glMateriali(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glMateriali(n, n2, n3);
        this.println("");
    }

    public void glMaterialiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glMaterialiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMaterialiv(n, n2, nArray);
        this.println("");
    }

    public void glMaterialiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMaterialiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glMaterialiv(n, n2, intBuffer);
        this.println("");
    }

    public void glMatrixIndexPointerARB(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glMatrixIndexPointerARB(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glMatrixIndexPointerARB(n, n2, n3, buffer);
        this.println("");
    }

    public void glMatrixIndexubvARB(int n, byte[] byArray) {
        this.printIndent();
        this.print("glMatrixIndexubvARB(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glMatrixIndexubvARB(n, byArray);
        this.println("");
    }

    public void glMatrixIndexubvARB(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glMatrixIndexubvARB(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glMatrixIndexubvARB(n, byteBuffer);
        this.println("");
    }

    public void glMatrixIndexuivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glMatrixIndexuivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMatrixIndexuivARB(n, nArray);
        this.println("");
    }

    public void glMatrixIndexuivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMatrixIndexuivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glMatrixIndexuivARB(n, intBuffer);
        this.println("");
    }

    public void glMatrixIndexusvARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glMatrixIndexusvARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMatrixIndexusvARB(n, sArray);
        this.println("");
    }

    public void glMatrixIndexusvARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMatrixIndexusvARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMatrixIndexusvARB(n, shortBuffer);
        this.println("");
    }

    public void glMatrixMode(int n) {
        this.printIndent();
        this.print("glMatrixMode(" + n + ")");
        this.downstreamGL.glMatrixMode(n);
        this.println("");
    }

    public void glMinmax(int n, int n2, boolean bl) {
        this.printIndent();
        this.print("glMinmax(" + n + "," + n2 + "," + bl + ")");
        this.downstreamGL.glMinmax(n, n2, bl);
        this.println("");
    }

    public void glMinmaxEXT(int n, int n2, boolean bl) {
        this.printIndent();
        this.print("glMinmaxEXT(" + n + "," + n2 + "," + bl + ")");
        this.downstreamGL.glMinmaxEXT(n, n2, bl);
        this.println("");
    }

    public void glMultMatrixd(double[] dArray) {
        this.printIndent();
        this.print("glMultMatrixd(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultMatrixd(dArray);
        this.println("");
    }

    public void glMultMatrixd(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultMatrixd(" + doubleBuffer + ")");
        this.downstreamGL.glMultMatrixd(doubleBuffer);
        this.println("");
    }

    public void glMultMatrixf(float[] fArray) {
        this.printIndent();
        this.print("glMultMatrixf(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultMatrixf(fArray);
        this.println("");
    }

    public void glMultMatrixf(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultMatrixf(" + floatBuffer + ")");
        this.downstreamGL.glMultMatrixf(floatBuffer);
        this.println("");
    }

    public void glMultTransposeMatrixd(double[] dArray) {
        this.printIndent();
        this.print("glMultTransposeMatrixd(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultTransposeMatrixd(dArray);
        this.println("");
    }

    public void glMultTransposeMatrixd(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultTransposeMatrixd(" + doubleBuffer + ")");
        this.downstreamGL.glMultTransposeMatrixd(doubleBuffer);
        this.println("");
    }

    public void glMultTransposeMatrixdARB(double[] dArray) {
        this.printIndent();
        this.print("glMultTransposeMatrixdARB(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultTransposeMatrixdARB(dArray);
        this.println("");
    }

    public void glMultTransposeMatrixdARB(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultTransposeMatrixdARB(" + doubleBuffer + ")");
        this.downstreamGL.glMultTransposeMatrixdARB(doubleBuffer);
        this.println("");
    }

    public void glMultTransposeMatrixf(float[] fArray) {
        this.printIndent();
        this.print("glMultTransposeMatrixf(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultTransposeMatrixf(fArray);
        this.println("");
    }

    public void glMultTransposeMatrixf(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultTransposeMatrixf(" + floatBuffer + ")");
        this.downstreamGL.glMultTransposeMatrixf(floatBuffer);
        this.println("");
    }

    public void glMultTransposeMatrixfARB(float[] fArray) {
        this.printIndent();
        this.print("glMultTransposeMatrixfARB(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultTransposeMatrixfARB(fArray);
        this.println("");
    }

    public void glMultTransposeMatrixfARB(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultTransposeMatrixfARB(" + floatBuffer + ")");
        this.downstreamGL.glMultTransposeMatrixfARB(floatBuffer);
        this.println("");
    }

    public void glMultiDrawArrays(int n, int[] nArray, int[] nArray2, int n2) {
        this.printIndent();
        this.print("glMultiDrawArrays(" + n + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + n2 + ")");
        this.downstreamGL.glMultiDrawArrays(n, nArray, nArray2, n2);
        this.println("");
    }

    public void glMultiDrawArrays(int n, IntBuffer intBuffer, IntBuffer intBuffer2, int n2) {
        this.printIndent();
        this.print("glMultiDrawArrays(" + n + "," + intBuffer + "," + intBuffer2 + "," + n2 + ")");
        this.downstreamGL.glMultiDrawArrays(n, intBuffer, intBuffer2, n2);
        this.println("");
    }

    public void glMultiDrawArraysEXT(int n, int[] nArray, int[] nArray2, int n2) {
        this.printIndent();
        this.print("glMultiDrawArraysEXT(" + n + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + n2 + ")");
        this.downstreamGL.glMultiDrawArraysEXT(n, nArray, nArray2, n2);
        this.println("");
    }

    public void glMultiDrawArraysEXT(int n, IntBuffer intBuffer, IntBuffer intBuffer2, int n2) {
        this.printIndent();
        this.print("glMultiDrawArraysEXT(" + n + "," + intBuffer + "," + intBuffer2 + "," + n2 + ")");
        this.downstreamGL.glMultiDrawArraysEXT(n, intBuffer, intBuffer2, n2);
        this.println("");
    }

    public void glMultiDrawElementArrayAPPLE(int n, int[] nArray, int[] nArray2, int n2) {
        this.printIndent();
        this.print("glMultiDrawElementArrayAPPLE(" + n + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + n2 + ")");
        this.downstreamGL.glMultiDrawElementArrayAPPLE(n, nArray, nArray2, n2);
        this.println("");
    }

    public void glMultiDrawElementArrayAPPLE(int n, IntBuffer intBuffer, IntBuffer intBuffer2, int n2) {
        this.printIndent();
        this.print("glMultiDrawElementArrayAPPLE(" + n + "," + intBuffer + "," + intBuffer2 + "," + n2 + ")");
        this.downstreamGL.glMultiDrawElementArrayAPPLE(n, intBuffer, intBuffer2, n2);
        this.println("");
    }

    public void glMultiDrawElementArrayNV(int n, int[] nArray, int[] nArray2, int n2) {
        this.printIndent();
        this.print("glMultiDrawElementArrayNV(" + n + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + n2 + ")");
        this.downstreamGL.glMultiDrawElementArrayNV(n, nArray, nArray2, n2);
        this.println("");
    }

    public void glMultiDrawElementArrayNV(int n, IntBuffer intBuffer, IntBuffer intBuffer2, int n2) {
        this.printIndent();
        this.print("glMultiDrawElementArrayNV(" + n + "," + intBuffer + "," + intBuffer2 + "," + n2 + ")");
        this.downstreamGL.glMultiDrawElementArrayNV(n, intBuffer, intBuffer2, n2);
        this.println("");
    }

    public void glMultiDrawElements(int n, int[] nArray, int n2, Buffer[] bufferArray, int n3) {
        this.printIndent();
        this.print("glMultiDrawElements(" + n + "," + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(bufferArray) + "," + n3 + ")");
        this.downstreamGL.glMultiDrawElements(n, nArray, n2, bufferArray, n3);
        this.println("");
    }

    public void glMultiDrawElements(int n, IntBuffer intBuffer, int n2, Buffer[] bufferArray, int n3) {
        this.printIndent();
        this.print("glMultiDrawElements(" + n + "," + intBuffer + "," + n2 + "," + this.dumpArray(bufferArray) + "," + n3 + ")");
        this.downstreamGL.glMultiDrawElements(n, intBuffer, n2, bufferArray, n3);
        this.println("");
    }

    public void glMultiDrawElementsEXT(int n, int[] nArray, int n2, Buffer[] bufferArray, int n3) {
        this.printIndent();
        this.print("glMultiDrawElementsEXT(" + n + "," + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(bufferArray) + "," + n3 + ")");
        this.downstreamGL.glMultiDrawElementsEXT(n, nArray, n2, bufferArray, n3);
        this.println("");
    }

    public void glMultiDrawElementsEXT(int n, IntBuffer intBuffer, int n2, Buffer[] bufferArray, int n3) {
        this.printIndent();
        this.print("glMultiDrawElementsEXT(" + n + "," + intBuffer + "," + n2 + "," + this.dumpArray(bufferArray) + "," + n3 + ")");
        this.downstreamGL.glMultiDrawElementsEXT(n, intBuffer, n2, bufferArray, n3);
        this.println("");
    }

    public void glMultiDrawRangeElementArrayAPPLE(int n, int n2, int n3, int[] nArray, int[] nArray2, int n4) {
        this.printIndent();
        this.print("glMultiDrawRangeElementArrayAPPLE(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + n4 + ")");
        this.downstreamGL.glMultiDrawRangeElementArrayAPPLE(n, n2, n3, nArray, nArray2, n4);
        this.println("");
    }

    public void glMultiDrawRangeElementArrayAPPLE(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, int n4) {
        this.printIndent();
        this.print("glMultiDrawRangeElementArrayAPPLE(" + n + "," + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + "," + n4 + ")");
        this.downstreamGL.glMultiDrawRangeElementArrayAPPLE(n, n2, n3, intBuffer, intBuffer2, n4);
        this.println("");
    }

    public void glMultiDrawRangeElementArrayNV(int n, int n2, int n3, int[] nArray, int[] nArray2, int n4) {
        this.printIndent();
        this.print("glMultiDrawRangeElementArrayNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + n4 + ")");
        this.downstreamGL.glMultiDrawRangeElementArrayNV(n, n2, n3, nArray, nArray2, n4);
        this.println("");
    }

    public void glMultiDrawRangeElementArrayNV(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, int n4) {
        this.printIndent();
        this.print("glMultiDrawRangeElementArrayNV(" + n + "," + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + "," + n4 + ")");
        this.downstreamGL.glMultiDrawRangeElementArrayNV(n, n2, n3, intBuffer, intBuffer2, n4);
        this.println("");
    }

    public void glMultiModeDrawArraysIBM(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
        this.printIndent();
        this.print("glMultiModeDrawArraysIBM(" + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + "," + n + "," + n2 + ")");
        this.downstreamGL.glMultiModeDrawArraysIBM(nArray, nArray2, nArray3, n, n2);
        this.println("");
    }

    public void glMultiModeDrawArraysIBM(IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n, int n2) {
        this.printIndent();
        this.print("glMultiModeDrawArraysIBM(" + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + n + "," + n2 + ")");
        this.downstreamGL.glMultiModeDrawArraysIBM(intBuffer, intBuffer2, intBuffer3, n, n2);
        this.println("");
    }

    public void glMultiModeDrawElementsIBM(int[] nArray, int[] nArray2, int n, Buffer[] bufferArray, int n2, int n3) {
        this.printIndent();
        this.print("glMultiModeDrawElementsIBM(" + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + n + "," + this.dumpArray(bufferArray) + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glMultiModeDrawElementsIBM(nArray, nArray2, n, bufferArray, n2, n3);
        this.println("");
    }

    public void glMultiModeDrawElementsIBM(IntBuffer intBuffer, IntBuffer intBuffer2, int n, Buffer[] bufferArray, int n2, int n3) {
        this.printIndent();
        this.print("glMultiModeDrawElementsIBM(" + intBuffer + "," + intBuffer2 + "," + n + "," + this.dumpArray(bufferArray) + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glMultiModeDrawElementsIBM(intBuffer, intBuffer2, n, bufferArray, n2, n3);
        this.println("");
    }

    public void glMultiTexCoord1d(int n, double d) {
        this.printIndent();
        this.print("glMultiTexCoord1d(" + n + "," + d + ")");
        this.downstreamGL.glMultiTexCoord1d(n, d);
        this.println("");
    }

    public void glMultiTexCoord1dARB(int n, double d) {
        this.printIndent();
        this.print("glMultiTexCoord1dARB(" + n + "," + d + ")");
        this.downstreamGL.glMultiTexCoord1dARB(n, d);
        this.println("");
    }

    public void glMultiTexCoord1dv(int n, double[] dArray) {
        this.printIndent();
        this.print("glMultiTexCoord1dv(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultiTexCoord1dv(n, dArray);
        this.println("");
    }

    public void glMultiTexCoord1dv(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1dv(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord1dv(n, doubleBuffer);
        this.println("");
    }

    public void glMultiTexCoord1dvARB(int n, double[] dArray) {
        this.printIndent();
        this.print("glMultiTexCoord1dvARB(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultiTexCoord1dvARB(n, dArray);
        this.println("");
    }

    public void glMultiTexCoord1dvARB(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1dvARB(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord1dvARB(n, doubleBuffer);
        this.println("");
    }

    public void glMultiTexCoord1f(int n, float f) {
        this.printIndent();
        this.print("glMultiTexCoord1f(" + n + "," + f + ")");
        this.downstreamGL.glMultiTexCoord1f(n, f);
        this.println("");
    }

    public void glMultiTexCoord1fARB(int n, float f) {
        this.printIndent();
        this.print("glMultiTexCoord1fARB(" + n + "," + f + ")");
        this.downstreamGL.glMultiTexCoord1fARB(n, f);
        this.println("");
    }

    public void glMultiTexCoord1fv(int n, float[] fArray) {
        this.printIndent();
        this.print("glMultiTexCoord1fv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultiTexCoord1fv(n, fArray);
        this.println("");
    }

    public void glMultiTexCoord1fv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1fv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord1fv(n, floatBuffer);
        this.println("");
    }

    public void glMultiTexCoord1fvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glMultiTexCoord1fvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultiTexCoord1fvARB(n, fArray);
        this.println("");
    }

    public void glMultiTexCoord1fvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1fvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord1fvARB(n, floatBuffer);
        this.println("");
    }

    public void glMultiTexCoord1hNV(int n, short s) {
        this.printIndent();
        this.print("glMultiTexCoord1hNV(" + n + "," + s + ")");
        this.downstreamGL.glMultiTexCoord1hNV(n, s);
        this.println("");
    }

    public void glMultiTexCoord1hvNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord1hvNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord1hvNV(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord1hvNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1hvNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord1hvNV(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord1i(int n, int n2) {
        this.printIndent();
        this.print("glMultiTexCoord1i(" + n + "," + n2 + ")");
        this.downstreamGL.glMultiTexCoord1i(n, n2);
        this.println("");
    }

    public void glMultiTexCoord1iARB(int n, int n2) {
        this.printIndent();
        this.print("glMultiTexCoord1iARB(" + n + "," + n2 + ")");
        this.downstreamGL.glMultiTexCoord1iARB(n, n2);
        this.println("");
    }

    public void glMultiTexCoord1iv(int n, int[] nArray) {
        this.printIndent();
        this.print("glMultiTexCoord1iv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMultiTexCoord1iv(n, nArray);
        this.println("");
    }

    public void glMultiTexCoord1iv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1iv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord1iv(n, intBuffer);
        this.println("");
    }

    public void glMultiTexCoord1ivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glMultiTexCoord1ivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMultiTexCoord1ivARB(n, nArray);
        this.println("");
    }

    public void glMultiTexCoord1ivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1ivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord1ivARB(n, intBuffer);
        this.println("");
    }

    public void glMultiTexCoord1s(int n, short s) {
        this.printIndent();
        this.print("glMultiTexCoord1s(" + n + "," + s + ")");
        this.downstreamGL.glMultiTexCoord1s(n, s);
        this.println("");
    }

    public void glMultiTexCoord1sARB(int n, short s) {
        this.printIndent();
        this.print("glMultiTexCoord1sARB(" + n + "," + s + ")");
        this.downstreamGL.glMultiTexCoord1sARB(n, s);
        this.println("");
    }

    public void glMultiTexCoord1sv(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord1sv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord1sv(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord1sv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1sv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord1sv(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord1svARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord1svARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord1svARB(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord1svARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1svARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord1svARB(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord2d(int n, double d, double d2) {
        this.printIndent();
        this.print("glMultiTexCoord2d(" + n + "," + d + "," + d2 + ")");
        this.downstreamGL.glMultiTexCoord2d(n, d, d2);
        this.println("");
    }

    public void glMultiTexCoord2dARB(int n, double d, double d2) {
        this.printIndent();
        this.print("glMultiTexCoord2dARB(" + n + "," + d + "," + d2 + ")");
        this.downstreamGL.glMultiTexCoord2dARB(n, d, d2);
        this.println("");
    }

    public void glMultiTexCoord2dv(int n, double[] dArray) {
        this.printIndent();
        this.print("glMultiTexCoord2dv(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultiTexCoord2dv(n, dArray);
        this.println("");
    }

    public void glMultiTexCoord2dv(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2dv(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord2dv(n, doubleBuffer);
        this.println("");
    }

    public void glMultiTexCoord2dvARB(int n, double[] dArray) {
        this.printIndent();
        this.print("glMultiTexCoord2dvARB(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultiTexCoord2dvARB(n, dArray);
        this.println("");
    }

    public void glMultiTexCoord2dvARB(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2dvARB(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord2dvARB(n, doubleBuffer);
        this.println("");
    }

    public void glMultiTexCoord2f(int n, float f, float f2) {
        this.printIndent();
        this.print("glMultiTexCoord2f(" + n + "," + f + "," + f2 + ")");
        this.downstreamGL.glMultiTexCoord2f(n, f, f2);
        this.println("");
    }

    public void glMultiTexCoord2fARB(int n, float f, float f2) {
        this.printIndent();
        this.print("glMultiTexCoord2fARB(" + n + "," + f + "," + f2 + ")");
        this.downstreamGL.glMultiTexCoord2fARB(n, f, f2);
        this.println("");
    }

    public void glMultiTexCoord2fv(int n, float[] fArray) {
        this.printIndent();
        this.print("glMultiTexCoord2fv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultiTexCoord2fv(n, fArray);
        this.println("");
    }

    public void glMultiTexCoord2fv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2fv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord2fv(n, floatBuffer);
        this.println("");
    }

    public void glMultiTexCoord2fvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glMultiTexCoord2fvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultiTexCoord2fvARB(n, fArray);
        this.println("");
    }

    public void glMultiTexCoord2fvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2fvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord2fvARB(n, floatBuffer);
        this.println("");
    }

    public void glMultiTexCoord2hNV(int n, short s, short s2) {
        this.printIndent();
        this.print("glMultiTexCoord2hNV(" + n + "," + s + "," + s2 + ")");
        this.downstreamGL.glMultiTexCoord2hNV(n, s, s2);
        this.println("");
    }

    public void glMultiTexCoord2hvNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord2hvNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord2hvNV(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord2hvNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2hvNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord2hvNV(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord2i(int n, int n2, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord2i(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord2i(n, n2, n3);
        this.println("");
    }

    public void glMultiTexCoord2iARB(int n, int n2, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord2iARB(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord2iARB(n, n2, n3);
        this.println("");
    }

    public void glMultiTexCoord2iv(int n, int[] nArray) {
        this.printIndent();
        this.print("glMultiTexCoord2iv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMultiTexCoord2iv(n, nArray);
        this.println("");
    }

    public void glMultiTexCoord2iv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2iv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord2iv(n, intBuffer);
        this.println("");
    }

    public void glMultiTexCoord2ivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glMultiTexCoord2ivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMultiTexCoord2ivARB(n, nArray);
        this.println("");
    }

    public void glMultiTexCoord2ivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2ivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord2ivARB(n, intBuffer);
        this.println("");
    }

    public void glMultiTexCoord2s(int n, short s, short s2) {
        this.printIndent();
        this.print("glMultiTexCoord2s(" + n + "," + s + "," + s2 + ")");
        this.downstreamGL.glMultiTexCoord2s(n, s, s2);
        this.println("");
    }

    public void glMultiTexCoord2sARB(int n, short s, short s2) {
        this.printIndent();
        this.print("glMultiTexCoord2sARB(" + n + "," + s + "," + s2 + ")");
        this.downstreamGL.glMultiTexCoord2sARB(n, s, s2);
        this.println("");
    }

    public void glMultiTexCoord2sv(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord2sv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord2sv(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord2sv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2sv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord2sv(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord2svARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord2svARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord2svARB(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord2svARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2svARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord2svARB(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord3d(int n, double d, double d2, double d3) {
        this.printIndent();
        this.print("glMultiTexCoord3d(" + n + "," + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glMultiTexCoord3d(n, d, d2, d3);
        this.println("");
    }

    public void glMultiTexCoord3dARB(int n, double d, double d2, double d3) {
        this.printIndent();
        this.print("glMultiTexCoord3dARB(" + n + "," + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glMultiTexCoord3dARB(n, d, d2, d3);
        this.println("");
    }

    public void glMultiTexCoord3dv(int n, double[] dArray) {
        this.printIndent();
        this.print("glMultiTexCoord3dv(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultiTexCoord3dv(n, dArray);
        this.println("");
    }

    public void glMultiTexCoord3dv(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3dv(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord3dv(n, doubleBuffer);
        this.println("");
    }

    public void glMultiTexCoord3dvARB(int n, double[] dArray) {
        this.printIndent();
        this.print("glMultiTexCoord3dvARB(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultiTexCoord3dvARB(n, dArray);
        this.println("");
    }

    public void glMultiTexCoord3dvARB(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3dvARB(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord3dvARB(n, doubleBuffer);
        this.println("");
    }

    public void glMultiTexCoord3f(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glMultiTexCoord3f(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glMultiTexCoord3f(n, f, f2, f3);
        this.println("");
    }

    public void glMultiTexCoord3fARB(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glMultiTexCoord3fARB(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glMultiTexCoord3fARB(n, f, f2, f3);
        this.println("");
    }

    public void glMultiTexCoord3fv(int n, float[] fArray) {
        this.printIndent();
        this.print("glMultiTexCoord3fv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultiTexCoord3fv(n, fArray);
        this.println("");
    }

    public void glMultiTexCoord3fv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3fv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord3fv(n, floatBuffer);
        this.println("");
    }

    public void glMultiTexCoord3fvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glMultiTexCoord3fvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultiTexCoord3fvARB(n, fArray);
        this.println("");
    }

    public void glMultiTexCoord3fvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3fvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord3fvARB(n, floatBuffer);
        this.println("");
    }

    public void glMultiTexCoord3hNV(int n, short s, short s2, short s3) {
        this.printIndent();
        this.print("glMultiTexCoord3hNV(" + n + "," + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glMultiTexCoord3hNV(n, s, s2, s3);
        this.println("");
    }

    public void glMultiTexCoord3hvNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord3hvNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord3hvNV(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord3hvNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3hvNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord3hvNV(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord3i(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glMultiTexCoord3i(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glMultiTexCoord3i(n, n2, n3, n4);
        this.println("");
    }

    public void glMultiTexCoord3iARB(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glMultiTexCoord3iARB(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glMultiTexCoord3iARB(n, n2, n3, n4);
        this.println("");
    }

    public void glMultiTexCoord3iv(int n, int[] nArray) {
        this.printIndent();
        this.print("glMultiTexCoord3iv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMultiTexCoord3iv(n, nArray);
        this.println("");
    }

    public void glMultiTexCoord3iv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3iv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord3iv(n, intBuffer);
        this.println("");
    }

    public void glMultiTexCoord3ivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glMultiTexCoord3ivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMultiTexCoord3ivARB(n, nArray);
        this.println("");
    }

    public void glMultiTexCoord3ivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3ivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord3ivARB(n, intBuffer);
        this.println("");
    }

    public void glMultiTexCoord3s(int n, short s, short s2, short s3) {
        this.printIndent();
        this.print("glMultiTexCoord3s(" + n + "," + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glMultiTexCoord3s(n, s, s2, s3);
        this.println("");
    }

    public void glMultiTexCoord3sARB(int n, short s, short s2, short s3) {
        this.printIndent();
        this.print("glMultiTexCoord3sARB(" + n + "," + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glMultiTexCoord3sARB(n, s, s2, s3);
        this.println("");
    }

    public void glMultiTexCoord3sv(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord3sv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord3sv(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord3sv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3sv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord3sv(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord3svARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord3svARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord3svARB(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord3svARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3svARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord3svARB(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord4d(int n, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glMultiTexCoord4d(" + n + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glMultiTexCoord4d(n, d, d2, d3, d4);
        this.println("");
    }

    public void glMultiTexCoord4dARB(int n, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glMultiTexCoord4dARB(" + n + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glMultiTexCoord4dARB(n, d, d2, d3, d4);
        this.println("");
    }

    public void glMultiTexCoord4dv(int n, double[] dArray) {
        this.printIndent();
        this.print("glMultiTexCoord4dv(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultiTexCoord4dv(n, dArray);
        this.println("");
    }

    public void glMultiTexCoord4dv(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4dv(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord4dv(n, doubleBuffer);
        this.println("");
    }

    public void glMultiTexCoord4dvARB(int n, double[] dArray) {
        this.printIndent();
        this.print("glMultiTexCoord4dvARB(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glMultiTexCoord4dvARB(n, dArray);
        this.println("");
    }

    public void glMultiTexCoord4dvARB(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4dvARB(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord4dvARB(n, doubleBuffer);
        this.println("");
    }

    public void glMultiTexCoord4f(int n, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glMultiTexCoord4f(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glMultiTexCoord4f(n, f, f2, f3, f4);
        this.println("");
    }

    public void glMultiTexCoord4fARB(int n, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glMultiTexCoord4fARB(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glMultiTexCoord4fARB(n, f, f2, f3, f4);
        this.println("");
    }

    public void glMultiTexCoord4fv(int n, float[] fArray) {
        this.printIndent();
        this.print("glMultiTexCoord4fv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultiTexCoord4fv(n, fArray);
        this.println("");
    }

    public void glMultiTexCoord4fv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4fv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord4fv(n, floatBuffer);
        this.println("");
    }

    public void glMultiTexCoord4fvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glMultiTexCoord4fvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glMultiTexCoord4fvARB(n, fArray);
        this.println("");
    }

    public void glMultiTexCoord4fvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4fvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord4fvARB(n, floatBuffer);
        this.println("");
    }

    public void glMultiTexCoord4hNV(int n, short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glMultiTexCoord4hNV(" + n + "," + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glMultiTexCoord4hNV(n, s, s2, s3, s4);
        this.println("");
    }

    public void glMultiTexCoord4hvNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord4hvNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord4hvNV(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord4hvNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4hvNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord4hvNV(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord4i(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glMultiTexCoord4i(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glMultiTexCoord4i(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glMultiTexCoord4iARB(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glMultiTexCoord4iARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glMultiTexCoord4iARB(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glMultiTexCoord4iv(int n, int[] nArray) {
        this.printIndent();
        this.print("glMultiTexCoord4iv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMultiTexCoord4iv(n, nArray);
        this.println("");
    }

    public void glMultiTexCoord4iv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4iv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord4iv(n, intBuffer);
        this.println("");
    }

    public void glMultiTexCoord4ivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glMultiTexCoord4ivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glMultiTexCoord4ivARB(n, nArray);
        this.println("");
    }

    public void glMultiTexCoord4ivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4ivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord4ivARB(n, intBuffer);
        this.println("");
    }

    public void glMultiTexCoord4s(int n, short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glMultiTexCoord4s(" + n + "," + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glMultiTexCoord4s(n, s, s2, s3, s4);
        this.println("");
    }

    public void glMultiTexCoord4sARB(int n, short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glMultiTexCoord4sARB(" + n + "," + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glMultiTexCoord4sARB(n, s, s2, s3, s4);
        this.println("");
    }

    public void glMultiTexCoord4sv(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord4sv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord4sv(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord4sv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4sv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord4sv(n, shortBuffer);
        this.println("");
    }

    public void glMultiTexCoord4svARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glMultiTexCoord4svARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glMultiTexCoord4svARB(n, sArray);
        this.println("");
    }

    public void glMultiTexCoord4svARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4svARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord4svARB(n, shortBuffer);
        this.println("");
    }

    public int glNewBufferRegion(int n) {
        this.printIndent();
        this.print("glNewBufferRegion(" + n + ")");
        int n2 = this.downstreamGL.glNewBufferRegion(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glNewList(int n, int n2) {
        this.printIndent();
        this.print("glNewList(" + n + "," + n2 + ")");
        this.downstreamGL.glNewList(n, n2);
        this.println("");
    }

    public int glNewObjectBufferATI(int n, boolean[] blArray, int n2) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n + "," + this.dumpArray(blArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glNewObjectBufferATI(n, blArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glNewObjectBufferATI(int n, char[] cArray, int n2) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n + "," + this.dumpArray(cArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glNewObjectBufferATI(n, cArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glNewObjectBufferATI(int n, byte[] byArray, int n2) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n + "," + this.dumpArray(byArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glNewObjectBufferATI(n, byArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glNewObjectBufferATI(int n, short[] sArray, int n2) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n + "," + this.dumpArray(sArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glNewObjectBufferATI(n, sArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glNewObjectBufferATI(int n, int[] nArray, int n2) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n + "," + this.dumpArray(nArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glNewObjectBufferATI(n, nArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glNewObjectBufferATI(int n, long[] lArray, int n2) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n + "," + this.dumpArray(lArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glNewObjectBufferATI(n, lArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glNewObjectBufferATI(int n, float[] fArray, int n2) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n + "," + this.dumpArray(fArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glNewObjectBufferATI(n, fArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glNewObjectBufferATI(int n, double[] dArray, int n2) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n + "," + this.dumpArray(dArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glNewObjectBufferATI(n, dArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    public int glNewObjectBufferATI(int n, Buffer buffer, int n2) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n + "," + buffer + "," + n2 + ")");
        int n3 = this.downstreamGL.glNewObjectBufferATI(n, buffer, n2);
        this.println(" = " + n3);
        return n3;
    }

    public void glNormal3b(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glNormal3b(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glNormal3b(by, by2, by3);
        this.println("");
    }

    public void glNormal3bv(byte[] byArray) {
        this.printIndent();
        this.print("glNormal3bv(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glNormal3bv(byArray);
        this.println("");
    }

    public void glNormal3bv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glNormal3bv(" + byteBuffer + ")");
        this.downstreamGL.glNormal3bv(byteBuffer);
        this.println("");
    }

    public void glNormal3d(double d, double d2, double d3) {
        this.printIndent();
        this.print("glNormal3d(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glNormal3d(d, d2, d3);
        this.println("");
    }

    public void glNormal3dv(double[] dArray) {
        this.printIndent();
        this.print("glNormal3dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glNormal3dv(dArray);
        this.println("");
    }

    public void glNormal3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glNormal3dv(" + doubleBuffer + ")");
        this.downstreamGL.glNormal3dv(doubleBuffer);
        this.println("");
    }

    public void glNormal3f(float f, float f2, float f3) {
        this.printIndent();
        this.print("glNormal3f(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glNormal3f(f, f2, f3);
        this.println("");
    }

    public void glNormal3fVertex3fSUN(float f, float f2, float f3, float f4, float f5, float f6) {
        this.printIndent();
        this.print("glNormal3fVertex3fSUN(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + ")");
        this.downstreamGL.glNormal3fVertex3fSUN(f, f2, f3, f4, f5, f6);
        this.println("");
    }

    public void glNormal3fVertex3fvSUN(float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glNormal3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glNormal3fVertex3fvSUN(fArray, fArray2);
        this.println("");
    }

    public void glNormal3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glNormal3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glNormal3fVertex3fvSUN(floatBuffer, floatBuffer2);
        this.println("");
    }

    public void glNormal3fv(float[] fArray) {
        this.printIndent();
        this.print("glNormal3fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glNormal3fv(fArray);
        this.println("");
    }

    public void glNormal3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glNormal3fv(" + floatBuffer + ")");
        this.downstreamGL.glNormal3fv(floatBuffer);
        this.println("");
    }

    public void glNormal3hNV(short s, short s2, short s3) {
        this.printIndent();
        this.print("glNormal3hNV(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glNormal3hNV(s, s2, s3);
        this.println("");
    }

    public void glNormal3hvNV(short[] sArray) {
        this.printIndent();
        this.print("glNormal3hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glNormal3hvNV(sArray);
        this.println("");
    }

    public void glNormal3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glNormal3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glNormal3hvNV(shortBuffer);
        this.println("");
    }

    public void glNormal3i(int n, int n2, int n3) {
        this.printIndent();
        this.print("glNormal3i(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glNormal3i(n, n2, n3);
        this.println("");
    }

    public void glNormal3iv(int[] nArray) {
        this.printIndent();
        this.print("glNormal3iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glNormal3iv(nArray);
        this.println("");
    }

    public void glNormal3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glNormal3iv(" + intBuffer + ")");
        this.downstreamGL.glNormal3iv(intBuffer);
        this.println("");
    }

    public void glNormal3s(short s, short s2, short s3) {
        this.printIndent();
        this.print("glNormal3s(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glNormal3s(s, s2, s3);
        this.println("");
    }

    public void glNormal3sv(short[] sArray) {
        this.printIndent();
        this.print("glNormal3sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glNormal3sv(sArray);
        this.println("");
    }

    public void glNormal3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glNormal3sv(" + shortBuffer + ")");
        this.downstreamGL.glNormal3sv(shortBuffer);
        this.println("");
    }

    public void glNormalPointer(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glNormalPointer(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glNormalPointer(n, n2, buffer);
        this.println("");
    }

    public void glNormalPointerEXT(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glNormalPointerEXT(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glNormalPointerEXT(n, n2, n3, buffer);
        this.println("");
    }

    public void glNormalPointerListIBM(int n, int n2, Buffer[] bufferArray, int n3) {
        this.printIndent();
        this.print("glNormalPointerListIBM(" + n + "," + n2 + "," + this.dumpArray(bufferArray) + "," + n3 + ")");
        this.downstreamGL.glNormalPointerListIBM(n, n2, bufferArray, n3);
        this.println("");
    }

    public void glNormalPointervINTEL(int n, Buffer[] bufferArray) {
        this.printIndent();
        this.print("glNormalPointervINTEL(" + n + "," + this.dumpArray(bufferArray) + ")");
        this.downstreamGL.glNormalPointervINTEL(n, bufferArray);
        this.println("");
    }

    public void glNormalStream3bATI(int n, byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glNormalStream3bATI(" + n + "," + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glNormalStream3bATI(n, by, by2, by3);
        this.println("");
    }

    public void glNormalStream3bvATI(int n, byte[] byArray) {
        this.printIndent();
        this.print("glNormalStream3bvATI(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glNormalStream3bvATI(n, byArray);
        this.println("");
    }

    public void glNormalStream3bvATI(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glNormalStream3bvATI(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glNormalStream3bvATI(n, byteBuffer);
        this.println("");
    }

    public void glNormalStream3dATI(int n, double d, double d2, double d3) {
        this.printIndent();
        this.print("glNormalStream3dATI(" + n + "," + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glNormalStream3dATI(n, d, d2, d3);
        this.println("");
    }

    public void glNormalStream3dvATI(int n, double[] dArray) {
        this.printIndent();
        this.print("glNormalStream3dvATI(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glNormalStream3dvATI(n, dArray);
        this.println("");
    }

    public void glNormalStream3dvATI(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glNormalStream3dvATI(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glNormalStream3dvATI(n, doubleBuffer);
        this.println("");
    }

    public void glNormalStream3fATI(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glNormalStream3fATI(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glNormalStream3fATI(n, f, f2, f3);
        this.println("");
    }

    public void glNormalStream3fvATI(int n, float[] fArray) {
        this.printIndent();
        this.print("glNormalStream3fvATI(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glNormalStream3fvATI(n, fArray);
        this.println("");
    }

    public void glNormalStream3fvATI(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glNormalStream3fvATI(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glNormalStream3fvATI(n, floatBuffer);
        this.println("");
    }

    public void glNormalStream3iATI(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glNormalStream3iATI(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glNormalStream3iATI(n, n2, n3, n4);
        this.println("");
    }

    public void glNormalStream3ivATI(int n, int[] nArray) {
        this.printIndent();
        this.print("glNormalStream3ivATI(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glNormalStream3ivATI(n, nArray);
        this.println("");
    }

    public void glNormalStream3ivATI(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glNormalStream3ivATI(" + n + "," + intBuffer + ")");
        this.downstreamGL.glNormalStream3ivATI(n, intBuffer);
        this.println("");
    }

    public void glNormalStream3sATI(int n, short s, short s2, short s3) {
        this.printIndent();
        this.print("glNormalStream3sATI(" + n + "," + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glNormalStream3sATI(n, s, s2, s3);
        this.println("");
    }

    public void glNormalStream3svATI(int n, short[] sArray) {
        this.printIndent();
        this.print("glNormalStream3svATI(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glNormalStream3svATI(n, sArray);
        this.println("");
    }

    public void glNormalStream3svATI(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glNormalStream3svATI(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glNormalStream3svATI(n, shortBuffer);
        this.println("");
    }

    public void glOrtho(double d, double d2, double d3, double d4, double d5, double d6) {
        this.printIndent();
        this.print("glOrtho(" + d + "," + d2 + "," + d3 + "," + d4 + "," + d5 + "," + d6 + ")");
        this.downstreamGL.glOrtho(d, d2, d3, d4, d5, d6);
        this.println("");
    }

    public void glPNTrianglesfATI(int n, float f) {
        this.printIndent();
        this.print("glPNTrianglesfATI(" + n + "," + f + ")");
        this.downstreamGL.glPNTrianglesfATI(n, f);
        this.println("");
    }

    public void glPNTrianglesiATI(int n, int n2) {
        this.printIndent();
        this.print("glPNTrianglesiATI(" + n + "," + n2 + ")");
        this.downstreamGL.glPNTrianglesiATI(n, n2);
        this.println("");
    }

    public void glPassTexCoordATI(int n, int n2, int n3) {
        this.printIndent();
        this.print("glPassTexCoordATI(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glPassTexCoordATI(n, n2, n3);
        this.println("");
    }

    public void glPassThrough(float f) {
        this.printIndent();
        this.print("glPassThrough(" + f + ")");
        this.downstreamGL.glPassThrough(f);
        this.println("");
    }

    public void glPixelDataRangeNV(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glPixelDataRangeNV(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glPixelDataRangeNV(n, n2, buffer);
        this.println("");
    }

    public void glPixelMapfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glPixelMapfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glPixelMapfv(n, n2, fArray);
        this.println("");
    }

    public void glPixelMapfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPixelMapfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glPixelMapfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glPixelMapuiv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glPixelMapuiv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glPixelMapuiv(n, n2, nArray);
        this.println("");
    }

    public void glPixelMapuiv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPixelMapuiv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glPixelMapuiv(n, n2, intBuffer);
        this.println("");
    }

    public void glPixelMapusv(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glPixelMapusv(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glPixelMapusv(n, n2, sArray);
        this.println("");
    }

    public void glPixelMapusv(int n, int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glPixelMapusv(" + n + "," + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glPixelMapusv(n, n2, shortBuffer);
        this.println("");
    }

    public void glPixelStoref(int n, float f) {
        this.printIndent();
        this.print("glPixelStoref(" + n + "," + f + ")");
        this.downstreamGL.glPixelStoref(n, f);
        this.println("");
    }

    public void glPixelStorei(int n, int n2) {
        this.printIndent();
        this.print("glPixelStorei(" + n + "," + n2 + ")");
        this.downstreamGL.glPixelStorei(n, n2);
        this.println("");
    }

    public void glPixelTexGenParameterfSGIS(int n, float f) {
        this.printIndent();
        this.print("glPixelTexGenParameterfSGIS(" + n + "," + f + ")");
        this.downstreamGL.glPixelTexGenParameterfSGIS(n, f);
        this.println("");
    }

    public void glPixelTexGenParameterfvSGIS(int n, float[] fArray) {
        this.printIndent();
        this.print("glPixelTexGenParameterfvSGIS(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glPixelTexGenParameterfvSGIS(n, fArray);
        this.println("");
    }

    public void glPixelTexGenParameterfvSGIS(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPixelTexGenParameterfvSGIS(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glPixelTexGenParameterfvSGIS(n, floatBuffer);
        this.println("");
    }

    public void glPixelTexGenParameteriSGIS(int n, int n2) {
        this.printIndent();
        this.print("glPixelTexGenParameteriSGIS(" + n + "," + n2 + ")");
        this.downstreamGL.glPixelTexGenParameteriSGIS(n, n2);
        this.println("");
    }

    public void glPixelTexGenParameterivSGIS(int n, int[] nArray) {
        this.printIndent();
        this.print("glPixelTexGenParameterivSGIS(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glPixelTexGenParameterivSGIS(n, nArray);
        this.println("");
    }

    public void glPixelTexGenParameterivSGIS(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPixelTexGenParameterivSGIS(" + n + "," + intBuffer + ")");
        this.downstreamGL.glPixelTexGenParameterivSGIS(n, intBuffer);
        this.println("");
    }

    public void glPixelTexGenSGIX(int n) {
        this.printIndent();
        this.print("glPixelTexGenSGIX(" + n + ")");
        this.downstreamGL.glPixelTexGenSGIX(n);
        this.println("");
    }

    public void glPixelTransferf(int n, float f) {
        this.printIndent();
        this.print("glPixelTransferf(" + n + "," + f + ")");
        this.downstreamGL.glPixelTransferf(n, f);
        this.println("");
    }

    public void glPixelTransferi(int n, int n2) {
        this.printIndent();
        this.print("glPixelTransferi(" + n + "," + n2 + ")");
        this.downstreamGL.glPixelTransferi(n, n2);
        this.println("");
    }

    public void glPixelTransformParameterfEXT(int n, int n2, float f) {
        this.printIndent();
        this.print("glPixelTransformParameterfEXT(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glPixelTransformParameterfEXT(n, n2, f);
        this.println("");
    }

    public void glPixelTransformParameterfvEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glPixelTransformParameterfvEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glPixelTransformParameterfvEXT(n, n2, fArray);
        this.println("");
    }

    public void glPixelTransformParameterfvEXT(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPixelTransformParameterfvEXT(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glPixelTransformParameterfvEXT(n, n2, floatBuffer);
        this.println("");
    }

    public void glPixelTransformParameteriEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glPixelTransformParameteriEXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glPixelTransformParameteriEXT(n, n2, n3);
        this.println("");
    }

    public void glPixelTransformParameterivEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glPixelTransformParameterivEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glPixelTransformParameterivEXT(n, n2, nArray);
        this.println("");
    }

    public void glPixelTransformParameterivEXT(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPixelTransformParameterivEXT(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glPixelTransformParameterivEXT(n, n2, intBuffer);
        this.println("");
    }

    public void glPixelZoom(float f, float f2) {
        this.printIndent();
        this.print("glPixelZoom(" + f + "," + f2 + ")");
        this.downstreamGL.glPixelZoom(f, f2);
        this.println("");
    }

    public void glPointParameterf(int n, float f) {
        this.printIndent();
        this.print("glPointParameterf(" + n + "," + f + ")");
        this.downstreamGL.glPointParameterf(n, f);
        this.println("");
    }

    public void glPointParameterfARB(int n, float f) {
        this.printIndent();
        this.print("glPointParameterfARB(" + n + "," + f + ")");
        this.downstreamGL.glPointParameterfARB(n, f);
        this.println("");
    }

    public void glPointParameterfEXT(int n, float f) {
        this.printIndent();
        this.print("glPointParameterfEXT(" + n + "," + f + ")");
        this.downstreamGL.glPointParameterfEXT(n, f);
        this.println("");
    }

    public void glPointParameterfSGIS(int n, float f) {
        this.printIndent();
        this.print("glPointParameterfSGIS(" + n + "," + f + ")");
        this.downstreamGL.glPointParameterfSGIS(n, f);
        this.println("");
    }

    public void glPointParameterfv(int n, float[] fArray) {
        this.printIndent();
        this.print("glPointParameterfv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glPointParameterfv(n, fArray);
        this.println("");
    }

    public void glPointParameterfv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPointParameterfv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glPointParameterfv(n, floatBuffer);
        this.println("");
    }

    public void glPointParameterfvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glPointParameterfvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glPointParameterfvARB(n, fArray);
        this.println("");
    }

    public void glPointParameterfvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPointParameterfvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glPointParameterfvARB(n, floatBuffer);
        this.println("");
    }

    public void glPointParameterfvEXT(int n, float[] fArray) {
        this.printIndent();
        this.print("glPointParameterfvEXT(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glPointParameterfvEXT(n, fArray);
        this.println("");
    }

    public void glPointParameterfvEXT(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPointParameterfvEXT(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glPointParameterfvEXT(n, floatBuffer);
        this.println("");
    }

    public void glPointParameterfvSGIS(int n, float[] fArray) {
        this.printIndent();
        this.print("glPointParameterfvSGIS(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glPointParameterfvSGIS(n, fArray);
        this.println("");
    }

    public void glPointParameterfvSGIS(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPointParameterfvSGIS(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glPointParameterfvSGIS(n, floatBuffer);
        this.println("");
    }

    public void glPointParameteri(int n, int n2) {
        this.printIndent();
        this.print("glPointParameteri(" + n + "," + n2 + ")");
        this.downstreamGL.glPointParameteri(n, n2);
        this.println("");
    }

    public void glPointParameteriNV(int n, int n2) {
        this.printIndent();
        this.print("glPointParameteriNV(" + n + "," + n2 + ")");
        this.downstreamGL.glPointParameteriNV(n, n2);
        this.println("");
    }

    public void glPointParameteriv(int n, int[] nArray) {
        this.printIndent();
        this.print("glPointParameteriv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glPointParameteriv(n, nArray);
        this.println("");
    }

    public void glPointParameteriv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPointParameteriv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glPointParameteriv(n, intBuffer);
        this.println("");
    }

    public void glPointParameterivNV(int n, int[] nArray) {
        this.printIndent();
        this.print("glPointParameterivNV(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glPointParameterivNV(n, nArray);
        this.println("");
    }

    public void glPointParameterivNV(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPointParameterivNV(" + n + "," + intBuffer + ")");
        this.downstreamGL.glPointParameterivNV(n, intBuffer);
        this.println("");
    }

    public void glPointSize(float f) {
        this.printIndent();
        this.print("glPointSize(" + f + ")");
        this.downstreamGL.glPointSize(f);
        this.println("");
    }

    public int glPollAsyncSGIX(int[] nArray) {
        this.printIndent();
        this.print("glPollAsyncSGIX(" + this.dumpArray(nArray) + ")");
        int n = this.downstreamGL.glPollAsyncSGIX(nArray);
        this.println(" = " + n);
        return n;
    }

    public int glPollAsyncSGIX(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPollAsyncSGIX(" + intBuffer + ")");
        int n = this.downstreamGL.glPollAsyncSGIX(intBuffer);
        this.println(" = " + n);
        return n;
    }

    public int glPollInstrumentsSGIX(int[] nArray) {
        this.printIndent();
        this.print("glPollInstrumentsSGIX(" + this.dumpArray(nArray) + ")");
        int n = this.downstreamGL.glPollInstrumentsSGIX(nArray);
        this.println(" = " + n);
        return n;
    }

    public int glPollInstrumentsSGIX(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPollInstrumentsSGIX(" + intBuffer + ")");
        int n = this.downstreamGL.glPollInstrumentsSGIX(intBuffer);
        this.println(" = " + n);
        return n;
    }

    public void glPolygonMode(int n, int n2) {
        this.printIndent();
        this.print("glPolygonMode(" + n + "," + n2 + ")");
        this.downstreamGL.glPolygonMode(n, n2);
        this.println("");
    }

    public void glPolygonOffset(float f, float f2) {
        this.printIndent();
        this.print("glPolygonOffset(" + f + "," + f2 + ")");
        this.downstreamGL.glPolygonOffset(f, f2);
        this.println("");
    }

    public void glPolygonOffsetEXT(float f, float f2) {
        this.printIndent();
        this.print("glPolygonOffsetEXT(" + f + "," + f2 + ")");
        this.downstreamGL.glPolygonOffsetEXT(f, f2);
        this.println("");
    }

    public void glPolygonStipple(byte[] byArray) {
        this.printIndent();
        this.print("glPolygonStipple(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glPolygonStipple(byArray);
        this.println("");
    }

    public void glPolygonStipple(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glPolygonStipple(" + byteBuffer + ")");
        this.downstreamGL.glPolygonStipple(byteBuffer);
        this.println("");
    }

    public void glPopAttrib() {
        this.printIndent();
        this.print("glPopAttrib()");
        this.downstreamGL.glPopAttrib();
        this.println("");
    }

    public void glPopClientAttrib() {
        this.printIndent();
        this.print("glPopClientAttrib()");
        this.downstreamGL.glPopClientAttrib();
        this.println("");
    }

    public void glPopMatrix() {
        this.printIndent();
        this.print("glPopMatrix()");
        this.downstreamGL.glPopMatrix();
        this.println("");
    }

    public void glPopName() {
        this.printIndent();
        this.print("glPopName()");
        this.downstreamGL.glPopName();
        this.println("");
    }

    public void glPrimitiveRestartIndexNV(int n) {
        this.printIndent();
        this.print("glPrimitiveRestartIndexNV(" + n + ")");
        this.downstreamGL.glPrimitiveRestartIndexNV(n);
        this.println("");
    }

    public void glPrimitiveRestartNV() {
        this.printIndent();
        this.print("glPrimitiveRestartNV()");
        this.downstreamGL.glPrimitiveRestartNV();
        this.println("");
    }

    public void glPrioritizeTextures(int n, int[] nArray, float[] fArray) {
        this.printIndent();
        this.print("glPrioritizeTextures(" + n + "," + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glPrioritizeTextures(n, nArray, fArray);
        this.println("");
    }

    public void glPrioritizeTextures(int n, IntBuffer intBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPrioritizeTextures(" + n + "," + intBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glPrioritizeTextures(n, intBuffer, floatBuffer);
        this.println("");
    }

    public void glPrioritizeTexturesEXT(int n, int[] nArray, float[] fArray) {
        this.printIndent();
        this.print("glPrioritizeTexturesEXT(" + n + "," + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glPrioritizeTexturesEXT(n, nArray, fArray);
        this.println("");
    }

    public void glPrioritizeTexturesEXT(int n, IntBuffer intBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPrioritizeTexturesEXT(" + n + "," + intBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glPrioritizeTexturesEXT(n, intBuffer, floatBuffer);
        this.println("");
    }

    public void glProgramEnvParameter4dARB(int n, int n2, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glProgramEnvParameter4dARB(" + n + "," + n2 + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glProgramEnvParameter4dARB(n, n2, d, d2, d3, d4);
        this.println("");
    }

    public void glProgramEnvParameter4dvARB(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glProgramEnvParameter4dvARB(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glProgramEnvParameter4dvARB(n, n2, dArray);
        this.println("");
    }

    public void glProgramEnvParameter4dvARB(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramEnvParameter4dvARB(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramEnvParameter4dvARB(n, n2, doubleBuffer);
        this.println("");
    }

    public void glProgramEnvParameter4fARB(int n, int n2, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glProgramEnvParameter4fARB(" + n + "," + n2 + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glProgramEnvParameter4fARB(n, n2, f, f2, f3, f4);
        this.println("");
    }

    public void glProgramEnvParameter4fvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glProgramEnvParameter4fvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glProgramEnvParameter4fvARB(n, n2, fArray);
        this.println("");
    }

    public void glProgramEnvParameter4fvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramEnvParameter4fvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramEnvParameter4fvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glProgramLocalParameter4dARB(int n, int n2, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glProgramLocalParameter4dARB(" + n + "," + n2 + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glProgramLocalParameter4dARB(n, n2, d, d2, d3, d4);
        this.println("");
    }

    public void glProgramLocalParameter4dvARB(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glProgramLocalParameter4dvARB(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glProgramLocalParameter4dvARB(n, n2, dArray);
        this.println("");
    }

    public void glProgramLocalParameter4dvARB(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramLocalParameter4dvARB(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramLocalParameter4dvARB(n, n2, doubleBuffer);
        this.println("");
    }

    public void glProgramLocalParameter4fARB(int n, int n2, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glProgramLocalParameter4fARB(" + n + "," + n2 + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glProgramLocalParameter4fARB(n, n2, f, f2, f3, f4);
        this.println("");
    }

    public void glProgramLocalParameter4fvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glProgramLocalParameter4fvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glProgramLocalParameter4fvARB(n, n2, fArray);
        this.println("");
    }

    public void glProgramLocalParameter4fvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramLocalParameter4fvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramLocalParameter4fvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glProgramNamedParameter4dNV(int n, int n2, String string, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glProgramNamedParameter4dNV(" + n + "," + n2 + "," + string + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glProgramNamedParameter4dNV(n, n2, string, d, d2, d3, d4);
        this.println("");
    }

    public void glProgramNamedParameter4dvNV(int n, int n2, String string, double[] dArray) {
        this.printIndent();
        this.print("glProgramNamedParameter4dvNV(" + n + "," + n2 + "," + string + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glProgramNamedParameter4dvNV(n, n2, string, dArray);
        this.println("");
    }

    public void glProgramNamedParameter4dvNV(int n, int n2, String string, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramNamedParameter4dvNV(" + n + "," + n2 + "," + string + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramNamedParameter4dvNV(n, n2, string, doubleBuffer);
        this.println("");
    }

    public void glProgramNamedParameter4fNV(int n, int n2, String string, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glProgramNamedParameter4fNV(" + n + "," + n2 + "," + string + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glProgramNamedParameter4fNV(n, n2, string, f, f2, f3, f4);
        this.println("");
    }

    public void glProgramNamedParameter4fvNV(int n, int n2, String string, float[] fArray) {
        this.printIndent();
        this.print("glProgramNamedParameter4fvNV(" + n + "," + n2 + "," + string + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glProgramNamedParameter4fvNV(n, n2, string, fArray);
        this.println("");
    }

    public void glProgramNamedParameter4fvNV(int n, int n2, String string, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramNamedParameter4fvNV(" + n + "," + n2 + "," + string + "," + floatBuffer + ")");
        this.downstreamGL.glProgramNamedParameter4fvNV(n, n2, string, floatBuffer);
        this.println("");
    }

    public void glProgramParameter4dNV(int n, int n2, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glProgramParameter4dNV(" + n + "," + n2 + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glProgramParameter4dNV(n, n2, d, d2, d3, d4);
        this.println("");
    }

    public void glProgramParameter4dvNV(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glProgramParameter4dvNV(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glProgramParameter4dvNV(n, n2, dArray);
        this.println("");
    }

    public void glProgramParameter4dvNV(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramParameter4dvNV(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramParameter4dvNV(n, n2, doubleBuffer);
        this.println("");
    }

    public void glProgramParameter4fNV(int n, int n2, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glProgramParameter4fNV(" + n + "," + n2 + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glProgramParameter4fNV(n, n2, f, f2, f3, f4);
        this.println("");
    }

    public void glProgramParameter4fvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glProgramParameter4fvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glProgramParameter4fvNV(n, n2, fArray);
        this.println("");
    }

    public void glProgramParameter4fvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramParameter4fvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramParameter4fvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glProgramParameters4dvNV(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glProgramParameters4dvNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glProgramParameters4dvNV(n, n2, n3, dArray);
        this.println("");
    }

    public void glProgramParameters4dvNV(int n, int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramParameters4dvNV(" + n + "," + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramParameters4dvNV(n, n2, n3, doubleBuffer);
        this.println("");
    }

    public void glProgramParameters4fvNV(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glProgramParameters4fvNV(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glProgramParameters4fvNV(n, n2, n3, fArray);
        this.println("");
    }

    public void glProgramParameters4fvNV(int n, int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramParameters4fvNV(" + n + "," + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramParameters4fvNV(n, n2, n3, floatBuffer);
        this.println("");
    }

    public void glProgramStringARB(int n, int n2, int n3, String string) {
        this.printIndent();
        this.print("glProgramStringARB(" + n + "," + n2 + "," + n3 + "," + string + ")");
        this.downstreamGL.glProgramStringARB(n, n2, n3, string);
        this.println("");
    }

    public void glPushAttrib(int n) {
        this.printIndent();
        this.print("glPushAttrib(" + n + ")");
        this.downstreamGL.glPushAttrib(n);
        this.println("");
    }

    public void glPushClientAttrib(int n) {
        this.printIndent();
        this.print("glPushClientAttrib(" + n + ")");
        this.downstreamGL.glPushClientAttrib(n);
        this.println("");
    }

    public void glPushMatrix() {
        this.printIndent();
        this.print("glPushMatrix()");
        this.downstreamGL.glPushMatrix();
        this.println("");
    }

    public void glPushName(int n) {
        this.printIndent();
        this.print("glPushName(" + n + ")");
        this.downstreamGL.glPushName(n);
        this.println("");
    }

    public void glRasterPos2d(double d, double d2) {
        this.printIndent();
        this.print("glRasterPos2d(" + d + "," + d2 + ")");
        this.downstreamGL.glRasterPos2d(d, d2);
        this.println("");
    }

    public void glRasterPos2dv(double[] dArray) {
        this.printIndent();
        this.print("glRasterPos2dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glRasterPos2dv(dArray);
        this.println("");
    }

    public void glRasterPos2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glRasterPos2dv(" + doubleBuffer + ")");
        this.downstreamGL.glRasterPos2dv(doubleBuffer);
        this.println("");
    }

    public void glRasterPos2f(float f, float f2) {
        this.printIndent();
        this.print("glRasterPos2f(" + f + "," + f2 + ")");
        this.downstreamGL.glRasterPos2f(f, f2);
        this.println("");
    }

    public void glRasterPos2fv(float[] fArray) {
        this.printIndent();
        this.print("glRasterPos2fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glRasterPos2fv(fArray);
        this.println("");
    }

    public void glRasterPos2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glRasterPos2fv(" + floatBuffer + ")");
        this.downstreamGL.glRasterPos2fv(floatBuffer);
        this.println("");
    }

    public void glRasterPos2i(int n, int n2) {
        this.printIndent();
        this.print("glRasterPos2i(" + n + "," + n2 + ")");
        this.downstreamGL.glRasterPos2i(n, n2);
        this.println("");
    }

    public void glRasterPos2iv(int[] nArray) {
        this.printIndent();
        this.print("glRasterPos2iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glRasterPos2iv(nArray);
        this.println("");
    }

    public void glRasterPos2iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glRasterPos2iv(" + intBuffer + ")");
        this.downstreamGL.glRasterPos2iv(intBuffer);
        this.println("");
    }

    public void glRasterPos2s(short s, short s2) {
        this.printIndent();
        this.print("glRasterPos2s(" + s + "," + s2 + ")");
        this.downstreamGL.glRasterPos2s(s, s2);
        this.println("");
    }

    public void glRasterPos2sv(short[] sArray) {
        this.printIndent();
        this.print("glRasterPos2sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glRasterPos2sv(sArray);
        this.println("");
    }

    public void glRasterPos2sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glRasterPos2sv(" + shortBuffer + ")");
        this.downstreamGL.glRasterPos2sv(shortBuffer);
        this.println("");
    }

    public void glRasterPos3d(double d, double d2, double d3) {
        this.printIndent();
        this.print("glRasterPos3d(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glRasterPos3d(d, d2, d3);
        this.println("");
    }

    public void glRasterPos3dv(double[] dArray) {
        this.printIndent();
        this.print("glRasterPos3dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glRasterPos3dv(dArray);
        this.println("");
    }

    public void glRasterPos3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glRasterPos3dv(" + doubleBuffer + ")");
        this.downstreamGL.glRasterPos3dv(doubleBuffer);
        this.println("");
    }

    public void glRasterPos3f(float f, float f2, float f3) {
        this.printIndent();
        this.print("glRasterPos3f(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glRasterPos3f(f, f2, f3);
        this.println("");
    }

    public void glRasterPos3fv(float[] fArray) {
        this.printIndent();
        this.print("glRasterPos3fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glRasterPos3fv(fArray);
        this.println("");
    }

    public void glRasterPos3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glRasterPos3fv(" + floatBuffer + ")");
        this.downstreamGL.glRasterPos3fv(floatBuffer);
        this.println("");
    }

    public void glRasterPos3i(int n, int n2, int n3) {
        this.printIndent();
        this.print("glRasterPos3i(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glRasterPos3i(n, n2, n3);
        this.println("");
    }

    public void glRasterPos3iv(int[] nArray) {
        this.printIndent();
        this.print("glRasterPos3iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glRasterPos3iv(nArray);
        this.println("");
    }

    public void glRasterPos3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glRasterPos3iv(" + intBuffer + ")");
        this.downstreamGL.glRasterPos3iv(intBuffer);
        this.println("");
    }

    public void glRasterPos3s(short s, short s2, short s3) {
        this.printIndent();
        this.print("glRasterPos3s(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glRasterPos3s(s, s2, s3);
        this.println("");
    }

    public void glRasterPos3sv(short[] sArray) {
        this.printIndent();
        this.print("glRasterPos3sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glRasterPos3sv(sArray);
        this.println("");
    }

    public void glRasterPos3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glRasterPos3sv(" + shortBuffer + ")");
        this.downstreamGL.glRasterPos3sv(shortBuffer);
        this.println("");
    }

    public void glRasterPos4d(double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glRasterPos4d(" + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glRasterPos4d(d, d2, d3, d4);
        this.println("");
    }

    public void glRasterPos4dv(double[] dArray) {
        this.printIndent();
        this.print("glRasterPos4dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glRasterPos4dv(dArray);
        this.println("");
    }

    public void glRasterPos4dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glRasterPos4dv(" + doubleBuffer + ")");
        this.downstreamGL.glRasterPos4dv(doubleBuffer);
        this.println("");
    }

    public void glRasterPos4f(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glRasterPos4f(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glRasterPos4f(f, f2, f3, f4);
        this.println("");
    }

    public void glRasterPos4fv(float[] fArray) {
        this.printIndent();
        this.print("glRasterPos4fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glRasterPos4fv(fArray);
        this.println("");
    }

    public void glRasterPos4fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glRasterPos4fv(" + floatBuffer + ")");
        this.downstreamGL.glRasterPos4fv(floatBuffer);
        this.println("");
    }

    public void glRasterPos4i(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glRasterPos4i(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glRasterPos4i(n, n2, n3, n4);
        this.println("");
    }

    public void glRasterPos4iv(int[] nArray) {
        this.printIndent();
        this.print("glRasterPos4iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glRasterPos4iv(nArray);
        this.println("");
    }

    public void glRasterPos4iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glRasterPos4iv(" + intBuffer + ")");
        this.downstreamGL.glRasterPos4iv(intBuffer);
        this.println("");
    }

    public void glRasterPos4s(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glRasterPos4s(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glRasterPos4s(s, s2, s3, s4);
        this.println("");
    }

    public void glRasterPos4sv(short[] sArray) {
        this.printIndent();
        this.print("glRasterPos4sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glRasterPos4sv(sArray);
        this.println("");
    }

    public void glRasterPos4sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glRasterPos4sv(" + shortBuffer + ")");
        this.downstreamGL.glRasterPos4sv(shortBuffer);
        this.println("");
    }

    public void glReadBuffer(int n) {
        this.printIndent();
        this.print("glReadBuffer(" + n + ")");
        this.downstreamGL.glReadBuffer(n);
        this.println("");
    }

    public void glReadBufferRegion(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glReadBufferRegion(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glReadBufferRegion(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glReadInstrumentsSGIX(int n) {
        this.printIndent();
        this.print("glReadInstrumentsSGIX(" + n + ")");
        this.downstreamGL.glReadInstrumentsSGIX(n);
        this.println("");
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray) {
        this.printIndent();
        this.print("glReadPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glReadPixels(n, n2, n3, n4, n5, n6, blArray);
        this.println("");
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray) {
        this.printIndent();
        this.print("glReadPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glReadPixels(n, n2, n3, n4, n5, n6, cArray);
        this.println("");
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.printIndent();
        this.print("glReadPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glReadPixels(n, n2, n3, n4, n5, n6, byArray);
        this.println("");
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        this.printIndent();
        this.print("glReadPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glReadPixels(n, n2, n3, n4, n5, n6, sArray);
        this.println("");
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.printIndent();
        this.print("glReadPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glReadPixels(n, n2, n3, n4, n5, n6, nArray);
        this.println("");
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray) {
        this.printIndent();
        this.print("glReadPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glReadPixels(n, n2, n3, n4, n5, n6, lArray);
        this.println("");
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glReadPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glReadPixels(n, n2, n3, n4, n5, n6, fArray);
        this.println("");
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glReadPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glReadPixels(n, n2, n3, n4, n5, n6, dArray);
        this.println("");
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glReadPixels(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glReadPixels(n, n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    public void glRectd(double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glRectd(" + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glRectd(d, d2, d3, d4);
        this.println("");
    }

    public void glRectdv(double[] dArray, double[] dArray2) {
        this.printIndent();
        this.print("glRectdv(" + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + ")");
        this.downstreamGL.glRectdv(dArray, dArray2);
        this.println("");
    }

    public void glRectdv(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        this.printIndent();
        this.print("glRectdv(" + doubleBuffer + "," + doubleBuffer2 + ")");
        this.downstreamGL.glRectdv(doubleBuffer, doubleBuffer2);
        this.println("");
    }

    public void glRectf(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glRectf(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glRectf(f, f2, f3, f4);
        this.println("");
    }

    public void glRectfv(float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glRectfv(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glRectfv(fArray, fArray2);
        this.println("");
    }

    public void glRectfv(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glRectfv(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glRectfv(floatBuffer, floatBuffer2);
        this.println("");
    }

    public void glRecti(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glRecti(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glRecti(n, n2, n3, n4);
        this.println("");
    }

    public void glRectiv(int[] nArray, int[] nArray2) {
        this.printIndent();
        this.print("glRectiv(" + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + ")");
        this.downstreamGL.glRectiv(nArray, nArray2);
        this.println("");
    }

    public void glRectiv(IntBuffer intBuffer, IntBuffer intBuffer2) {
        this.printIndent();
        this.print("glRectiv(" + intBuffer + "," + intBuffer2 + ")");
        this.downstreamGL.glRectiv(intBuffer, intBuffer2);
        this.println("");
    }

    public void glRects(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glRects(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glRects(s, s2, s3, s4);
        this.println("");
    }

    public void glRectsv(short[] sArray, short[] sArray2) {
        this.printIndent();
        this.print("glRectsv(" + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + ")");
        this.downstreamGL.glRectsv(sArray, sArray2);
        this.println("");
    }

    public void glRectsv(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        this.printIndent();
        this.print("glRectsv(" + shortBuffer + "," + shortBuffer2 + ")");
        this.downstreamGL.glRectsv(shortBuffer, shortBuffer2);
        this.println("");
    }

    public void glReferencePlaneSGIX(double[] dArray) {
        this.printIndent();
        this.print("glReferencePlaneSGIX(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glReferencePlaneSGIX(dArray);
        this.println("");
    }

    public void glReferencePlaneSGIX(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glReferencePlaneSGIX(" + doubleBuffer + ")");
        this.downstreamGL.glReferencePlaneSGIX(doubleBuffer);
        this.println("");
    }

    public int glRenderMode(int n) {
        this.printIndent();
        this.print("glRenderMode(" + n + ")");
        int n2 = this.downstreamGL.glRenderMode(n);
        this.println(" = " + n2);
        return n2;
    }

    public void glRenderbufferStorageEXT(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glRenderbufferStorageEXT(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glRenderbufferStorageEXT(n, n2, n3, n4);
        this.println("");
    }

    public void glReplacementCodePointerSUN(int n, int n2, Buffer[] bufferArray) {
        this.printIndent();
        this.print("glReplacementCodePointerSUN(" + n + "," + n2 + "," + this.dumpArray(bufferArray) + ")");
        this.downstreamGL.glReplacementCodePointerSUN(n, n2, bufferArray);
        this.println("");
    }

    public void glReplacementCodeubSUN(byte by) {
        this.printIndent();
        this.print("glReplacementCodeubSUN(" + by + ")");
        this.downstreamGL.glReplacementCodeubSUN(by);
        this.println("");
    }

    public void glReplacementCodeubvSUN(byte[] byArray) {
        this.printIndent();
        this.print("glReplacementCodeubvSUN(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glReplacementCodeubvSUN(byArray);
        this.println("");
    }

    public void glReplacementCodeubvSUN(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glReplacementCodeubvSUN(" + byteBuffer + ")");
        this.downstreamGL.glReplacementCodeubvSUN(byteBuffer);
        this.println("");
    }

    public void glReplacementCodeuiColor3fVertex3fSUN(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        this.printIndent();
        this.print("glReplacementCodeuiColor3fVertex3fSUN(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + ")");
        this.downstreamGL.glReplacementCodeuiColor3fVertex3fSUN(n, f, f2, f3, f4, f5, f6);
        this.println("");
    }

    public void glReplacementCodeuiColor3fVertex3fvSUN(int[] nArray, float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glReplacementCodeuiColor3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glReplacementCodeuiColor3fVertex3fvSUN(nArray, fArray, fArray2);
        this.println("");
    }

    public void glReplacementCodeuiColor3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glReplacementCodeuiColor3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glReplacementCodeuiColor3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2);
        this.println("");
    }

    public void glReplacementCodeuiColor4fNormal3fVertex3fSUN(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4fNormal3fVertex3fSUN(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + ")");
        this.downstreamGL.glReplacementCodeuiColor4fNormal3fVertex3fSUN(n, f, f2, f3, f4, f5, f6, f7, f8, f9, f10);
        this.println("");
    }

    public void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(int[] nArray, float[] fArray, float[] fArray2, float[] fArray3) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4fNormal3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + ")");
        this.downstreamGL.glReplacementCodeuiColor4fNormal3fVertex3fvSUN(nArray, fArray, fArray2, fArray3);
        this.println("");
    }

    public void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4fNormal3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glReplacementCodeuiColor4fNormal3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    public void glReplacementCodeuiColor4ubVertex3fSUN(int n, byte by, byte by2, byte by3, byte by4, float f, float f2, float f3) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4ubVertex3fSUN(" + n + "," + by + "," + by2 + "," + by3 + "," + by4 + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glReplacementCodeuiColor4ubVertex3fSUN(n, by, by2, by3, by4, f, f2, f3);
        this.println("");
    }

    public void glReplacementCodeuiColor4ubVertex3fvSUN(int[] nArray, byte[] byArray, float[] fArray) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4ubVertex3fvSUN(" + this.dumpArray(nArray) + "," + this.dumpArray(byArray) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glReplacementCodeuiColor4ubVertex3fvSUN(nArray, byArray, fArray);
        this.println("");
    }

    public void glReplacementCodeuiColor4ubVertex3fvSUN(IntBuffer intBuffer, ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4ubVertex3fvSUN(" + intBuffer + "," + byteBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glReplacementCodeuiColor4ubVertex3fvSUN(intBuffer, byteBuffer, floatBuffer);
        this.println("");
    }

    public void glReplacementCodeuiNormal3fVertex3fSUN(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        this.printIndent();
        this.print("glReplacementCodeuiNormal3fVertex3fSUN(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + ")");
        this.downstreamGL.glReplacementCodeuiNormal3fVertex3fSUN(n, f, f2, f3, f4, f5, f6);
        this.println("");
    }

    public void glReplacementCodeuiNormal3fVertex3fvSUN(int[] nArray, float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glReplacementCodeuiNormal3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glReplacementCodeuiNormal3fVertex3fvSUN(nArray, fArray, fArray2);
        this.println("");
    }

    public void glReplacementCodeuiNormal3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glReplacementCodeuiNormal3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glReplacementCodeuiNormal3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2);
        this.println("");
    }

    public void glReplacementCodeuiSUN(int n) {
        this.printIndent();
        this.print("glReplacementCodeuiSUN(" + n + ")");
        this.downstreamGL.glReplacementCodeuiSUN(n);
        this.println("");
    }

    public void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + "," + f11 + "," + f12 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(n, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        this.println("");
    }

    public void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(int[] nArray, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + "," + this.dumpArray(fArray4) + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(nArray, fArray, fArray2, fArray3, fArray4);
        this.println("");
    }

    public void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + "," + floatBuffer4 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.println("");
    }

    public void glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(n, f, f2, f3, f4, f5, f6, f7, f8);
        this.println("");
    }

    public void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(int[] nArray, float[] fArray, float[] fArray2, float[] fArray3) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(nArray, fArray, fArray2, fArray3);
        this.println("");
    }

    public void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    public void glReplacementCodeuiTexCoord2fVertex3fSUN(int n, float f, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fVertex3fSUN(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fVertex3fSUN(n, f, f2, f3, f4, f5);
        this.println("");
    }

    public void glReplacementCodeuiTexCoord2fVertex3fvSUN(int[] nArray, float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fVertex3fvSUN(" + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fVertex3fvSUN(nArray, fArray, fArray2);
        this.println("");
    }

    public void glReplacementCodeuiTexCoord2fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2);
        this.println("");
    }

    public void glReplacementCodeuiVertex3fSUN(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glReplacementCodeuiVertex3fSUN(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glReplacementCodeuiVertex3fSUN(n, f, f2, f3);
        this.println("");
    }

    public void glReplacementCodeuiVertex3fvSUN(int[] nArray, float[] fArray) {
        this.printIndent();
        this.print("glReplacementCodeuiVertex3fvSUN(" + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glReplacementCodeuiVertex3fvSUN(nArray, fArray);
        this.println("");
    }

    public void glReplacementCodeuiVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glReplacementCodeuiVertex3fvSUN(" + intBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glReplacementCodeuiVertex3fvSUN(intBuffer, floatBuffer);
        this.println("");
    }

    public void glReplacementCodeuivSUN(int[] nArray) {
        this.printIndent();
        this.print("glReplacementCodeuivSUN(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glReplacementCodeuivSUN(nArray);
        this.println("");
    }

    public void glReplacementCodeuivSUN(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glReplacementCodeuivSUN(" + intBuffer + ")");
        this.downstreamGL.glReplacementCodeuivSUN(intBuffer);
        this.println("");
    }

    public void glReplacementCodeusSUN(short s) {
        this.printIndent();
        this.print("glReplacementCodeusSUN(" + s + ")");
        this.downstreamGL.glReplacementCodeusSUN(s);
        this.println("");
    }

    public void glReplacementCodeusvSUN(short[] sArray) {
        this.printIndent();
        this.print("glReplacementCodeusvSUN(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glReplacementCodeusvSUN(sArray);
        this.println("");
    }

    public void glReplacementCodeusvSUN(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glReplacementCodeusvSUN(" + shortBuffer + ")");
        this.downstreamGL.glReplacementCodeusvSUN(shortBuffer);
        this.println("");
    }

    public void glRequestResidentProgramsNV(int n, int[] nArray) {
        this.printIndent();
        this.print("glRequestResidentProgramsNV(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glRequestResidentProgramsNV(n, nArray);
        this.println("");
    }

    public void glRequestResidentProgramsNV(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glRequestResidentProgramsNV(" + n + "," + intBuffer + ")");
        this.downstreamGL.glRequestResidentProgramsNV(n, intBuffer);
        this.println("");
    }

    public void glResetHistogram(int n) {
        this.printIndent();
        this.print("glResetHistogram(" + n + ")");
        this.downstreamGL.glResetHistogram(n);
        this.println("");
    }

    public void glResetHistogramEXT(int n) {
        this.printIndent();
        this.print("glResetHistogramEXT(" + n + ")");
        this.downstreamGL.glResetHistogramEXT(n);
        this.println("");
    }

    public void glResetMinmax(int n) {
        this.printIndent();
        this.print("glResetMinmax(" + n + ")");
        this.downstreamGL.glResetMinmax(n);
        this.println("");
    }

    public void glResetMinmaxEXT(int n) {
        this.printIndent();
        this.print("glResetMinmaxEXT(" + n + ")");
        this.downstreamGL.glResetMinmaxEXT(n);
        this.println("");
    }

    public void glResizeBuffersMESA() {
        this.printIndent();
        this.print("glResizeBuffersMESA()");
        this.downstreamGL.glResizeBuffersMESA();
        this.println("");
    }

    public void glRotated(double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glRotated(" + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glRotated(d, d2, d3, d4);
        this.println("");
    }

    public void glRotatef(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glRotatef(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glRotatef(f, f2, f3, f4);
        this.println("");
    }

    public void glSampleCoverage(float f, boolean bl) {
        this.printIndent();
        this.print("glSampleCoverage(" + f + "," + bl + ")");
        this.downstreamGL.glSampleCoverage(f, bl);
        this.println("");
    }

    public void glSampleCoverageARB(float f, boolean bl) {
        this.printIndent();
        this.print("glSampleCoverageARB(" + f + "," + bl + ")");
        this.downstreamGL.glSampleCoverageARB(f, bl);
        this.println("");
    }

    public void glSampleMapATI(int n, int n2, int n3) {
        this.printIndent();
        this.print("glSampleMapATI(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glSampleMapATI(n, n2, n3);
        this.println("");
    }

    public void glSampleMaskEXT(float f, boolean bl) {
        this.printIndent();
        this.print("glSampleMaskEXT(" + f + "," + bl + ")");
        this.downstreamGL.glSampleMaskEXT(f, bl);
        this.println("");
    }

    public void glSampleMaskSGIS(float f, boolean bl) {
        this.printIndent();
        this.print("glSampleMaskSGIS(" + f + "," + bl + ")");
        this.downstreamGL.glSampleMaskSGIS(f, bl);
        this.println("");
    }

    public void glSamplePatternEXT(int n) {
        this.printIndent();
        this.print("glSamplePatternEXT(" + n + ")");
        this.downstreamGL.glSamplePatternEXT(n);
        this.println("");
    }

    public void glSamplePatternSGIS(int n) {
        this.printIndent();
        this.print("glSamplePatternSGIS(" + n + ")");
        this.downstreamGL.glSamplePatternSGIS(n);
        this.println("");
    }

    public void glScaled(double d, double d2, double d3) {
        this.printIndent();
        this.print("glScaled(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glScaled(d, d2, d3);
        this.println("");
    }

    public void glScalef(float f, float f2, float f3) {
        this.printIndent();
        this.print("glScalef(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glScalef(f, f2, f3);
        this.println("");
    }

    public void glScissor(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glScissor(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glScissor(n, n2, n3, n4);
        this.println("");
    }

    public void glSecondaryColor3b(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glSecondaryColor3b(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glSecondaryColor3b(by, by2, by3);
        this.println("");
    }

    public void glSecondaryColor3bEXT(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glSecondaryColor3bEXT(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glSecondaryColor3bEXT(by, by2, by3);
        this.println("");
    }

    public void glSecondaryColor3bv(byte[] byArray) {
        this.printIndent();
        this.print("glSecondaryColor3bv(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glSecondaryColor3bv(byArray);
        this.println("");
    }

    public void glSecondaryColor3bv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3bv(" + byteBuffer + ")");
        this.downstreamGL.glSecondaryColor3bv(byteBuffer);
        this.println("");
    }

    public void glSecondaryColor3bvEXT(byte[] byArray) {
        this.printIndent();
        this.print("glSecondaryColor3bvEXT(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glSecondaryColor3bvEXT(byArray);
        this.println("");
    }

    public void glSecondaryColor3bvEXT(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3bvEXT(" + byteBuffer + ")");
        this.downstreamGL.glSecondaryColor3bvEXT(byteBuffer);
        this.println("");
    }

    public void glSecondaryColor3d(double d, double d2, double d3) {
        this.printIndent();
        this.print("glSecondaryColor3d(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glSecondaryColor3d(d, d2, d3);
        this.println("");
    }

    public void glSecondaryColor3dEXT(double d, double d2, double d3) {
        this.printIndent();
        this.print("glSecondaryColor3dEXT(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glSecondaryColor3dEXT(d, d2, d3);
        this.println("");
    }

    public void glSecondaryColor3dv(double[] dArray) {
        this.printIndent();
        this.print("glSecondaryColor3dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glSecondaryColor3dv(dArray);
        this.println("");
    }

    public void glSecondaryColor3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3dv(" + doubleBuffer + ")");
        this.downstreamGL.glSecondaryColor3dv(doubleBuffer);
        this.println("");
    }

    public void glSecondaryColor3dvEXT(double[] dArray) {
        this.printIndent();
        this.print("glSecondaryColor3dvEXT(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glSecondaryColor3dvEXT(dArray);
        this.println("");
    }

    public void glSecondaryColor3dvEXT(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3dvEXT(" + doubleBuffer + ")");
        this.downstreamGL.glSecondaryColor3dvEXT(doubleBuffer);
        this.println("");
    }

    public void glSecondaryColor3f(float f, float f2, float f3) {
        this.printIndent();
        this.print("glSecondaryColor3f(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glSecondaryColor3f(f, f2, f3);
        this.println("");
    }

    public void glSecondaryColor3fEXT(float f, float f2, float f3) {
        this.printIndent();
        this.print("glSecondaryColor3fEXT(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glSecondaryColor3fEXT(f, f2, f3);
        this.println("");
    }

    public void glSecondaryColor3fv(float[] fArray) {
        this.printIndent();
        this.print("glSecondaryColor3fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glSecondaryColor3fv(fArray);
        this.println("");
    }

    public void glSecondaryColor3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3fv(" + floatBuffer + ")");
        this.downstreamGL.glSecondaryColor3fv(floatBuffer);
        this.println("");
    }

    public void glSecondaryColor3fvEXT(float[] fArray) {
        this.printIndent();
        this.print("glSecondaryColor3fvEXT(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glSecondaryColor3fvEXT(fArray);
        this.println("");
    }

    public void glSecondaryColor3fvEXT(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3fvEXT(" + floatBuffer + ")");
        this.downstreamGL.glSecondaryColor3fvEXT(floatBuffer);
        this.println("");
    }

    public void glSecondaryColor3hNV(short s, short s2, short s3) {
        this.printIndent();
        this.print("glSecondaryColor3hNV(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glSecondaryColor3hNV(s, s2, s3);
        this.println("");
    }

    public void glSecondaryColor3hvNV(short[] sArray) {
        this.printIndent();
        this.print("glSecondaryColor3hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glSecondaryColor3hvNV(sArray);
        this.println("");
    }

    public void glSecondaryColor3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3hvNV(shortBuffer);
        this.println("");
    }

    public void glSecondaryColor3i(int n, int n2, int n3) {
        this.printIndent();
        this.print("glSecondaryColor3i(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glSecondaryColor3i(n, n2, n3);
        this.println("");
    }

    public void glSecondaryColor3iEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glSecondaryColor3iEXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glSecondaryColor3iEXT(n, n2, n3);
        this.println("");
    }

    public void glSecondaryColor3iv(int[] nArray) {
        this.printIndent();
        this.print("glSecondaryColor3iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glSecondaryColor3iv(nArray);
        this.println("");
    }

    public void glSecondaryColor3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3iv(" + intBuffer + ")");
        this.downstreamGL.glSecondaryColor3iv(intBuffer);
        this.println("");
    }

    public void glSecondaryColor3ivEXT(int[] nArray) {
        this.printIndent();
        this.print("glSecondaryColor3ivEXT(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glSecondaryColor3ivEXT(nArray);
        this.println("");
    }

    public void glSecondaryColor3ivEXT(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3ivEXT(" + intBuffer + ")");
        this.downstreamGL.glSecondaryColor3ivEXT(intBuffer);
        this.println("");
    }

    public void glSecondaryColor3s(short s, short s2, short s3) {
        this.printIndent();
        this.print("glSecondaryColor3s(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glSecondaryColor3s(s, s2, s3);
        this.println("");
    }

    public void glSecondaryColor3sEXT(short s, short s2, short s3) {
        this.printIndent();
        this.print("glSecondaryColor3sEXT(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glSecondaryColor3sEXT(s, s2, s3);
        this.println("");
    }

    public void glSecondaryColor3sv(short[] sArray) {
        this.printIndent();
        this.print("glSecondaryColor3sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glSecondaryColor3sv(sArray);
        this.println("");
    }

    public void glSecondaryColor3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3sv(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3sv(shortBuffer);
        this.println("");
    }

    public void glSecondaryColor3svEXT(short[] sArray) {
        this.printIndent();
        this.print("glSecondaryColor3svEXT(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glSecondaryColor3svEXT(sArray);
        this.println("");
    }

    public void glSecondaryColor3svEXT(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3svEXT(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3svEXT(shortBuffer);
        this.println("");
    }

    public void glSecondaryColor3ub(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glSecondaryColor3ub(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glSecondaryColor3ub(by, by2, by3);
        this.println("");
    }

    public void glSecondaryColor3ubEXT(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glSecondaryColor3ubEXT(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glSecondaryColor3ubEXT(by, by2, by3);
        this.println("");
    }

    public void glSecondaryColor3ubv(byte[] byArray) {
        this.printIndent();
        this.print("glSecondaryColor3ubv(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glSecondaryColor3ubv(byArray);
        this.println("");
    }

    public void glSecondaryColor3ubv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3ubv(" + byteBuffer + ")");
        this.downstreamGL.glSecondaryColor3ubv(byteBuffer);
        this.println("");
    }

    public void glSecondaryColor3ubvEXT(byte[] byArray) {
        this.printIndent();
        this.print("glSecondaryColor3ubvEXT(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glSecondaryColor3ubvEXT(byArray);
        this.println("");
    }

    public void glSecondaryColor3ubvEXT(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3ubvEXT(" + byteBuffer + ")");
        this.downstreamGL.glSecondaryColor3ubvEXT(byteBuffer);
        this.println("");
    }

    public void glSecondaryColor3ui(int n, int n2, int n3) {
        this.printIndent();
        this.print("glSecondaryColor3ui(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glSecondaryColor3ui(n, n2, n3);
        this.println("");
    }

    public void glSecondaryColor3uiEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glSecondaryColor3uiEXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glSecondaryColor3uiEXT(n, n2, n3);
        this.println("");
    }

    public void glSecondaryColor3uiv(int[] nArray) {
        this.printIndent();
        this.print("glSecondaryColor3uiv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glSecondaryColor3uiv(nArray);
        this.println("");
    }

    public void glSecondaryColor3uiv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3uiv(" + intBuffer + ")");
        this.downstreamGL.glSecondaryColor3uiv(intBuffer);
        this.println("");
    }

    public void glSecondaryColor3uivEXT(int[] nArray) {
        this.printIndent();
        this.print("glSecondaryColor3uivEXT(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glSecondaryColor3uivEXT(nArray);
        this.println("");
    }

    public void glSecondaryColor3uivEXT(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3uivEXT(" + intBuffer + ")");
        this.downstreamGL.glSecondaryColor3uivEXT(intBuffer);
        this.println("");
    }

    public void glSecondaryColor3us(short s, short s2, short s3) {
        this.printIndent();
        this.print("glSecondaryColor3us(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glSecondaryColor3us(s, s2, s3);
        this.println("");
    }

    public void glSecondaryColor3usEXT(short s, short s2, short s3) {
        this.printIndent();
        this.print("glSecondaryColor3usEXT(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glSecondaryColor3usEXT(s, s2, s3);
        this.println("");
    }

    public void glSecondaryColor3usv(short[] sArray) {
        this.printIndent();
        this.print("glSecondaryColor3usv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glSecondaryColor3usv(sArray);
        this.println("");
    }

    public void glSecondaryColor3usv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3usv(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3usv(shortBuffer);
        this.println("");
    }

    public void glSecondaryColor3usvEXT(short[] sArray) {
        this.printIndent();
        this.print("glSecondaryColor3usvEXT(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glSecondaryColor3usvEXT(sArray);
        this.println("");
    }

    public void glSecondaryColor3usvEXT(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3usvEXT(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3usvEXT(shortBuffer);
        this.println("");
    }

    public void glSecondaryColorPointer(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glSecondaryColorPointer(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glSecondaryColorPointer(n, n2, n3, buffer);
        this.println("");
    }

    public void glSecondaryColorPointerEXT(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glSecondaryColorPointerEXT(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glSecondaryColorPointerEXT(n, n2, n3, buffer);
        this.println("");
    }

    public void glSecondaryColorPointerListIBM(int n, int n2, int n3, Buffer[] bufferArray, int n4) {
        this.printIndent();
        this.print("glSecondaryColorPointerListIBM(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(bufferArray) + "," + n4 + ")");
        this.downstreamGL.glSecondaryColorPointerListIBM(n, n2, n3, bufferArray, n4);
        this.println("");
    }

    public void glSelectBuffer(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSelectBuffer(" + n + "," + intBuffer + ")");
        this.downstreamGL.glSelectBuffer(n, intBuffer);
        this.println("");
    }

    public void glSeparableFilter2D(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray, boolean[] blArray2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + ")");
        this.downstreamGL.glSeparableFilter2D(n, n2, n3, n4, n5, n6, blArray, blArray2);
        this.println("");
    }

    public void glSeparableFilter2D(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray, char[] cArray2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + ")");
        this.downstreamGL.glSeparableFilter2D(n, n2, n3, n4, n5, n6, cArray, cArray2);
        this.println("");
    }

    public void glSeparableFilter2D(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray, byte[] byArray2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + ")");
        this.downstreamGL.glSeparableFilter2D(n, n2, n3, n4, n5, n6, byArray, byArray2);
        this.println("");
    }

    public void glSeparableFilter2D(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray, short[] sArray2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + ")");
        this.downstreamGL.glSeparableFilter2D(n, n2, n3, n4, n5, n6, sArray, sArray2);
        this.println("");
    }

    public void glSeparableFilter2D(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + ")");
        this.downstreamGL.glSeparableFilter2D(n, n2, n3, n4, n5, n6, nArray, nArray2);
        this.println("");
    }

    public void glSeparableFilter2D(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray, long[] lArray2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + ")");
        this.downstreamGL.glSeparableFilter2D(n, n2, n3, n4, n5, n6, lArray, lArray2);
        this.println("");
    }

    public void glSeparableFilter2D(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glSeparableFilter2D(n, n2, n3, n4, n5, n6, fArray, fArray2);
        this.println("");
    }

    public void glSeparableFilter2D(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray, double[] dArray2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + ")");
        this.downstreamGL.glSeparableFilter2D(n, n2, n3, n4, n5, n6, dArray, dArray2);
        this.println("");
    }

    public void glSeparableFilter2D(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer, Buffer buffer2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + "," + buffer2 + ")");
        this.downstreamGL.glSeparableFilter2D(n, n2, n3, n4, n5, n6, buffer, buffer2);
        this.println("");
    }

    public void glSeparableFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray, boolean[] blArray2) {
        this.printIndent();
        this.print("glSeparableFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + "," + this.dumpArray(blArray2) + ")");
        this.downstreamGL.glSeparableFilter2DEXT(n, n2, n3, n4, n5, n6, blArray, blArray2);
        this.println("");
    }

    public void glSeparableFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray, char[] cArray2) {
        this.printIndent();
        this.print("glSeparableFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + "," + this.dumpArray(cArray2) + ")");
        this.downstreamGL.glSeparableFilter2DEXT(n, n2, n3, n4, n5, n6, cArray, cArray2);
        this.println("");
    }

    public void glSeparableFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray, byte[] byArray2) {
        this.printIndent();
        this.print("glSeparableFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + "," + this.dumpArray(byArray2) + ")");
        this.downstreamGL.glSeparableFilter2DEXT(n, n2, n3, n4, n5, n6, byArray, byArray2);
        this.println("");
    }

    public void glSeparableFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray, short[] sArray2) {
        this.printIndent();
        this.print("glSeparableFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + "," + this.dumpArray(sArray2) + ")");
        this.downstreamGL.glSeparableFilter2DEXT(n, n2, n3, n4, n5, n6, sArray, sArray2);
        this.println("");
    }

    public void glSeparableFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2) {
        this.printIndent();
        this.print("glSeparableFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + ")");
        this.downstreamGL.glSeparableFilter2DEXT(n, n2, n3, n4, n5, n6, nArray, nArray2);
        this.println("");
    }

    public void glSeparableFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray, long[] lArray2) {
        this.printIndent();
        this.print("glSeparableFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + "," + this.dumpArray(lArray2) + ")");
        this.downstreamGL.glSeparableFilter2DEXT(n, n2, n3, n4, n5, n6, lArray, lArray2);
        this.println("");
    }

    public void glSeparableFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glSeparableFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glSeparableFilter2DEXT(n, n2, n3, n4, n5, n6, fArray, fArray2);
        this.println("");
    }

    public void glSeparableFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray, double[] dArray2) {
        this.printIndent();
        this.print("glSeparableFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + "," + this.dumpArray(dArray2) + ")");
        this.downstreamGL.glSeparableFilter2DEXT(n, n2, n3, n4, n5, n6, dArray, dArray2);
        this.println("");
    }

    public void glSeparableFilter2DEXT(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer, Buffer buffer2) {
        this.printIndent();
        this.print("glSeparableFilter2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + "," + buffer2 + ")");
        this.downstreamGL.glSeparableFilter2DEXT(n, n2, n3, n4, n5, n6, buffer, buffer2);
        this.println("");
    }

    public void glSetFenceAPPLE(int n) {
        this.printIndent();
        this.print("glSetFenceAPPLE(" + n + ")");
        this.downstreamGL.glSetFenceAPPLE(n);
        this.println("");
    }

    public void glSetFenceNV(int n, int n2) {
        this.printIndent();
        this.print("glSetFenceNV(" + n + "," + n2 + ")");
        this.downstreamGL.glSetFenceNV(n, n2);
        this.println("");
    }

    public void glSetFragmentShaderConstantATI(int n, float[] fArray) {
        this.printIndent();
        this.print("glSetFragmentShaderConstantATI(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glSetFragmentShaderConstantATI(n, fArray);
        this.println("");
    }

    public void glSetFragmentShaderConstantATI(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSetFragmentShaderConstantATI(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glSetFragmentShaderConstantATI(n, floatBuffer);
        this.println("");
    }

    public void glSetInvariantEXT(int n, int n2, boolean[] blArray) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n + "," + n2 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glSetInvariantEXT(n, n2, blArray);
        this.println("");
    }

    public void glSetInvariantEXT(int n, int n2, char[] cArray) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n + "," + n2 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glSetInvariantEXT(n, n2, cArray);
        this.println("");
    }

    public void glSetInvariantEXT(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glSetInvariantEXT(n, n2, byArray);
        this.println("");
    }

    public void glSetInvariantEXT(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glSetInvariantEXT(n, n2, sArray);
        this.println("");
    }

    public void glSetInvariantEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glSetInvariantEXT(n, n2, nArray);
        this.println("");
    }

    public void glSetInvariantEXT(int n, int n2, long[] lArray) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n + "," + n2 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glSetInvariantEXT(n, n2, lArray);
        this.println("");
    }

    public void glSetInvariantEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glSetInvariantEXT(n, n2, fArray);
        this.println("");
    }

    public void glSetInvariantEXT(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glSetInvariantEXT(n, n2, dArray);
        this.println("");
    }

    public void glSetInvariantEXT(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glSetInvariantEXT(n, n2, buffer);
        this.println("");
    }

    public void glSetLocalConstantEXT(int n, int n2, boolean[] blArray) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n + "," + n2 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glSetLocalConstantEXT(n, n2, blArray);
        this.println("");
    }

    public void glSetLocalConstantEXT(int n, int n2, char[] cArray) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n + "," + n2 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glSetLocalConstantEXT(n, n2, cArray);
        this.println("");
    }

    public void glSetLocalConstantEXT(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glSetLocalConstantEXT(n, n2, byArray);
        this.println("");
    }

    public void glSetLocalConstantEXT(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glSetLocalConstantEXT(n, n2, sArray);
        this.println("");
    }

    public void glSetLocalConstantEXT(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glSetLocalConstantEXT(n, n2, nArray);
        this.println("");
    }

    public void glSetLocalConstantEXT(int n, int n2, long[] lArray) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n + "," + n2 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glSetLocalConstantEXT(n, n2, lArray);
        this.println("");
    }

    public void glSetLocalConstantEXT(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glSetLocalConstantEXT(n, n2, fArray);
        this.println("");
    }

    public void glSetLocalConstantEXT(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glSetLocalConstantEXT(n, n2, dArray);
        this.println("");
    }

    public void glSetLocalConstantEXT(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glSetLocalConstantEXT(n, n2, buffer);
        this.println("");
    }

    public void glShadeModel(int n) {
        this.printIndent();
        this.print("glShadeModel(" + n + ")");
        this.downstreamGL.glShadeModel(n);
        this.println("");
    }

    public void glShaderOp1EXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glShaderOp1EXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glShaderOp1EXT(n, n2, n3);
        this.println("");
    }

    public void glShaderOp2EXT(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glShaderOp2EXT(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glShaderOp2EXT(n, n2, n3, n4);
        this.println("");
    }

    public void glShaderOp3EXT(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glShaderOp3EXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glShaderOp3EXT(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glShaderSource(int n, int n2, ByteBuffer[] byteBufferArray, int[] nArray) {
        this.printIndent();
        this.print("glShaderSource(" + n + "," + n2 + "," + this.dumpArray(byteBufferArray) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glShaderSource(n, n2, byteBufferArray, nArray);
        this.println("");
    }

    public void glShaderSource(int n, int n2, ByteBuffer[] byteBufferArray, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glShaderSource(" + n + "," + n2 + "," + this.dumpArray(byteBufferArray) + "," + intBuffer + ")");
        this.downstreamGL.glShaderSource(n, n2, byteBufferArray, intBuffer);
        this.println("");
    }

    public void glShaderSourceARB(int n, int n2, String[] stringArray, int[] nArray) {
        this.printIndent();
        this.print("glShaderSourceARB(" + n + "," + n2 + "," + this.dumpArray(stringArray) + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glShaderSourceARB(n, n2, stringArray, nArray);
        this.println("");
    }

    public void glShaderSourceARB(int n, int n2, String[] stringArray, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glShaderSourceARB(" + n + "," + n2 + "," + this.dumpArray(stringArray) + "," + intBuffer + ")");
        this.downstreamGL.glShaderSourceARB(n, n2, stringArray, intBuffer);
        this.println("");
    }

    public void glSharpenTexFuncSGIS(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glSharpenTexFuncSGIS(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glSharpenTexFuncSGIS(n, n2, fArray);
        this.println("");
    }

    public void glSharpenTexFuncSGIS(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSharpenTexFuncSGIS(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glSharpenTexFuncSGIS(n, n2, floatBuffer);
        this.println("");
    }

    public void glSpriteParameterfSGIX(int n, float f) {
        this.printIndent();
        this.print("glSpriteParameterfSGIX(" + n + "," + f + ")");
        this.downstreamGL.glSpriteParameterfSGIX(n, f);
        this.println("");
    }

    public void glSpriteParameterfvSGIX(int n, float[] fArray) {
        this.printIndent();
        this.print("glSpriteParameterfvSGIX(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glSpriteParameterfvSGIX(n, fArray);
        this.println("");
    }

    public void glSpriteParameterfvSGIX(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSpriteParameterfvSGIX(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glSpriteParameterfvSGIX(n, floatBuffer);
        this.println("");
    }

    public void glSpriteParameteriSGIX(int n, int n2) {
        this.printIndent();
        this.print("glSpriteParameteriSGIX(" + n + "," + n2 + ")");
        this.downstreamGL.glSpriteParameteriSGIX(n, n2);
        this.println("");
    }

    public void glSpriteParameterivSGIX(int n, int[] nArray) {
        this.printIndent();
        this.print("glSpriteParameterivSGIX(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glSpriteParameterivSGIX(n, nArray);
        this.println("");
    }

    public void glSpriteParameterivSGIX(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSpriteParameterivSGIX(" + n + "," + intBuffer + ")");
        this.downstreamGL.glSpriteParameterivSGIX(n, intBuffer);
        this.println("");
    }

    public void glStartInstrumentsSGIX() {
        this.printIndent();
        this.print("glStartInstrumentsSGIX()");
        this.downstreamGL.glStartInstrumentsSGIX();
        this.println("");
    }

    public void glStencilFunc(int n, int n2, int n3) {
        this.printIndent();
        this.print("glStencilFunc(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glStencilFunc(n, n2, n3);
        this.println("");
    }

    public void glStencilFuncSeparate(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glStencilFuncSeparate(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glStencilFuncSeparate(n, n2, n3, n4);
        this.println("");
    }

    public void glStencilFuncSeparateATI(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glStencilFuncSeparateATI(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glStencilFuncSeparateATI(n, n2, n3, n4);
        this.println("");
    }

    public void glStencilMask(int n) {
        this.printIndent();
        this.print("glStencilMask(" + n + ")");
        this.downstreamGL.glStencilMask(n);
        this.println("");
    }

    public void glStencilMaskSeparate(int n, int n2) {
        this.printIndent();
        this.print("glStencilMaskSeparate(" + n + "," + n2 + ")");
        this.downstreamGL.glStencilMaskSeparate(n, n2);
        this.println("");
    }

    public void glStencilOp(int n, int n2, int n3) {
        this.printIndent();
        this.print("glStencilOp(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glStencilOp(n, n2, n3);
        this.println("");
    }

    public void glStencilOpSeparate(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glStencilOpSeparate(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glStencilOpSeparate(n, n2, n3, n4);
        this.println("");
    }

    public void glStencilOpSeparateATI(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glStencilOpSeparateATI(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glStencilOpSeparateATI(n, n2, n3, n4);
        this.println("");
    }

    public void glStopInstrumentsSGIX(int n) {
        this.printIndent();
        this.print("glStopInstrumentsSGIX(" + n + ")");
        this.downstreamGL.glStopInstrumentsSGIX(n);
        this.println("");
    }

    public void glStringMarkerGREMEDY(int n, boolean[] blArray) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n, blArray);
        this.println("");
    }

    public void glStringMarkerGREMEDY(int n, char[] cArray) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n, cArray);
        this.println("");
    }

    public void glStringMarkerGREMEDY(int n, byte[] byArray) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n, byArray);
        this.println("");
    }

    public void glStringMarkerGREMEDY(int n, short[] sArray) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n, sArray);
        this.println("");
    }

    public void glStringMarkerGREMEDY(int n, int[] nArray) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n, nArray);
        this.println("");
    }

    public void glStringMarkerGREMEDY(int n, long[] lArray) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n, lArray);
        this.println("");
    }

    public void glStringMarkerGREMEDY(int n, float[] fArray) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n, fArray);
        this.println("");
    }

    public void glStringMarkerGREMEDY(int n, double[] dArray) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n, dArray);
        this.println("");
    }

    public void glStringMarkerGREMEDY(int n, Buffer buffer) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n + "," + buffer + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n, buffer);
        this.println("");
    }

    public void glSwapAPPLE() {
        this.printIndent();
        this.print("glSwapAPPLE()");
        this.downstreamGL.glSwapAPPLE();
        this.println("");
    }

    public void glSwizzleEXT(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glSwizzleEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glSwizzleEXT(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public void glTagSampleBufferSGIX() {
        this.printIndent();
        this.print("glTagSampleBufferSGIX()");
        this.downstreamGL.glTagSampleBufferSGIX();
        this.println("");
    }

    public void glTangent3bEXT(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glTangent3bEXT(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glTangent3bEXT(by, by2, by3);
        this.println("");
    }

    public void glTangent3bvEXT(byte[] byArray) {
        this.printIndent();
        this.print("glTangent3bvEXT(" + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTangent3bvEXT(byArray);
        this.println("");
    }

    public void glTangent3bvEXT(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glTangent3bvEXT(" + byteBuffer + ")");
        this.downstreamGL.glTangent3bvEXT(byteBuffer);
        this.println("");
    }

    public void glTangent3dEXT(double d, double d2, double d3) {
        this.printIndent();
        this.print("glTangent3dEXT(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glTangent3dEXT(d, d2, d3);
        this.println("");
    }

    public void glTangent3dvEXT(double[] dArray) {
        this.printIndent();
        this.print("glTangent3dvEXT(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTangent3dvEXT(dArray);
        this.println("");
    }

    public void glTangent3dvEXT(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTangent3dvEXT(" + doubleBuffer + ")");
        this.downstreamGL.glTangent3dvEXT(doubleBuffer);
        this.println("");
    }

    public void glTangent3fEXT(float f, float f2, float f3) {
        this.printIndent();
        this.print("glTangent3fEXT(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glTangent3fEXT(f, f2, f3);
        this.println("");
    }

    public void glTangent3fvEXT(float[] fArray) {
        this.printIndent();
        this.print("glTangent3fvEXT(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTangent3fvEXT(fArray);
        this.println("");
    }

    public void glTangent3fvEXT(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTangent3fvEXT(" + floatBuffer + ")");
        this.downstreamGL.glTangent3fvEXT(floatBuffer);
        this.println("");
    }

    public void glTangent3iEXT(int n, int n2, int n3) {
        this.printIndent();
        this.print("glTangent3iEXT(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glTangent3iEXT(n, n2, n3);
        this.println("");
    }

    public void glTangent3ivEXT(int[] nArray) {
        this.printIndent();
        this.print("glTangent3ivEXT(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTangent3ivEXT(nArray);
        this.println("");
    }

    public void glTangent3ivEXT(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTangent3ivEXT(" + intBuffer + ")");
        this.downstreamGL.glTangent3ivEXT(intBuffer);
        this.println("");
    }

    public void glTangent3sEXT(short s, short s2, short s3) {
        this.printIndent();
        this.print("glTangent3sEXT(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glTangent3sEXT(s, s2, s3);
        this.println("");
    }

    public void glTangent3svEXT(short[] sArray) {
        this.printIndent();
        this.print("glTangent3svEXT(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTangent3svEXT(sArray);
        this.println("");
    }

    public void glTangent3svEXT(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTangent3svEXT(" + shortBuffer + ")");
        this.downstreamGL.glTangent3svEXT(shortBuffer);
        this.println("");
    }

    public void glTangentPointerEXT(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glTangentPointerEXT(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glTangentPointerEXT(n, n2, buffer);
        this.println("");
    }

    public void glTbufferMask3DFX(int n) {
        this.printIndent();
        this.print("glTbufferMask3DFX(" + n + ")");
        this.downstreamGL.glTbufferMask3DFX(n);
        this.println("");
    }

    public boolean glTestFenceAPPLE(int n) {
        this.printIndent();
        this.print("glTestFenceAPPLE(" + n + ")");
        boolean bl = this.downstreamGL.glTestFenceAPPLE(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glTestFenceNV(int n) {
        this.printIndent();
        this.print("glTestFenceNV(" + n + ")");
        boolean bl = this.downstreamGL.glTestFenceNV(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glTestObjectAPPLE(int n, int n2) {
        this.printIndent();
        this.print("glTestObjectAPPLE(" + n + "," + n2 + ")");
        boolean bl = this.downstreamGL.glTestObjectAPPLE(n, n2);
        this.println(" = " + bl);
        return bl;
    }

    public void glTexBumpParameterfvATI(int n, float[] fArray) {
        this.printIndent();
        this.print("glTexBumpParameterfvATI(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexBumpParameterfvATI(n, fArray);
        this.println("");
    }

    public void glTexBumpParameterfvATI(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexBumpParameterfvATI(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glTexBumpParameterfvATI(n, floatBuffer);
        this.println("");
    }

    public void glTexBumpParameterivATI(int n, int[] nArray) {
        this.printIndent();
        this.print("glTexBumpParameterivATI(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexBumpParameterivATI(n, nArray);
        this.println("");
    }

    public void glTexBumpParameterivATI(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexBumpParameterivATI(" + n + "," + intBuffer + ")");
        this.downstreamGL.glTexBumpParameterivATI(n, intBuffer);
        this.println("");
    }

    public void glTexCoord1d(double d) {
        this.printIndent();
        this.print("glTexCoord1d(" + d + ")");
        this.downstreamGL.glTexCoord1d(d);
        this.println("");
    }

    public void glTexCoord1dv(double[] dArray) {
        this.printIndent();
        this.print("glTexCoord1dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexCoord1dv(dArray);
        this.println("");
    }

    public void glTexCoord1dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexCoord1dv(" + doubleBuffer + ")");
        this.downstreamGL.glTexCoord1dv(doubleBuffer);
        this.println("");
    }

    public void glTexCoord1f(float f) {
        this.printIndent();
        this.print("glTexCoord1f(" + f + ")");
        this.downstreamGL.glTexCoord1f(f);
        this.println("");
    }

    public void glTexCoord1fv(float[] fArray) {
        this.printIndent();
        this.print("glTexCoord1fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexCoord1fv(fArray);
        this.println("");
    }

    public void glTexCoord1fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexCoord1fv(" + floatBuffer + ")");
        this.downstreamGL.glTexCoord1fv(floatBuffer);
        this.println("");
    }

    public void glTexCoord1hNV(short s) {
        this.printIndent();
        this.print("glTexCoord1hNV(" + s + ")");
        this.downstreamGL.glTexCoord1hNV(s);
        this.println("");
    }

    public void glTexCoord1hvNV(short[] sArray) {
        this.printIndent();
        this.print("glTexCoord1hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexCoord1hvNV(sArray);
        this.println("");
    }

    public void glTexCoord1hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord1hvNV(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord1hvNV(shortBuffer);
        this.println("");
    }

    public void glTexCoord1i(int n) {
        this.printIndent();
        this.print("glTexCoord1i(" + n + ")");
        this.downstreamGL.glTexCoord1i(n);
        this.println("");
    }

    public void glTexCoord1iv(int[] nArray) {
        this.printIndent();
        this.print("glTexCoord1iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexCoord1iv(nArray);
        this.println("");
    }

    public void glTexCoord1iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexCoord1iv(" + intBuffer + ")");
        this.downstreamGL.glTexCoord1iv(intBuffer);
        this.println("");
    }

    public void glTexCoord1s(short s) {
        this.printIndent();
        this.print("glTexCoord1s(" + s + ")");
        this.downstreamGL.glTexCoord1s(s);
        this.println("");
    }

    public void glTexCoord1sv(short[] sArray) {
        this.printIndent();
        this.print("glTexCoord1sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexCoord1sv(sArray);
        this.println("");
    }

    public void glTexCoord1sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord1sv(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord1sv(shortBuffer);
        this.println("");
    }

    public void glTexCoord2d(double d, double d2) {
        this.printIndent();
        this.print("glTexCoord2d(" + d + "," + d2 + ")");
        this.downstreamGL.glTexCoord2d(d, d2);
        this.println("");
    }

    public void glTexCoord2dv(double[] dArray) {
        this.printIndent();
        this.print("glTexCoord2dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexCoord2dv(dArray);
        this.println("");
    }

    public void glTexCoord2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexCoord2dv(" + doubleBuffer + ")");
        this.downstreamGL.glTexCoord2dv(doubleBuffer);
        this.println("");
    }

    public void glTexCoord2f(float f, float f2) {
        this.printIndent();
        this.print("glTexCoord2f(" + f + "," + f2 + ")");
        this.downstreamGL.glTexCoord2f(f, f2);
        this.println("");
    }

    public void glTexCoord2fColor3fVertex3fSUN(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.printIndent();
        this.print("glTexCoord2fColor3fVertex3fSUN(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + ")");
        this.downstreamGL.glTexCoord2fColor3fVertex3fSUN(f, f2, f3, f4, f5, f6, f7, f8);
        this.println("");
    }

    public void glTexCoord2fColor3fVertex3fvSUN(float[] fArray, float[] fArray2, float[] fArray3) {
        this.printIndent();
        this.print("glTexCoord2fColor3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + ")");
        this.downstreamGL.glTexCoord2fColor3fVertex3fvSUN(fArray, fArray2, fArray3);
        this.println("");
    }

    public void glTexCoord2fColor3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glTexCoord2fColor3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glTexCoord2fColor3fVertex3fvSUN(floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    public void glTexCoord2fColor4fNormal3fVertex3fSUN(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.printIndent();
        this.print("glTexCoord2fColor4fNormal3fVertex3fSUN(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + "," + f11 + "," + f12 + ")");
        this.downstreamGL.glTexCoord2fColor4fNormal3fVertex3fSUN(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        this.println("");
    }

    public void glTexCoord2fColor4fNormal3fVertex3fvSUN(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.printIndent();
        this.print("glTexCoord2fColor4fNormal3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + "," + this.dumpArray(fArray4) + ")");
        this.downstreamGL.glTexCoord2fColor4fNormal3fVertex3fvSUN(fArray, fArray2, fArray3, fArray4);
        this.println("");
    }

    public void glTexCoord2fColor4fNormal3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        this.printIndent();
        this.print("glTexCoord2fColor4fNormal3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + "," + floatBuffer4 + ")");
        this.downstreamGL.glTexCoord2fColor4fNormal3fVertex3fvSUN(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.println("");
    }

    public void glTexCoord2fColor4ubVertex3fSUN(float f, float f2, byte by, byte by2, byte by3, byte by4, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glTexCoord2fColor4ubVertex3fSUN(" + f + "," + f2 + "," + by + "," + by2 + "," + by3 + "," + by4 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glTexCoord2fColor4ubVertex3fSUN(f, f2, by, by2, by3, by4, f3, f4, f5);
        this.println("");
    }

    public void glTexCoord2fColor4ubVertex3fvSUN(float[] fArray, byte[] byArray, float[] fArray2) {
        this.printIndent();
        this.print("glTexCoord2fColor4ubVertex3fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(byArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glTexCoord2fColor4ubVertex3fvSUN(fArray, byArray, fArray2);
        this.println("");
    }

    public void glTexCoord2fColor4ubVertex3fvSUN(FloatBuffer floatBuffer, ByteBuffer byteBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glTexCoord2fColor4ubVertex3fvSUN(" + floatBuffer + "," + byteBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glTexCoord2fColor4ubVertex3fvSUN(floatBuffer, byteBuffer, floatBuffer2);
        this.println("");
    }

    public void glTexCoord2fNormal3fVertex3fSUN(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.printIndent();
        this.print("glTexCoord2fNormal3fVertex3fSUN(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + ")");
        this.downstreamGL.glTexCoord2fNormal3fVertex3fSUN(f, f2, f3, f4, f5, f6, f7, f8);
        this.println("");
    }

    public void glTexCoord2fNormal3fVertex3fvSUN(float[] fArray, float[] fArray2, float[] fArray3) {
        this.printIndent();
        this.print("glTexCoord2fNormal3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + ")");
        this.downstreamGL.glTexCoord2fNormal3fVertex3fvSUN(fArray, fArray2, fArray3);
        this.println("");
    }

    public void glTexCoord2fNormal3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glTexCoord2fNormal3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glTexCoord2fNormal3fVertex3fvSUN(floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    public void glTexCoord2fVertex3fSUN(float f, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glTexCoord2fVertex3fSUN(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glTexCoord2fVertex3fSUN(f, f2, f3, f4, f5);
        this.println("");
    }

    public void glTexCoord2fVertex3fvSUN(float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glTexCoord2fVertex3fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glTexCoord2fVertex3fvSUN(fArray, fArray2);
        this.println("");
    }

    public void glTexCoord2fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glTexCoord2fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glTexCoord2fVertex3fvSUN(floatBuffer, floatBuffer2);
        this.println("");
    }

    public void glTexCoord2fv(float[] fArray) {
        this.printIndent();
        this.print("glTexCoord2fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexCoord2fv(fArray);
        this.println("");
    }

    public void glTexCoord2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexCoord2fv(" + floatBuffer + ")");
        this.downstreamGL.glTexCoord2fv(floatBuffer);
        this.println("");
    }

    public void glTexCoord2hNV(short s, short s2) {
        this.printIndent();
        this.print("glTexCoord2hNV(" + s + "," + s2 + ")");
        this.downstreamGL.glTexCoord2hNV(s, s2);
        this.println("");
    }

    public void glTexCoord2hvNV(short[] sArray) {
        this.printIndent();
        this.print("glTexCoord2hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexCoord2hvNV(sArray);
        this.println("");
    }

    public void glTexCoord2hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord2hvNV(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord2hvNV(shortBuffer);
        this.println("");
    }

    public void glTexCoord2i(int n, int n2) {
        this.printIndent();
        this.print("glTexCoord2i(" + n + "," + n2 + ")");
        this.downstreamGL.glTexCoord2i(n, n2);
        this.println("");
    }

    public void glTexCoord2iv(int[] nArray) {
        this.printIndent();
        this.print("glTexCoord2iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexCoord2iv(nArray);
        this.println("");
    }

    public void glTexCoord2iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexCoord2iv(" + intBuffer + ")");
        this.downstreamGL.glTexCoord2iv(intBuffer);
        this.println("");
    }

    public void glTexCoord2s(short s, short s2) {
        this.printIndent();
        this.print("glTexCoord2s(" + s + "," + s2 + ")");
        this.downstreamGL.glTexCoord2s(s, s2);
        this.println("");
    }

    public void glTexCoord2sv(short[] sArray) {
        this.printIndent();
        this.print("glTexCoord2sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexCoord2sv(sArray);
        this.println("");
    }

    public void glTexCoord2sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord2sv(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord2sv(shortBuffer);
        this.println("");
    }

    public void glTexCoord3d(double d, double d2, double d3) {
        this.printIndent();
        this.print("glTexCoord3d(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glTexCoord3d(d, d2, d3);
        this.println("");
    }

    public void glTexCoord3dv(double[] dArray) {
        this.printIndent();
        this.print("glTexCoord3dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexCoord3dv(dArray);
        this.println("");
    }

    public void glTexCoord3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexCoord3dv(" + doubleBuffer + ")");
        this.downstreamGL.glTexCoord3dv(doubleBuffer);
        this.println("");
    }

    public void glTexCoord3f(float f, float f2, float f3) {
        this.printIndent();
        this.print("glTexCoord3f(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glTexCoord3f(f, f2, f3);
        this.println("");
    }

    public void glTexCoord3fv(float[] fArray) {
        this.printIndent();
        this.print("glTexCoord3fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexCoord3fv(fArray);
        this.println("");
    }

    public void glTexCoord3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexCoord3fv(" + floatBuffer + ")");
        this.downstreamGL.glTexCoord3fv(floatBuffer);
        this.println("");
    }

    public void glTexCoord3hNV(short s, short s2, short s3) {
        this.printIndent();
        this.print("glTexCoord3hNV(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glTexCoord3hNV(s, s2, s3);
        this.println("");
    }

    public void glTexCoord3hvNV(short[] sArray) {
        this.printIndent();
        this.print("glTexCoord3hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexCoord3hvNV(sArray);
        this.println("");
    }

    public void glTexCoord3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord3hvNV(shortBuffer);
        this.println("");
    }

    public void glTexCoord3i(int n, int n2, int n3) {
        this.printIndent();
        this.print("glTexCoord3i(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glTexCoord3i(n, n2, n3);
        this.println("");
    }

    public void glTexCoord3iv(int[] nArray) {
        this.printIndent();
        this.print("glTexCoord3iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexCoord3iv(nArray);
        this.println("");
    }

    public void glTexCoord3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexCoord3iv(" + intBuffer + ")");
        this.downstreamGL.glTexCoord3iv(intBuffer);
        this.println("");
    }

    public void glTexCoord3s(short s, short s2, short s3) {
        this.printIndent();
        this.print("glTexCoord3s(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glTexCoord3s(s, s2, s3);
        this.println("");
    }

    public void glTexCoord3sv(short[] sArray) {
        this.printIndent();
        this.print("glTexCoord3sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexCoord3sv(sArray);
        this.println("");
    }

    public void glTexCoord3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord3sv(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord3sv(shortBuffer);
        this.println("");
    }

    public void glTexCoord4d(double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glTexCoord4d(" + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glTexCoord4d(d, d2, d3, d4);
        this.println("");
    }

    public void glTexCoord4dv(double[] dArray) {
        this.printIndent();
        this.print("glTexCoord4dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexCoord4dv(dArray);
        this.println("");
    }

    public void glTexCoord4dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexCoord4dv(" + doubleBuffer + ")");
        this.downstreamGL.glTexCoord4dv(doubleBuffer);
        this.println("");
    }

    public void glTexCoord4f(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glTexCoord4f(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glTexCoord4f(f, f2, f3, f4);
        this.println("");
    }

    public void glTexCoord4fColor4fNormal3fVertex4fSUN(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15) {
        this.printIndent();
        this.print("glTexCoord4fColor4fNormal3fVertex4fSUN(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + "," + f11 + "," + f12 + "," + f13 + "," + f14 + "," + f15 + ")");
        this.downstreamGL.glTexCoord4fColor4fNormal3fVertex4fSUN(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15);
        this.println("");
    }

    public void glTexCoord4fColor4fNormal3fVertex4fvSUN(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.printIndent();
        this.print("glTexCoord4fColor4fNormal3fVertex4fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + "," + this.dumpArray(fArray3) + "," + this.dumpArray(fArray4) + ")");
        this.downstreamGL.glTexCoord4fColor4fNormal3fVertex4fvSUN(fArray, fArray2, fArray3, fArray4);
        this.println("");
    }

    public void glTexCoord4fColor4fNormal3fVertex4fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        this.printIndent();
        this.print("glTexCoord4fColor4fNormal3fVertex4fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + "," + floatBuffer4 + ")");
        this.downstreamGL.glTexCoord4fColor4fNormal3fVertex4fvSUN(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.println("");
    }

    public void glTexCoord4fVertex4fSUN(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.printIndent();
        this.print("glTexCoord4fVertex4fSUN(" + f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + ")");
        this.downstreamGL.glTexCoord4fVertex4fSUN(f, f2, f3, f4, f5, f6, f7, f8);
        this.println("");
    }

    public void glTexCoord4fVertex4fvSUN(float[] fArray, float[] fArray2) {
        this.printIndent();
        this.print("glTexCoord4fVertex4fvSUN(" + this.dumpArray(fArray) + "," + this.dumpArray(fArray2) + ")");
        this.downstreamGL.glTexCoord4fVertex4fvSUN(fArray, fArray2);
        this.println("");
    }

    public void glTexCoord4fVertex4fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glTexCoord4fVertex4fvSUN(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glTexCoord4fVertex4fvSUN(floatBuffer, floatBuffer2);
        this.println("");
    }

    public void glTexCoord4fv(float[] fArray) {
        this.printIndent();
        this.print("glTexCoord4fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexCoord4fv(fArray);
        this.println("");
    }

    public void glTexCoord4fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexCoord4fv(" + floatBuffer + ")");
        this.downstreamGL.glTexCoord4fv(floatBuffer);
        this.println("");
    }

    public void glTexCoord4hNV(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glTexCoord4hNV(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glTexCoord4hNV(s, s2, s3, s4);
        this.println("");
    }

    public void glTexCoord4hvNV(short[] sArray) {
        this.printIndent();
        this.print("glTexCoord4hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexCoord4hvNV(sArray);
        this.println("");
    }

    public void glTexCoord4hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord4hvNV(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord4hvNV(shortBuffer);
        this.println("");
    }

    public void glTexCoord4i(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glTexCoord4i(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glTexCoord4i(n, n2, n3, n4);
        this.println("");
    }

    public void glTexCoord4iv(int[] nArray) {
        this.printIndent();
        this.print("glTexCoord4iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexCoord4iv(nArray);
        this.println("");
    }

    public void glTexCoord4iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexCoord4iv(" + intBuffer + ")");
        this.downstreamGL.glTexCoord4iv(intBuffer);
        this.println("");
    }

    public void glTexCoord4s(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glTexCoord4s(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glTexCoord4s(s, s2, s3, s4);
        this.println("");
    }

    public void glTexCoord4sv(short[] sArray) {
        this.printIndent();
        this.print("glTexCoord4sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexCoord4sv(sArray);
        this.println("");
    }

    public void glTexCoord4sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord4sv(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord4sv(shortBuffer);
        this.println("");
    }

    public void glTexCoordPointer(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glTexCoordPointer(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glTexCoordPointer(n, n2, n3, buffer);
        this.println("");
    }

    public void glTexCoordPointerEXT(int n, int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glTexCoordPointerEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glTexCoordPointerEXT(n, n2, n3, n4, buffer);
        this.println("");
    }

    public void glTexCoordPointerListIBM(int n, int n2, int n3, Buffer[] bufferArray, int n4) {
        this.printIndent();
        this.print("glTexCoordPointerListIBM(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(bufferArray) + "," + n4 + ")");
        this.downstreamGL.glTexCoordPointerListIBM(n, n2, n3, bufferArray, n4);
        this.println("");
    }

    public void glTexCoordPointervINTEL(int n, int n2, Buffer[] bufferArray) {
        this.printIndent();
        this.print("glTexCoordPointervINTEL(" + n + "," + n2 + "," + this.dumpArray(bufferArray) + ")");
        this.downstreamGL.glTexCoordPointervINTEL(n, n2, bufferArray);
        this.println("");
    }

    public void glTexEnvf(int n, int n2, float f) {
        this.printIndent();
        this.print("glTexEnvf(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glTexEnvf(n, n2, f);
        this.println("");
    }

    public void glTexEnvfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glTexEnvfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexEnvfv(n, n2, fArray);
        this.println("");
    }

    public void glTexEnvfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexEnvfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glTexEnvfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glTexEnvi(int n, int n2, int n3) {
        this.printIndent();
        this.print("glTexEnvi(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glTexEnvi(n, n2, n3);
        this.println("");
    }

    public void glTexEnviv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glTexEnviv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexEnviv(n, n2, nArray);
        this.println("");
    }

    public void glTexEnviv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexEnviv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glTexEnviv(n, n2, intBuffer);
        this.println("");
    }

    public void glTexFilterFuncSGIS(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glTexFilterFuncSGIS(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexFilterFuncSGIS(n, n2, n3, fArray);
        this.println("");
    }

    public void glTexFilterFuncSGIS(int n, int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexFilterFuncSGIS(" + n + "," + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glTexFilterFuncSGIS(n, n2, n3, floatBuffer);
        this.println("");
    }

    public void glTexGend(int n, int n2, double d) {
        this.printIndent();
        this.print("glTexGend(" + n + "," + n2 + "," + d + ")");
        this.downstreamGL.glTexGend(n, n2, d);
        this.println("");
    }

    public void glTexGendv(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glTexGendv(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexGendv(n, n2, dArray);
        this.println("");
    }

    public void glTexGendv(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexGendv(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glTexGendv(n, n2, doubleBuffer);
        this.println("");
    }

    public void glTexGenf(int n, int n2, float f) {
        this.printIndent();
        this.print("glTexGenf(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glTexGenf(n, n2, f);
        this.println("");
    }

    public void glTexGenfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glTexGenfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexGenfv(n, n2, fArray);
        this.println("");
    }

    public void glTexGenfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexGenfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glTexGenfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glTexGeni(int n, int n2, int n3) {
        this.printIndent();
        this.print("glTexGeni(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glTexGeni(n, n2, n3);
        this.println("");
    }

    public void glTexGeniv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glTexGeniv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexGeniv(n, n2, nArray);
        this.println("");
    }

    public void glTexGeniv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexGeniv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glTexGeniv(n, n2, intBuffer);
        this.println("");
    }

    public void glTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean[] blArray) {
        this.printIndent();
        this.print("glTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexImage1D(n, n2, n3, n4, n5, n6, n7, blArray);
        this.println("");
    }

    public void glTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, char[] cArray) {
        this.printIndent();
        this.print("glTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexImage1D(n, n2, n3, n4, n5, n6, n7, cArray);
        this.println("");
    }

    public void glTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray) {
        this.printIndent();
        this.print("glTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexImage1D(n, n2, n3, n4, n5, n6, n7, byArray);
        this.println("");
    }

    public void glTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, short[] sArray) {
        this.printIndent();
        this.print("glTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexImage1D(n, n2, n3, n4, n5, n6, n7, sArray);
        this.println("");
    }

    public void glTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        this.printIndent();
        this.print("glTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexImage1D(n, n2, n3, n4, n5, n6, n7, nArray);
        this.println("");
    }

    public void glTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, long[] lArray) {
        this.printIndent();
        this.print("glTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexImage1D(n, n2, n3, n4, n5, n6, n7, lArray);
        this.println("");
    }

    public void glTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray) {
        this.printIndent();
        this.print("glTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexImage1D(n, n2, n3, n4, n5, n6, n7, fArray);
        this.println("");
    }

    public void glTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, double[] dArray) {
        this.printIndent();
        this.print("glTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexImage1D(n, n2, n3, n4, n5, n6, n7, dArray);
        this.println("");
    }

    public void glTexImage1D(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        this.printIndent();
        this.print("glTexImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + buffer + ")");
        this.downstreamGL.glTexImage1D(n, n2, n3, n4, n5, n6, n7, buffer);
        this.println("");
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean[] blArray) {
        this.printIndent();
        this.print("glTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, blArray);
        this.println("");
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, char[] cArray) {
        this.printIndent();
        this.print("glTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, cArray);
        this.println("");
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.printIndent();
        this.print("glTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, byArray);
        this.println("");
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray) {
        this.printIndent();
        this.print("glTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, sArray);
        this.println("");
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        this.printIndent();
        this.print("glTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, nArray);
        this.println("");
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long[] lArray) {
        this.printIndent();
        this.print("glTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, lArray);
        this.println("");
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        this.printIndent();
        this.print("glTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, fArray);
        this.println("");
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double[] dArray) {
        this.printIndent();
        this.print("glTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, dArray);
        this.println("");
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.printIndent();
        this.print("glTexImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + buffer + ")");
        this.downstreamGL.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.println("");
    }

    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean[] blArray) {
        this.printIndent();
        this.print("glTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, blArray);
        this.println("");
    }

    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, char[] cArray) {
        this.printIndent();
        this.print("glTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, cArray);
        this.println("");
    }

    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte[] byArray) {
        this.printIndent();
        this.print("glTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, byArray);
        this.println("");
    }

    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, short[] sArray) {
        this.printIndent();
        this.print("glTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, sArray);
        this.println("");
    }

    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray) {
        this.printIndent();
        this.print("glTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, nArray);
        this.println("");
    }

    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long[] lArray) {
        this.printIndent();
        this.print("glTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, lArray);
        this.println("");
    }

    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float[] fArray) {
        this.printIndent();
        this.print("glTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, fArray);
        this.println("");
    }

    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, double[] dArray) {
        this.printIndent();
        this.print("glTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, dArray);
        this.println("");
    }

    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        this.printIndent();
        this.print("glTexImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + buffer + ")");
        this.downstreamGL.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, buffer);
        this.println("");
    }

    public void glTexImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean[] blArray) {
        this.printIndent();
        this.print("glTexImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, blArray);
        this.println("");
    }

    public void glTexImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, char[] cArray) {
        this.printIndent();
        this.print("glTexImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, cArray);
        this.println("");
    }

    public void glTexImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte[] byArray) {
        this.printIndent();
        this.print("glTexImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, byArray);
        this.println("");
    }

    public void glTexImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, short[] sArray) {
        this.printIndent();
        this.print("glTexImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, sArray);
        this.println("");
    }

    public void glTexImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray) {
        this.printIndent();
        this.print("glTexImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, nArray);
        this.println("");
    }

    public void glTexImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long[] lArray) {
        this.printIndent();
        this.print("glTexImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, lArray);
        this.println("");
    }

    public void glTexImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float[] fArray) {
        this.printIndent();
        this.print("glTexImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, fArray);
        this.println("");
    }

    public void glTexImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, double[] dArray) {
        this.printIndent();
        this.print("glTexImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, dArray);
        this.println("");
    }

    public void glTexImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        this.printIndent();
        this.print("glTexImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + buffer + ")");
        this.downstreamGL.glTexImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, buffer);
        this.println("");
    }

    public void glTexImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean[] blArray) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, blArray);
        this.println("");
    }

    public void glTexImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, char[] cArray) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, cArray);
        this.println("");
    }

    public void glTexImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, byte[] byArray) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, byArray);
        this.println("");
    }

    public void glTexImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, short[] sArray) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, sArray);
        this.println("");
    }

    public void glTexImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, nArray);
        this.println("");
    }

    public void glTexImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long[] lArray) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, lArray);
        this.println("");
    }

    public void glTexImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, float[] fArray) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, fArray);
        this.println("");
    }

    public void glTexImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, double[] dArray) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, dArray);
        this.println("");
    }

    public void glTexImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + buffer + ")");
        this.downstreamGL.glTexImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, buffer);
        this.println("");
    }

    public void glTexParameterf(int n, int n2, float f) {
        this.printIndent();
        this.print("glTexParameterf(" + n + "," + n2 + "," + f + ")");
        this.downstreamGL.glTexParameterf(n, n2, f);
        this.println("");
    }

    public void glTexParameterfv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glTexParameterfv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexParameterfv(n, n2, fArray);
        this.println("");
    }

    public void glTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexParameterfv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glTexParameterfv(n, n2, floatBuffer);
        this.println("");
    }

    public void glTexParameteri(int n, int n2, int n3) {
        this.printIndent();
        this.print("glTexParameteri(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glTexParameteri(n, n2, n3);
        this.println("");
    }

    public void glTexParameteriv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glTexParameteriv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexParameteriv(n, n2, nArray);
        this.println("");
    }

    public void glTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexParameteriv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glTexParameteriv(n, n2, intBuffer);
        this.println("");
    }

    public void glTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexSubImage1D(n, n2, n3, n4, n5, n6, blArray);
        this.println("");
    }

    public void glTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexSubImage1D(n, n2, n3, n4, n5, n6, cArray);
        this.println("");
    }

    public void glTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexSubImage1D(n, n2, n3, n4, n5, n6, byArray);
        this.println("");
    }

    public void glTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexSubImage1D(n, n2, n3, n4, n5, n6, sArray);
        this.println("");
    }

    public void glTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexSubImage1D(n, n2, n3, n4, n5, n6, nArray);
        this.println("");
    }

    public void glTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexSubImage1D(n, n2, n3, n4, n5, n6, lArray);
        this.println("");
    }

    public void glTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexSubImage1D(n, n2, n3, n4, n5, n6, fArray);
        this.println("");
    }

    public void glTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexSubImage1D(n, n2, n3, n4, n5, n6, dArray);
        this.println("");
    }

    public void glTexSubImage1D(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage1D(n, n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    public void glTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, boolean[] blArray) {
        this.printIndent();
        this.print("glTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexSubImage1DEXT(n, n2, n3, n4, n5, n6, blArray);
        this.println("");
    }

    public void glTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, char[] cArray) {
        this.printIndent();
        this.print("glTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexSubImage1DEXT(n, n2, n3, n4, n5, n6, cArray);
        this.println("");
    }

    public void glTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.printIndent();
        this.print("glTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexSubImage1DEXT(n, n2, n3, n4, n5, n6, byArray);
        this.println("");
    }

    public void glTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        this.printIndent();
        this.print("glTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexSubImage1DEXT(n, n2, n3, n4, n5, n6, sArray);
        this.println("");
    }

    public void glTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.printIndent();
        this.print("glTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexSubImage1DEXT(n, n2, n3, n4, n5, n6, nArray);
        this.println("");
    }

    public void glTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, long[] lArray) {
        this.printIndent();
        this.print("glTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexSubImage1DEXT(n, n2, n3, n4, n5, n6, lArray);
        this.println("");
    }

    public void glTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.printIndent();
        this.print("glTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexSubImage1DEXT(n, n2, n3, n4, n5, n6, fArray);
        this.println("");
    }

    public void glTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.printIndent();
        this.print("glTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexSubImage1DEXT(n, n2, n3, n4, n5, n6, dArray);
        this.println("");
    }

    public void glTexSubImage1DEXT(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage1DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage1DEXT(n, n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean[] blArray) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, blArray);
        this.println("");
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, char[] cArray) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, cArray);
        this.println("");
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, byArray);
        this.println("");
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, sArray);
        this.println("");
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, nArray);
        this.println("");
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long[] lArray) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, lArray);
        this.println("");
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, fArray);
        this.println("");
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double[] dArray) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, dArray);
        this.println("");
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.println("");
    }

    public void glTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean[] blArray) {
        this.printIndent();
        this.print("glTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8, blArray);
        this.println("");
    }

    public void glTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, char[] cArray) {
        this.printIndent();
        this.print("glTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8, cArray);
        this.println("");
    }

    public void glTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.printIndent();
        this.print("glTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8, byArray);
        this.println("");
    }

    public void glTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray) {
        this.printIndent();
        this.print("glTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8, sArray);
        this.println("");
    }

    public void glTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        this.printIndent();
        this.print("glTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8, nArray);
        this.println("");
    }

    public void glTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long[] lArray) {
        this.printIndent();
        this.print("glTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8, lArray);
        this.println("");
    }

    public void glTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        this.printIndent();
        this.print("glTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8, fArray);
        this.println("");
    }

    public void glTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double[] dArray) {
        this.printIndent();
        this.print("glTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8, dArray);
        this.println("");
    }

    public void glTexSubImage2DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage2DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage2DEXT(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.println("");
    }

    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean[] blArray) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, blArray);
        this.println("");
    }

    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, char[] cArray) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, cArray);
        this.println("");
    }

    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, byte[] byArray) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, byArray);
        this.println("");
    }

    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, short[] sArray) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, sArray);
        this.println("");
    }

    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, nArray);
        this.println("");
    }

    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long[] lArray) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, lArray);
        this.println("");
    }

    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, float[] fArray) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, fArray);
        this.println("");
    }

    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, double[] dArray) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, dArray);
        this.println("");
    }

    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, buffer);
        this.println("");
    }

    public void glTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean[] blArray) {
        this.printIndent();
        this.print("glTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, blArray);
        this.println("");
    }

    public void glTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, char[] cArray) {
        this.printIndent();
        this.print("glTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, cArray);
        this.println("");
    }

    public void glTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, byte[] byArray) {
        this.printIndent();
        this.print("glTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, byArray);
        this.println("");
    }

    public void glTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, short[] sArray) {
        this.printIndent();
        this.print("glTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, sArray);
        this.println("");
    }

    public void glTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray) {
        this.printIndent();
        this.print("glTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, nArray);
        this.println("");
    }

    public void glTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long[] lArray) {
        this.printIndent();
        this.print("glTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, lArray);
        this.println("");
    }

    public void glTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, float[] fArray) {
        this.printIndent();
        this.print("glTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, fArray);
        this.println("");
    }

    public void glTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, double[] dArray) {
        this.printIndent();
        this.print("glTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, dArray);
        this.println("");
    }

    public void glTexSubImage3DEXT(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage3DEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage3DEXT(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, buffer);
        this.println("");
    }

    public void glTexSubImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean[] blArray) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, blArray);
        this.println("");
    }

    public void glTexSubImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, char[] cArray) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, cArray);
        this.println("");
    }

    public void glTexSubImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, byte[] byArray) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, byArray);
        this.println("");
    }

    public void glTexSubImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, short[] sArray) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, sArray);
        this.println("");
    }

    public void glTexSubImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, nArray);
        this.println("");
    }

    public void glTexSubImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, long[] lArray) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, lArray);
        this.println("");
    }

    public void glTexSubImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, float[] fArray) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, fArray);
        this.println("");
    }

    public void glTexSubImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, double[] dArray) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, dArray);
        this.println("");
    }

    public void glTexSubImage4DSGIS(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, buffer);
        this.println("");
    }

    public void glTextureColorMaskSGIS(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.printIndent();
        this.print("glTextureColorMaskSGIS(" + bl + "," + bl2 + "," + bl3 + "," + bl4 + ")");
        this.downstreamGL.glTextureColorMaskSGIS(bl, bl2, bl3, bl4);
        this.println("");
    }

    public void glTextureLightEXT(int n) {
        this.printIndent();
        this.print("glTextureLightEXT(" + n + ")");
        this.downstreamGL.glTextureLightEXT(n);
        this.println("");
    }

    public void glTextureMaterialEXT(int n, int n2) {
        this.printIndent();
        this.print("glTextureMaterialEXT(" + n + "," + n2 + ")");
        this.downstreamGL.glTextureMaterialEXT(n, n2);
        this.println("");
    }

    public void glTextureNormalEXT(int n) {
        this.printIndent();
        this.print("glTextureNormalEXT(" + n + ")");
        this.downstreamGL.glTextureNormalEXT(n);
        this.println("");
    }

    public void glTextureRangeAPPLE(int n, int n2, boolean[] blArray) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n + "," + n2 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glTextureRangeAPPLE(n, n2, blArray);
        this.println("");
    }

    public void glTextureRangeAPPLE(int n, int n2, char[] cArray) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n + "," + n2 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glTextureRangeAPPLE(n, n2, cArray);
        this.println("");
    }

    public void glTextureRangeAPPLE(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glTextureRangeAPPLE(n, n2, byArray);
        this.println("");
    }

    public void glTextureRangeAPPLE(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glTextureRangeAPPLE(n, n2, sArray);
        this.println("");
    }

    public void glTextureRangeAPPLE(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glTextureRangeAPPLE(n, n2, nArray);
        this.println("");
    }

    public void glTextureRangeAPPLE(int n, int n2, long[] lArray) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n + "," + n2 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glTextureRangeAPPLE(n, n2, lArray);
        this.println("");
    }

    public void glTextureRangeAPPLE(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glTextureRangeAPPLE(n, n2, fArray);
        this.println("");
    }

    public void glTextureRangeAPPLE(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glTextureRangeAPPLE(n, n2, dArray);
        this.println("");
    }

    public void glTextureRangeAPPLE(int n, int n2, Buffer buffer) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n + "," + n2 + "," + buffer + ")");
        this.downstreamGL.glTextureRangeAPPLE(n, n2, buffer);
        this.println("");
    }

    public void glTrackMatrixNV(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glTrackMatrixNV(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glTrackMatrixNV(n, n2, n3, n4);
        this.println("");
    }

    public void glTranslated(double d, double d2, double d3) {
        this.printIndent();
        this.print("glTranslated(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glTranslated(d, d2, d3);
        this.println("");
    }

    public void glTranslatef(float f, float f2, float f3) {
        this.printIndent();
        this.print("glTranslatef(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glTranslatef(f, f2, f3);
        this.println("");
    }

    public void glUniform1f(int n, float f) {
        this.printIndent();
        this.print("glUniform1f(" + n + "," + f + ")");
        this.downstreamGL.glUniform1f(n, f);
        this.println("");
    }

    public void glUniform1fARB(int n, float f) {
        this.printIndent();
        this.print("glUniform1fARB(" + n + "," + f + ")");
        this.downstreamGL.glUniform1fARB(n, f);
        this.println("");
    }

    public void glUniform1fv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glUniform1fv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniform1fv(n, n2, fArray);
        this.println("");
    }

    public void glUniform1fv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform1fv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform1fv(n, n2, floatBuffer);
        this.println("");
    }

    public void glUniform1fvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glUniform1fvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniform1fvARB(n, n2, fArray);
        this.println("");
    }

    public void glUniform1fvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform1fvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform1fvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glUniform1i(int n, int n2) {
        this.printIndent();
        this.print("glUniform1i(" + n + "," + n2 + ")");
        this.downstreamGL.glUniform1i(n, n2);
        this.println("");
    }

    public void glUniform1iARB(int n, int n2) {
        this.printIndent();
        this.print("glUniform1iARB(" + n + "," + n2 + ")");
        this.downstreamGL.glUniform1iARB(n, n2);
        this.println("");
    }

    public void glUniform1iv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glUniform1iv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glUniform1iv(n, n2, nArray);
        this.println("");
    }

    public void glUniform1iv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform1iv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glUniform1iv(n, n2, intBuffer);
        this.println("");
    }

    public void glUniform1ivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glUniform1ivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glUniform1ivARB(n, n2, nArray);
        this.println("");
    }

    public void glUniform1ivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform1ivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glUniform1ivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glUniform2f(int n, float f, float f2) {
        this.printIndent();
        this.print("glUniform2f(" + n + "," + f + "," + f2 + ")");
        this.downstreamGL.glUniform2f(n, f, f2);
        this.println("");
    }

    public void glUniform2fARB(int n, float f, float f2) {
        this.printIndent();
        this.print("glUniform2fARB(" + n + "," + f + "," + f2 + ")");
        this.downstreamGL.glUniform2fARB(n, f, f2);
        this.println("");
    }

    public void glUniform2fv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glUniform2fv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniform2fv(n, n2, fArray);
        this.println("");
    }

    public void glUniform2fv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform2fv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform2fv(n, n2, floatBuffer);
        this.println("");
    }

    public void glUniform2fvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glUniform2fvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniform2fvARB(n, n2, fArray);
        this.println("");
    }

    public void glUniform2fvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform2fvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform2fvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glUniform2i(int n, int n2, int n3) {
        this.printIndent();
        this.print("glUniform2i(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glUniform2i(n, n2, n3);
        this.println("");
    }

    public void glUniform2iARB(int n, int n2, int n3) {
        this.printIndent();
        this.print("glUniform2iARB(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glUniform2iARB(n, n2, n3);
        this.println("");
    }

    public void glUniform2iv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glUniform2iv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glUniform2iv(n, n2, nArray);
        this.println("");
    }

    public void glUniform2iv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform2iv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glUniform2iv(n, n2, intBuffer);
        this.println("");
    }

    public void glUniform2ivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glUniform2ivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glUniform2ivARB(n, n2, nArray);
        this.println("");
    }

    public void glUniform2ivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform2ivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glUniform2ivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glUniform3f(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glUniform3f(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glUniform3f(n, f, f2, f3);
        this.println("");
    }

    public void glUniform3fARB(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glUniform3fARB(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glUniform3fARB(n, f, f2, f3);
        this.println("");
    }

    public void glUniform3fv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glUniform3fv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniform3fv(n, n2, fArray);
        this.println("");
    }

    public void glUniform3fv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform3fv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform3fv(n, n2, floatBuffer);
        this.println("");
    }

    public void glUniform3fvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glUniform3fvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniform3fvARB(n, n2, fArray);
        this.println("");
    }

    public void glUniform3fvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform3fvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform3fvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glUniform3i(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glUniform3i(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glUniform3i(n, n2, n3, n4);
        this.println("");
    }

    public void glUniform3iARB(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glUniform3iARB(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glUniform3iARB(n, n2, n3, n4);
        this.println("");
    }

    public void glUniform3iv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glUniform3iv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glUniform3iv(n, n2, nArray);
        this.println("");
    }

    public void glUniform3iv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform3iv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glUniform3iv(n, n2, intBuffer);
        this.println("");
    }

    public void glUniform3ivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glUniform3ivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glUniform3ivARB(n, n2, nArray);
        this.println("");
    }

    public void glUniform3ivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform3ivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glUniform3ivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glUniform4f(int n, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glUniform4f(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glUniform4f(n, f, f2, f3, f4);
        this.println("");
    }

    public void glUniform4fARB(int n, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glUniform4fARB(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glUniform4fARB(n, f, f2, f3, f4);
        this.println("");
    }

    public void glUniform4fv(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glUniform4fv(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniform4fv(n, n2, fArray);
        this.println("");
    }

    public void glUniform4fv(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform4fv(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform4fv(n, n2, floatBuffer);
        this.println("");
    }

    public void glUniform4fvARB(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glUniform4fvARB(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniform4fvARB(n, n2, fArray);
        this.println("");
    }

    public void glUniform4fvARB(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform4fvARB(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform4fvARB(n, n2, floatBuffer);
        this.println("");
    }

    public void glUniform4i(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glUniform4i(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glUniform4i(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glUniform4iARB(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glUniform4iARB(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glUniform4iARB(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glUniform4iv(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glUniform4iv(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glUniform4iv(n, n2, nArray);
        this.println("");
    }

    public void glUniform4iv(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform4iv(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glUniform4iv(n, n2, intBuffer);
        this.println("");
    }

    public void glUniform4ivARB(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glUniform4ivARB(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glUniform4ivARB(n, n2, nArray);
        this.println("");
    }

    public void glUniform4ivARB(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform4ivARB(" + n + "," + n2 + "," + intBuffer + ")");
        this.downstreamGL.glUniform4ivARB(n, n2, intBuffer);
        this.println("");
    }

    public void glUniformMatrix2fv(int n, int n2, boolean bl, float[] fArray) {
        this.printIndent();
        this.print("glUniformMatrix2fv(" + n + "," + n2 + "," + bl + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniformMatrix2fv(n, n2, bl, fArray);
        this.println("");
    }

    public void glUniformMatrix2fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix2fv(" + n + "," + n2 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix2fv(n, n2, bl, floatBuffer);
        this.println("");
    }

    public void glUniformMatrix2fvARB(int n, int n2, boolean bl, float[] fArray) {
        this.printIndent();
        this.print("glUniformMatrix2fvARB(" + n + "," + n2 + "," + bl + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniformMatrix2fvARB(n, n2, bl, fArray);
        this.println("");
    }

    public void glUniformMatrix2fvARB(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix2fvARB(" + n + "," + n2 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix2fvARB(n, n2, bl, floatBuffer);
        this.println("");
    }

    public void glUniformMatrix3fv(int n, int n2, boolean bl, float[] fArray) {
        this.printIndent();
        this.print("glUniformMatrix3fv(" + n + "," + n2 + "," + bl + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniformMatrix3fv(n, n2, bl, fArray);
        this.println("");
    }

    public void glUniformMatrix3fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix3fv(" + n + "," + n2 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix3fv(n, n2, bl, floatBuffer);
        this.println("");
    }

    public void glUniformMatrix3fvARB(int n, int n2, boolean bl, float[] fArray) {
        this.printIndent();
        this.print("glUniformMatrix3fvARB(" + n + "," + n2 + "," + bl + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniformMatrix3fvARB(n, n2, bl, fArray);
        this.println("");
    }

    public void glUniformMatrix3fvARB(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix3fvARB(" + n + "," + n2 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix3fvARB(n, n2, bl, floatBuffer);
        this.println("");
    }

    public void glUniformMatrix4fv(int n, int n2, boolean bl, float[] fArray) {
        this.printIndent();
        this.print("glUniformMatrix4fv(" + n + "," + n2 + "," + bl + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniformMatrix4fv(n, n2, bl, fArray);
        this.println("");
    }

    public void glUniformMatrix4fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix4fv(" + n + "," + n2 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix4fv(n, n2, bl, floatBuffer);
        this.println("");
    }

    public void glUniformMatrix4fvARB(int n, int n2, boolean bl, float[] fArray) {
        this.printIndent();
        this.print("glUniformMatrix4fvARB(" + n + "," + n2 + "," + bl + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glUniformMatrix4fvARB(n, n2, bl, fArray);
        this.println("");
    }

    public void glUniformMatrix4fvARB(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix4fvARB(" + n + "," + n2 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix4fvARB(n, n2, bl, floatBuffer);
        this.println("");
    }

    public void glUnlockArraysEXT() {
        this.printIndent();
        this.print("glUnlockArraysEXT()");
        this.downstreamGL.glUnlockArraysEXT();
        this.println("");
    }

    public boolean glUnmapBuffer(int n) {
        this.printIndent();
        this.print("glUnmapBuffer(" + n + ")");
        boolean bl = this.downstreamGL.glUnmapBuffer(n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glUnmapBufferARB(int n) {
        this.printIndent();
        this.print("glUnmapBufferARB(" + n + ")");
        boolean bl = this.downstreamGL.glUnmapBufferARB(n);
        this.println(" = " + bl);
        return bl;
    }

    public void glUpdateObjectBufferATI(int n, int n2, int n3, boolean[] blArray, int n4) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + "," + n4 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n, n2, n3, blArray, n4);
        this.println("");
    }

    public void glUpdateObjectBufferATI(int n, int n2, int n3, char[] cArray, int n4) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + "," + n4 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n, n2, n3, cArray, n4);
        this.println("");
    }

    public void glUpdateObjectBufferATI(int n, int n2, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n, n2, n3, byArray, n4);
        this.println("");
    }

    public void glUpdateObjectBufferATI(int n, int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n, n2, n3, sArray, n4);
        this.println("");
    }

    public void glUpdateObjectBufferATI(int n, int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n, n2, n3, nArray, n4);
        this.println("");
    }

    public void glUpdateObjectBufferATI(int n, int n2, int n3, long[] lArray, int n4) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + n4 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n, n2, n3, lArray, n4);
        this.println("");
    }

    public void glUpdateObjectBufferATI(int n, int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n, n2, n3, fArray, n4);
        this.println("");
    }

    public void glUpdateObjectBufferATI(int n, int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n, n2, n3, dArray, n4);
        this.println("");
    }

    public void glUpdateObjectBufferATI(int n, int n2, int n3, Buffer buffer, int n4) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n + "," + n2 + "," + n3 + "," + buffer + "," + n4 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n, n2, n3, buffer, n4);
        this.println("");
    }

    public void glUseProgram(int n) {
        this.printIndent();
        this.print("glUseProgram(" + n + ")");
        this.downstreamGL.glUseProgram(n);
        this.println("");
    }

    public void glUseProgramObjectARB(int n) {
        this.printIndent();
        this.print("glUseProgramObjectARB(" + n + ")");
        this.downstreamGL.glUseProgramObjectARB(n);
        this.println("");
    }

    public void glValidateProgram(int n) {
        this.printIndent();
        this.print("glValidateProgram(" + n + ")");
        this.downstreamGL.glValidateProgram(n);
        this.println("");
    }

    public void glValidateProgramARB(int n) {
        this.printIndent();
        this.print("glValidateProgramARB(" + n + ")");
        this.downstreamGL.glValidateProgramARB(n);
        this.println("");
    }

    public void glVariantArrayObjectATI(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glVariantArrayObjectATI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glVariantArrayObjectATI(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glVariantPointerEXT(int n, int n2, int n3, boolean[] blArray) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glVariantPointerEXT(n, n2, n3, blArray);
        this.println("");
    }

    public void glVariantPointerEXT(int n, int n2, int n3, char[] cArray) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glVariantPointerEXT(n, n2, n3, cArray);
        this.println("");
    }

    public void glVariantPointerEXT(int n, int n2, int n3, byte[] byArray) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVariantPointerEXT(n, n2, n3, byArray);
        this.println("");
    }

    public void glVariantPointerEXT(int n, int n2, int n3, short[] sArray) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVariantPointerEXT(n, n2, n3, sArray);
        this.println("");
    }

    public void glVariantPointerEXT(int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVariantPointerEXT(n, n2, n3, nArray);
        this.println("");
    }

    public void glVariantPointerEXT(int n, int n2, int n3, long[] lArray) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glVariantPointerEXT(n, n2, n3, lArray);
        this.println("");
    }

    public void glVariantPointerEXT(int n, int n2, int n3, float[] fArray) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVariantPointerEXT(n, n2, n3, fArray);
        this.println("");
    }

    public void glVariantPointerEXT(int n, int n2, int n3, double[] dArray) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVariantPointerEXT(n, n2, n3, dArray);
        this.println("");
    }

    public void glVariantPointerEXT(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glVariantPointerEXT(n, n2, n3, buffer);
        this.println("");
    }

    public void glVariantbvEXT(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVariantbvEXT(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVariantbvEXT(n, byArray);
        this.println("");
    }

    public void glVariantbvEXT(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVariantbvEXT(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVariantbvEXT(n, byteBuffer);
        this.println("");
    }

    public void glVariantdvEXT(int n, double[] dArray) {
        this.printIndent();
        this.print("glVariantdvEXT(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVariantdvEXT(n, dArray);
        this.println("");
    }

    public void glVariantdvEXT(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVariantdvEXT(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVariantdvEXT(n, doubleBuffer);
        this.println("");
    }

    public void glVariantfvEXT(int n, float[] fArray) {
        this.printIndent();
        this.print("glVariantfvEXT(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVariantfvEXT(n, fArray);
        this.println("");
    }

    public void glVariantfvEXT(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVariantfvEXT(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVariantfvEXT(n, floatBuffer);
        this.println("");
    }

    public void glVariantivEXT(int n, int[] nArray) {
        this.printIndent();
        this.print("glVariantivEXT(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVariantivEXT(n, nArray);
        this.println("");
    }

    public void glVariantivEXT(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVariantivEXT(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVariantivEXT(n, intBuffer);
        this.println("");
    }

    public void glVariantsvEXT(int n, short[] sArray) {
        this.printIndent();
        this.print("glVariantsvEXT(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVariantsvEXT(n, sArray);
        this.println("");
    }

    public void glVariantsvEXT(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVariantsvEXT(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVariantsvEXT(n, shortBuffer);
        this.println("");
    }

    public void glVariantubvEXT(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVariantubvEXT(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVariantubvEXT(n, byArray);
        this.println("");
    }

    public void glVariantubvEXT(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVariantubvEXT(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVariantubvEXT(n, byteBuffer);
        this.println("");
    }

    public void glVariantuivEXT(int n, int[] nArray) {
        this.printIndent();
        this.print("glVariantuivEXT(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVariantuivEXT(n, nArray);
        this.println("");
    }

    public void glVariantuivEXT(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVariantuivEXT(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVariantuivEXT(n, intBuffer);
        this.println("");
    }

    public void glVariantusvEXT(int n, short[] sArray) {
        this.printIndent();
        this.print("glVariantusvEXT(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVariantusvEXT(n, sArray);
        this.println("");
    }

    public void glVariantusvEXT(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVariantusvEXT(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVariantusvEXT(n, shortBuffer);
        this.println("");
    }

    public void glVertex2d(double d, double d2) {
        this.printIndent();
        this.print("glVertex2d(" + d + "," + d2 + ")");
        this.downstreamGL.glVertex2d(d, d2);
        this.println("");
    }

    public void glVertex2dv(double[] dArray) {
        this.printIndent();
        this.print("glVertex2dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertex2dv(dArray);
        this.println("");
    }

    public void glVertex2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertex2dv(" + doubleBuffer + ")");
        this.downstreamGL.glVertex2dv(doubleBuffer);
        this.println("");
    }

    public void glVertex2f(float f, float f2) {
        this.printIndent();
        this.print("glVertex2f(" + f + "," + f2 + ")");
        this.downstreamGL.glVertex2f(f, f2);
        this.println("");
    }

    public void glVertex2fv(float[] fArray) {
        this.printIndent();
        this.print("glVertex2fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertex2fv(fArray);
        this.println("");
    }

    public void glVertex2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertex2fv(" + floatBuffer + ")");
        this.downstreamGL.glVertex2fv(floatBuffer);
        this.println("");
    }

    public void glVertex2hNV(short s, short s2) {
        this.printIndent();
        this.print("glVertex2hNV(" + s + "," + s2 + ")");
        this.downstreamGL.glVertex2hNV(s, s2);
        this.println("");
    }

    public void glVertex2hvNV(short[] sArray) {
        this.printIndent();
        this.print("glVertex2hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertex2hvNV(sArray);
        this.println("");
    }

    public void glVertex2hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex2hvNV(" + shortBuffer + ")");
        this.downstreamGL.glVertex2hvNV(shortBuffer);
        this.println("");
    }

    public void glVertex2i(int n, int n2) {
        this.printIndent();
        this.print("glVertex2i(" + n + "," + n2 + ")");
        this.downstreamGL.glVertex2i(n, n2);
        this.println("");
    }

    public void glVertex2iv(int[] nArray) {
        this.printIndent();
        this.print("glVertex2iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertex2iv(nArray);
        this.println("");
    }

    public void glVertex2iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertex2iv(" + intBuffer + ")");
        this.downstreamGL.glVertex2iv(intBuffer);
        this.println("");
    }

    public void glVertex2s(short s, short s2) {
        this.printIndent();
        this.print("glVertex2s(" + s + "," + s2 + ")");
        this.downstreamGL.glVertex2s(s, s2);
        this.println("");
    }

    public void glVertex2sv(short[] sArray) {
        this.printIndent();
        this.print("glVertex2sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertex2sv(sArray);
        this.println("");
    }

    public void glVertex2sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex2sv(" + shortBuffer + ")");
        this.downstreamGL.glVertex2sv(shortBuffer);
        this.println("");
    }

    public void glVertex3d(double d, double d2, double d3) {
        this.printIndent();
        this.print("glVertex3d(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glVertex3d(d, d2, d3);
        this.println("");
    }

    public void glVertex3dv(double[] dArray) {
        this.printIndent();
        this.print("glVertex3dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertex3dv(dArray);
        this.println("");
    }

    public void glVertex3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertex3dv(" + doubleBuffer + ")");
        this.downstreamGL.glVertex3dv(doubleBuffer);
        this.println("");
    }

    public void glVertex3f(float f, float f2, float f3) {
        this.printIndent();
        this.print("glVertex3f(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glVertex3f(f, f2, f3);
        this.println("");
    }

    public void glVertex3fv(float[] fArray) {
        this.printIndent();
        this.print("glVertex3fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertex3fv(fArray);
        this.println("");
    }

    public void glVertex3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertex3fv(" + floatBuffer + ")");
        this.downstreamGL.glVertex3fv(floatBuffer);
        this.println("");
    }

    public void glVertex3hNV(short s, short s2, short s3) {
        this.printIndent();
        this.print("glVertex3hNV(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertex3hNV(s, s2, s3);
        this.println("");
    }

    public void glVertex3hvNV(short[] sArray) {
        this.printIndent();
        this.print("glVertex3hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertex3hvNV(sArray);
        this.println("");
    }

    public void glVertex3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glVertex3hvNV(shortBuffer);
        this.println("");
    }

    public void glVertex3i(int n, int n2, int n3) {
        this.printIndent();
        this.print("glVertex3i(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glVertex3i(n, n2, n3);
        this.println("");
    }

    public void glVertex3iv(int[] nArray) {
        this.printIndent();
        this.print("glVertex3iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertex3iv(nArray);
        this.println("");
    }

    public void glVertex3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertex3iv(" + intBuffer + ")");
        this.downstreamGL.glVertex3iv(intBuffer);
        this.println("");
    }

    public void glVertex3s(short s, short s2, short s3) {
        this.printIndent();
        this.print("glVertex3s(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertex3s(s, s2, s3);
        this.println("");
    }

    public void glVertex3sv(short[] sArray) {
        this.printIndent();
        this.print("glVertex3sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertex3sv(sArray);
        this.println("");
    }

    public void glVertex3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex3sv(" + shortBuffer + ")");
        this.downstreamGL.glVertex3sv(shortBuffer);
        this.println("");
    }

    public void glVertex4d(double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertex4d(" + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertex4d(d, d2, d3, d4);
        this.println("");
    }

    public void glVertex4dv(double[] dArray) {
        this.printIndent();
        this.print("glVertex4dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertex4dv(dArray);
        this.println("");
    }

    public void glVertex4dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertex4dv(" + doubleBuffer + ")");
        this.downstreamGL.glVertex4dv(doubleBuffer);
        this.println("");
    }

    public void glVertex4f(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertex4f(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertex4f(f, f2, f3, f4);
        this.println("");
    }

    public void glVertex4fv(float[] fArray) {
        this.printIndent();
        this.print("glVertex4fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertex4fv(fArray);
        this.println("");
    }

    public void glVertex4fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertex4fv(" + floatBuffer + ")");
        this.downstreamGL.glVertex4fv(floatBuffer);
        this.println("");
    }

    public void glVertex4hNV(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertex4hNV(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertex4hNV(s, s2, s3, s4);
        this.println("");
    }

    public void glVertex4hvNV(short[] sArray) {
        this.printIndent();
        this.print("glVertex4hvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertex4hvNV(sArray);
        this.println("");
    }

    public void glVertex4hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex4hvNV(" + shortBuffer + ")");
        this.downstreamGL.glVertex4hvNV(shortBuffer);
        this.println("");
    }

    public void glVertex4i(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glVertex4i(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glVertex4i(n, n2, n3, n4);
        this.println("");
    }

    public void glVertex4iv(int[] nArray) {
        this.printIndent();
        this.print("glVertex4iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertex4iv(nArray);
        this.println("");
    }

    public void glVertex4iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertex4iv(" + intBuffer + ")");
        this.downstreamGL.glVertex4iv(intBuffer);
        this.println("");
    }

    public void glVertex4s(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertex4s(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertex4s(s, s2, s3, s4);
        this.println("");
    }

    public void glVertex4sv(short[] sArray) {
        this.printIndent();
        this.print("glVertex4sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertex4sv(sArray);
        this.println("");
    }

    public void glVertex4sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex4sv(" + shortBuffer + ")");
        this.downstreamGL.glVertex4sv(shortBuffer);
        this.println("");
    }

    public void glVertexArrayParameteriAPPLE(int n, int n2) {
        this.printIndent();
        this.print("glVertexArrayParameteriAPPLE(" + n + "," + n2 + ")");
        this.downstreamGL.glVertexArrayParameteriAPPLE(n, n2);
        this.println("");
    }

    public void glVertexArrayRangeAPPLE(int n, boolean[] blArray) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n, blArray);
        this.println("");
    }

    public void glVertexArrayRangeAPPLE(int n, char[] cArray) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n, cArray);
        this.println("");
    }

    public void glVertexArrayRangeAPPLE(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n, byArray);
        this.println("");
    }

    public void glVertexArrayRangeAPPLE(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n, sArray);
        this.println("");
    }

    public void glVertexArrayRangeAPPLE(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n, nArray);
        this.println("");
    }

    public void glVertexArrayRangeAPPLE(int n, long[] lArray) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n, lArray);
        this.println("");
    }

    public void glVertexArrayRangeAPPLE(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n, fArray);
        this.println("");
    }

    public void glVertexArrayRangeAPPLE(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n, dArray);
        this.println("");
    }

    public void glVertexArrayRangeAPPLE(int n, Buffer buffer) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n + "," + buffer + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n, buffer);
        this.println("");
    }

    public void glVertexArrayRangeNV(int n, Buffer buffer) {
        this.printIndent();
        this.print("glVertexArrayRangeNV(" + n + "," + buffer + ")");
        this.downstreamGL.glVertexArrayRangeNV(n, buffer);
        this.println("");
    }

    public void glVertexAttrib1d(int n, double d) {
        this.printIndent();
        this.print("glVertexAttrib1d(" + n + "," + d + ")");
        this.downstreamGL.glVertexAttrib1d(n, d);
        this.println("");
    }

    public void glVertexAttrib1dARB(int n, double d) {
        this.printIndent();
        this.print("glVertexAttrib1dARB(" + n + "," + d + ")");
        this.downstreamGL.glVertexAttrib1dARB(n, d);
        this.println("");
    }

    public void glVertexAttrib1dNV(int n, double d) {
        this.printIndent();
        this.print("glVertexAttrib1dNV(" + n + "," + d + ")");
        this.downstreamGL.glVertexAttrib1dNV(n, d);
        this.println("");
    }

    public void glVertexAttrib1dv(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib1dv(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib1dv(n, dArray);
        this.println("");
    }

    public void glVertexAttrib1dv(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1dv(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib1dv(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib1dvARB(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib1dvARB(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib1dvARB(n, dArray);
        this.println("");
    }

    public void glVertexAttrib1dvARB(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1dvARB(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib1dvARB(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib1dvNV(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib1dvNV(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib1dvNV(n, dArray);
        this.println("");
    }

    public void glVertexAttrib1dvNV(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1dvNV(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib1dvNV(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib1f(int n, float f) {
        this.printIndent();
        this.print("glVertexAttrib1f(" + n + "," + f + ")");
        this.downstreamGL.glVertexAttrib1f(n, f);
        this.println("");
    }

    public void glVertexAttrib1fARB(int n, float f) {
        this.printIndent();
        this.print("glVertexAttrib1fARB(" + n + "," + f + ")");
        this.downstreamGL.glVertexAttrib1fARB(n, f);
        this.println("");
    }

    public void glVertexAttrib1fNV(int n, float f) {
        this.printIndent();
        this.print("glVertexAttrib1fNV(" + n + "," + f + ")");
        this.downstreamGL.glVertexAttrib1fNV(n, f);
        this.println("");
    }

    public void glVertexAttrib1fv(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib1fv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib1fv(n, fArray);
        this.println("");
    }

    public void glVertexAttrib1fv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1fv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib1fv(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib1fvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib1fvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib1fvARB(n, fArray);
        this.println("");
    }

    public void glVertexAttrib1fvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1fvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib1fvARB(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib1fvNV(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib1fvNV(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib1fvNV(n, fArray);
        this.println("");
    }

    public void glVertexAttrib1fvNV(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1fvNV(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib1fvNV(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib1hNV(int n, short s) {
        this.printIndent();
        this.print("glVertexAttrib1hNV(" + n + "," + s + ")");
        this.downstreamGL.glVertexAttrib1hNV(n, s);
        this.println("");
    }

    public void glVertexAttrib1hvNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib1hvNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib1hvNV(n, sArray);
        this.println("");
    }

    public void glVertexAttrib1hvNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1hvNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib1hvNV(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib1s(int n, short s) {
        this.printIndent();
        this.print("glVertexAttrib1s(" + n + "," + s + ")");
        this.downstreamGL.glVertexAttrib1s(n, s);
        this.println("");
    }

    public void glVertexAttrib1sARB(int n, short s) {
        this.printIndent();
        this.print("glVertexAttrib1sARB(" + n + "," + s + ")");
        this.downstreamGL.glVertexAttrib1sARB(n, s);
        this.println("");
    }

    public void glVertexAttrib1sNV(int n, short s) {
        this.printIndent();
        this.print("glVertexAttrib1sNV(" + n + "," + s + ")");
        this.downstreamGL.glVertexAttrib1sNV(n, s);
        this.println("");
    }

    public void glVertexAttrib1sv(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib1sv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib1sv(n, sArray);
        this.println("");
    }

    public void glVertexAttrib1sv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1sv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib1sv(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib1svARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib1svARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib1svARB(n, sArray);
        this.println("");
    }

    public void glVertexAttrib1svARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1svARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib1svARB(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib1svNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib1svNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib1svNV(n, sArray);
        this.println("");
    }

    public void glVertexAttrib1svNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1svNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib1svNV(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib2d(int n, double d, double d2) {
        this.printIndent();
        this.print("glVertexAttrib2d(" + n + "," + d + "," + d2 + ")");
        this.downstreamGL.glVertexAttrib2d(n, d, d2);
        this.println("");
    }

    public void glVertexAttrib2dARB(int n, double d, double d2) {
        this.printIndent();
        this.print("glVertexAttrib2dARB(" + n + "," + d + "," + d2 + ")");
        this.downstreamGL.glVertexAttrib2dARB(n, d, d2);
        this.println("");
    }

    public void glVertexAttrib2dNV(int n, double d, double d2) {
        this.printIndent();
        this.print("glVertexAttrib2dNV(" + n + "," + d + "," + d2 + ")");
        this.downstreamGL.glVertexAttrib2dNV(n, d, d2);
        this.println("");
    }

    public void glVertexAttrib2dv(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib2dv(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib2dv(n, dArray);
        this.println("");
    }

    public void glVertexAttrib2dv(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2dv(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib2dv(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib2dvARB(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib2dvARB(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib2dvARB(n, dArray);
        this.println("");
    }

    public void glVertexAttrib2dvARB(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2dvARB(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib2dvARB(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib2dvNV(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib2dvNV(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib2dvNV(n, dArray);
        this.println("");
    }

    public void glVertexAttrib2dvNV(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2dvNV(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib2dvNV(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib2f(int n, float f, float f2) {
        this.printIndent();
        this.print("glVertexAttrib2f(" + n + "," + f + "," + f2 + ")");
        this.downstreamGL.glVertexAttrib2f(n, f, f2);
        this.println("");
    }

    public void glVertexAttrib2fARB(int n, float f, float f2) {
        this.printIndent();
        this.print("glVertexAttrib2fARB(" + n + "," + f + "," + f2 + ")");
        this.downstreamGL.glVertexAttrib2fARB(n, f, f2);
        this.println("");
    }

    public void glVertexAttrib2fNV(int n, float f, float f2) {
        this.printIndent();
        this.print("glVertexAttrib2fNV(" + n + "," + f + "," + f2 + ")");
        this.downstreamGL.glVertexAttrib2fNV(n, f, f2);
        this.println("");
    }

    public void glVertexAttrib2fv(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib2fv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib2fv(n, fArray);
        this.println("");
    }

    public void glVertexAttrib2fv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2fv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib2fv(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib2fvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib2fvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib2fvARB(n, fArray);
        this.println("");
    }

    public void glVertexAttrib2fvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2fvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib2fvARB(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib2fvNV(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib2fvNV(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib2fvNV(n, fArray);
        this.println("");
    }

    public void glVertexAttrib2fvNV(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2fvNV(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib2fvNV(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib2hNV(int n, short s, short s2) {
        this.printIndent();
        this.print("glVertexAttrib2hNV(" + n + "," + s + "," + s2 + ")");
        this.downstreamGL.glVertexAttrib2hNV(n, s, s2);
        this.println("");
    }

    public void glVertexAttrib2hvNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib2hvNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib2hvNV(n, sArray);
        this.println("");
    }

    public void glVertexAttrib2hvNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2hvNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib2hvNV(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib2s(int n, short s, short s2) {
        this.printIndent();
        this.print("glVertexAttrib2s(" + n + "," + s + "," + s2 + ")");
        this.downstreamGL.glVertexAttrib2s(n, s, s2);
        this.println("");
    }

    public void glVertexAttrib2sARB(int n, short s, short s2) {
        this.printIndent();
        this.print("glVertexAttrib2sARB(" + n + "," + s + "," + s2 + ")");
        this.downstreamGL.glVertexAttrib2sARB(n, s, s2);
        this.println("");
    }

    public void glVertexAttrib2sNV(int n, short s, short s2) {
        this.printIndent();
        this.print("glVertexAttrib2sNV(" + n + "," + s + "," + s2 + ")");
        this.downstreamGL.glVertexAttrib2sNV(n, s, s2);
        this.println("");
    }

    public void glVertexAttrib2sv(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib2sv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib2sv(n, sArray);
        this.println("");
    }

    public void glVertexAttrib2sv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2sv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib2sv(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib2svARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib2svARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib2svARB(n, sArray);
        this.println("");
    }

    public void glVertexAttrib2svARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2svARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib2svARB(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib2svNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib2svNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib2svNV(n, sArray);
        this.println("");
    }

    public void glVertexAttrib2svNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2svNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib2svNV(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib3d(int n, double d, double d2, double d3) {
        this.printIndent();
        this.print("glVertexAttrib3d(" + n + "," + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glVertexAttrib3d(n, d, d2, d3);
        this.println("");
    }

    public void glVertexAttrib3dARB(int n, double d, double d2, double d3) {
        this.printIndent();
        this.print("glVertexAttrib3dARB(" + n + "," + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glVertexAttrib3dARB(n, d, d2, d3);
        this.println("");
    }

    public void glVertexAttrib3dNV(int n, double d, double d2, double d3) {
        this.printIndent();
        this.print("glVertexAttrib3dNV(" + n + "," + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glVertexAttrib3dNV(n, d, d2, d3);
        this.println("");
    }

    public void glVertexAttrib3dv(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib3dv(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib3dv(n, dArray);
        this.println("");
    }

    public void glVertexAttrib3dv(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3dv(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib3dv(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib3dvARB(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib3dvARB(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib3dvARB(n, dArray);
        this.println("");
    }

    public void glVertexAttrib3dvARB(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3dvARB(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib3dvARB(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib3dvNV(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib3dvNV(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib3dvNV(n, dArray);
        this.println("");
    }

    public void glVertexAttrib3dvNV(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3dvNV(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib3dvNV(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib3f(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glVertexAttrib3f(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glVertexAttrib3f(n, f, f2, f3);
        this.println("");
    }

    public void glVertexAttrib3fARB(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glVertexAttrib3fARB(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glVertexAttrib3fARB(n, f, f2, f3);
        this.println("");
    }

    public void glVertexAttrib3fNV(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glVertexAttrib3fNV(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glVertexAttrib3fNV(n, f, f2, f3);
        this.println("");
    }

    public void glVertexAttrib3fv(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib3fv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib3fv(n, fArray);
        this.println("");
    }

    public void glVertexAttrib3fv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3fv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib3fv(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib3fvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib3fvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib3fvARB(n, fArray);
        this.println("");
    }

    public void glVertexAttrib3fvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3fvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib3fvARB(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib3fvNV(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib3fvNV(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib3fvNV(n, fArray);
        this.println("");
    }

    public void glVertexAttrib3fvNV(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3fvNV(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib3fvNV(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib3hNV(int n, short s, short s2, short s3) {
        this.printIndent();
        this.print("glVertexAttrib3hNV(" + n + "," + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexAttrib3hNV(n, s, s2, s3);
        this.println("");
    }

    public void glVertexAttrib3hvNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib3hvNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib3hvNV(n, sArray);
        this.println("");
    }

    public void glVertexAttrib3hvNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3hvNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib3hvNV(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib3s(int n, short s, short s2, short s3) {
        this.printIndent();
        this.print("glVertexAttrib3s(" + n + "," + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexAttrib3s(n, s, s2, s3);
        this.println("");
    }

    public void glVertexAttrib3sARB(int n, short s, short s2, short s3) {
        this.printIndent();
        this.print("glVertexAttrib3sARB(" + n + "," + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexAttrib3sARB(n, s, s2, s3);
        this.println("");
    }

    public void glVertexAttrib3sNV(int n, short s, short s2, short s3) {
        this.printIndent();
        this.print("glVertexAttrib3sNV(" + n + "," + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexAttrib3sNV(n, s, s2, s3);
        this.println("");
    }

    public void glVertexAttrib3sv(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib3sv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib3sv(n, sArray);
        this.println("");
    }

    public void glVertexAttrib3sv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3sv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib3sv(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib3svARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib3svARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib3svARB(n, sArray);
        this.println("");
    }

    public void glVertexAttrib3svARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3svARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib3svARB(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib3svNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib3svNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib3svNV(n, sArray);
        this.println("");
    }

    public void glVertexAttrib3svNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3svNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib3svNV(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4Nbv(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttrib4Nbv(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttrib4Nbv(n, byArray);
        this.println("");
    }

    public void glVertexAttrib4Nbv(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nbv(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nbv(n, byteBuffer);
        this.println("");
    }

    public void glVertexAttrib4NbvARB(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttrib4NbvARB(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttrib4NbvARB(n, byArray);
        this.println("");
    }

    public void glVertexAttrib4NbvARB(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NbvARB(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4NbvARB(n, byteBuffer);
        this.println("");
    }

    public void glVertexAttrib4Niv(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexAttrib4Niv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexAttrib4Niv(n, nArray);
        this.println("");
    }

    public void glVertexAttrib4Niv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Niv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4Niv(n, intBuffer);
        this.println("");
    }

    public void glVertexAttrib4NivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexAttrib4NivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexAttrib4NivARB(n, nArray);
        this.println("");
    }

    public void glVertexAttrib4NivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4NivARB(n, intBuffer);
        this.println("");
    }

    public void glVertexAttrib4Nsv(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4Nsv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4Nsv(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4Nsv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nsv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nsv(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4NsvARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4NsvARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4NsvARB(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4NsvARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NsvARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4NsvARB(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4Nub(int n, byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glVertexAttrib4Nub(" + n + "," + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glVertexAttrib4Nub(n, by, by2, by3, by4);
        this.println("");
    }

    public void glVertexAttrib4NubARB(int n, byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glVertexAttrib4NubARB(" + n + "," + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glVertexAttrib4NubARB(n, by, by2, by3, by4);
        this.println("");
    }

    public void glVertexAttrib4Nubv(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttrib4Nubv(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttrib4Nubv(n, byArray);
        this.println("");
    }

    public void glVertexAttrib4Nubv(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nubv(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nubv(n, byteBuffer);
        this.println("");
    }

    public void glVertexAttrib4NubvARB(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttrib4NubvARB(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttrib4NubvARB(n, byArray);
        this.println("");
    }

    public void glVertexAttrib4NubvARB(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NubvARB(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4NubvARB(n, byteBuffer);
        this.println("");
    }

    public void glVertexAttrib4Nuiv(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexAttrib4Nuiv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexAttrib4Nuiv(n, nArray);
        this.println("");
    }

    public void glVertexAttrib4Nuiv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nuiv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nuiv(n, intBuffer);
        this.println("");
    }

    public void glVertexAttrib4NuivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexAttrib4NuivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexAttrib4NuivARB(n, nArray);
        this.println("");
    }

    public void glVertexAttrib4NuivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NuivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4NuivARB(n, intBuffer);
        this.println("");
    }

    public void glVertexAttrib4Nusv(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4Nusv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4Nusv(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4Nusv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nusv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nusv(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4NusvARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4NusvARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4NusvARB(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4NusvARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NusvARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4NusvARB(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4bv(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttrib4bv(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttrib4bv(n, byArray);
        this.println("");
    }

    public void glVertexAttrib4bv(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4bv(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4bv(n, byteBuffer);
        this.println("");
    }

    public void glVertexAttrib4bvARB(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttrib4bvARB(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttrib4bvARB(n, byArray);
        this.println("");
    }

    public void glVertexAttrib4bvARB(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4bvARB(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4bvARB(n, byteBuffer);
        this.println("");
    }

    public void glVertexAttrib4d(int n, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertexAttrib4d(" + n + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertexAttrib4d(n, d, d2, d3, d4);
        this.println("");
    }

    public void glVertexAttrib4dARB(int n, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertexAttrib4dARB(" + n + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertexAttrib4dARB(n, d, d2, d3, d4);
        this.println("");
    }

    public void glVertexAttrib4dNV(int n, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertexAttrib4dNV(" + n + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertexAttrib4dNV(n, d, d2, d3, d4);
        this.println("");
    }

    public void glVertexAttrib4dv(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib4dv(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib4dv(n, dArray);
        this.println("");
    }

    public void glVertexAttrib4dv(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4dv(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib4dv(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib4dvARB(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib4dvARB(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib4dvARB(n, dArray);
        this.println("");
    }

    public void glVertexAttrib4dvARB(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4dvARB(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib4dvARB(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib4dvNV(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttrib4dvNV(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttrib4dvNV(n, dArray);
        this.println("");
    }

    public void glVertexAttrib4dvNV(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4dvNV(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib4dvNV(n, doubleBuffer);
        this.println("");
    }

    public void glVertexAttrib4f(int n, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertexAttrib4f(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertexAttrib4f(n, f, f2, f3, f4);
        this.println("");
    }

    public void glVertexAttrib4fARB(int n, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertexAttrib4fARB(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertexAttrib4fARB(n, f, f2, f3, f4);
        this.println("");
    }

    public void glVertexAttrib4fNV(int n, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertexAttrib4fNV(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertexAttrib4fNV(n, f, f2, f3, f4);
        this.println("");
    }

    public void glVertexAttrib4fv(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib4fv(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib4fv(n, fArray);
        this.println("");
    }

    public void glVertexAttrib4fv(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4fv(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib4fv(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib4fvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib4fvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib4fvARB(n, fArray);
        this.println("");
    }

    public void glVertexAttrib4fvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4fvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib4fvARB(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib4fvNV(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttrib4fvNV(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttrib4fvNV(n, fArray);
        this.println("");
    }

    public void glVertexAttrib4fvNV(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4fvNV(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib4fvNV(n, floatBuffer);
        this.println("");
    }

    public void glVertexAttrib4hNV(int n, short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexAttrib4hNV(" + n + "," + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexAttrib4hNV(n, s, s2, s3, s4);
        this.println("");
    }

    public void glVertexAttrib4hvNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4hvNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4hvNV(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4hvNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4hvNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4hvNV(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4iv(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexAttrib4iv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexAttrib4iv(n, nArray);
        this.println("");
    }

    public void glVertexAttrib4iv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4iv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4iv(n, intBuffer);
        this.println("");
    }

    public void glVertexAttrib4ivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexAttrib4ivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexAttrib4ivARB(n, nArray);
        this.println("");
    }

    public void glVertexAttrib4ivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4ivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4ivARB(n, intBuffer);
        this.println("");
    }

    public void glVertexAttrib4s(int n, short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexAttrib4s(" + n + "," + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexAttrib4s(n, s, s2, s3, s4);
        this.println("");
    }

    public void glVertexAttrib4sARB(int n, short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexAttrib4sARB(" + n + "," + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexAttrib4sARB(n, s, s2, s3, s4);
        this.println("");
    }

    public void glVertexAttrib4sNV(int n, short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexAttrib4sNV(" + n + "," + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexAttrib4sNV(n, s, s2, s3, s4);
        this.println("");
    }

    public void glVertexAttrib4sv(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4sv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4sv(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4sv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4sv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4sv(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4svARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4svARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4svARB(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4svARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4svARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4svARB(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4svNV(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4svNV(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4svNV(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4svNV(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4svNV(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4svNV(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4ubNV(int n, byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glVertexAttrib4ubNV(" + n + "," + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glVertexAttrib4ubNV(n, by, by2, by3, by4);
        this.println("");
    }

    public void glVertexAttrib4ubv(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttrib4ubv(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttrib4ubv(n, byArray);
        this.println("");
    }

    public void glVertexAttrib4ubv(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4ubv(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4ubv(n, byteBuffer);
        this.println("");
    }

    public void glVertexAttrib4ubvARB(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttrib4ubvARB(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttrib4ubvARB(n, byArray);
        this.println("");
    }

    public void glVertexAttrib4ubvARB(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4ubvARB(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4ubvARB(n, byteBuffer);
        this.println("");
    }

    public void glVertexAttrib4ubvNV(int n, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttrib4ubvNV(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttrib4ubvNV(n, byArray);
        this.println("");
    }

    public void glVertexAttrib4ubvNV(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4ubvNV(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4ubvNV(n, byteBuffer);
        this.println("");
    }

    public void glVertexAttrib4uiv(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexAttrib4uiv(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexAttrib4uiv(n, nArray);
        this.println("");
    }

    public void glVertexAttrib4uiv(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4uiv(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4uiv(n, intBuffer);
        this.println("");
    }

    public void glVertexAttrib4uivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexAttrib4uivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexAttrib4uivARB(n, nArray);
        this.println("");
    }

    public void glVertexAttrib4uivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4uivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4uivARB(n, intBuffer);
        this.println("");
    }

    public void glVertexAttrib4usv(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4usv(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4usv(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4usv(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4usv(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4usv(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttrib4usvARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttrib4usvARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttrib4usvARB(n, sArray);
        this.println("");
    }

    public void glVertexAttrib4usvARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4usvARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4usvARB(n, shortBuffer);
        this.println("");
    }

    public void glVertexAttribArrayObjectATI(int n, int n2, int n3, boolean bl, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glVertexAttribArrayObjectATI(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glVertexAttribArrayObjectATI(n, n2, n3, bl, n4, n5, n6);
        this.println("");
    }

    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, boolean[] blArray) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + this.dumpArray(blArray) + ")");
        this.downstreamGL.glVertexAttribPointer(n, n2, n3, bl, n4, blArray);
        this.println("");
    }

    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, char[] cArray) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + this.dumpArray(cArray) + ")");
        this.downstreamGL.glVertexAttribPointer(n, n2, n3, bl, n4, cArray);
        this.println("");
    }

    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttribPointer(n, n2, n3, bl, n4, byArray);
        this.println("");
    }

    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttribPointer(n, n2, n3, bl, n4, sArray);
        this.println("");
    }

    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, int[] nArray) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexAttribPointer(n, n2, n3, bl, n4, nArray);
        this.println("");
    }

    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, long[] lArray) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + this.dumpArray(lArray) + ")");
        this.downstreamGL.glVertexAttribPointer(n, n2, n3, bl, n4, lArray);
        this.println("");
    }

    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttribPointer(n, n2, n3, bl, n4, fArray);
        this.println("");
    }

    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttribPointer(n, n2, n3, bl, n4, dArray);
        this.println("");
    }

    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glVertexAttribPointer(n, n2, n3, bl, n4, buffer);
        this.println("");
    }

    public void glVertexAttribPointerARB(int n, int n2, int n3, boolean bl, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glVertexAttribPointerARB(" + n + "," + n2 + "," + n3 + "," + bl + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glVertexAttribPointerARB(n, n2, n3, bl, n4, buffer);
        this.println("");
    }

    public void glVertexAttribPointerNV(int n, int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glVertexAttribPointerNV(" + n + "," + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glVertexAttribPointerNV(n, n2, n3, n4, buffer);
        this.println("");
    }

    public void glVertexAttribs1dvNV(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttribs1dvNV(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttribs1dvNV(n, n2, dArray);
        this.println("");
    }

    public void glVertexAttribs1dvNV(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttribs1dvNV(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttribs1dvNV(n, n2, doubleBuffer);
        this.println("");
    }

    public void glVertexAttribs1fvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttribs1fvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttribs1fvNV(n, n2, fArray);
        this.println("");
    }

    public void glVertexAttribs1fvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttribs1fvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttribs1fvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glVertexAttribs1hvNV(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttribs1hvNV(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttribs1hvNV(n, n2, sArray);
        this.println("");
    }

    public void glVertexAttribs1hvNV(int n, int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs1hvNV(" + n + "," + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs1hvNV(n, n2, shortBuffer);
        this.println("");
    }

    public void glVertexAttribs1svNV(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttribs1svNV(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttribs1svNV(n, n2, sArray);
        this.println("");
    }

    public void glVertexAttribs1svNV(int n, int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs1svNV(" + n + "," + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs1svNV(n, n2, shortBuffer);
        this.println("");
    }

    public void glVertexAttribs2dvNV(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttribs2dvNV(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttribs2dvNV(n, n2, dArray);
        this.println("");
    }

    public void glVertexAttribs2dvNV(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttribs2dvNV(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttribs2dvNV(n, n2, doubleBuffer);
        this.println("");
    }

    public void glVertexAttribs2fvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttribs2fvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttribs2fvNV(n, n2, fArray);
        this.println("");
    }

    public void glVertexAttribs2fvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttribs2fvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttribs2fvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glVertexAttribs2hvNV(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttribs2hvNV(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttribs2hvNV(n, n2, sArray);
        this.println("");
    }

    public void glVertexAttribs2hvNV(int n, int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs2hvNV(" + n + "," + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs2hvNV(n, n2, shortBuffer);
        this.println("");
    }

    public void glVertexAttribs2svNV(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttribs2svNV(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttribs2svNV(n, n2, sArray);
        this.println("");
    }

    public void glVertexAttribs2svNV(int n, int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs2svNV(" + n + "," + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs2svNV(n, n2, shortBuffer);
        this.println("");
    }

    public void glVertexAttribs3dvNV(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttribs3dvNV(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttribs3dvNV(n, n2, dArray);
        this.println("");
    }

    public void glVertexAttribs3dvNV(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttribs3dvNV(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttribs3dvNV(n, n2, doubleBuffer);
        this.println("");
    }

    public void glVertexAttribs3fvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttribs3fvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttribs3fvNV(n, n2, fArray);
        this.println("");
    }

    public void glVertexAttribs3fvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttribs3fvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttribs3fvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glVertexAttribs3hvNV(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttribs3hvNV(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttribs3hvNV(n, n2, sArray);
        this.println("");
    }

    public void glVertexAttribs3hvNV(int n, int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs3hvNV(" + n + "," + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs3hvNV(n, n2, shortBuffer);
        this.println("");
    }

    public void glVertexAttribs3svNV(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttribs3svNV(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttribs3svNV(n, n2, sArray);
        this.println("");
    }

    public void glVertexAttribs3svNV(int n, int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs3svNV(" + n + "," + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs3svNV(n, n2, shortBuffer);
        this.println("");
    }

    public void glVertexAttribs4dvNV(int n, int n2, double[] dArray) {
        this.printIndent();
        this.print("glVertexAttribs4dvNV(" + n + "," + n2 + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexAttribs4dvNV(n, n2, dArray);
        this.println("");
    }

    public void glVertexAttribs4dvNV(int n, int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4dvNV(" + n + "," + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttribs4dvNV(n, n2, doubleBuffer);
        this.println("");
    }

    public void glVertexAttribs4fvNV(int n, int n2, float[] fArray) {
        this.printIndent();
        this.print("glVertexAttribs4fvNV(" + n + "," + n2 + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexAttribs4fvNV(n, n2, fArray);
        this.println("");
    }

    public void glVertexAttribs4fvNV(int n, int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4fvNV(" + n + "," + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttribs4fvNV(n, n2, floatBuffer);
        this.println("");
    }

    public void glVertexAttribs4hvNV(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttribs4hvNV(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttribs4hvNV(n, n2, sArray);
        this.println("");
    }

    public void glVertexAttribs4hvNV(int n, int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4hvNV(" + n + "," + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs4hvNV(n, n2, shortBuffer);
        this.println("");
    }

    public void glVertexAttribs4svNV(int n, int n2, short[] sArray) {
        this.printIndent();
        this.print("glVertexAttribs4svNV(" + n + "," + n2 + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexAttribs4svNV(n, n2, sArray);
        this.println("");
    }

    public void glVertexAttribs4svNV(int n, int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4svNV(" + n + "," + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs4svNV(n, n2, shortBuffer);
        this.println("");
    }

    public void glVertexAttribs4ubvNV(int n, int n2, byte[] byArray) {
        this.printIndent();
        this.print("glVertexAttribs4ubvNV(" + n + "," + n2 + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glVertexAttribs4ubvNV(n, n2, byArray);
        this.println("");
    }

    public void glVertexAttribs4ubvNV(int n, int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4ubvNV(" + n + "," + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttribs4ubvNV(n, n2, byteBuffer);
        this.println("");
    }

    public void glVertexBlendARB(int n) {
        this.printIndent();
        this.print("glVertexBlendARB(" + n + ")");
        this.downstreamGL.glVertexBlendARB(n);
        this.println("");
    }

    public void glVertexBlendEnvfATI(int n, float f) {
        this.printIndent();
        this.print("glVertexBlendEnvfATI(" + n + "," + f + ")");
        this.downstreamGL.glVertexBlendEnvfATI(n, f);
        this.println("");
    }

    public void glVertexBlendEnviATI(int n, int n2) {
        this.printIndent();
        this.print("glVertexBlendEnviATI(" + n + "," + n2 + ")");
        this.downstreamGL.glVertexBlendEnviATI(n, n2);
        this.println("");
    }

    public void glVertexPointer(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glVertexPointer(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glVertexPointer(n, n2, n3, buffer);
        this.println("");
    }

    public void glVertexPointerEXT(int n, int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glVertexPointerEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glVertexPointerEXT(n, n2, n3, n4, buffer);
        this.println("");
    }

    public void glVertexPointerListIBM(int n, int n2, int n3, Buffer[] bufferArray, int n4) {
        this.printIndent();
        this.print("glVertexPointerListIBM(" + n + "," + n2 + "," + n3 + "," + this.dumpArray(bufferArray) + "," + n4 + ")");
        this.downstreamGL.glVertexPointerListIBM(n, n2, n3, bufferArray, n4);
        this.println("");
    }

    public void glVertexPointervINTEL(int n, int n2, Buffer[] bufferArray) {
        this.printIndent();
        this.print("glVertexPointervINTEL(" + n + "," + n2 + "," + this.dumpArray(bufferArray) + ")");
        this.downstreamGL.glVertexPointervINTEL(n, n2, bufferArray);
        this.println("");
    }

    public void glVertexStream1dATI(int n, double d) {
        this.printIndent();
        this.print("glVertexStream1dATI(" + n + "," + d + ")");
        this.downstreamGL.glVertexStream1dATI(n, d);
        this.println("");
    }

    public void glVertexStream1dvATI(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexStream1dvATI(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexStream1dvATI(n, dArray);
        this.println("");
    }

    public void glVertexStream1dvATI(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexStream1dvATI(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexStream1dvATI(n, doubleBuffer);
        this.println("");
    }

    public void glVertexStream1fATI(int n, float f) {
        this.printIndent();
        this.print("glVertexStream1fATI(" + n + "," + f + ")");
        this.downstreamGL.glVertexStream1fATI(n, f);
        this.println("");
    }

    public void glVertexStream1fvATI(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexStream1fvATI(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexStream1fvATI(n, fArray);
        this.println("");
    }

    public void glVertexStream1fvATI(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexStream1fvATI(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexStream1fvATI(n, floatBuffer);
        this.println("");
    }

    public void glVertexStream1iATI(int n, int n2) {
        this.printIndent();
        this.print("glVertexStream1iATI(" + n + "," + n2 + ")");
        this.downstreamGL.glVertexStream1iATI(n, n2);
        this.println("");
    }

    public void glVertexStream1ivATI(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexStream1ivATI(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexStream1ivATI(n, nArray);
        this.println("");
    }

    public void glVertexStream1ivATI(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexStream1ivATI(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexStream1ivATI(n, intBuffer);
        this.println("");
    }

    public void glVertexStream1sATI(int n, short s) {
        this.printIndent();
        this.print("glVertexStream1sATI(" + n + "," + s + ")");
        this.downstreamGL.glVertexStream1sATI(n, s);
        this.println("");
    }

    public void glVertexStream1svATI(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexStream1svATI(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexStream1svATI(n, sArray);
        this.println("");
    }

    public void glVertexStream1svATI(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexStream1svATI(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexStream1svATI(n, shortBuffer);
        this.println("");
    }

    public void glVertexStream2dATI(int n, double d, double d2) {
        this.printIndent();
        this.print("glVertexStream2dATI(" + n + "," + d + "," + d2 + ")");
        this.downstreamGL.glVertexStream2dATI(n, d, d2);
        this.println("");
    }

    public void glVertexStream2dvATI(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexStream2dvATI(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexStream2dvATI(n, dArray);
        this.println("");
    }

    public void glVertexStream2dvATI(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexStream2dvATI(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexStream2dvATI(n, doubleBuffer);
        this.println("");
    }

    public void glVertexStream2fATI(int n, float f, float f2) {
        this.printIndent();
        this.print("glVertexStream2fATI(" + n + "," + f + "," + f2 + ")");
        this.downstreamGL.glVertexStream2fATI(n, f, f2);
        this.println("");
    }

    public void glVertexStream2fvATI(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexStream2fvATI(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexStream2fvATI(n, fArray);
        this.println("");
    }

    public void glVertexStream2fvATI(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexStream2fvATI(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexStream2fvATI(n, floatBuffer);
        this.println("");
    }

    public void glVertexStream2iATI(int n, int n2, int n3) {
        this.printIndent();
        this.print("glVertexStream2iATI(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glVertexStream2iATI(n, n2, n3);
        this.println("");
    }

    public void glVertexStream2ivATI(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexStream2ivATI(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexStream2ivATI(n, nArray);
        this.println("");
    }

    public void glVertexStream2ivATI(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexStream2ivATI(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexStream2ivATI(n, intBuffer);
        this.println("");
    }

    public void glVertexStream2sATI(int n, short s, short s2) {
        this.printIndent();
        this.print("glVertexStream2sATI(" + n + "," + s + "," + s2 + ")");
        this.downstreamGL.glVertexStream2sATI(n, s, s2);
        this.println("");
    }

    public void glVertexStream2svATI(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexStream2svATI(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexStream2svATI(n, sArray);
        this.println("");
    }

    public void glVertexStream2svATI(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexStream2svATI(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexStream2svATI(n, shortBuffer);
        this.println("");
    }

    public void glVertexStream3dATI(int n, double d, double d2, double d3) {
        this.printIndent();
        this.print("glVertexStream3dATI(" + n + "," + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glVertexStream3dATI(n, d, d2, d3);
        this.println("");
    }

    public void glVertexStream3dvATI(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexStream3dvATI(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexStream3dvATI(n, dArray);
        this.println("");
    }

    public void glVertexStream3dvATI(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexStream3dvATI(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexStream3dvATI(n, doubleBuffer);
        this.println("");
    }

    public void glVertexStream3fATI(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glVertexStream3fATI(" + n + "," + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glVertexStream3fATI(n, f, f2, f3);
        this.println("");
    }

    public void glVertexStream3fvATI(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexStream3fvATI(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexStream3fvATI(n, fArray);
        this.println("");
    }

    public void glVertexStream3fvATI(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexStream3fvATI(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexStream3fvATI(n, floatBuffer);
        this.println("");
    }

    public void glVertexStream3iATI(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glVertexStream3iATI(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glVertexStream3iATI(n, n2, n3, n4);
        this.println("");
    }

    public void glVertexStream3ivATI(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexStream3ivATI(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexStream3ivATI(n, nArray);
        this.println("");
    }

    public void glVertexStream3ivATI(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexStream3ivATI(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexStream3ivATI(n, intBuffer);
        this.println("");
    }

    public void glVertexStream3sATI(int n, short s, short s2, short s3) {
        this.printIndent();
        this.print("glVertexStream3sATI(" + n + "," + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexStream3sATI(n, s, s2, s3);
        this.println("");
    }

    public void glVertexStream3svATI(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexStream3svATI(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexStream3svATI(n, sArray);
        this.println("");
    }

    public void glVertexStream3svATI(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexStream3svATI(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexStream3svATI(n, shortBuffer);
        this.println("");
    }

    public void glVertexStream4dATI(int n, double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertexStream4dATI(" + n + "," + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertexStream4dATI(n, d, d2, d3, d4);
        this.println("");
    }

    public void glVertexStream4dvATI(int n, double[] dArray) {
        this.printIndent();
        this.print("glVertexStream4dvATI(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glVertexStream4dvATI(n, dArray);
        this.println("");
    }

    public void glVertexStream4dvATI(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexStream4dvATI(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexStream4dvATI(n, doubleBuffer);
        this.println("");
    }

    public void glVertexStream4fATI(int n, float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertexStream4fATI(" + n + "," + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertexStream4fATI(n, f, f2, f3, f4);
        this.println("");
    }

    public void glVertexStream4fvATI(int n, float[] fArray) {
        this.printIndent();
        this.print("glVertexStream4fvATI(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexStream4fvATI(n, fArray);
        this.println("");
    }

    public void glVertexStream4fvATI(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexStream4fvATI(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glVertexStream4fvATI(n, floatBuffer);
        this.println("");
    }

    public void glVertexStream4iATI(int n, int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glVertexStream4iATI(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glVertexStream4iATI(n, n2, n3, n4, n5);
        this.println("");
    }

    public void glVertexStream4ivATI(int n, int[] nArray) {
        this.printIndent();
        this.print("glVertexStream4ivATI(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glVertexStream4ivATI(n, nArray);
        this.println("");
    }

    public void glVertexStream4ivATI(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexStream4ivATI(" + n + "," + intBuffer + ")");
        this.downstreamGL.glVertexStream4ivATI(n, intBuffer);
        this.println("");
    }

    public void glVertexStream4sATI(int n, short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexStream4sATI(" + n + "," + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexStream4sATI(n, s, s2, s3, s4);
        this.println("");
    }

    public void glVertexStream4svATI(int n, short[] sArray) {
        this.printIndent();
        this.print("glVertexStream4svATI(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexStream4svATI(n, sArray);
        this.println("");
    }

    public void glVertexStream4svATI(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexStream4svATI(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glVertexStream4svATI(n, shortBuffer);
        this.println("");
    }

    public void glVertexWeightPointerEXT(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glVertexWeightPointerEXT(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glVertexWeightPointerEXT(n, n2, n3, buffer);
        this.println("");
    }

    public void glVertexWeightfEXT(float f) {
        this.printIndent();
        this.print("glVertexWeightfEXT(" + f + ")");
        this.downstreamGL.glVertexWeightfEXT(f);
        this.println("");
    }

    public void glVertexWeightfvEXT(float[] fArray) {
        this.printIndent();
        this.print("glVertexWeightfvEXT(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glVertexWeightfvEXT(fArray);
        this.println("");
    }

    public void glVertexWeightfvEXT(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexWeightfvEXT(" + floatBuffer + ")");
        this.downstreamGL.glVertexWeightfvEXT(floatBuffer);
        this.println("");
    }

    public void glVertexWeighthNV(short s) {
        this.printIndent();
        this.print("glVertexWeighthNV(" + s + ")");
        this.downstreamGL.glVertexWeighthNV(s);
        this.println("");
    }

    public void glVertexWeighthvNV(short[] sArray) {
        this.printIndent();
        this.print("glVertexWeighthvNV(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glVertexWeighthvNV(sArray);
        this.println("");
    }

    public void glVertexWeighthvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexWeighthvNV(" + shortBuffer + ")");
        this.downstreamGL.glVertexWeighthvNV(shortBuffer);
        this.println("");
    }

    public void glViewport(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glViewport(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glViewport(n, n2, n3, n4);
        this.println("");
    }

    public void glWeightPointerARB(int n, int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glWeightPointerARB(" + n + "," + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glWeightPointerARB(n, n2, n3, buffer);
        this.println("");
    }

    public void glWeightbvARB(int n, byte[] byArray) {
        this.printIndent();
        this.print("glWeightbvARB(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glWeightbvARB(n, byArray);
        this.println("");
    }

    public void glWeightbvARB(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glWeightbvARB(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glWeightbvARB(n, byteBuffer);
        this.println("");
    }

    public void glWeightdvARB(int n, double[] dArray) {
        this.printIndent();
        this.print("glWeightdvARB(" + n + "," + this.dumpArray(dArray) + ")");
        this.downstreamGL.glWeightdvARB(n, dArray);
        this.println("");
    }

    public void glWeightdvARB(int n, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWeightdvARB(" + n + "," + doubleBuffer + ")");
        this.downstreamGL.glWeightdvARB(n, doubleBuffer);
        this.println("");
    }

    public void glWeightfvARB(int n, float[] fArray) {
        this.printIndent();
        this.print("glWeightfvARB(" + n + "," + this.dumpArray(fArray) + ")");
        this.downstreamGL.glWeightfvARB(n, fArray);
        this.println("");
    }

    public void glWeightfvARB(int n, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWeightfvARB(" + n + "," + floatBuffer + ")");
        this.downstreamGL.glWeightfvARB(n, floatBuffer);
        this.println("");
    }

    public void glWeightivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glWeightivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glWeightivARB(n, nArray);
        this.println("");
    }

    public void glWeightivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWeightivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glWeightivARB(n, intBuffer);
        this.println("");
    }

    public void glWeightsvARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glWeightsvARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glWeightsvARB(n, sArray);
        this.println("");
    }

    public void glWeightsvARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWeightsvARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glWeightsvARB(n, shortBuffer);
        this.println("");
    }

    public void glWeightubvARB(int n, byte[] byArray) {
        this.printIndent();
        this.print("glWeightubvARB(" + n + "," + this.dumpArray(byArray) + ")");
        this.downstreamGL.glWeightubvARB(n, byArray);
        this.println("");
    }

    public void glWeightubvARB(int n, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glWeightubvARB(" + n + "," + byteBuffer + ")");
        this.downstreamGL.glWeightubvARB(n, byteBuffer);
        this.println("");
    }

    public void glWeightuivARB(int n, int[] nArray) {
        this.printIndent();
        this.print("glWeightuivARB(" + n + "," + this.dumpArray(nArray) + ")");
        this.downstreamGL.glWeightuivARB(n, nArray);
        this.println("");
    }

    public void glWeightuivARB(int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWeightuivARB(" + n + "," + intBuffer + ")");
        this.downstreamGL.glWeightuivARB(n, intBuffer);
        this.println("");
    }

    public void glWeightusvARB(int n, short[] sArray) {
        this.printIndent();
        this.print("glWeightusvARB(" + n + "," + this.dumpArray(sArray) + ")");
        this.downstreamGL.glWeightusvARB(n, sArray);
        this.println("");
    }

    public void glWeightusvARB(int n, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWeightusvARB(" + n + "," + shortBuffer + ")");
        this.downstreamGL.glWeightusvARB(n, shortBuffer);
        this.println("");
    }

    public void glWindowPos2d(double d, double d2) {
        this.printIndent();
        this.print("glWindowPos2d(" + d + "," + d2 + ")");
        this.downstreamGL.glWindowPos2d(d, d2);
        this.println("");
    }

    public void glWindowPos2dARB(double d, double d2) {
        this.printIndent();
        this.print("glWindowPos2dARB(" + d + "," + d2 + ")");
        this.downstreamGL.glWindowPos2dARB(d, d2);
        this.println("");
    }

    public void glWindowPos2dMESA(double d, double d2) {
        this.printIndent();
        this.print("glWindowPos2dMESA(" + d + "," + d2 + ")");
        this.downstreamGL.glWindowPos2dMESA(d, d2);
        this.println("");
    }

    public void glWindowPos2dv(double[] dArray) {
        this.printIndent();
        this.print("glWindowPos2dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glWindowPos2dv(dArray);
        this.println("");
    }

    public void glWindowPos2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos2dv(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos2dv(doubleBuffer);
        this.println("");
    }

    public void glWindowPos2dvARB(double[] dArray) {
        this.printIndent();
        this.print("glWindowPos2dvARB(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glWindowPos2dvARB(dArray);
        this.println("");
    }

    public void glWindowPos2dvARB(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos2dvARB(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos2dvARB(doubleBuffer);
        this.println("");
    }

    public void glWindowPos2dvMESA(double[] dArray) {
        this.printIndent();
        this.print("glWindowPos2dvMESA(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glWindowPos2dvMESA(dArray);
        this.println("");
    }

    public void glWindowPos2dvMESA(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos2dvMESA(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos2dvMESA(doubleBuffer);
        this.println("");
    }

    public void glWindowPos2f(float f, float f2) {
        this.printIndent();
        this.print("glWindowPos2f(" + f + "," + f2 + ")");
        this.downstreamGL.glWindowPos2f(f, f2);
        this.println("");
    }

    public void glWindowPos2fARB(float f, float f2) {
        this.printIndent();
        this.print("glWindowPos2fARB(" + f + "," + f2 + ")");
        this.downstreamGL.glWindowPos2fARB(f, f2);
        this.println("");
    }

    public void glWindowPos2fMESA(float f, float f2) {
        this.printIndent();
        this.print("glWindowPos2fMESA(" + f + "," + f2 + ")");
        this.downstreamGL.glWindowPos2fMESA(f, f2);
        this.println("");
    }

    public void glWindowPos2fv(float[] fArray) {
        this.printIndent();
        this.print("glWindowPos2fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glWindowPos2fv(fArray);
        this.println("");
    }

    public void glWindowPos2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos2fv(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos2fv(floatBuffer);
        this.println("");
    }

    public void glWindowPos2fvARB(float[] fArray) {
        this.printIndent();
        this.print("glWindowPos2fvARB(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glWindowPos2fvARB(fArray);
        this.println("");
    }

    public void glWindowPos2fvARB(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos2fvARB(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos2fvARB(floatBuffer);
        this.println("");
    }

    public void glWindowPos2fvMESA(float[] fArray) {
        this.printIndent();
        this.print("glWindowPos2fvMESA(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glWindowPos2fvMESA(fArray);
        this.println("");
    }

    public void glWindowPos2fvMESA(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos2fvMESA(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos2fvMESA(floatBuffer);
        this.println("");
    }

    public void glWindowPos2i(int n, int n2) {
        this.printIndent();
        this.print("glWindowPos2i(" + n + "," + n2 + ")");
        this.downstreamGL.glWindowPos2i(n, n2);
        this.println("");
    }

    public void glWindowPos2iARB(int n, int n2) {
        this.printIndent();
        this.print("glWindowPos2iARB(" + n + "," + n2 + ")");
        this.downstreamGL.glWindowPos2iARB(n, n2);
        this.println("");
    }

    public void glWindowPos2iMESA(int n, int n2) {
        this.printIndent();
        this.print("glWindowPos2iMESA(" + n + "," + n2 + ")");
        this.downstreamGL.glWindowPos2iMESA(n, n2);
        this.println("");
    }

    public void glWindowPos2iv(int[] nArray) {
        this.printIndent();
        this.print("glWindowPos2iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glWindowPos2iv(nArray);
        this.println("");
    }

    public void glWindowPos2iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos2iv(" + intBuffer + ")");
        this.downstreamGL.glWindowPos2iv(intBuffer);
        this.println("");
    }

    public void glWindowPos2ivARB(int[] nArray) {
        this.printIndent();
        this.print("glWindowPos2ivARB(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glWindowPos2ivARB(nArray);
        this.println("");
    }

    public void glWindowPos2ivARB(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos2ivARB(" + intBuffer + ")");
        this.downstreamGL.glWindowPos2ivARB(intBuffer);
        this.println("");
    }

    public void glWindowPos2ivMESA(int[] nArray) {
        this.printIndent();
        this.print("glWindowPos2ivMESA(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glWindowPos2ivMESA(nArray);
        this.println("");
    }

    public void glWindowPos2ivMESA(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos2ivMESA(" + intBuffer + ")");
        this.downstreamGL.glWindowPos2ivMESA(intBuffer);
        this.println("");
    }

    public void glWindowPos2s(short s, short s2) {
        this.printIndent();
        this.print("glWindowPos2s(" + s + "," + s2 + ")");
        this.downstreamGL.glWindowPos2s(s, s2);
        this.println("");
    }

    public void glWindowPos2sARB(short s, short s2) {
        this.printIndent();
        this.print("glWindowPos2sARB(" + s + "," + s2 + ")");
        this.downstreamGL.glWindowPos2sARB(s, s2);
        this.println("");
    }

    public void glWindowPos2sMESA(short s, short s2) {
        this.printIndent();
        this.print("glWindowPos2sMESA(" + s + "," + s2 + ")");
        this.downstreamGL.glWindowPos2sMESA(s, s2);
        this.println("");
    }

    public void glWindowPos2sv(short[] sArray) {
        this.printIndent();
        this.print("glWindowPos2sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glWindowPos2sv(sArray);
        this.println("");
    }

    public void glWindowPos2sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos2sv(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos2sv(shortBuffer);
        this.println("");
    }

    public void glWindowPos2svARB(short[] sArray) {
        this.printIndent();
        this.print("glWindowPos2svARB(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glWindowPos2svARB(sArray);
        this.println("");
    }

    public void glWindowPos2svARB(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos2svARB(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos2svARB(shortBuffer);
        this.println("");
    }

    public void glWindowPos2svMESA(short[] sArray) {
        this.printIndent();
        this.print("glWindowPos2svMESA(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glWindowPos2svMESA(sArray);
        this.println("");
    }

    public void glWindowPos2svMESA(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos2svMESA(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos2svMESA(shortBuffer);
        this.println("");
    }

    public void glWindowPos3d(double d, double d2, double d3) {
        this.printIndent();
        this.print("glWindowPos3d(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glWindowPos3d(d, d2, d3);
        this.println("");
    }

    public void glWindowPos3dARB(double d, double d2, double d3) {
        this.printIndent();
        this.print("glWindowPos3dARB(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glWindowPos3dARB(d, d2, d3);
        this.println("");
    }

    public void glWindowPos3dMESA(double d, double d2, double d3) {
        this.printIndent();
        this.print("glWindowPos3dMESA(" + d + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glWindowPos3dMESA(d, d2, d3);
        this.println("");
    }

    public void glWindowPos3dv(double[] dArray) {
        this.printIndent();
        this.print("glWindowPos3dv(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glWindowPos3dv(dArray);
        this.println("");
    }

    public void glWindowPos3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos3dv(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos3dv(doubleBuffer);
        this.println("");
    }

    public void glWindowPos3dvARB(double[] dArray) {
        this.printIndent();
        this.print("glWindowPos3dvARB(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glWindowPos3dvARB(dArray);
        this.println("");
    }

    public void glWindowPos3dvARB(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos3dvARB(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos3dvARB(doubleBuffer);
        this.println("");
    }

    public void glWindowPos3dvMESA(double[] dArray) {
        this.printIndent();
        this.print("glWindowPos3dvMESA(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glWindowPos3dvMESA(dArray);
        this.println("");
    }

    public void glWindowPos3dvMESA(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos3dvMESA(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos3dvMESA(doubleBuffer);
        this.println("");
    }

    public void glWindowPos3f(float f, float f2, float f3) {
        this.printIndent();
        this.print("glWindowPos3f(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glWindowPos3f(f, f2, f3);
        this.println("");
    }

    public void glWindowPos3fARB(float f, float f2, float f3) {
        this.printIndent();
        this.print("glWindowPos3fARB(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glWindowPos3fARB(f, f2, f3);
        this.println("");
    }

    public void glWindowPos3fMESA(float f, float f2, float f3) {
        this.printIndent();
        this.print("glWindowPos3fMESA(" + f + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glWindowPos3fMESA(f, f2, f3);
        this.println("");
    }

    public void glWindowPos3fv(float[] fArray) {
        this.printIndent();
        this.print("glWindowPos3fv(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glWindowPos3fv(fArray);
        this.println("");
    }

    public void glWindowPos3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos3fv(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos3fv(floatBuffer);
        this.println("");
    }

    public void glWindowPos3fvARB(float[] fArray) {
        this.printIndent();
        this.print("glWindowPos3fvARB(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glWindowPos3fvARB(fArray);
        this.println("");
    }

    public void glWindowPos3fvARB(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos3fvARB(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos3fvARB(floatBuffer);
        this.println("");
    }

    public void glWindowPos3fvMESA(float[] fArray) {
        this.printIndent();
        this.print("glWindowPos3fvMESA(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glWindowPos3fvMESA(fArray);
        this.println("");
    }

    public void glWindowPos3fvMESA(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos3fvMESA(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos3fvMESA(floatBuffer);
        this.println("");
    }

    public void glWindowPos3i(int n, int n2, int n3) {
        this.printIndent();
        this.print("glWindowPos3i(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glWindowPos3i(n, n2, n3);
        this.println("");
    }

    public void glWindowPos3iARB(int n, int n2, int n3) {
        this.printIndent();
        this.print("glWindowPos3iARB(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glWindowPos3iARB(n, n2, n3);
        this.println("");
    }

    public void glWindowPos3iMESA(int n, int n2, int n3) {
        this.printIndent();
        this.print("glWindowPos3iMESA(" + n + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glWindowPos3iMESA(n, n2, n3);
        this.println("");
    }

    public void glWindowPos3iv(int[] nArray) {
        this.printIndent();
        this.print("glWindowPos3iv(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glWindowPos3iv(nArray);
        this.println("");
    }

    public void glWindowPos3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos3iv(" + intBuffer + ")");
        this.downstreamGL.glWindowPos3iv(intBuffer);
        this.println("");
    }

    public void glWindowPos3ivARB(int[] nArray) {
        this.printIndent();
        this.print("glWindowPos3ivARB(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glWindowPos3ivARB(nArray);
        this.println("");
    }

    public void glWindowPos3ivARB(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos3ivARB(" + intBuffer + ")");
        this.downstreamGL.glWindowPos3ivARB(intBuffer);
        this.println("");
    }

    public void glWindowPos3ivMESA(int[] nArray) {
        this.printIndent();
        this.print("glWindowPos3ivMESA(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glWindowPos3ivMESA(nArray);
        this.println("");
    }

    public void glWindowPos3ivMESA(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos3ivMESA(" + intBuffer + ")");
        this.downstreamGL.glWindowPos3ivMESA(intBuffer);
        this.println("");
    }

    public void glWindowPos3s(short s, short s2, short s3) {
        this.printIndent();
        this.print("glWindowPos3s(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glWindowPos3s(s, s2, s3);
        this.println("");
    }

    public void glWindowPos3sARB(short s, short s2, short s3) {
        this.printIndent();
        this.print("glWindowPos3sARB(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glWindowPos3sARB(s, s2, s3);
        this.println("");
    }

    public void glWindowPos3sMESA(short s, short s2, short s3) {
        this.printIndent();
        this.print("glWindowPos3sMESA(" + s + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glWindowPos3sMESA(s, s2, s3);
        this.println("");
    }

    public void glWindowPos3sv(short[] sArray) {
        this.printIndent();
        this.print("glWindowPos3sv(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glWindowPos3sv(sArray);
        this.println("");
    }

    public void glWindowPos3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos3sv(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos3sv(shortBuffer);
        this.println("");
    }

    public void glWindowPos3svARB(short[] sArray) {
        this.printIndent();
        this.print("glWindowPos3svARB(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glWindowPos3svARB(sArray);
        this.println("");
    }

    public void glWindowPos3svARB(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos3svARB(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos3svARB(shortBuffer);
        this.println("");
    }

    public void glWindowPos3svMESA(short[] sArray) {
        this.printIndent();
        this.print("glWindowPos3svMESA(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glWindowPos3svMESA(sArray);
        this.println("");
    }

    public void glWindowPos3svMESA(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos3svMESA(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos3svMESA(shortBuffer);
        this.println("");
    }

    public void glWindowPos4dMESA(double d, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glWindowPos4dMESA(" + d + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glWindowPos4dMESA(d, d2, d3, d4);
        this.println("");
    }

    public void glWindowPos4dvMESA(double[] dArray) {
        this.printIndent();
        this.print("glWindowPos4dvMESA(" + this.dumpArray(dArray) + ")");
        this.downstreamGL.glWindowPos4dvMESA(dArray);
        this.println("");
    }

    public void glWindowPos4dvMESA(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos4dvMESA(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos4dvMESA(doubleBuffer);
        this.println("");
    }

    public void glWindowPos4fMESA(float f, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glWindowPos4fMESA(" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glWindowPos4fMESA(f, f2, f3, f4);
        this.println("");
    }

    public void glWindowPos4fvMESA(float[] fArray) {
        this.printIndent();
        this.print("glWindowPos4fvMESA(" + this.dumpArray(fArray) + ")");
        this.downstreamGL.glWindowPos4fvMESA(fArray);
        this.println("");
    }

    public void glWindowPos4fvMESA(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos4fvMESA(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos4fvMESA(floatBuffer);
        this.println("");
    }

    public void glWindowPos4iMESA(int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glWindowPos4iMESA(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glWindowPos4iMESA(n, n2, n3, n4);
        this.println("");
    }

    public void glWindowPos4ivMESA(int[] nArray) {
        this.printIndent();
        this.print("glWindowPos4ivMESA(" + this.dumpArray(nArray) + ")");
        this.downstreamGL.glWindowPos4ivMESA(nArray);
        this.println("");
    }

    public void glWindowPos4ivMESA(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos4ivMESA(" + intBuffer + ")");
        this.downstreamGL.glWindowPos4ivMESA(intBuffer);
        this.println("");
    }

    public void glWindowPos4sMESA(short s, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glWindowPos4sMESA(" + s + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glWindowPos4sMESA(s, s2, s3, s4);
        this.println("");
    }

    public void glWindowPos4svMESA(short[] sArray) {
        this.printIndent();
        this.print("glWindowPos4svMESA(" + this.dumpArray(sArray) + ")");
        this.downstreamGL.glWindowPos4svMESA(sArray);
        this.println("");
    }

    public void glWindowPos4svMESA(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos4svMESA(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos4svMESA(shortBuffer);
        this.println("");
    }

    public void glWriteMaskEXT(int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glWriteMaskEXT(" + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glWriteMaskEXT(n, n2, n3, n4, n5, n6);
        this.println("");
    }

    public boolean isFunctionAvailable(String string) {
        this.printIndent();
        this.print("isFunctionAvailable(" + string + ")");
        boolean bl = this.downstreamGL.isFunctionAvailable(string);
        this.println(" = " + bl);
        return bl;
    }

    public boolean isExtensionAvailable(String string) {
        this.printIndent();
        this.print("isExtensionAvailable(" + string + ")");
        boolean bl = this.downstreamGL.isExtensionAvailable(string);
        this.println(" = " + bl);
        return bl;
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glAllocateMemoryNV(" + n + "," + f + "," + f2 + "," + f3 + ")");
        ByteBuffer byteBuffer = this.downstreamGL.glAllocateMemoryNV(n, f, f2, f3);
        this.println(" = " + byteBuffer);
        return byteBuffer;
    }

    public void setSwapInterval(int n) {
        this.printIndent();
        this.print("setSwapInterval(" + n + ")");
        this.downstreamGL.setSwapInterval(n);
        this.println("");
    }

    public ByteBuffer wglAllocateMemoryNV(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("wglAllocateMemoryNV(" + n + "," + f + "," + f2 + "," + f3 + ")");
        ByteBuffer byteBuffer = this.downstreamGL.wglAllocateMemoryNV(n, f, f2, f3);
        this.println(" = " + byteBuffer);
        return byteBuffer;
    }

    public boolean wglBeginFrameTrackingI3D() {
        this.printIndent();
        this.print("wglBeginFrameTrackingI3D()");
        boolean bl = this.downstreamGL.wglBeginFrameTrackingI3D();
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglBindDisplayColorTableEXT(short s) {
        this.printIndent();
        this.print("wglBindDisplayColorTableEXT(" + s + ")");
        boolean bl = this.downstreamGL.wglBindDisplayColorTableEXT(s);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglBindTexImageARB(long l, int n) {
        this.printIndent();
        this.print("wglBindTexImageARB(" + l + "," + n + ")");
        boolean bl = this.downstreamGL.wglBindTexImageARB(l, n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglChoosePixelFormatARB(long l, int[] nArray, float[] fArray, int n, int[] nArray2, int[] nArray3) {
        this.printIndent();
        this.print("wglChoosePixelFormatARB(" + l + "," + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + "," + n + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + ")");
        boolean bl = this.downstreamGL.wglChoosePixelFormatARB(l, nArray, fArray, n, nArray2, nArray3);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglChoosePixelFormatARB(long l, IntBuffer intBuffer, FloatBuffer floatBuffer, int n, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        this.printIndent();
        this.print("wglChoosePixelFormatARB(" + l + "," + intBuffer + "," + floatBuffer + "," + n + "," + intBuffer2 + "," + intBuffer3 + ")");
        boolean bl = this.downstreamGL.wglChoosePixelFormatARB(l, intBuffer, floatBuffer, n, intBuffer2, intBuffer3);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglChoosePixelFormatEXT(long l, int[] nArray, float[] fArray, int n, int[] nArray2, int[] nArray3) {
        this.printIndent();
        this.print("wglChoosePixelFormatEXT(" + l + "," + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + "," + n + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + ")");
        boolean bl = this.downstreamGL.wglChoosePixelFormatEXT(l, nArray, fArray, n, nArray2, nArray3);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglChoosePixelFormatEXT(long l, IntBuffer intBuffer, FloatBuffer floatBuffer, int n, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        this.printIndent();
        this.print("wglChoosePixelFormatEXT(" + l + "," + intBuffer + "," + floatBuffer + "," + n + "," + intBuffer2 + "," + intBuffer3 + ")");
        boolean bl = this.downstreamGL.wglChoosePixelFormatEXT(l, intBuffer, floatBuffer, n, intBuffer2, intBuffer3);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglCreateDisplayColorTableEXT(short s) {
        this.printIndent();
        this.print("wglCreateDisplayColorTableEXT(" + s + ")");
        boolean bl = this.downstreamGL.wglCreateDisplayColorTableEXT(s);
        this.println(" = " + bl);
        return bl;
    }

    public long wglCreatePbufferARB(long l, int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("wglCreatePbufferARB(" + l + "," + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        long l2 = this.downstreamGL.wglCreatePbufferARB(l, n, n2, n3, nArray);
        this.println(" = " + l2);
        return l2;
    }

    public long wglCreatePbufferARB(long l, int n, int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("wglCreatePbufferARB(" + l + "," + n + "," + n2 + "," + n3 + "," + intBuffer + ")");
        long l2 = this.downstreamGL.wglCreatePbufferARB(l, n, n2, n3, intBuffer);
        this.println(" = " + l2);
        return l2;
    }

    public long wglCreatePbufferEXT(long l, int n, int n2, int n3, int[] nArray) {
        this.printIndent();
        this.print("wglCreatePbufferEXT(" + l + "," + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + ")");
        long l2 = this.downstreamGL.wglCreatePbufferEXT(l, n, n2, n3, nArray);
        this.println(" = " + l2);
        return l2;
    }

    public long wglCreatePbufferEXT(long l, int n, int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("wglCreatePbufferEXT(" + l + "," + n + "," + n2 + "," + n3 + "," + intBuffer + ")");
        long l2 = this.downstreamGL.wglCreatePbufferEXT(l, n, n2, n3, intBuffer);
        this.println(" = " + l2);
        return l2;
    }

    public void wglDestroyDisplayColorTableEXT(short s) {
        this.printIndent();
        this.print("wglDestroyDisplayColorTableEXT(" + s + ")");
        this.downstreamGL.wglDestroyDisplayColorTableEXT(s);
        this.println("");
    }

    public boolean wglDestroyPbufferARB(long l) {
        this.printIndent();
        this.print("wglDestroyPbufferARB(" + l + ")");
        boolean bl = this.downstreamGL.wglDestroyPbufferARB(l);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglDestroyPbufferEXT(long l) {
        this.printIndent();
        this.print("wglDestroyPbufferEXT(" + l + ")");
        boolean bl = this.downstreamGL.wglDestroyPbufferEXT(l);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglDisableFrameLockI3D() {
        this.printIndent();
        this.print("wglDisableFrameLockI3D()");
        boolean bl = this.downstreamGL.wglDisableFrameLockI3D();
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglEnableFrameLockI3D() {
        this.printIndent();
        this.print("wglEnableFrameLockI3D()");
        boolean bl = this.downstreamGL.wglEnableFrameLockI3D();
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglEndFrameTrackingI3D() {
        this.printIndent();
        this.print("wglEndFrameTrackingI3D()");
        boolean bl = this.downstreamGL.wglEndFrameTrackingI3D();
        this.println(" = " + bl);
        return bl;
    }

    public void wglFreeMemoryNV(Buffer buffer) {
        this.printIndent();
        this.print("wglFreeMemoryNV(" + buffer + ")");
        this.downstreamGL.wglFreeMemoryNV(buffer);
        this.println("");
    }

    public long wglGetCurrentReadDCARB() {
        this.printIndent();
        this.print("wglGetCurrentReadDCARB()");
        long l = this.downstreamGL.wglGetCurrentReadDCARB();
        this.println(" = " + l);
        return l;
    }

    public long wglGetCurrentReadDCEXT() {
        this.printIndent();
        this.print("wglGetCurrentReadDCEXT()");
        long l = this.downstreamGL.wglGetCurrentReadDCEXT();
        this.println(" = " + l);
        return l;
    }

    public String wglGetExtensionsStringARB(long l) {
        this.printIndent();
        this.print("wglGetExtensionsStringARB(" + l + ")");
        String string = this.downstreamGL.wglGetExtensionsStringARB(l);
        this.println(" = " + string);
        return string;
    }

    public String wglGetExtensionsStringEXT() {
        this.printIndent();
        this.print("wglGetExtensionsStringEXT()");
        String string = this.downstreamGL.wglGetExtensionsStringEXT();
        this.println(" = " + string);
        return string;
    }

    public boolean wglGetFrameUsageI3D(float[] fArray) {
        this.printIndent();
        this.print("wglGetFrameUsageI3D(" + this.dumpArray(fArray) + ")");
        boolean bl = this.downstreamGL.wglGetFrameUsageI3D(fArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglGetFrameUsageI3D(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("wglGetFrameUsageI3D(" + floatBuffer + ")");
        boolean bl = this.downstreamGL.wglGetFrameUsageI3D(floatBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public long wglGetPbufferDCARB(long l) {
        this.printIndent();
        this.print("wglGetPbufferDCARB(" + l + ")");
        long l2 = this.downstreamGL.wglGetPbufferDCARB(l);
        this.println(" = " + l2);
        return l2;
    }

    public long wglGetPbufferDCEXT(long l) {
        this.printIndent();
        this.print("wglGetPbufferDCEXT(" + l + ")");
        long l2 = this.downstreamGL.wglGetPbufferDCEXT(l);
        this.println(" = " + l2);
        return l2;
    }

    public boolean wglGetPixelFormatAttribfvARB(long l, int n, int n2, int n3, int[] nArray, float[] fArray) {
        this.printIndent();
        this.print("wglGetPixelFormatAttribfvARB(" + l + "," + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + ")");
        boolean bl = this.downstreamGL.wglGetPixelFormatAttribfvARB(l, n, n2, n3, nArray, fArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglGetPixelFormatAttribfvARB(long l, int n, int n2, int n3, IntBuffer intBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("wglGetPixelFormatAttribfvARB(" + l + "," + n + "," + n2 + "," + n3 + "," + intBuffer + "," + floatBuffer + ")");
        boolean bl = this.downstreamGL.wglGetPixelFormatAttribfvARB(l, n, n2, n3, intBuffer, floatBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglGetPixelFormatAttribfvEXT(long l, int n, int n2, int n3, int[] nArray, float[] fArray) {
        this.printIndent();
        this.print("wglGetPixelFormatAttribfvEXT(" + l + "," + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(fArray) + ")");
        boolean bl = this.downstreamGL.wglGetPixelFormatAttribfvEXT(l, n, n2, n3, nArray, fArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglGetPixelFormatAttribfvEXT(long l, int n, int n2, int n3, IntBuffer intBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("wglGetPixelFormatAttribfvEXT(" + l + "," + n + "," + n2 + "," + n3 + "," + intBuffer + "," + floatBuffer + ")");
        boolean bl = this.downstreamGL.wglGetPixelFormatAttribfvEXT(l, n, n2, n3, intBuffer, floatBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglGetPixelFormatAttribivARB(long l, int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this.printIndent();
        this.print("wglGetPixelFormatAttribivARB(" + l + "," + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + ")");
        boolean bl = this.downstreamGL.wglGetPixelFormatAttribivARB(l, n, n2, n3, nArray, nArray2);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglGetPixelFormatAttribivARB(long l, int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        this.printIndent();
        this.print("wglGetPixelFormatAttribivARB(" + l + "," + n + "," + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + ")");
        boolean bl = this.downstreamGL.wglGetPixelFormatAttribivARB(l, n, n2, n3, intBuffer, intBuffer2);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglGetPixelFormatAttribivEXT(long l, int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this.printIndent();
        this.print("wglGetPixelFormatAttribivEXT(" + l + "," + n + "," + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + ")");
        boolean bl = this.downstreamGL.wglGetPixelFormatAttribivEXT(l, n, n2, n3, nArray, nArray2);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglGetPixelFormatAttribivEXT(long l, int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        this.printIndent();
        this.print("wglGetPixelFormatAttribivEXT(" + l + "," + n + "," + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + ")");
        boolean bl = this.downstreamGL.wglGetPixelFormatAttribivEXT(l, n, n2, n3, intBuffer, intBuffer2);
        this.println(" = " + bl);
        return bl;
    }

    public int wglGetSwapIntervalEXT() {
        this.printIndent();
        this.print("wglGetSwapIntervalEXT()");
        int n = this.downstreamGL.wglGetSwapIntervalEXT();
        this.println(" = " + n);
        return n;
    }

    public boolean wglIsEnabledFrameLockI3D(int[] nArray) {
        this.printIndent();
        this.print("wglIsEnabledFrameLockI3D(" + this.dumpArray(nArray) + ")");
        boolean bl = this.downstreamGL.wglIsEnabledFrameLockI3D(nArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglIsEnabledFrameLockI3D(IntBuffer intBuffer) {
        this.printIndent();
        this.print("wglIsEnabledFrameLockI3D(" + intBuffer + ")");
        boolean bl = this.downstreamGL.wglIsEnabledFrameLockI3D(intBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglLoadDisplayColorTableEXT(short[] sArray, int n) {
        this.printIndent();
        this.print("wglLoadDisplayColorTableEXT(" + this.dumpArray(sArray) + "," + n + ")");
        boolean bl = this.downstreamGL.wglLoadDisplayColorTableEXT(sArray, n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglLoadDisplayColorTableEXT(ShortBuffer shortBuffer, int n) {
        this.printIndent();
        this.print("wglLoadDisplayColorTableEXT(" + shortBuffer + "," + n + ")");
        boolean bl = this.downstreamGL.wglLoadDisplayColorTableEXT(shortBuffer, n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglMakeContextCurrentARB(long l, long l2, long l3) {
        this.printIndent();
        this.print("wglMakeContextCurrentARB(" + l + "," + l2 + "," + l3 + ")");
        boolean bl = this.downstreamGL.wglMakeContextCurrentARB(l, l2, l3);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglMakeContextCurrentEXT(long l, long l2, long l3) {
        this.printIndent();
        this.print("wglMakeContextCurrentEXT(" + l + "," + l2 + "," + l3 + ")");
        boolean bl = this.downstreamGL.wglMakeContextCurrentEXT(l, l2, l3);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglQueryFrameLockMasterI3D(int[] nArray) {
        this.printIndent();
        this.print("wglQueryFrameLockMasterI3D(" + this.dumpArray(nArray) + ")");
        boolean bl = this.downstreamGL.wglQueryFrameLockMasterI3D(nArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglQueryFrameLockMasterI3D(IntBuffer intBuffer) {
        this.printIndent();
        this.print("wglQueryFrameLockMasterI3D(" + intBuffer + ")");
        boolean bl = this.downstreamGL.wglQueryFrameLockMasterI3D(intBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglQueryFrameTrackingI3D(int[] nArray, int[] nArray2, float[] fArray) {
        this.printIndent();
        this.print("wglQueryFrameTrackingI3D(" + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(fArray) + ")");
        boolean bl = this.downstreamGL.wglQueryFrameTrackingI3D(nArray, nArray2, fArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglQueryFrameTrackingI3D(IntBuffer intBuffer, IntBuffer intBuffer2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("wglQueryFrameTrackingI3D(" + intBuffer + "," + intBuffer2 + "," + floatBuffer + ")");
        boolean bl = this.downstreamGL.wglQueryFrameTrackingI3D(intBuffer, intBuffer2, floatBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglQueryPbufferARB(long l, int n, int[] nArray) {
        this.printIndent();
        this.print("wglQueryPbufferARB(" + l + "," + n + "," + this.dumpArray(nArray) + ")");
        boolean bl = this.downstreamGL.wglQueryPbufferARB(l, n, nArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglQueryPbufferARB(long l, int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("wglQueryPbufferARB(" + l + "," + n + "," + intBuffer + ")");
        boolean bl = this.downstreamGL.wglQueryPbufferARB(l, n, intBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglQueryPbufferEXT(long l, int n, int[] nArray) {
        this.printIndent();
        this.print("wglQueryPbufferEXT(" + l + "," + n + "," + this.dumpArray(nArray) + ")");
        boolean bl = this.downstreamGL.wglQueryPbufferEXT(l, n, nArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglQueryPbufferEXT(long l, int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("wglQueryPbufferEXT(" + l + "," + n + "," + intBuffer + ")");
        boolean bl = this.downstreamGL.wglQueryPbufferEXT(l, n, intBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public int wglReleasePbufferDCARB(long l, long l2) {
        this.printIndent();
        this.print("wglReleasePbufferDCARB(" + l + "," + l2 + ")");
        int n = this.downstreamGL.wglReleasePbufferDCARB(l, l2);
        this.println(" = " + n);
        return n;
    }

    public int wglReleasePbufferDCEXT(long l, long l2) {
        this.printIndent();
        this.print("wglReleasePbufferDCEXT(" + l + "," + l2 + ")");
        int n = this.downstreamGL.wglReleasePbufferDCEXT(l, l2);
        this.println(" = " + n);
        return n;
    }

    public boolean wglReleaseTexImageARB(long l, int n) {
        this.printIndent();
        this.print("wglReleaseTexImageARB(" + l + "," + n + ")");
        boolean bl = this.downstreamGL.wglReleaseTexImageARB(l, n);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglSetPbufferAttribARB(long l, int[] nArray) {
        this.printIndent();
        this.print("wglSetPbufferAttribARB(" + l + "," + this.dumpArray(nArray) + ")");
        boolean bl = this.downstreamGL.wglSetPbufferAttribARB(l, nArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglSetPbufferAttribARB(long l, IntBuffer intBuffer) {
        this.printIndent();
        this.print("wglSetPbufferAttribARB(" + l + "," + intBuffer + ")");
        boolean bl = this.downstreamGL.wglSetPbufferAttribARB(l, intBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean wglSwapIntervalEXT(int n) {
        this.printIndent();
        this.print("wglSwapIntervalEXT(" + n + ")");
        boolean bl = this.downstreamGL.wglSwapIntervalEXT(n);
        this.println(" = " + bl);
        return bl;
    }

    public ByteBuffer glXAllocateMemoryNV(int n, float f, float f2, float f3) {
        this.printIndent();
        this.print("glXAllocateMemoryNV(" + n + "," + f + "," + f2 + "," + f3 + ")");
        ByteBuffer byteBuffer = this.downstreamGL.glXAllocateMemoryNV(n, f, f2, f3);
        this.println(" = " + byteBuffer);
        return byteBuffer;
    }

    public int glXBindChannelToWindowSGIX(long l, int n, int n2, long l2) {
        this.printIndent();
        this.print("glXBindChannelToWindowSGIX(" + l + "," + n + "," + n2 + "," + l2 + ")");
        int n3 = this.downstreamGL.glXBindChannelToWindowSGIX(l, n, n2, l2);
        this.println(" = " + n3);
        return n3;
    }

    public void glXBindSwapBarrierSGIX(long l, long l2, int n) {
        this.printIndent();
        this.print("glXBindSwapBarrierSGIX(" + l + "," + l2 + "," + n + ")");
        this.downstreamGL.glXBindSwapBarrierSGIX(l, l2, n);
        this.println("");
    }

    public int glXChannelRectSGIX(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glXChannelRectSGIX(" + l + "," + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        int n7 = this.downstreamGL.glXChannelRectSGIX(l, n, n2, n3, n4, n5, n6);
        this.println(" = " + n7);
        return n7;
    }

    public int glXChannelRectSyncSGIX(long l, int n, int n2, int n3) {
        this.printIndent();
        this.print("glXChannelRectSyncSGIX(" + l + "," + n + "," + n2 + "," + n3 + ")");
        int n4 = this.downstreamGL.glXChannelRectSyncSGIX(l, n, n2, n3);
        this.println(" = " + n4);
        return n4;
    }

    public void glXCopySubBufferMESA(long l, long l2, int n, int n2, int n3, int n4) {
        this.printIndent();
        this.print("glXCopySubBufferMESA(" + l + "," + l2 + "," + n + "," + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glXCopySubBufferMESA(l, l2, n, n2, n3, n4);
        this.println("");
    }

    public void glXCushionSGI(long l, long l2, float f) {
        this.printIndent();
        this.print("glXCushionSGI(" + l + "," + l2 + "," + f + ")");
        this.downstreamGL.glXCushionSGI(l, l2, f);
        this.println("");
    }

    public void glXFreeContextEXT(long l, long l2) {
        this.printIndent();
        this.print("glXFreeContextEXT(" + l + "," + l2 + ")");
        this.downstreamGL.glXFreeContextEXT(l, l2);
        this.println("");
    }

    public void glXFreeMemoryNV(Buffer buffer) {
        this.printIndent();
        this.print("glXFreeMemoryNV(" + buffer + ")");
        this.downstreamGL.glXFreeMemoryNV(buffer);
        this.println("");
    }

    public int glXGetAGPOffsetMESA(boolean[] blArray) {
        this.printIndent();
        this.print("glXGetAGPOffsetMESA(" + this.dumpArray(blArray) + ")");
        int n = this.downstreamGL.glXGetAGPOffsetMESA(blArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetAGPOffsetMESA(char[] cArray) {
        this.printIndent();
        this.print("glXGetAGPOffsetMESA(" + this.dumpArray(cArray) + ")");
        int n = this.downstreamGL.glXGetAGPOffsetMESA(cArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetAGPOffsetMESA(byte[] byArray) {
        this.printIndent();
        this.print("glXGetAGPOffsetMESA(" + this.dumpArray(byArray) + ")");
        int n = this.downstreamGL.glXGetAGPOffsetMESA(byArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetAGPOffsetMESA(short[] sArray) {
        this.printIndent();
        this.print("glXGetAGPOffsetMESA(" + this.dumpArray(sArray) + ")");
        int n = this.downstreamGL.glXGetAGPOffsetMESA(sArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetAGPOffsetMESA(int[] nArray) {
        this.printIndent();
        this.print("glXGetAGPOffsetMESA(" + this.dumpArray(nArray) + ")");
        int n = this.downstreamGL.glXGetAGPOffsetMESA(nArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetAGPOffsetMESA(long[] lArray) {
        this.printIndent();
        this.print("glXGetAGPOffsetMESA(" + this.dumpArray(lArray) + ")");
        int n = this.downstreamGL.glXGetAGPOffsetMESA(lArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetAGPOffsetMESA(float[] fArray) {
        this.printIndent();
        this.print("glXGetAGPOffsetMESA(" + this.dumpArray(fArray) + ")");
        int n = this.downstreamGL.glXGetAGPOffsetMESA(fArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetAGPOffsetMESA(double[] dArray) {
        this.printIndent();
        this.print("glXGetAGPOffsetMESA(" + this.dumpArray(dArray) + ")");
        int n = this.downstreamGL.glXGetAGPOffsetMESA(dArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetAGPOffsetMESA(Buffer buffer) {
        this.printIndent();
        this.print("glXGetAGPOffsetMESA(" + buffer + ")");
        int n = this.downstreamGL.glXGetAGPOffsetMESA(buffer);
        this.println(" = " + n);
        return n;
    }

    public long glXGetContextIDEXT(long l) {
        this.printIndent();
        this.print("glXGetContextIDEXT(" + l + ")");
        long l2 = this.downstreamGL.glXGetContextIDEXT(l);
        this.println(" = " + l2);
        return l2;
    }

    public long glXGetCurrentDisplayEXT() {
        this.printIndent();
        this.print("glXGetCurrentDisplayEXT()");
        long l = this.downstreamGL.glXGetCurrentDisplayEXT();
        this.println(" = " + l);
        return l;
    }

    public long glXGetCurrentReadDrawableSGI() {
        this.printIndent();
        this.print("glXGetCurrentReadDrawableSGI()");
        long l = this.downstreamGL.glXGetCurrentReadDrawableSGI();
        this.println(" = " + l);
        return l;
    }

    public long glXGetProcAddressARB(String string) {
        this.printIndent();
        this.print("glXGetProcAddressARB(" + string + ")");
        long l = this.downstreamGL.glXGetProcAddressARB(string);
        this.println(" = " + l);
        return l;
    }

    public int glXGetTransparentIndexSUN(long l, long l2, long l3, int[] nArray) {
        this.printIndent();
        this.print("glXGetTransparentIndexSUN(" + l + "," + l2 + "," + l3 + "," + this.dumpArray(nArray) + ")");
        int n = this.downstreamGL.glXGetTransparentIndexSUN(l, l2, l3, nArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetTransparentIndexSUN(long l, long l2, long l3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glXGetTransparentIndexSUN(" + l + "," + l2 + "," + l3 + "," + intBuffer + ")");
        int n = this.downstreamGL.glXGetTransparentIndexSUN(l, l2, l3, intBuffer);
        this.println(" = " + n);
        return n;
    }

    public int glXGetVideoSyncSGI(int[] nArray) {
        this.printIndent();
        this.print("glXGetVideoSyncSGI(" + this.dumpArray(nArray) + ")");
        int n = this.downstreamGL.glXGetVideoSyncSGI(nArray);
        this.println(" = " + n);
        return n;
    }

    public int glXGetVideoSyncSGI(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glXGetVideoSyncSGI(" + intBuffer + ")");
        int n = this.downstreamGL.glXGetVideoSyncSGI(intBuffer);
        this.println(" = " + n);
        return n;
    }

    public long glXImportContextEXT(long l, long l2) {
        this.printIndent();
        this.print("glXImportContextEXT(" + l + "," + l2 + ")");
        long l3 = this.downstreamGL.glXImportContextEXT(l, l2);
        this.println(" = " + l3);
        return l3;
    }

    public void glXJoinSwapGroupSGIX(long l, long l2, long l3) {
        this.printIndent();
        this.print("glXJoinSwapGroupSGIX(" + l + "," + l2 + "," + l3 + ")");
        this.downstreamGL.glXJoinSwapGroupSGIX(l, l2, l3);
        this.println("");
    }

    public boolean glXMakeCurrentReadSGI(long l, long l2, long l3, long l4) {
        this.printIndent();
        this.print("glXMakeCurrentReadSGI(" + l + "," + l2 + "," + l3 + "," + l4 + ")");
        boolean bl = this.downstreamGL.glXMakeCurrentReadSGI(l, l2, l3, l4);
        this.println(" = " + bl);
        return bl;
    }

    public int glXQueryChannelDeltasSGIX(long l, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.printIndent();
        this.print("glXQueryChannelDeltasSGIX(" + l + "," + n + "," + n2 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + "," + this.dumpArray(nArray4) + ")");
        int n3 = this.downstreamGL.glXQueryChannelDeltasSGIX(l, n, n2, nArray, nArray2, nArray3, nArray4);
        this.println(" = " + n3);
        return n3;
    }

    public int glXQueryChannelDeltasSGIX(long l, int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, IntBuffer intBuffer4) {
        this.printIndent();
        this.print("glXQueryChannelDeltasSGIX(" + l + "," + n + "," + n2 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + intBuffer4 + ")");
        int n3 = this.downstreamGL.glXQueryChannelDeltasSGIX(l, n, n2, intBuffer, intBuffer2, intBuffer3, intBuffer4);
        this.println(" = " + n3);
        return n3;
    }

    public int glXQueryChannelRectSGIX(long l, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.printIndent();
        this.print("glXQueryChannelRectSGIX(" + l + "," + n + "," + n2 + "," + this.dumpArray(nArray) + "," + this.dumpArray(nArray2) + "," + this.dumpArray(nArray3) + "," + this.dumpArray(nArray4) + ")");
        int n3 = this.downstreamGL.glXQueryChannelRectSGIX(l, n, n2, nArray, nArray2, nArray3, nArray4);
        this.println(" = " + n3);
        return n3;
    }

    public int glXQueryChannelRectSGIX(long l, int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, IntBuffer intBuffer4) {
        this.printIndent();
        this.print("glXQueryChannelRectSGIX(" + l + "," + n + "," + n2 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + intBuffer4 + ")");
        int n3 = this.downstreamGL.glXQueryChannelRectSGIX(l, n, n2, intBuffer, intBuffer2, intBuffer3, intBuffer4);
        this.println(" = " + n3);
        return n3;
    }

    public int glXQueryContextInfoEXT(long l, long l2, int n, int[] nArray) {
        this.printIndent();
        this.print("glXQueryContextInfoEXT(" + l + "," + l2 + "," + n + "," + this.dumpArray(nArray) + ")");
        int n2 = this.downstreamGL.glXQueryContextInfoEXT(l, l2, n, nArray);
        this.println(" = " + n2);
        return n2;
    }

    public int glXQueryContextInfoEXT(long l, long l2, int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glXQueryContextInfoEXT(" + l + "," + l2 + "," + n + "," + intBuffer + ")");
        int n2 = this.downstreamGL.glXQueryContextInfoEXT(l, l2, n, intBuffer);
        this.println(" = " + n2);
        return n2;
    }

    public boolean glXQueryMaxSwapBarriersSGIX(long l, int n, int[] nArray) {
        this.printIndent();
        this.print("glXQueryMaxSwapBarriersSGIX(" + l + "," + n + "," + this.dumpArray(nArray) + ")");
        boolean bl = this.downstreamGL.glXQueryMaxSwapBarriersSGIX(l, n, nArray);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glXQueryMaxSwapBarriersSGIX(long l, int n, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glXQueryMaxSwapBarriersSGIX(" + l + "," + n + "," + intBuffer + ")");
        boolean bl = this.downstreamGL.glXQueryMaxSwapBarriersSGIX(l, n, intBuffer);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glXReleaseBuffersMESA(long l, long l2) {
        this.printIndent();
        this.print("glXReleaseBuffersMESA(" + l + "," + l2 + ")");
        boolean bl = this.downstreamGL.glXReleaseBuffersMESA(l, l2);
        this.println(" = " + bl);
        return bl;
    }

    public boolean glXSet3DfxModeMESA(int n) {
        this.printIndent();
        this.print("glXSet3DfxModeMESA(" + n + ")");
        boolean bl = this.downstreamGL.glXSet3DfxModeMESA(n);
        this.println(" = " + bl);
        return bl;
    }

    public int glXSwapIntervalSGI(int n) {
        this.printIndent();
        this.print("glXSwapIntervalSGI(" + n + ")");
        int n2 = this.downstreamGL.glXSwapIntervalSGI(n);
        this.println(" = " + n2);
        return n2;
    }

    public int glXWaitVideoSyncSGI(int n, int n2, int[] nArray) {
        this.printIndent();
        this.print("glXWaitVideoSyncSGI(" + n + "," + n2 + "," + this.dumpArray(nArray) + ")");
        int n3 = this.downstreamGL.glXWaitVideoSyncSGI(n, n2, nArray);
        this.println(" = " + n3);
        return n3;
    }

    public int glXWaitVideoSyncSGI(int n, int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glXWaitVideoSyncSGI(" + n + "," + n2 + "," + intBuffer + ")");
        int n3 = this.downstreamGL.glXWaitVideoSyncSGI(n, n2, intBuffer);
        this.println(" = " + n3);
        return n3;
    }

    protected String dumpArray(Object object) {
        if (object == null) {
            return "[null]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = Array.getLength(object);
        int n2 = Math.min(n, 16);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(Array.get(object, i));
            if (i >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        if (n > 16) {
            stringBuffer.append("...").append(n);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected void print(String string) {
        this.stream.print(string);
    }

    protected void println(String string) {
        this.stream.println(string);
    }

    protected void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.stream.print(' ');
        }
    }
}

