/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.vis.Shape;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Observable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.util.GLUT;

public class ColorScale
extends Observable
implements Shape {
    private Color textColor = Color.white;
    private int font = 1;
    private GLUT glut = new GLUT();
    private boolean dirty = true;
    private boolean enabled = true;
    private ColorSet colorSet = ColorSet.RAINBOW;
    private String lowString;
    private String highString;
    private String label;
    private double fontScale = 0.12;
    private float leftMargin = 25.0f;
    private float leftTextMargin = 5.0f;
    private int displayList;
    private int width = 25;
    private int height = 300;
    private int topBottomMargin = 60;
    private boolean oldReverseVideo;
    private int oldWidth;
    private int oldHeight;
    private boolean oldAntiAlias;

    public void setStrings(String string, String string2, String string3) {
        this.lowString = string;
        this.highString = string2;
        this.label = string3;
        this.dirty = true;
    }

    public Color getColor(float f) {
        float f2 = f;
        int n = 0;
        int n2 = this.colorSet.colorsR.length - 1;
        n = 0;
        f = f2 * (float)n2;
        for (float f3 = 1.0f / (float)n2; f2 > f3; f3 += 1.0f / (float)n2) {
            ++n;
            f = (f2 - f3) * (float)n2;
        }
        double d = this.colorSet.colorsR[n] + (double)f * (this.colorSet.colorsR[n + 1] - this.colorSet.colorsR[n]);
        double d2 = this.colorSet.colorsG[n] + (double)f * (this.colorSet.colorsG[n + 1] - this.colorSet.colorsG[n]);
        double d3 = this.colorSet.colorsB[n] + (double)f * (this.colorSet.colorsB[n + 1] - this.colorSet.colorsB[n]);
        d = Math.min(d, 1.0);
        d2 = Math.min(d2, 1.0);
        d3 = Math.min(d3, 1.0);
        d = Math.max(d, 0.0);
        d2 = Math.max(d2, 0.0);
        d3 = Math.max(d3, 0.0);
        return new Color((float)d, (float)d2, (float)d3);
    }

    public JPanel getControlPanel(final VisRenderer visRenderer) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        JCheckBox jCheckBox = new JCheckBox("Show ColorScale", true);
        VisTools.addCompItem(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorScale.this.enabled = ((JCheckBox)actionEvent.getSource()).isSelected();
                ColorScale.this.dirty = true;
                visRenderer.redraw();
            }
        });
        final JSlider jSlider = new JSlider(0, 100, (int)(this.getFontScale() * 100.0));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    ColorScale.this.setFontScale((double)jSlider.getValue() / 100.0);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        VisTools.addCompItem(jPanel, new JLabel("Font Size"), gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 1;
        VisTools.addCompItem(jPanel, jSlider, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 0;
        ButtonGroup buttonGroup = new ButtonGroup();
        final HashMap<JRadioButton, ColorSet> hashMap = new HashMap<JRadioButton, ColorSet>();
        int n = 0;
        int n2 = 2;
        for (int i = 0; i < ColorSet.VALUES.length; ++i) {
            ColorSet colorSet = ColorSet.VALUES[i];
            JRadioButton jRadioButton = new JRadioButton(colorSet.toString(), this.colorSet == colorSet);
            buttonGroup.add(jRadioButton);
            hashMap.put(jRadioButton, colorSet);
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorScale.this.colorSet = (ColorSet)hashMap.get(actionEvent.getSource());
                    ColorScale.this.dirty = true;
                    ColorScale.this.setChanged();
                    ColorScale.this.notifyObservers();
                    visRenderer.redraw();
                }
            });
            VisTools.addCompItem(jPanel, jRadioButton, gridBagConstraints, n, n2, 1, 1);
            if (n == 0) {
                ++n;
                continue;
            }
            n = 0;
            ++n2;
        }
        return jPanel;
    }

    private float getTextWidth(GL gL, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        float f = 0.0f;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            float f2 = this.glut.glutStrokeLength(this.font, string2);
            f = Math.max(f, f2);
        }
        return (float)((double)f * this.fontScale);
    }

    private void drawText(GL gL, double d, double d2, String string, boolean bl) {
        if (string == null) {
            return;
        }
        gL.glPushMatrix();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        n = stringTokenizer.countTokens();
        double d3 = 105.0 * this.fontScale;
        double d4 = 34.0 * this.fontScale;
        float f = (float)(139.0 * this.fontScale);
        f = (float)((d3 + d4) * 1.1);
        d2 = bl ? d2 - d3 - 5.0 : d2 + (double)(f * (float)(n - 1)) + d4 + 3.0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            double d5 = d;
            gL.glPushMatrix();
            float f2 = this.glut.glutStrokeLength(this.font, string2);
            gL.glTranslated(d5 -= (double)f2 * this.fontScale / 2.0, d2, 0.0);
            gL.glScaled(this.fontScale, this.fontScale, this.fontScale);
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                this.glut.glutStrokeCharacter(gL, this.font, c);
            }
            gL.glPopMatrix();
            gL.glTranslated(0.0, (double)(-f), 0.0);
        }
        gL.glPopMatrix();
    }

    public void render(VisRenderer visRenderer) {
        GLDrawable gLDrawable = visRenderer.getGLDrawable();
        if (this.oldReverseVideo != visRenderer.getReverseVideo()) {
            this.dirty = true;
        }
        this.oldReverseVideo = visRenderer.getReverseVideo();
        if (this.oldAntiAlias != visRenderer.getAntiAliasedLines()) {
            this.dirty = true;
        }
        this.oldAntiAlias = visRenderer.getAntiAliasedLines();
        if (!this.enabled) {
            return;
        }
        int n = (int)gLDrawable.getSize().getWidth();
        int n2 = (int)gLDrawable.getSize().getHeight();
        if (n != this.oldWidth || n2 != this.oldHeight) {
            this.dirty = true;
            this.oldWidth = n;
            this.oldHeight = n2;
        }
        GL gL = gLDrawable.getGL();
        if (this.dirty || this.displayList == 0) {
            if (this.displayList != 0) {
                gL.glDeleteLists(this.displayList, 1);
            }
            this.displayList = gL.glGenLists(1);
            gL.glNewList(this.displayList, 4864);
            this.privateRender(visRenderer);
            gL.glEndList();
            this.dirty = false;
        }
        gL.glCallList(this.displayList);
    }

    private void privateRender(VisRenderer visRenderer) {
        float f;
        float f2;
        GLDrawable gLDrawable = visRenderer.getGLDrawable();
        GL gL = gLDrawable.getGL();
        if (!this.enabled) {
            return;
        }
        int n = (int)gLDrawable.getSize().getWidth();
        int n2 = (int)gLDrawable.getSize().getHeight();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(0.0, (double)n, 0.0, (double)n2, -1.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glDisable(2896);
        gL.glDisable(2929);
        gL.glLineWidth(1.0f);
        if (visRenderer.getAntiAliasedLines()) {
            gL.glEnable(2848);
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
            gL.glHint(3154, 4354);
        } else {
            gL.glDisable(2848);
            gL.glDisable(3042);
        }
        int n3 = Math.min(this.height, this.height - this.topBottomMargin);
        int n4 = this.width;
        gL.glTranslated((double)this.leftMargin, (double)(n2 / 2 - n3 / 2), 0.0);
        gL.glShadeModel(7425);
        gL.glFrontFace(2304);
        gL.glBegin(7);
        int n5 = 10;
        float f3 = (float)n3 / 10.0f;
        for (f2 = 0.0f; f2 < (float)n5; f2 += 1.0f) {
            f = f2 / (float)n5;
            Color color = this.getColor(f);
            float f4 = (f2 + 1.0f) / (float)n5;
            Color color2 = this.getColor(f4);
            VisTools.glSetColor(gL, color);
            gL.glVertex3f((float)n4, f2 * f3, 0.0f);
            gL.glVertex3f(0.0f, f2 * f3, 0.0f);
            VisTools.glSetColor(gL, color2);
            gL.glVertex3f(0.0f, (f2 + 1.0f) * f3, 0.0f);
            gL.glVertex3f((float)n4, (f2 + 1.0f) * f3, 0.0f);
        }
        gL.glEnd();
        if (visRenderer.getReverseVideo()) {
            VisTools.glSetColor(gL, VisTools.invert(this.textColor));
        } else {
            VisTools.glSetColor(gL, this.textColor);
        }
        float f5 = 0.0f;
        f2 = this.getTextWidth(gL, this.highString);
        f = (float)(n4 / 2) - f2 / 2.0f;
        if (f < -this.leftMargin + this.leftTextMargin) {
            f5 = -f - this.leftMargin + this.leftTextMargin;
        }
        this.drawText(gL, f5 + (float)(n4 / 2), n3, this.highString, false);
        f5 = 0.0f;
        f2 = this.getTextWidth(gL, this.lowString);
        f = (float)(n4 / 2) - f2 / 2.0f;
        if (f < -this.leftMargin + this.leftTextMargin) {
            f5 = -f - this.leftMargin + this.leftTextMargin;
        }
        this.drawText(gL, f5 + (float)(n4 / 2), 0.0, this.lowString, true);
        gL.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        this.drawText(gL, n3 / 2, -n4, this.label, true);
        gL.glPopMatrix();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glEnable(2896);
        gL.glEnable(2929);
    }

    public double getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(double d) {
        this.fontScale = d;
        this.dirty = true;
    }

    public static class ColorSet {
        private final String name;
        public final double[] colorsR;
        public final double[] colorsG;
        public final double[] colorsB;
        public static final ColorSet RAINBOW = new ColorSet("Rainbow", new double[]{0.0, 0.0, 0.0, 1.0, 1.0}, new double[]{0.0, 1.0, 1.0, 1.0, 0.0}, new double[]{1.0, 1.0, 0.0, 0.0, 0.0});
        public static final ColorSet GRAYSCALE = new ColorSet("Grayscale", new double[]{0.0, 1.0}, new double[]{0.0, 1.0}, new double[]{0.0, 1.0});
        public static final ColorSet BLUE_RED = new ColorSet("Blue-Red", new double[]{0.0, 1.0}, new double[]{0.0, 0.0}, new double[]{1.0, 0.0});
        public static final ColorSet BLUE_WHITE_RED = new ColorSet("Blue-White-Red", new double[]{0.0, 1.0, 1.0}, new double[]{0.0, 1.0, 0.0}, new double[]{1.0, 1.0, 0.0});
        public static ColorSet[] VALUES = new ColorSet[]{RAINBOW, GRAYSCALE, BLUE_RED, BLUE_WHITE_RED};

        private ColorSet(String string, double[] dArray, double[] dArray2, double[] dArray3) {
            this.name = string;
            this.colorsR = dArray;
            this.colorsG = dArray2;
            this.colorsB = dArray3;
        }

        public String toString() {
            return this.name;
        }
    }
}

