/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.util.Arrays;

public class Spline {
    private double[] xx;
    private double[] yy;
    private double[] a;
    private double[] b;
    private double[] c;
    private double[] d;

    public Spline(double[] dArray, double[] dArray2) {
        this.setValues(dArray, dArray2);
    }

    public void setValues(double[] dArray, double[] dArray2) {
        this.xx = dArray;
        this.yy = dArray2;
        if (dArray.length > 1) {
            this.calculateCoefficients();
        }
    }

    public double getValue(double d) {
        if (this.xx.length == 0) {
            return Double.NaN;
        }
        if (this.xx.length == 1) {
            if (this.xx[0] == d) {
                return this.yy[0];
            }
            return Double.NaN;
        }
        int n = Arrays.binarySearch(this.xx, d);
        if (n > 0) {
            return this.yy[n];
        }
        if ((n = -(n + 1) - 1) < 0) {
            return this.yy[0];
        }
        return this.a[n] + this.b[n] * (d - this.xx[n]) + this.c[n] * Math.pow(d - this.xx[n], 2.0) + this.d[n] * Math.pow(d - this.xx[n], 3.0);
    }

    public double getDx(double d) {
        if (this.xx.length == 0 || this.xx.length == 1) {
            return 0.0;
        }
        int n = Arrays.binarySearch(this.xx, d);
        if (n < 0) {
            n = -(n + 1) - 1;
        }
        return this.b[n] + 2.0 * this.c[n] * (d - this.xx[n]) + 3.0 * this.d[n] * Math.pow(d - this.xx[n], 2.0);
    }

    private void calculateCoefficients() {
        int n = this.yy.length;
        this.a = new double[n];
        this.b = new double[n];
        this.c = new double[n];
        this.d = new double[n];
        if (n == 2) {
            this.a[0] = this.yy[0];
            this.b[0] = this.yy[1] - this.yy[0];
            return;
        }
        double[] dArray = new double[n - 1];
        int n2 = 0;
        while (n2 < n - 1) {
            this.a[n2] = this.yy[n2];
            dArray[n2] = this.xx[n2 + 1] - this.xx[n2];
            ++n2;
        }
        this.a[n - 1] = this.yy[n - 1];
        double[][] dArray2 = new double[n - 2][n - 2];
        double[] dArray3 = new double[n - 2];
        int n3 = 0;
        while (n3 < n - 2) {
            dArray3[n3] = 3.0 * ((this.yy[n3 + 2] - this.yy[n3 + 1]) / dArray[n3 + 1] - (this.yy[n3 + 1] - this.yy[n3]) / dArray[n3]);
            dArray2[n3][n3] = 2.0 * (dArray[n3] + dArray[n3 + 1]);
            if (n3 > 0) {
                dArray2[n3][n3 - 1] = dArray[n3];
            }
            if (n3 < n - 3) {
                dArray2[n3][n3 + 1] = dArray[n3 + 1];
            }
            ++n3;
        }
        this.solve(dArray2, dArray3);
        int n4 = 0;
        while (n4 < n - 2) {
            this.c[n4 + 1] = dArray3[n4];
            this.b[n4] = (this.a[n4 + 1] - this.a[n4]) / dArray[n4] - (2.0 * this.c[n4] + this.c[n4 + 1]) / 3.0 * dArray[n4];
            this.d[n4] = (this.c[n4 + 1] - this.c[n4]) / (3.0 * dArray[n4]);
            ++n4;
        }
        this.b[n - 2] = (this.a[n - 1] - this.a[n - 2]) / dArray[n - 2] - (2.0 * this.c[n - 2] + this.c[n - 1]) / 3.0 * dArray[n - 2];
        this.d[n - 2] = (this.c[n - 1] - this.c[n - 2]) / (3.0 * dArray[n - 2]);
    }

    public void solve(double[][] dArray, double[] dArray2) {
        int n = dArray2.length;
        int n2 = 1;
        while (n2 < n) {
            dArray[n2][n2 - 1] = dArray[n2][n2 - 1] / dArray[n2 - 1][n2 - 1];
            dArray[n2][n2] = dArray[n2][n2] - dArray[n2 - 1][n2] * dArray[n2][n2 - 1];
            dArray2[n2] = dArray2[n2] - dArray[n2][n2 - 1] * dArray2[n2 - 1];
            ++n2;
        }
        dArray2[n - 1] = dArray2[n - 1] / dArray[n - 1][n - 1];
        int n3 = dArray2.length - 2;
        while (n3 >= 0) {
            dArray2[n3] = (dArray2[n3] - dArray[n3][n3 + 1] * dArray2[n3 + 1]) / dArray[n3][n3];
            --n3;
        }
    }
}

