/*
 * Decompiled with CFR 0.152.
 */
package TauIL.absyn;

import TauIL.absyn.AbstractSyntax;
import TauIL.absyn.SyntaxList;

public class ListManager {
    public static final int LIST = 0;
    public static final int STACK = 1;
    public static final int QUEUE = 2;
    private SyntaxList head;
    private SyntaxList tail;
    private SyntaxList cursor;
    private SyntaxList temp;
    private int list_type = 0;
    private boolean empty = true;

    public ListManager(SyntaxList syntaxList) {
        this.tail = this.cursor = syntaxList;
        this.head = this.cursor;
        if (syntaxList != null) {
            this.empty = false;
        }
        if (!this.empty) {
            while (this.tail.tail != null) {
                this.tail = this.tail.tail;
            }
        }
    }

    public ListManager(SyntaxList syntaxList, int n) {
        this(syntaxList);
        this.list_type = n;
        if (this.list_type < 0 || this.list_type > 2) {
            throw new IllegalArgumentException(this.list_type + " : is not a legal ListManager type argument.");
        }
    }

    public boolean hasNext() {
        return this.cursor != null;
    }

    public AbstractSyntax next() {
        if (this.cursor == null) {
            return null;
        }
        this.temp = this.cursor;
        this.cursor = this.cursor.tail;
        return this.temp.head;
    }

    public void reset() {
        this.cursor = this.head;
    }

    public void insert(SyntaxList syntaxList) {
        this.temp = syntaxList;
        if (syntaxList != null) {
            while (this.temp.tail != null) {
                this.temp = this.temp.tail;
            }
            switch (this.list_type) {
                case 1: {
                    this.temp.tail = this.head;
                    this.head = syntaxList;
                    break;
                }
                case 0: 
                case 2: {
                    this.tail.tail = syntaxList;
                    this.tail = this.temp;
                }
            }
        }
    }

    public SyntaxList remove() {
        if (this.empty || this.cursor == null) {
            return null;
        }
        SyntaxList syntaxList = this.temp = this.head;
        switch (this.list_type) {
            case 0: {
                if (this.cursor != this.head) {
                    while (this.temp.tail != this.cursor) {
                        this.temp = this.temp.tail;
                    }
                    this.temp.tail = this.cursor.tail;
                    syntaxList = this.cursor;
                    this.cursor = this.temp.tail;
                    if (this.cursor != null) break;
                    this.tail = this.temp;
                    break;
                }
            }
            case 1: 
            case 2: {
                this.cursor = this.head = this.head.tail;
                if (this.head != null) break;
                this.tail = null;
                this.empty = true;
            }
        }
        this.temp = null;
        return syntaxList;
    }

    public SyntaxList retrieve() {
        SyntaxList syntaxList = this.head;
        this.temp = null;
        this.cursor = null;
        this.tail = null;
        this.head = null;
        this.empty = true;
        return syntaxList;
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

