/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.util;

import java.util.HashMap;
import java.util.Iterator;
import org.jatha.Jatha;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;

public class SymbolTable
extends HashMap {
    public static final int HASH_TABLE_DEFAULT_SIZE = 4096;
    public static final float HASH_TABLE_DEFAULT_LOAD_FACTOR = 0.8f;
    private Jatha f_lisp = null;

    public SymbolTable(Jatha lisp) {
        super(4096, 0.8f);
        this.f_lisp = lisp;
    }

    public SymbolTable(Jatha lisp, int defaultSize) {
        super(defaultSize, 0.8f);
        this.f_lisp = lisp;
    }

    public SymbolTable(Jatha lisp, int initialSize, float loadFactor) {
        super(initialSize, loadFactor);
        this.f_lisp = lisp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LispValue put(LispString key, LispValue value) {
        try {
            super.put(key.getValue(), value);
        }
        catch (NullPointerException e) {
            System.err.println("NullPointerException for " + key + "/" + value + " in SymbolTable.put.");
            Object var4_4 = null;
            return var4_4;
        }
        finally {
            return value;
        }
    }

    public synchronized LispValue get(LispString key) {
        Object val = super.get(key.getValue());
        if (val == null) {
            return this.f_lisp.NIL;
        }
        return (LispValue)val;
    }

    public synchronized LispValue replace(LispString key, LispValue value) {
        super.remove(key.getValue());
        this.put(key, value);
        return value;
    }

    public Iterator keys() {
        return this.keySet().iterator();
    }
}

