/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.test.junit;

import java.io.EOFException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jatha.Jatha;
import org.jatha.dynatype.LispCons;
import org.jatha.dynatype.LispConsOrNil;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispReal;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.LispValueNotAListException;
import org.jatha.dynatype.LispValueNotAStringException;
import org.jatha.dynatype.LispValueNotConvertableToAStringException;
import org.jatha.dynatype.StandardLispBignum;
import org.jatha.dynatype.StandardLispCons;
import org.jatha.dynatype.StandardLispConstant;
import org.jatha.dynatype.StandardLispHashTable;
import org.jatha.dynatype.StandardLispInteger;
import org.jatha.dynatype.StandardLispPackage;
import org.jatha.dynatype.StandardLispReal;
import org.jatha.dynatype.StandardLispString;
import org.jatha.dynatype.StandardLispSymbol;

public class CoreTest
extends TestCase {
    protected static Jatha f_lisp;
    protected LispValue f_NIL;
    protected LispValue f_T;
    protected LispValue f_Bignum;
    protected LispValue f_Cons;
    protected LispValue f_Constant;
    protected LispValue f_Function;
    protected LispValue f_HashTable;
    protected LispValue f_Integer;
    protected LispValue f_Keyword;
    protected LispValue f_List;
    protected LispValue f_Number;
    protected LispValue f_QuotedList;
    protected LispValue f_Package;
    protected LispValue f_Real;
    protected LispValue f_String;
    protected LispValue f_Symbol;
    protected LispValue A;
    protected LispValue B;
    protected LispValue C;
    protected LispValue D;
    protected LispValue E;
    protected LispValue F;
    protected LispValue G;
    protected LispValue ONE;
    protected LispValue TWO;
    protected LispValue THREE;
    protected LispValue FOUR;
    protected LispValue FIVE;
    static /* synthetic */ Class class$org$jatha$test$junit$CoreTest;

    public static void main(String[] args) {
        boolean useGui = false;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equalsIgnoreCase("-gui")) continue;
                useGui = true;
            }
        }
        if (useGui) {
            junit.swingui.TestRunner.run((Class)(class$org$jatha$test$junit$CoreTest == null ? (class$org$jatha$test$junit$CoreTest = CoreTest.class$("org.jatha.test.junit.CoreTest")) : class$org$jatha$test$junit$CoreTest));
        } else {
            TestRunner.run((Test)CoreTest.suite());
        }
    }

    protected void setUp() throws Exception {
        f_lisp = new Jatha(false, false);
        f_lisp.init();
        f_lisp.start();
        try {
            this.A = f_lisp.parse("A");
            this.B = f_lisp.parse("B");
            this.C = f_lisp.parse("C");
            this.D = f_lisp.parse("D");
            this.E = f_lisp.parse("E");
        }
        catch (EOFException eof) {
            throw new Exception("Can't parse symbols.");
        }
        this.ONE = new StandardLispInteger(f_lisp, 1L);
        this.TWO = new StandardLispInteger(f_lisp, 2L);
        this.THREE = new StandardLispInteger(f_lisp, 3L);
        this.FOUR = new StandardLispInteger(f_lisp, 4L);
        this.FIVE = new StandardLispInteger(f_lisp, 5L);
        this.f_NIL = CoreTest.f_lisp.NIL;
        this.f_T = CoreTest.f_lisp.T;
        this.f_Bignum = new StandardLispBignum(f_lisp, -2L);
        this.f_Cons = new StandardLispCons(f_lisp, this.A, this.B);
        this.f_Constant = new StandardLispConstant(f_lisp, "CONSTANT");
        this.f_Function = f_lisp.parse("CAR").symbol_function();
        this.f_HashTable = new StandardLispHashTable(f_lisp);
        this.f_Integer = new StandardLispInteger(f_lisp, 614L);
        this.f_Keyword = f_lisp.parse(":HELLO");
        this.f_List = f_lisp.makeList(this.A, this.B, this.C);
        this.f_Package = new StandardLispPackage(f_lisp, "TEST-PACKAGE");
        this.f_QuotedList = f_lisp.makeList(CoreTest.f_lisp.QUOTE, f_lisp.makeList(this.A, this.B, this.C));
        this.f_Real = new StandardLispReal(f_lisp, 6.14);
        this.f_String = new StandardLispString(f_lisp, "a test string");
        this.f_Symbol = new StandardLispSymbol(f_lisp, "TEST-SYMBOL");
    }

    public static Test suite() {
        return new TestSuite(class$org$jatha$test$junit$CoreTest == null ? (class$org$jatha$test$junit$CoreTest = CoreTest.class$("org.jatha.test.junit.CoreTest")) : class$org$jatha$test$junit$CoreTest);
    }

    public void testBasicAtom() {
        CoreTest.assertTrue((boolean)this.A.basic_atom());
        CoreTest.assertTrue((boolean)this.ONE.basic_atom());
        CoreTest.assertTrue((boolean)this.f_NIL.basic_atom());
        CoreTest.assertTrue((boolean)this.f_T.basic_atom());
        CoreTest.assertTrue((boolean)this.f_Bignum.basic_atom());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_atom());
        CoreTest.assertTrue((boolean)this.f_Constant.basic_atom());
        CoreTest.assertFalse((boolean)this.f_Function.basic_atom());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_atom());
        CoreTest.assertTrue((boolean)this.f_Integer.basic_atom());
        CoreTest.assertTrue((boolean)this.f_Keyword.basic_atom());
        CoreTest.assertFalse((boolean)this.f_List.basic_atom());
        CoreTest.assertFalse((boolean)this.f_Package.basic_atom());
        CoreTest.assertTrue((boolean)this.f_Real.basic_atom());
        CoreTest.assertTrue((boolean)this.f_String.basic_atom());
        CoreTest.assertTrue((boolean)this.f_Symbol.basic_atom());
    }

    public void testBasicBignump() {
        CoreTest.assertFalse((boolean)this.A.basic_bignump());
        CoreTest.assertFalse((boolean)this.ONE.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_NIL.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_T.basic_bignump());
        CoreTest.assertTrue((boolean)this.f_Bignum.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_Function.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_List.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_Package.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_Real.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_String.basic_bignump());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_bignump());
    }

    public void testBasicConsp() {
        CoreTest.assertFalse((boolean)this.A.basic_consp());
        CoreTest.assertFalse((boolean)this.ONE.basic_consp());
        CoreTest.assertFalse((boolean)this.f_NIL.basic_consp());
        CoreTest.assertFalse((boolean)this.f_T.basic_consp());
        CoreTest.assertFalse((boolean)this.f_Bignum.basic_consp());
        CoreTest.assertTrue((boolean)this.f_Cons.basic_consp());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_consp());
        CoreTest.assertTrue((boolean)this.f_Function.basic_consp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_consp());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_consp());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_consp());
        CoreTest.assertTrue((boolean)this.f_List.basic_consp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_consp());
        CoreTest.assertTrue((boolean)this.f_QuotedList.basic_consp());
        CoreTest.assertFalse((boolean)this.f_Real.basic_consp());
        CoreTest.assertFalse((boolean)this.f_String.basic_consp());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_consp());
    }

    public void testBasicConstantp() {
        CoreTest.assertFalse((boolean)this.A.basic_constantp());
        CoreTest.assertTrue((boolean)this.ONE.basic_constantp());
        CoreTest.assertTrue((boolean)this.f_NIL.basic_constantp());
        CoreTest.assertTrue((boolean)this.f_T.basic_constantp());
        CoreTest.assertTrue((boolean)this.f_Bignum.basic_constantp());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_constantp());
        CoreTest.assertTrue((boolean)this.f_Constant.basic_constantp());
        CoreTest.assertFalse((boolean)this.f_Function.basic_constantp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_constantp());
        CoreTest.assertTrue((boolean)this.f_Integer.basic_constantp());
        CoreTest.assertTrue((boolean)this.f_Keyword.basic_constantp());
        CoreTest.assertFalse((boolean)this.f_List.basic_constantp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_constantp());
        CoreTest.assertTrue((boolean)this.f_QuotedList.basic_constantp());
        CoreTest.assertTrue((boolean)this.f_Real.basic_constantp());
        CoreTest.assertTrue((boolean)this.f_String.basic_constantp());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_constantp());
    }

    public void testBasicForeignp() {
        CoreTest.assertFalse((boolean)this.A.basic_foreignp());
        CoreTest.assertFalse((boolean)this.ONE.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_NIL.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_T.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_Bignum.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_Function.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_List.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_Real.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_String.basic_foreignp());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_foreignp());
    }

    public void testBasicIntegerp() {
        CoreTest.assertFalse((boolean)this.A.basic_integerp());
        CoreTest.assertTrue((boolean)this.ONE.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_NIL.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_T.basic_integerp());
        CoreTest.assertTrue((boolean)this.f_Bignum.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_Function.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_integerp());
        CoreTest.assertTrue((boolean)this.f_Integer.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_List.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_Real.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_String.basic_integerp());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_integerp());
    }

    public void testBasicFunctionp() {
        CoreTest.assertFalse((boolean)this.A.basic_functionp());
        CoreTest.assertFalse((boolean)this.ONE.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_NIL.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_T.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_Bignum.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_Function.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_List.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_Real.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_String.basic_functionp());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_functionp());
    }

    public void testBasicKeywordp() {
        CoreTest.assertFalse((boolean)this.A.basic_keywordp());
        CoreTest.assertFalse((boolean)this.ONE.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_NIL.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_T.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_Bignum.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_Function.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_keywordp());
        CoreTest.assertTrue((boolean)this.f_Keyword.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_List.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_Real.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_String.basic_keywordp());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_keywordp());
    }

    public void testBasicLength() {
        int l = 0;
        try {
            l = this.A.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.ONE.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        CoreTest.assertTrue((0 == this.f_NIL.basic_length() ? 1 : 0) != 0);
        try {
            l = this.f_T.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Bignum.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Cons.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Constant.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        CoreTest.assertTrue((1 < this.f_Function.basic_length() ? 1 : 0) != 0);
        try {
            l = this.f_HashTable.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Integer.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Keyword.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        CoreTest.assertTrue((3 == this.f_List.basic_length() ? 1 : 0) != 0);
        try {
            l = this.f_Package.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        CoreTest.assertTrue((2 == this.f_QuotedList.basic_length() ? 1 : 0) != 0);
        try {
            l = this.f_Real.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        CoreTest.assertTrue((13 == this.f_String.basic_length() ? 1 : 0) != 0);
        try {
            l = this.f_Symbol.basic_length();
            CoreTest.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException lispValueNotAListException) {
            // empty catch block
        }
    }

    public void testBasicListp() {
        CoreTest.assertFalse((boolean)this.A.basic_listp());
        CoreTest.assertFalse((boolean)this.ONE.basic_listp());
        CoreTest.assertTrue((boolean)this.f_NIL.basic_listp());
        CoreTest.assertFalse((boolean)this.f_T.basic_listp());
        CoreTest.assertFalse((boolean)this.f_Bignum.basic_listp());
        CoreTest.assertTrue((boolean)this.f_Cons.basic_listp());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_listp());
        CoreTest.assertTrue((boolean)this.f_Function.basic_listp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_listp());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_listp());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_listp());
        CoreTest.assertTrue((boolean)this.f_List.basic_listp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_listp());
        CoreTest.assertFalse((boolean)this.f_Real.basic_listp());
        CoreTest.assertFalse((boolean)this.f_String.basic_listp());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_listp());
    }

    public void testBasicMacrop() {
        CoreTest.assertFalse((boolean)this.A.basic_macrop());
        CoreTest.assertFalse((boolean)this.ONE.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_NIL.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_T.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_Bignum.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_Function.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_List.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_Package.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_Real.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_String.basic_macrop());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_macrop());
    }

    public void testBasicNull() {
        CoreTest.assertFalse((boolean)this.A.basic_null());
        CoreTest.assertFalse((boolean)this.ONE.basic_null());
        CoreTest.assertTrue((boolean)this.f_NIL.basic_null());
        CoreTest.assertFalse((boolean)this.f_T.basic_null());
        CoreTest.assertFalse((boolean)this.f_Bignum.basic_null());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_null());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_null());
        CoreTest.assertFalse((boolean)this.f_Function.basic_null());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_null());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_null());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_null());
        CoreTest.assertFalse((boolean)this.f_List.basic_null());
        CoreTest.assertFalse((boolean)this.f_Package.basic_null());
        CoreTest.assertFalse((boolean)this.f_Real.basic_null());
        CoreTest.assertFalse((boolean)this.f_String.basic_null());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_null());
    }

    public void testBasicNumberp() {
        CoreTest.assertFalse((boolean)this.A.basic_numberp());
        CoreTest.assertTrue((boolean)this.ONE.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_NIL.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_T.basic_numberp());
        CoreTest.assertTrue((boolean)this.f_Bignum.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_Function.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_numberp());
        CoreTest.assertTrue((boolean)this.f_Integer.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_List.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_numberp());
        CoreTest.assertTrue((boolean)this.f_Real.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_String.basic_numberp());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_numberp());
    }

    public void testBasicStringp() {
        CoreTest.assertFalse((boolean)this.A.basic_stringp());
        CoreTest.assertFalse((boolean)this.ONE.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_NIL.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_T.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_Bignum.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_Constant.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_Function.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_Keyword.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_List.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_Real.basic_stringp());
        CoreTest.assertTrue((boolean)this.f_String.basic_stringp());
        CoreTest.assertFalse((boolean)this.f_Symbol.basic_stringp());
    }

    public void testBasicSymbolp() {
        CoreTest.assertTrue((boolean)this.A.basic_symbolp());
        CoreTest.assertFalse((boolean)this.ONE.basic_symbolp());
        CoreTest.assertTrue((boolean)this.f_NIL.basic_symbolp());
        CoreTest.assertTrue((boolean)this.f_T.basic_symbolp());
        CoreTest.assertFalse((boolean)this.f_Bignum.basic_symbolp());
        CoreTest.assertFalse((boolean)this.f_Cons.basic_symbolp());
        CoreTest.assertTrue((boolean)this.f_Constant.basic_symbolp());
        CoreTest.assertFalse((boolean)this.f_Function.basic_symbolp());
        CoreTest.assertFalse((boolean)this.f_HashTable.basic_symbolp());
        CoreTest.assertFalse((boolean)this.f_Integer.basic_symbolp());
        CoreTest.assertTrue((boolean)this.f_Keyword.basic_symbolp());
        CoreTest.assertFalse((boolean)this.f_List.basic_symbolp());
        CoreTest.assertFalse((boolean)this.f_Package.basic_symbolp());
        CoreTest.assertFalse((boolean)this.f_Real.basic_symbolp());
        CoreTest.assertFalse((boolean)this.f_String.basic_symbolp());
        CoreTest.assertTrue((boolean)this.f_Symbol.basic_symbolp());
    }

    public void testAppend() {
        LispCons l2;
        LispCons l1 = f_lisp.makeList(this.A, this.B, this.C, this.D);
        LispValue l3 = l1.append(l2 = f_lisp.makeList(this.D, this.C, this.B, this.A));
        CoreTest.assertTrue((8 == l3.basic_length() ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.equal(l3.sixth()) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((l3.first().equal(l3.last().car()) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((boolean)l3.eq(l1).basic_null());
        CoreTest.assertTrue((l2.eq(l3.cdr().cdr().cdr().cdr()) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((l3.reverse().equal(l3) != CoreTest.f_lisp.NIL ? 1 : 0) != 0);
    }

    public void testapply() {
    }

    public void testassoc() {
    }

    public void testatom() {
    }

    public void testbignump() {
    }

    public void testboundp() {
    }

    public void testbutlast() {
    }

    public void testcar() {
    }

    public void testcdr() {
    }

    public void testcharacterp() {
    }

    public void testclrhash() {
    }

    public void testconsp() {
    }

    public void testcopy_list() {
    }

    public void testeighth() {
    }

    public void testelt() {
    }

    public void testeq() {
    }

    public void testeql() {
    }

    public void testequal() {
    }

    public void testfboundp() {
    }

    public void testfloatp() {
    }

    public void testfifth() {
    }

    public void testfirst() {
    }

    public void testfourth() {
    }

    public void testfuncall() {
    }

    public void testgethash() {
    }

    public void testsetf_gethash() {
    }

    public void testhashtablep() {
    }

    public void testhash_table_count() {
    }

    public void testhash_table_size() {
    }

    public void testhash_table_rehash_size() {
    }

    public void testhash_table_rehash_threshold() {
    }

    public void testhash_table_test() {
    }

    public void testintegerp() {
    }

    public void testkeywordp() {
    }

    public void testlast() {
    }

    public void testlength() {
    }

    public void testlisp_null() {
    }

    public void testlist() {
    }

    public void testlistp() {
    }

    public void testmax1() {
        CoreTest.assertTrue((this.ONE.max(f_lisp.makeList(this.ONE, this.TWO, this.THREE, this.FOUR)).eql(this.FOUR) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmax2() {
        CoreTest.assertFalse((this.ONE.max(this.TWO).eql(this.ONE) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmax3() {
        CoreTest.assertTrue((this.ONE.max(this.TWO).eql(this.TWO) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmax4() {
        CoreTest.assertTrue((this.TWO.max(this.ONE).eql(this.TWO) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmax5() {
        CoreTest.assertFalse((this.TWO.max(this.ONE).eql(this.ONE) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmax6() {
        LispReal C;
        LispReal A = f_lisp.makeReal(1.4);
        LispReal B = f_lisp.makeReal(14.6);
        CoreTest.assertTrue((B.max(f_lisp.makeList(A, this.ONE, C = f_lisp.makeReal(17.7))).eql(C) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmin1() {
        CoreTest.assertTrue((this.ONE.min(f_lisp.makeList(this.ONE, this.TWO, this.THREE, this.FOUR)).eql(this.ONE) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmin2() {
        CoreTest.assertFalse((this.ONE.min(this.TWO).eql(this.TWO) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmin3() {
        CoreTest.assertTrue((this.ONE.min(this.TWO).eql(this.ONE) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmin4() {
        CoreTest.assertTrue((this.TWO.min(this.ONE).eql(this.ONE) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmin5() {
        CoreTest.assertFalse((this.TWO.min(this.ONE).eql(this.TWO) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmin6() {
        LispReal C;
        LispReal A = f_lisp.makeReal(1.4);
        LispReal B = f_lisp.makeReal(14.6);
        CoreTest.assertTrue((B.min(f_lisp.makeList(A, this.TWO, C = f_lisp.makeReal(17.7))).eql(A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testmember() {
    }

    public void testnconc() {
    }

    public void testninth() {
    }

    public void testnreverse() {
    }

    public void testnumberp() {
    }

    public void testpop() {
        LispValue l1 = f_lisp.makeList(this.A, this.B, this.C);
        LispCons l2 = f_lisp.makeList(this.A, this.B, this.C);
        CoreTest.assertTrue((CoreTest.f_lisp.T == this.A.eq(l1.pop()) ? 1 : 0) != 0);
        CoreTest.assertTrue((2 == l1.basic_length() ? 1 : 0) != 0);
        CoreTest.assertTrue((3 == l1.push(this.D).basic_length() ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D == l1.pop() ? 1 : 0) != 0);
        CoreTest.assertTrue((2 == l1.basic_length() ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B == l1.pop() ? 1 : 0) != 0);
        CoreTest.assertTrue((1 == l1.basic_length() ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C == l1.pop() ? 1 : 0) != 0);
        CoreTest.assertTrue((CoreTest.f_lisp.T == l1.equal(new StandardLispCons(f_lisp, CoreTest.f_lisp.NIL, CoreTest.f_lisp.NIL)) ? 1 : 0) != 0);
        l1 = new StandardLispSymbol(f_lisp, "L1");
        l1.setq(f_lisp.makeList(this.A, this.B, this.C));
        CoreTest.assertTrue((CoreTest.f_lisp.T == this.A.eq(l1.pop()) ? 1 : 0) != 0);
        CoreTest.assertTrue((2 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        CoreTest.assertTrue((CoreTest.f_lisp.T == this.B.eq(l1.pop()) ? 1 : 0) != 0);
        CoreTest.assertTrue((1 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        CoreTest.assertTrue((CoreTest.f_lisp.T == this.C.eq(l1.pop()) ? 1 : 0) != 0);
        CoreTest.assertTrue((0 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        CoreTest.assertTrue((boolean)l1.symbol_value().basic_null());
        l1.push(this.C);
        CoreTest.assertTrue((1 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        l1.push(this.B);
        CoreTest.assertTrue((2 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        l1.push(this.A);
        CoreTest.assertTrue((3 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        CoreTest.assertTrue((CoreTest.f_lisp.T == l1.symbol_value().equal(f_lisp.makeList(this.A, this.B, this.C)) ? 1 : 0) != 0);
        CoreTest.assertTrue((CoreTest.f_lisp.T == l1.symbol_value().equal(l2) ? 1 : 0) != 0);
    }

    public void testprin1() {
    }

    public void testprinc() {
    }

    public void testprint() {
    }

    public void testpush() {
        StandardLispSymbol l1 = new StandardLispSymbol(f_lisp, "L1");
        LispCons l2 = f_lisp.makeList(this.A, this.B);
        l1.setq(CoreTest.f_lisp.NIL);
        l1.push(this.B);
        l1.push(this.A);
        CoreTest.assertTrue((l1.symbol_value().equal(l2) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testrassoc() {
    }

    public void testremhash() {
    }

    public void testremove() {
    }

    public void testreverse() {
    }

    public void testrplaca() {
    }

    public void testrplacd() {
    }

    public void testsecond() {
    }

    public void testsetf_symbol_function() {
    }

    public void testsetf_symbol_plist() {
    }

    public void testsetf_symbol_value() {
    }

    public void testseventh() {
    }

    public void teststringp() {
        this.A = f_lisp.makeString("test");
        this.B = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringp() == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringp() == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
    }

    public void teststring() {
        this.A = f_lisp.makeString("test");
        this.B = f_lisp.makeInteger(5);
        this.C = f_lisp.makeList(this.A, this.B);
        CoreTest.assertTrue((this.A.string().stringp() == CoreTest.f_lisp.T ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.B.string().stringp() == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotConvertableToAStringException.");
        }
        catch (LispValueNotConvertableToAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.C.string().stringp() == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotConvertableToAStringException.");
        }
        catch (LispValueNotConvertableToAStringException lispValueNotConvertableToAStringException) {
            // empty catch block
        }
    }

    public void teststringUpcase() {
        this.A = f_lisp.makeString("test");
        this.B = f_lisp.makeString("Test");
        this.C = f_lisp.makeString("");
        this.D = f_lisp.makeString("x");
        this.E = f_lisp.makeInteger(5);
        CoreTest.assertTrue((boolean)((LispString)this.A.stringUpcase()).getValue().equals("TEST"));
        CoreTest.assertTrue((boolean)((LispString)this.B.stringUpcase()).getValue().equals("TEST"));
        CoreTest.assertTrue((boolean)((LispString)this.C.stringUpcase()).getValue().equals(""));
        CoreTest.assertTrue((boolean)((LispString)this.D.stringUpcase()).getValue().equals("X"));
        try {
            CoreTest.assertTrue((boolean)((LispString)this.E.stringUpcase()).getValue().equals("5"));
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringDowncase() {
        this.A = f_lisp.makeString("test");
        this.B = f_lisp.makeString("Test");
        this.C = f_lisp.makeString("");
        this.D = f_lisp.makeString("X");
        this.E = f_lisp.makeInteger(5);
        CoreTest.assertTrue((boolean)((LispString)this.A.stringDowncase()).getValue().equals("test"));
        CoreTest.assertTrue((boolean)((LispString)this.B.stringDowncase()).getValue().equals("test"));
        CoreTest.assertTrue((boolean)((LispString)this.C.stringDowncase()).getValue().equals(""));
        CoreTest.assertTrue((boolean)((LispString)this.D.stringDowncase()).getValue().equals("x"));
        try {
            CoreTest.assertTrue((boolean)((LispString)this.E.stringDowncase()).getValue().equals("5"));
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringCapitalize() {
        this.A = f_lisp.makeString("test");
        this.B = f_lisp.makeString("eTest");
        this.C = f_lisp.makeString("");
        this.D = f_lisp.makeString("x");
        this.E = f_lisp.makeInteger(5);
        CoreTest.assertTrue((boolean)((LispString)this.A.stringCapitalize()).getValue().equals("Test"));
        CoreTest.assertTrue((boolean)((LispString)this.B.stringCapitalize()).getValue().equals("Etest"));
        CoreTest.assertTrue((boolean)((LispString)this.C.stringCapitalize()).getValue().equals(""));
        CoreTest.assertTrue((boolean)((LispString)this.D.stringCapitalize()).getValue().equals("X"));
        try {
            CoreTest.assertTrue((boolean)((LispString)this.E.stringCapitalize()).getValue().equals("5"));
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringEqual() {
        this.A = f_lisp.makeString("MiKeY");
        this.B = f_lisp.makeString("MiKeY");
        this.C = f_lisp.makeString("mikey");
        this.D = f_lisp.makeString("5");
        this.E = f_lisp.makeInteger(5);
        this.F = f_lisp.makeString("");
        this.G = f_lisp.makeString("");
        CoreTest.assertTrue((this.A.stringEqual(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringEqual(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.A.stringEqual(this.C) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringEqual(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringEqual(this.C) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringEqual(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringEqual(this.D) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringEqual(this.F) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.E.stringEqual(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringEqual(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringEq() {
        this.A = f_lisp.makeString("MiKeY");
        this.B = f_lisp.makeString("MiKeY");
        this.C = f_lisp.makeString("mikey");
        this.D = f_lisp.makeString("5");
        this.E = f_lisp.makeInteger(5);
        this.F = f_lisp.makeString("");
        this.G = f_lisp.makeString("");
        CoreTest.assertTrue((this.A.stringEq(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringEq(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.A.stringEq(this.C) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringEq(this.A) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringEq(this.C) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringEq(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringEq(this.D) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringEq(this.F) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.E.stringEq(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringEq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringNeq() {
        this.A = f_lisp.makeString("MiKeY");
        this.B = f_lisp.makeString("MiKeY");
        this.C = f_lisp.makeString("mikey");
        this.D = f_lisp.makeString("5");
        this.E = f_lisp.makeInteger(5);
        this.F = f_lisp.makeString("");
        this.G = f_lisp.makeString("");
        CoreTest.assertTrue((this.A.stringNeq(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringNeq(this.A) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.A.stringNeq(this.C) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringNeq(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringNeq(this.C) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringNeq(this.G) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringNeq(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringNeq(this.F) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.E.stringNeq(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringNeq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringLessThan() {
        this.A = f_lisp.makeString("");
        this.B = f_lisp.makeString("a");
        this.C = f_lisp.makeString("ab");
        this.D = f_lisp.makeString("ba");
        this.E = f_lisp.makeString("bb");
        this.F = f_lisp.makeString("bbbbbbbz");
        this.G = f_lisp.makeInteger(5);
        LispString B1 = f_lisp.makeString("A");
        LispString C1 = f_lisp.makeString("AB");
        LispString D1 = f_lisp.makeString("BA");
        LispString E1 = f_lisp.makeString("BB");
        LispString F1 = f_lisp.makeString("BBBBBBBZ");
        LispInteger G1 = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringLessThan(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringLessThan(this.A) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringLessThan(this.C) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringLessThan(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringLessThan(this.F) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringLessThan(B1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((B1.stringLessThan(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((E1.stringLessThan(F1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringLessThan(F1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringLessThan(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringLessThan(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
    }

    public void teststringLessP() {
        this.A = f_lisp.makeString("");
        this.B = f_lisp.makeString("a");
        this.C = f_lisp.makeString("ab");
        this.D = f_lisp.makeString("ba");
        this.E = f_lisp.makeString("bb");
        this.F = f_lisp.makeString("bbbbbbbz");
        this.G = f_lisp.makeInteger(5);
        LispString B1 = f_lisp.makeString("A");
        LispString C1 = f_lisp.makeString("AB");
        LispString D1 = f_lisp.makeString("BA");
        LispString E1 = f_lisp.makeString("BB");
        LispString F1 = f_lisp.makeString("BBBBBBBZ");
        LispInteger G1 = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringLessP(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringLessP(this.A) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringLessP(this.C) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringLessP(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringLessP(this.F) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringLessP(C1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((C1.stringLessP(this.C) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((E1.stringLessP(F1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringLessP(F1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringLessP(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringLessP(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
    }

    public void teststringGreaterThan() {
        this.A = f_lisp.makeString("");
        this.B = f_lisp.makeString("a");
        this.C = f_lisp.makeString("ab");
        this.D = f_lisp.makeString("ba");
        this.E = f_lisp.makeString("bb");
        this.F = f_lisp.makeString("bbbbbbbz");
        this.G = f_lisp.makeInteger(5);
        LispString B1 = f_lisp.makeString("A");
        LispString C1 = f_lisp.makeString("AB");
        LispString D1 = f_lisp.makeString("BA");
        LispString E1 = f_lisp.makeString("BB");
        LispString F1 = f_lisp.makeString("BBBBBBBZ");
        LispInteger G1 = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringGreaterThan(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringGreaterThan(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringGreaterThan(this.C) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringGreaterThan(this.D) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringGreaterThan(this.F) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringGreaterThan(B1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((B1.stringGreaterThan(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((E1.stringGreaterThan(F1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringGreaterThan(F1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringGreaterThan(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringGreaterThan(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
    }

    public void teststringGreaterP() {
        this.A = f_lisp.makeString("");
        this.B = f_lisp.makeString("a");
        this.C = f_lisp.makeString("ab");
        this.D = f_lisp.makeString("ba");
        this.E = f_lisp.makeString("bb");
        this.F = f_lisp.makeString("bbbbbbbz");
        this.G = f_lisp.makeInteger(5);
        LispString B1 = f_lisp.makeString("A");
        LispString C1 = f_lisp.makeString("AB");
        LispString D1 = f_lisp.makeString("BA");
        LispString E1 = f_lisp.makeString("BB");
        LispString F1 = f_lisp.makeString("BBBBBBBZ");
        LispInteger G1 = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringGreaterP(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringGreaterP(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringGreaterP(this.C) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringGreaterP(this.D) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringGreaterP(this.F) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringGreaterP(C1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((C1.stringGreaterP(this.C) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((E1.stringGreaterP(F1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringGreaterP(F1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringGreaterP(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringGreaterP(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
    }

    public void teststringLessThanOrEqual() {
        this.A = f_lisp.makeString("");
        this.B = f_lisp.makeString("a");
        this.C = f_lisp.makeString("ab");
        this.D = f_lisp.makeString("ba");
        this.E = f_lisp.makeString("bb");
        this.F = f_lisp.makeString("bbbbbbbz");
        this.G = f_lisp.makeInteger(5);
        LispString B1 = f_lisp.makeString("A");
        LispString C1 = f_lisp.makeString("AB");
        LispString D1 = f_lisp.makeString("BA");
        LispString E1 = f_lisp.makeString("BB");
        LispString F1 = f_lisp.makeString("BBBBBBBZ");
        LispInteger G1 = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringLessThanOrEqual(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.A.stringLessThanOrEqual(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringLessThanOrEqual(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringLessThanOrEqual(this.A) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringLessThanOrEqual(this.C) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringLessThanOrEqual(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringLessThanOrEqual(this.F) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringLessThanOrEqual(B1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((B1.stringLessThanOrEqual(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((E1.stringLessThanOrEqual(F1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringLessThanOrEqual(F1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringLessThanOrEqual(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringLessThanOrEqual(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
    }

    public void teststringGreaterThanOrEqual() {
        this.A = f_lisp.makeString("");
        this.B = f_lisp.makeString("a");
        this.C = f_lisp.makeString("ab");
        this.D = f_lisp.makeString("ba");
        this.E = f_lisp.makeString("bb");
        this.F = f_lisp.makeString("bbbbbbbz");
        this.G = f_lisp.makeInteger(5);
        LispString B1 = f_lisp.makeString("A");
        LispString C1 = f_lisp.makeString("AB");
        LispString D1 = f_lisp.makeString("BA");
        LispString E1 = f_lisp.makeString("BB");
        LispString F1 = f_lisp.makeString("BBBBBBBZ");
        LispInteger G1 = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringGreaterThanOrEqual(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.A.stringGreaterThanOrEqual(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringGreaterThanOrEqual(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringGreaterThanOrEqual(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringGreaterThanOrEqual(this.C) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringGreaterThanOrEqual(this.D) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringGreaterThanOrEqual(this.F) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringGreaterThanOrEqual(B1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((B1.stringGreaterThanOrEqual(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((E1.stringGreaterThanOrEqual(F1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringGreaterThanOrEqual(F1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringGreaterThanOrEqual(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringGreaterThanOrEqual(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
    }

    public void teststringNotLessP() {
        this.A = f_lisp.makeString("");
        this.B = f_lisp.makeString("a");
        this.C = f_lisp.makeString("ab");
        this.D = f_lisp.makeString("ba");
        this.E = f_lisp.makeString("bb");
        this.F = f_lisp.makeString("bbbbbbbz");
        this.G = f_lisp.makeInteger(5);
        LispString B1 = f_lisp.makeString("A");
        LispString C1 = f_lisp.makeString("AB");
        LispString D1 = f_lisp.makeString("BA");
        LispString E1 = f_lisp.makeString("BB");
        LispString F1 = f_lisp.makeString("BBBBBBBZ");
        LispInteger G1 = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringNotLessP(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.A.stringNotLessP(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringNotLessP(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringNotLessP(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringNotLessP(this.C) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringNotLessP(this.D) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringNotLessP(this.F) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringNotLessP(B1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((B1.stringNotLessP(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((E1.stringNotLessP(F1) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((F1.stringNotLessP(this.F) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringNotLessP(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringNotLessP(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
    }

    public void teststringNotGreaterP() {
        this.A = f_lisp.makeString("");
        this.B = f_lisp.makeString("a");
        this.C = f_lisp.makeString("ab");
        this.D = f_lisp.makeString("ba");
        this.E = f_lisp.makeString("bb");
        this.F = f_lisp.makeString("bbbbbbbz");
        this.G = f_lisp.makeInteger(5);
        LispString B1 = f_lisp.makeString("A");
        LispString C1 = f_lisp.makeString("AB");
        LispString D1 = f_lisp.makeString("BA");
        LispString E1 = f_lisp.makeString("BB");
        LispString F1 = f_lisp.makeString("BBBBBBBZ");
        LispInteger G1 = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringNotGreaterP(this.A) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.A.stringNotGreaterP(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringNotGreaterP(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringNotGreaterP(this.A) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringNotGreaterP(this.C) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringNotGreaterP(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringNotGreaterP(this.F) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringNotGreaterP(B1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((B1.stringNotGreaterP(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((E1.stringNotGreaterP(F1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringNotGreaterP(F1) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringNotGreaterP(this.D) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.D.stringNotGreaterP(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
    }

    public void teststringEndsWith() {
        this.A = f_lisp.makeString("mikey");
        this.B = f_lisp.makeString("key");
        this.C = f_lisp.makeString("MIKEY");
        this.D = f_lisp.makeString("MIkey");
        this.E = f_lisp.makeString("mikeys");
        this.F = f_lisp.makeString("");
        this.G = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringEndsWith(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringEndsWith(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringEndsWith(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringEndsWith(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringEndsWith(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringEndsWith(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringEndsWith(this.F) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringEndsWith(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.B.stringEndsWith(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringStartsWith() {
        this.A = f_lisp.makeString("mikey");
        this.B = f_lisp.makeString("mi");
        this.C = f_lisp.makeString("MIKEY");
        this.D = f_lisp.makeString("miKEY");
        this.E = f_lisp.makeString("smikey");
        this.F = f_lisp.makeString("");
        this.G = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringStartsWith(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringStartsWith(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringStartsWith(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringStartsWith(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringStartsWith(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringStartsWith(this.B) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringStartsWith(this.F) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringStartsWith(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException e) {
            // empty catch block
        }
        try {
            CoreTest.assertTrue((this.B.stringStartsWith(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringTrim() {
        this.A = f_lisp.makeString("   mikey   ");
        this.B = f_lisp.makeString("mikey   ");
        this.C = f_lisp.makeString("   mikey");
        this.D = f_lisp.makeString("  malikey");
        this.E = f_lisp.makeString("mikey");
        this.F = f_lisp.makeString("");
        this.G = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringTrim().stringEq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringTrim().stringEq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringTrim().stringEq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringTrim().stringEq(this.E) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringTrim().stringEq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringTrim().stringEq(this.E) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringTrim().stringEq(this.F) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((this.G.stringTrim() == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringTrim2() {
        this.A = f_lisp.makeString("aabbcmikeyabcdef");
        this.B = f_lisp.makeString("mikeycabcab");
        this.C = f_lisp.makeString("amikeyc");
        this.D = f_lisp.makeString("aamalikey");
        this.E = f_lisp.makeString("mikey");
        this.F = f_lisp.makeString("abcdef");
        this.G = f_lisp.makeString("");
        LispInteger H = f_lisp.makeInteger(5);
        CoreTest.assertTrue((this.A.stringTrim(this.F).stringEq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.B.stringTrim(this.F).stringEq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.C.stringTrim(this.F).stringEq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.stringTrim(this.F).stringEq(this.E) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringTrim(this.F).stringEq(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.F.stringTrim(this.F).stringEq(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.E.stringTrim(this.F).stringEq(this.F) == CoreTest.f_lisp.NIL ? 1 : 0) != 0);
        try {
            CoreTest.assertTrue((H.stringTrim(this.F) == CoreTest.f_lisp.T ? 1 : 0) != 0);
            CoreTest.fail((String)"Should have thrown a LispValueNotAStringException.");
        }
        catch (LispValueNotAStringException lispValueNotAStringException) {
            // empty catch block
        }
    }

    public void teststringLeftTrim() {
    }

    public void teststringLeftTrim2() {
    }

    public void teststringRightTrim() {
    }

    public void teststringRightTrim2() {
    }

    public void testsubst() {
    }

    public void testsubstring() {
    }

    public void testsymbolp() {
    }

    public void testsymbol_function() {
    }

    public void testsymbol_name() {
    }

    public void testsymbol_package() {
    }

    public void testsymbol_plist() {
    }

    public void testsymbol_value() {
    }

    public void testtenth() {
    }

    public void testthird() {
    }

    public void testtype_of() {
    }

    public void testtypep() {
    }

    public void testzerop() {
    }

    public void testAdd1() {
        this.A = f_lisp.makeReal(3.1);
        this.B = f_lisp.makeReal(3.2);
        CoreTest.assertTrue((this.A.add(this.B).subtract(f_lisp.makeReal(6.3)).lessThan(f_lisp.makeReal(1.0E-11)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testAdd2() {
        this.A = f_lisp.makeReal(3.1);
        this.E = f_lisp.makeInteger(14);
        CoreTest.assertTrue((this.A.add(this.E).eql(f_lisp.makeReal(17.1)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testAdd3() {
        this.C = f_lisp.makeReal(3.3);
        this.F = f_lisp.makeInteger(7);
        CoreTest.assertTrue((this.F.add(this.C).eql(f_lisp.makeReal(10.3)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testAdd4() {
        this.E = f_lisp.makeInteger(14);
        this.F = f_lisp.makeInteger(7);
        this.G = f_lisp.makeInteger(21);
        CoreTest.assertTrue((this.E.add(this.F).eql(this.G) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testAdd5() {
        this.A = f_lisp.makeReal(3.0);
        this.B = f_lisp.makeReal(3.2);
        this.C = f_lisp.makeReal(3.3);
        this.D = f_lisp.makeReal(4.5);
        this.E = f_lisp.makeInteger(14);
        CoreTest.assertTrue((this.A.add(this.B).add(this.C).add(this.D).eql(this.E) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testAdd6() {
        this.A = f_lisp.makeReal(3.0);
        this.B = f_lisp.makeReal(3.2);
        this.C = f_lisp.makeReal(3.3);
        this.D = f_lisp.makeReal(4.5);
        this.E = f_lisp.makeInteger(14);
        CoreTest.assertTrue((this.E.eql(this.A.add(this.B).add(this.C).add(this.D)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testDivide() {
        this.A = f_lisp.makeReal(3.1);
        this.B = f_lisp.makeReal(3.2);
        this.C = f_lisp.makeReal(3.3);
        this.D = f_lisp.makeReal(4.5);
        this.E = f_lisp.makeInteger(14);
        this.F = f_lisp.makeInteger(7);
        this.G = f_lisp.makeInteger(21);
        CoreTest.assertTrue((this.D.divide(this.C).eql(f_lisp.makeInteger(9).divide(f_lisp.makeReal(6.6))) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((this.D.divide(this.E).eql(f_lisp.makeInteger(9).divide(f_lisp.makeReal(28.0))) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        CoreTest.assertTrue((f_lisp.makeReal(13.5).divide(f_lisp.makeReal(4.5)).eql(f_lisp.makeInteger(3)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testMultiply() {
        this.A = f_lisp.makeInteger(6);
        this.B = f_lisp.makeInteger(7);
        this.C = f_lisp.makeInteger(0);
        this.D = f_lisp.makeInteger(8);
        this.E = this.A.multiply(this.B.multiply(this.C.multiply(this.D)));
        CoreTest.assertTrue((this.E.zerop() == CoreTest.f_lisp.T ? 1 : 0) != 0);
        this.A = f_lisp.makeReal(6.14);
        this.B = f_lisp.makeReal(7.0f);
        this.C = f_lisp.makeReal(0.0f);
        this.D = f_lisp.makeReal(12.12121212);
        this.E = this.A.multiply(this.B.multiply(this.C.multiply(this.D)));
        CoreTest.assertTrue((this.E.zerop() == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testSubtract1() {
        this.A = f_lisp.makeReal(5.1);
        this.B = f_lisp.makeReal(14.2);
        CoreTest.assertTrue((this.B.subtract(this.A).subtract(f_lisp.makeReal(9.1)).lessThan(f_lisp.makeReal(1.0E-11)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testSubtract2() {
        this.A = f_lisp.makeReal(3.1);
        this.B = f_lisp.makeInteger(14);
        CoreTest.assertTrue((this.A.subtract(this.B).subtract(f_lisp.makeReal(-10.9)).lessThan(f_lisp.makeReal(1.0E-11)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testSubtract3() {
        this.A = f_lisp.makeReal(3.3);
        this.B = f_lisp.makeInteger(7);
        CoreTest.assertTrue((this.B.subtract(this.A).subtract(f_lisp.makeReal(3.7)).lessThan(f_lisp.makeReal(1.0E-11)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testSubtract4() {
        this.A = f_lisp.makeInteger(14);
        this.B = f_lisp.makeInteger(7);
        this.C = f_lisp.makeInteger(21);
        CoreTest.assertTrue((this.C.subtract(this.A).eql(this.B) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testSubtract5() {
        this.A = f_lisp.makeInteger(5);
        this.B = f_lisp.makeReal(3.2);
        this.C = f_lisp.makeReal(3.3);
        this.D = f_lisp.makeReal(9.5);
        this.E = f_lisp.makeReal(21.0);
        CoreTest.assertTrue((this.E.subtract(this.D).subtract(this.C).subtract(this.B).subtract(this.A).lessThan(f_lisp.makeReal(1.0E-6)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testSubtract6() {
        this.A = f_lisp.makeInteger(5);
        this.B = f_lisp.makeReal(3.2);
        this.C = f_lisp.makeReal(3.3);
        this.D = f_lisp.makeReal(9.5);
        this.E = f_lisp.makeReal(21.0);
        CoreTest.assertTrue((this.A.subtract(this.E).subtract(this.D).subtract(this.C).subtract(this.B).lessThan(f_lisp.makeReal(1.0E-6)) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testToString() {
        CoreTest.assertTrue((boolean)"A".equals(((Object)this.A).toString()));
        CoreTest.assertTrue((boolean)"B".equals(((Object)this.B).toString()));
        CoreTest.assertTrue((boolean)"C".equals(((Object)this.C).toString()));
        CoreTest.assertTrue((boolean)"\"a test string\"".equals(((Object)this.f_String).toString()));
        CoreTest.assertTrue((boolean)"a test string".equals(this.f_String.toStringSimple()));
    }

    public void testLongList() {
        LispConsOrNil longList_1 = CoreTest.f_lisp.NIL;
        LispConsOrNil longList_2 = CoreTest.f_lisp.NIL;
        for (int i = 0; i < 14000; ++i) {
            longList_1 = new StandardLispCons(f_lisp, this.A, longList_1);
            longList_2 = new StandardLispCons(f_lisp, this.B, longList_2);
        }
        CoreTest.assertTrue((longList_1.basic_length() == 14000 ? 1 : 0) != 0);
        CoreTest.assertTrue((longList_2.basic_length() == 14000 ? 1 : 0) != 0);
        CoreTest.assertTrue((longList_1.basic_length() == longList_2.basic_length() ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

