/*
 * Tag menu
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "TagMenu.h"

#include "Environment.h"
#include "TagcollDocument.h"

#include <map>
#include <vector>
#include <string>

using namespace std;
using namespace Tagcoll;

template<class DOC>
void TagMenu<DOC>::do_selected(Tag tag)
{
	_signal_selected.emit(tag);
}

template<class DOC>
void TagMenu<DOC>::populateWith(const TagSet& tags) throw ()
{
	// Needs std:: not to be confused with some other map
	std::map<Facet, vector<Tag> > contents;
    for (TagSet::const_iterator i = tags.begin(); i != tags.end(); i++)
	{
		std::map<Facet, vector<Tag> >::iterator j = contents.find(i->facet());
		if (j != contents.end())
			j->second.push_back(*i);
		else
		{
			std::vector<Tag> v;
			v.push_back(*i);
			contents.insert(pair<Facet, vector<Tag> >(i->facet(), v));
		}
	}

	for (std::map<Facet, vector<Tag> >::const_iterator i = contents.begin(); i != contents.end(); i++)
	{
		Gtk::Menu* submenu = manage(new Gtk::Menu);
		for (vector<Tag>::const_iterator j = i->second.begin(); j != i->second.end(); j++)
		{
			submenu->items().push_back(Gtk::Menu_Helpers::MenuElem(
						j->name(),
						sigc::bind<Tag>(
							sigc::mem_fun(*this, &TagMenu::do_selected), *j)));
			//printf("Adding %.*s::%.*s\n", PFSTR(i->first), PFSTR(*j));
		}
		if (i->first.name().empty())
			items().push_back(Gtk::Menu_Helpers::MenuElem("(legacy)", *submenu));
		else
			items().push_back(Gtk::Menu_Helpers::MenuElem(i->first.name(), *submenu));
	}
}

template<class DOC>
void TagMenu<DOC>::populateWith(const TagSet& tags, const Facet& facet) throw ()
{
	for (TagSet::const_iterator i = tags.begin(); i != tags.end(); i++)
	{
		//printf("Facet: %.*s, tag: %.*s\n", PFSTR(f), PFSTR(t));
		if (i->facet() == facet)
		{
			//printf("Adding %.*s\n", PFSTR(*i));
			items().push_back(Gtk::Menu_Helpers::MenuElem(
						i->name(),
						sigc::bind<Tag>(
							sigc::mem_fun(*this, &TagMenu::do_selected), *i)));
		}
	}
}

template<class DOC>
void TagMenu<DOC>::populateAll(const DOC& doc) throw ()
{
	TagSet allTags = doc.collection().getAllTags();
	populateWith(allTags);
}

/*
template<class DOC>
void TagMenu<DOC>::populateAvailable(const DOC& doc, const std::vector<string>& items) throw ()
{
	TagSet merged;
	TagSet inters;

	// Create merged tagset
	// Create intersected tagset
	for (vector<string>::const_iterator i = items.begin(); i != items.end(); i++)
	{
		TagSet tags = (*i).tags();
		if (i == items.begin())
			inters = tags;
		else
			inters ^= tags;
		merged += tags;
	}

	// Use merged - intersected
	populateWith(merged - inters);
}
*/

template<class DOC>
void TagMenu<DOC>::populateAvailable(const DOC& doc, const TagSet& selectedTags) throw ()
{
	TagSet tags = doc.collection().getCompanionTags(selectedTags);
	populateWith(tags);
}

template<class DOC>
void TagMenu<DOC>::populateAvailable(const DOC& doc, const TagSet& selectedTags, const Facet& facet) throw ()
{
	TagSet tags = doc.collection().getCompanionTags(selectedTags);
	populateWith(tags, facet);
}

template<class DOC>
void TagMenu<DOC>::populateUnselected(const DOC& doc, const TagSet& selectedTags) throw ()
{
	TagSet tags = doc.collection().getAllTags() - selectedTags;
	//for (OpSet<string>::const_iterator i = tags.begin(); i != tags.end(); i++)
		//printf("Sel: %.*s\n", PFSTR(*i));
	populateWith(tags);
}

template<class DOC>
void TagMenu<DOC>::populateUnselected(const DOC& doc, const TagSet& selectedTags, const Facet& facet) throw ()
{
	TagSet tags = doc.collection().getAllTags() - selectedTags;
	//for (OpSet<string>::const_iterator i = tags.begin(); i != tags.end(); i++)
		//printf("Sel: %.*s\n", PFSTR(*i));
	populateWith(tags, facet);
}

template class TagMenu< TagcollDocument<string> >;

// vim:set ts=4 sw=4:
