#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdarg.h>
#include <signal.h>


#include "io_lib_header.h"
#include "util_lib_header.h"
#include "dp_lib_header.h"
#include "define_header.h"
#include "t_coffee.h"
void test();
static char *get_evaluate_defaults(char *buf);
static char *get_genome_defaults(char *buf);
static char *get_dali_defaults(char *buf);
static char *get_very_fast_defaults(char *buf);
static char *get_precomputed_defaults(char *buf);
static char *get_3dcoffee_defaults(char *buf);
static char *get_repeat_defaults(char *buf);
static char *get_low_memory_defaults( char *buf);

static int run_other_pg(int argc, char *argv[]);
static char *t_coffee_command2dpa_command ( char **argv, int argc,struct Constraint_list *CL, char*run_name);
#define is_a_seq_file(file) (!is_matrix(file) && !is_matrix(file+1) && !is_method (file) && !is_method (file+1) &&(check_file_exists(file) || check_file_exists(file+1))) 
main ( int argc, char *argv[])
	{
	
	int a, b, c, t;
	char *f;

	Sequence *S;
	char **new_order;
	char **initial_order;

	Fname *F=NULL;
	Constraint_list *CL;
	Alignment  *A=NULL, *EA=NULL;
	Alignment  **aln_list;
	Sequence *SEQ_LIST;
	FILE *OUT;	

	
	NT_node **T=NULL;
	int tot_node;
	char *pc;
/*Parameters*/
	int ulimit;
	int check_configuration;
	int update;
	int garbage;
	int quiet;
	char *parameters;
	char *t_coffee_defaults;
	int t_coffee_defaults_flag;
	char *dali_defaults;
	char *very_fast_defaults;
	
	FILE *le=NULL;
	char *se_name;
	char *run_name;
	
	char *mem_mode;
	
	int do_extend;
	char *extend_mode;
	int max_n_pair;
	int  nseq_for_quadruplet;
	char **seq_name_for_quadruplet;
	
	int do_compact;
	int **do_list;
	int n_do;

	char *compact_mode;
	int do_clean;
	char *clean_mode;
	int do_self;
	int do_normalise;
	


	int n_list;
	char **list_file;
	
	int n_seq_list;
	char **seq_list;
	char **template_file_list;
	int n_template_file;
	
	int n_pdb;
	char **pdb_list;
	int pdb_start, pdb_end;
	char *pdb_name;

	char *out_lib;
	int lib_only;
	char *outseqweight;



	char *seq_source;
	
	int cosmetic_penalty,gop,f_gop, gep,f_gep, nomatch;
	
	char *tree_file;
	char *use_tree;
	char *tree_mode;

	int quicktree;
	char *out_aln;
	char **tot_out_aln;
	int maximise;
	char **out_aln_format;
	int  n_out_aln_format;
	char *infile;
	char *matrix;
	char *dp_mode;
	char *profile_mode;
	char *profile_comparison;
	
	
	int tg_mode;
	int   ktup;
	int   fasta_step;
	int   diag_threshold;
	int   diag_mode;
	char *sim_matrix;

	char *type;
	char *outorder;
	char *output_res_num;
	char *residue_case;
	int extra_cpu;

	char *weight;
	char *seq_weight;
	int do_align;
	char *evaluate_mode;
	
	int get_type;
	/*Post_processing*/
	int clean_aln;
	int clean_threshold;
	int clean_iteration;
	char *clean_evaluate_mode;
	/*Profile Alignment*/
	
	char **profile;
	int n_profile;
	
	char *profile1;
	char *profile2;

	/*Domain Parameters*/
	int do_domain;
	int domain_start;
	int domain_len;
	int domain_scale;
	int domain_interactive;
	/* extended matrix analysis*/
	int do_extended_matrix;
	/*Action Parameters*/
	int do_evaluate;
	int do_convert;
	int do_version;

	int maxnseq;
	int maxlen;
	/*Thread parameters*/
	int prot_min_sim;
	int prot_max_sim;
	int prot_min_cov;
	int pdb_min_sim;
	int pdb_max_sim;
	int pdb_min_cov;
	

	
	char *prot_blast_server;
	char *pdb_blast_server;
	
	
	char *pdb_db;
	char *prot_db;
	NT_node *SNL;
	
	/*
	char *dna_db;
	char *dna_blast_server;
	int dna_min_sim;
	int dna_max_sim;
	int dna_min_cov;
	*/


	/*Method log*/
	char * method_log;	

	char **struc_to_use;
	int n_struc_to_use;

	/*Cache*/
	char * cache;

	/*align_pdb*/
	char *align_pdb_param_file;
	char *align_pdb_hasch_mode;
	char *msa_mode;
	int lalign_n_top;
	int iterate;
	/*split*/
	int split;
	int split_nseq_thres;
	int split_score_thres;
	char split_name[1000];
	char split_format[1000];
	Alignment *SPLIT_ALN;
	
	int check_pdb_status;
	/*trim*/
	int trim;
	Sequence *trim_subS=NULL;
	Sequence *trim_S=NULL;
	Sequence *SEQ_TO_KEEP=NULL;
	char *trimfile;
	char trim_format[1000];
	int n_seq_to_keep;
	char **seq_to_keep;
	char *special_mode;

	/*dpa*/
	char *dpa_master_aln;
	int dpa_min_score1;
	int dpa_min_score2;
	int dpa_maxnseq;
	int dpa_keep_tmpfile;
	int dpa_debug;
	/*error report*/
	char *full_log;

	/*Multithread*/
	char *multi_thread;
	char *lib_list;
system ("set SEQ_REFORMAT \"t_coffee -other_pg seq_reformat \"");
argv=standard_initialisation (argv, &argc);

 

/*Running other programs via T-Coffee*/
if (argc>=3 && strm (argv[1], "-other_pg"))
  {
    return run_other_pg (argc-2, argv+2);
  }

/*PARAMETER PROTOTYPE:    READ PARAMETER FILE     */
	       
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-ulimit"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Limit the maximum memory usage (in Megabytes). 0: no limit" ,\
			    /*Parameter*/ &ulimit          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "100"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );	     
/*PARAMETER PROTOTYPE:    READ PARAMETER FILE     */
	       declare_name (parameters);
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-parameters"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "R_F"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "get bottom parameters" ,\
			    /*Parameter*/ &parameters          ,\
			    /*Def 1*/     "NULL"             ,\
			    /*Def 2*/     "stdin"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );	     
	       declare_name (special_mode);
	       
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-special_mode"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "specifies a special mode: genome, quickaln, dali, 3dcoffee" ,\
			    /*Parameter*/ &special_mode          ,\
			    /*Def 1*/     "none"             ,\
			    /*Def 2*/     "HARD_CODED"       ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
	       declare_name (very_fast_defaults);
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-very_fast"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Get parameters that make T-Coffee very fast (ktup tree and 10 top diagonals)" ,\
			    /*Parameter*/ &very_fast_defaults          ,\
			    /*Def 1*/     "NULL"             ,\
			    /*Def 2*/     "HARD_CODED"       ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
	       declare_name (dali_defaults);
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-dali_defaults"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "get top parameters" ,\
			    /*Parameter*/ &dali_defaults          ,\
			    /*Def 1*/     "NULL"             ,\
			    /*Def 2*/     "HARD_CODED"       ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
	       declare_name (t_coffee_defaults);
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-t_coffee_defaults"        ,\
			    /*Flag*/      &t_coffee_defaults_flag     ,\
			    /*TYPE*/      "R_F"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "get top parameters" ,\
			    /*Parameter*/ &t_coffee_defaults          ,\
			    /*Def 1*/     "NULL"             ,\
			    /*Def 2*/     "NULL"       ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );




/* extra>prompt>special>parameters>defaults*/
argv=break_list ( argv, &argc, "=;, \n");
argv=merge_list ( argv, &argc);
if (argc>1 && argv[1][0]!='-')argv=push_string ("-seq ", argv, &argc, 1);

if (t_coffee_defaults_flag)
  {
    char *pname=NULL;
    
    pname=getenv ( "TCOFFEE_DEFAULTS");
    
    if (check_file_exists ( t_coffee_defaults))pname=t_coffee_defaults;
    else if ( getenv ( "TCOFFEE_DEFAULTS"))
      {
	pname=getenv ( "TCOFFEE_DEFAULTS");
	if (check_file_exists(pname));
	else pname=NULL;
      }
    else
      {
	declare_name(pname);sprintf (pname, "%s/.t_coffee_defaults",getenv ( "HOME") );
	if (!check_file_exists (pname)){vfree(pname);pname=NULL;}
      }
    
    if (pname)
      {
	argv=push_string (file2string(pname), argv, &argc, 1);
	t_coffee_defaults=pname;
      }
    else
      {
	t_coffee_defaults=NULL;
      }
  }
if ( parameters && parameters[0])argv=push_string (file2string (parameters), argv, &argc, 1);

if (special_mode || dali_defaults || very_fast_defaults )
   {
     char *new_arg=NULL;
     if (special_mode && !special_mode[0]);
     else if ( strm (special_mode, "genome"))new_arg=get_genome_defaults(NULL);
     else if ( strm (special_mode, "quickaln") || very_fast_defaults && very_fast_defaults[0])new_arg=get_very_fast_defaults(NULL);
     else if ( strm (special_mode, "dali") || (dali_defaults && dali_defaults[0]) )new_arg=get_dali_defaults(NULL);
     else if ( strm (special_mode, "evaluate"))new_arg=get_evaluate_defaults(NULL);
     else if ( strm (special_mode, "precomputed"))new_arg=get_precomputed_defaults(NULL);
     else if ( strm (special_mode, "3dcoffee"))new_arg=get_3dcoffee_defaults(NULL);
     else if ( strm (special_mode, "repeats"))new_arg=get_repeat_defaults(NULL);
     else if ( strm (special_mode, "low_memory"))new_arg=get_low_memory_defaults(NULL);
     
     else if ( strm (special_mode, "none"));
     else
       {
	 fprintf ( stderr, "\nERROR: special_mode %s is unknown [FATAL:%s]\n",special_mode, PROGRAM);
	 exit (EXIT_FAILURE);
       }
	       
     argv=push_string (new_arg, argv, &argc, 1);
   }	 
if ( getenv ("TCOFFEE_EXTRA_PARAM"))argv=push_string (getenv ("TCOFFEE_EXTRA_PARAM"), argv, &argc, argc); 


argv=break_list ( argv, &argc, "=;, \n");
argv=merge_list ( argv, &argc);


/*PARAMETER PROTOTYPE:    VERSION      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-version"        ,\
			    /*Flag*/      &do_version        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "forces the program to output the version number and exit" ,\
			    /*Parameter*/ &do_version          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \
		   );


/*PARAMETER PROTOTYPE:    DO EVALUATE      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-score"        ,\
			    /*Flag*/      &do_evaluate        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "DEPRECATED: use -special_mode evaluate instead " ,\
			    /*Parameter*/ &do_evaluate          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \
		   );
if ( !do_evaluate)
  {
/*PARAMETER PROTOTYPE:    DO EVALUATE      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-evaluate"        ,\
			    /*Flag*/      &do_evaluate        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Use -special_mode evaluate for a default behavior " ,\
			    /*Parameter*/ &do_evaluate          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \
		   );
  }
/*PARAMETER PROTOTYPE:    DO FORMAT      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-convert"        ,\
			    /*Flag*/      &do_convert        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "forces the program to make a convertion" ,\
			    /*Parameter*/ &do_convert          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \
		   );	     


/*PARAMETER PROTOTYPE*/
     declare_name (se_name);
     get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-quiet"      ,\
			    /*Flag*/      &quiet        ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Defines the file in which the log output is written"          ,\
			    /*Parameter*/ &se_name      ,\
			    /*Def 1*/     "stderr"      ,\
			    /*Def 2*/     "/dev/null"   ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
     /*PARAMETER PROTOTYPE:    DO FORMAT      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-check_configuration"        ,\
			    /*Flag*/      &check_configuration       ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "checks that the required programs are installed" ,\
			    /*Parameter*/ &check_configuration          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \
			    );	     
	  /*PARAMETER PROTOTYPE:    UPDATE      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-update"        ,\
			    /*Flag*/      &update,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "checks the existence of an updated version" ,\
			    /*Parameter*/ &update          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \
			    );     

	       

     if ( check_configuration)
       {
	 
	 check_configuration4program();
	 exit (EXIT_SUCCESS);
	 
       }
     if ( update)
       {
	 exit (check_for_update(DISTRIBUTION_ADDRESS));
       }
     if ( do_version)
       {
	 fprintf ( stdout, "PROGRAM: %s (%s)\n",PROGRAM,VERSION);
	 exit (EXIT_SUCCESS);
       }


     le=vfopen ( se_name, "w");
     fprintf ( le, "\nPROGRAM: %s (%s)\n",PROGRAM,VERSION);

/*PARAMETER PROTOTYPE: RUN NAME*/
               declare_name (full_log);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-full_log"   ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"          ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Sets the prefix of all the output files"          ,\
			    /*Parameter*/ &full_log     ,\
			    /*Def 1*/     "NULL"        ,\
			    /*Def 2*/     "full_log"            ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
	       vremove(full_log);
/*PARAMETER PROTOTYPE: RUN NAME*/
               declare_name (run_name);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-run_name"   ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"          ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Sets the prefix of all the output files"          ,\
			    /*Parameter*/ &run_name     ,\
			    /*Def 1*/     "NULL"        ,\
			    /*Def 2*/     ""            ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

/*PARAMETER PROTOTYPE: MEM MODE*/
	       declare_name(mem_mode);
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-mem_mode"   ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"          ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Deprecated" ,\
			    /*Parameter*/ &mem_mode     ,\
			    /*Def 1*/     "mem"         ,\
			    /*Def 2*/     ""            ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

/*PARAMETER PROTOTYPE: EXTEND  */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-extend"     ,\
			    /*Flag*/      &do_extend    ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Do Library Extention On the Fly"          ,\
			    /*Parameter*/ &do_extend    ,\
			    /*Def 1*/     "1"           ,\
			    /*Def 2*/     "1"           ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
/*PARAMETER PROTOTYPE: EXTEND  */
	       declare_name (extend_mode);
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-extend_mode"     ,\
			    /*Flag*/      &garbage    ,\
			    /*TYPE*/      "S"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Library extension mode"          ,\
			    /*Parameter*/ &extend_mode    ,\
			    /*Def 1*/     "very_fast_triplet"           ,\
			    /*Def 2*/     ""           ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
	       /*PARAMETER PROTOTYPE: EXTEND  */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-max_n_pair"     ,\
			    /*Flag*/      &garbage    ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Indicates the Number of Pairs to Compare when making prf Vs prf. 0<=>every pair "          ,\
			    /*Parameter*/ &max_n_pair    ,\
			    /*Def 1*/     "10"           ,\
			    /*Def 2*/     "3"           ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
	       
/*PARAMETER PROTOTYPE: SEQUENCES TO EXTEND */
	seq_name_for_quadruplet=declare_char ( 200, STRING);
	nseq_for_quadruplet=get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-seq_name_for_quadruplet"         ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  200           ,\
			    /*DOC*/       "Indicates which sequence must be used to compute quadruplets"          ,\
			    /*Parameter*/ seq_name_for_quadruplet    ,\
			    /*Def 1*/     "all",\
			    /*Def 2*/     ""       ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
/*PARAMETER PROTOTYPE: COMPACT */
	       declare_name (compact_mode);
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-compact"    ,\
			    /*Flag*/      &do_compact   ,\
			    /*TYPE*/      "S"          ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Deprecated"          ,\
			    /*Parameter*/ &compact_mode ,\
			    /*Def 1*/     "default"      ,\
			    /*Def 2*/     "default"      ,\
			    /*Min_value*/ "0"           ,\
			    /*Max Value*/ "1"           \
		   );


/*PARAMETER PROTOTYPE:        CLEAN*/
	       declare_name ( clean_mode);
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-clean"      ,\
			    /*Flag*/      &do_clean     ,\
			    /*TYPE*/      "S"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Deprecated"          ,\
			    /*Parameter*/ &clean_mode   ,\
			    /*Def 1*/     "no"          ,\
			    /*Def 2*/     "shadow"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"         \
		   );

/*PARAMETER PROTOTYPE:        DO SELF */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-do_self"    ,\
			    /*Flag*/      &do_self      ,\
			    /*TYPE*/      "FL"          ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  0             ,\
			    /*DOC*/       "Make self extension. Used by Mocca"          ,\
			    /*Parameter*/ &do_self      ,\
			    /*Def 1*/     "0"           ,\
			    /*Def 2*/     "1"           ,\
			    /*Min_value*/ "0"           ,\
			    /*Max Value*/ "1"           \
		   );

/*PARAMETER PROTOTYPE:        DO NORMALISE */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-do_normalise"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"          ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Normalisation factor when computing scores"          ,\
			    /*Parameter*/ &do_normalise ,\
			    /*Def 1*/     "1000"           ,\
			    /*Def 2*/     "1000"       ,\
			    /*Min_value*/ "0"           ,\
			    /*Max Value*/ "10000"           \
		   );
/*PARAMETER PROTOTYPE:        IN */
	       template_file_list=declare_char (100, STRING);
	       n_template_file=get_cl_param(			\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-template_file"         ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1000           ,\
			    /*DOC*/       "List of templates file for the sequences",\
			    /*Parameter*/ template_file_list     ,	\
			    /*Def 1*/    "",\
			    /*Def 2*/     "stdin"       ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
	/*PARAMETER PROTOTYPE:        IN */
	seq_list=declare_char (1000, STRING);
	n_seq_list=get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-seq"         ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1000           ,\
			    /*DOC*/       "List of sequences in any acceptable format",\
			    /*Parameter*/ seq_list     ,\
			    /*Def 1*/    "",\
			    /*Def 2*/     "stdin"       ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
	/*PARAMETER PROTOTYPE:        IN */
	list_file=declare_char (2000, STRING);
	n_list=get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-in"         ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  2000           ,\
			    /*DOC*/       "Reads the Ssequences, Mmethods, Llibraries,Xmatrices,Rprofiles,Pstructures,AAlignments"          ,\
			    /*Parameter*/ list_file     ,\
			    /*Def 1*/    "Mlalign_id_pair Mslow_pair",\
			    /*Def 2*/     "stdin"       ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
	pdb_list=declare_char ( 200, STRING);
	n_pdb=get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-pdb"         ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  200           ,\
			    /*DOC*/       "Reads/fetch a pdb file: PDBID(PDB_CHAIN)[opt] (FIRST,LAST)[opt],"          ,\
			    /*Parameter*/ pdb_list     ,\
			    /*Def 1*/    "",\
			    /*Def 2*/     ""       ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
	

/*PARAMETER PROTOTYPE:    OUT_LIB     */
	declare_name (out_lib);
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-out_lib"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Prompts the program to write the computed library file"          ,\
			    /*Parameter*/&out_lib       ,\
			    /*Def 1*/    "no"      ,\
			    /*Def 2*/    "default"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
/*PARAMETER PROTOTYPE:    OUT_LIB     */
	       
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-lib_only"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Only Compute the library",\
			    /*Parameter*/&lib_only       ,\
			    /*Def 1*/    "0"      ,\
			    /*Def 2*/    "1"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

/*PARAMETER PROTOTYPE:    OUT_LIB     */
	declare_name (outseqweight);
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-outseqweight"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Prompts the program to write the sequuence weight values"          ,\
			    /*Parameter*/&outseqweight       ,\
			    /*Def 1*/    "no"      ,\
			    /*Def 2*/    "default"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
/*PARAMETER PROTOTYPE:    SEQ TO ALIGN     */
	       declare_name (seq_source);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-seq_source",\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"          ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Indicates the files that will be used as sequence sources, important for dpa. With the default mode alignments must be provided with the Sflag as well as tye Aflag if they contribute novel sequences",\
			    /*Parameter*/ &seq_source   ,\
			    /*Def 1*/    "ANY"          ,\
			    /*Def 2*/    ""              ,\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );

/*PARAMETER PROTOTYPE:    COSMETIC PENALTY     */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-cosmetic_penalty" ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "A very low Gap Opening Penalty.It only affects the non stable portions of the alignmnent.Negative values penalize gaps, positive values reward them"          ,\
			    /*Parameter*/ &cosmetic_penalty          ,\
			    /*Def 1*/    "-50"            ,\
			    /*Def 2*/    "-50"             ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );	       
/*PARAMETER PROTOTYPE:    GAPOPEN     */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-gapopen"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Gap opening penalty. Cosmetic penalty is set to 0 when Gapopen is set. Negative values penalize gaps, positive values reward them"          ,\
			    /*Parameter*/ &gop          ,\
			    /*Def 1*/    "0"            ,\
			    /*Def 2*/    ""             ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

/*PARAMETER PROTOTYPE:    GAPEXT     */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-gapext"     ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Gap Extension Penalty. Positive values give rewards to gaps and prevent the alignment of unrelated segments"          ,\
			    /*Parameter*/ &gep          ,\
			    /*Def 1*/    "0"            ,\
			    /*Def 2*/    ""             ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"         \
		   );

/*PARAMETER PROTOTYPE:    F_GAPOPEN     */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-fgapopen"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Deprecated"          ,\
			    /*Parameter*/ &f_gop          ,\
			    /*Def 1*/    "0"            ,\
			    /*Def 2*/    ""             ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
/*PARAMETER PROTOTYPE:    F_GAPEXT     */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-fgapext"     ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Deprecated"          ,\
			    /*Parameter*/ &f_gep          ,\
			    /*Def 1*/    "0"            ,\
			    /*Def 2*/    ""             ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"         \
		   );
/*PARAMETER PROTOTYPE:    NEW_TREE     */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-nomatch"     ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Deprecated"          ,\
			    /*Parameter*/ &nomatch          ,\
			    /*Def 1*/    "0"            ,\
			    /*Def 2*/    "0"             ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"         \
		   );	       
	       declare_name ( tree_file);
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-newtree"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Name of the output guide tree"          ,\
			    /*Parameter*/&tree_file     ,\
			    /*Def 1*/    "default"      ,\
			    /*Def 2*/    ""             ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"         \
		   );
/*PARAMETER PROTOTYPE:    USETREE     */
	       declare_name ( use_tree);
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-usetree",\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "R_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Use an existing guide tree"          ,\
			    /*Parameter*/ &use_tree     ,\
			    /*Def 1*/    "NULL"         ,\
			    /*Def 2*/    "NULL"         ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"         \
		   );

/*PARAMETER PROTOTYPE:    OUT_LIB     */
	       declare_name ( tree_mode);
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-tree_mode"  ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Computation of the distances for the tree: slow, fast, very_fast"          ,\
			    /*Parameter*/ &tree_mode    ,\
			    /*Def 1*/    "slow"         ,\
			    /*Def 2*/    "slow"         ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
/*PARAMETER PROTOTYPE:    OUT_LIB     */
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
 			    /*output*/    &le           ,\
	 		    /*Name*/      "-quicktree"  ,\
		 	    /*Flag*/      &quicktree    ,\
			    /*TYPE*/      "FL"          ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  0             ,\
			    /*DOC*/       "Use tree_mode=very_fast"          ,\
			    /*Parameter*/ &quicktree    ,\
			    /*Def 1*/    "0"            ,\
			    /*Def 2*/    "1"            ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
	       if ( quicktree)sprintf ( tree_mode, "very_fast");
/*PARAMETER PROTOTYPE:    OUTFILE     */
	       declare_name ( out_aln);
	       tot_out_aln=declare_char (200, STRING);
	        get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-outfile"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Name of the output alignment"          ,\
			    /*Parameter*/ &out_aln      ,\
			    /*Def 1*/    "default"      ,\
			    /*Def 2*/    ""             ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

/*PARAMETER PROTOTYPE:    MAXIMISE     */		
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-maximise"   ,\
			    /*Flag*/      &maximise     ,\
			    /*TYPE*/      "FL"          ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  0             ,\
			    /*DOC*/       "Deprecated"          ,\
			    /*Parameter*/ &maximise     ,\
			    /*Def 1*/    "1"            ,\
			    /*Def 2*/    "1"            ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"         \
		   );
	       
/*PARAMETER PROTOTYPE:    OUTPUT_FORMAT    */
	       out_aln_format=declare_char ( 200, STRING);
	       n_out_aln_format=get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-output"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  200              ,\
			    /*DOC*/       "Specifies one or many formats that must be output: clustalw_aln, msf_aln. The file extension is the output format"           ,\
			    /*Parameter*/ out_aln_format,\
			    /*Def 1*/    "clustalw"           ,\
			    /*Def 2*/    "1"             ,\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );
/*PARAMETER PROTOTYPE:    INFILE    */
	       declare_name (infile);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-infile"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "R_F"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "input a pre-computed alignment, or a file to reformat"           ,\
			    /*Parameter*/ &infile        ,\
			    /*Def 1*/    ""              ,\
			    /*Def 2*/    ""              ,\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	       

/*PARAMETER PROTOTYPE:    INFILE    */
	       declare_name (matrix);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-matrix"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Specifies the substitution matrix.\nWARNING: This Flag Causes T-Coffee to behave like ClustalW (No library) "           ,\
			    /*Parameter*/ &matrix        ,\
			    /*Def 1*/    "blosum62mt"              ,\
			    /*Def 2*/    "blosum62mt"    ,\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	    
/*PARAMETER PROTOTYPE:    TG_MODE    */
	       
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-tg_mode"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "D"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "0: Penalise Term gap with gapopen and gapext\n1: gapopen only\n2: No penalty\n",\
			    /*Parameter*/ &tg_mode        ,\
			    /*Def 1*/    "1",\
			    /*Def 2*/    "0",\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	   
/*PARAMETER PROTOTYPE:    DP_MODE    */
	       declare_name (profile_mode);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-profile_mode"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Function used to compute profile2profile scores",\
			    /*Parameter*/ &profile_mode        ,\
			    /*Def 1*/    "cw_profile_profile",\
			    /*Def 2*/    "cw_profile_profile",\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );

	       declare_name (profile_comparison);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-profile_comparison"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Method used to compare two profiles: full<N>: compares <every | N best> pair of sequence and every pair of structure if a structure method is used,profile: compares only the profiles.  ",\
			    /*Parameter*/ &profile_comparison        ,\
			    /*Def 1*/    "full50",\
			    /*Def 2*/    "profile",\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );
/*PARAMETER PROTOTYPE:    DP_MODE    */
	       declare_name (dp_mode);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-dp_mode"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Type of alignment algorithm used by T-Coffee: gotoh_pair_wise, myers_millers_pair_wise, "           ,\
			    /*Parameter*/ &dp_mode        ,\
			    /*Def 1*/    "cfasta_pair_wise",\
			    /*Def 2*/    "cfasta_pair_wise",\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	       
/*PARAMETER PROTOTYPE:    KTUP    */
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-ktuple"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "D"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Word size when using the heursitic dynamic programming modes fasta_pair_wise and cfasta_pair_wise "           ,\
			    /*Parameter*/ &ktup          ,\
			    /*Def 1*/    "1",\
			    /*Def 2*/    "1",\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	       
/*PARAMETER PROTOTYPE:    FASTA_STEP    */
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-ndiag"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "D"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Number of diagonals to consider when using the heursitic dynamic programming modes fasta_pair_wise and cfasta_pair_wise"           ,\
			    /*Parameter*/ &fasta_step          ,\
			    /*Def 1*/    "0",\
			    /*Def 2*/    "10",\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	
/*PARAMETER PROTOTYPE:    FASTA_STEP    */
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-diag_threshold"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "D"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "ND"           ,\
			    /*Parameter*/ &diag_threshold ,\
			    /*Def 1*/    "0",\
			    /*Def 2*/    "10",\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	    
/*PARAMETER PROTOTYPE:    diag_mode    */
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-diag_mode"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "D"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "0: Use the whole Diag\n1: Use the best match\n"           ,\
			    /*Parameter*/ &diag_mode          ,\
			    /*Def 1*/    "0",\
			    /*Def 2*/    "1",
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	
/*PARAMETER PROTOTYPE:    SIM_MATRIX    */
	       declare_name (sim_matrix);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-sim_matrix"      ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Degenerated matrix used to compute a similarity"           ,\
			    /*Parameter*/ &sim_matrix        ,\
			    /*Def 1*/    "vasiliky",\
			    /*Def 2*/    "idmat",\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	       

/*PARAMETER PROTOTYPE:    INFILE    */
	       declare_name (type);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-type"        ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "protein or dna. Automatically set, but can be forced with this flag"           ,\
			    /*Parameter*/ &type          ,\
			    /*Def 1*/    ""              ,\
			    /*Def 2*/    ""              ,\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );	
/*PARAMETER PROTOTYPE:    INFILE    */
	       declare_name (outorder);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-outorder"        ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Specifies the order of the sequences in the msa: input or aligned"           ,\
			    /*Parameter*/ &outorder       ,\
			    /*Def 1*/    "aligned"          ,\
			    /*Def 2*/    "input"        ,\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );
/*PARAMETER PROTOTYPE:    INFILE    */
	       declare_name (output_res_num);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-seqnos"        ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Adds Residue Numbers to the MSA"           ,\
			    /*Parameter*/ &output_res_num ,\
			    /*Def 1*/    "off"            ,\
			    /*Def 2*/    "on"             ,\
			    /*Min_value*/ "any"           ,\
			    /*Max Value*/ "any"            \
		   );
/*PARAMETER PROTOTYPE:    INFILE    */
	       declare_name (residue_case);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-case"        ,\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"            ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Causes the case to be: kept:lower:upper."           ,\
			    /*Parameter*/ &residue_case         ,\
			    /*Def 1*/    "keep"            ,\
			    /*Def 2*/    "upper"             ,\
			    /*Min_value*/ "any"           ,\
			    /*Max Value*/ "any"            \
		   );

/*PARAMETER PROTOTYPE:    CPU     */
	       
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-cpu"        ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Makes it possible to add a pre-specified amount of cpu time to the measured usage"          ,\
			    /*Parameter*/ &extra_cpu    ,\
			    /*Def 1*/    "0"            ,\
			    /*Def 2*/    "0"            ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

/*PARAMETER PROTOTYPE:    MAXNSEQ     */
	       
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-maxnseq"        ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Maximum number of sequences (-1=no max)"          ,\
			    /*Parameter*/ &maxnseq    ,\
			    /*Def 1*/    "60"            ,\
			    /*Def 2*/    "0"            ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

/*PARAMETER PROTOTYPE:    MAXLEN     */
	       
	       get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-maxlen"        ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Maximum length of a sequence (-1=no max)"          ,\
			    /*Parameter*/ &maxlen    ,\
			    /*Def 1*/    "-1"            ,\
			    /*Def 2*/    "-1"            ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );


/*PARAMETER PROTOTYPE:    WEIGHT      */
	       declare_name ( weight);
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-weight"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Defines the library weight: sim OR  sim_(matrix)" ,\
			    /*Parameter*/ &weight          ,\
			    /*Def 1*/    "default"             ,\
			    /*Def 2*/    "sim"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );	  /*PARAMETER PROTOTYPE:    WEIGHT      */
	       declare_name ( seq_weight);
	       
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-seq_weight"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Defines the sequences weighting scheme t_coffee" ,\
			    /*Parameter*/ &seq_weight          ,\
			    /*Def 1*/    "t_coffee"             ,\
			    /*Def 2*/    "t_coffee"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );	    

/*PARAMETER PROTOTYPE:    DO ALIGN      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-align"        ,\
			    /*Flag*/      &do_align        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  0                ,\
			    /*DOC*/       "forces the program to make the alignment" ,\
			    /*Parameter*/ &do_align          ,\
			    /*Def 1*/     "1"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
/*PARAMETER PROTOTYPE:    DO DOMAIN      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-mocca"        ,\
			    /*Flag*/      &do_domain        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  0                ,\
			    /*DOC*/       "forces the program to extract domains" ,\
			    /*Parameter*/ &do_domain          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );  
	       if ( !do_domain)
		 {
/*PARAMETER PROTOTYPE:    DO DOMAIN      */
		   get_cl_param(				\
			    /*argc*/      argc             ,	\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-domain"        ,\
			    /*Flag*/      &do_domain        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  0                ,\
			    /*DOC*/       "forces the program to extract domains" ,\
			    /*Parameter*/ &do_domain          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
					  );  
		 }
/*PARAMETER PROTOTYPE:    Domain Param      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-start"        ,\
			    /*Flag*/      &domain_start        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "start of the master domain in the mocca mode" ,\
			    /*Parameter*/ &domain_start          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );  	     
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-len"        ,\
			    /*Flag*/      &domain_len        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "length of the master domain in the mocca mode" ,\
			    /*Parameter*/ &domain_len          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );

get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-scale"        ,\
			    /*Flag*/      &domain_scale        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Decreases the t_coffee score by Scale, so that non match get negative values" ,\
			    /*Parameter*/ &domain_scale          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-mocca_interactive"        ,\
			    /*Flag*/      &domain_interactive        ,\
			    /*TYPE*/      "FL"             ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  0                ,\
			    /*DOC*/       "Runs Mocca in an interactive manneer" ,\
			    /*Parameter*/ &domain_interactive,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );

 /*PARAMETER PROTOTYPE:    WEIGHT      */
	       declare_name (evaluate_mode);
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-evaluate_mode"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Mode used to produce the color output:t_coffee_fast,t_coffee_slow  " ,\
			    /*Parameter*/ &evaluate_mode          ,\
			    /*Def 1*/    "t_coffee_fast"             ,\
			    /*Def 2*/    "dali"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );	     
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-get_type"        ,\
			    /*Flag*/      &get_type        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "forces t_coffee top get the type of the sequences" ,\
			    /*Parameter*/ &get_type          ,\
			    /*Def 1*/    "0"             ,\
			    /*Def 2*/    "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \
		   );	     

get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-clean_aln"        ,\
			    /*Flag*/      &clean_aln        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Forces weak portion of aln to be realigned" ,\
			    /*Parameter*/ &clean_aln          ,\
			    /*Def 1*/    "0"             ,\
			    /*Def 2*/    "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \
		   );
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-clean_threshold"        ,\
			    /*Flag*/      &clean_threshold        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Threshold for the portions of the MSA that will are realigned by '-clean_evaluate_mode'. The threshold refers to the CORE score set by '-evaluate_mode'" ,\
			    /*Parameter*/ &clean_threshold          ,\
			    /*Def 1*/     "1"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-clean_iteration"        ,\
			    /*Flag*/      &clean_iteration        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Number of rounds for '-clean_aln'" ,\
			    /*Parameter*/ &clean_iteration          ,\
			    /*Def 1*/     "1"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
declare_name (clean_evaluate_mode);
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-clean_evaluate_mode"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Mode used to score residues (see evaluate_mode)" ,\
			    /*Parameter*/ &clean_evaluate_mode          ,\
			    /*Def 1*/    "t_coffee_fast"             ,\
			    /*Def 2*/    "t_coffee_fast"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );	    
profile=declare_char ( 2000, STRING);
n_profile=get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-profile"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  2000                ,\
			    /*DOC*/       "Input one or many MSA that will be treated as profiles" ,\
			    /*Parameter*/ profile          ,\
			    /*Def 1*/    ""             ,\
			    /*Def 2*/    ""             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );	    
declare_name (profile1);
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-profile1"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Input one profile (ClustalW option)" ,\
			    /*Parameter*/ &profile1          ,\
			    /*Def 1*/    ""             ,\
			    /*Def 2*/    ""             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
declare_name (profile2);
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-profile2"        ,\
			    /*Flag*/      &garbage        ,\
			    /*TYPE*/      "S"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Input a profile (ClustalW option)" ,\
			    /*Parameter*/ &profile2          ,\
			    /*Def 1*/    ""             ,\
			    /*Def 2*/    ""             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
/*PARAMETER PROTOTYPE:    DO EXTENDED MATRIX      */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-extend_matrix"        ,\
			    /*Flag*/      &do_extended_matrix        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  0                ,\
			    /*DOC*/       "Deprecated" ,\
			    /*Parameter*/ &do_extended_matrix          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );  
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-prot_min_sim"        ,\
			    /*Flag*/      &prot_min_sim        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Minimum similarity between a sequence and its PDB target" ,\
			    /*Parameter*/ &prot_min_sim          ,\
			    /*Def 1*/     "40"             ,\
			    /*Def 2*/     "40"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-prot_max_sim"        ,\
			    /*Flag*/      &prot_max_sim        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Maximum similarity between a sequence and its BLAST relatives" ,\
			    /*Parameter*/ &prot_max_sim          ,\
			    /*Def 1*/     "60"             ,\
			    /*Def 2*/     "100"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-prot_min_cov"        ,\
			    /*Flag*/      &prot_min_cov        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Minimum coverage of a sequence by its BLAST relatives" ,\
			    /*Parameter*/ &prot_min_cov          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "0"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-pdb_min_sim"        ,\
			    /*Flag*/      &pdb_min_sim        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Minimum similarity between a sequence and its PDB target" ,\
			    /*Parameter*/ &pdb_min_sim          ,\
			    /*Def 1*/     "30"             ,\
			    /*Def 2*/     "30"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-pdb_max_sim"        ,\
			    /*Flag*/      &pdb_max_sim        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Maximum similarity between a sequence and its PDB target" ,\
			    /*Parameter*/ &pdb_max_sim          ,\
			    /*Def 1*/     "100"             ,\
			    /*Def 2*/     "100"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-pdb_min_cov"        ,\
			    /*Flag*/      &pdb_min_cov        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Minimum coverage of a sequence by its PDB target" ,\
			    /*Parameter*/ &pdb_min_cov          ,\
			    /*Def 1*/     "50"             ,\
			    /*Def 2*/     "50"             ,\
			    /*Min_value*/ "any"            ,\
			    /*Max Value*/ "any"             \
		   );
declare_name (pdb_blast_server);
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-pdb_blast_server"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "ND"          ,\
			    /*Parameter*/&pdb_blast_server       ,\
			    /*Def 1*/    "SIB"      ,\
			    /*Def 2*/    "default"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
declare_name (prot_blast_server);
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-prot_blast_server"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "ND"          ,\
			    /*Parameter*/&prot_blast_server       ,\
			    /*Def 1*/    "SIB"      ,\
			    /*Def 2*/    "default"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
declare_name (pdb_db);
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-pdb_db"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Non Redundant PDB database"          ,\
			    /*Parameter*/&pdb_db       ,\
			    /*Def 1*/    "nrl3d"      ,\
			    /*Def 2*/    "default"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
declare_name (prot_db);
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-protein_db"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "ND"          ,\
 			    /*Parameter*/&prot_db       ,\
	 		    /*Def 1*/    "nr"      ,\
			    /*Def 2*/    "default"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

declare_name (method_log);
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-method_log"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "ND"          ,\
			    /*Parameter*/&method_log       ,\
			    /*Def 1*/    "no"      ,\
			    /*Def 2*/    "default"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
/*PARAMETER PROTOTYPE:        IN */
	struc_to_use=declare_char ( 200, STRING);
	n_struc_to_use=get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-struc_to_use"         ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"           ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  200           ,\
			    /*DOC*/       "Specifies the structures that must be used when combining sequences and structures. The default is to use all the structures."          ,\
			    /*Parameter*/ struc_to_use     ,\
			    /*Def 1*/    "",\
			    /*Def 2*/     "stdin"       ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

declare_name (cache);
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-cache"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Specifies that a cache must be used to save the structures and their comparison, as well as the blast searches.\navailable modes are: use,ignore,update,local, directory name"          ,\
			    /*Parameter*/ &cache       ,\
			    /*Def 1*/    "use"      ,\
			    /*Def 2*/    "update"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
declare_name (align_pdb_param_file);
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-align_pdb_param_file"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "parameter_file"          ,\
			    /*Parameter*/ &align_pdb_param_file       ,\
			    /*Def 1*/    "no"      ,\
			    /*Def 2*/    "no"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
declare_name (align_pdb_hasch_mode);
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-align_pdb_hasch_mode"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "W_F"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "parameter_file"          ,\
			    /*Parameter*/ &align_pdb_hasch_mode       ,\
			    /*Def 1*/    "hasch_ca_trace_bubble"      ,\
			    /*Def 2*/    "hasch_ca_trace_bubble"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
declare_name (msa_mode);
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-msa_mode"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Algorithm used to compute the MSA: tree | graph"          ,\
			    /*Parameter*/ &msa_mode      ,\
			    /*Def 1*/    "tree"      ,\
			    /*Def 2*/    "tree"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
 get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-lalign_n_top"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Number of local alignments reported by the local method (lalign) when building the library"          ,\
			    /*Parameter*/ &lalign_n_top      ,\
			    /*Def 1*/    "10"      ,\
			    /*Def 2*/    "10"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-iterate"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "NUmber of iteration on the progressive alignment [0: no iteration, -1: Nseq iterations]",\
			    /*Parameter*/ &iterate      ,\
			    /*Def 1*/    "0"      ,\
			    /*Def 2*/    "100"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-trim"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "trim dataset",\
			    /*Parameter*/ &trim      ,\
			    /*Def 1*/    "0"      ,\
			    /*Def 2*/    "1"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-split"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "split dataset",\
			    /*Parameter*/ &split      ,\
			    /*Def 1*/    "0"      ,\
			    /*Def 2*/    "1"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
declare_name(trimfile);
get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-trimfile"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "S"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "trim dataset filename",\
			    /*Parameter*/ &trimfile      ,\
			    /*Def 1*/    "default"      ,\
			    /*Def 2*/    ""      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-split"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "split dataset",\
			    /*Parameter*/ &split      ,\
			    /*Def 1*/    "0"      ,\
			    /*Def 2*/    "1"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

if (trim && !split)split=trim;

get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-split_nseq_thres"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Maximum Number of sequences within a subgroup",\
			    /*Parameter*/ &split_nseq_thres      ,\
			    /*Def 1*/    "0"      ,\
			    /*Def 2*/    "1"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-split_score_thres"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Minimum score within a split dataset",\
			    /*Parameter*/ &split_score_thres      ,\
			    /*Def 1*/    "0"      ,\
			    /*Def 2*/    "1"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );
get_cl_param(\
			    /*argc*/      argc          ,\
			    /*argv*/      argv          ,\
			    /*output*/    &le           ,\
			    /*Name*/      "-check_pdb_status"    ,\
			    /*Flag*/      &garbage      ,\
			    /*TYPE*/      "D"         ,\
			    /*OPTIONAL?*/ OPTIONAL      ,\
			    /*MAX Nval*/  1             ,\
			    /*DOC*/       "Reports the existance of a PDB file",\
			    /*Parameter*/ &check_pdb_status      ,\
			    /*Def 1*/    "0"      ,\
			    /*Def 2*/    "1"      ,\
			    /*Min_value*/ "any"         ,\
			    /*Max Value*/ "any"          \
		   );

/*PARAMETER PROTOTYPE:    SEQ TO ALIGN     */
	       seq_to_keep=declare_char ( 2000, STRING);
	       n_seq_to_keep=get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-seq_to_keep",\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"          ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  200              ,\
			    /*DOC*/       "File containing the name of the sequences to keep when triming OR a list of names)",\
			    /*Parameter*/ seq_to_keep   ,\
			    /*Def 1*/    "NULL"          ,\
			    /*Def 2*/    ""              ,\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );
/*******************************************************************************************************/	     
/*                                                                                                     */	      
/*                           TCoffee_dpa Parameter:START                                               */
/*                                                                                                     */	    
/*******************************************************************************************************/
/*PARAMETER PROTOTYPE:    dpa_master_aln     */
	       declare_name (dpa_master_aln);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-dpa_master_aln",\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"          ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Approximate Alignment: File|method",\
			    /*Parameter*/ &dpa_master_aln   ,\
			    /*Def 1*/    ""       ,\
			    /*Def 2*/    ""              ,\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );
	       /*PARAMETER PROTOTYPE:    dpa_maxnseq    */
	       
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-dpa_maxnseq",\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "D"          ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Maximum number of sequences to be aligned with DPA",\
			    /*Parameter*/ &dpa_maxnseq   ,\
			    /*Def 1*/    "10"       ,\
			    /*Def 2*/    "0"              ,\
			    /*Min_value*/ "any"          ,\
			    /*Max Value*/ "any"           \
		   );
/*PARAMETER PROTOTYPE:    dpa_min_score1    */
	       
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-dpa_min_score1",\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "D"          ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  200              ,\
			    /*DOC*/       "Minimum percent ID to merge sequences in the approximate alignment",\
			    /*Parameter*/ &dpa_min_score1   ,\
			    /*Def 1*/    ""       ,\
			    /*Def 2*/    ""              ,\
			    /*Min_value*/ "0"          ,\
			    /*Max Value*/ "100"           \
		   );	       
/*PARAMETER PROTOTYPE:    dpa_min_score2    */
	       
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-dpa_min_score2",\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "D"          ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  200              ,\
			    /*DOC*/       "Threshold for aligning a group in the slow double progressive alignment (automatically readjusted)",\
			    /*Parameter*/ &dpa_min_score2   ,\
			    /*Def 1*/    ""       ,\
			    /*Def 2*/    ""              ,\
			    /*Min_value*/ "0"          ,\
			    /*Max Value*/ "100"           \
		   );	       
/*PARAMETER PROTOTYPE:    dpa_keep_tmp_file     */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-dpa_keep_tmpfile"        ,\
			    /*Flag*/      &dpa_keep_tmpfile        ,\
			    /*TYPE*/      "FL"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "Prevents deletion of the tmpfile generated by t_coffee_dpa",\
			    /*Parameter*/ &do_version          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \

			    );
/*PARAMETER PROTOTYPE:    dpa_debug     */
	       get_cl_param(\
			    /*argc*/      argc             ,\
			    /*argv*/      argv             ,\
			    /*output*/    &le              ,\
			    /*Name*/      "-dpa_debug"        ,\
			    /*Flag*/      &dpa_debug        ,\
			    /*TYPE*/      "D"              ,\
			    /*OPTIONAL?*/ OPTIONAL         ,\
			    /*MAX Nval*/  1                ,\
			    /*DOC*/       "DEbug mode for DPA ( causes dpa tmp files to be kept)",\
			    /*Parameter*/ &do_version          ,\
			    /*Def 1*/     "0"             ,\
			    /*Def 2*/     "1"             ,\
			    /*Min_value*/ "0"            ,\
			    /*Max Value*/ "1"             \

			    );
	       	       
/*PARAMETER PROTOTYPE:    multi_thread    */
	       declare_name (multi_thread);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-multi_thread",\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"          ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "Instructs T-Coffee to run a multi_thread version. Argument can be a configuration file",\
			    /*Parameter*/ &multi_thread   ,\
			    /*Def 1*/    ""       ,\
			    /*Def 2*/    "default"              ,\
			    /*Min_value*/ "0"          ,\
			    /*Max Value*/ "100"           \
		   );	       
/*PARAMETER PROTOTYPE:    lib_list    */
	       declare_name (lib_list);
	       get_cl_param(\
			    /*argc*/      argc           ,\
			    /*argv*/      argv           ,\
			    /*output*/    &le            ,\
			    /*Name*/      "-lib_list",\
			    /*Flag*/      &garbage       ,\
			    /*TYPE*/      "S"          ,\
			    /*OPTIONAL?*/ OPTIONAL       ,\
			    /*MAX Nval*/  1              ,\
			    /*DOC*/       "A File that contains every pair/group of sequence to process when computing the lib, Format:<nseq> <index1><index2>",\
			    /*Parameter*/ &lib_list   ,\
			    /*Def 1*/    ""       ,\
			    /*Def 2*/    "default"              ,\
			    /*Min_value*/ "0"          ,\
			    /*Max Value*/ "100"           \
		   );	       
	       
/*******************************************************************************************************/	     
/*                                                                                                     */	      
/*                           TCoffee_dpa Parameter:END                                                 */
/*                                                                                                     */	    
/*******************************************************************************************************/
	       
	       if (argc==1 || name_is_in_list("-help", argv, argc, STRING)!=-1 ){exit (EXIT_SUCCESS);}
	       get_cl_param( argc, argv,&le, NULL,NULL,NULL,0,0,NULL);	     
	       prepare_cache (cache);	  

	       
/*******************************************************************************************************/	     
/*                                                                                                     */	      
/*                           FILL list_file (contains seq, aln and meth)                               */
/*                                                                                                     */	    
/*******************************************************************************************************/	     
   

/*Re-introduce the sequences introduced with -infile*/
/*Standard*/ 
               
	       if ( infile[0] && !do_evaluate)
		   {
		   sprintf ( list_file[n_list++], "%s",infile);		   
		   }
/*DO EVALUATE: The aln to evaluate must be provided via -infile*/	       
	       else  if (do_evaluate)
	           {
		     if (!infile[0] ||  !(main_read_aln ( infile, NULL)))
		       {
			 fprintf ( stderr,"\nERROR: When using -evaluate, Provide a multiple sequence alignment via the -infile flag [FATAL:%s]\n", PROGRAM);
			 exit (EXIT_FAILURE);
		       }
		     else if (! main_read_aln ( infile,NULL))
		       {
			 fprintf ( stderr,"\nERROR: FILE %s is NOT a valid alignment [FATAL:%s]\n", infile, PROGRAM);
			 exit (EXIT_FAILURE);
		       }
		     else if ( infile[0]=='A' ||infile[0]=='S')
		       {
			 sprintf ( list_file[n_list++], "S%s",infile+1);
		       }
		     else sprintf ( list_file[n_list++], "S%s",infile);
		   }

/*FETCH THE STRUCTURES INTRODUCED WITH -pdb and add them to -in*/
	       if ( n_pdb)
		 {
		   for ( a=0; a< n_pdb; a++)
		     {
		       if ( is_number (pdb_list[a]));
		       else
			 {
			 pdb_start=pdb_end=0;
			 if ( a+1< n_pdb && is_number (pdb_list[a+1]))pdb_start=atoi (pdb_list[a+1]);
			 if ( a+2< n_pdb && is_number (pdb_list[a+2]))pdb_end=atoi (pdb_list[a+2]);
			 
					 
			 pdb_name=get_pdb_struc ( pdb_list[a],pdb_start, pdb_end);
			 if (pdb_name){sprintf (list_file[n_list++], "P%s", pdb_name);vfree(pdb_name);}
			 }		     }
		 }
 
/*Make Sure -infile is set*/
	       if (!infile[0]&& (do_evaluate || do_convert))
		 {
		   
		   if ( do_evaluate || do_convert)sprintf ( infile, "%s",seq_list[0]); 
		 }

/*INTEGRATE THE PROFILES*/	 
	       
	       if ( profile1 && profile1[0])
		 {
		   sprintf ( list_file[n_list++], "R%s",profile1);
		 }
	       if ( profile2 && profile2[0])
		 {
		   sprintf ( list_file[n_list++], "R%s",profile2);
		 }
	       
	       for ( a=0; a< n_profile; a++)
		 {
		   FILE *fp;
		   if ( (fp=find_token_in_file (profile[a], NULL, "FILE_LIST"))!=NULL)
		     {
		       int z;
		       char rname[1000];
		       vfclose (fp);
		       fp=vfopen (profile[a], "r");
		       
		       while ( (z=fgetc(fp))!=EOF)
			 { 
			   ungetc(z, fp);
			   fscanf (fp, "%s\n", rname);
			   if ( check_file_exists(rname))sprintf ( list_file[n_list++], "R%s", rname);
			 }
		       vfclose (fp);
		     }
		   else 
		     {
		       sprintf ( list_file[n_list++], "R%s",profile[a]);
		     }
		 }
	       /*Introduce the sequences from the -seq flag*/
	       for (a=0; a<n_seq_list; a++)
		 {
		   sprintf (list_file[n_list++], "%s",seq_list[a]);
		 }

/*FILL THE F STRUCTURE (Contains Information for Output names For the defaults)*/	 	       
	       if (n_list==0 || argc<=1)
		 {
		   fprintf ( stderr, "\nERROR: You have NOT provided enough arguments [FATAL:%s]", PROGRAM);
		   exit (EXIT_FAILURE);
		 }
		  
	       else if ( run_name)F=parse_fname(run_name);
	       else if ( argv[1][0]!='-' && (check_file_exists( argv[1]) || check_file_exists(argv[1]+1)))
		 {
		   if (check_file_exists(argv[1]))F=parse_fname(argv[1]);
		   else if ( check_file_exists(argv[1]+1))F=parse_fname(argv[1]+1);
		   
		 }
	       else if (infile[0])
		 {
		   
		   if ( check_file_exists (infile))F=parse_fname(infile);
		   else if (check_file_exists (infile+1))F =parse_fname(infile+1);
		 }
	       else 
	          {

		  for ( a=0; a< n_list; a++)
		      {
			if (!is_method(list_file[a])) 
			  {
			      
			    
			     if ( check_file_exists( list_file[a])){F=parse_fname(list_file[a]);break;}			 
			     else if ( is_in_set ( list_file[a][0], "ASLXR") && check_file_exists( list_file[a]+1)){F=parse_fname(list_file[a]+1);break;}
			     else if ( is_in_set ( list_file[a][0], "P") && is_pdb_struc (list_file[a]+1))
			       {
				 F=parse_fname(is_pdb_struc (list_file[a]+1));break;
				 
			       }
			  }  
		      }
		
		  }
	       
	       
	       /*Get Structures*/
	       for ( a=0; a< n_list; a++)
		 {
		   if ( list_file[a][0]=='P' && !check_file_exists(list_file[a]))
		     {
		       char buf[1000];
		       sprintf(buf, "%s", list_file[a]+1);
		       sprintf(list_file[a], "P%s",is_pdb_struc (buf));
		     }
		 }

	       /*FATAL: NO SEQUENCES*/
	       if (!F)
		 {
		   fprintf ( stderr, "\nERROR: You have not provided any sequence [FATAL:%s]\n",PROGRAM);
		   exit (1);
		 }

	       if (!run_name)F->path[0]='\0';
	      
	      
	       identify_list_format      (list_file, n_list);
	      
	      
	       fprintf (le, "\nINPUT FILES\n");
	       for ( a=0; a< n_list; a++)
		   {
		     fprintf (le, "\tInput File (%c) %s ",list_file[a][0],list_file[a]+1); 
		     if ( list_file[a][0]=='A' || list_file[a][0]=='S' || list_file[a][0]=='P'|| list_file[a][0]=='R' ) 
		       {
			 fprintf (le, " Format %s\n", f=identify_seq_format ( list_file[a]+1));
			 vfree (f);
		       }
		     else fprintf (le, "\n");
		   }


/*SET GAP PENALTIES POSITIVE OR NEGATIVE: deprecated, gap penalties can take whtever values*/
	       /*
	       if (  maximise && (gop>0 || gep>0)){gop=(gop>0)?-gop:gop; gep=(gep>0)?-gep:gep;}
	       if ( !maximise && (gop<0 || gep<0)){gop=(gop<0)?-gop:gop; gep=(gep<0)?-gep:gep;}
	       if (  maximise && (f_gop>0 || f_gep>0)){f_gop=(f_gop>0)?-f_gop:f_gop; f_gep=(f_gep>0)?-f_gep:f_gep;}
	       if ( !maximise && (f_gop<0 || f_gep<0)){f_gop=(f_gop<0)?-f_gop:f_gop; f_gep=(f_gep<0)?-f_gep:f_gep;}
	       */



		            
/*CONVERT, ALIGN OR EVALUATE: CHOSE THE RIGHT VERB*/
	       /*Set the Hierarchy of the verbs*/
	       /*The first one decides...*/
	      
	       
	       do_list=vcalloc ( 100, sizeof (int*));
	       n_do=0;
	       do_list[n_do++]=&do_extended_matrix;
	       do_list[n_do++]=&do_convert;
	       do_list[n_do++]=&do_evaluate;
	       do_list[n_do++]=&do_domain;
	       do_list[n_do++]=&do_align;
	       

	       for ( a=0; a< n_do; a++)
		 {
		 if ( do_list[a][0])
		   {
		   for ( b=0; b< n_do; b++)if ( b!=a)do_list[b][0]=0;
		   break;
		   }
		 }


	    
/*SET THE DEFAULT NAMES*/
	       if ( do_convert)
	           {
		     if ( strm (tree_file, "default"))sprintf ( tree_file, "no");
		   }
	       
	     

	       if (  do_evaluate)
		   {
		   sprintf ( out_lib, "no");
		   sprintf ( tree_file, "no");
		   clean_aln=0;
		   }
 
     
	       if ( F && strm ( tree_file, "default"))sprintf ( tree_file ,"%s%s.dnd",F->path     ,F->name);

	       	       for (a=0; a< n_out_aln_format; a++)
			 {
			   if (is_out_format_list (out_aln_format[a]));
			   else
			     {
			       fprintf (stderr, "\n%s is not a valid format [FATAL:%s]\n", out_aln_format[a], PROGRAM);
			       exit (EXIT_FAILURE);
			     }
			 }
	       
	       if ( F && strm ( out_aln  , "default"))
	          {
		  for (a=0; a< n_out_aln_format; a++)
		      sprintf ( tot_out_aln[a]   ,"%s%s.%s"      ,F->path,F->name, (strm (out_aln_format[a], "gcg")?"msf":(strm(out_aln_format[a],"clustalw")?"aln":out_aln_format[a])));
		  }
	       else if (  n_out_aln_format==1)
		   sprintf ( tot_out_aln[0], "%s", out_aln);
	       else
	          {
		  for (a=0; a< n_out_aln_format; a++)
		      sprintf ( tot_out_aln[a]   ,"%s%s.%s", F->path  ,out_aln, (strm (out_aln_format[a], "gcg")?"msf":(strm(out_aln_format[a],"clustalw")?"aln":out_aln_format[a])));    
		  }
	       
	       if ( F && strm ( out_lib  , "default"))sprintf ( out_lib   ,"%s%s.tc_lib",F->path     , F->name);
	       if ( type && type[0])
	          {
		      if (strm2 (type,"Protein", "protein"))sprintf ( type, "PROTEIN");
		      if (strm2 (type,"DNA", "dna"))sprintf ( type, "DNA");
		      
		  }
	       

	       if (   !use_tree && check_file_exists (tree_file))vremove (tree_file);
	       else if ( !use_tree || (use_tree && strm (use_tree, "default")));
	       else sprintf ( tree_file, "%s", use_tree);
	       
/*******************************************************************************************************/	     
/*                                                                                                     */	      
/*                           Input Sequences and Library                                               */
/*                                                                                                     */	      
/*******************************************************************************************************/
	       
/*START*/
	       /*1 READ THE SEQUENCES*/
	       S=read_seq_in_n_list (list_file, n_list, type,seq_source);
	        S=seq2template_seq(S, "_S_self");
	       /* Get the Templates*/
	       if ( n_template_file)
		 {
		   fprintf ( le, "\nLooking For Sequence Templates:\n");
		   for ( a=0; a< n_template_file; a++)
		     {
		       fprintf ( le, "\n\tTemplate Type: [%s] Mode Or File: [%s] [Start", template_type2type_name(template_file_list[a]), template_file_list[a]);
		       S=seq2template_seq(S, template_file_list[a]);
		       fprintf ( le, "]");
		     }
		   if (seq2n_X_template ( S, "_R_"))
		     {
		       fprintf ( le, "\nLooking For Profile  Templates");
		       for ( a=0; a< n_template_file; a++)
			 {
			   fprintf ( le, "\n\tTemplate Type: [%s] Mode Or File: [%s] [Start", template_type2type_name(template_file_list[a]), template_file_list[a]);
			   S=profile_seq2template_seq(S, template_file_list[a]);
			   fprintf ( le, "]");
			 }
		     }
		   
		   if (seq2n_X_template ( S, "_*_"))sprintf (S->template_file, "%s",seq2template_file (S, NULL));
		 }
	       S=seq2template_type (S);
		 
	       
	       le=display_sequences_names   ( S, le, check_pdb_status, TEMPLATES);
	       	       
	       /*Switch to T-Coffee_dpa if there ara too Many_sequences*/
	       if ( maxnseq!=0 && S->nseq> maxnseq)
	          {
		    
		    if (dpa_maxnseq==0)
		      {
			
			fprintf( le, "\nTOO MANY SEQUENCES (%d Sequences while Max=%d) [FATAL:%S]\n", S->nseq,maxnseq, PROGRAM);
			exit (EXIT_FAILURE);
		      }
		    else
		      {
			char *command;
			Constraint_list *DPACL;
			
			DPACL=declare_constraint_list ( S,NULL, NULL, 0,(strm(mem_mode, "disk"))?tmpfile():NULL, NULL); 
			DPACL->local_stderr=le;
			command=t_coffee_command2dpa_command (argv, argc,DPACL, F->name);
			fprintf( le, "\nTOO MANY SEQUENCES (%d Sequences while Max=%d)\n\tAutomatic Switch to t_coffee_dpa\n%s\n", S->nseq, maxnseq, command);
			exit (my_system ( command));
		      }
		  }
	    
	       /*Abort if the sequences are too long */
	       if (maxlen!=-1 && S->max_len>maxlen)
		  {
		      fprintf ( stderr, "\nSEQUENCES TOO LONG [Longuest=%d][MAX=%d][FATAL:%s]\n", S->max_len,maxlen, PROGRAM);
		      exit (EXIT_FAILURE);
 
		  }

	       if ( get_type)
		 {
		   S=get_sequence_type (S);
		   fprintf ( stdout , "%s\n", S->type);
		   free_sequence(S, S->nseq);
		   return 1;
		 }

	       /*Reorder the sequences*/
	       new_order=duplicate_char (S->name, -1, -1);	       
	       new_order=sort_string_array   (new_order, S->nseq);

	       initial_order=duplicate_char (S->name, -1, -1);	
	       S=reorder_seq(S,new_order,S->nseq);
	       free_char (new_order, -1);

	       /*3 PREPARE THE CONSTRAINT LIST*/

	       CL=declare_constraint_list ( S,NULL, NULL, 0,(strm(mem_mode, "disk"))?tmpfile():NULL, NULL); 
	       CL->local_stderr=le;
	       if (  matrix && matrix[0])
		 {
		   sprintf ( CL->method_matrix,"%s", matrix);
		   /*sprintf ( list_file[n_list++], "X%s",matrix);*/
		 }
	       
	       /*Set the evaluation Functions*/
	       CL->profile_mode=get_profile_mode_function (profile_mode, NULL);
	       sprintf ( CL->profile_comparison, "%s", profile_comparison);
	       if ( n_struc_to_use)
		 {
		   CL->STRUC_LIST=declare_sequence (1,1,n_struc_to_use);
		   CL->STRUC_LIST->nseq=0;
		   for ( a=0; a< n_struc_to_use; a++)
		     {
		       
		       sprintf ( (CL->STRUC_LIST)->name[(CL->STRUC_LIST)->nseq++],"%s",struc_to_use[a]);
		     }
		 }
	       sprintf (CL->align_pdb_param_file, "%s", align_pdb_param_file);
	       sprintf (CL->align_pdb_hasch_mode, "%s", align_pdb_hasch_mode);
	       
	       /*Blast Parameters*/
	       (CL->Prot_Blast)->min_id=prot_min_sim;
	       (CL->Prot_Blast)->max_id=prot_max_sim;
	       (CL->Prot_Blast)->min_cov=prot_min_cov;	       
	       sprintf ( (CL->Prot_Blast)->blast_server, "%s", prot_blast_server);
	       sprintf ( (CL->Prot_Blast)->db, "%s", prot_db);
	       
	       (CL->Pdb_Blast)->min_id=pdb_min_sim;
	       (CL->Pdb_Blast)->max_id=pdb_max_sim;
	       (CL->Pdb_Blast)->min_cov=pdb_min_cov;	       
	       sprintf ( (CL->Pdb_Blast)->blast_server, "%s", pdb_blast_server);
	       sprintf ( (CL->Pdb_Blast)->db, "%s", pdb_db);
	       CL->check_pdb_status=check_pdb_status;
	       /*split parameters */
	       CL->split=split;
	       CL->split_nseq_thres=split_nseq_thres;
	       CL->split_score_thres=split_score_thres;
	       /*Blast Parameters
	       (CL->DNA_Blast)->min_id=dna_min_sim;
	       (CL->DNA_Blast)->max_id=dna_max_sim;
	       (CL->DNA_Blast)->min_cov=dna_min_cov;	       
	       sprintf ( (CL->DNA_Blast)->blast_server, "%s", dna_blast_server);
	       sprintf ( (CL->DNA_Blast)->db, "%s", dna_db);
	       */
	     
	       if ( method_log)
		 {
		   if ( strm (method_log, "default"))
		     {
		       sprintf ( CL->method_log, "%s%s.method_log",F->path, F->name);
		     }
		   else if ( !strm (method_log, "no"))
		     {
		      sprintf ( CL->method_log, "%s", method_log);
		     }
		 }
	       

	       CL->lalign_n_top=lalign_n_top;
	       sprintf ( CL->multi_thread, "%s", multi_thread);
	       sprintf ( CL->lib_list, "%s", lib_list);
	       
/* Important: This is where the library is compiled!!!!*/
	       if ((CL->S)->nseq>1 && !do_convert)CL=read_n_constraint_list (list_file,n_list,NULL, mem_mode,weight,type, le, CL, seq_source);   	     
	       else if ( do_convert && out_lib[0])
		 {
		   if ( infile[0])
		     {sprintf (list_file[0], "%s", name2type_name(infile));
		     CL=read_n_constraint_list (list_file,1,NULL, mem_mode,weight,type, le, CL, seq_source);   
		     }
		   else
		     {
		     CL=read_n_constraint_list (list_file,n_list,NULL, mem_mode,weight,type, le, CL, seq_source);   	     
		     }
		 }
	       if ( CL->M)clean_aln=0;



	       /*If the List is empty*/
	       if ( (CL->S)->nseq>1 && CL->ne==0 && !CL->M &&!(do_convert && n_list>0))
		 {
		   fprintf ( stderr, "\n******************ERROR*****************************************\n");
		   
		   fprintf ( stderr, "\nYou have not provided any method or enough Sequences[FATAL]");
		   fprintf ( stderr, "\nIf you have used the '-in' Flag, ADD the methods you wish to use:");
		   fprintf ( stderr, "\n\t-in <your sequences> Mlalign_id_pair Mfast_pair\n");
		   fprintf ( stderr, "\nAnd make sure you provide at least TWO sequences\n");	
		   for ( a=0; a< argc; a++)fprintf ( stderr, "%s ", argv[a]);
		   fprintf ( stderr, "\n*****************************************************************\n");
		   exit(EXIT_FAILURE);
		 }

	       CL->normalise=do_normalise;
 
	       if ( type && type[0])sprintf ( (CL->S)->type, "%s", type); 
	       CL->extend_jit=(do_extend>0)?1:0;
	       
	       CL->extend_threshold=(do_extend==1)?0:do_extend;
	       CL->do_self=do_self;
	       sprintf (CL->extend_clean_mode,   "%s", clean_mode);
	       sprintf (CL->extend_compact_mode, "%s", compact_mode);
	       if ( CL->extend_jit && CL->extend_threshold !=0)filter_list (CL,0, CL->ne, CL->extend_threshold); 	       
	       CL->pw_parameters_set=1;



	       CL->nomatch=nomatch;

	       /*Gep and Gop*/
	       if ( !gep &&  !gop && CL->M)
		   {
		    CL->gop=get_avg_matrix_mm ( CL->M, (strm3((CL->S)->type,"PROTEIN", "Protein", "protein")?AA_ALPHABET:"gcuta"))*10;
		    CL->gep=CL->gop/10;
		    fprintf ( CL->local_stderr, "\nAUTOMATIC PENALTIES: gapopen=%d gapext=%d", CL->gop, CL->gep);
		   }
	       else if ( !CL->M && cosmetic_penalty && !gep && !gop)
	           {
		    CL->gep=0;
		    CL->gop=cosmetic_penalty;
		   }
	       else
	           {
		     CL->gep=gep;
		     CL->gop=gop;
		   }
	       
	       /*Frame Penalties*/
	       CL->f_gep=f_gep;
	       CL->f_gop=f_gop;

	       
	       CL->maximise=maximise;
	       if (strm((CL->S)->type,"DNA") )
		   CL->ktup=MAX(2,ktup);
	       else
		   CL->ktup=ktup;
	       
	       CL->use_fragments=diag_mode;
	       CL->fasta_step=fasta_step;
	       CL->diagonal_threshold=diag_threshold;
	       
	       sprintf ( CL->matrix_for_aa_group, "%s", sim_matrix);
	       sprintf ( CL->dp_mode, "%s", dp_mode);
	       CL->TG_MODE=tg_mode;
	       	     
	       sprintf ( CL->evaluate_mode, "%s", evaluate_mode);
	       
	      fprintf (le, "\n\n\tLibrary Total Size: [%d]\n", CL->ne); 
	       
	      
	      if (CL->ne>0 && out_lib[0]!='\0' && !strm (out_lib, "no"))
	         {
		   
		    OUT=save_constraint_list ( CL, 0, CL->ne, out_lib, NULL, "ascii",CL->S);
		    vfclose (OUT);
		    CL->local_stderr=display_output_filename (le, "TCLIB","tc_lib_format_01",out_lib, CHECK);		   
		 }
	      if ( lib_only)exit (EXIT_SUCCESS);
	      
	      CL=choose_extension_mode (extend_mode, CL);
	      CL->max_n_pair=max_n_pair;
	      
	      sprintf ( CL->tree_mode, "%s", tree_mode);
	      /*WEIGHT CONSTRAINT LIST*/

	    
	      if ( !do_convert)
		{
		 
		  CL->similarity_matrix=get_constraint_list_similarity_matrix (CL);
		  CL=weight_constraint_list(CL, seq_weight);
		  if (output_seq_weights (CL->W, outseqweight))
		    CL->local_stderr=display_output_filename( CL->local_stderr,"WEIGHT","tc_weight",outseqweight, CHECK);
		  le=display_weights(CL->W, le);
		}
	    
	     
	      /*Prepare quadruplets*/
	      if ( nseq_for_quadruplet && !strm(seq_name_for_quadruplet[0], "all"))
		{
		  CL->nseq_for_quadruplet=nseq_for_quadruplet;
		  CL->seq_for_quadruplet=vcalloc ((CL->S)->nseq, sizeof (int));
		  for (a=0; a< CL->nseq_for_quadruplet; a++)
		    {
		      printf ( "\nquad: %s", seq_name_for_quadruplet[a]);
		      if ( (b=name_is_in_list (seq_name_for_quadruplet[a],(CL->S)->name,(CL->S)->nseq, 100))!=-1)CL->seq_for_quadruplet[b]=1;
		      else fprintf ( stderr, "\nWarning: Sequence %s is not in the set and cannot be used for quadruplet extension\n",seq_name_for_quadruplet[a]); 
		    }
		}
	      else if ( nseq_for_quadruplet && strm(seq_name_for_quadruplet[0], "all"))
		{
		  
		  CL->nseq_for_quadruplet=(CL->S)->nseq;
		  CL->seq_for_quadruplet=vcalloc ((CL->S)->nseq, sizeof (int));
		  for (a=0; a< CL->nseq_for_quadruplet; a++)
		    {
		      CL->seq_for_quadruplet[a]=1;
		    }
		}

/*******************************************************************************************************/	     
/*                                                                                                     */	      
/*                           Prepare The Alignment                                                     */
/*                                                                                                     */	      
/*******************************************************************************************************/
	     
	      if ( do_align )
		   {
		   A=seq2aln  ((CL->S),NULL,1);
		   ungap_array(A->seq_al,A->nseq);		   
		   
		   /*Chose the right Mode for evaluating Columns*/
		   
		   if ( A->nseq==1);
		   else if ( strm ( msa_mode, "graph"))
			{
			  fprintf ( stderr, "\nDO GRAPH ALIGNMENT");
			  A=graph_aln ( A, CL, (CL->S));
			} 
		   else if ( strm ( msa_mode, "tsp"))
			{
			  fprintf ( stderr, "\nDO TSP ALIGNMENT");
			  A=tsp_aln ( A, CL, (CL->S));
			}
		   else if ( strm ( msa_mode, "precomputed"))
		     {
		       if (infile[0]) {free_aln (A);A=main_read_aln ( infile, declare_aln(CL->S));}
		       else{fprintf ( stderr, "\nERROR: tree_mode=aln requires an aln passed via the -infile flag [FATAL:%s]", PROGRAM);crash ("");}
		       
		       sprintf ( CL->dp_mode, "precomputed_pair_wise");
		       sprintf ( CL->tree_mode, "aln");
		       CL->tree_aln=A=reorder_aln ( A, (CL->S)->name,(CL->S)->nseq);
		       
		       pc=tree_file;
		       if ( strm (tree_file, "default") || !check_file_exists (tree_file))
			 T=make_tree ( A,CL,gop, gep,(CL->S),pc, tree_mode, maximise);	      
		       else if ( strm (tree_file, "no"))
			 T=make_tree ( A,CL,gop, gep,(CL->S),NULL, tree_mode, maximise);
		       else
			 {
			   T=read_tree (pc,&tot_node,(CL->S)->nseq,  (CL->S)->name);
			 }
		       
		       SNL=tree_aln ((T[3][0])->left,(T[3][0])->right,A,(CL->S)->nseq, CL);
		     }
		   else if ( strm ( msa_mode, "tree"))
		     {
		       if ( strm (CL->tree_mode, "aln"))
			 {
			   if (infile[0]) {free_aln (A);A=main_read_aln ( infile, declare_aln(CL->S));}
			   else{fprintf ( stderr, "\nERROR: tree_mode=aln requires an aln passed via the -infile flag [FATAL:%s]", PROGRAM);crash ("");}
			   CL->tree_aln=A;
			 }
		       if ( (CL->S)->nseq>2)
			 {	      
			   pc=tree_file;
			   if ( strm (tree_file, "default") || !check_file_exists (tree_file))
			     T=make_tree ( A,CL,gop, gep,(CL->S),pc, tree_mode, maximise);	      
			   else if ( strm (tree_file, "no"))
			     T=make_tree ( A,CL,gop, gep,(CL->S),NULL, tree_mode, maximise);
			   else
			     {
			       fprintf ( le, "\nREAD PRECOMPUTED TREE: %s\n", pc);
			       T=read_tree (pc,&tot_node,(CL->S)->nseq,  (CL->S)->name);
			     }
			   
			   SNL=tree_aln ((T[3][0])->left,(T[3][0])->right,A,(CL->S)->nseq, CL);
			 }
		       else
			 {
			   tree_aln (NULL,NULL,A, (CL->S)->nseq,CL);
			 }
		       
		       A->nseq=(CL->S)->nseq;
		     }
		   else
		     {
		       fprintf ( stderr, "\nERROR: msa_mode %s is unknown [%s:FATAL]\n", msa_mode, PROGRAM);
		       crash ("");
		     }
		     
		   }
	       else if ( (do_evaluate || do_convert))
	           {

		
		   A=(infile[0])?main_read_aln ( infile, declare_aln(CL->S)):NULL;
		   
		   if (!A)A=seq2aln((CL->S), NULL,0);
		   
		   
		   A->S=CL->S;		  
		   A->nseq=(CL->S)->nseq;
		  
		   
		   }
	      
	      
	      else if (do_domain)
		   {
		     CL->moca=vcalloc ( 1, sizeof ( Moca));
		     if (strm ( "cfasta_pair_wise", dp_mode))sprintf (CL->dp_mode, "%s","domain_pair_wise"); 
		     (CL->moca)->moca_start=domain_start;
		     (CL->moca)->moca_len  =domain_len;
		     (CL->moca)->moca_scale=(domain_scale==0)?-(CL->normalise/20):domain_scale;
		     (CL->moca)->moca_interactive=domain_interactive;
		     


		     if (!cosmetic_penalty && !gep && !gop)
		       {
			 CL->gop=-200;
			 CL->gep=-100;
		       }

		     CL=prepare_cl_for_moca (CL);
		     aln_list=moca_aln (CL);
		     free_int ( CL->packed_seq_lu, -1);
		     CL->packed_seq_lu=NULL;

		     a=0;
		     while ( aln_list[a])
		       {			 
		       for ( b=0; b< n_out_aln_format; b++)
			  {			    

			    output_format_aln (out_aln_format[b],aln_list[a],EA=fast_coffee_evaluate_output(aln_list[a], CL), tot_out_aln[b]);
			    le=display_output_filename( le,"MSA",out_aln_format[b], tot_out_aln[b], CHECK);
			  }
		       a++;
		       }
		   exit (EXIT_SUCCESS);
		   }
	      else if ( do_extended_matrix)
		{
		  A=seq2aln(CL->S, NULL, 1);
		  A->CL=CL;
		  for ( a=0; a< n_out_aln_format; a++)
		    {
		      output_format_aln (out_aln_format[a],A,EA, tot_out_aln[a]);
		      le=display_output_filename( le,"MSA",out_aln_format[a], tot_out_aln[a], CHECK);
		    }

		  exit (EXIT_SUCCESS);
		}


/*******************************************************************************************************/	     
/*                                                                                                     */	      
/*                           PREPARE THE ALIGNMENT FOR OUTPUT                                          */
/*                                                                                                     */	      
/*******************************************************************************************************/
	      if (A)
	          {
		    /*
		    for ( a=0; a< A->nseq; a++)
		      {
			   for ( b=0; b< A->len_aln ; b++)
			     if ( A->seq_al[a][b]=='O' || A->seq_al[a][b]=='o')A->seq_al[a][b]='-';
			 }
		    */

		      A=reorder_aln ( A, (CL->S)->name,(CL->S)->nseq);      
		      		      
		      if (getenv ("DEBUG_TCOFFEE"))print_aln (A);
		      
		      if ( check_file_exists(outorder))
			{
			  Sequence *OS;
			  OS=get_fasta_sequence (outorder, NULL);
			  if ( prf_in_seq (CL->S))A->expanded_order=OS->name;
			  else A=reorder_aln ( A,OS->name,A->nseq);
			}
		      else if ( strm(outorder, "aligned") && T)
			{
			  A=reorder_aln ( A,A->tree_order,A->nseq);
			 
			}
		      else 
			{ 
			  
			  A=reorder_aln ( A, (CL->S)->name,(CL->S)->nseq);  
			  A=reorder_aln ( A, initial_order,(CL->S)->nseq);  
			 
			}

		     
		      A->output_res_num=strm3 ( output_res_num, "on", "On", "ON");
		      
		      if ( strm2 (residue_case, "keep", "retain"))A->residue_case=2;
		      else if (strm3 (residue_case, "upper", "Upper", "UPPER"))A->residue_case=0;
		      else if (strm3 (residue_case, "lower", "Lower", "LOWER"))A->residue_case=1;
		      else A->residue_case=1;

		      
		      if ( clean_aln)
			{
			  EA=main_coffee_evaluate_output(A, CL,clean_evaluate_mode);			  
			  A=clean_maln(A, EA,clean_threshold,clean_iteration);
			  free_aln (EA);
			  A=ungap_aln(A);
			}
		      
		      if ( iterate)
			{
			  A=iterate_aln (A, iterate, CL);
			  A=ungap_aln(A);
			}


		      EA=main_coffee_evaluate_output(A, CL, evaluate_mode);

		      

		      for ( a=0; a< n_out_aln_format; a++)
			  output_format_aln (out_aln_format[a],A,EA, tot_out_aln[a]);
		      
		      if (!strm2(out_aln, "stdout", "stderr") && le==stderr && !do_convert)output_format_aln ("t_coffee_aln",A,NULL,"stdout");
		      
		      fprintf (le, "\n\nOUTPUT RESULTS");
		      le=display_output_filename (le, "TREE","newik", tree_file, CHECK);
		      
		      for ( a=0; a< n_out_aln_format; a++)
			le=display_output_filename( le,"MSA",out_aln_format[a], tot_out_aln[a], CHECK);
		  }

	      if (split)
		{ 

		  if (trim && n_seq_to_keep) 
		    {
		      if (n_seq_to_keep==1 && check_file_exists (seq_to_keep[0]))
			{
			  
			  SEQ_TO_KEEP=read_sequences (seq_to_keep[0]);
			}
		      else
			{
			  
			  SEQ_TO_KEEP=declare_sequence ( 1, 1,n_seq_to_keep);
			  for ( a=0; a< n_seq_to_keep; a++)sprintf ( SEQ_TO_KEEP->name[a], "%s", seq_to_keep[a]);
			}
		    }
		  
		  sprintf ( CL->dp_mode, "precomputed_pair_wise");
		  sprintf ( CL->tree_mode, "aln");
		  

		 
		  CL->tree_aln=A=reorder_aln ( A, (CL->S)->name,(CL->S)->nseq);
		  CL->S=aln2seq ( A);
		  
		  if (!T)
		    {
		      
		      pc=tree_file;
		      if ( strm (tree_file, "default") || !check_file_exists (tree_file))
			T=make_tree ( A,CL,gop, gep,(CL->S),pc, tree_mode, maximise);	      
		      else if ( strm (tree_file, "no"))
			T=make_tree ( A,CL,gop, gep,(CL->S),NULL, tree_mode, maximise);
		      else
			T=read_tree (pc,&tot_node,(CL->S)->nseq,  (CL->S)->name);
		      
		    }
		  
		  SNL=tree_aln ((T[3][0])->left,(T[3][0])->right,A,(CL->S)->nseq, CL);
		  
		 
		  for ( a=0, b=0; a<A->nseq; a++)b+=(SNL[a])?1:0;
		  fprintf ( le, "\n\nSPLIT DATASET: %d Groups\n", b);
		  /*Display Group Names*/
		  
		  if ( trim && SEQ_TO_KEEP)
		    {
		      for ( a=0; a< SEQ_TO_KEEP->nseq; a++)
			{
			  
			  trim_subS=extract_one_seq(SEQ_TO_KEEP->name[a],0,0,A,KEEP_NAME);
			  trim_S=add_sequence (trim_subS,trim_S,0);
			}
		    }
		  for ( a=0, b=0; a<A->nseq; a++)
		    {
		      
		      if ( SNL[a])
			{
			  b++;
			  fprintf ( le, "\n\tSPLIT_GROUP %d ; Nseq %d ; Score %d ; List ",b, (SNL[a])->nseq, (int)(SNL[a])->score);
			  for ( c=0; c< (SNL[a])->nseq; c++)
			    {
			      fprintf ( le, "%s ",(CL->S)->name[(SNL[a])->lseq[c]]);
			    }

			  SPLIT_ALN=extract_sub_aln (A, (SNL[a])->nseq,(SNL[a])->lseq);
			  SPLIT_ALN->S=A->S;
			  ungap_aln (SPLIT_ALN);
			  
			  if (!trim)
			    {
			      sprintf ( split_format, "%s", "clustalw");
			      sprintf ( split_name, "%s.split.%d.%s", F->name, b,split_format);
			      fprintf ( le, " ; File %s",  split_name);
			      output_format_aln (split_format,SPLIT_ALN,NULL,split_name);
			      le=display_output_filename( le,"SPLIT_SEQ",split_format,split_name, CHECK); 
			    }
			  else if (trim)
			    {
			      t=aln2most_similar_sequence(SPLIT_ALN, "idmat");
			      trim_subS=extract_one_seq(SPLIT_ALN->name[t],0,0,SPLIT_ALN,KEEP_NAME);
			      trim_S=add_sequence (trim_subS,trim_S,0);
			      fprintf ( le, "\n\tTRIM_SEQ: Kept sequence %s",SPLIT_ALN->name[t]); 
			    }
			  free_aln (SPLIT_ALN);
			  fprintf (le, "\n");
			}
		    }

		  if (trim)
		      {
			
			
		       SPLIT_ALN=seq2aln (trim_S,NULL, KEEP_GAP);
		       ungap_aln (SPLIT_ALN);
		       sprintf ( trim_format, "%s", "fasta_aln");
		       if ( strm (trimfile, "default"))sprintf ( trimfile, "%s.trim.%s", F->name,trim_format);
		       
		       output_format_aln (trim_format,SPLIT_ALN,NULL,trimfile);
		       le=display_output_filename( le,"TRIM_SEQ",trim_format,trimfile, CHECK); 
		      } 
		}		      
	      
		
	
	      
		      
	fprintf (le, "\n\n"); 
		
	free_char (list_file, -1); 	
	free_Alignment (A); 		
	free_Alignment (EA); 		
	
	S=free_constraint_list (CL);
	free_sequence (S, S->nseq);
	vremove ( "core");
	
	vfree_all();
	le=print_mem_usage (le, PROGRAM);
	le=print_cpu_usage(le, PROGRAM);
	if (full_log && full_log[0])log_function(full_log);
	
	exit (EXIT_SUCCESS);
	}

/*Specialized set of Parameters*/
char *get_precomputed_defaults(char *buf)
   {
     
     if (buf==NULL)buf=vcalloc (1000, sizeof (char));
     
     buf=strcat (buf," -msa_mode=precomputed ");
     buf=strcat (buf," -seq_weight=no ");
     buf=strcat (buf," -evaluate_mode no ");
     buf=strcat (buf," -in Xpam250mt ");
     return buf;
   }
char *get_evaluate_defaults(char *buf)
   {
     
     if (buf==NULL)buf=vcalloc (1000, sizeof (char));

     buf=strcat (buf," -quiet=stdout ");
     /*buf=strcat (buf," -seq_weight=no ");*/
     buf=strcat (buf," -output score_ascii score_html ");
     buf=strcat (buf," -iterate 0 ");
     
     buf=strcat (buf," -evaluate ");
     
    
     
     return buf;
   }
char *get_genome_defaults(char *buf)
   {
     
     if (buf==NULL)buf=vcalloc (1000, sizeof (char));
    
     buf=strcat (buf," -seq_weight=no ");
     buf=strcat (buf," -dp_mode sim_pair_wise_lalign ");
     buf=strcat (buf," -output glalign ");
     buf=strcat (buf," -iterate 0 ");
     buf=strcat (buf," -tree_mode ktup ");
     buf=strcat (buf," -evaluate_mode t_coffee_slow "); 
     buf=strcat (buf," -gapopen 100 -gapext 20 -nomatch 30 ");
     buf=strcat (buf," -clean_aln 0 ");
     buf=strcat (buf,"-output clustalw,score_ascii ");
    
     
     return buf;
   }
char *get_dali_defaults(char *buf)
   {
     
     if (buf==NULL)buf=vcalloc (1000, sizeof (char));

     buf=strcat (buf,"-cosmetic_penalty=-50 ");
     buf=strcat (buf,"-tree_mode=slow ");
     buf=strcat (buf,"-output clustalw,score_ascii ");
     buf=strcat (buf,"-evaluate_mode=non_extended_t_coffee ");
     buf=strcat (buf,"-clean_aln 0 ");
     
     return buf;
   }

char *get_very_fast_defaults(char *buf)
   {
     if (buf==NULL)buf=vcalloc (1000, sizeof (char));
     
     buf=strcat (buf,"-in Xblosum62mt ");
     buf=strcat (buf,"-tree_mode geometric ");
     buf=strcat (buf,"-ktuple 3 ");
     buf=strcat (buf,"-dp_mode very_fast_pair_wise ");
     buf=strcat (buf,"-extend_mode fast_matrix ");
     buf=strcat (buf,"-gapopen -16 ");
     buf=strcat (buf,"-gapext -1 ");
     buf=strcat (buf,"-iterate 0 ");
     buf=strcat (buf,"-in ");

     return buf;
   }
char *get_low_memory_defaults(char *buf)
   {
     if (buf==NULL)buf=vcalloc (1000, sizeof (char));
     
     buf=strcat (buf,"-in=Mslow_pair,Mlalign_id_pair -tree_mode=slow -dp_mode=myers_miller_pair_wise ");
     buf=strcat (buf,"-in ");

     return buf;
   }

char *get_3dcoffee_defaults(char *buf)
   {
    
     if (buf==NULL)buf=vcalloc (1000, sizeof (char));
     
     buf=strcat (buf,"-in slow_pair sap_pair fugue_pair -template_file _P_self ");
     buf=strcat (buf,"-in ");

     return buf;
   }

char *get_repeat_defaults(char *buf)
   {
    
     if (buf==NULL)buf=vcalloc (1000, sizeof (char));
     
     buf=strcat (buf,"-in slow_pair -matrix idmat -out_lib -profile_comparison profile -profile_mode channel_profile_profile -dp_mode myers_miller_pair_wise ");
     buf=strcat (buf,"-in ");
     return buf;
   }


int check_configuration4program()
   {
     int a=0;
     
     a+=1-check_program_is_installed ( "blastall.remote"       ,SIB_BLAST_4_TCOFFEE,    "SIB_BLAST_4_TCOFFEE"   ,"not public"                                    ,IS_NOT_FATAL);
     a+=1-check_program_is_installed ( "blastcl3"              ,NCBI_BLAST_4_TCOFFEE,   "NCBI_BLAST_4_TCOFFEE"  ,"ftp://ftp.ncbi.nih.gov/blast/network/netblast/",IS_NOT_FATAL);
     a+=1-check_program_is_installed ( "blastall"              ,LOCAL_BLAST_4_TCOFFEE,  "LOCAL_BLAST_4_TCOFFEE" ,"ftp://ftp.ncbi.nih.gov/blast/"                 ,IS_NOT_FATAL);
     a+=1-check_program_is_installed ( "fugue_client"          ,FUGUE_4_TCOFFEE,        "FUGUE_4_TCOFFEE"       ,"not public"                                    ,IS_NOT_FATAL);
     a+=1-check_program_is_installed ( "lalign2list"           ,LALIGN_4_TCOFFEE,       "LALIGN_4_TCOFFEE"      ,MAIL                                            ,IS_NOT_FATAL);
     a+=1-check_program_is_installed ( "clustalw"              ,CLUSTALW_4_TCOFFEE,     "CLUSTALW_4_TCOFFEE"    ,"ftp://www.ebi.ac.uk"                           ,IS_NOT_FATAL);     
     a+=1-check_program_is_installed ( "sap"                   ,SAP_4_TCOFFEE,          "SAP_4_TCOFFEE"         ,MAIL                                            ,IS_NOT_FATAL);     
     
     a+=1-check_program_is_installed ( "ps2pdf"                ,PS2PDF,                     "PS2PDF"                    ,"unknown", IS_NOT_FATAL);  
     a+=1-check_program_is_installed ( "wget"                  ,WGET             , "WGET"             ,"wget.sunsite.dk", IS_NOT_FATAL);
     
     fprintf ( stderr, "\nInformation: you can generate this verification using the -check_configuration flag");

     return a;
     
   }

/*Chose the right Mode for comparing residues*/

void test ()
{
  char command[1000];
  char *c2;
  
  c2=vcalloc ( 100, sizeof (char));

  sprintf (command, "cat hmgt_mouseVsnrl3d.blast_result |blast_aln2fasta_aln.pl | fasta_aln2fasta_aln_unique_name.pl > my_test");
  
  fprintf ( stderr, "C1: %d, C2:%d", is_dynamic_memory (c2), is_dynamic_memory (c2));
  
  
  exit (0);
}

int run_other_pg ( int argc, char *argv[])
{
  if ( strm (argv[0], "seq_reformat"))
    {
      return seq_reformat (argc, argv);
    }
  else if ( strm (argv[0], "aln_compare"))
    {
      return aln_compare (argc, argv);
    }
  else if ( strstr ( argv[0], "unpack_"))
    {
      unpack_all_perl_script (argv[0]+strlen ("unpack_"));
    }
  else
    {
      return my_system_cl (argc, argv);
    }
  return EXIT_FAILURE;
}

char *t_coffee_command2dpa_command ( char **argv, int argc, struct Constraint_list *CL, char*run_name)
{
  char *command;
  char subcommand[1000];
  Alignment *BUFA;
  Sequence *S;
  char *full_sequences;
  int a, x;
  int run_name_set=0;
  
  S=CL->S;
  
  command=vcalloc ( argc*100, sizeof (char));
  sprintf ( command, "t_coffee_dpa ");
  output_fasta_seq ( full_sequences=vtmpnam (NULL), BUFA=seq2aln (S, NULL, RM_GAP));
  free_aln (BUFA);
  
  for (x=1; x<argc; x++)
    {
      subcommand[0]='\0';
      if ( strstr (argv[x],"-run_name"))run_name_set=1;
      
      if ( strstr (argv[x], "-seq"))
	{
	  sprintf ( subcommand, " %s %s ", argv[x], full_sequences);
	}
      else
	{
	  sprintf ( subcommand, " %s ", argv[x]);
	}
      
      strcat ( command, subcommand);
    }
  
  sprintf ( subcommand, " -seq_source _LA ");
  strcat ( command, subcommand);
  
  if ( !run_name_set)
    {
      sprintf ( subcommand, " -run_name %s", run_name);
      strcat ( command, subcommand);
    }
  
  return command;
}
/*********************************COPYRIGHT NOTICE**********************************/
/* Centre National de la Recherche Scientifique (CNRS) */
/*and */
/*Cedric Notredame */
/*Tue May 10 12:08:44     2005. */
/*All rights reserved.*/
/*This file is part of T-COFFEE.*/
/**/
/*    T-COFFEE is free software; you can redistribute it and/or modify*/
/*    it under the terms of the GNU General Public License as published by*/
/*    the Free Software Foundation; either version 2 of the License, or*/
/*    (at your option) any later version.*/
/**/
/*    T-COFFEE is distributed in the hope that it will be useful,*/
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*    GNU General Public License for more details.*/
/**/
/*    You should have received a copy of the GNU General Public License*/
/*    along with Foobar; if not, write to the Free Software*/
/*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/
/*...............................................                                                                                      |*/
/*  If you need some more information*/
/*  cedric.notredame@europe.com*/
/*...............................................                                                                                                                                     |*/
/**/
/**/
/*	*/
/*********************************COPYRIGHT NOTICE**********************************/
