C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE CFLUVS
C                       *****************
C
C      ----------------------------------------------------------
     * (NDIM,NPOINS,COORDS,NREFS,NREFE,NELEMS,NODES,NDMATS,
     *  TMPSA,TMPS,NBFLVS,NPFEL,NFLUVS,VFLUVS)
C      ----------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ENTREE DE FLUX VOLUMIQUES SUR LE SOLIDE                   *
C            (EN FONCTION DE L'ESPACE DU TEMPS ET DE LA TEMPERATURE)   *
C            CAS DU MODELE GENERAL                                     *
C                                                                      *
C            Dans la version 3.0, le flux volumiques peuvent etre      *
C            definis sur les noeuds, les elements ou                   *
C            par noeud d'un element                                    *
C                                                                      *
C            (Sous-programme utilisateur)                              *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  COORDS   ! TE ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  TMPSA    ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  TMPS     ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  NBFLVS   !  E ! D  ! NOMBRE DE NOEUDS AVEC FLUX VOL               !
C !  NFLUVS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS AVEC FLUX VOL     !
C !  VFLUVS   ! TR ! R  ! VALEUR DU FLUX VOLUMIQUE EN CES NOEUDS       !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /TEMPS/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "divct.h"
#include "syrthu.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS,NBFLVS,NPFEL,NELEMS,NDMATS
      INTEGER NREFS(NPOINS),NFLUVS(NBFLVS),NREFE(NELEMS)
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM),TMPSA(NPOINS),TMPS(NPOINS)
      DOUBLE PRECISION  VFLUVS(NBFLVS,NPFEL)
C
C.. Variables internes
      INTEGER I,J,K,N,NUMREF,NUMNO,NUMEL
      DOUBLE PRECISION  XX,YY,ZZ,TT1,TT2,T
C
C***********************************************************************
C
C     1- INTERVENTION UTILISATEUR A PARTIR DE CETTE LIGNE
C     ---------------------------------------------------
C
C     Pour stopper l'execution proprement en cas de probleme
C     mettre LSTOPS a "TRUE" dans vos tests
C     LSTOPS = .FALSE.
C
C     ------------------------------------------------------------------
C     Le flux volumique est stocke dans VFLUVS
C     Il peut etre fonction de l'espace (COORDS(...,1),COORDS(...,2),
C     COORDS(...,3)), du temps TEMPS, et de la temperature TMPS(...)
C     Dans le cas du modele coque, on dispose des temperatures
C     interne (TMPSA) et externe (TMPS) de la coque
C     ------------------------------------------------------------------    
C
C 
C     Temps reel courant sur le solide
CUTI  T = TEMPSS
C
C
C     ============================================================
C     TRAITEMENT PAR NOEUD
C     ============================================================
C     Pour chaque point portant un flux volumique
CUTI  DO N=1,NBFLVS
C
C        Numero global du noeud
CUTI     NUMNO = NFLUVS(N)
C   
C        Reference du noeud
CUTI     NUMREF = NREFS(NUMNO)
C
C        Coordonnees du noeud
CUTI     XX = COORDS(NUMNO,1)
CUTI     YY = COORDS(NUMNO,2)
CUTI     IF (NDIM.EQ.3) ZZ = COORDS(NUMNO,3)
C
C        TT1 = Temperature au noeud courant
CUTI     TT1 = TMPS(NUMNO)
C
C        Si le noeud courant porte la reference 4 le flux vaut 1000 W/M3
CUTI     IF ( NUMREF.EQ.4 ) THEN
CUTI       VFLUVS(N,1) = 1000.D0
C
C        Sinon il vaut 10000 W/M3
CUTI     ELSE
CUTI       VFLUVS(N,1) = 10000.D0
C
CUTI     ENDIF
C
CUTI  ENDDO
C     ============================================================
C     FIN DU TRAITEMENT PAR NOEUD
C     ============================================================
C
C
C
C
C     ============================================================
C     TRAITEMENT PAR ELEMENT (FLUX VOLUMIQUE CONSTANT PAR ELEMENT)
C     ============================================================
C     Pour chaque element portant un flux volumique
CUTI  DO N=1,NBFLVS
C
C        Numero global de l'element
CUTI     NUMEL = NFLUVS(N)
C   
C        Numero des noeuds de l'element
CUTI     N1 = NODES(NUMEL,1)
CUTI     N2 = NODES(NUMEL,2)
CUTI     N3 = NODES(NUMEL,3)
CUTI     N4 = NODES(NUMEL,4)
CUTI     N5 = NODES(NUMEL,5)
CUTI     N6 = NODES(NUMEL,6)
CUTI     IF (NDIM.EQ.3) THEN
CUTI         N7 = NODES(NUMEL,7)
CUTI         N8 = NODES(NUMEL,8)
CUTI         N9 = NODES(NUMEL,9)
CUTI         N10= NODES(NUMEL,10)
CUTI      ENDIF
C
C        Reference de l'element
CUTI     NUMREF = NREFE(NUMEL)
C
C        Coordonnees XXi YYi ZZi des noeuds de l'element
C        (6 en 2d, 10 en 3D)
C        Noeud n1
CUTI     XX1 = COORDS(N1,1)
CUTI     YY1 = COORDS(N1,2)
CUTI     IF (NDIM.EQ.3) ZZ1 = COORDS(N1,3)
C        Noeud n2
CUTI     XX2 = COORDS(N2,1)
CUTI     YY2 = COORDS(N2,2)
CUTI     IF (NDIM.EQ.3) ZZ2 = COORDS(N2,3)
CUTI     .
CUTI     .
CUTI     etc...
C
C        Temperatures TTi aux noeuds de l'element (6 en 2d 10 en 3d)
C        TT1 = Temperature au noeud courant n1
CUTI     TT1 = TMPS(N1)
CUTI     TT2 = TMPS(N2)
CUTI     .
CUTI     .
CUTI     etc...
C
C        Si l'element courant porte la reference 4
C        alors le flux vaut 1000 W/M3
C        Sinon il vaut 10000 W/M3
CUTI     IF ( NUMREF.EQ.4 ) THEN
CUTI       VFLUVS(N,1) = 1000.D0
CUTI     ELSE
CUTI       VFLUVS(N,1) = 10000.D0
CUTI     ENDIF
C
CUTI  ENDDO
C
C     ============================================================
C     FIN DU TRAITEMENT PAR ELEMENT (FLUX CONSTANT PAR ELEMENT)
C     ============================================================
C
C
C
C
C
C
C     ============================================================
C     TRAITEMENT PAR NOEUD D'UN ELEMENT
C     (LE FLUX VOLUMIQUE PEUT VARIER DANS L'ELEMENT)
C     ============================================================
C     Pour chaque element portant un flux volumique
CUTI  DO N=1,NBFLVS
C
C        Numero global de l'element
CUTI     NUMEL = NFLUVS(N)
C        Reference de l'element
CUTI     NUMREF = NREFE(NUMEL)
C
C        Pour chaque noeud de l'element courant
CUTI     DO J=1,NPFEL
C
C          Numero du noeud courant
CUTI       N1 = NODES(NUMEL,J)
C
C
C          Coordonnees du noeud courant
CUTI       XX1 = COORDS(N1,1)
CUTI       YY1 = COORDS(N1,2)
CUTI       IF (NDIM.EQ.3) ZZ1 = COORDS(N1,3)
C
C          Temperature du noeud courant
CUTI       TT1 = TMPS(N1)
C
C          Si l'element courant porte la reference 4
C          alors le flux vaut 1000 W/M3 sur chacun des noeuds de l'element
C          Sinon il vaut 10000 W/M3
CUTI         IF ( NUMREF.EQ.4 ) THEN
CUTI           VFLUVS(N,J) = 1000.D0
CUTI         ELSE
CUTI           VFLUVS(N,J) = 10000.D0
CUTI         ENDIF
CUTI     ENDDO
C
CUTI  ENDDO
C
C     ============================================================
C     FIN DU TRAITEMENT PAR NOEUD D'UN ELEMENT
C     (LE FLUX VOLUMIQUE PEUT VARIER DANS L'ELEMENT)
C     ============================================================
C
C
C
C----
C FIN
C----
      END
