/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | cnorm2                                                               |
  |         Calcul de normales en dimension 2                            |
  |======================================================================| */
void cnor_2d(int ndim,int nelray,int npoinr,
	     int *nodray,double *cooray,double *xnfray)
{
  int n,n1,n2;
  double xn,yn,an;

  for (n=0;n<nelray*ndim;n++) xnfray[n]=0.;

  for (n=0;n<nelray;n++) 
    {
      n1=nodray[n]-1; n2=nodray[n+nelray]-1;
      xn=-cooray[n2+npoinr] + cooray[n1+npoinr];
      yn= cooray[n2]        - cooray[n1];
      an = sqrt(xn*xn+yn*yn);

      xnfray[n]=xn/an;
      xnfray[n+nelray]=yn/an;
    }
}
      
          
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | cnorm2                                                               |
  |         Calcul de normales en dimension 3                            |
  |======================================================================| */
void cnor_3d(int ndim,int nelray,int npoinr,
	     int *nodray,double *cooray,double *xnfray)
{
  int n,n1,n2,n3;
  double xn,yn,zn,an,xab,yab,zab,xac,yac,zac;

  for (n=0;n<nelray*ndim;n++) xnfray[n]=0.;

  for (n=0;n<nelray;n++) 
    {
      n1=nodray[n]-1; n2=nodray[n+nelray]-1;  n3=nodray[n+2*nelray]-1;
      xab=cooray[n2]         -cooray[n1];
      yab=cooray[n2+npoinr]  -cooray[n1+npoinr];
      zab=cooray[n2+2*npoinr]-cooray[n1+2*npoinr];

      xac=cooray[n3]         -cooray[n1];
      yac=cooray[n3+npoinr]  -cooray[n1+npoinr];
      zac=cooray[n3+2*npoinr]-cooray[n1+2*npoinr];

      xn= yab*zac - zab*yac;
      yn=-xab*zac + zab*xac;
      zn= xab*yac - yab*xac;

      an = sqrt(xn*xn + yn*yn + zn*zn);

      xnfray[n]=xn/an;
      xnfray[n+nelray]=yn/an;
      xnfray[n+2*nelray]=zn/an;
    }
}
      
