C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECREF
C                       *****************
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   LECTURE ET INTERPRETATION DU FICHIER cl.data            *
C              Lecture de la correspondance entre references           *
C              et type de CL                                           *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/XREFER/!      ! M  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "optct.h"
#include "xrefer.h"
#include "nlofes.h"
#include "nlofct.h"
#include "bilan.h"
C
C**********************************************************************
C
C
      INTEGER I,N,I1,I2,II1,II2,NB,LCH
C
      INTEGER ITAB(NRFMAX)
      CHARACTER*200 CHAINE,FORMA
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      DO I=1,NRFMAX
        IREFFC(I) = 0
        IREFSC(I) = 0
        IREFSD(I) = 0
        IREFSF(I) = 0
        IREFSE(I) = 0
        IREFSV(I) = 0
        IREFRE(I) = 0
        IREFRI(I) = 0
        IREFPR(I) = 0
        IREFMO(I) = 0
      ENDDO
C
      DO I=1,NRFMAX
         ITAB(I) = 0
      ENDDO
C
      DO I=1,NRFMAX
        DO N=1,NBISMX
          IRBILS(I,N)=0
          IRBILV(I,N)=0
        ENDDO
      ENDDO
C
C    
C
C     1- LECTURE DES REFERENCES DES CATEGORIES DE NOEUDS 
C     ==================================================
C
      REWIND(NFCLCT)
C
C     Boucle de lecture....
   10 CONTINUE
C
      CHAINE = ' '
      READ(NFCLCT,1000,END=999) CHAINE
C
      IF (CHAINE(1:1) .EQ. '/') GOTO 10
C
      CALL POSCOT(CHAINE,I1,I2,LCH)
C
      IF (I1 .EQ. 0) GOTO 10
C
C
C     1.1- NOEUDS FLUIDES COUPLES AU SOLIDE
C     ------------------------------------
      IF ( CHAINE(I1:I2).EQ. 
     *     'REFERENCES NOEUDS FLUIDES COUPLES AU SOLIDE') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 110 N=1,NB
           IREFFC(ITAB(N)) = 1
  110    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 111 N=1,NRFMAX
             IREFFC(N) = 1
  111      CONTINUE
         ENDIF
C
C     1.2- NOEUDS SOLIDES COUPLES
C     ---------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     *        'REFERENCES NOEUDS OU FACES SOLIDES COUPLE(E)S') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 120 N=1,NB
           IREFSC(ITAB(N)) = 1
  120    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 121 N=1,NRFMAX
             IREFSC(N) = 1
  121      CONTINUE
         ENDIF        
C
C
C     1.3- NOEUDS SOLIDES AVEC DIRICHLET
C     ---------------------------------- 
      ELSEIF ( CHAINE(I1:I2).EQ.
     &  'REFERENCES NOEUDS SOLIDES AVEC DIRICHLET') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 130 N=1,NB
           IREFSD(ITAB(N)) = 1
  130    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 131 N=1,NRFMAX
             IREFSD(N) = 1
  131      CONTINUE
         ENDIF        
C
C     1.4- NOEUDS SOLIDES AVEC FLUX
C     -----------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     &   'REFERENCES NOEUDS OU FACES SOLIDES AVEC FLUX') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 140 N=1,NB
           IREFSF(ITAB(N)) = 1
  140    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 141 N=1,NRFMAX
             IREFSF(N) = 1
  141      CONTINUE
         ENDIF        
C
C     1.5- NOEUDS SOLIDES AVEC COEFFICIENTS D'ECHANGE
C     -----------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU FACES SOLIDES AVEC COEFFICIENT D ECHANGE') 
     &  THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 150 N=1,NB
           IREFSE(ITAB(N)) = 1
  150    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 151 N=1,NRFMAX
             IREFSE(N) = 1
  151      CONTINUE
         ENDIF
C
C     1.6- NOEUDS SOLIDES AVEC FLUX VOLUMIQUE
C     ----------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU ELEMENTS SOLIDES AVEC FLUX VOLUMIQUES') 
     &  THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 160 N=1,NB
           IREFSV(ITAB(N)) = 1
  160    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 161 N=1,NRFMAX
             IREFSV(N) = 1
  161      CONTINUE
         ENDIF
C
C     1.7- NOEUDS SOLIDES AVEC RESISTANCE DE CONTACT
C     ----------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU FACES SOLIDES AVEC RESISTANCE DE CONTACT') 
     &  THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 170 N=1,NB
           IREFRE(ITAB(N)) = 1
  170    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 171 N=1,NRFMAX
             IREFRE(N) = 1
  171      CONTINUE
         ENDIF
C
C     1.8- NOEUDS SOLIDES AVEC RAYONNEMENT INFINI
C     -------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU FACES SOLIDES AVEC RAYONNEMENT INFINI')
     &   THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 182 N=1,NB
           IREFRI(ITAB(N)) = 1
  182   CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 183 N=1,NRFMAX
             IREFRI(N) = 1
  183      CONTINUE
         ENDIF
C
C
C     1.9- NOEUDS SOLIDES PERIODIQUES
C     -------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS SOLIDES PERIODIQUES') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
         IF (NB.NE.0 .AND. NBDIPR.EQ.0) THEN
           WRITE(NFECRA,1900)
           STOP
         ENDIF
C
         DO 190 N=1,NB
           IREFPR(ITAB(N)) = 1
  190    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 191 N=1,NRFMAX
             IREFPR(N) = 1
  191      CONTINUE
         ENDIF
C
C     1.10- NOEUDS SOLIDES EN ROTATION
C     --------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS SOLIDES EN ROTATION') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 192 N=1,NB
           IREFMO(ITAB(N)) = 1
  192    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 193 N=1,NRFMAX
             IREFMO(N) = 1
  193      CONTINUE
         ENDIF
C
C
C
C     1.11- BILAN DE FLUX SURFACIQUES
C     -------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 'BILAN FLUX SURFACIQUES') THEN
C
         NBILAS=NBILAS+1
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO N=1,NB
           IRBILS(ITAB(N),NBILAS) = 1
         ENDDO
C
C     1.12- BILAN DE FLUX VOLUMIQUES
C     -------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 'BILAN FLUX VOLUMIQUES') THEN
C
         NBILAV=NBILAV+1
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO N=1,NB
           IRBILV(ITAB(N),NBILAV) = 1
         ENDDO
C
C
      ENDIF
C
      GOTO 10
C
 999  CONTINUE
C
C     2- IMPRESSION POUR VERIFICATIONS
C     ================================
C
      IF (NBLBLA.GE.2) THEN
C
        NB = 0
        DO 309 N=1,NRFMAX
         IF (IREFFC(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  309   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2010) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 311 N=1,NRFMAX
         IF (IREFSC(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  311   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2020) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 312 N=1,NRFMAX
         IF (IREFSD(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  312   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2030) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 313 N=1,NRFMAX
         IF (IREFSF(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  313   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2040) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 314 N=1,NRFMAX
         IF (IREFSE(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  314   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2050) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 315 N=1,NRFMAX
         IF (IREFSV(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  315   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2060) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 316 N=1,NRFMAX
         IF (IREFRE(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  316   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2070) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 318 N=1,NRFMAX
         IF (IREFRI(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  318   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2081) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 319 N=1,NRFMAX
         IF (IREFPR(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  319   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2090) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 320 N=1,NRFMAX
         IF (IREFMO(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  320   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,2100) 
          WRITE(NFECRA,2001) (ITAB(N),N=1,NB)
        ENDIF      
C
        IF (NBILAS.GT.0) THEN
          WRITE(NFECRA,3100) 
          DO I=1,NBILAS
            NB = 0
            DO N=1,NRFMAX
              IF (IRBILS(N,I).NE.0) THEN
                NB = NB + 1
                ITAB(NB) = N
              ENDIF
            ENDDO
            IF (NB.NE.0) THEN
              WRITE(NFECRA,3101) I,(ITAB(N),N=1,NB)
            ENDIF      
          ENDDO
        ENDIF
C
C
        IF (NBILAV.GT.0) THEN
          WRITE(NFECRA,3200) 
          DO I=1,NBILAV
            NB = 0
            DO N=1,NRFMAX
              IF (IRBILV(N,I).NE.0) THEN
                NB = NB + 1
                ITAB(NB) = N
              ENDIF
            ENDDO
            IF (NB.NE.0) THEN
              WRITE(NFECRA,3201) I,(ITAB(N),N=1,NB)
            ENDIF      
          ENDDO
        ENDIF
C
C
      ENDIF
C   
C
      GOTO 300
C
C     3. GESTION DES ERREURS DE LECTURE
C     =================================
C
 9999 WRITE(NFECRA,9000) CHAINE
      STOP
C
  300 CONTINUE
C
C--------
C FORMATS
C--------
 1000 FORMAT(A200)
C
 1900 FORMAT(' %% ERREUR LECREF : On lit des references de noeuds',
     &       ' periodiques alors qu''aucune',/,
     &   20X,'periodicite n''est declaree',/,
     &   20X,'(cf ''NOMBRE DE DIRECTIONS PERIODIQUES='')')
 2010 FORMAT(//,80('*'),//,
     &      ' *** LECREF : REFERENCES DES NOEUDS DU FLUIDE COUPLES')
 2020 FORMAT(/,' *** LECREF : REFERENCES DES NOEUDS DU SOLIDE ',
     &      'COUPLES')
 2030 FORMAT(/,' *** LECREF : REFERENCES DES NOEUDS DU SOLIDE ',
     &         'AVEC DIRICHLET')
 2040 FORMAT(/,' *** LECREF : REFERENCES DES NOEUDS DU SOLIDE ',
     &         'AVEC FLUX')
 2050 FORMAT(/,' *** LECREF : REFERENCES DES NOEUDS DU SOLIDE ',
     &         'AVEC COEFFICIENTS D''ECHANGE')
 2060 FORMAT(/,' *** LECREF : REFERENCES DES NOEUDS DU SOLIDE ',
     &         'AVEC FLUX VOLUMIQUE')
 2070 FORMAT(/,' *** LECREF : REFERENCES DES NOEUDS DU SOLIDE ',
     &         'AVEC RESISTANCE DE CONTACT')
 2081 FORMAT(/,' *** LECREF : REFERENCES NOEUDS OU FACES ',
     &          'SOLIDES AVEC RAYONNEMENT INFINI')
 2090 FORMAT(/,' *** LECREF : REFERENCES DES NOEUDS SOLIDES ',
     &         'PERIODIQUES')
 2100 FORMAT(/,' *** LECREF : REFERENCES DES NOEUDS SOLIDES ',
     &         'EN ROTATION')
 2001 FORMAT(3X,32I3,/)
 3100 FORMAT(/,' *** LECREF : Bilans surfaciques :')
 3101 FORMAT(  '              Bilan :',I2,'  References :',99I3)
 3200 FORMAT(/,' *** LECREF : Bilans volumiques :')
 3201 FORMAT(  '              Bilan :',I2,'  References :',99I3)
 9000 FORMAT(/,' %% ERREUR LECREF : Erreur dans le fichier de donnees',
     * /,20X,'au cours de la lecture des references',/,
     *   20X,'Ligne concernee : ',A)
C----
C FIN
C----
C
      RETURN
      END
