C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=LECG2R,SSI=0
C
                        SUBROUTINE LECG2R
C                       *****************
C
C     -------------------------
     *( TRESU,NLONGT,NOMT,NFIC)
C     -------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C       LECTURE DU FICHIER RESULTAT SYRTHES POUR UNE SUITE DE CALCUL   *  
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! TRESU  !  TR  ! D  ! TABLEAU DE RESULTATS A ECRIRE               !
C   ! NLONGT !   E  ! D  ! DIMENSION DU TABLEAU TRESU                  !
C   ! NOMT   !   A  ! D  ! NOM DE LA VARIABLE A ECRIRE                 !
C   ! LENTET !   L  ! D  ! INDICATEUR D'ECRITURE DE L'ENTETE           !
C   ! NFIC   !   E  ! D  ! NUMERO LOGIQUE DU FICHIER                   !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C      
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "nlofes.h"
C**********************************************************************
C
C.. Variables externes
      INTEGER   NLONGT,NFIC
      DOUBLE PRECISION    TRESU(NLONGT)
      CHARACTER NOMT*12
C
C.. Variables internes
      INTEGER   I
      CHARACTER CH*12
C
C
C**********************************************************************
C
C     0- INITIALISATION
C     =================
C
      DO 1 I=1,NLONGT
         TRESU (I) = 0.D0
    1 CONTINUE
C
C
C     1- LECTURE DU TABLEAU DE RESULTATS
C     ==================================
C
      READ(NFIC,1000,ERR=99) CH
      IF (CH.NE.NOMT) THEN
        WRITE(NFECRA,1999) CH,NOMT
        STOP
      ENDIF
      READ(NFIC,1000,ERR=99) CH
      READ(NFIC,1010,ERR=99) (TRESU(I),I=1,NLONGT)
C 
      RETURN
C
   99 CONTINUE
      WRITE(NFECRA,999)
      STOP
C
C--------
C FORMATS
C--------
C
 1000 FORMAT(A12)
 1010 FORMAT(6E13.7)
C
 1999 FORMAT(/,' %% ERREUR LECG2R : ',
     &       'LE FICHIER SUITE N''EST PAS CORRECT',/,
     &       '                    ',
     &       'On lit ',A12,' au lieu de ',A12)
C
  999 FORMAT(/,' %% ERREUR LECG2R : ',
     &         ' ERREUR DE LECTURE DU FICHIER SUITE')
C
C
      END
