C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE ECRG1
C                       *****************
C
C     -------------------------------------------------
     *( NFIC,LF,NDIM,NDIELE,NBPOIN,NBELE,NBNODE,NBFACE,
     *  COORD,NODE,NREFER,NREFE,NREFAC)
C     ------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C       GENERATION DU FICHIER GEOMETRIQUE POUR GRAFN3S                 *  
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NFIC   !   E  ! D  ! NUMERO LOGIQUE DU FICHIER                   !
C   !   LF   !   L  !  D ! INDICATEUR                                  !
C   !        !      !    !   = vrai = ecriture des references des faces!
C   !        !      !    !   = faux = pas d'ecriture                   !
C   ! NDIM   !   E  ! D  ! DIMENSION DU PROBLEME (LOCAL)               !
C   ! NDIELE !   E  ! D  ! DIMENSION DES ELEMENTS DU MAILLAGE          !
C   !        !      !    !   1 -> segment                              !
C   !        !      !    !   2 -> triangle                             !
C   !        !      !    !   3 -> tetraedre                            !
C   ! NBPOIN !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE                !
C   ! NBELE  !   E  ! D  ! NOMBRE D'ELEMENTS DU MAILLAGE               !
C   ! NBNODE !   L  ! D  ! NOMBRE DE NOEUDS PAR ELEMENT                !
C   ! NBFACE !   E  ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES        !
C   ! COORD  !  TR  !    ! TABLE DES COORDONNEES                       !
C   ! NODE   !  TE  ! M  ! CONNECTIVITE DU MAILLAGE                    !
C   ! NREFER !  TE  ! D  ! REFERENCES DES NOEUDS                       !
C   ! NREFAC !  TE  ! D  ! REFERENCES DES FACES                        !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C      
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "nlofes.h"
C
C**********************************************************************
C.. Variables externes
      INTEGER NDIM,NDIELE,NBPOIN,NBELE,NBNODE,NBFACE
      INTEGER NODE(NBELE,NBNODE),NREFER(NBPOIN),NFIC
      INTEGER NREFAC(NBELE,NBFACE),NREFE(NBELE) 
      DOUBLE PRECISION  COORD(NBPOIN,NDIM)
      LOGICAL LF
C
C.. Variables internes
      CHARACTER*1 CTP1P2
      INTEGER N,I,NNSOM
      DOUBLE PRECISION XTCL
C
C**********************************************************************
C
C     0- INITIALISATIONS ET TRI DES NOEUDS
C     ====================================
C
C     0.1- Initialisations
C     --------------------
C
      XTCL  = 0
C
C        
C     1- ENTETE DU FICHIER (EN COMMENTAIRES)
C     ======================================
      WRITE(NFIC,1100)
      WRITE(NFIC,1110) NDIM,NDIELE,NBPOIN,NBELE,NBNODE
C
C
C     2- ECRITURE DE LA TABLE DES NOEUDS
C     ==================================
C
C     Ecriture du titre de la rubique
      WRITE(NFIC,2000)
C
      DO 200 N=1,NBPOIN      
C
        DO 210 I = 1,NDIM
          IF (ABS(COORD(N,I)) .LE. 1.E-10) COORD(N,I) = 0.D0
  210   CONTINUE
C
        IF (NDIM.EQ.2) THEN
C
          WRITE(NFIC,2100)
     &         N,NREFER(N),(COORD(N,I),I=1,2),XTCL
C
        ELSEIF (NDIM.EQ.3) THEN
C
          WRITE(NFIC,2100)
     &         N,NREFER(N),(COORD(N,I),I=1,3)
C
        ENDIF
C
  200 CONTINUE
C
C
C     3- ECRITURE DE LA TABLE DES ELEMENTS
C     ====================================
C
C     Ecriture du titre de la rubique
      WRITE(NFIC,3000)
C
C     3.0- Segments a 2 noeuds
C     ------------------------
      IF (NDIELE.EQ.1 .AND. NBNODE.EQ.2) THEN
        DO 130 N=1,NBELE
           WRITE(NFIC,3100) N,NREFE(N),(NODE(N,I),I=1,2)
 130    CONTINUE
C
C     3.1- Segments a 3 noeuds
C     ------------------------
      ELSEIF (NDIELE.EQ.1 .AND. NBNODE.EQ.3) THEN
        DO 131 N=1,NBELE
           WRITE(NFIC,3200) N,NREFE(N),(NODE(N,I),I=1,3)
 131    CONTINUE
C
C     3.2- Triangles a 3 noeuds
C     -------------------------
      ELSEIF (NDIELE.EQ.2 .AND. NBNODE.EQ.3) THEN
        DO 132 N=1,NBELE
           WRITE(NFIC,3200) N,NREFE(N),(NODE(N,I),I=1,3)
 132    CONTINUE
C
C     3.3- Triangles a 6 noeuds
C     -------------------------
      ELSEIF (NDIELE.EQ.2 .AND. NBNODE.EQ.6) THEN
        DO 133 N=1,NBELE
           WRITE(NFIC,3300) N,NREFE(N),(NODE(N,I),I=1,6)
 133    CONTINUE
C
C
C     3.4- Tetraedre a 10 noeuds
C     --------------------------
      ELSEIF (NDIELE.EQ.3 .AND. NBNODE.EQ.10) THEN
        DO 134 N=1,NBELE
          WRITE(NFIC,3400) N,NREFE(N),(NODE(N,I),I=1,10)
 134    CONTINUE
C
      ELSE
        WRITE(NFECRA,3500)
        STOP
C
      ENDIF
C
C
C     4- ECRITURE DES REFERENCES DES FACES
C     ====================================
C
      IF (LF) THEN
C
        WRITE(NFIC,4000)
C
        DO 400 N=1,NBELE
          WRITE(NFIC,4100) N,(NREFAC(N,I),I=1,NBFACE)
  400   CONTINUE
C
      ENDIF
C
      CALL FLUSHF(NFIC)
C
C--------
C FORMATS
C--------
C
 999  FORMAT(' %% ERREUR ECRG1 : la dimension des elements (NDIELE)',
     &       ' est incorrecte') 
1100  FORMAT(
     &  'C************************************************C',/,
     &  'C        FICHIER GEOMETRIQUE SYRTHES 3.4         C',/,
     &  'C************************************************C')
      
1110  FORMAT(
     &  'C  DIMENSION = ',I1,'  DIMENSION DES ELTS = ',I1,/,
     &  'C  NOMBRE DE NOEUDS = ',I10,/,
     &  'C  NOMBRE D''ELEMENTS =',I10,/,
     &  'C  NOMBRE DE NOEUDS PAR ELEMENT = ',I3,/,
     &  'C************************************************C')
C
 2000 FORMAT('C',/,'C$ RUBRIQUE = NOEUDS',/,'C')
 2100 FORMAT(I10,I3,1X,3(E14.7,1X))
C
 3000 FORMAT('C',/,'C$ RUBRIQUE = ELEMENTS',/,'C')
 3100 FORMAT(I10,I3,2I10)
 3200 FORMAT(I10,I3,3I10)
 3300 FORMAT(I10,I3,6I10)
 3400 FORMAT(I10,I3,10I10)
 3500 FORMAT(/,'  %% ECRG1 : TYPE D''ELEMENTS INCONNUS')
C
C
 4000 FORMAT('C',/,'C$ RUBRIQUE = REFERENCES DES FACES',/,'C')
 4100 FORMAT(I10,1X,4I5)
 
C
      END
