C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=ASSEMB,SSI=0
C
                     SUBROUTINE ASSEMB
C                    *****************
C
C     --------------------------------------------
     *( DMAT,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT)
C      -------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     ASSEMBLAGE DES VECTEURS POUR                      *
C                    LE CAS BIDIMENSIONNEL, AXISYMETRIQUE,             *
C                    TRIDIMENSIONNEL ET COQUE.                         *
C                    Vecteur non necessairement initialise a 0         *
C                                                                      *
C     ATTENTION : Dans ce sous-programme on force la vectorisation     *
C                 si l'instruction !OCL  est active                    *  
C                 ce qui suppose un arrangement des elements adapte.   *
C                 Ordre ayant une importance uniquement  sur VPP5000   *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   DMAT    !  TR  ! D  ! DIAGONALE DE LA MATRICE M                !
C   !   NODES   !  TE  ! D  ! NUMERO DES NOEUDS ( LOCALE --> GLOBALE ) !
C   !   WCT     !  TR  ! M  ! TABLEAUX DE TRAVAIL (NELEMS*NDMATS )     !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "divct.h"
C
C***********************************************************************
      INTEGER NPOINS,NELEMS,NDMATS,NDIELE
C
      DOUBLE PRECISION DMAT(NPOINS)
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
C      
C     Variables locales
      INTEGER I,INODE
      INTEGER NBBLOC,ILONV
C
C***********************************************************************
C
      ILONV=ABS(IVECTO)
C
      IF (ILONV.EQ.1024) THEN
C     Assemblage des vecteurs sur 1024
      NBBLOC= NELEMS/ILONV
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,1)
          DMAT(INODE) = DMAT(INODE) + WCT(I,1)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,1)
          DMAT(INODE) = DMAT(INODE) + WCT(I,1)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,1)
          DMAT(INODE) = DMAT(INODE) + WCT(I,1)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,2)
          DMAT(INODE) = DMAT(INODE) + WCT(I,2)
      ENDDO

      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,2)
          DMAT(INODE) = DMAT(INODE) + WCT(I,2)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,2)
          DMAT(INODE) = DMAT(INODE) + WCT(I,2)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,3)
          DMAT(INODE) = DMAT(INODE) + WCT(I,3)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,3)
          DMAT(INODE) = DMAT(INODE) + WCT(I,3)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,3)
          DMAT(INODE) = DMAT(INODE) + WCT(I,3)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,4)
          DMAT(INODE) = DMAT(INODE) + WCT(I,4)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,4)
          DMAT(INODE) = DMAT(INODE) + WCT(I,4)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,4)
          DMAT(INODE) = DMAT(INODE) + WCT(I,4)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,5)
          DMAT(INODE) = DMAT(INODE) + WCT(I,5)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,5)
          DMAT(INODE) = DMAT(INODE) + WCT(I,5)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,5)
          DMAT(INODE) = DMAT(INODE) + WCT(I,5)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,6)
          DMAT(INODE) = DMAT(INODE) + WCT(I,6)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,6)
          DMAT(INODE) = DMAT(INODE) + WCT(I,6)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,6)
          DMAT(INODE) = DMAT(INODE) + WCT(I,6)
      ENDDO
      ENDIF
C
C
C
      IF ( NDIELE .EQ. 3 ) THEN
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,7)
          DMAT(INODE) = DMAT(INODE) + WCT(I,7)
      ENDDO

      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,7)
          DMAT(INODE) = DMAT(INODE) + WCT(I,7)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,7)
          DMAT(INODE) = DMAT(INODE) + WCT(I,7)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,8)
          DMAT(INODE) = DMAT(INODE) + WCT(I,8)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,8)
          DMAT(INODE) = DMAT(INODE) + WCT(I,8)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,8)
          DMAT(INODE) = DMAT(INODE) + WCT(I,8)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,9)
          DMAT(INODE) = DMAT(INODE) + WCT(I,9)
      ENDDO

      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,9)
          DMAT(INODE) = DMAT(INODE) + WCT(I,9)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,9)
          DMAT(INODE) = DMAT(INODE) + WCT(I,9)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(16)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,10)
          DMAT(INODE) = DMAT(INODE) + WCT(I,10)
      ENDDO
      IF(IVECTO.GT.0) THEN      
!OCL NOVREC, VRL(16)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,10)
          DMAT(INODE) = DMAT(INODE) + WCT(I,10)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,10)
          DMAT(INODE) = DMAT(INODE) + WCT(I,10)
      ENDDO
      ENDIF
C
      ENDIF
C
      ENDIF
C
C
C-------------------
      IF (ILONV.EQ.128) THEN
C     Assemblage des vecteurs sur 128
      NBBLOC= NELEMS/ILONV
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,1)
          DMAT(INODE) = DMAT(INODE) + WCT(I,1)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,1)
          DMAT(INODE) = DMAT(INODE) + WCT(I,1)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,1)
          DMAT(INODE) = DMAT(INODE) + WCT(I,1)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,2)
          DMAT(INODE) = DMAT(INODE) + WCT(I,2)
      ENDDO

      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,2)
          DMAT(INODE) = DMAT(INODE) + WCT(I,2)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,2)
          DMAT(INODE) = DMAT(INODE) + WCT(I,2)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,3)
          DMAT(INODE) = DMAT(INODE) + WCT(I,3)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,3)
          DMAT(INODE) = DMAT(INODE) + WCT(I,3)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,3)
          DMAT(INODE) = DMAT(INODE) + WCT(I,3)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,4)
          DMAT(INODE) = DMAT(INODE) + WCT(I,4)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,4)
          DMAT(INODE) = DMAT(INODE) + WCT(I,4)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,4)
          DMAT(INODE) = DMAT(INODE) + WCT(I,4)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,5)
          DMAT(INODE) = DMAT(INODE) + WCT(I,5)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,5)
          DMAT(INODE) = DMAT(INODE) + WCT(I,5)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,5)
          DMAT(INODE) = DMAT(INODE) + WCT(I,5)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,6)
          DMAT(INODE) = DMAT(INODE) + WCT(I,6)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,6)
          DMAT(INODE) = DMAT(INODE) + WCT(I,6)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,6)
          DMAT(INODE) = DMAT(INODE) + WCT(I,6)
      ENDDO
      ENDIF
C
C
C
      IF ( NDIELE .EQ. 3 ) THEN
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,7)
          DMAT(INODE) = DMAT(INODE) + WCT(I,7)
      ENDDO

      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,7)
          DMAT(INODE) = DMAT(INODE) + WCT(I,7)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,7)
          DMAT(INODE) = DMAT(INODE) + WCT(I,7)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,8)
          DMAT(INODE) = DMAT(INODE) + WCT(I,8)
      ENDDO
      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,8)
          DMAT(INODE) = DMAT(INODE) + WCT(I,8)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,8)
          DMAT(INODE) = DMAT(INODE) + WCT(I,8)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,9)
          DMAT(INODE) = DMAT(INODE) + WCT(I,9)
      ENDDO

      IF(IVECTO.GT.0) THEN
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,9)
          DMAT(INODE) = DMAT(INODE) + WCT(I,9)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,9)
          DMAT(INODE) = DMAT(INODE) + WCT(I,9)
      ENDDO
      ENDIF
C
!OCL NOVREC, VRL(128)
      DO  I=1,NBBLOC*ILONV
          INODE = NODES(I,10)
          DMAT(INODE) = DMAT(INODE) + WCT(I,10)
      ENDDO
      IF(IVECTO.GT.0) THEN      
!OCL NOVREC, VRL(128)
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,10)
          DMAT(INODE) = DMAT(INODE) + WCT(I,10)
      ENDDO
      ELSE
      DO I=NBBLOC*ILONV+1,NELEMS
          INODE = NODES(I,10)
          DMAT(INODE) = DMAT(INODE) + WCT(I,10)
      ENDDO
      ENDIF
C
      ENDIF

C
      ENDIF
C
C
C------------------------------
      IF (ILONV.EQ.0) THEN
C     Assemblage scalaire des vecteurs
      DO I=1,NELEMS
          INODE = NODES(I,1)
          DMAT(INODE) = DMAT(INODE) + WCT(I,1)
      ENDDO
C
      DO I=1,NELEMS
          INODE = NODES(I,2)
          DMAT(INODE) = DMAT(INODE) + WCT(I,2)
      ENDDO
C
      DO I=1,NELEMS
          INODE = NODES(I,3)
          DMAT(INODE) = DMAT(INODE) + WCT(I,3)
      ENDDO
C
      DO I=1,NELEMS
          INODE = NODES(I,4)
          DMAT(INODE) = DMAT(INODE) + WCT(I,4)
      ENDDO
C
      DO I=1,NELEMS
          INODE = NODES(I,5)
          DMAT(INODE) = DMAT(INODE) + WCT(I,5)
      ENDDO
C
      DO I=1,NELEMS
          INODE = NODES(I,6)
          DMAT(INODE) = DMAT(INODE) + WCT(I,6)
      ENDDO
C
C
      IF ( NDIELE .EQ. 3 ) THEN
C
          DO I=1,NELEMS
              INODE = NODES(I,7)
              DMAT(INODE) = DMAT(INODE) + WCT(I,7)
      ENDDO
C
          DO I=1,NELEMS
              INODE = NODES(I,8)
              DMAT(INODE) = DMAT(INODE) + WCT(I,8)
      ENDDO
C
          DO I=1,NELEMS
              INODE = NODES(I,9)
              DMAT(INODE) = DMAT(INODE) + WCT(I,9)
      ENDDO
C
          DO I=1,NELEMS
              INODE = NODES(I,10)
              DMAT(INODE) = DMAT(INODE) + WCT(I,10)
      ENDDO
C
      ENDIF
C
      ENDIF
C
      RETURN
      END   
