/*
 * This file tests Java-style and Javadoc comments.
 * $id$
 * $changelog$
 */

/**
 * Representation of an Employee. This class follows the (in)famous example of
 * being an Employee, used in many C++ courses. Employees have names and IDs.
 * If this were a bigger example they might have more.
 * @see Employee.name()
 * @see Employee.id()
 * @see string
 * @link http://www.c++.org/ Your C++ Manual
 */
class Employee {
public:
    /** Constructor. id may be empty, in which case a new ID is generated. */
    Employee(const std::string &name, const string &id);

    /** Returns the name of this Employee */
    std::string name() const;

    /** Returns the id of this Employee */
    std::string id() const;
    /** @defgroup age
     *  the age attribute
     *  @{
     */
    short age() const;
    void age(short);
    /** @} end of age */
private:
    /** The name */
    std::string _name;
    /** The ID. This is a sequence of alphanumeric digits of length 10 and
     * starting with 'e'. */
    std::string _id;
    short _age;
};
