

#ifndef _RCDSCANNER_H_
#define _RCDSCANNER_H_


#include <vector>
#include <string>

class Configuration;


class RCDScanProgress {
   
   int _total;
   
public:
   void setTotal(int total) { _total = total; };

   virtual void update(string phase, int current=-1) = 0;
};



class RCDScanner {

   Configuration *_database;
   
protected:

   vector<string> _pkgList;
   vector<string> _srcList;
   string _infoDir;
   
   string _cdId;
   string _cdName;

   string pkgSourceType() const;
   string srcSourceType() const;
   bool isOurArch(string arch) const;
   bool scanDirectory(string path, RCDScanProgress *progress, int depth=0);

   void cleanPkgList(vector<string> &list);
   void cleanSrcList(vector<string> &list);
   
   bool writeDatabase(string id, string name);
   bool writeSourceList(string id, vector<string> &list, bool pkg);

   string getDiscName();
   
public:
   void unmountCD();

   bool scanCD(RCDScanProgress *progress);
   void countLists(int &pkgLists, int &srcLists);

   bool copyLists(RCDScanProgress *progress);   
   
   bool needsRegistration(string &defaultName);
   bool registerDisc(string name);
   
   bool finish();
   
};


#endif


