// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#include "Ptv.h"
#include "OrderedPtvSet.h"
#include <vector>
#include <stdexcept>
#include <algorithm>

namespace SyFi
{

	// --- OrderedPtvSet

	OrderedPtvSet:: OrderedPtvSet()
	{
	}

	OrderedPtvSet::~OrderedPtvSet()
	{
		Ptvs.clear();
	}

	OrderedPtvSet:: OrderedPtvSet(const Ptv& p0, const Ptv& p1)
	{
		Ptvs.push_back(p0);
		Ptvs.push_back(p1);
		std::sort(Ptvs.begin(), Ptvs.end(), Ptv_is_less());
	}

	OrderedPtvSet:: OrderedPtvSet(const Ptv& p0, const Ptv& p1, const Ptv& p2)
	{
		Ptvs.push_back(p0);
		Ptvs.push_back(p1);
		Ptvs.push_back(p2);
		std::sort(Ptvs.begin(), Ptvs.end(), Ptv_is_less());
	}

	OrderedPtvSet:: OrderedPtvSet(const Ptv& p0, const Ptv& p1, const Ptv& p2, const Ptv& p3)
	{
		Ptvs.push_back(p0);
		Ptvs.push_back(p1);
		Ptvs.push_back(p2);
		Ptvs.push_back(p3);
		std::sort(Ptvs.begin(), Ptvs.end(), Ptv_is_less());
	}

	void OrderedPtvSet:: append(const Ptv& p)
	{
		Ptvs.push_back(p);
		std::sort(Ptvs.begin(), Ptvs.end(), Ptv_is_less());
	}

	unsigned int OrderedPtvSet:: size() const
	{
		return Ptvs.size();
	}

	const Ptv& OrderedPtvSet:: operator [] (unsigned int i) const
	{
		return Ptvs[i];
	}

	Ptv& OrderedPtvSet:: operator [] (unsigned int i)
	{
		return Ptvs[i];
	}

	OrderedPtvSet& OrderedPtvSet::operator = (const OrderedPtvSet& p)
	{
		if ( this != &p)
		{
			Ptvs.clear();
			for (unsigned int i=0; i<p.size(); i++)
			{
				Ptvs.push_back(p[i]);
			}
		}
		return *this;
	}

	bool OrderedPtvSet:: less(const OrderedPtvSet& p) const
	{
		if ( Ptvs.size() <  p.size() ) return true ;
		if ( Ptvs.size() > p.size() ) return false;

		for (unsigned int i=Ptvs.size()-1; i>= 0; i--)
		{
			if ( Ptvs[i].less(p[i]) && p[i].less(Ptvs[i]))
			{
			}
			else if ( Ptvs[i].less(p[i]) )
			{
				return true;
			}
			else if ( p[i].less(Ptvs[i]) )
			{
				return false;
			}
		}
		return false;
	}

	std::ostream & operator<< ( std::ostream& os, const OrderedPtvSet& p)
	{
		if (p.size() >= 1)
		{
			os <<"[";
			for (unsigned int i=0; i< p.size()-1; i++)
			{
				os <<p[i]<<",";
			}
			os <<p[p.size()-1]<<"]";
		}
		else
		{
			os <<"OrderedPtvSet not created properly"<<std::endl;
		}
		return os;
	}

	// --- OrderedPtvSet_i

	OrderedPtvSet_i :: OrderedPtvSet_i ()
	{
	}

	OrderedPtvSet_i::~OrderedPtvSet_i()
	{
	}

	OrderedPtvSet_i :: OrderedPtvSet_i (OrderedPtvSet& s, unsigned int i)
	{
		si.first = s;
		si.second.push_back(i);
	}

	OrderedPtvSet_i :: OrderedPtvSet_i (OrderedPtvSet& s, unsigned int i0, unsigned int i1)
	{
		si.first = s;
		si.second.push_back(i0);
		si.second.push_back(i1);
	}

	const OrderedPtvSet&  OrderedPtvSet_i:: get_OrderedPtvSet() const
	{
		return si.first;
	}

	unsigned int OrderedPtvSet_i:: get_i(unsigned int n) const
	{
		if ( n >= 0 && n < si.second.size() )
		{
			return si.second[n];
		}
		else
		{

			throw(std::out_of_range("The index is out of range!"));

		}
	}

	unsigned int OrderedPtvSet_i:: size() const
	{
		return si.second.size();
	}

	bool OrderedPtvSet_i::less(const OrderedPtvSet_i& ss) const
	{
		if ( si.second.size() < ss.size() ) return true;
		if ( si.second.size() > ss.size() ) return false;

		for (unsigned int d=0; d< si.second.size(); d++)
		{
			if ( si.second[d] < ss.get_i(d) ) return true;
			if ( si.second[d] > ss.get_i(d) ) return false;
		}

		return si.first.less(ss.get_OrderedPtvSet());

	}

	std::ostream & operator<< ( std::ostream& os, const OrderedPtvSet_i& p)
	{
		cout <<p.get_OrderedPtvSet();
		if (p.size() >= 1)
		{
			os <<",[";
			for (unsigned int i=0; i< p.size()-1; i++)
			{
				os <<p.get_i(i)<<",";
			}
			os <<p.get_i(p.size()-1)<<"]";
		}
		else
		{
			os <<"OrderedPtvSet_i not created properly"<<std::endl;
		}
		return os;
	}

}								 //namespace SyFi
